<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

<!-- 
     This file contains templates for upgrading PhotoML files from
     DTD version 0.09 to version 0.10.

     Copyright © 2005 Brendt Wohlberg <photoml@wohlberg.net>

     This is free software; you can redistribute it and/or modify it 
     under the terms of version 2 of the GNU General Public License 
     at http://www.gnu.org/licenses/gpl-2.0.txt.

     This software is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
     GNU General Public License for more details.
-->

<xsl:output method="xml" indent="yes"
	    doctype-public="-//BW//DTD PhotoML 0.10//EN"
            doctype-system="photo.dtd"/>


<!-- Default template -->
<xsl:template match="*|@*|text()|processing-instruction()|comment()">
  <xsl:copy>
    <xsl:apply-templates select="*|@*|text()|processing-instruction()|comment()"/>
  </xsl:copy>
</xsl:template>


<!-- Handle element name change from image to idximage -->
<xsl:template match="image">
  <idximage>
    <xsl:apply-templates select="@*"/>
  </idximage>
</xsl:template>


<!-- Handle change in location content model -->
<xsl:template match="address[parent::location]">
  <description>
    <xsl:apply-templates select="@*|*|text()|comment()"/>
  </description>
  <xsl:comment> Upgrade warning: address is no longer a valid child of location. The location element may require editing. </xsl:comment>
  <xsl:message>
    <xsl:text>Warning: manual editing of output may be required</xsl:text>
  </xsl:message>
</xsl:template>


<!-- Handle change in handling of empty descendants of defaults elements -->
<xsl:template match="*[ancestor::defaults and not(normalize-space(.)) and count(./*)=0]">
  <xsl:copy-of select="."/>
  <xsl:comment> Upgrade warning: handling of empty descendants of defaults elements has changed. The defaults element may require editing. </xsl:comment>
  <xsl:message>
    <xsl:text>Warning: manual editing of output may be required</xsl:text>
  </xsl:message>
</xsl:template>


</xsl:stylesheet>
