# -*- coding: utf-8 -*-
#
# PhotoFilmStrip - Creates movies out of your pictures.
#
# Copyright (C) 2011 Jens Goepfert
#

import logging
import sys

from photofilmstrip.lib.DestructionManager import DestructionManager


class AppMixin:

    def __init__(self):
        self.InitLogging()

    def InitLogging(self):
        if "-d" in sys.argv:
            lvl = logging.DEBUG
        else:
            lvl = logging.WARNING
        logging.basicConfig(level=lvl,
                            format=self._GetLogFormat(),
                            datefmt='%d.%m.%Y %H:%M:%S',
                            filename=self._GetLogFilename())

    def InitI18N(self):
        from photofilmstrip.action.ActionI18N import ActionI18N
        ActionI18N().Execute()

    def InitGStreamer(self):
        import gi
        gi.require_version('Gst', '1.0')

        from gi.repository import Gst
        Gst.init(None)

    def Start(self):
        self.InitI18N()
        self.InitGStreamer()

        DestructionManager()

        from photofilmstrip.lib.jobimpl.JobManager import JobManager
        JobManager().Init(workerCount=2)
        JobManager().Init("render")

        try:
            return self._OnStart()
        finally:
            DestructionManager().Destroy()

    def _GetLogFormat(self):
        return '%(asctime)s (%(levelname)s) %(name)s: %(message)s'

    def _GetLogFilename(self):
        return None

    def _OnStart(self):
        raise NotImplementedError()
