Minutes from 61st OpenVDB TSC meeting, Aug 4th, 2020, (EDT)

Attendees: *Nick* A., *Jeff* L., *Ken* M.

Additional Attendees: Johannes Meng (Intel), JT Nelson (Blender),
Bruce Chernia (Intel), Peter Cheng (DW), Andre Pradhana (DW)

Regrets: *Peter* C, *Dan* B..

Agenda:

1) Confirm quorum
2) Secretary
3) Forum
4) NanoVDB
5) Repository Structure
6) Makefile
7) Next Meeting

1) Quorum was confirmed.

2) Secretary was Jeff Lait

3) Forum

Questions about computing averages of leaf nodes.  Unclear if the questioner wants it baked in the tree or just computed.  "On load" implies it is to be computed on construction.

Another post is on large VDBs and Out of Core (OOC).  Wants to be able to stream it and unload it.  Ken has in the past written a minimal version that does delayed loading and unloading.  Loads in only the leaf data into a preset pool.

A mistake we've tried to do is make VDB try to do everything.  So we kept putting everything in one structure, so it is not ideal for any application.  Out of core is substandard, and random access is harmed by the out of core.  We're trying to simplify the tree, and reduce dependency.  Ken would like to contribute his streamable read only tree at some point.  Ken will reply to the thread.

4) NanoVDB

Nick and Ken will talk at the OpenSource event where we can talk about it.  This will be an alpha release of NanoVDB.  There is still another platform that might cause tree changes.  This will imply there is a long period where it isn't official.

How can we push to it without a pull request?  Can do development on a fork.  The feature branch on the fork can be done quickly.  And this is then pushed up regularly to master.  How to make it easy for people to push up changes?

AX for example has three repos that are all trying to stay up to date.  Previously we had a private repo, that required a sync to the dneg fork.

Ken can keep the current private repo private.  He can manually send synchronization pull requests by copying over from the private repo to the public.  It is expected development will occur on the private repo and push to the public for the next few months until it transfers fully.  Any PRs to the public repo can be hand-merged by Ken into the private repo to apply.

5) Repository structure.

Proposal to change the structure to allow for different versions to mix together for different submodules.  Requires headers not be off the root directory, so you can -I include submodules from different locations.  Each module can get a subdirectory of its same name to store the C and header files.  This will affect existing tooling.   Doing this before AX and Nano will be good.  We then also end up with a clean source folder.  Build system can ensure that the correct componets are built, so you never include anything from the local repo that is supposed to go from the installation on disk.

This will break existing PRs so we should make sure they are relatively up to date.  The actual change is easy, the implications are harder.

All present vote in favour.

6) Makefile

Jeff reported Houdini's transition to the CMake from the Makefile.  Ideally we support multi-target builds so can build Release and Debug in one configuration.

Should CMAKE_POSTFIX_DEBUG have a _d by default.

Mac seems to be inconsistent with where to put the 7.1.0 decorator - it goes ahead of the library extension rather than after.

We should consider now removing the Makefile.  Unclear how many are using it as it currently doesn't work.  We should raise it at the OpenSource day to see if there is push back.

We are currently letting the Makefile rot.  So we should remove it.

We will put NanoVDB in raw, with both its Makefile and CMake.  We will create a feature branch on Wednesday for NanoVDB.

7) Next Meeting

Tuesday, August 25th 2020. 1pm-2pm EDT
