# OpenVAS Vulnerability Test
# $Id$
# Description: 
# Microsoft Security Bulletin MS06-056
# .NET Framework 2.0 Cross-Site Scripting Vulnerability - CVE-2006-3436 
#
#
# Affected Software: 
#
# .NET Framework 2.0 for the following operating system versions: 
# Microsoft Windows 2000 Service Pack 4
# Microsoft Windows XP Service Pack 1 or Windows XP Service Pack 2
# Microsoft Windows XP Professional x64 Edition
# Microsoft Windows XP Tablet PC Edition
# Microsoft Windows XP Media Center Edition
# Microsoft Windows Server 2003 or Windows Server 2003 Service Pack 1
# Microsoft Windows Server with SP1 for Itanium-based Systems
# Microsoft Windows Server 2003 x64 Edition
# 
# Non-Affected Software:
#
# Microsoft Windows Server 2003 for Itanium-based Systems
# 
# Tested Microsoft Windows Components:
#
# Affected Components:
#
# Microsoft .NET Framework 2.0
#
# Non-Affected Components:
#
# Microsoft .NET Framework 1.0
# Microsoft .NET Framework 1.1 
#
# remote-MS06-056.nasl
#
# Author:
# Christian Eric Edjenguele <christian.edjenguele@owasp.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 and later,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#



if(description)
{
script_id(101006);
script_tag(name:"cvss_base", value:"4.3");
script_tag(name:"risk_factor", value:"Medium");
script_bugtraq_id(20337);
script_cve_id("CVE-2006-3436");
name = "Microsoft Security Bulletin MS06-056";
script_name(name);
 
desc = "
A cross-site scripting vulnerability exists in a server running a vulnerable version of the .Net Framework 2.0 
that could inject a client side script in the user's browser. The script could spoof content, 
disclose information, or take any action that the user could take on the affected web site.





Solution :
Microsoft has released a patch to correct this issue,
you can download it from the following web site:
http://www.microsoft.com/technet/security/Bulletin/MS06-056.mspx
 



Risk factor : Low";

script_description(desc); 

summary = ".NET Framework 2.0 Cross-Site Scripting Vulnerability";

script_summary(summary);

script_category(ACT_ATTACK);

script_copyright("Christian Eric Edjenguele <christian.edjenguele@owasp.org>");
family = "Windows : Microsoft Bulletins";
script_family(family);
script_dependencies("find_service.nes", "remote-detect-MSdotNET-version.nasl");
script_require_ports("Services/www");
script_require_keys("dotNET/version", "dotNet/port");



exit(0);

}


#
# The script code starts here
#

include("revisions-lib.inc");

dotnet = get_kb_item("dotNET/version"); 
port = get_kb_item("dotNet/port");

if(!dotnet)
	exit(0);

else
{
	# Microsoft .NET Framework version 2.0
    	if(revcomp(a:dotnet, b:"2.0.50727.210") == -1){

		# Report 'Microsoft .NET Framework 2.0 Cross-Site Scripting Vulnerability (MS06-056)'
    		report = 'Missing MS06-056 patch, detected Microsoft .Net Framework version: ' + dotnet;
		security_hole(port:port, data:report);
	}
}
