/*###############################################################################
# Linux Management Providers (LMP), Power Management provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_RegisteredPowerManagementProfileAccess.h"

const string InstanceID="OpenDRIM:PowerManagement:1.0.1";

int PowerManagement_OpenDRIM_RegisteredPowerManagementProfile_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int PowerManagement_OpenDRIM_RegisteredPowerManagementProfile_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int PowerManagement_OpenDRIM_RegisteredPowerManagementProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_RegisteredPowerManagementProfile>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	OpenDRIM_RegisteredPowerManagementProfile instance;
	instance.setInstanceID(InstanceID);
	
	if(discriminant=="ei")
		CF_assert(PowerManagement_OpenDRIM_RegisteredPowerManagementProfile_populate(instance,errorMessage));
	
	result.push_back(instance);
	_L_;
	return OK;
}

int PowerManagement_OpenDRIM_RegisteredPowerManagementProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_RegisteredPowerManagementProfile& instance, const char** properties, string& errorMessage) {
	_E_;
	if (instance.InstanceID!=InstanceID)
	{
		errorMessage = "No instance";
		return NOT_FOUND;
	}

	CF_assert(PowerManagement_OpenDRIM_RegisteredPowerManagementProfile_populate(instance,errorMessage));
	_L_;
	return OK;
}

int PowerManagement_OpenDRIM_RegisteredPowerManagementProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredPowerManagementProfile& newInstance, const OpenDRIM_RegisteredPowerManagementProfile& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerManagement_OpenDRIM_RegisteredPowerManagementProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredPowerManagementProfile& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerManagement_OpenDRIM_RegisteredPowerManagementProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredPowerManagementProfile& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerManagement_OpenDRIM_RegisteredPowerManagementProfile_populate(OpenDRIM_RegisteredPowerManagementProfile& instance, string& errorMessage) {
	_E_;
	vector<unsigned short> AdvertiseTypes;

	instance.setRegisteredName("Power State Management");
	instance.setRegisteredVersion("1.0.1");
	instance.setRegisteredOrganization(2);	// DMTF

	AdvertiseTypes.push_back(2);			// Not Advertised
	instance.setAdvertiseTypes(AdvertiseTypes);
	_L_;
	return OK;
}

