/* !!! WARNING WARNING WARNING WARNING WARNING WARNING WARNING !!!
 *
 * THIS FILE IS AUTOMATICALLY GENERATED BY 'generator.pl'.
 *
 * Any changes you make to this file may be overwritten.
 */

/* OCaml bindings for libvirt.
 * (C) Copyright 2007-2008 Richard W.M. Jones, Red Hat Inc.
 * http://libvirt.org/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version,
 * with the OCaml linking exception described in ../COPYING.LIB.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libvirt/libvirt.h>
#include <libvirt/virterror.h>

#include <caml/config.h>
#include <caml/alloc.h>
#include <caml/callback.h>
#include <caml/custom.h>
#include <caml/fail.h>
#include <caml/memory.h>
#include <caml/misc.h>
#include <caml/mlvalues.h>
#include <caml/signals.h>

#include "libvirt_c_prologue.c"

#include "libvirt_c_oneoffs.c"

/* Automatically generated binding for virConnectClose.
 * In generator.pl this function has signature "conn : free".
 */

CAMLprim value
ocaml_libvirt_connect_close (value connv)
{
  CAMLparam1 (connv);

  virConnectPtr conn = Connect_val (connv);
  int r;

  NONBLOCKING (r = virConnectClose (conn));
  CHECK_ERROR (r == -1, conn, "virConnectClose");

  /* So that we don't double-free in the finalizer: */
  Connect_val (connv) = NULL;

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virConnectGetHostname.
 * In generator.pl this function has signature "conn : string".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRCONNECTGETHOSTNAME
extern char *virConnectGetHostname (virConnectPtr conn) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_connect_get_hostname (value connv)
{
  CAMLparam1 (connv);
#ifndef HAVE_VIRCONNECTGETHOSTNAME
  /* Symbol virConnectGetHostname not found at compile time. */
  not_supported ("virConnectGetHostname");
  CAMLnoreturn;
#else
  /* Check that the symbol virConnectGetHostname
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virConnectGetHostname);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  char *r;

  NONBLOCKING (r = virConnectGetHostname (conn));
  CHECK_ERROR (!r, conn, "virConnectGetHostname");

  rv = caml_copy_string (r);
  free (r);
  CAMLreturn (rv);
#endif
}

/* Automatically generated binding for virConnectGetURI.
 * In generator.pl this function has signature "conn : string".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRCONNECTGETURI
extern char *virConnectGetURI (virConnectPtr conn) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_connect_get_uri (value connv)
{
  CAMLparam1 (connv);
#ifndef HAVE_VIRCONNECTGETURI
  /* Symbol virConnectGetURI not found at compile time. */
  not_supported ("virConnectGetURI");
  CAMLnoreturn;
#else
  /* Check that the symbol virConnectGetURI
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virConnectGetURI);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  char *r;

  NONBLOCKING (r = virConnectGetURI (conn));
  CHECK_ERROR (!r, conn, "virConnectGetURI");

  rv = caml_copy_string (r);
  free (r);
  CAMLreturn (rv);
#endif
}

/* Automatically generated binding for virConnectGetType.
 * In generator.pl this function has signature "conn : static string".
 */

CAMLprim value
ocaml_libvirt_connect_get_type (value connv)
{
  CAMLparam1 (connv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  const char *r;

  NONBLOCKING (r = virConnectGetType (conn));
  CHECK_ERROR (!r, conn, "virConnectGetType");

  rv = caml_copy_string (r);
  CAMLreturn (rv);
}

/* Automatically generated binding for virConnectNumOfDomains.
 * In generator.pl this function has signature "conn : int".
 */

CAMLprim value
ocaml_libvirt_connect_num_of_domains (value connv)
{
  CAMLparam1 (connv);

  virConnectPtr conn = Connect_val (connv);
  int r;

  NONBLOCKING (r = virConnectNumOfDomains (conn));
  CHECK_ERROR (r == -1, conn, "virConnectNumOfDomains");

  CAMLreturn (Val_int (r));
}

/* Automatically generated binding for virConnectListDomains.
 * In generator.pl this function has signature "conn, int : int array".
 */

CAMLprim value
ocaml_libvirt_connect_list_domains (value connv, value iv)
{
  CAMLparam2 (connv, iv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  int i = Int_val (iv);
  int ids[i], r;

  /* Some libvirt List* functions still throw exceptions if i == 0,
   * so catch that and return an empty array directly.  This changes
   * the semantics slightly (masking other failures) but it's
   * unlikely anyone will care.  RWMJ 2008/06/10
   */
  if (i == 0) {
    rv = caml_alloc (0, 0);
    CAMLreturn (rv);
  }

  NONBLOCKING (r = virConnectListDomains (conn, ids, i));
  CHECK_ERROR (r == -1, conn, "virConnectListDomains");

  rv = caml_alloc (r, 0);
  for (i = 0; i < r; ++i)
    Store_field (rv, i, Val_int (ids[i]));

  CAMLreturn (rv);
}

/* Automatically generated binding for virConnectNumOfDefinedDomains.
 * In generator.pl this function has signature "conn : int".
 */

CAMLprim value
ocaml_libvirt_connect_num_of_defined_domains (value connv)
{
  CAMLparam1 (connv);

  virConnectPtr conn = Connect_val (connv);
  int r;

  NONBLOCKING (r = virConnectNumOfDefinedDomains (conn));
  CHECK_ERROR (r == -1, conn, "virConnectNumOfDefinedDomains");

  CAMLreturn (Val_int (r));
}

/* Automatically generated binding for virConnectListDefinedDomains.
 * In generator.pl this function has signature "conn, int : string array".
 */

CAMLprim value
ocaml_libvirt_connect_list_defined_domains (value connv, value iv)
{
  CAMLparam2 (connv, iv);

  CAMLlocal2 (rv, strv);
  virConnectPtr conn = Connect_val (connv);
  int i = Int_val (iv);
  char *names[i];
  int r;

  /* Some libvirt List* functions still throw exceptions if i == 0,
   * so catch that and return an empty array directly.  This changes
   * the semantics slightly (masking other failures) but it's
   * unlikely anyone will care.  RWMJ 2008/06/10
   */
  if (i == 0) {
    rv = caml_alloc (0, 0);
    CAMLreturn (rv);
  }

  NONBLOCKING (r = virConnectListDefinedDomains (conn, names, i));
  CHECK_ERROR (r == -1, conn, "virConnectListDefinedDomains");

  rv = caml_alloc (r, 0);
  for (i = 0; i < r; ++i) {
    strv = caml_copy_string (names[i]);
    Store_field (rv, i, strv);
    free (names[i]);
  }

  CAMLreturn (rv);
}

/* Automatically generated binding for virConnectNumOfNetworks.
 * In generator.pl this function has signature "conn : int".
 */

CAMLprim value
ocaml_libvirt_connect_num_of_networks (value connv)
{
  CAMLparam1 (connv);

  virConnectPtr conn = Connect_val (connv);
  int r;

  NONBLOCKING (r = virConnectNumOfNetworks (conn));
  CHECK_ERROR (r == -1, conn, "virConnectNumOfNetworks");

  CAMLreturn (Val_int (r));
}

/* Automatically generated binding for virConnectListNetworks.
 * In generator.pl this function has signature "conn, int : string array".
 */

CAMLprim value
ocaml_libvirt_connect_list_networks (value connv, value iv)
{
  CAMLparam2 (connv, iv);

  CAMLlocal2 (rv, strv);
  virConnectPtr conn = Connect_val (connv);
  int i = Int_val (iv);
  char *names[i];
  int r;

  /* Some libvirt List* functions still throw exceptions if i == 0,
   * so catch that and return an empty array directly.  This changes
   * the semantics slightly (masking other failures) but it's
   * unlikely anyone will care.  RWMJ 2008/06/10
   */
  if (i == 0) {
    rv = caml_alloc (0, 0);
    CAMLreturn (rv);
  }

  NONBLOCKING (r = virConnectListNetworks (conn, names, i));
  CHECK_ERROR (r == -1, conn, "virConnectListNetworks");

  rv = caml_alloc (r, 0);
  for (i = 0; i < r; ++i) {
    strv = caml_copy_string (names[i]);
    Store_field (rv, i, strv);
    free (names[i]);
  }

  CAMLreturn (rv);
}

/* Automatically generated binding for virConnectNumOfDefinedNetworks.
 * In generator.pl this function has signature "conn : int".
 */

CAMLprim value
ocaml_libvirt_connect_num_of_defined_networks (value connv)
{
  CAMLparam1 (connv);

  virConnectPtr conn = Connect_val (connv);
  int r;

  NONBLOCKING (r = virConnectNumOfDefinedNetworks (conn));
  CHECK_ERROR (r == -1, conn, "virConnectNumOfDefinedNetworks");

  CAMLreturn (Val_int (r));
}

/* Automatically generated binding for virConnectListDefinedNetworks.
 * In generator.pl this function has signature "conn, int : string array".
 */

CAMLprim value
ocaml_libvirt_connect_list_defined_networks (value connv, value iv)
{
  CAMLparam2 (connv, iv);

  CAMLlocal2 (rv, strv);
  virConnectPtr conn = Connect_val (connv);
  int i = Int_val (iv);
  char *names[i];
  int r;

  /* Some libvirt List* functions still throw exceptions if i == 0,
   * so catch that and return an empty array directly.  This changes
   * the semantics slightly (masking other failures) but it's
   * unlikely anyone will care.  RWMJ 2008/06/10
   */
  if (i == 0) {
    rv = caml_alloc (0, 0);
    CAMLreturn (rv);
  }

  NONBLOCKING (r = virConnectListDefinedNetworks (conn, names, i));
  CHECK_ERROR (r == -1, conn, "virConnectListDefinedNetworks");

  rv = caml_alloc (r, 0);
  for (i = 0; i < r; ++i) {
    strv = caml_copy_string (names[i]);
    Store_field (rv, i, strv);
    free (names[i]);
  }

  CAMLreturn (rv);
}

/* Automatically generated binding for virConnectNumOfStoragePools.
 * In generator.pl this function has signature "conn : int".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRCONNECTNUMOFSTORAGEPOOLS
extern int virConnectNumOfStoragePools (virConnectPtr conn) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_connect_num_of_storage_pools (value connv)
{
  CAMLparam1 (connv);
#ifndef HAVE_VIRCONNECTNUMOFSTORAGEPOOLS
  /* Symbol virConnectNumOfStoragePools not found at compile time. */
  not_supported ("virConnectNumOfStoragePools");
  CAMLnoreturn;
#else
  /* Check that the symbol virConnectNumOfStoragePools
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virConnectNumOfStoragePools);

  virConnectPtr conn = Connect_val (connv);
  int r;

  NONBLOCKING (r = virConnectNumOfStoragePools (conn));
  CHECK_ERROR (r == -1, conn, "virConnectNumOfStoragePools");

  CAMLreturn (Val_int (r));
#endif
}

/* Automatically generated binding for virConnectListStoragePools.
 * In generator.pl this function has signature "conn, int : string array".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRCONNECTLISTSTORAGEPOOLS
extern int virConnectListStoragePools (virConnectPtr conn, char **const names, int maxnames) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_connect_list_storage_pools (value connv, value iv)
{
  CAMLparam2 (connv, iv);
#ifndef HAVE_VIRCONNECTLISTSTORAGEPOOLS
  /* Symbol virConnectListStoragePools not found at compile time. */
  not_supported ("virConnectListStoragePools");
  CAMLnoreturn;
#else
  /* Check that the symbol virConnectListStoragePools
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virConnectListStoragePools);

  CAMLlocal2 (rv, strv);
  virConnectPtr conn = Connect_val (connv);
  int i = Int_val (iv);
  char *names[i];
  int r;

  /* Some libvirt List* functions still throw exceptions if i == 0,
   * so catch that and return an empty array directly.  This changes
   * the semantics slightly (masking other failures) but it's
   * unlikely anyone will care.  RWMJ 2008/06/10
   */
  if (i == 0) {
    rv = caml_alloc (0, 0);
    CAMLreturn (rv);
  }

  NONBLOCKING (r = virConnectListStoragePools (conn, names, i));
  CHECK_ERROR (r == -1, conn, "virConnectListStoragePools");

  rv = caml_alloc (r, 0);
  for (i = 0; i < r; ++i) {
    strv = caml_copy_string (names[i]);
    Store_field (rv, i, strv);
    free (names[i]);
  }

  CAMLreturn (rv);
#endif
}

/* Automatically generated binding for virConnectNumOfDefinedStoragePools.
 * In generator.pl this function has signature "conn : int".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRCONNECTNUMOFDEFINEDSTORAGEPOOLS
extern int virConnectNumOfDefinedStoragePools (virConnectPtr conn) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_connect_num_of_defined_storage_pools (value connv)
{
  CAMLparam1 (connv);
#ifndef HAVE_VIRCONNECTNUMOFDEFINEDSTORAGEPOOLS
  /* Symbol virConnectNumOfDefinedStoragePools not found at compile time. */
  not_supported ("virConnectNumOfDefinedStoragePools");
  CAMLnoreturn;
#else
  /* Check that the symbol virConnectNumOfDefinedStoragePools
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virConnectNumOfDefinedStoragePools);

  virConnectPtr conn = Connect_val (connv);
  int r;

  NONBLOCKING (r = virConnectNumOfDefinedStoragePools (conn));
  CHECK_ERROR (r == -1, conn, "virConnectNumOfDefinedStoragePools");

  CAMLreturn (Val_int (r));
#endif
}

/* Automatically generated binding for virConnectListDefinedStoragePools.
 * In generator.pl this function has signature "conn, int : string array".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRCONNECTLISTDEFINEDSTORAGEPOOLS
extern int virConnectListDefinedStoragePools (virConnectPtr conn, char **const names, int maxnames) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_connect_list_defined_storage_pools (value connv, value iv)
{
  CAMLparam2 (connv, iv);
#ifndef HAVE_VIRCONNECTLISTDEFINEDSTORAGEPOOLS
  /* Symbol virConnectListDefinedStoragePools not found at compile time. */
  not_supported ("virConnectListDefinedStoragePools");
  CAMLnoreturn;
#else
  /* Check that the symbol virConnectListDefinedStoragePools
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virConnectListDefinedStoragePools);

  CAMLlocal2 (rv, strv);
  virConnectPtr conn = Connect_val (connv);
  int i = Int_val (iv);
  char *names[i];
  int r;

  /* Some libvirt List* functions still throw exceptions if i == 0,
   * so catch that and return an empty array directly.  This changes
   * the semantics slightly (masking other failures) but it's
   * unlikely anyone will care.  RWMJ 2008/06/10
   */
  if (i == 0) {
    rv = caml_alloc (0, 0);
    CAMLreturn (rv);
  }

  NONBLOCKING (r = virConnectListDefinedStoragePools (conn, names, i));
  CHECK_ERROR (r == -1, conn, "virConnectListDefinedStoragePools");

  rv = caml_alloc (r, 0);
  for (i = 0; i < r; ++i) {
    strv = caml_copy_string (names[i]);
    Store_field (rv, i, strv);
    free (names[i]);
  }

  CAMLreturn (rv);
#endif
}

/* Automatically generated binding for virConnectGetCapabilities.
 * In generator.pl this function has signature "conn : string".
 */

CAMLprim value
ocaml_libvirt_connect_get_capabilities (value connv)
{
  CAMLparam1 (connv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  char *r;

  NONBLOCKING (r = virConnectGetCapabilities (conn));
  CHECK_ERROR (!r, conn, "virConnectGetCapabilities");

  rv = caml_copy_string (r);
  free (r);
  CAMLreturn (rv);
}

/* Automatically generated binding for virDomainCreateLinux.
 * In generator.pl this function has signature "conn, string, 0U : dom".
 */

CAMLprim value
ocaml_libvirt_domain_create_linux (value connv, value strv)
{
  CAMLparam2 (connv, strv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  char *str = String_val (strv);
  virDomainPtr r;

  NONBLOCKING (r = virDomainCreateLinux (conn, str, 0));
  CHECK_ERROR (!r, conn, "virDomainCreateLinux");

  rv = Val_domain (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virDomainFree.
 * In generator.pl this function has signature "dom : free".
 */

CAMLprim value
ocaml_libvirt_domain_free (value domv)
{
  CAMLparam1 (domv);

  virDomainPtr dom = Domain_val (domv);
  virConnectPtr conn = Connect_domv (domv);
  int r;

  NONBLOCKING (r = virDomainFree (dom));
  CHECK_ERROR (r == -1, conn, "virDomainFree");

  /* So that we don't double-free in the finalizer: */
  Domain_val (domv) = NULL;

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virDomainDestroy.
 * In generator.pl this function has signature "dom : free".
 */

CAMLprim value
ocaml_libvirt_domain_destroy (value domv)
{
  CAMLparam1 (domv);

  virDomainPtr dom = Domain_val (domv);
  virConnectPtr conn = Connect_domv (domv);
  int r;

  NONBLOCKING (r = virDomainDestroy (dom));
  CHECK_ERROR (r == -1, conn, "virDomainDestroy");

  /* So that we don't double-free in the finalizer: */
  Domain_val (domv) = NULL;

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virDomainLookupByName.
 * In generator.pl this function has signature "conn, string : dom".
 */

CAMLprim value
ocaml_libvirt_domain_lookup_by_name (value connv, value strv)
{
  CAMLparam2 (connv, strv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  char *str = String_val (strv);
  virDomainPtr r;

  NONBLOCKING (r = virDomainLookupByName (conn, str));
  CHECK_ERROR (!r, conn, "virDomainLookupByName");

  rv = Val_domain (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virDomainLookupByID.
 * In generator.pl this function has signature "conn, int : dom".
 */

CAMLprim value
ocaml_libvirt_domain_lookup_by_id (value connv, value iv)
{
  CAMLparam2 (connv, iv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  int i = Int_val (iv);
  virDomainPtr r;

  NONBLOCKING (r = virDomainLookupByID (conn, i));
  CHECK_ERROR (!r, conn, "virDomainLookupByID");

  rv = Val_domain (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virDomainLookupByUUID.
 * In generator.pl this function has signature "conn, uuid : dom".
 */

CAMLprim value
ocaml_libvirt_domain_lookup_by_uuid (value connv, value uuidv)
{
  CAMLparam2 (connv, uuidv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  unsigned char *uuid = (unsigned char *) String_val (uuidv);
  virDomainPtr r;

  NONBLOCKING (r = virDomainLookupByUUID (conn, uuid));
  CHECK_ERROR (!r, conn, "virDomainLookupByUUID");

  rv = Val_domain (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virDomainLookupByUUIDString.
 * In generator.pl this function has signature "conn, string : dom".
 */

CAMLprim value
ocaml_libvirt_domain_lookup_by_uuid_string (value connv, value strv)
{
  CAMLparam2 (connv, strv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  char *str = String_val (strv);
  virDomainPtr r;

  NONBLOCKING (r = virDomainLookupByUUIDString (conn, str));
  CHECK_ERROR (!r, conn, "virDomainLookupByUUIDString");

  rv = Val_domain (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virDomainGetName.
 * In generator.pl this function has signature "dom : static string".
 */

CAMLprim value
ocaml_libvirt_domain_get_name (value domv)
{
  CAMLparam1 (domv);

  CAMLlocal1 (rv);
  virDomainPtr dom = Domain_val (domv);
  virConnectPtr conn = Connect_domv (domv);
  const char *r;

  NONBLOCKING (r = virDomainGetName (dom));
  CHECK_ERROR (!r, conn, "virDomainGetName");

  rv = caml_copy_string (r);
  CAMLreturn (rv);
}

/* Automatically generated binding for virDomainGetOSType.
 * In generator.pl this function has signature "dom : string".
 */

CAMLprim value
ocaml_libvirt_domain_get_os_type (value domv)
{
  CAMLparam1 (domv);

  CAMLlocal1 (rv);
  virDomainPtr dom = Domain_val (domv);
  virConnectPtr conn = Connect_domv (domv);
  char *r;

  NONBLOCKING (r = virDomainGetOSType (dom));
  CHECK_ERROR (!r, conn, "virDomainGetOSType");

  rv = caml_copy_string (r);
  free (r);
  CAMLreturn (rv);
}

/* Automatically generated binding for virDomainGetXMLDesc.
 * In generator.pl this function has signature "dom, 0 : string".
 */

CAMLprim value
ocaml_libvirt_domain_get_xml_desc (value domv)
{
  CAMLparam1 (domv);

  CAMLlocal1 (rv);
  virDomainPtr dom = Domain_val (domv);
  virConnectPtr conn = Connect_domv (domv);
  char *r;

  NONBLOCKING (r = virDomainGetXMLDesc (dom, 0));
  CHECK_ERROR (!r, conn, "virDomainGetXMLDesc");

  rv = caml_copy_string (r);
  free (r);
  CAMLreturn (rv);
}

/* Automatically generated binding for virDomainGetUUID.
 * In generator.pl this function has signature "dom : uuid".
 */

CAMLprim value
ocaml_libvirt_domain_get_uuid (value domv)
{
  CAMLparam1 (domv);

  CAMLlocal1 (rv);
  virDomainPtr dom = Domain_val (domv);
  virConnectPtr conn = Connect_domv (domv);
  unsigned char uuid[VIR_UUID_BUFLEN];
  int r;

  NONBLOCKING (r = virDomainGetUUID (dom, uuid));
  CHECK_ERROR (r == -1, conn, "virDomainGetUUID");

  /* UUIDs are byte arrays with a fixed length. */
  rv = caml_alloc_string (VIR_UUID_BUFLEN);
  memcpy (String_val (rv), uuid, VIR_UUID_BUFLEN);
  CAMLreturn (rv);
}

/* Automatically generated binding for virDomainGetUUIDString.
 * In generator.pl this function has signature "dom : uuid string".
 */

CAMLprim value
ocaml_libvirt_domain_get_uuid_string (value domv)
{
  CAMLparam1 (domv);

  CAMLlocal1 (rv);
  virDomainPtr dom = Domain_val (domv);
  virConnectPtr conn = Connect_domv (domv);
  char uuid[VIR_UUID_STRING_BUFLEN];
  int r;

  NONBLOCKING (r = virDomainGetUUIDString (dom, uuid));
  CHECK_ERROR (r == -1, conn, "virDomainGetUUIDString");

  rv = caml_copy_string (uuid);
  CAMLreturn (rv);
}

/* Automatically generated binding for virDomainGetMaxVcpus.
 * In generator.pl this function has signature "dom : int".
 */

CAMLprim value
ocaml_libvirt_domain_get_max_vcpus (value domv)
{
  CAMLparam1 (domv);

  virDomainPtr dom = Domain_val (domv);
  virConnectPtr conn = Connect_domv (domv);
  int r;

  NONBLOCKING (r = virDomainGetMaxVcpus (dom));
  CHECK_ERROR (r == -1, conn, "virDomainGetMaxVcpus");

  CAMLreturn (Val_int (r));
}

/* Automatically generated binding for virDomainSave.
 * In generator.pl this function has signature "dom, string : unit".
 */

CAMLprim value
ocaml_libvirt_domain_save (value domv, value strv)
{
  CAMLparam2 (domv, strv);

  virDomainPtr dom = Domain_val (domv);
  virConnectPtr conn = Connect_domv (domv);
  char *str = String_val (strv);
  int r;

  NONBLOCKING (r = virDomainSave (dom, str));
  CHECK_ERROR (r == -1, conn, "virDomainSave");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virDomainRestore.
 * In generator.pl this function has signature "conn, string : unit".
 */

CAMLprim value
ocaml_libvirt_domain_restore (value connv, value strv)
{
  CAMLparam2 (connv, strv);

  virConnectPtr conn = Connect_val (connv);
  char *str = String_val (strv);
  int r;

  NONBLOCKING (r = virDomainRestore (conn, str));
  CHECK_ERROR (r == -1, conn, "virDomainRestore");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virDomainCoreDump.
 * In generator.pl this function has signature "dom, string, 0 : unit".
 */

CAMLprim value
ocaml_libvirt_domain_core_dump (value domv, value strv)
{
  CAMLparam2 (domv, strv);

  CAMLlocal1 (rv);
  virDomainPtr dom = Domain_val (domv);
  virConnectPtr conn = Connect_domv (domv);
  char *str = String_val (strv);
  int r;

  NONBLOCKING (r = virDomainCoreDump (dom, str, 0));
  CHECK_ERROR (!r, conn, "virDomainCoreDump");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virDomainSuspend.
 * In generator.pl this function has signature "dom : unit".
 */

CAMLprim value
ocaml_libvirt_domain_suspend (value domv)
{
  CAMLparam1 (domv);

  virDomainPtr dom = Domain_val (domv);
  virConnectPtr conn = Connect_domv (domv);
  int r;

  NONBLOCKING (r = virDomainSuspend (dom));
  CHECK_ERROR (r == -1, conn, "virDomainSuspend");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virDomainResume.
 * In generator.pl this function has signature "dom : unit".
 */

CAMLprim value
ocaml_libvirt_domain_resume (value domv)
{
  CAMLparam1 (domv);

  virDomainPtr dom = Domain_val (domv);
  virConnectPtr conn = Connect_domv (domv);
  int r;

  NONBLOCKING (r = virDomainResume (dom));
  CHECK_ERROR (r == -1, conn, "virDomainResume");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virDomainShutdown.
 * In generator.pl this function has signature "dom : unit".
 */

CAMLprim value
ocaml_libvirt_domain_shutdown (value domv)
{
  CAMLparam1 (domv);

  virDomainPtr dom = Domain_val (domv);
  virConnectPtr conn = Connect_domv (domv);
  int r;

  NONBLOCKING (r = virDomainShutdown (dom));
  CHECK_ERROR (r == -1, conn, "virDomainShutdown");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virDomainReboot.
 * In generator.pl this function has signature "dom, 0 : unit".
 */

CAMLprim value
ocaml_libvirt_domain_reboot (value domv)
{
  CAMLparam1 (domv);

  virDomainPtr dom = Domain_val (domv);
  virConnectPtr conn = Connect_domv (domv);
  int r;

  NONBLOCKING (r = virDomainReboot (dom, 0));
  CHECK_ERROR (r == -1, conn, "virDomainReboot");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virDomainDefineXML.
 * In generator.pl this function has signature "conn, string : dom".
 */

CAMLprim value
ocaml_libvirt_domain_define_xml (value connv, value strv)
{
  CAMLparam2 (connv, strv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  char *str = String_val (strv);
  virDomainPtr r;

  NONBLOCKING (r = virDomainDefineXML (conn, str));
  CHECK_ERROR (!r, conn, "virDomainDefineXML");

  rv = Val_domain (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virDomainUndefine.
 * In generator.pl this function has signature "dom : unit".
 */

CAMLprim value
ocaml_libvirt_domain_undefine (value domv)
{
  CAMLparam1 (domv);

  virDomainPtr dom = Domain_val (domv);
  virConnectPtr conn = Connect_domv (domv);
  int r;

  NONBLOCKING (r = virDomainUndefine (dom));
  CHECK_ERROR (r == -1, conn, "virDomainUndefine");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virDomainCreate.
 * In generator.pl this function has signature "dom : unit".
 */

CAMLprim value
ocaml_libvirt_domain_create (value domv)
{
  CAMLparam1 (domv);

  virDomainPtr dom = Domain_val (domv);
  virConnectPtr conn = Connect_domv (domv);
  int r;

  NONBLOCKING (r = virDomainCreate (dom));
  CHECK_ERROR (r == -1, conn, "virDomainCreate");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virDomainAttachDevice.
 * In generator.pl this function has signature "dom, string : unit".
 */

CAMLprim value
ocaml_libvirt_domain_attach_device (value domv, value strv)
{
  CAMLparam2 (domv, strv);

  virDomainPtr dom = Domain_val (domv);
  virConnectPtr conn = Connect_domv (domv);
  char *str = String_val (strv);
  int r;

  NONBLOCKING (r = virDomainAttachDevice (dom, str));
  CHECK_ERROR (r == -1, conn, "virDomainAttachDevice");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virDomainDetachDevice.
 * In generator.pl this function has signature "dom, string : unit".
 */

CAMLprim value
ocaml_libvirt_domain_detach_device (value domv, value strv)
{
  CAMLparam2 (domv, strv);

  virDomainPtr dom = Domain_val (domv);
  virConnectPtr conn = Connect_domv (domv);
  char *str = String_val (strv);
  int r;

  NONBLOCKING (r = virDomainDetachDevice (dom, str));
  CHECK_ERROR (r == -1, conn, "virDomainDetachDevice");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virDomainGetAutostart.
 * In generator.pl this function has signature "dom : bool".
 */

CAMLprim value
ocaml_libvirt_domain_get_autostart (value domv)
{
  CAMLparam1 (domv);

  virDomainPtr dom = Domain_val (domv);
  virConnectPtr conn = Connect_domv (domv);
  int r, b;

  NONBLOCKING (r = virDomainGetAutostart (dom, &b));
  CHECK_ERROR (r == -1, conn, "virDomainGetAutostart");

  CAMLreturn (b ? Val_true : Val_false);
}

/* Automatically generated binding for virDomainSetAutostart.
 * In generator.pl this function has signature "dom, bool : unit".
 */

CAMLprim value
ocaml_libvirt_domain_set_autostart (value domv, value bv)
{
  CAMLparam2 (domv, bv);

  virDomainPtr dom = Domain_val (domv);
  virConnectPtr conn = Connect_domv (domv);
  int r, b;

  b = bv == Val_true ? 1 : 0;

  NONBLOCKING (r = virDomainSetAutostart (dom, b));
  CHECK_ERROR (r == -1, conn, "virDomainSetAutostart");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virNetworkFree.
 * In generator.pl this function has signature "net : free".
 */

CAMLprim value
ocaml_libvirt_network_free (value netv)
{
  CAMLparam1 (netv);

  virNetworkPtr net = Network_val (netv);
  virConnectPtr conn = Connect_netv (netv);
  int r;

  NONBLOCKING (r = virNetworkFree (net));
  CHECK_ERROR (r == -1, conn, "virNetworkFree");

  /* So that we don't double-free in the finalizer: */
  Network_val (netv) = NULL;

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virNetworkDestroy.
 * In generator.pl this function has signature "net : free".
 */

CAMLprim value
ocaml_libvirt_network_destroy (value netv)
{
  CAMLparam1 (netv);

  virNetworkPtr net = Network_val (netv);
  virConnectPtr conn = Connect_netv (netv);
  int r;

  NONBLOCKING (r = virNetworkDestroy (net));
  CHECK_ERROR (r == -1, conn, "virNetworkDestroy");

  /* So that we don't double-free in the finalizer: */
  Network_val (netv) = NULL;

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virNetworkLookupByName.
 * In generator.pl this function has signature "conn, string : net".
 */

CAMLprim value
ocaml_libvirt_network_lookup_by_name (value connv, value strv)
{
  CAMLparam2 (connv, strv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  char *str = String_val (strv);
  virNetworkPtr r;

  NONBLOCKING (r = virNetworkLookupByName (conn, str));
  CHECK_ERROR (!r, conn, "virNetworkLookupByName");

  rv = Val_network (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virNetworkLookupByUUID.
 * In generator.pl this function has signature "conn, uuid : net".
 */

CAMLprim value
ocaml_libvirt_network_lookup_by_uuid (value connv, value uuidv)
{
  CAMLparam2 (connv, uuidv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  unsigned char *uuid = (unsigned char *) String_val (uuidv);
  virNetworkPtr r;

  NONBLOCKING (r = virNetworkLookupByUUID (conn, uuid));
  CHECK_ERROR (!r, conn, "virNetworkLookupByUUID");

  rv = Val_network (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virNetworkLookupByUUIDString.
 * In generator.pl this function has signature "conn, string : net".
 */

CAMLprim value
ocaml_libvirt_network_lookup_by_uuid_string (value connv, value strv)
{
  CAMLparam2 (connv, strv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  char *str = String_val (strv);
  virNetworkPtr r;

  NONBLOCKING (r = virNetworkLookupByUUIDString (conn, str));
  CHECK_ERROR (!r, conn, "virNetworkLookupByUUIDString");

  rv = Val_network (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virNetworkGetName.
 * In generator.pl this function has signature "net : static string".
 */

CAMLprim value
ocaml_libvirt_network_get_name (value netv)
{
  CAMLparam1 (netv);

  CAMLlocal1 (rv);
  virNetworkPtr net = Network_val (netv);
  virConnectPtr conn = Connect_netv (netv);
  const char *r;

  NONBLOCKING (r = virNetworkGetName (net));
  CHECK_ERROR (!r, conn, "virNetworkGetName");

  rv = caml_copy_string (r);
  CAMLreturn (rv);
}

/* Automatically generated binding for virNetworkGetXMLDesc.
 * In generator.pl this function has signature "net, 0 : string".
 */

CAMLprim value
ocaml_libvirt_network_get_xml_desc (value netv)
{
  CAMLparam1 (netv);

  CAMLlocal1 (rv);
  virNetworkPtr net = Network_val (netv);
  virConnectPtr conn = Connect_netv (netv);
  char *r;

  NONBLOCKING (r = virNetworkGetXMLDesc (net, 0));
  CHECK_ERROR (!r, conn, "virNetworkGetXMLDesc");

  rv = caml_copy_string (r);
  free (r);
  CAMLreturn (rv);
}

/* Automatically generated binding for virNetworkGetBridgeName.
 * In generator.pl this function has signature "net : string".
 */

CAMLprim value
ocaml_libvirt_network_get_bridge_name (value netv)
{
  CAMLparam1 (netv);

  CAMLlocal1 (rv);
  virNetworkPtr net = Network_val (netv);
  virConnectPtr conn = Connect_netv (netv);
  char *r;

  NONBLOCKING (r = virNetworkGetBridgeName (net));
  CHECK_ERROR (!r, conn, "virNetworkGetBridgeName");

  rv = caml_copy_string (r);
  free (r);
  CAMLreturn (rv);
}

/* Automatically generated binding for virNetworkGetUUID.
 * In generator.pl this function has signature "net : uuid".
 */

CAMLprim value
ocaml_libvirt_network_get_uuid (value netv)
{
  CAMLparam1 (netv);

  CAMLlocal1 (rv);
  virNetworkPtr net = Network_val (netv);
  virConnectPtr conn = Connect_netv (netv);
  unsigned char uuid[VIR_UUID_BUFLEN];
  int r;

  NONBLOCKING (r = virNetworkGetUUID (net, uuid));
  CHECK_ERROR (r == -1, conn, "virNetworkGetUUID");

  /* UUIDs are byte arrays with a fixed length. */
  rv = caml_alloc_string (VIR_UUID_BUFLEN);
  memcpy (String_val (rv), uuid, VIR_UUID_BUFLEN);
  CAMLreturn (rv);
}

/* Automatically generated binding for virNetworkGetUUIDString.
 * In generator.pl this function has signature "net : uuid string".
 */

CAMLprim value
ocaml_libvirt_network_get_uuid_string (value netv)
{
  CAMLparam1 (netv);

  CAMLlocal1 (rv);
  virNetworkPtr net = Network_val (netv);
  virConnectPtr conn = Connect_netv (netv);
  char uuid[VIR_UUID_STRING_BUFLEN];
  int r;

  NONBLOCKING (r = virNetworkGetUUIDString (net, uuid));
  CHECK_ERROR (r == -1, conn, "virNetworkGetUUIDString");

  rv = caml_copy_string (uuid);
  CAMLreturn (rv);
}

/* Automatically generated binding for virNetworkUndefine.
 * In generator.pl this function has signature "net : unit".
 */

CAMLprim value
ocaml_libvirt_network_undefine (value netv)
{
  CAMLparam1 (netv);

  virNetworkPtr net = Network_val (netv);
  virConnectPtr conn = Connect_netv (netv);
  int r;

  NONBLOCKING (r = virNetworkUndefine (net));
  CHECK_ERROR (r == -1, conn, "virNetworkUndefine");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virNetworkCreateXML.
 * In generator.pl this function has signature "conn, string : net".
 */

CAMLprim value
ocaml_libvirt_network_create_xml (value connv, value strv)
{
  CAMLparam2 (connv, strv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  char *str = String_val (strv);
  virNetworkPtr r;

  NONBLOCKING (r = virNetworkCreateXML (conn, str));
  CHECK_ERROR (!r, conn, "virNetworkCreateXML");

  rv = Val_network (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virNetworkDefineXML.
 * In generator.pl this function has signature "conn, string : net".
 */

CAMLprim value
ocaml_libvirt_network_define_xml (value connv, value strv)
{
  CAMLparam2 (connv, strv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  char *str = String_val (strv);
  virNetworkPtr r;

  NONBLOCKING (r = virNetworkDefineXML (conn, str));
  CHECK_ERROR (!r, conn, "virNetworkDefineXML");

  rv = Val_network (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virNetworkCreate.
 * In generator.pl this function has signature "net : unit".
 */

CAMLprim value
ocaml_libvirt_network_create (value netv)
{
  CAMLparam1 (netv);

  virNetworkPtr net = Network_val (netv);
  virConnectPtr conn = Connect_netv (netv);
  int r;

  NONBLOCKING (r = virNetworkCreate (net));
  CHECK_ERROR (r == -1, conn, "virNetworkCreate");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virNetworkGetAutostart.
 * In generator.pl this function has signature "net : bool".
 */

CAMLprim value
ocaml_libvirt_network_get_autostart (value netv)
{
  CAMLparam1 (netv);

  virNetworkPtr net = Network_val (netv);
  virConnectPtr conn = Connect_netv (netv);
  int r, b;

  NONBLOCKING (r = virNetworkGetAutostart (net, &b));
  CHECK_ERROR (r == -1, conn, "virNetworkGetAutostart");

  CAMLreturn (b ? Val_true : Val_false);
}

/* Automatically generated binding for virNetworkSetAutostart.
 * In generator.pl this function has signature "net, bool : unit".
 */

CAMLprim value
ocaml_libvirt_network_set_autostart (value netv, value bv)
{
  CAMLparam2 (netv, bv);

  virNetworkPtr net = Network_val (netv);
  virConnectPtr conn = Connect_netv (netv);
  int r, b;

  b = bv == Val_true ? 1 : 0;

  NONBLOCKING (r = virNetworkSetAutostart (net, b));
  CHECK_ERROR (r == -1, conn, "virNetworkSetAutostart");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virStoragePoolFree.
 * In generator.pl this function has signature "pool : free".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEPOOLFREE
extern int virStoragePoolFree (virStoragePoolPtr pool) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_pool_free (value poolv)
{
  CAMLparam1 (poolv);
#ifndef HAVE_VIRSTORAGEPOOLFREE
  /* Symbol virStoragePoolFree not found at compile time. */
  not_supported ("virStoragePoolFree");
  CAMLnoreturn;
#else
  /* Check that the symbol virStoragePoolFree
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStoragePoolFree);

  virStoragePoolPtr pool = Pool_val (poolv);
  virConnectPtr conn = Connect_polv (poolv);
  int r;

  NONBLOCKING (r = virStoragePoolFree (pool));
  CHECK_ERROR (r == -1, conn, "virStoragePoolFree");

  /* So that we don't double-free in the finalizer: */
  Pool_val (poolv) = NULL;

  CAMLreturn (Val_unit);
#endif
}

/* Automatically generated binding for virStoragePoolDestroy.
 * In generator.pl this function has signature "pool : free".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEPOOLDESTROY
extern int virStoragePoolDestroy (virStoragePoolPtr pool) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_pool_destroy (value poolv)
{
  CAMLparam1 (poolv);
#ifndef HAVE_VIRSTORAGEPOOLDESTROY
  /* Symbol virStoragePoolDestroy not found at compile time. */
  not_supported ("virStoragePoolDestroy");
  CAMLnoreturn;
#else
  /* Check that the symbol virStoragePoolDestroy
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStoragePoolDestroy);

  virStoragePoolPtr pool = Pool_val (poolv);
  virConnectPtr conn = Connect_polv (poolv);
  int r;

  NONBLOCKING (r = virStoragePoolDestroy (pool));
  CHECK_ERROR (r == -1, conn, "virStoragePoolDestroy");

  /* So that we don't double-free in the finalizer: */
  Pool_val (poolv) = NULL;

  CAMLreturn (Val_unit);
#endif
}

/* Automatically generated binding for virStoragePoolLookupByName.
 * In generator.pl this function has signature "conn, string : pool".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEPOOLLOOKUPBYNAME
extern virStoragePoolPtr virStoragePoolLookupByName (virConnectPtr conn, const char *str) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_pool_lookup_by_name (value connv, value strv)
{
  CAMLparam2 (connv, strv);
#ifndef HAVE_VIRSTORAGEPOOLLOOKUPBYNAME
  /* Symbol virStoragePoolLookupByName not found at compile time. */
  not_supported ("virStoragePoolLookupByName");
  CAMLnoreturn;
#else
  /* Check that the symbol virStoragePoolLookupByName
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStoragePoolLookupByName);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  char *str = String_val (strv);
  virStoragePoolPtr r;

  NONBLOCKING (r = virStoragePoolLookupByName (conn, str));
  CHECK_ERROR (!r, conn, "virStoragePoolLookupByName");

  rv = Val_pool (r, connv);

  CAMLreturn (rv);
#endif
}

/* Automatically generated binding for virStoragePoolLookupByUUID.
 * In generator.pl this function has signature "conn, uuid : pool".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEPOOLLOOKUPBYUUID
extern virStoragePoolPtr virStoragePoolLookupByUUID (virConnectPtr conn, const unsigned char *str) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_pool_lookup_by_uuid (value connv, value uuidv)
{
  CAMLparam2 (connv, uuidv);
#ifndef HAVE_VIRSTORAGEPOOLLOOKUPBYUUID
  /* Symbol virStoragePoolLookupByUUID not found at compile time. */
  not_supported ("virStoragePoolLookupByUUID");
  CAMLnoreturn;
#else
  /* Check that the symbol virStoragePoolLookupByUUID
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStoragePoolLookupByUUID);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  unsigned char *uuid = (unsigned char *) String_val (uuidv);
  virStoragePoolPtr r;

  NONBLOCKING (r = virStoragePoolLookupByUUID (conn, uuid));
  CHECK_ERROR (!r, conn, "virStoragePoolLookupByUUID");

  rv = Val_pool (r, connv);

  CAMLreturn (rv);
#endif
}

/* Automatically generated binding for virStoragePoolLookupByUUIDString.
 * In generator.pl this function has signature "conn, string : pool".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEPOOLLOOKUPBYUUIDSTRING
extern virStoragePoolPtr virStoragePoolLookupByUUIDString (virConnectPtr conn, const char *str) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_pool_lookup_by_uuid_string (value connv, value strv)
{
  CAMLparam2 (connv, strv);
#ifndef HAVE_VIRSTORAGEPOOLLOOKUPBYUUIDSTRING
  /* Symbol virStoragePoolLookupByUUIDString not found at compile time. */
  not_supported ("virStoragePoolLookupByUUIDString");
  CAMLnoreturn;
#else
  /* Check that the symbol virStoragePoolLookupByUUIDString
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStoragePoolLookupByUUIDString);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  char *str = String_val (strv);
  virStoragePoolPtr r;

  NONBLOCKING (r = virStoragePoolLookupByUUIDString (conn, str));
  CHECK_ERROR (!r, conn, "virStoragePoolLookupByUUIDString");

  rv = Val_pool (r, connv);

  CAMLreturn (rv);
#endif
}

/* Automatically generated binding for virStoragePoolGetName.
 * In generator.pl this function has signature "pool : static string".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEPOOLGETNAME
extern const char *virStoragePoolGetName (virStoragePoolPtr pool) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_pool_get_name (value poolv)
{
  CAMLparam1 (poolv);
#ifndef HAVE_VIRSTORAGEPOOLGETNAME
  /* Symbol virStoragePoolGetName not found at compile time. */
  not_supported ("virStoragePoolGetName");
  CAMLnoreturn;
#else
  /* Check that the symbol virStoragePoolGetName
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStoragePoolGetName);

  CAMLlocal1 (rv);
  virStoragePoolPtr pool = Pool_val (poolv);
  virConnectPtr conn = Connect_polv (poolv);
  const char *r;

  NONBLOCKING (r = virStoragePoolGetName (pool));
  CHECK_ERROR (!r, conn, "virStoragePoolGetName");

  rv = caml_copy_string (r);
  CAMLreturn (rv);
#endif
}

/* Automatically generated binding for virStoragePoolGetXMLDesc.
 * In generator.pl this function has signature "pool, 0U : string".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEPOOLGETXMLDESC
extern char *virStoragePoolGetXMLDesc (virStoragePoolPtr pool, unsigned  int flags) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_pool_get_xml_desc (value poolv)
{
  CAMLparam1 (poolv);
#ifndef HAVE_VIRSTORAGEPOOLGETXMLDESC
  /* Symbol virStoragePoolGetXMLDesc not found at compile time. */
  not_supported ("virStoragePoolGetXMLDesc");
  CAMLnoreturn;
#else
  /* Check that the symbol virStoragePoolGetXMLDesc
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStoragePoolGetXMLDesc);

  CAMLlocal1 (rv);
  virStoragePoolPtr pool = Pool_val (poolv);
  virConnectPtr conn = Connect_polv (poolv);
  char *r;

  NONBLOCKING (r = virStoragePoolGetXMLDesc (pool, 0));
  CHECK_ERROR (!r, conn, "virStoragePoolGetXMLDesc");

  rv = caml_copy_string (r);
  free (r);
  CAMLreturn (rv);
#endif
}

/* Automatically generated binding for virStoragePoolGetUUID.
 * In generator.pl this function has signature "pool : uuid".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEPOOLGETUUID
extern int virStoragePoolGetUUID (virStoragePoolPtr pool, unsigned char *) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_pool_get_uuid (value poolv)
{
  CAMLparam1 (poolv);
#ifndef HAVE_VIRSTORAGEPOOLGETUUID
  /* Symbol virStoragePoolGetUUID not found at compile time. */
  not_supported ("virStoragePoolGetUUID");
  CAMLnoreturn;
#else
  /* Check that the symbol virStoragePoolGetUUID
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStoragePoolGetUUID);

  CAMLlocal1 (rv);
  virStoragePoolPtr pool = Pool_val (poolv);
  virConnectPtr conn = Connect_polv (poolv);
  unsigned char uuid[VIR_UUID_BUFLEN];
  int r;

  NONBLOCKING (r = virStoragePoolGetUUID (pool, uuid));
  CHECK_ERROR (r == -1, conn, "virStoragePoolGetUUID");

  /* UUIDs are byte arrays with a fixed length. */
  rv = caml_alloc_string (VIR_UUID_BUFLEN);
  memcpy (String_val (rv), uuid, VIR_UUID_BUFLEN);
  CAMLreturn (rv);
#endif
}

/* Automatically generated binding for virStoragePoolGetUUIDString.
 * In generator.pl this function has signature "pool : uuid string".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEPOOLGETUUIDSTRING
extern int virStoragePoolGetUUIDString (virStoragePoolPtr pool, char *) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_pool_get_uuid_string (value poolv)
{
  CAMLparam1 (poolv);
#ifndef HAVE_VIRSTORAGEPOOLGETUUIDSTRING
  /* Symbol virStoragePoolGetUUIDString not found at compile time. */
  not_supported ("virStoragePoolGetUUIDString");
  CAMLnoreturn;
#else
  /* Check that the symbol virStoragePoolGetUUIDString
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStoragePoolGetUUIDString);

  CAMLlocal1 (rv);
  virStoragePoolPtr pool = Pool_val (poolv);
  virConnectPtr conn = Connect_polv (poolv);
  char uuid[VIR_UUID_STRING_BUFLEN];
  int r;

  NONBLOCKING (r = virStoragePoolGetUUIDString (pool, uuid));
  CHECK_ERROR (r == -1, conn, "virStoragePoolGetUUIDString");

  rv = caml_copy_string (uuid);
  CAMLreturn (rv);
#endif
}

/* Automatically generated binding for virStoragePoolCreateXML.
 * In generator.pl this function has signature "conn, string, 0U : pool".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEPOOLCREATEXML
extern virStoragePoolPtr virStoragePoolCreateXML (virConnectPtr conn, const char *str, unsigned int flags) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_pool_create_xml (value connv, value strv)
{
  CAMLparam2 (connv, strv);
#ifndef HAVE_VIRSTORAGEPOOLCREATEXML
  /* Symbol virStoragePoolCreateXML not found at compile time. */
  not_supported ("virStoragePoolCreateXML");
  CAMLnoreturn;
#else
  /* Check that the symbol virStoragePoolCreateXML
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStoragePoolCreateXML);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  char *str = String_val (strv);
  virStoragePoolPtr r;

  NONBLOCKING (r = virStoragePoolCreateXML (conn, str, 0));
  CHECK_ERROR (!r, conn, "virStoragePoolCreateXML");

  rv = Val_pool (r, connv);

  CAMLreturn (rv);
#endif
}

/* Automatically generated binding for virStoragePoolDefineXML.
 * In generator.pl this function has signature "conn, string, 0U : pool".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEPOOLDEFINEXML
extern virStoragePoolPtr virStoragePoolDefineXML (virConnectPtr conn, const char *str, unsigned int flags) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_pool_define_xml (value connv, value strv)
{
  CAMLparam2 (connv, strv);
#ifndef HAVE_VIRSTORAGEPOOLDEFINEXML
  /* Symbol virStoragePoolDefineXML not found at compile time. */
  not_supported ("virStoragePoolDefineXML");
  CAMLnoreturn;
#else
  /* Check that the symbol virStoragePoolDefineXML
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStoragePoolDefineXML);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  char *str = String_val (strv);
  virStoragePoolPtr r;

  NONBLOCKING (r = virStoragePoolDefineXML (conn, str, 0));
  CHECK_ERROR (!r, conn, "virStoragePoolDefineXML");

  rv = Val_pool (r, connv);

  CAMLreturn (rv);
#endif
}

/* Automatically generated binding for virStoragePoolBuild.
 * In generator.pl this function has signature "pool, uint : unit".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEPOOLBUILD
extern int virStoragePoolBuild (virStoragePoolPtr pool, unsigned int i) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_pool_build (value poolv, value iv)
{
  CAMLparam2 (poolv, iv);
#ifndef HAVE_VIRSTORAGEPOOLBUILD
  /* Symbol virStoragePoolBuild not found at compile time. */
  not_supported ("virStoragePoolBuild");
  CAMLnoreturn;
#else
  /* Check that the symbol virStoragePoolBuild
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStoragePoolBuild);

  virStoragePoolPtr pool = Pool_val (poolv);
  virConnectPtr conn = Connect_polv (poolv);
  unsigned int i = Int_val (iv);
  int r;

  NONBLOCKING (r = virStoragePoolBuild (pool, i));
  CHECK_ERROR (!r, conn, "virStoragePoolBuild");

  CAMLreturn (Val_unit);
#endif
}

/* Automatically generated binding for virStoragePoolUndefine.
 * In generator.pl this function has signature "pool : unit".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEPOOLUNDEFINE
extern int virStoragePoolUndefine (virStoragePoolPtr pool) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_pool_undefine (value poolv)
{
  CAMLparam1 (poolv);
#ifndef HAVE_VIRSTORAGEPOOLUNDEFINE
  /* Symbol virStoragePoolUndefine not found at compile time. */
  not_supported ("virStoragePoolUndefine");
  CAMLnoreturn;
#else
  /* Check that the symbol virStoragePoolUndefine
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStoragePoolUndefine);

  virStoragePoolPtr pool = Pool_val (poolv);
  virConnectPtr conn = Connect_polv (poolv);
  int r;

  NONBLOCKING (r = virStoragePoolUndefine (pool));
  CHECK_ERROR (r == -1, conn, "virStoragePoolUndefine");

  CAMLreturn (Val_unit);
#endif
}

/* Automatically generated binding for virStoragePoolCreate.
 * In generator.pl this function has signature "pool, 0U : unit".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEPOOLCREATE
extern int virStoragePoolCreate (virStoragePoolPtr pool, unsigned  int flags) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_pool_create (value poolv)
{
  CAMLparam1 (poolv);
#ifndef HAVE_VIRSTORAGEPOOLCREATE
  /* Symbol virStoragePoolCreate not found at compile time. */
  not_supported ("virStoragePoolCreate");
  CAMLnoreturn;
#else
  /* Check that the symbol virStoragePoolCreate
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStoragePoolCreate);

  virStoragePoolPtr pool = Pool_val (poolv);
  virConnectPtr conn = Connect_polv (poolv);
  int r;

  NONBLOCKING (r = virStoragePoolCreate (pool, 0));
  CHECK_ERROR (r == -1, conn, "virStoragePoolCreate");

  CAMLreturn (Val_unit);
#endif
}

/* Automatically generated binding for virStoragePoolDelete.
 * In generator.pl this function has signature "pool, uint : unit".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEPOOLDELETE
extern int virStoragePoolDelete (virStoragePoolPtr pool, unsigned int i) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_pool_delete (value poolv, value iv)
{
  CAMLparam2 (poolv, iv);
#ifndef HAVE_VIRSTORAGEPOOLDELETE
  /* Symbol virStoragePoolDelete not found at compile time. */
  not_supported ("virStoragePoolDelete");
  CAMLnoreturn;
#else
  /* Check that the symbol virStoragePoolDelete
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStoragePoolDelete);

  virStoragePoolPtr pool = Pool_val (poolv);
  virConnectPtr conn = Connect_polv (poolv);
  unsigned int i = Int_val (iv);
  int r;

  NONBLOCKING (r = virStoragePoolDelete (pool, i));
  CHECK_ERROR (!r, conn, "virStoragePoolDelete");

  CAMLreturn (Val_unit);
#endif
}

/* Automatically generated binding for virStoragePoolRefresh.
 * In generator.pl this function has signature "pool, 0U : unit".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEPOOLREFRESH
extern int virStoragePoolRefresh (virStoragePoolPtr pool, unsigned  int flags) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_pool_refresh (value poolv)
{
  CAMLparam1 (poolv);
#ifndef HAVE_VIRSTORAGEPOOLREFRESH
  /* Symbol virStoragePoolRefresh not found at compile time. */
  not_supported ("virStoragePoolRefresh");
  CAMLnoreturn;
#else
  /* Check that the symbol virStoragePoolRefresh
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStoragePoolRefresh);

  virStoragePoolPtr pool = Pool_val (poolv);
  virConnectPtr conn = Connect_polv (poolv);
  int r;

  NONBLOCKING (r = virStoragePoolRefresh (pool, 0));
  CHECK_ERROR (r == -1, conn, "virStoragePoolRefresh");

  CAMLreturn (Val_unit);
#endif
}

/* Automatically generated binding for virStoragePoolGetAutostart.
 * In generator.pl this function has signature "pool : bool".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEPOOLGETAUTOSTART
extern int virStoragePoolGetAutostart (virStoragePoolPtr pool, int *r) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_pool_get_autostart (value poolv)
{
  CAMLparam1 (poolv);
#ifndef HAVE_VIRSTORAGEPOOLGETAUTOSTART
  /* Symbol virStoragePoolGetAutostart not found at compile time. */
  not_supported ("virStoragePoolGetAutostart");
  CAMLnoreturn;
#else
  /* Check that the symbol virStoragePoolGetAutostart
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStoragePoolGetAutostart);

  virStoragePoolPtr pool = Pool_val (poolv);
  virConnectPtr conn = Connect_polv (poolv);
  int r, b;

  NONBLOCKING (r = virStoragePoolGetAutostart (pool, &b));
  CHECK_ERROR (r == -1, conn, "virStoragePoolGetAutostart");

  CAMLreturn (b ? Val_true : Val_false);
#endif
}

/* Automatically generated binding for virStoragePoolSetAutostart.
 * In generator.pl this function has signature "pool, bool : unit".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEPOOLSETAUTOSTART
extern int virStoragePoolSetAutostart (virStoragePoolPtr pool, int b) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_pool_set_autostart (value poolv, value bv)
{
  CAMLparam2 (poolv, bv);
#ifndef HAVE_VIRSTORAGEPOOLSETAUTOSTART
  /* Symbol virStoragePoolSetAutostart not found at compile time. */
  not_supported ("virStoragePoolSetAutostart");
  CAMLnoreturn;
#else
  /* Check that the symbol virStoragePoolSetAutostart
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStoragePoolSetAutostart);

  virStoragePoolPtr pool = Pool_val (poolv);
  virConnectPtr conn = Connect_polv (poolv);
  int r, b;

  b = bv == Val_true ? 1 : 0;

  NONBLOCKING (r = virStoragePoolSetAutostart (pool, b));
  CHECK_ERROR (r == -1, conn, "virStoragePoolSetAutostart");

  CAMLreturn (Val_unit);
#endif
}

/* Automatically generated binding for virStoragePoolNumOfVolumes.
 * In generator.pl this function has signature "pool : int".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEPOOLNUMOFVOLUMES
extern int virStoragePoolNumOfVolumes (virStoragePoolPtr pool) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_pool_num_of_volumes (value poolv)
{
  CAMLparam1 (poolv);
#ifndef HAVE_VIRSTORAGEPOOLNUMOFVOLUMES
  /* Symbol virStoragePoolNumOfVolumes not found at compile time. */
  not_supported ("virStoragePoolNumOfVolumes");
  CAMLnoreturn;
#else
  /* Check that the symbol virStoragePoolNumOfVolumes
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStoragePoolNumOfVolumes);

  virStoragePoolPtr pool = Pool_val (poolv);
  virConnectPtr conn = Connect_polv (poolv);
  int r;

  NONBLOCKING (r = virStoragePoolNumOfVolumes (pool));
  CHECK_ERROR (r == -1, conn, "virStoragePoolNumOfVolumes");

  CAMLreturn (Val_int (r));
#endif
}

/* Automatically generated binding for virStoragePoolListVolumes.
 * In generator.pl this function has signature "pool, int : string array".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEPOOLLISTVOLUMES
extern int virStoragePoolListVolumes (virStoragePoolPtr pool, char **const names, int maxnames) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_pool_list_volumes (value poolv, value iv)
{
  CAMLparam2 (poolv, iv);
#ifndef HAVE_VIRSTORAGEPOOLLISTVOLUMES
  /* Symbol virStoragePoolListVolumes not found at compile time. */
  not_supported ("virStoragePoolListVolumes");
  CAMLnoreturn;
#else
  /* Check that the symbol virStoragePoolListVolumes
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStoragePoolListVolumes);

  CAMLlocal2 (rv, strv);
  virStoragePoolPtr pool = Pool_val (poolv);
  virConnectPtr conn = Connect_polv (poolv);
  int i = Int_val (iv);
  char *names[i];
  int r;

  /* Some libvirt List* functions still throw exceptions if i == 0,
   * so catch that and return an empty array directly.  This changes
   * the semantics slightly (masking other failures) but it's
   * unlikely anyone will care.  RWMJ 2008/06/10
   */
  if (i == 0) {
    rv = caml_alloc (0, 0);
    CAMLreturn (rv);
  }

  NONBLOCKING (r = virStoragePoolListVolumes (pool, names, i));
  CHECK_ERROR (r == -1, conn, "virStoragePoolListVolumes");

  rv = caml_alloc (r, 0);
  for (i = 0; i < r; ++i) {
    strv = caml_copy_string (names[i]);
    Store_field (rv, i, strv);
    free (names[i]);
  }

  CAMLreturn (rv);
#endif
}

/* Automatically generated binding for virStorageVolFree.
 * In generator.pl this function has signature "vol : free".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEVOLFREE
extern int virStorageVolFree (virStorageVolPtr vol) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_vol_free (value volv)
{
  CAMLparam1 (volv);
#ifndef HAVE_VIRSTORAGEVOLFREE
  /* Symbol virStorageVolFree not found at compile time. */
  not_supported ("virStorageVolFree");
  CAMLnoreturn;
#else
  /* Check that the symbol virStorageVolFree
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStorageVolFree);

  virStorageVolPtr vol = Volume_val (volv);
  virConnectPtr conn = Connect_volv (volv);
  int r;

  NONBLOCKING (r = virStorageVolFree (vol));
  CHECK_ERROR (r == -1, conn, "virStorageVolFree");

  /* So that we don't double-free in the finalizer: */
  Volume_val (volv) = NULL;

  CAMLreturn (Val_unit);
#endif
}

/* Automatically generated binding for virStorageVolDelete.
 * In generator.pl this function has signature "vol, uint : unit".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEVOLDELETE
extern int virStorageVolDelete (virStorageVolPtr vol, unsigned int i) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_vol_delete (value volv, value iv)
{
  CAMLparam2 (volv, iv);
#ifndef HAVE_VIRSTORAGEVOLDELETE
  /* Symbol virStorageVolDelete not found at compile time. */
  not_supported ("virStorageVolDelete");
  CAMLnoreturn;
#else
  /* Check that the symbol virStorageVolDelete
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStorageVolDelete);

  virStorageVolPtr vol = Volume_val (volv);
  virConnectPtr conn = Connect_volv (volv);
  unsigned int i = Int_val (iv);
  int r;

  NONBLOCKING (r = virStorageVolDelete (vol, i));
  CHECK_ERROR (!r, conn, "virStorageVolDelete");

  CAMLreturn (Val_unit);
#endif
}

/* Automatically generated binding for virStorageVolLookupByName.
 * In generator.pl this function has signature "pool, string : vol from pool".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEVOLLOOKUPBYNAME
extern virStorageVolPtr virStorageVolLookupByName (virStoragePoolPtr pool, const char *str) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_vol_lookup_by_name (value poolv, value strv)
{
  CAMLparam2 (poolv, strv);
#ifndef HAVE_VIRSTORAGEVOLLOOKUPBYNAME
  /* Symbol virStorageVolLookupByName not found at compile time. */
  not_supported ("virStorageVolLookupByName");
  CAMLnoreturn;
#else
  /* Check that the symbol virStorageVolLookupByName
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStorageVolLookupByName);

  CAMLlocal2 (rv, connv);
  virStoragePoolPtr pool = Pool_val (poolv);
  virConnectPtr conn = Connect_polv (poolv);
  char *str = String_val (strv);
  virStorageVolPtr r;

  NONBLOCKING (r = virStorageVolLookupByName (pool, str));
  CHECK_ERROR (!r, conn, "virStorageVolLookupByName");

  connv = Field (poolv, 1);
  rv = Val_volume (r, connv);

  CAMLreturn (rv);
#endif
}

/* Automatically generated binding for virStorageVolLookupByKey.
 * In generator.pl this function has signature "conn, string : vol".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEVOLLOOKUPBYKEY
extern virStorageVolPtr virStorageVolLookupByKey (virConnectPtr conn, const char *str) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_vol_lookup_by_key (value connv, value strv)
{
  CAMLparam2 (connv, strv);
#ifndef HAVE_VIRSTORAGEVOLLOOKUPBYKEY
  /* Symbol virStorageVolLookupByKey not found at compile time. */
  not_supported ("virStorageVolLookupByKey");
  CAMLnoreturn;
#else
  /* Check that the symbol virStorageVolLookupByKey
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStorageVolLookupByKey);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  char *str = String_val (strv);
  virStorageVolPtr r;

  NONBLOCKING (r = virStorageVolLookupByKey (conn, str));
  CHECK_ERROR (!r, conn, "virStorageVolLookupByKey");

  rv = Val_volume (r, connv);

  CAMLreturn (rv);
#endif
}

/* Automatically generated binding for virStorageVolLookupByPath.
 * In generator.pl this function has signature "conn, string : vol".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEVOLLOOKUPBYPATH
extern virStorageVolPtr virStorageVolLookupByPath (virConnectPtr conn, const char *str) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_vol_lookup_by_path (value connv, value strv)
{
  CAMLparam2 (connv, strv);
#ifndef HAVE_VIRSTORAGEVOLLOOKUPBYPATH
  /* Symbol virStorageVolLookupByPath not found at compile time. */
  not_supported ("virStorageVolLookupByPath");
  CAMLnoreturn;
#else
  /* Check that the symbol virStorageVolLookupByPath
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStorageVolLookupByPath);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  char *str = String_val (strv);
  virStorageVolPtr r;

  NONBLOCKING (r = virStorageVolLookupByPath (conn, str));
  CHECK_ERROR (!r, conn, "virStorageVolLookupByPath");

  rv = Val_volume (r, connv);

  CAMLreturn (rv);
#endif
}

/* Automatically generated binding for virStorageVolCreateXML.
 * In generator.pl this function has signature "pool, string, 0U : vol from pool".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEVOLCREATEXML
extern virStorageVolPtr virStorageVolCreateXML (virStoragePoolPtr pool, const char *str, unsigned  int flags) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_vol_create_xml (value poolv, value strv)
{
  CAMLparam2 (poolv, strv);
#ifndef HAVE_VIRSTORAGEVOLCREATEXML
  /* Symbol virStorageVolCreateXML not found at compile time. */
  not_supported ("virStorageVolCreateXML");
  CAMLnoreturn;
#else
  /* Check that the symbol virStorageVolCreateXML
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStorageVolCreateXML);

  CAMLlocal2 (rv, connv);
  virStoragePoolPtr pool = Pool_val (poolv);
  virConnectPtr conn = Connect_polv (poolv);
  char *str = String_val (strv);
  virStorageVolPtr r;

  NONBLOCKING (r = virStorageVolCreateXML (pool, str, 0));
  CHECK_ERROR (!r, conn, "virStorageVolCreateXML");

  connv = Field (poolv, 1);
  rv = Val_volume (r, connv);

  CAMLreturn (rv);
#endif
}

/* Automatically generated binding for virStorageVolGetXMLDesc.
 * In generator.pl this function has signature "vol, 0U : string".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEVOLGETXMLDESC
extern char *virStorageVolGetXMLDesc (virStorageVolPtr vol, unsigned  int flags) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_vol_get_xml_desc (value volv)
{
  CAMLparam1 (volv);
#ifndef HAVE_VIRSTORAGEVOLGETXMLDESC
  /* Symbol virStorageVolGetXMLDesc not found at compile time. */
  not_supported ("virStorageVolGetXMLDesc");
  CAMLnoreturn;
#else
  /* Check that the symbol virStorageVolGetXMLDesc
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStorageVolGetXMLDesc);

  CAMLlocal1 (rv);
  virStorageVolPtr vol = Volume_val (volv);
  virConnectPtr conn = Connect_volv (volv);
  char *r;

  NONBLOCKING (r = virStorageVolGetXMLDesc (vol, 0));
  CHECK_ERROR (!r, conn, "virStorageVolGetXMLDesc");

  rv = caml_copy_string (r);
  free (r);
  CAMLreturn (rv);
#endif
}

/* Automatically generated binding for virStorageVolGetPath.
 * In generator.pl this function has signature "vol : string".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEVOLGETPATH
extern char *virStorageVolGetPath (virStorageVolPtr vol) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_vol_get_path (value volv)
{
  CAMLparam1 (volv);
#ifndef HAVE_VIRSTORAGEVOLGETPATH
  /* Symbol virStorageVolGetPath not found at compile time. */
  not_supported ("virStorageVolGetPath");
  CAMLnoreturn;
#else
  /* Check that the symbol virStorageVolGetPath
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStorageVolGetPath);

  CAMLlocal1 (rv);
  virStorageVolPtr vol = Volume_val (volv);
  virConnectPtr conn = Connect_volv (volv);
  char *r;

  NONBLOCKING (r = virStorageVolGetPath (vol));
  CHECK_ERROR (!r, conn, "virStorageVolGetPath");

  rv = caml_copy_string (r);
  free (r);
  CAMLreturn (rv);
#endif
}

/* Automatically generated binding for virStorageVolGetKey.
 * In generator.pl this function has signature "vol : static string".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEVOLGETKEY
extern const char *virStorageVolGetKey (virStorageVolPtr vol) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_vol_get_key (value volv)
{
  CAMLparam1 (volv);
#ifndef HAVE_VIRSTORAGEVOLGETKEY
  /* Symbol virStorageVolGetKey not found at compile time. */
  not_supported ("virStorageVolGetKey");
  CAMLnoreturn;
#else
  /* Check that the symbol virStorageVolGetKey
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStorageVolGetKey);

  CAMLlocal1 (rv);
  virStorageVolPtr vol = Volume_val (volv);
  virConnectPtr conn = Connect_volv (volv);
  const char *r;

  NONBLOCKING (r = virStorageVolGetKey (vol));
  CHECK_ERROR (!r, conn, "virStorageVolGetKey");

  rv = caml_copy_string (r);
  CAMLreturn (rv);
#endif
}

/* Automatically generated binding for virStorageVolGetName.
 * In generator.pl this function has signature "vol : static string".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEVOLGETNAME
extern const char *virStorageVolGetName (virStorageVolPtr vol) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_vol_get_name (value volv)
{
  CAMLparam1 (volv);
#ifndef HAVE_VIRSTORAGEVOLGETNAME
  /* Symbol virStorageVolGetName not found at compile time. */
  not_supported ("virStorageVolGetName");
  CAMLnoreturn;
#else
  /* Check that the symbol virStorageVolGetName
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStorageVolGetName);

  CAMLlocal1 (rv);
  virStorageVolPtr vol = Volume_val (volv);
  virConnectPtr conn = Connect_volv (volv);
  const char *r;

  NONBLOCKING (r = virStorageVolGetName (vol));
  CHECK_ERROR (!r, conn, "virStorageVolGetName");

  rv = caml_copy_string (r);
  CAMLreturn (rv);
#endif
}

/* Automatically generated binding for virStoragePoolLookupByVolume.
 * In generator.pl this function has signature "vol : pool from vol".
 */

#ifdef HAVE_WEAK_SYMBOLS
#ifdef HAVE_VIRSTORAGEPOOLLOOKUPBYVOLUME
extern virStoragePoolPtr virStoragePoolLookupByVolume (virStorageVolPtr vol) __attribute__((weak));
#endif
#endif

CAMLprim value
ocaml_libvirt_storage_pool_lookup_by_volume (value volv)
{
  CAMLparam1 (volv);
#ifndef HAVE_VIRSTORAGEPOOLLOOKUPBYVOLUME
  /* Symbol virStoragePoolLookupByVolume not found at compile time. */
  not_supported ("virStoragePoolLookupByVolume");
  CAMLnoreturn;
#else
  /* Check that the symbol virStoragePoolLookupByVolume
   * is in runtime version of libvirt.
   */
  WEAK_SYMBOL_CHECK (virStoragePoolLookupByVolume);

  CAMLlocal2 (rv, connv);
  virStorageVolPtr vol = Volume_val (volv);
  virConnectPtr conn = Connect_volv (volv);
  virStoragePoolPtr r;

  NONBLOCKING (r = virStoragePoolLookupByVolume (vol));
  CHECK_ERROR (!r, conn, "virStoragePoolLookupByVolume");

  connv = Field (volv, 1);
  rv = Val_pool (r, connv);

  CAMLreturn (rv);
#endif
}

#include "libvirt_c_epilogue.c"

/* EOF */
