/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2008 Sun Microsystems, Inc.
 */
package org.netbeans.modules.dlight.spi.support;

import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata.Column;
import org.netbeans.modules.dlight.api.storage.DataTableMetadataFilter;
import org.netbeans.modules.dlight.api.storage.DataTableMetadataFilterSupport;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;

/**
 * Implements default SQLTableDataProvider for {@link org.netbeans.modules.dlight.core.storage.model.SQLDataStorage}
 */
public class SQLTableDataProvider implements TableDataProvider {

    private final Lock lock = new Lock();
    private final List<DataFilter> filters = new ArrayList<DataFilter>();
    private SQLDataStorage storage;
    private ServiceInfoDataStorage serviceInfoStorage;

    public SQLTableDataProvider() {
    }

//  public String getID() {
//    return "TableDataProvider";
//  }
//  /**
//   * Returns {@link org.netbeans.modules.dlight.core.dataprovider.model.TableDataModel} as
//   * provided data model scheme
//   * @return
//   */
//  public List<? extends DataModelScheme> getProvidedDataModelScheme() {
//    return Arrays.asList(TableDataModel.instance);
//  }
//
//  public final boolean provides(DataModelScheme dataModel) {
//    return getProvidedDataModelScheme().contains(dataModel);
//  }
//
//  public List<DataStorageType> getSupportedDataStorageTypes() {
//    return Arrays.asList(DataStorageTypeFactory.getInstance().getDataStorageType(SQLDataStorage.SQL_DATA_STORAGE_TYPE));
//  }
    /**
     * Attaches DataProvider to the <param>storage</param>.
     * All data requested by {@link org.netbeans.modules.dlight.core.visualizer.model.Visualizer} will
     * be extracted from this storage. This method is invoked at the time Visualizer
     * need to be displayed. See {@link org.netbeans.modules.dlight.core.model.DLightManager#openVisualizer(org.netbeans.modules.dlight.core.model.DLightTool, java.lang.String, org.netbeans.modules.dlight.core.visualizer.model.VisualizerConfiguration) } for more detailes
     * @param storage {@link org.netbeans.modules.dlight.core.storage.model.DataStorage}
     */
    @Override
    public final void attachTo(DataStorage storage) {
        this.storage = (SQLDataStorage) storage;
    }

//  /**
//   * Returns new instance of SQLTableDataProvider
//   * @return new instance of SQLTableDataProvider
//   */
//  public DataProvider newInstance() {
//    return new SQLTableDataProvider();
//  }
    private <T extends DataFilter> Collection<T> getDataFilters(Class<T> clazz) {
        Collection<T> result = new ArrayList<T>();
        synchronized (lock) {
            for (DataFilter f : filters) {
                if (f.getClass() == clazz) {
                    result.add(clazz.cast(f));
                }
            }
        }
        return result;
    }

    /**
     * Returns table view to visualize
     * @param tableMetadata table description to get data from
     * @return list of {@link org.netbeans.modules.dlight.core.storage.model.DataRow}
     */
    @Override
    public List<DataRow> queryData(DataTableMetadata tableMetadata) {
        if (tableMetadata == null) {
            return null;
        }
        List<Column> columns = tableMetadata.getColumns();
        List<DataRow> result = new ArrayList<DataRow>();
//        List<DataFilter> changedFilters = new ArrayList<DataFilter>();
//        final long startTimeStamp = Long.valueOf(serviceInfoStorage.getValue(ServiceInfoDataStorage.START_TIME_NANOSECONDS));
//        synchronized(lock){
//            for (DataFilter f : filters){
//                if (f instanceof TimeIntervalDataFilter){
//                    //long startTs = f.
//                    Range<Long> interval  = ((TimeIntervalDataFilter)f).getInterval();
//                    Range<Long> newInterval = new Range<Long>(interval.getStart() + startTimeStamp, interval.getEnd() + startTimeStamp);
//                    TimeIntervalDataFilter newFilter  = TimeIntervalDataFilterFactory.create(newInterval);
//                    changedFilters.add(newFilter);
//                }else{
//                    changedFilters.add(f);
//                }
//            }
//        }

        Collection<TimeIntervalDataFilter> timeFilters = getDataFilters(TimeIntervalDataFilter.class);
        Collection<DataTableMetadataFilter> tableFilters = new ArrayList<DataTableMetadataFilter>();
        DataTableMetadataFilterSupport filtersSupport = DataTableMetadataFilterSupport.getInstance();
        for (TimeIntervalDataFilter timeFilter : timeFilters) {
            tableFilters.addAll(filtersSupport.createFilters(tableMetadata, timeFilter));
        }

        try {
            //TODO: once it is ready for I/O - just uncomment
            ResultSet rs = storage.select(tableMetadata, tableFilters);
            //ResultSet rs = storage.select(tableMetadata.getName(), columns, tableMetadata.getViewStatement());
            if (rs == null) {
                return Collections.emptyList();
            }
            List<String> colnames = tableMetadata.getColumnNames();
            while (rs.next()) {
                ArrayList<Object> data = new ArrayList<Object>(columns.size());
                for (Column c : columns) {
                    data.add(rs.getObject(c.getColumnName()));
                }
                DataRow dataRow = new DataRow(colnames, data);
                result.add(dataRow);
            }

        } catch (SQLException ex) {
            SQLExceptions.printStackTrace(storage, ex);
        }
        return result;
    }

    @Override
    public void attachTo(ServiceInfoDataStorage serviceInfoDataStorage) {
        this.serviceInfoStorage = serviceInfoDataStorage;
    }

    @Override
    public void dataFiltersChanged(List<DataFilter> newSet, boolean isAdjusting) {
        //we should keep them here
        if (isAdjusting) {
            return;
        }
        synchronized (lock) {
            filters.clear();
            filters.addAll(newSet);
        }
    }

    // TODO: need to discuss... 
    public SQLDataStorage getStorage() {
        return storage;
    }

    private final static class Lock {
    }
}
