/* 
 * Copyright (c) 2011, 2013, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#pragma once

namespace MySQL {
  namespace Forms {

    public ref class FindPanelImpl : public ViewImpl, public MySQL::Utilities::IFindPanel
    {
    private:
      MySQL::Utilities::FindPanel^ nativeFindPanel;
    protected:
      static bool create(mforms::FindPanel* panel);
      static int perform_action(mforms::FindPanel* panel, mforms::FindPanelAction action);
      static void focus(mforms::FindPanel* panel);
      static void enable_replace(mforms::FindPanel* panel, bool flag);

      int DoFindReplace(mforms::FindPanelAction action);
    public:
      FindPanelImpl(mforms::FindPanel* panel);

      virtual void Close();
      virtual int FindReplaceAction(MySQL::Utilities::FindPanelAction action);

      static void init(Manager ^mgr)
      {
        mforms::ControlFactory *f= mforms::ControlFactory::get_instance();

        DEF_CALLBACK1(bool, mforms::FindPanel*, mgr, f->_findpanel_impl, FindPanelImpl, create);
        DEF_CALLBACK2(int, mforms::FindPanel*, mforms::FindPanelAction, mgr, f->_findpanel_impl, FindPanelImpl, perform_action);
        DEF_CALLBACK1(void, mforms::FindPanel*, mgr, f->_findpanel_impl, FindPanelImpl, focus);
        DEF_CALLBACK2(void, mforms::FindPanel*, bool, mgr, f->_findpanel_impl, FindPanelImpl, enable_replace);
      }
    };

  };
};
