/* Copyright (C) 1999 Beau Kuiper

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "config.h"
#include "auth.h"

/* This file contains code to autheticate for mud users */

/* any level higher than this will successfully authenticate. */

#define MINLEVEL 20

typedef struct 
{
	char *password;
	int level;
} PASSWDSTRUCT;

int mudauth_config(char *cmd, char *data, int line, void *h)
{
	PASSWDSTRUCT *handle = (PASSWDSTRUCT *)h;
	
	if (strcmp(cmd, "Level") == 0)
		sscanf(data, "%d", &(handle->level));
	else if ((strcmp(cmd, "Password") == 0) && (strlen(data) > 2))
	{
		handle->password = strdupwrapper(data + 1);
		handle->password[strlen(handle->password) - 1] = 0;
	}
	return(FALSE);
}
				
void *gethandle(void *peer, void *tset, char *username, int *err)
{
	PASSWDSTRUCT *newhandle;
	int result, error, line;
	char *userfile;
	
	userfile = mktokconfstr(tset, auth_getcursectionid(peer), "playerfile", NULL);

	if (userfile == NULL)
	{
		log_addentry(MYLOG_INFO, NULL, "authmud requires playerfile to specify player file");
		*err = AUTH_ERROR;
		return(NULL);
	}
	
	newhandle = mallocwrapper(sizeof(PASSWDSTRUCT));
	newhandle->password = NULL;
	newhandle->level = 0;
	
	result = loadconfigfile(userfile, mudauth_config, newhandle, FALSE, &error, &line);
	
	*err = AUTH_OK;
	if (result != 0)
		*err = AUTH_USERNKNOW;
	
	if (newhandle->level <= MINLEVEL)
	{
		if (newhandle->password) freewrapper(newhandle->password);
		newhandle = NULL;
		*err = AUTH_ERROR;
	}
	freewrapper(userfile);
	return(newhandle);
}

void freehandle(void *h)
{
	PASSWDSTRUCT *handle = (PASSWDSTRUCT *)h;
	
	freewrapper(handle->password);
	freewrapper(handle);
}

int chkpasswd(void *h, char *password, char **errmsg)
{
	PASSWDSTRUCT *handle = (PASSWDSTRUCT *)h;
	
	return(chkpassword(handle->password, password));
}
