/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

//
// .NAME:
//  SubPage
//
// .AUTHOR:
//  Gilberto Camara and Fernando Ii
//
// .SUMMARY:
//  Provides supprot for subpages in the PlotMod plot hierarchy
//
//
// .CLIENTS:
//  Page
//
// .RESPONSBILITIES:
//  - Include new data units
//  - Create data objects (leaves of the PlotMod tree )
//  - Keep track of the matching information
//
//
// .COLLABORATORS:
//  DatObject, MatchingInfo
//
// .ASCENDENT:
//  Presentable
//
//
// .DESCENDENT:
//  (none)
//
#ifndef SubPage_H
#define SubPage_H

#include "Presentable.h"

class DataObject;

class SubPage : public Presentable
{
public:
    // Constructors
    // Constructor from a request
    SubPage(MvRequest& subpageRequest);

    SubPage(MvRequest&, int, long, long, const MatchingInfo&);

    SubPage(const SubPage&);

    virtual Presentable* Clone() const { return new SubPage(*this); }

    // Destructor
    ~SubPage();

    // Methods
    // Overriden from Presentable class

    // Draw me and all my children
    virtual void Draw();

    // Draw Title Text only, positional is drawn by Page
    virtual void DrawText();

    // Draw Legend
    virtual void DrawLegend();

    // Draw Import icons
    virtual void DrawImport();

    // Draws output file Prolog
    void DrawProlog();

    // Draws output file page header
    void DrawPageHeader();

    // Finalize drawing
    void DrawTrailer();  //CHECK IF THIS IS STILL NEEDED
    void DrawTrailer(MvRequest&);

    // Accept a  visitor
    virtual void Visit(Visitor& v);

    virtual long PictureId(const char* typeName, bool generate = false);

    // Local to subpage class
    // Set/return/check the canvas ( one per subpage )
    virtual void SetCanvas(Canvas* canvas);
    virtual Canvas& GetCanvas() const;
    bool CheckCanvas();

    // Insert a new data unit (response to a drop action)
    void InsertDataUnit(int, long, long, const MatchingInfo&);

    // Remove icon from tree structure
    virtual void RemoveIcon(MvIcon&);

    // Remove all data icon from tree structure
    virtual void RemoveAllData() { RemoveMyData(); }

    bool GetDrawPrior(DrawPriorMap*);

    bool GetDataObjects(list<DataObject*>&);

    // Indicate/determine whether a page is visited in background
    virtual bool VisitInBackground() { return visitInBackground_; }
    virtual void VisitInBackground(bool xx) { visitInBackground_ = xx; }

    virtual void PendingDrawingsAdd();
    virtual void PendingDrawingsRemove();

    virtual void SetVisibility(bool);
    virtual bool IsVisible();

    //virtual void DescribeData ( MvRequest& );
    // Add to request SubPage dataunit icons with dataobject requests

    //virtual Cached DescribeMatchingInfo ();
    // Describes Matching info in the "DATE TIME LEVEL PARAM" format

    // Check if there is any Visdef associated with the input Dataunit.
    // This also includes Visdefs that are associated with the children of the Dataunit.
    // This function returns a flag (True: found a Dataunit) and a list of
    // associated Dataunits.
    virtual bool CheckValidVisDef(MvIcon&, MvRequest&, MvIconList&, int = 0);

private:
    // No copy allowed
    SubPage& operator=(const SubPage&);

    // Members
    Canvas* subpageCanvas_;
    bool visitInBackground_;
    bool hasTitleDraw_;

    typedef map<string, long> PictureIdMap;
    PictureIdMap pictureIdMap_;  // for synchronization problems
};

#endif
