CDECK  ID>, HWUDAT.
*CMZ :-        -26/04/91  10.18.58  by  Bryan Webber
*-- Author :    Ian Knowles & Bryan Webber
C-----------------------------------------------------------------------
      BLOCK DATA HWUDAT
C-----------------------------------------------------------------------
C     Loads common blocks with particle properties data; for particle I:
C        RNAME(I) = Name
C        IDPDG(I) = PDG code
C        IFLAV(I) = HERWIG flavour code
C        ICHRG(I) = Electric charge (|e-|)          (*3 for (di-)quarks)
C        RMASS(I) = Mass (GeV/c^2)
C        RLTIM(I) = Proper life time (s)
C        RSPIN(I) = Spin
C     And stores the particle decay tables: call HWUDPR to print them
C-----------------------------------------------------------------------
      INCLUDE 'HERWIG59.INC'
      INTEGER NLAST,NNEXT,NLEFT,I,J
      PARAMETER (NLAST=393,NNEXT=393+1,NLEFT=NMXRES-393)
      DATA NRES/393/
C Don't forget to change the three occurances above as well
      DATA (RNAME(I),IDPDG(I),IFLAV(I),ICHRG(I),RMASS(I),RLTIM(I),
     &      RSPIN(I),I=0,16)/
     & '        ',      0,   0, 0,0.000,0.000D+00,0.0,
     & 'DQRK    ',      1,   0,-1,0.320,0.000D+00,0.5,
     & 'UQRK    ',      2,   0,+2,0.320,0.000D+00,0.5,
     & 'SQRK    ',      3,   0,-1,0.500,0.000D+00,0.5,
     & 'CQRK    ',      4,   0,+2,1.550,0.000D+00,0.5,
     & 'BQRK    ',      5,   0,-1,4.950,0.000D+00,0.5,
     & 'TQRK    ',      6,   0,+2,170.0,0.000D+00,0.5,
     & 'DBAR    ',     -1,   0,+1,0.320,0.000D+00,0.5,
     & 'UBAR    ',     -2,   0,-2,0.320,0.000D+00,0.5,
     & 'SBAR    ',     -3,   0,+1,0.500,0.000D+00,0.5,
     & 'CBAR    ',     -4,   0,-2,1.550,0.000D+00,0.5,
     & 'BBAR    ',     -5,   0,+1,4.950,0.000D+00,0.5,
     & 'TBAR    ',     -6,   0,-2,170.0,0.000D+00,0.5,
     & 'GLUON   ',     21,   0, 0,0.750,0.000D+00,1.0,
     & 'CMF     ',      0,   0, 0,0.000,0.000D+00,0.0,
     & 'HARD    ',      0,   0, 0,0.000,0.000D+00,0.0,
     & 'SOFT    ',      0,   0, 0,0.000,0.000D+00,0.0/
      DATA (RNAME(I),IDPDG(I),IFLAV(I),ICHRG(I),RMASS(I),RLTIM(I),
     &      RSPIN(I),I=17,32)/
     & 'CONE    ',      0,   0, 0,0.000,0.000D+00,0.0,
     & 'HEAVY   ',      0,   0, 0,0.000,0.000D+00,0.0,
     & 'CLUS    ',     91,   0, 0,0.000,0.000D+00,0.0,
     & '****    ',      0,   0, 0,0.000,0.000D+00,0.0,
     & 'PI0     ',    111,  11, 0,0.135,8.400D-17,0.0,
     & 'ETA     ',    221,  33, 0,0.547,0.000D+00,0.0,
     & 'RHO0    ',    113,  11, 0,0.770,0.000D+00,1.0,
     & 'OMEGA   ',    223,  33, 0,0.782,0.000D+00,1.0,
     & 'ETAP    ',    331,  33, 0,0.958,0.000D+00,0.0,
     & 'F_2     ',    225,  33, 0,1.275,0.000D+00,2.0,
     & 'A_10    ',  20113,  11, 0,1.230,0.000D+00,1.0,
     & 'FL_1    ',  20223,  33, 0,1.282,0.000D+00,1.0,
     & 'A_20    ',    115,  11, 0,1.318,0.000D+00,2.0,
     & 'PI-     ',   -211,  12,-1,0.140,2.603D-08,0.0,
     & 'RHO-    ',   -213,  12,-1,0.770,0.000D+00,1.0,
     & 'A_1-    ', -20213,  12,-1,1.230,0.000D+00,1.0/
      DATA (RNAME(I),IDPDG(I),IFLAV(I),ICHRG(I),RMASS(I),RLTIM(I),
     &      RSPIN(I),I=33,48)/
     & 'A_2-    ',   -215,  12,-1,1.318,0.000D+00,2.0,
     & 'K-      ',   -321,  32,-1,0.494,1.237D-08,0.0,
     & 'K*-     ',   -323,  32,-1,0.892,0.000D+00,1.0,
     & 'KH_1-   ', -20323,  32,-1,1.750,0.000D+00,1.0,
     & 'K*_2-   ',   -325,  32,-1,1.425,0.000D+00,2.0,
     & 'PI+     ',    211,  21,+1,0.140,2.603D-08,0.0,
     & 'RHO+    ',    213,  21,+1,0.770,0.000D+00,1.0,
     & 'A_1+    ',  20213,  21,+1,1.230,0.000D+00,1.0,
     & 'A_2+    ',    215,  21,+1,1.318,0.000D+00,2.0,
     & 'KBAR0   ',   -311,  31, 0,0.498,0.000D+00,0.0,
     & 'K*BAR0  ',   -313,  31, 0,0.896,0.000D+00,1.0,
     & 'KH_1BAR0', -20313,  31, 0,1.750,0.000D+00,1.0,
     & 'K*_2BAR0',   -315,  31, 0,1.432,0.000D+00,2.0,
     & 'K+      ',    321,  23,+1,0.494,1.237D-08,0.0,
     & 'K*+     ',    323,  23,+1,0.892,0.000D+00,1.0,
     & 'KH_1+   ',  20323,  23,+1,1.750,0.000D+00,1.0/
      DATA (RNAME(I),IDPDG(I),IFLAV(I),ICHRG(I),RMASS(I),RLTIM(I),
     &      RSPIN(I),I=49,64)/
     & 'K*_2+   ',    325,  23,+1,1.425,0.000D+00,2.0,
     & 'K0      ',    311,  13, 0,0.498,0.000D+00,0.0,
     & 'K*0     ',    313,  13, 0,0.896,0.000D+00,1.0,
     & 'KH_10   ',  20313,  13, 0,1.750,0.000D+00,1.0,
     & 'K*_20   ',    315,  13, 0,1.432,0.000D+00,2.0,
     & '        ',      0,   0, 0,0.000,0.000D+00,0.0,
     & '        ',      0,   0, 0,0.000,0.000D+00,0.0,
     & 'PHI     ',    333,  33, 0,1.019,0.000D+00,1.0,
     & 'FH_1    ',  20333,  33, 0,1.512,0.000D+00,1.0,
     & 'FP_2    ',    335,  33, 0,1.525,0.000D+00,2.0,
     & 'GAMMA   ',     22,   0, 0,0.000,1.000D+30,1.0,
     & 'K_S0    ',    310,   0, 0,0.498,8.926D-11,0.0,
     & 'K_L0    ',    130,   0, 0,0.498,5.170D-08,0.0,
     & '        ',      0,   0, 0,0.000,0.000D+00,0.0,
     & '        ',      0,   0, 0,0.000,0.000D+00,0.0,
     & '        ',      0,   0, 0,0.000,0.000D+00,0.0/
      DATA (RNAME(I),IDPDG(I),IFLAV(I),ICHRG(I),RMASS(I),RLTIM(I),
     &      RSPIN(I),I=65,80)/
     & '        ',      0,   0, 0,0.000,0.000D+00,0.0,
     & '        ',      0,   0, 0,0.000,0.000D+00,0.0,
     & '        ',      0,   0, 0,0.000,0.000D+00,0.0,
     & '        ',      0,   0, 0,0.000,0.000D+00,0.0,
     & '        ',      0,   0, 0,0.000,0.000D+00,0.0,
     & '        ',      0,   0, 0,0.000,0.000D+00,0.0,
     & 'REMG    ',   9998,   0, 0,0.000,0.000D+00,0.0,
     & 'REMN    ',   9999,   0, 0,0.000,0.000D+00,0.0,
     & 'P       ',   2212, 122,+1,0.938,1.000D+30,0.5,
     & 'DELTA+  ',   2214, 122,+1,1.232,0.000D+00,1.5,
     & 'N       ',   2112, 112, 0,0.940,8.870D+03,0.5,
     & 'DELTA0  ',   2114, 112, 0,1.232,0.000D+00,1.5,
     & 'DELTA-  ',   1114, 111,-1,1.232,0.000D+00,1.5,
     & 'LAMBDA  ',   3122, 123, 0,1.116,2.632D-10,0.5,
     & 'SIGMA0  ',   3212, 123, 0,1.192,7.400D-20,0.5,
     & 'SIGMA*0 ',   3214, 123, 0,1.384,0.000D+00,1.5/
      DATA (RNAME(I),IDPDG(I),IFLAV(I),ICHRG(I),RMASS(I),RLTIM(I),
     &      RSPIN(I),I=81,96)/
     & 'SIGMA-  ',   3112, 113,-1,1.197,1.479D-10,0.5,
     & 'SIGMA*- ',   3114, 113,-1,1.387,0.000D+00,1.5,
     & 'XI-     ',   3312, 133,-1,1.321,1.639D-10,0.5,
     & 'XI*-    ',   3314, 133,-1,1.535,0.000D+00,1.5,
     & 'DELTA++ ',   2224, 222,+2,1.232,0.000D+00,1.5,
     & 'SIGMA+  ',   3222, 223,+1,1.189,7.990D-11,0.5,
     & 'SIGMA*+ ',   3224, 223,+1,1.383,0.000D+00,1.5,
     & 'XI0     ',   3322, 233, 0,1.315,2.900D-10,0.5,
     & 'XI*0    ',   3324, 233, 0,1.532,0.000D+00,1.5,
     & 'OMEGA-  ',   3334, 333,-1,1.672,8.220D-11,1.5,
     & 'PBAR    ',  -2212,-122,-1,0.938,1.000D+30,0.5,
     & 'DELTABR-',  -2214,-122,-1,1.232,0.000D+00,1.5,
     & 'NBAR    ',  -2112,-112, 0,0.940,8.870D+03,0.5,
     & 'DELTABR0',  -2114,-112, 0,1.232,0.000D+00,1.5,
     & 'DELTABR+',  -1114,-111,+1,1.232,0.000D+00,1.5,
     & 'LAMBDABR',  -3122,-123, 0,1.116,2.632D-10,0.5/
      DATA (RNAME(I),IDPDG(I),IFLAV(I),ICHRG(I),RMASS(I),RLTIM(I),
     &      RSPIN(I),I=97,112)/
     & 'SIGMABR0',  -3212,-123, 0,1.192,7.400D-20,0.5,
     & 'SGMA*BR0',  -3214,-123, 0,1.384,0.000D+00,1.5,
     & 'SIGMABR+',  -3112,-113,+1,1.197,1.479D-10,0.5,
     & 'SGMA*BR+',  -3114,-113,+1,1.387,0.000D+00,1.5,
     & 'XIBAR+  ',  -3312,-133,+1,1.321,1.639D-10,0.5,
     & 'XI*BAR+ ',  -3314,-133,+1,1.535,0.000D+00,1.5,
     & 'DLTABR--',  -2224,-222,-2,1.232,0.000D+00,1.5,
     & 'SIGMABR-',  -3222,-223,-1,1.189,7.990D-11,0.5,
     & 'SGMA*BR-',  -3224,-223,-1,1.383,0.000D+00,1.5,
     & 'XIBAR0  ',  -3322,-233, 0,1.315,2.900D-10,0.5,
     & 'XI*BAR  ',  -3324,-233, 0,1.532,0.000D+00,1.5,
     & 'OMEGABR+',  -3334,-333,+1,1.672,8.220D-11,1.5,
     & 'UU      ',   2203,   0,+4,0.640,0.000D+00,0.0,
     & 'UD      ',   2101,   0,+1,0.640,0.000D+00,0.0,
     & 'DD      ',   1103,   0,-2,0.640,0.000D+00,0.0,
     & 'US      ',   3201,   0,+1,0.820,0.000D+00,0.0/
      DATA (RNAME(I),IDPDG(I),IFLAV(I),ICHRG(I),RMASS(I),RLTIM(I),
     &      RSPIN(I),I=113,128)/
     & 'DS      ',   3101,   0,-2,0.820,0.000D+00,0.0,
     & 'SS      ',   3303,   0,-2,1.000,0.000D+00,0.0,
     & 'UBARUBAR',  -2203,   0,-4,0.640,0.000D+00,0.0,
     & 'UBARDBAR',  -2101,   0,-1,0.640,0.000D+00,0.0,
     & 'DBARDBAR',  -1103,   0,+2,0.640,0.000D+00,0.0,
     & 'UBARSBAR',  -3201,   0,-1,0.820,0.000D+00,0.0,
     & 'DBARSBAR',  -3101,   0,+2,0.820,0.000D+00,0.0,
     & 'SBARSBAR',  -3303,   0,+2,1.000,0.000D+00,0.0,
     & 'E-      ',     11,   0,-1,0.001,1.000D+30,0.5,
     & 'NU_E    ',     12,   0, 0,0.000,1.000D+30,0.5,
     & 'MU-     ',     13,   0,-1,0.106,2.197D-06,0.5,
     & 'NU_MU   ',     14,   0, 0,0.000,1.000D+30,0.5,
     & 'TAU-    ',     15,   0,-1,1.777,2.916D-13,0.5,
     & 'NU_TAU  ',     16,   0, 0,0.000,1.000D+30,0.5,
     & 'E+      ',    -11,   0,+1,0.001,1.000D+30,0.5,
     & 'NU_EBAR ',    -12,   0, 0,0.000,1.000D+30,0.5/
      DATA (RNAME(I),IDPDG(I),IFLAV(I),ICHRG(I),RMASS(I),RLTIM(I),
     &      RSPIN(I),I=129,144)/
     & 'MU+     ',    -13,   0,+1,0.106,2.197D-06,0.5,
     & 'NU_MUBAR',    -14,   0, 0,0.000,1.000D+30,0.5,
     & 'TAU+    ',    -15,   0,+1,1.777,2.916D-13,0.5,
     & 'NU_TAUBR',    -16,   0, 0,0.000,1.000D+30,0.5,
     & '        ',      0,   0, 0,0.000,0.000D+00,0.0,
     & '        ',      0,   0, 0,0.000,0.000D+00,0.0,
     & '        ',      0,   0, 0,0.000,0.000D+00,0.0,
     & 'D+      ',    411,  41,+1,1.869,1.057D-12,0.0,
     & 'D*+     ',    413,  41,+1,2.010,0.000D+00,1.0,
     & 'DH_1+   ',  20413,  41,+1,2.426,0.000D+00,1.0,
     & 'D*_2+   ',    415,  41,+1,2.456,0.000D+00,2.0,
     & 'D0      ',    421,  42, 0,1.865,4.150D-13,0.0,
     & 'D*0     ',    423,  42, 0,2.007,0.000D+00,1.0,
     & 'DH_10   ',  20423,  42, 0,2.423,0.000D+00,1.0,
     & 'D*_20   ',    425,  42, 0,2.458,0.000D+00,2.0,
     & 'D_S+    ',    431,  43,+1,1.969,4.670D-13,0.0/
      DATA (RNAME(I),IDPDG(I),IFLAV(I),ICHRG(I),RMASS(I),RLTIM(I),
     &      RSPIN(I),I=145,160)/
     & 'D*_S+   ',    433,  43,+1,2.110,0.000D+00,1.0,
     & 'DH_S1+  ',  20433,  43,+1,2.535,0.000D+00,1.0,
     & 'D*_S2+  ',    435,  43,+1,2.573,0.000D+00,2.0,
     & 'SGMA_C++',   4222, 224,+2,2.453,0.000D+00,0.5,
     & 'SGM*_C++',   4224, 224,+2,2.530,0.000D+00,1.5,
     & 'LMBDA_C+',   4122, 124,+1,2.285,2.060D-13,0.5,
     & 'SIGMA_C+',   4212, 124,+1,2.454,0.000D+00,0.5,
     & 'SGMA*_C+',   4214, 124,+1,2.530,0.000D+00,1.5,
     & 'SIGMA_C0',   4112, 114, 0,2.452,0.000D+00,0.5,
     & 'SGMA*_C0',   4114, 114, 0,2.530,0.000D+00,1.5,
     & 'XI_C+   ',   4232, 234,+1,2.466,3.500D-13,0.5,
     & 'XIP_C+  ',   4322, 234,+1,2.575,0.000D+00,0.5,
     & 'XI*_C+  ',   4324, 234,+1,2.639,0.000D+00,1.5,
     & 'XI_C0   ',   4132, 134, 0,2.470,9.800D-14,0.5,
     & 'XIP_C0  ',   4312, 134, 0,2.580,0.000D+00,0.5,
     & 'XI*_C0  ',   4314, 134, 0,2.644,0.000D+00,1.5/
      DATA (RNAME(I),IDPDG(I),IFLAV(I),ICHRG(I),RMASS(I),RLTIM(I),
     &      RSPIN(I),I=161,176)/
     & 'OMEGA_C0',   4332, 334, 0,2.704,6.400D-14,0.5,
     & 'OMGA*_C0',   4334, 334, 0,2.730,0.000D+00,1.5,
     & 'ETA_C   ',    441,  44, 0,2.979,0.000D+00,0.0,
     & 'JPSI    ',    443,  44, 0,3.097,0.000D+00,1.0,
     & 'CHI_C1  ',  10441,  44, 0,3.415,0.000D+00,0.0,
     & 'PSI2S   ', 100443,  44, 0,3.686,0.000D+00,1.0,
     & 'PSID    ',  30443,  44, 0,3.770,0.000D+00,1.0,
     & '        ',      0,   0, 0,0.000,0.000D+00,0.0,
     & '        ',      0,   0, 0,0.000,0.000D+00,0.0,
     & '        ',      0,   0, 0,0.000,0.000D+00,0.0,
     & 'D-      ',   -411,  14,-1,1.869,1.057D-12,0.0,
     & 'D*-     ',   -413,  14,-1,2.010,0.000D+00,1.0,
     & 'DH_1-   ', -20413,  14,-1,2.426,0.000D+00,1.0,
     & 'D*_2-   ',   -415,  14,-1,2.456,0.000D+00,2.0,
     & 'DBAR0   ',   -421,  24, 0,1.865,4.140D-13,0.0,
     & 'D*BAR0  ',   -423,  24, 0,2.007,0.000D+00,1.0/
      DATA (RNAME(I),IDPDG(I),IFLAV(I),ICHRG(I),RMASS(I),RLTIM(I),
     &      RSPIN(I),I=177,192)/
     & 'DH_1BAR0', -20423,  24, 0,2.423,0.000D+00,1.0,
     & 'D*_2BAR0',   -425,  24, 0,2.458,0.000D+00,2.0,
     & 'D_S-    ',   -431,  34,-1,1.969,4.670D-13,0.0,
     & 'D*_S-   ',   -433,  34,-1,2.110,0.000D+00,1.0,
     & 'DH_S1-  ', -20433,  34,-1,2.535,0.000D+00,1.0,
     & 'D*_S2-  ',   -435,  34,-1,2.573,0.000D+00,2.0,
     & 'SGMA_C--',  -4222,-224,-2,2.453,0.000D+00,0.5,
     & 'SGM*_C--',  -4224,-224,-2,2.530,0.000D+00,1.5,
     & 'LMBDA_C-',  -4122,-124,-1,2.285,2.060D-13,0.5,
     & 'SIGMA_C-',  -4212,-124,-1,2.454,0.000D+00,0.5,
     & 'SGMA*_C-',  -4214,-124,-1,2.530,0.000D+00,1.5,
     & 'SGM_CBR0',  -4112,-114, 0,2.452,0.000D+00,0.5,
     & 'SG*_CBR0',  -4114,-114, 0,2.530,0.000D+00,1.5,
     & 'XI_C-   ',  -4232,-234,-1,2.466,3.500D-13,0.5,
     & 'XIP_C-  ',  -4322,-234,-1,2.575,0.000D+00,0.5,
     & 'XI*_C-  ',  -4324,-234,-1,2.639,0.000D+00,1.5/
      DATA (RNAME(I),IDPDG(I),IFLAV(I),ICHRG(I),RMASS(I),RLTIM(I),
     &      RSPIN(I),I=193,208)/
     & 'XI_CBAR0',  -4132,-134, 0,2.470,9.800D-14,0.5,
     & 'XIP_CBR0',  -4312,-134, 0,2.580,0.000D+00,0.5,
     & 'XI*_CBR0',  -4314,-134, 0,2.644,0.000D+00,1.5,
     & 'OMG_CBR0',  -4332,-334, 0,2.704,6.400D-14,0.5,
     & 'OM*_CBR0',  -4334,-334, 0,2.730,0.000D+00,1.5,
     & 'W+      ',     24,   0,+1,80.22,0.000D+00,1.0,
     & 'W-      ',    -24,   0,-1,80.22,0.000D+00,1.0,
     & 'Z0/GAMA*',     23,   0, 0,91.19,0.000D+00,1.0,
     & 'HIGGS   ',     25,   0, 0,150.0,0.000D+00,0.0,
     & 'Z0P     ',     32,   0, 0,500.0,0.000D+00,1.0,
     & '        ',      0,   0, 0,0.000,0.000D+00,0.0,
     & '        ',      0,   0, 0,0.000,0.000D+00,0.0,
     & '        ',      0,   0, 0,0.000,0.000D+00,0.0,
     & '        ',      0,   0, 0,0.000,0.000D+00,0.0,
     & '        ',      0,   0, 0,0.000,0.000D+00,0.0,
     & '        ',      0,   0, 0,0.000,0.000D+00,0.0/
      DATA (RNAME(I),IDPDG(I),IFLAV(I),ICHRG(I),RMASS(I),RLTIM(I),
     &      RSPIN(I),I=209,224)/
     & 'VQRK    ',      7,   0,-1,200.0,0.000D+00,0.5,
     & 'AQRK    ',      8,   0,+2,400.0,0.000D+00,0.5,
     & 'HQRK    ',      7,   0,-1,400.0,0.000D+00,0.5,
     & 'HPQK    ',      8,   0,+2,600.0,0.000D+00,0.5,
     & '        ',      0,   0, 0,0.000,0.000D+00,0.0,
     & '        ',      0,   0, 0,0.000,0.000D+00,0.0,
     & 'VBAR    ',     -7,   0,+1,200.0,0.000D+00,0.5,
     & 'ABAR    ',     -8,   0,-2,400.0,0.000D+00,0.5,
     & 'HBAR    ',     -7,   0,+1,400.0,0.000D+00,0.5,
     & 'HPBR    ',     -8,   0,-2,600.0,0.000D+00,0.5,
     & '        ',      0,   0, 0,0.000,0.000D+00,0.0,
     & '        ',      0,   0, 0,0.000,0.000D+00,0.0,
     & 'B_DBAR0 ',   -511,  51, 0,5.279,1.614D-12,0.0,
     & 'B-      ',   -521,  52,-1,5.278,1.652D-12,0.0,
     & 'B_SBAR0 ',   -531,  53, 0,5.375,1.540D-12,0.0,
     & 'SIGMA_B+',   5222, 225,+1,5.820,1.070D-12,0.5/
      DATA (RNAME(I),IDPDG(I),IFLAV(I),ICHRG(I),RMASS(I),RLTIM(I),
     &      RSPIN(I),I=225,240)/
     & 'LMBDA_B0',   5122, 125, 0,5.641,1.070D-12,0.5,
     & 'SIGMA_B-',   5112, 115,-1,5.820,1.070D-12,0.5,
     & 'XI_B0   ',   5232, 235, 0,5.800,1.070D-12,0.5,
     & 'XI_B-   ',   5132, 135,-1,5.800,1.070D-12,0.5,
     & 'OMEGA_B-',   5332, 335,-1,6.040,1.070D-12,0.5,
     & 'B_C-    ',   -541,  54,-1,6.250,1.000D-12,0.5,
     & 'UPSLON1S',    553,  55, 0,9.460,0.000D+00,1.0,
     & 'T_B-    ',   -651,  56,-1,0.000,0.000D+00,0.0,
     & 'T+      ',    611,  61,+1,0.000,0.000D+00,0.0,
     & 'T0      ',    621,  62, 0,0.000,0.000D+00,0.0,
     & 'T_S+    ',    631,  63,+1,0.000,0.000D+00,0.0,
     & 'SGMA_T++',   6222, 226,+2,0.000,0.000D+00,0.5,
     & 'LMBDA_T0',   6122, 126,+1,0.000,0.000D+00,0.5,
     & 'SIGMA_T0',   6112, 116, 0,0.000,0.000D+00,0.5,
     & 'XI_T+   ',   6232, 236,+1,0.000,0.000D+00,0.5,
     & 'XI_T0   ',   6132, 136, 0,0.000,0.000D+00,0.5/
      DATA (RNAME(I),IDPDG(I),IFLAV(I),ICHRG(I),RMASS(I),RLTIM(I),
     &      RSPIN(I),I=241,256)/
     & 'OMEGA_T0',   6332, 336, 0,0.000,0.000D+00,0.5,
     & 'T_C0    ',    641,  64, 0,0.000,0.000D+00,0.0,
     & 'T_B+    ',    651,  65,+1,0.000,0.000D+00,0.0,
     & 'TOPONIUM',    663,  66, 0,0.000,0.000D+00,1.0,
     & 'B_D0    ',    511,  15, 0,5.279,1.614D-12,0.0,
     & 'B+      ',    521,  25,+1,5.278,1.652D-12,0.0,
     & 'B_S0    ',    531,  35, 0,5.375,1.540D-12,0.0,
     & 'SGM_BBR-',  -5222,-225,-1,5.820,1.070D-12,0.5,
     & 'LMD_BBR0',  -5122,-125, 0,5.641,1.070D-12,0.5,
     & 'SGM_BBR+',  -5112,-115,+1,5.820,1.070D-12,0.5,
     & 'XI_BBAR0',  -5232,-235, 0,5.800,1.070D-12,0.5,
     & 'XI_B+   ',  -5132,-135,+1,5.800,1.070D-12,0.5,
     & 'OMG_BBR+',  -5332,-335,+1,6.040,1.070D-12,0.5,
     & 'B_C+    ',    541,  45,+1,6.250,1.000D-12,0.5,
     & 'T-      ',   -611,  16,-1,0.000,0.000D+00,0.0,
     & 'TBAR0   ',   -621,  26, 0,0.000,0.000D+00,0.0/
      DATA (RNAME(I),IDPDG(I),IFLAV(I),ICHRG(I),RMASS(I),RLTIM(I),
     &      RSPIN(I),I=257,272)/
     & 'T_S-    ',   -631,  36,-1,0.000,0.000D+00,0.0,
     & 'SGMA_T--',  -6222,-226,-2,0.000,0.000D+00,0.5,
     & 'LAMDA_T-',  -6122,-126,-1,0.000,0.000D+00,0.5,
     & 'SGM_TBR0',  -6112,-116, 0,0.000,0.000D+00,0.5,
     & 'XI_T-   ',  -6232,-236,-1,0.000,0.000D+00,0.5,
     & 'XI_TBAR0',  -6132,-136, 0,0.000,0.000D+00,0.5,
     & 'OMG_TBR0',  -6332,-336, 0,0.000,0.000D+00,0.5,
     & 'T_CBAR0 ',   -641,  46, 0,0.000,0.000D+00,0.0,
     & 'B*BAR0  ',   -513,  51, 0,5.325,0.000D+00,1.0,
     & 'B*-     ',   -523,  52,-1,5.325,0.000D+00,1.0,
     & 'B*_SBAR0',   -533,  53, 0,5.422,0.000D+00,1.0,
     & 'BH_1BAR0', -20513,  51, 0,5.760,0.000D+00,1.0,
     & 'BH_1-   ', -20523,  52,-1,5.760,0.000D+00,1.0,
     & 'BH_S1BR0', -20533,  53, 0,5.855,0.000D+00,1.0,
     & 'B*_2BAR0',   -515,  51, 0,5.770,0.000D+00,2.0,
     & 'B*_2-   ',   -525,  52,-1,5.770,0.000D+00,2.0/
      DATA (RNAME(I),IDPDG(I),IFLAV(I),ICHRG(I),RMASS(I),RLTIM(I),
     &      RSPIN(I),I=273,288)/
     & 'B*_S2BR0',   -535,  53, 0,5.865,0.000D+00,2.0,
     & 'B*0     ',    513,  15, 0,5.325,0.000D+00,1.0,
     & 'B*+     ',    523,  25,+1,5.325,0.000D+00,1.0,
     & 'B*_S0   ',    533,  35, 0,5.422,0.000D+00,1.0,
     & 'BH_10   ',  20513,  15, 0,5.760,0.000D+00,1.0,
     & 'BH_1+   ',  20523,  25,+1,5.760,0.000D+00,1.0,
     & 'BH_S10  ',  20533,  35, 0,5.855,0.000D+00,1.0,
     & 'B*_20   ',    515,  15, 0,5.770,0.000D+00,2.0,
     & 'B*_2+   ',    525,  25,+1,5.770,0.000D+00,2.0,
     & 'B*_S20  ',    535,  35, 0,5.865,0.000D+00,2.0,
     & '        ',      0,   0, 0,0.000,0.000D+00,  0,
     & '        ',      0,   0, 0,0.000,0.000D+00,  0,
     & 'B_10    ',  10113,  11, 0,1.231,0.000D+00,1.0,
     & 'B_1+    ',  10213,  21,+1,1.231,0.000D+00,1.0,
     & 'B_1-    ', -10213,  12,-1,1.231,0.000D+00,1.0,
     & 'HL_10   ',  10223,  33, 0,1.170,0.000D+00,1.0/
      DATA (RNAME(I),IDPDG(I),IFLAV(I),ICHRG(I),RMASS(I),RLTIM(I),
     &      RSPIN(I),I=289,304)/
     & 'HH_10   ',  10333,  33, 0,1.395,0.000D+00,1.0,
     & 'A_00    ',  10111,  11, 0,0.996,0.000D+00,0.0,
     & 'A_0+    ',  10211,  21,+1,0.996,0.000D+00,0.0,
     & 'A_0-    ', -10211,  12,-1,0.996,0.000D+00,0.0,
     & 'F0P0    ',  10221,  33, 0,0.996,0.000D+00,0.0,
     & 'FH_00   ',  10331,  33, 0,1.250,0.000D+00,0.0,
     & 'B*_C+   ',    543,  45,+1,6.295,0.000D+00,1.0,
     & 'B*_C-   ',   -543,  54,-1,6.295,0.000D+00,1.0,
     & 'BH_C1+  ',  20543,  45,+1,6.730,0.000D+00,1.0,
     & 'BH_C1-  ', -20543,  54,-1,6.730,0.000D+00,1.0,
     & 'B*_C2+  ',    545,  45,+1,6.740,0.000D+00,2.0,
     & 'B*_C2-  ',   -545,  54,-1,6.740,0.000D+00,2.0,
     & 'H_C     ',  10443,  44, 0,3.526,0.000D+00,1.0,
     & 'CHI_C0  ',  20443,  44, 0,3.415,0.000D+00,0.0,
     & 'CHI_C2  ',    445,  44, 0,3.556,0.000D+00,2.0,
     & 'ETA_B   ',    551,  55, 0,9.000,0.000D+00,0.0/
      DATA (RNAME(I),IDPDG(I),IFLAV(I),ICHRG(I),RMASS(I),RLTIM(I),
     &      RSPIN(I),I=305,320)/
     & 'H_B     ',  10553,  55, 0,9.888,0.000D+00,1.0,
     & 'CHI_B0  ',  10551,  55, 0,9.860,0.000D+00,0.0,
     & 'CHI_B1  ',  20553,  55, 0,9.892,0.000D+00,1.0,
     & 'CHI_B2  ',    555,  55, 0,9.913,0.000D+00,2.0,
     & 'KL_10   ',  10313,  13, 0,1.570,0.000D+00,1.0,
     & 'KL_1+   ',  10323,  23,+1,1.570,0.000D+00,1.0,
     & 'KL_1BAR0', -10313,  31, 0,1.570,0.000D+00,1.0,
     & 'KL_1-   ', -10323,  32,-1,1.570,0.000D+00,1.0,
     & 'DL_1+   ',  10413,  41,+1,2.425,0.000D+00,1.0,
     & 'DL_10   ',  10423,  42, 0,2.423,0.000D+00,1.0,
     & 'DL_S1+  ',  10433,  43,+1,2.535,0.000D+00,1.0,
     & 'DL_1-   ', -10413,  14,-1,2.425,0.000D+00,1.0,
     & 'DL_1BAR0', -10423,  24, 0,2.423,0.000D+00,1.0,
     & 'DL_S1-  ', -10433,  34,-1,2.535,0.000D+00,1.0,
     & 'BL_10   ',  10513,  15, 0,5.760,0.000D+00,1.0,
     & 'BL_1+   ',  10523,  25,+1,5.760,0.000D+00,1.0/
      DATA (RNAME(I),IDPDG(I),IFLAV(I),ICHRG(I),RMASS(I),RLTIM(I),
     &      RSPIN(I),I=321,336)/
     & 'BL_S10  ',  10533,  35, 0,5.855,0.000D+00,1.0,
     & 'BL_C1+  ',  10543,  45,+1,6.730,0.000D+00,1.0,
     & 'BL_1BAR0', -10513,  51, 0,5.760,0.000D+00,1.0,
     & 'BL_1-   ', -10523,  52,-1,5.760,0.000D+00,1.0,
     & 'BL_S1BR0', -10533,  53, 0,5.855,0.000D+00,1.0,
     & 'BL_C1-  ', -10543,  54,-1,6.730,0.000D+00,1.0,
     & 'K*_0+   ',  10321,  23,+1,1.429,0.000D+00,0.0,
     & 'K*_00   ',  10311,  13, 0,1.429,0.000D+00,0.0,
     & 'K*_0BAR0', -10311,  31, 0,1.429,0.000D+00,0.0,
     & 'K*_0-   ', -10321,  32,-1,1.429,0.000D+00,0.0,
     & 'D*_0+   ',  10411,  41,+1,2.423,0.000D+00,0.0,
     & 'D*_00   ',  10421,  42, 0,2.423,0.000D+00,0.0,
     & 'D*_S0+  ',  10431,  43,+1,2.525,0.000D+00,0.0,
     & 'D*_0-   ', -10411,  14,-1,2.423,0.000D+00,0.0,
     & 'D*_0BAR0', -10421,  24, 0,2.423,0.000D+00,0.0,
     & 'D*_S0-  ', -10431,  34,-1,2.525,0.000D+00,0.0/
      DATA (RNAME(I),IDPDG(I),IFLAV(I),ICHRG(I),RMASS(I),RLTIM(I),
     &      RSPIN(I),I=337,352)/
     & 'B*_00   ',  10511,  15, 0,5.760,0.000D+00,0.0,
     & 'B*_0+   ',  10521,  25,+1,5.760,0.000D+00,0.0,
     & 'B*_S00  ',  10531,  35, 0,5.855,0.000D+00,0.0,
     & 'B*_C0+  ',  10541,  45,+1,6.730,0.000D+00,0.0,
     & 'B*_0BAR0', -10511,  51, 0,5.760,0.000D+00,0.0,
     & 'B*_0-   ', -10521,  52,-1,5.760,0.000D+00,0.0,
     & 'B*_S0BR0', -10531,  53, 0,5.855,0.000D+00,0.0,
     & 'B*_C0-  ', -10541,  54,-1,6.730,0.000D+00,0.0,
     & 'SGMA*_B-',   5114, 115,-1,5.840,0.000D+00,1.5,
     & 'SIGMA_B0',   5212, 125, 0,5.820,0.000D+00,0.5,
     & 'SGMA*_B0',   5214, 125, 0,5.840,0.000D+00,1.5,
     & 'SGMA*_B+',   5224, 225,+1,5.840,0.000D+00,1.5,
     & 'XIP_B0  ',   5322, 235, 0,5.945,0.000D+00,0.5,
     & 'XI*_B0  ',   5324, 235, 0,5.945,0.000D+00,1.5,
     & 'XIP_B-  ',   5312, 135,-1,5.945,0.000D+00,0.5,
     & 'XI*_B-  ',   5314, 135,-1,5.945,0.000D+00,1.5/
      DATA (RNAME(I),IDPDG(I),IFLAV(I),ICHRG(I),RMASS(I),RLTIM(I),
     &      RSPIN(I),I=353,368)/
     & '0MGA*_B-',   5334, 335,-1,6.060,0.000D+00,1.5,
     & 'SG*_BBR+',  -5114,-115,+1,5.840,0.000D+00,1.5,
     & 'SGM_BBR0',  -5212,-125, 0,5.820,0.000D+00,0.5,
     & 'SG*_BBR0',  -5214,-125, 0,5.840,0.000D+00,1.5,
     & 'SG*_BBR-',  -5224,-225,-1,5.840,0.000D+00,1.5,
     & 'XIP_BBR0',  -5322,-235, 0,5.945,0.000D+00,0.5,
     & 'XI*_BBR0',  -5324,-235, 0,5.945,0.000D+00,1.5,
     & 'XIP_B+  ',  -5312,-135,+1,5.945,0.000D+00,0.5,
     & 'XI*_B+  ',  -5314,-135,+1,5.945,0.000D+00,1.5,
     & '0MGA*_B+',  -5334,-335,+1,6.060,0.000D+00,1.5,
     & 'KDL_2+  ',  10325,  23,+1,1.773,0.000D+00,2.0,
     & 'KDL_20  ',  10315,  13, 0,1.773,0.000D+00,2.0,
     & 'KDL_2BR0', -10315,  31, 0,1.773,0.000D+00,2.0,
     & 'KDL_2-  ', -10325,  32,-1,1.773,0.000D+00,2.0,
     & 'KD*+    ',  30323,  23,+1,1.714,0.000D+00,1.0,
     & 'KD*0    ',  30313,  13, 0,1.714,0.000D+00,1.0/
      DATA (RNAME(I),IDPDG(I),IFLAV(I),ICHRG(I),RMASS(I),RLTIM(I),
     &      RSPIN(I),I=369,384)/
     & 'KD*BAR0 ', -30313,  31, 0,1.714,0.000D+00,1.0,
     & 'KD*-    ', -30323,  32,-1,1.714,0.000D+00,1.0,
     & 'KDH_2+  ',  20325,  23,+1,1.816,0.000D+00,2.0,
     & 'KDH_20  ',  20315,  13, 0,1.816,0.000D+00,2.0,
     & 'KDH_2BR0', -20315,  31, 0,1.816,0.000D+00,2.0,
     & 'KDH_2-  ', -20325,  32,-1,1.816,0.000D+00,2.0,
     & 'KD_3+   ',    327,  23,+1,1.770,0.000D+00,3.0,
     & 'KD_30   ',    317,  13, 0,1.770,0.000D+00,3.0,
     & 'KD_3BAR0',   -317,  31, 0,1.770,0.000D+00,3.0,
     & 'KD_3-   ',   -327,  32,-1,1.770,0.000D+00,3.0,
     & 'PI_2+   ',  10215,  21,+1,1.670,0.000D+00,2.0,
     & 'PI_20   ',  10115,  11, 0,1.670,0.000D+00,2.0,
     & 'PI_2-   ', -10215,  12,-1,1.670,0.000D+00,2.0,
     & 'RHOD+   ',  30213,  21,+1,1.700,0.000D+00,1.0,
     & 'RHOD0   ',  30113,  11, 0,1.700,0.000D+00,1.0,
     & 'RHOD-   ', -30213,  12,-1,1.700,0.000D+00,1.0/
      DATA (RNAME(I),IDPDG(I),IFLAV(I),ICHRG(I),RMASS(I),RLTIM(I),
     &      RSPIN(I),I=385,NLAST)/
     & 'RHO_3+  ',    217,  21,+1,1.691,0.000D+00,3.0,
     & 'RHO_30  ',    117,  11, 0,1.691,0.000D+00,3.0,
     & 'RHO_3-  ',   -217,  12,-1,1.691,0.000D+00,3.0,
     & 'UPSLON2S', 100553,  55, 0,10.023,0.000D+00,1.0,
     & 'CHI2P_B0', 110551,  55, 0,10.232,0.000D+00,0.0,
     & 'CHI2P_B1', 120553,  55, 0,10.255,0.000D+00,1.0,
     & 'CHI2P_B2', 100555,  55, 0,10.269,0.000D+00,2.0,
     & 'UPSLON3S', 200553,  55, 0,10.355,0.000D+00,1.0,
     & 'UPSLON4S', 300553,  55, 0,10.580,0.000D+00,1.0/
C
      DATA (RNAME(I),I=NNEXT,NMXRES)/NLEFT*'        '/
      DATA (IDPDG(I),I=NNEXT,NMXRES)/NLEFT*0/
      DATA (IFLAV(I),I=NNEXT,NMXRES)/NLEFT*0/
      DATA (RMASS(I),I=NNEXT,NMXRES)/NLEFT*0.000/
      DATA (RLTIM(I),I=NNEXT,NMXRES)/NLEFT*0.000D+00/
      DATA (RSPIN(I),I=NNEXT,NMXRES)/NLEFT*0.0/
C
      DATA (RSTAB(I),I=1,NMXRES)/NMXRES*.FALSE./
      DATA DKPSET/.FALSE./
C
      DATA NDKYS/2226/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=   1,  19)/
     &   6,0.340,100,  2,  7,  5,  0,  0,
     &   6,0.330,100,  4,  9,  5,  0,  0,
     &   6,0.110,100,122,127,  5,  0,  0,
     &   6,0.110,100,124,129,  5,  0,  0,
     &   6,0.110,100,126,131,  5,  0,  0,
     &  12,0.340,100,  8,  1, 11,  0,  0,
     &  12,0.330,100, 10,  3, 11,  0,  0,
     &  12,0.110,100,128,121, 11,  0,  0,
     &  12,0.110,100,130,123, 11,  0,  0,
     &  12,0.110,100,132,125, 11,  0,  0,
     &  21,0.988,  0, 59, 59,  0,  0,  0,
     &  21,0.012,  0,127,121, 59,  0,  0,
     &  22,0.388,  0, 59, 59,  0,  0,  0,
     &  22,0.319,  0, 21, 21, 21,  0,  0,
     &  22,0.001,  0, 21, 59, 59,  0,  0,
     &  22,0.236,  0, 38, 30, 21,  0,  0,
     &  22,0.049,  0, 38, 30, 59,  0,  0,
     &  22,0.005,  0,127,121, 59,  0,  0,
     &  22,0.002,  0, 38, 30,127,121,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=  20,  38)/
     &  23,0.989,  0, 38, 30,  0,  0,  0,
     &  23,0.010,  0, 38, 30, 59,  0,  0,
     &  23,0.001,  0, 21, 59,  0,  0,  0,
     &  24,0.888,  0, 38, 30, 21,  0,  0,
     &  24,0.085,  0, 21, 59,  0,  0,  0,
     &  24,0.022,  0, 38, 30,  0,  0,  0,
     &  24,0.001,  0, 22, 59,  0,  0,  0,
     &  24,0.001,  0, 21,127,121,  0,  0,
     &  24,0.003,  0, 38, 30, 21, 21,  0,
     &  25,0.437,  0, 38, 30, 22,  0,  0,
     &  25,0.302,  0, 23, 59,  0,  0,  0,
     &  25,0.208,  0, 21, 21, 22,  0,  0,
     &  25,0.030,  0, 24, 59,  0,  0,  0,
     &  25,0.021,  0, 59, 59,  0,  0,  0,
     &  25,0.002,  0, 21, 21, 21,  0,  0,
     &  26,0.566,  0, 38, 30,  0,  0,  0,
     &  26,0.283,  0, 21, 21,  0,  0,  0,
     &  26,0.069,  0, 38, 30, 21, 21,  0,
     &  26,0.023,  0, 46, 34,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=  39,  57)/
     &  26,0.023,  0, 50, 42,  0,  0,  0,
     &  26,0.028,  0, 38, 38, 30, 30,  0,
     &  26,0.005,  0, 22, 22,  0,  0,  0,
     &  26,0.003,  0, 21, 21, 21, 21,  0,
     &  27,0.499,  0, 39, 30,  0,  0,  0,
     &  27,0.499,  0, 31, 38,  0,  0,  0,
     &  27,0.002,  0, 21, 59, 59,  0,  0,
     &  28,0.148,  0, 21, 21, 38, 30,  0,
     &  28,0.148,  0, 23, 38, 30,  0,  0,
     &  28,0.147,  0,291, 30,  0,  0,  0,
     &  28,0.147,  0,290, 21,  0,  0,  0,
     &  28,0.147,  0,292, 38,  0,  0,  0,
     &  28,0.067,  0, 22, 38, 30,  0,  0,
     &  28,0.033,  0, 22, 21, 21,  0,  0,
     &  28,0.032,  0, 46, 42, 30,  0,  0,
     &  28,0.016,  0, 46, 34, 21,  0,  0,
     &  28,0.016,  0, 50, 42, 21,  0,  0,
     &  28,0.032,  0, 50, 34, 38,  0,  0,
     &  28,0.066,  0, 59, 23,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=  58,  76)/
     &  28,0.001,  0, 56, 59,  0,  0,  0,
     &  29,0.349,  0, 39, 30,  0,  0,  0,
     &  29,0.349,  0, 31, 38,  0,  0,  0,
     &  29,0.144,  0, 22, 21,  0,  0,  0,
     &  29,0.104,  0, 24, 38, 30,  0,  0,
     &  29,0.024,  0, 46, 34,  0,  0,  0,
     &  29,0.024,  0, 50, 42,  0,  0,  0,
     &  29,0.006,  0, 25, 21,  0,  0,  0,
     &  30,1.000,  0,123,130,  0,  0,  0,
     &  31,1.000,  0, 30, 21,  0,  0,  0,
     &  32,0.499,  0, 31, 21,  0,  0,  0,
     &  32,0.499,  0, 23, 30,  0,  0,  0,
     &  32,0.002,  0, 30, 59,  0,  0,  0,
     &  33,0.349,  0, 31, 21,  0,  0,  0,
     &  33,0.349,  0, 23, 30,  0,  0,  0,
     &  33,0.144,  0, 22, 30,  0,  0,  0,
     &  33,0.101,  0, 24, 30, 21,  0,  0,
     &  33,0.048,  0, 50, 34,  0,  0,  0,
     &  33,0.006,  0, 25, 30,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=  77,  95)/
     &  33,0.003,  0, 30, 59,  0,  0,  0,
     &  34,0.629,  0,123,130,  0,  0,  0,
     &  34,0.212,  0, 30, 21,  0,  0,  0,
     &  34,0.056,  0, 30, 38, 30,  0,  0,
     &  34,0.017,  0, 30, 21, 21,  0,  0,
     &  34,0.048,101,121,128, 21,  0,  0,
     &  34,0.032,101,123,130, 21,  0,  0,
     &  34,0.006,  0,123,130, 59,  0,  0,
     &  35,0.666,  0, 42, 30,  0,  0,  0,
     &  35,0.333,  0, 34, 21,  0,  0,  0,
     &  35,0.001,  0, 34, 59,  0,  0,  0,
     &  36,0.627,  0, 43, 30,  0,  0,  0,
     &  36,0.313,  0, 35, 21,  0,  0,  0,
     &  36,0.020,  0, 42, 31,  0,  0,  0,
     &  36,0.010,  0, 34, 23,  0,  0,  0,
     &  36,0.020,  0, 34,294,  0,  0,  0,
     &  36,0.010,  0, 34, 24,  0,  0,  0,
     &  37,0.331,  0, 42, 30,  0,  0,  0,
     &  37,0.166,  0, 34, 21,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=  96, 114)/
     &  37,0.168,  0, 43, 30,  0,  0,  0,
     &  37,0.084,  0, 35, 21,  0,  0,  0,
     &  37,0.087,  0, 35, 38, 30,  0,  0,
     &  37,0.044,  0, 35, 21, 21,  0,  0,
     &  37,0.059,  0, 42, 31,  0,  0,  0,
     &  37,0.029,  0, 34, 23,  0,  0,  0,
     &  37,0.029,  0, 34, 24,  0,  0,  0,
     &  37,0.002,  0, 34, 59,  0,  0,  0,
     &  37,0.001,  0, 34, 22,  0,  0,  0,
     &  38,1.000,  0,129,124,  0,  0,  0,
     &  39,1.000,  0, 38, 21,  0,  0,  0,
     &  40,0.499,  0, 39, 21,  0,  0,  0,
     &  40,0.499,  0, 23, 38,  0,  0,  0,
     &  40,0.002,  0, 38, 59,  0,  0,  0,
     &  41,0.349,  0, 39, 21,  0,  0,  0,
     &  41,0.349,  0, 23, 38,  0,  0,  0,
     &  41,0.144,  0, 22, 38,  0,  0,  0,
     &  41,0.101,  0, 24, 38, 21,  0,  0,
     &  41,0.048,  0, 46, 42,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 115, 133)/
     &  41,0.006,  0, 25, 38,  0,  0,  0,
     &  41,0.003,  0, 38, 59,  0,  0,  0,
     &  42,0.500,  0, 60,  0,  0,  0,  0,
     &  42,0.500,  0, 61,  0,  0,  0,  0,
     &  43,0.665,  0, 34, 38,  0,  0,  0,
     &  43,0.333,  0, 42, 21,  0,  0,  0,
     &  43,0.002,  0, 42, 59,  0,  0,  0,
     &  44,0.627,  0, 35, 38,  0,  0,  0,
     &  44,0.313,  0, 43, 21,  0,  0,  0,
     &  44,0.020,  0, 34, 39,  0,  0,  0,
     &  44,0.010,  0, 42, 23,  0,  0,  0,
     &  44,0.020,  0, 42,294,  0,  0,  0,
     &  44,0.010,  0, 42, 24,  0,  0,  0,
     &  45,0.331,  0, 34, 38,  0,  0,  0,
     &  45,0.166,  0, 42, 21,  0,  0,  0,
     &  45,0.168,  0, 35, 38,  0,  0,  0,
     &  45,0.084,  0, 43, 21,  0,  0,  0,
     &  45,0.089,  0, 42, 38, 30,  0,  0,
     &  45,0.044,  0, 42, 21, 21,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 134, 152)/
     &  45,0.059,  0, 34, 39,  0,  0,  0,
     &  45,0.029,  0, 42, 23,  0,  0,  0,
     &  45,0.029,  0, 42, 24,  0,  0,  0,
     &  45,0.001,  0, 42, 22,  0,  0,  0,
     &  46,0.629,  0,129,124,  0,  0,  0,
     &  46,0.212,  0, 38, 21,  0,  0,  0,
     &  46,0.056,  0, 38, 38, 30,  0,  0,
     &  46,0.017,  0, 38, 21, 21,  0,  0,
     &  46,0.032,101,129,124, 21,  0,  0,
     &  46,0.048,101,127,122, 21,  0,  0,
     &  46,0.006,  0,129,124, 59,  0,  0,
     &  47,0.666,  0, 50, 38,  0,  0,  0,
     &  47,0.333,  0, 46, 21,  0,  0,  0,
     &  47,0.001,  0, 46, 59,  0,  0,  0,
     &  48,0.627,  0, 51, 38,  0,  0,  0,
     &  48,0.313,  0, 47, 21,  0,  0,  0,
     &  48,0.020,  0, 50, 39,  0,  0,  0,
     &  48,0.010,  0, 46, 23,  0,  0,  0,
     &  48,0.020,  0, 46,294,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 153, 171)/
     &  48,0.010,  0, 46, 24,  0,  0,  0,
     &  49,0.331,  0, 50, 38,  0,  0,  0,
     &  49,0.166,  0, 46, 21,  0,  0,  0,
     &  49,0.168,  0, 51, 38,  0,  0,  0,
     &  49,0.084,  0, 47, 21,  0,  0,  0,
     &  49,0.087,  0, 47, 38, 30,  0,  0,
     &  49,0.044,  0, 47, 21, 21,  0,  0,
     &  49,0.059,  0, 50, 39,  0,  0,  0,
     &  49,0.029,  0, 46, 23,  0,  0,  0,
     &  49,0.029,  0, 46, 24,  0,  0,  0,
     &  49,0.002,  0, 46, 59,  0,  0,  0,
     &  49,0.001,  0, 46, 22,  0,  0,  0,
     &  50,0.500,  0, 60,  0,  0,  0,  0,
     &  50,0.500,  0, 61,  0,  0,  0,  0,
     &  51,0.665,  0, 46, 30,  0,  0,  0,
     &  51,0.333,  0, 50, 21,  0,  0,  0,
     &  51,0.002,  0, 50, 59,  0,  0,  0,
     &  52,0.627,  0, 47, 30,  0,  0,  0,
     &  52,0.313,  0, 51, 21,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 172, 190)/
     &  52,0.020,  0, 46, 31,  0,  0,  0,
     &  52,0.010,  0, 50, 23,  0,  0,  0,
     &  52,0.020,  0, 50,294,  0,  0,  0,
     &  52,0.010,  0, 50, 24,  0,  0,  0,
     &  53,0.331,  0, 46, 30,  0,  0,  0,
     &  53,0.166,  0, 50, 21,  0,  0,  0,
     &  53,0.168,  0, 47, 30,  0,  0,  0,
     &  53,0.084,  0, 51, 21,  0,  0,  0,
     &  53,0.089,  0, 50, 38, 30,  0,  0,
     &  53,0.044,  0, 50, 21, 21,  0,  0,
     &  53,0.059,  0, 46, 31,  0,  0,  0,
     &  53,0.029,  0, 50, 23,  0,  0,  0,
     &  53,0.029,  0, 50, 24,  0,  0,  0,
     &  53,0.001,  0, 50, 22,  0,  0,  0,
     &  56,0.490,  0, 46, 34,  0,  0,  0,
     &  56,0.342,  0, 61, 60,  0,  0,  0,
     &  56,0.043,  0, 39, 30,  0,  0,  0,
     &  56,0.043,  0, 23, 21,  0,  0,  0,
     &  56,0.043,  0, 31, 38,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 191, 209)/
     &  56,0.025,  0, 38, 30, 21,  0,  0,
     &  56,0.013,  0, 22, 59,  0,  0,  0,
     &  56,0.001,  0, 21, 59,  0,  0,  0,
     &  57,0.250,  0, 50, 43,  0,  0,  0,
     &  57,0.250,  0, 34, 47,  0,  0,  0,
     &  57,0.250,  0, 42, 51,  0,  0,  0,
     &  57,0.250,  0, 46, 35,  0,  0,  0,
     &  58,0.356,  0, 46, 34,  0,  0,  0,
     &  58,0.356,  0, 50, 42,  0,  0,  0,
     &  58,0.279,  0, 22, 22,  0,  0,  0,
     &  58,0.006,  0, 38, 30,  0,  0,  0,
     &  58,0.003,  0, 21, 21,  0,  0,  0,
     &  60,0.684,  0, 38, 30,  0,  0,  0,
     &  60,0.314,  0, 21, 21,  0,  0,  0,
     &  60,0.002,  0, 38, 30, 59,  0,  0,
     &  61,0.216,  0, 21, 21, 21,  0,  0,
     &  61,0.124,  0, 38, 30, 21,  0,  0,
     &  61,0.135,101,123,130, 38,  0,  0,
     &  61,0.135,101,124,129, 30,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 210, 228)/
     &  61,0.187,101,121,128, 38,  0,  0,
     &  61,0.187,101,122,127, 30,  0,  0,
     &  61,0.006,  0,121,128, 38, 59,  0,
     &  61,0.006,  0,122,127, 30, 59,  0,
     &  61,0.002,  0, 38, 30,  0,  0,  0,
     &  61,0.001,  0, 21, 21,  0,  0,  0,
     &  61,0.001,  0, 59, 59,  0,  0,  0,
     &  74,0.663,  0, 73, 21,  0,  0,  0,
     &  74,0.331,  0, 75, 38,  0,  0,  0,
     &  74,0.006,  0, 73, 59,  0,  0,  0,
     &  75,1.000,101,121,128, 73,  0,  0,
     &  76,0.663,  0, 75, 21,  0,  0,  0,
     &  76,0.331,  0, 73, 30,  0,  0,  0,
     &  76,0.006,  0, 75, 59,  0,  0,  0,
     &  77,1.000,  0, 75, 30,  0,  0,  0,
     &  78,0.638,  0, 73, 30,  0,  0,  0,
     &  78,0.358,  0, 75, 21,  0,  0,  0,
     &  78,0.002,  0, 75, 59,  0,  0,  0,
     &  78,0.001,  0, 73, 30, 59,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 229, 247)/
     &  78,0.001,101,121,128, 73,  0,  0,
     &  79,0.995,  0, 78, 59,  0,  0,  0,
     &  79,0.005,  0, 78,127,121,  0,  0,
     &  80,0.880,  0, 78, 21,  0,  0,  0,
     &  80,0.060,  0, 86, 30,  0,  0,  0,
     &  80,0.060,  0, 81, 38,  0,  0,  0,
     &  81,0.998,  0, 75, 30,  0,  0,  0,
     &  81,0.001,  0, 75, 30, 59,  0,  0,
     &  81,0.001,101,121,128, 75,  0,  0,
     &  82,0.880,  0, 78, 30,  0,  0,  0,
     &  82,0.060,  0, 79, 30,  0,  0,  0,
     &  82,0.060,  0, 81, 21,  0,  0,  0,
     &  83,0.999,  0, 78, 30,  0,  0,  0,
     &  83,0.001,101,121,128, 78,  0,  0,
     &  84,0.667,  0, 88, 30,  0,  0,  0,
     &  84,0.333,  0, 83, 21,  0,  0,  0,
     &  85,1.000,  0, 73, 38,  0,  0,  0,
     &  86,0.516,  0, 73, 21,  0,  0,  0,
     &  86,0.483,  0, 75, 38,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 248, 266)/
     &  86,0.001,  0, 73, 59,  0,  0,  0,
     &  87,0.880,  0, 78, 38,  0,  0,  0,
     &  87,0.060,  0, 86, 21,  0,  0,  0,
     &  87,0.060,  0, 79, 38,  0,  0,  0,
     &  88,0.995,  0, 78, 21,  0,  0,  0,
     &  88,0.001,  0, 78, 59,  0,  0,  0,
     &  88,0.004,  0, 79, 59,  0,  0,  0,
     &  89,0.667,  0, 83, 38,  0,  0,  0,
     &  89,0.333,  0, 88, 21,  0,  0,  0,
     &  90,0.675,  0, 78, 34,  0,  0,  0,
     &  90,0.233,  0, 88, 30,  0,  0,  0,
     &  90,0.086,  0, 83, 21,  0,  0,  0,
     &  90,0.006,101,121,128, 88,  0,  0,
     &  92,0.663,  0, 91, 21,  0,  0,  0,
     &  92,0.331,  0, 93, 30,  0,  0,  0,
     &  92,0.006,  0, 91, 59,  0,  0,  0,
     &  93,1.000,101,127,122, 91,  0,  0,
     &  94,0.663,  0, 93, 21,  0,  0,  0,
     &  94,0.331,  0, 91, 38,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 267, 285)/
     &  94,0.006,  0, 93, 59,  0,  0,  0,
     &  95,1.000,  0, 93, 38,  0,  0,  0,
     &  96,0.638,  0, 91, 38,  0,  0,  0,
     &  96,0.358,  0, 93, 21,  0,  0,  0,
     &  96,0.002,  0, 93, 59,  0,  0,  0,
     &  96,0.001,  0, 91, 38, 59,  0,  0,
     &  96,0.001,101,127,122, 91,  0,  0,
     &  97,0.995,  0, 96, 59,  0,  0,  0,
     &  97,0.005,  0, 96,127,121,  0,  0,
     &  98,0.880,  0, 96, 21,  0,  0,  0,
     &  98,0.060,  0,104, 38,  0,  0,  0,
     &  98,0.060,  0, 99, 30,  0,  0,  0,
     &  99,0.998,  0, 93, 38,  0,  0,  0,
     &  99,0.001,  0, 93, 38, 59,  0,  0,
     &  99,0.001,101,127,122, 93,  0,  0,
     & 100,0.880,  0, 96, 38,  0,  0,  0,
     & 100,0.060,  0, 97, 38,  0,  0,  0,
     & 100,0.060,  0, 99, 21,  0,  0,  0,
     & 101,0.999,  0, 96, 38,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 286, 304)/
     & 101,0.001,101,127,122, 96,  0,  0,
     & 102,0.667,  0,106, 38,  0,  0,  0,
     & 102,0.333,  0,101, 21,  0,  0,  0,
     & 103,1.000,  0, 91, 30,  0,  0,  0,
     & 104,0.516,  0, 91, 21,  0,  0,  0,
     & 104,0.483,  0, 93, 30,  0,  0,  0,
     & 104,0.001,  0, 91, 59,  0,  0,  0,
     & 105,0.880,  0, 96, 30,  0,  0,  0,
     & 105,0.060,  0,104, 21,  0,  0,  0,
     & 105,0.060,  0, 97, 30,  0,  0,  0,
     & 106,0.995,  0, 96, 21,  0,  0,  0,
     & 106,0.001,  0, 96, 59,  0,  0,  0,
     & 106,0.004,  0, 97, 59,  0,  0,  0,
     & 107,0.667,  0,101, 30,  0,  0,  0,
     & 107,0.333,  0,106, 21,  0,  0,  0,
     & 108,0.675,  0, 96, 46,  0,  0,  0,
     & 108,0.233,  0,106, 38,  0,  0,  0,
     & 108,0.086,  0,101, 21,  0,  0,  0,
     & 108,0.006,101,127,122,106,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 305, 323)/
     & 123,0.986,100,121,128,124,  0,  0,
     & 123,0.014,  0,121,128,124, 59,  0,
     & 125,0.178,100,121,128,126,  0,  0,
     & 125,0.171,100,123,130,126,  0,  0,
     & 125,0.002,  0,123,130, 59,126,  0,
     & 125,0.111,  0, 30,126,  0,  0,  0,
     & 125,0.253,  0, 31,126,  0,  0,  0,
     & 125,0.181,  0, 32,126,  0,  0,  0,
     & 125,0.002,  0, 30, 22, 21,126,  0,
     & 125,0.018,  0, 30, 24,126,  0,  0,
     & 125,0.004,  0, 30, 24, 21,126,  0,
     & 125,0.015,  0, 31, 23,126,  0,  0,
     & 125,0.001,  0, 31, 24, 21,126,  0,
     & 125,0.024,  0, 32, 21,126,  0,  0,
     & 125,0.002,  0, 32, 38, 30,126,  0,
     & 125,0.007,  0, 34,126,  0,  0,  0,
     & 125,0.014,  0, 35,126,  0,  0,  0,
     & 125,0.003,  0, 35, 21,126,  0,  0,
     & 125,0.001,  0, 34, 38, 30,126,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 324, 342)/
     & 125,0.004,  0, 30, 43,126,  0,  0,
     & 125,0.003,  0, 34, 50,126,  0,  0,
     & 125,0.003,  0, 34, 51,126,  0,  0,
     & 125,0.003,  0, 30, 50, 42,126,  0,
     & 129,0.986,100,127,122,130,  0,  0,
     & 129,0.014,  0,127,122,130, 59,  0,
     & 131,0.178,100,127,122,132,  0,  0,
     & 131,0.171,100,129,124,132,  0,  0,
     & 131,0.002,  0,129,124, 59,132,  0,
     & 131,0.111,  0, 38,132,  0,  0,  0,
     & 131,0.253,  0, 39,132,  0,  0,  0,
     & 131,0.181,  0, 40,132,  0,  0,  0,
     & 131,0.002,  0, 38, 22, 21,132,  0,
     & 131,0.018,  0, 38, 24,132,  0,  0,
     & 131,0.004,  0, 38, 24, 21,132,  0,
     & 131,0.015,  0, 39, 23,132,  0,  0,
     & 131,0.001,  0, 39, 24, 21,132,  0,
     & 131,0.024,  0, 40, 21,132,  0,  0,
     & 131,0.002,  0, 40, 38, 30,132,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 343, 361)/
     & 131,0.007,  0, 46,132,  0,  0,  0,
     & 131,0.014,  0, 47,132,  0,  0,  0,
     & 131,0.003,  0, 47, 21,132,  0,  0,
     & 131,0.001,  0, 46, 38, 30,132,  0,
     & 131,0.004,  0, 38, 51,132,  0,  0,
     & 131,0.003,  0, 46, 42,132,  0,  0,
     & 131,0.003,  0, 46, 43,132,  0,  0,
     & 131,0.003,  0, 38, 50, 42,132,  0,
     & 136,0.067,101,122,127, 42,  0,  0,
     & 136,0.067,101,124,129, 42,  0,  0,
     & 136,0.048,101,122,127, 43,  0,  0,
     & 136,0.048,101,124,129, 43,  0,  0,
     & 136,0.003,  0, 34, 38,122,127,  0,
     & 136,0.003,  0, 34, 38,124,129,  0,
     & 136,0.006,101,122,127, 21,  0,  0,
     & 136,0.006,101,124,129, 21,  0,  0,
     & 136,0.002,101,122,127, 23,  0,  0,
     & 136,0.002,101,124,129, 23,  0,  0,
     & 136,0.055,  0, 34, 38, 38,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 362, 380)/
     & 136,0.031,  0, 34, 39, 38,  0,  0,
     & 136,0.042,  0, 34, 38, 38, 21, 21,
     & 136,0.002,  0, 34, 38, 38, 38, 31,
     & 136,0.021,  0, 35, 38, 38,  0,  0,
     & 136,0.027,  0, 42, 38,  0,  0,  0,
     & 136,0.066,  0, 42, 39,  0,  0,  0,
     & 136,0.081,  0, 42, 40,  0,  0,  0,
     & 136,0.024,  0, 42, 38, 21,  0,  0,
     & 136,0.004,  0, 42, 38, 23,  0,  0,
     & 136,0.069,  0, 42, 38, 38, 30, 21,
     & 136,0.001,  0, 42, 38, 38, 30, 23,
     & 136,0.022,  0, 43, 38,  0,  0,  0,
     & 136,0.021,  0, 43, 39,  0,  0,  0,
     & 136,0.042,  0, 43, 38, 21,  0,  0,
     & 136,0.008,  0, 43, 38, 23,  0,  0,
     & 136,0.010,  0, 43, 38, 38, 30,  0,
     & 136,0.050,  0,311, 38,  0,  0,  0,
     & 136,0.034,  0,329, 38,  0,  0,  0,
     & 136,0.010,  0,369, 38,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 381, 399)/
     & 136,0.031,  0, 46, 42, 42,  0,  0,
     & 136,0.003,  0, 38, 21,  0,  0,  0,
     & 136,0.001,  0, 38, 23,  0,  0,  0,
     & 136,0.002,  0, 38, 38, 30,  0,  0,
     & 136,0.008,  0, 38, 22,  0,  0,  0,
     & 136,0.001,  0, 38, 38, 38, 30, 30,
     & 136,0.003,  0, 38, 38, 38, 30, 31,
     & 136,0.008,  0, 46, 42,  0,  0,  0,
     & 136,0.005,  0, 46, 43,  0,  0,  0,
     & 136,0.026,  0, 47, 43,  0,  0,  0,
     & 136,0.005,  0, 46, 34, 38,  0,  0,
     & 136,0.007,  0, 38, 56,  0,  0,  0,
     & 136,0.023,  0, 38, 56, 21,  0,  0,
     & 136,0.005,  0, 46, 46, 34,  0,  0,
     & 137,0.683,  0,140, 38,  0,  0,  0,
     & 137,0.306,  0,136, 21,  0,  0,  0,
     & 137,0.011,  0,136, 59,  0,  0,  0,
     & 138,0.667,  0,141, 38,  0,  0,  0,
     & 138,0.333,  0,137, 21,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 400, 418)/
     & 139,0.220,  0,140, 38,  0,  0,  0,
     & 139,0.110,  0,136, 21,  0,  0,  0,
     & 139,0.380,  0,141, 38,  0,  0,  0,
     & 139,0.190,  0,137, 21,  0,  0,  0,
     & 139,0.004,  0,136, 22,  0,  0,  0,
     & 139,0.064,  0,141, 38, 21,  0,  0,
     & 139,0.032,  0,137, 38, 30,  0,  0,
     & 140,0.037,101,122,127, 34,  0,  0,
     & 140,0.037,101,124,129, 34,  0,  0,
     & 140,0.016,101,122,127, 35,  0,  0,
     & 140,0.016,101,124,129, 35,  0,  0,
     & 140,0.013,  0, 34, 21,122,127,  0,
     & 140,0.013,  0, 34, 21,124,129,  0,
     & 140,0.012,  0, 42, 30,122,127,  0,
     & 140,0.012,  0, 42, 30,124,129,  0,
     & 140,0.003,101,122,127, 30,  0,  0,
     & 140,0.003,101,124,129, 30,  0,  0,
     & 140,0.039,  0, 34, 38,  0,  0,  0,
     & 140,0.091,  0, 34, 39,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 419, 437)/
     & 140,0.067,  0, 34, 40,  0,  0,  0,
     & 140,0.004,  0, 34, 38, 21,  0,  0,
     & 140,0.100,  0, 34, 38, 21, 21,  0,
     & 140,0.058,  0, 34, 38, 23,  0,  0,
     & 140,0.020,  0, 34, 38, 24,  0,  0,
     & 140,0.006,  0, 34, 38, 25,  0,  0,
     & 140,0.043,  0, 35, 38,  0,  0,  0,
     & 140,0.035,  0, 35, 39,  0,  0,  0,
     & 140,0.007,  0,312, 38,  0,  0,  0,
     & 140,0.007,  0,330, 38,  0,  0,  0,
     & 140,0.020,  0, 42, 21,  0,  0,  0,
     & 140,0.006,  0, 42, 22,  0,  0,  0,
     & 140,0.009,  0, 42, 23,  0,  0,  0,
     & 140,0.016,  0, 42, 24,  0,  0,  0,
     & 140,0.014,  0, 42, 25,  0,  0,  0,
     & 140,0.003,  0, 42,293,  0,  0,  0,
     & 140,0.007,  0, 42, 56,  0,  0,  0,
     & 140,0.003,  0, 42, 26,  0,  0,  0,
     & 140,0.004,  0, 42,294,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 438, 456)/
     & 140,0.006,  0, 42, 21, 21,  0,  0,
     & 140,0.042,  0, 42, 38, 30, 21,  0,
     & 140,0.004,  0, 42, 38, 38, 30, 30,
     & 140,0.076,  0, 42, 38, 30, 21, 21,
     & 140,0.026,  0, 43, 21,  0,  0,  0,
     & 140,0.014,  0, 43, 22,  0,  0,  0,
     & 140,0.014,  0, 43, 23,  0,  0,  0,
     & 140,0.011,  0, 43, 24,  0,  0,  0,
     & 140,0.018,  0, 43, 38, 30,  0,  0,
     & 140,0.004,  0, 42, 46, 34,  0,  0,
     & 140,0.004,  0, 42, 46, 34, 21,  0,
     & 140,0.005,  0, 42, 42, 50,  0,  0,
     & 140,0.002,  0, 38, 30,  0,  0,  0,
     & 140,0.001,  0, 21, 21,  0,  0,  0,
     & 140,0.008,  0, 38, 30, 21,  0,  0,
     & 140,0.007,  0, 38, 38, 30, 30,  0,
     & 140,0.015,  0, 38, 38, 30, 30, 21,
     & 140,0.004,  0, 46, 34,  0,  0,  0,
     & 140,0.003,  0, 47, 34,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 457, 475)/
     & 140,0.002,  0, 46, 35,  0,  0,  0,
     & 140,0.001,  0, 50, 42,  0,  0,  0,
     & 140,0.002,  0, 51, 43,  0,  0,  0,
     & 140,0.003,  0, 50, 34, 38,  0,  0,
     & 140,0.003,  0, 42, 46, 30,  0,  0,
     & 140,0.001,  0, 46, 34, 38, 30, 21,
     & 140,0.002,  0, 56, 23,  0,  0,  0,
     & 140,0.001,  0, 56, 38, 30,  0,  0,
     & 141,0.636,  0,140, 21,  0,  0,  0,
     & 141,0.364,  0,140, 59,  0,  0,  0,
     & 142,0.667,  0,137, 30,  0,  0,  0,
     & 142,0.333,  0,141, 21,  0,  0,  0,
     & 143,0.220,  0,136, 30,  0,  0,  0,
     & 143,0.110,  0,140, 21,  0,  0,  0,
     & 143,0.380,  0,137, 30,  0,  0,  0,
     & 143,0.190,  0,141, 21,  0,  0,  0,
     & 143,0.004,  0,140, 22,  0,  0,  0,
     & 143,0.064,  0,137, 30, 21,  0,  0,
     & 143,0.032,  0,141, 38, 30,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 476, 494)/
     & 144,0.009,  0,124,129,  0,  0,  0,
     & 144,0.019,101,122,127, 56,  0,  0,
     & 144,0.019,101,124,129, 56,  0,  0,
     & 144,0.025,101,122,127, 22,  0,  0,
     & 144,0.025,101,124,129, 22,  0,  0,
     & 144,0.009,101,122,127, 25,  0,  0,
     & 144,0.009,101,124,129, 25,  0,  0,
     & 144,0.036,  0, 46, 42,  0,  0,  0,
     & 144,0.034,  0, 46, 43,  0,  0,  0,
     & 144,0.007,  0, 46,329,  0,  0,  0,
     & 144,0.043,  0, 47, 42,  0,  0,  0,
     & 144,0.058,  0, 47, 43,  0,  0,  0,
     & 144,0.011,  0, 46, 34, 38,  0,  0,
     & 144,0.055,  0, 46, 34, 38, 21,  0,
     & 144,0.003,  0, 46, 34, 38, 38, 30,
     & 144,0.014,  0, 46, 42, 38, 30,  0,
     & 144,0.017,  0, 50, 34, 38, 38,  0,
     & 144,0.036,  0, 56, 38,  0,  0,  0,
     & 144,0.067,  0, 56, 39,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 495, 513)/
     & 144,0.023,  0, 56, 38, 21,  0,  0,
     & 144,0.018,  0, 56, 38, 38, 30,  0,
     & 144,0.020,  0, 22, 38,  0,  0,  0,
     & 144,0.001,  0, 23, 38,  0,  0,  0,
     & 144,0.009,  0, 24, 38,  0,  0,  0,
     & 144,0.049,  0, 25, 38,  0,  0,  0,
     & 144,0.011,  0,293, 38,  0,  0,  0,
     & 144,0.015,  0, 22, 38, 21,  0,  0,
     & 144,0.016,  0, 25, 38, 21,  0,  0,
     & 144,0.103,  0, 22, 39,  0,  0,  0,
     & 144,0.120,  0, 25, 39,  0,  0,  0,
     & 144,0.010,  0, 38, 38, 30,  0,  0,
     & 144,0.046,  0, 38, 38, 30, 21,  0,
     & 144,0.003,  0, 38, 38, 38, 30, 30,
     & 144,0.042,  0, 38, 30, 30, 38, 39,
     & 144,0.001,  0, 46, 23,  0,  0,  0,
     & 144,0.005,  0, 46, 38, 30,  0,  0,
     & 144,0.001,  0, 46, 56,  0,  0,  0,
     & 144,0.004,  0, 50, 38,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 514, 532)/
     & 144,0.007,  0, 51, 38,  0,  0,  0,
     & 145,0.900,  0,144, 59,  0,  0,  0,
     & 145,0.100,  0,144, 21,  0,  0,  0,
     & 146,0.500,  0,137, 50,  0,  0,  0,
     & 146,0.500,  0,141, 46,  0,  0,  0,
     & 147,0.440,  0,136, 50,  0,  0,  0,
     & 147,0.440,  0,140, 46,  0,  0,  0,
     & 147,0.055,  0,137, 50,  0,  0,  0,
     & 147,0.055,  0,141, 46,  0,  0,  0,
     & 147,0.010,  0,144, 22,  0,  0,  0,
     & 148,1.000,  0,150, 38,  0,  0,  0,
     & 149,1.000,  0,150, 38,  0,  0,  0,
     & 150,0.028,101,122,127, 78,  0,  0,
     & 150,0.010,101,122,127, 80,  0,  0,
     & 150,0.028,101,124,129, 78,  0,  0,
     & 150,0.010,101,124,129, 80,  0,  0,
     & 150,0.026,  0, 73, 42,  0,  0,  0,
     & 150,0.030,  0, 73, 42, 21,  0,  0,
     & 150,0.029,  0, 73, 42, 38, 30,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 533, 551)/
     & 150,0.014,  0, 73, 42, 22,  0,  0,
     & 150,0.020,  0, 73, 43,  0,  0,  0,
     & 150,0.029,  0, 73, 34, 38,  0,  0,
     & 150,0.039,  0, 73, 34, 38, 21,  0,
     & 150,0.002,  0, 73, 34, 38, 38, 30,
     & 150,0.010,  0, 73, 34, 38, 21, 21,
     & 150,0.014,  0, 73, 35, 38,  0,  0,
     & 150,0.010,  0, 74, 42,  0,  0,  0,
     & 150,0.020,  0, 74, 43,  0,  0,  0,
     & 150,0.010,  0, 74, 43, 21,  0,  0,
     & 150,0.007,  0, 85, 34,  0,  0,  0,
     & 150,0.014,  0, 85, 35,  0,  0,  0,
     & 150,0.004,  0, 73,293,  0,  0,  0,
     & 150,0.003,  0, 73, 38, 30,  0,  0,
     & 150,0.003,  0, 73, 38, 30, 38, 30,
     & 150,0.001,  0, 73, 56,  0,  0,  0,
     & 150,0.002,  0, 73, 46, 34,  0,  0,
     & 150,0.010,  0, 78, 38,  0,  0,  0,
     & 150,0.020,  0, 78, 39,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 552, 570)/
     & 150,0.030,  0, 78, 38, 21,  0,  0,
     & 150,0.010,  0, 78, 38, 22,  0,  0,
     & 150,0.020,  0, 78, 38, 24,  0,  0,
     & 150,0.035,  0, 78, 38, 38, 30,  0,
     & 150,0.020,  0, 78, 38, 21, 21,  0,
     & 150,0.010,  0, 78, 38, 38, 30, 21,
     & 150,0.010,  0, 78, 38, 21, 21, 21,
     & 150,0.007,  0, 78, 46, 42,  0,  0,
     & 150,0.011,  0, 79, 38,  0,  0,  0,
     & 150,0.022,  0, 79, 38, 21,  0,  0,
     & 150,0.013,  0, 79, 38, 38, 30,  0,
     & 150,0.010,  0, 79, 38, 21, 21,  0,
     & 150,0.007,  0, 79, 38, 38, 30, 21,
     & 150,0.005,  0, 79, 38, 21, 21, 21,
     & 150,0.005,  0, 80, 38,  0,  0,  0,
     & 150,0.015,  0, 80, 39,  0,  0,  0,
     & 150,0.011,  0, 86, 21,  0,  0,  0,
     & 150,0.007,  0, 86, 22,  0,  0,  0,
     & 150,0.010,  0, 86, 23,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 571, 589)/
     & 150,0.031,  0, 86, 24,  0,  0,  0,
     & 150,0.010,  0, 86, 25,  0,  0,  0,
     & 150,0.004,  0, 86, 56,  0,  0,  0,
     & 150,0.026,  0, 86, 38, 30,  0,  0,
     & 150,0.005,  0, 86, 38, 38, 30, 30,
     & 150,0.005,  0, 86, 38, 30, 21, 21,
     & 150,0.005,  0, 87, 21,  0,  0,  0,
     & 150,0.006,  0, 87, 23,  0,  0,  0,
     & 150,0.004,  0, 86, 46, 34,  0,  0,
     & 150,0.002,  0, 86, 46, 30,  0,  0,
     & 150,0.001,  0, 86, 46, 30, 21,  0,
     & 150,0.016,  0, 81, 38, 38,  0,  0,
     & 150,0.003,  0, 88, 46,  0,  0,  0,
     & 150,0.002,  0, 89, 46,  0,  0,  0,
     & 150,0.003,  0, 83, 46, 38,  0,  0,
     & 150,0.040,  0, 75, 46, 21,  0,  0,
     & 150,0.040,  0, 75, 46, 38, 30,  0,
     & 150,0.020,  0, 75, 46, 21, 21,  0,
     & 150,0.010,  0, 75, 46, 38, 30, 21/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 590, 608)/
     & 150,0.010,  0, 75, 46, 21, 21, 21,
     & 150,0.020,  0, 75, 47, 21,  0,  0,
     & 150,0.040,  0, 75, 42, 38,  0,  0,
     & 150,0.020,  0, 75, 42, 39,  0,  0,
     & 150,0.010,  0, 75, 42, 38, 38, 30,
     & 150,0.010,  0, 75, 42, 38, 21, 21,
     & 150,0.006,  0, 75, 43, 38,  0,  0,
     & 151,1.000,  0,150, 21,  0,  0,  0,
     & 152,1.000,  0,150, 21,  0,  0,  0,
     & 153,1.000,  0,150, 30,  0,  0,  0,
     & 154,1.000,  0,150, 30,  0,  0,  0,
     & 155,0.045,101,122,127, 88,  0,  0,
     & 155,0.005,101,122,127, 89,  0,  0,
     & 155,0.045,101,124,129, 88,  0,  0,
     & 155,0.005,101,124,129, 89,  0,  0,
     & 155,0.021,  0, 86, 42,  0,  0,  0,
     & 155,0.032,  0, 87, 42,  0,  0,  0,
     & 155,0.032,  0, 79, 38, 42,  0,  0,
     & 155,0.045,  0, 86, 43,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 609, 627)/
     & 155,0.065,  0, 87, 43,  0,  0,  0,
     & 155,0.065,  0, 79, 38, 43,  0,  0,
     & 155,0.055,  0, 88, 38,  0,  0,  0,
     & 155,0.160,  0, 88, 39,  0,  0,  0,
     & 155,0.105,  0, 89, 38,  0,  0,  0,
     & 155,0.320,  0, 89, 39,  0,  0,  0,
     & 156,1.000,  0,155, 59,  0,  0,  0,
     & 157,0.667,  0,158, 38,  0,  0,  0,
     & 157,0.333,  0,155, 21,  0,  0,  0,
     & 158,0.045,101,122,127, 83,  0,  0,
     & 158,0.045,101,124,129, 83,  0,  0,
     & 158,0.005,101,122,127, 84,  0,  0,
     & 158,0.005,101,124,129, 84,  0,  0,
     & 158,0.020,  0, 79, 42,  0,  0,  0,
     & 158,0.020,  0, 79, 21, 42,  0,  0,
     & 158,0.020,  0, 80, 42,  0,  0,  0,
     & 158,0.060,  0, 79, 43,  0,  0,  0,
     & 158,0.060,  0, 79, 21, 43,  0,  0,
     & 158,0.060,  0, 80, 43,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 628, 646)/
     & 158,0.020,  0, 86, 34,  0,  0,  0,
     & 158,0.060,  0, 86, 35,  0,  0,  0,
     & 158,0.040,  0, 87, 34,  0,  0,  0,
     & 158,0.120,  0, 87, 35,  0,  0,  0,
     & 158,0.020,  0, 83, 38,  0,  0,  0,
     & 158,0.060,  0, 83, 39,  0,  0,  0,
     & 158,0.040,  0, 84, 38,  0,  0,  0,
     & 158,0.120,  0, 84, 39,  0,  0,  0,
     & 158,0.010,  0, 88, 21,  0,  0,  0,
     & 158,0.030,  0, 88, 23,  0,  0,  0,
     & 158,0.020,  0, 89, 21,  0,  0,  0,
     & 158,0.060,  0, 89, 23,  0,  0,  0,
     & 158,0.030,  0, 88, 56,  0,  0,  0,
     & 158,0.030,  0, 90, 46,  0,  0,  0,
     & 159,1.000,  0,158, 59,  0,  0,  0,
     & 160,0.670,  0,155, 30,  0,  0,  0,
     & 160,0.330,  0,158, 21,  0,  0,  0,
     & 161,0.050,101,122,127, 90,  0,  0,
     & 161,0.050,101,124,129, 90,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 647, 665)/
     & 161,0.075,  0, 88, 42,  0,  0,  0,
     & 161,0.225,  0, 88, 43,  0,  0,  0,
     & 161,0.150,  0, 89, 42,  0,  0,  0,
     & 161,0.450,  0, 89, 43,  0,  0,  0,
     & 162,1.000,  0,161, 59,  0,  0,  0,
     & 163,0.028,  0, 25, 38, 30,  0,  0,
     & 163,0.014,  0, 25, 21, 21,  0,  0,
     & 163,0.018,  0, 39, 31,  0,  0,  0,
     & 163,0.009,  0, 23, 23,  0,  0,  0,
     & 163,0.010,  0, 51, 34, 38,  0,  0,
     & 163,0.010,  0, 43, 47, 30,  0,  0,
     & 163,0.004,  0, 51, 43,  0,  0,  0,
     & 163,0.004,  0, 47, 35,  0,  0,  0,
     & 163,0.007,  0, 56, 56,  0,  0,  0,
     & 163,0.022,  0, 46, 42, 30,  0,  0,
     & 163,0.011,  0, 46, 34, 21,  0,  0,
     & 163,0.011,  0, 50, 42, 21,  0,  0,
     & 163,0.022,  0, 50, 34, 38,  0,  0,
     & 163,0.032,  0, 22, 38, 30,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 666, 684)/
     & 163,0.016,  0, 22, 21, 21,  0,  0,
     & 163,0.020,  0, 38, 30, 46, 34,  0,
     & 163,0.012,  0, 38, 30, 38, 30,  0,
     & 163,0.001,  0, 73, 91,  0,  0,  0,
     & 163,0.001,  0, 59, 59,  0,  0,  0,
     & 163,0.748,  0, 13, 13,  0,  0,  0,
     & 164,0.060,  0,121,127,  0,  0,  0,
     & 164,0.060,  0,123,129,  0,  0,  0,
     & 164,0.004,  0, 39, 30,  0,  0,  0,
     & 164,0.004,  0, 23, 21,  0,  0,  0,
     & 164,0.004,  0, 31, 38,  0,  0,  0,
     & 164,0.003,  0, 41, 31,  0,  0,  0,
     & 164,0.003,  0, 29, 23,  0,  0,  0,
     & 164,0.003,  0, 33, 39,  0,  0,  0,
     & 164,0.009,  0, 24, 38, 38, 30, 30,
     & 164,0.007,  0, 24, 38, 30,  0,  0,
     & 164,0.003,  0, 51, 45,  0,  0,  0,
     & 164,0.003,  0, 43, 53,  0,  0,  0,
     & 164,0.003,  0, 24, 51, 42,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 685, 703)/
     & 164,0.003,  0, 24, 43, 50,  0,  0,
     & 164,0.004,  0, 24, 26,  0,  0,  0,
     & 164,0.003,  0, 46, 35,  0,  0,  0,
     & 164,0.003,  0, 34, 47,  0,  0,  0,
     & 164,0.002,  0, 50, 43,  0,  0,  0,
     & 164,0.002,  0, 42, 51,  0,  0,  0,
     & 164,0.003,  0, 24, 21, 21,  0,  0,
     & 164,0.002,  0,286, 30,  0,  0,  0,
     & 164,0.002,  0,287, 38,  0,  0,  0,
     & 164,0.003,  0, 24, 46, 42, 30,  0,
     & 164,0.003,  0, 24, 34, 50, 38,  0,
     & 164,0.002,  0,285, 21,  0,  0,  0,
     & 164,0.001,  0, 56, 51, 42,  0,  0,
     & 164,0.001,  0, 56, 43, 50,  0,  0,
     & 164,0.001,  0, 24, 50, 42,  0,  0,
     & 164,0.001,  0, 24, 46, 34,  0,  0,
     & 164,0.002,  0, 56, 38, 30, 38, 30,
     & 164,0.002,  0, 85, 91, 30,  0,  0,
     & 164,0.002,  0,103, 73, 38,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 704, 722)/
     & 164,0.002,  0, 24, 22,  0,  0,  0,
     & 164,0.001,  0, 56, 50, 42,  0,  0,
     & 164,0.001,  0, 56, 46, 34,  0,  0,
     & 164,0.001,  0, 73, 91, 24,  0,  0,
     & 164,0.001,  0, 85,103,  0,  0,  0,
     & 164,0.001,  0, 82,100,  0,  0,  0,
     & 164,0.001,  0, 87,105,  0,  0,  0,
     & 164,0.001,  0, 73, 91, 25,  0,  0,
     & 164,0.001,  0, 56, 58,  0,  0,  0,
     & 164,0.001,  0, 56, 38, 30,  0,  0,
     & 164,0.001,  0, 56, 46, 42, 30,  0,
     & 164,0.001,  0, 56, 34, 50, 38,  0,
     & 164,0.001,  0, 56, 22,  0,  0,  0,
     & 164,0.001,  0, 84,102,  0,  0,  0,
     & 164,0.001,  0, 73, 34, 98,  0,  0,
     & 164,0.001,  0, 91, 46, 80,  0,  0,
     & 164,0.034,  0, 38, 38, 30, 30, 21,
     & 164,0.029,  0, 23, 23, 23, 21,  0,
     & 164,0.015,  0, 38, 30, 21,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 723, 741)/
     & 164,0.012,  0, 38, 30, 21, 34, 46,
     & 164,0.009,  0, 23, 23, 23, 24,  0,
     & 164,0.007,  0, 38, 30, 34, 46,  0,
     & 164,0.002,  0, 46, 42, 30,  0,  0,
     & 164,0.001,  0, 46, 34, 21,  0,  0,
     & 164,0.001,  0, 50, 42, 21,  0,  0,
     & 164,0.002,  0, 50, 34, 38,  0,  0,
     & 164,0.006,  0, 73, 91, 38, 30,  0,
     & 164,0.004,  0, 38, 30, 38, 30,  0,
     & 164,0.004,  0, 38, 30, 38, 30, 23,
     & 164,0.004,  0, 75, 93, 38, 30,  0,
     & 164,0.001,  0, 86,104,  0,  0,  0,
     & 164,0.001,  0, 79, 97,  0,  0,  0,
     & 164,0.001,  0, 81, 99,  0,  0,  0,
     & 164,0.003,  0, 23, 23, 34, 46,  0,
     & 164,0.002,  0, 73, 91, 38, 30, 21,
     & 164,0.002,  0, 73, 91,  0,  0,  0,
     & 164,0.002,  0, 73, 91, 22,  0,  0,
     & 164,0.002,  0, 73, 93, 30,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 742, 760)/
     & 164,0.002,  0, 75, 93,  0,  0,  0,
     & 164,0.001,  0, 83,102,  0,  0,  0,
     & 164,0.001,  0, 88,106,  0,  0,  0,
     & 164,0.001,  0, 78, 96,  0,  0,  0,
     & 164,0.001,  0, 73, 91, 21,  0,  0,
     & 164,0.001,  0, 78,104, 38,  0,  0,
     & 164,0.001,  0, 96, 86, 30,  0,  0,
     & 164,0.001,  0, 73, 34, 96,  0,  0,
     & 164,0.001,  0, 91, 46, 78,  0,  0,
     & 164,0.001,  0, 46, 34, 46, 34,  0,
     & 164,0.013,  0, 59,163,  0,  0,  0,
     & 164,0.008,  0, 59, 38, 30, 21, 21,
     & 164,0.004,  0, 59, 22, 38, 30,  0,
     & 164,0.002,  0, 59, 22, 21, 21,  0,
     & 164,0.003,  0, 59, 39, 31,  0,  0,
     & 164,0.002,  0, 59, 23, 23,  0,  0,
     & 164,0.004,  0, 59, 25,  0,  0,  0,
     & 164,0.003,  0, 59, 38, 30, 38, 30,
     & 164,0.002,  0, 59, 24, 24,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 761, 779)/
     & 164,0.001,  0, 59, 26,  0,  0,  0,
     & 164,0.001,  0, 59, 22,  0,  0,  0,
     & 164,0.001,  0, 59, 28,  0,  0,  0,
     & 164,0.001,  0, 59, 58,  0,  0,  0,
     & 164,0.020,  0,  1,  7,  0,  0,  0,
     & 164,0.080,  0,  2,  8,  0,  0,  0,
     & 164,0.020,  0,  3,  9,  0,  0,  0,
     & 164,0.364,130, 13, 13, 13,  0,  0,
     & 164,0.091,130, 13, 13, 59,  0,  0,
     & 165,0.037,  0, 38, 30, 38, 30,  0,
     & 165,0.030,  0, 38, 30, 46, 34,  0,
     & 165,0.016,  0, 23, 38, 30,  0,  0,
     & 165,0.015,  0, 23, 38, 30, 38, 30,
     & 165,0.004,  0, 46, 43, 30,  0,  0,
     & 165,0.002,  0, 46, 35, 21,  0,  0,
     & 165,0.002,  0, 51, 43, 21,  0,  0,
     & 165,0.004,  0, 51, 35, 38,  0,  0,
     & 165,0.008,  0, 38, 30,  0,  0,  0,
     & 165,0.007,  0, 46, 34,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 780, 798)/
     & 165,0.005,  0, 38, 30, 73, 91,  0,
     & 165,0.003,  0, 21, 21,  0,  0,  0,
     & 165,0.003,  0, 22, 22,  0,  0,  0,
     & 165,0.007,  0, 59,164,  0,  0,  0,
     & 165,0.857,  0, 13, 13,  0,  0,  0,
     & 166,0.008,  0,121,127,  0,  0,  0,
     & 166,0.008,  0,123,129,  0,  0,  0,
     & 166,0.001,  0,125,131,  0,  0,  0,
     & 166,0.338,  0,164, 38, 30,  0,  0,
     & 166,0.169,  0,164, 21, 21,  0,  0,
     & 166,0.027,  0,164, 22,  0,  0,  0,
     & 166,0.001,  0,164, 21,  0,  0,  0,
     & 166,0.004,  0, 23, 23, 23, 21,  0,
     & 166,0.003,  0, 23, 23, 21,  0,  0,
     & 166,0.002,  0, 38, 30, 46, 34,  0,
     & 166,0.001,  0, 38, 30, 73, 91,  0,
     & 166,0.093,  0, 59,165,  0,  0,  0,
     & 166,0.087,  0, 59,302,  0,  0,  0,
     & 166,0.078,  0, 59,303,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 799, 817)/
     & 166,0.003,  0, 59,163,  0,  0,  0,
     & 166,0.003,  0,  1,  7,  0,  0,  0,
     & 166,0.012,  0,  2,  8,  0,  0,  0,
     & 166,0.003,  0,  3,  9,  0,  0,  0,
     & 166,0.127,130, 13, 13, 13,  0,  0,
     & 166,0.032,130, 13, 13, 59,  0,  0,
     & 167,0.500,  0,136,171,  0,  0,  0,
     & 167,0.500,  0,140,175,  0,  0,  0,
     & 171,0.067,101,128,121, 50,  0,  0,
     & 171,0.067,101,130,123, 50,  0,  0,
     & 171,0.048,101,128,121, 51,  0,  0,
     & 171,0.048,101,130,123, 51,  0,  0,
     & 171,0.003,  0,128,121, 46, 30,  0,
     & 171,0.003,  0,130,123, 46, 30,  0,
     & 171,0.006,101,128,121, 21,  0,  0,
     & 171,0.006,101,130,123, 21,  0,  0,
     & 171,0.002,101,128,121, 23,  0,  0,
     & 171,0.002,101,130,123, 23,  0,  0,
     & 171,0.055,  0, 46, 30, 30,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 818, 836)/
     & 171,0.031,  0, 46, 31, 30,  0,  0,
     & 171,0.042,  0, 46, 30, 30, 21, 21,
     & 171,0.002,  0, 46, 30, 30, 30, 39,
     & 171,0.021,  0, 47, 30, 30,  0,  0,
     & 171,0.027,  0, 50, 30,  0,  0,  0,
     & 171,0.066,  0, 50, 31,  0,  0,  0,
     & 171,0.081,  0, 50, 32,  0,  0,  0,
     & 171,0.024,  0, 50, 30, 21,  0,  0,
     & 171,0.004,  0, 50, 30, 23,  0,  0,
     & 171,0.069,  0, 50, 30, 30, 38, 21,
     & 171,0.001,  0, 50, 30, 30, 38, 23,
     & 171,0.022,  0, 51, 30,  0,  0,  0,
     & 171,0.021,  0, 51, 31,  0,  0,  0,
     & 171,0.042,  0, 51, 30, 21,  0,  0,
     & 171,0.008,  0, 51, 30, 23,  0,  0,
     & 171,0.010,  0, 51, 30, 30, 38,  0,
     & 171,0.050,  0,309, 30,  0,  0,  0,
     & 171,0.034,  0,328, 30,  0,  0,  0,
     & 171,0.010,  0,368, 30,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 837, 855)/
     & 171,0.031,  0, 34, 50, 50,  0,  0,
     & 171,0.003,  0, 30, 21,  0,  0,  0,
     & 171,0.001,  0, 30, 23,  0,  0,  0,
     & 171,0.002,  0, 30, 30, 38,  0,  0,
     & 171,0.008,  0, 30, 22,  0,  0,  0,
     & 171,0.001,  0, 30, 30, 30, 38, 38,
     & 171,0.003,  0, 30, 30, 30, 38, 39,
     & 171,0.008,  0, 34, 50,  0,  0,  0,
     & 171,0.005,  0, 34, 51,  0,  0,  0,
     & 171,0.026,  0, 35, 51,  0,  0,  0,
     & 171,0.005,  0, 34, 46, 30,  0,  0,
     & 171,0.007,  0, 30, 56,  0,  0,  0,
     & 171,0.023,  0, 30, 56, 21,  0,  0,
     & 171,0.005,  0, 34, 34, 46,  0,  0,
     & 172,0.683,  0,175, 30,  0,  0,  0,
     & 172,0.306,  0,171, 21,  0,  0,  0,
     & 172,0.011,  0,171, 59,  0,  0,  0,
     & 173,0.667,  0,176, 30,  0,  0,  0,
     & 173,0.333,  0,172, 21,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 856, 874)/
     & 174,0.220,  0,175, 30,  0,  0,  0,
     & 174,0.110,  0,171, 21,  0,  0,  0,
     & 174,0.380,  0,176, 30,  0,  0,  0,
     & 174,0.190,  0,172, 21,  0,  0,  0,
     & 174,0.004,  0,171, 22,  0,  0,  0,
     & 174,0.064,  0,176, 30, 21,  0,  0,
     & 174,0.032,  0,172, 38, 30,  0,  0,
     & 175,0.037,101,128,121, 46,  0,  0,
     & 175,0.037,101,130,123, 46,  0,  0,
     & 175,0.016,101,128,121, 47,  0,  0,
     & 175,0.016,101,130,123, 47,  0,  0,
     & 175,0.013,  0,128,121, 46, 21,  0,
     & 175,0.013,  0,130,123, 46, 21,  0,
     & 175,0.012,  0,128,121, 50, 38,  0,
     & 175,0.012,  0,130,123, 50, 38,  0,
     & 175,0.003,101,128,121, 38,  0,  0,
     & 175,0.003,101,130,123, 38,  0,  0,
     & 175,0.039,  0, 46, 30,  0,  0,  0,
     & 175,0.091,  0, 46, 31,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 875, 893)/
     & 175,0.067,  0, 46, 32,  0,  0,  0,
     & 175,0.004,  0, 46, 30, 21,  0,  0,
     & 175,0.100,  0, 46, 30, 21, 21,  0,
     & 175,0.058,  0, 46, 30, 23,  0,  0,
     & 175,0.020,  0, 46, 30, 24,  0,  0,
     & 175,0.006,  0, 46, 30, 25,  0,  0,
     & 175,0.043,  0, 47, 30,  0,  0,  0,
     & 175,0.035,  0, 47, 31,  0,  0,  0,
     & 175,0.007,  0,310, 30,  0,  0,  0,
     & 175,0.007,  0,327, 30,  0,  0,  0,
     & 175,0.020,  0, 50, 21,  0,  0,  0,
     & 175,0.006,  0, 50, 22,  0,  0,  0,
     & 175,0.009,  0, 50, 23,  0,  0,  0,
     & 175,0.016,  0, 50, 24,  0,  0,  0,
     & 175,0.014,  0, 50, 25,  0,  0,  0,
     & 175,0.003,  0, 50,293,  0,  0,  0,
     & 175,0.007,  0, 50, 56,  0,  0,  0,
     & 175,0.003,  0, 50, 26,  0,  0,  0,
     & 175,0.004,  0, 50,294,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 894, 912)/
     & 175,0.006,  0, 50, 21, 21,  0,  0,
     & 175,0.042,  0, 50, 30, 38, 21,  0,
     & 175,0.004,  0, 50, 30, 30, 38, 38,
     & 175,0.076,  0, 50, 30, 38, 21, 21,
     & 175,0.026,  0, 51, 21,  0,  0,  0,
     & 175,0.014,  0, 51, 22,  0,  0,  0,
     & 175,0.014,  0, 51, 23,  0,  0,  0,
     & 175,0.011,  0, 51, 24,  0,  0,  0,
     & 175,0.018,  0, 51, 30, 38,  0,  0,
     & 175,0.004,  0, 50, 34, 46,  0,  0,
     & 175,0.004,  0, 50, 34, 46, 21,  0,
     & 175,0.005,  0, 50, 50, 42,  0,  0,
     & 175,0.002,  0, 30, 38,  0,  0,  0,
     & 175,0.001,  0, 21, 21,  0,  0,  0,
     & 175,0.008,  0, 30, 38, 21,  0,  0,
     & 175,0.007,  0, 30, 30, 38, 38,  0,
     & 175,0.015,  0, 30, 30, 38, 38, 21,
     & 175,0.004,  0, 34, 46,  0,  0,  0,
     & 175,0.003,  0, 35, 46,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 913, 931)/
     & 175,0.002,  0, 34, 47,  0,  0,  0,
     & 175,0.001,  0, 42, 50,  0,  0,  0,
     & 175,0.002,  0, 43, 51,  0,  0,  0,
     & 175,0.003,  0, 42, 46, 30,  0,  0,
     & 175,0.003,  0, 50, 34, 38,  0,  0,
     & 175,0.001,  0, 34, 46, 30, 38, 21,
     & 175,0.002,  0, 56, 23,  0,  0,  0,
     & 175,0.001,  0, 56, 30, 38,  0,  0,
     & 176,0.636,  0,175, 21,  0,  0,  0,
     & 176,0.364,  0,175, 59,  0,  0,  0,
     & 177,0.667,  0,172, 38,  0,  0,  0,
     & 177,0.333,  0,176, 21,  0,  0,  0,
     & 178,0.220,  0,171, 38,  0,  0,  0,
     & 178,0.110,  0,175, 21,  0,  0,  0,
     & 178,0.380,  0,172, 38,  0,  0,  0,
     & 178,0.190,  0,176, 21,  0,  0,  0,
     & 178,0.004,  0,175, 22,  0,  0,  0,
     & 178,0.064,  0,172, 38, 21,  0,  0,
     & 178,0.032,  0,176, 38, 30,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 932, 950)/
     & 179,0.009,  0,130,123,  0,  0,  0,
     & 179,0.019,101,128,121, 56,  0,  0,
     & 179,0.019,101,130,123, 56,  0,  0,
     & 179,0.025,101,128,121, 22,  0,  0,
     & 179,0.025,101,130,123, 22,  0,  0,
     & 179,0.009,101,128,121, 25,  0,  0,
     & 179,0.009,101,130,123, 25,  0,  0,
     & 179,0.036,  0, 34, 50,  0,  0,  0,
     & 179,0.034,  0, 34, 51,  0,  0,  0,
     & 179,0.007,  0, 34,328,  0,  0,  0,
     & 179,0.043,  0, 35, 50,  0,  0,  0,
     & 179,0.058,  0, 35, 51,  0,  0,  0,
     & 179,0.011,  0, 34, 46, 30,  0,  0,
     & 179,0.055,  0, 34, 46, 30, 21,  0,
     & 179,0.003,  0, 34, 46, 30, 38, 30,
     & 179,0.014,  0, 34, 50, 38, 30,  0,
     & 179,0.017,  0, 42, 46, 30, 30,  0,
     & 179,0.036,  0, 56, 30,  0,  0,  0,
     & 179,0.067,  0, 56, 31,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 951, 969)/
     & 179,0.023,  0, 56, 30, 21,  0,  0,
     & 179,0.018,  0, 56, 30, 38, 30,  0,
     & 179,0.020,  0, 22, 30,  0,  0,  0,
     & 179,0.001,  0, 23, 30,  0,  0,  0,
     & 179,0.009,  0, 24, 30,  0,  0,  0,
     & 179,0.049,  0, 25, 30,  0,  0,  0,
     & 179,0.011,  0,293, 30,  0,  0,  0,
     & 179,0.015,  0, 22, 30, 21,  0,  0,
     & 179,0.016,  0, 25, 30, 21,  0,  0,
     & 179,0.103,  0, 22, 31,  0,  0,  0,
     & 179,0.120,  0, 25, 31,  0,  0,  0,
     & 179,0.010,  0, 30, 38, 30,  0,  0,
     & 179,0.046,  0, 30, 38, 30, 21,  0,
     & 179,0.003,  0, 30, 38, 38, 30, 30,
     & 179,0.042,  0, 30, 38, 38, 30, 31,
     & 179,0.001,  0, 34, 23,  0,  0,  0,
     & 179,0.005,  0, 34, 38, 30,  0,  0,
     & 179,0.001,  0, 34, 56,  0,  0,  0,
     & 179,0.004,  0, 42, 30,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 970, 988)/
     & 179,0.007,  0, 43, 30,  0,  0,  0,
     & 180,0.900,  0,179, 59,  0,  0,  0,
     & 180,0.100,  0,179, 21,  0,  0,  0,
     & 181,0.500,  0,172, 42,  0,  0,  0,
     & 181,0.500,  0,176, 34,  0,  0,  0,
     & 182,0.440,  0,171, 42,  0,  0,  0,
     & 182,0.440,  0,175, 34,  0,  0,  0,
     & 182,0.055,  0,172, 42,  0,  0,  0,
     & 182,0.055,  0,176, 34,  0,  0,  0,
     & 182,0.010,  0,179, 22,  0,  0,  0,
     & 183,1.000,  0,185, 30,  0,  0,  0,
     & 184,1.000,  0,185, 30,  0,  0,  0,
     & 185,0.028,101,128,121, 96,  0,  0,
     & 185,0.010,101,128,121, 98,  0,  0,
     & 185,0.028,101,130,123, 96,  0,  0,
     & 185,0.010,101,130,123, 98,  0,  0,
     & 185,0.026,  0, 91, 50,  0,  0,  0,
     & 185,0.030,  0, 91, 50, 21,  0,  0,
     & 185,0.029,  0, 91, 50, 38, 30,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I= 989,1007)/
     & 185,0.014,  0, 91, 50, 22,  0,  0,
     & 185,0.020,  0, 91, 51,  0,  0,  0,
     & 185,0.029,  0, 91, 46, 30,  0,  0,
     & 185,0.039,  0, 91, 46, 30, 21,  0,
     & 185,0.002,  0, 91, 46, 30, 30, 38,
     & 185,0.010,  0, 91, 46, 30, 21, 21,
     & 185,0.014,  0, 91, 47, 30,  0,  0,
     & 185,0.010,  0, 92, 50,  0,  0,  0,
     & 185,0.020,  0, 92, 51,  0,  0,  0,
     & 185,0.010,  0, 92, 51, 21,  0,  0,
     & 185,0.007,  0,103, 46,  0,  0,  0,
     & 185,0.014,  0,103, 47,  0,  0,  0,
     & 185,0.004,  0, 91,293,  0,  0,  0,
     & 185,0.003,  0, 91, 38, 30,  0,  0,
     & 185,0.003,  0, 91, 38, 30, 38, 30,
     & 185,0.001,  0, 91, 56,  0,  0,  0,
     & 185,0.002,  0, 91, 46, 34,  0,  0,
     & 185,0.010,  0, 96, 30,  0,  0,  0,
     & 185,0.020,  0, 96, 31,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1008,1026)/
     & 185,0.030,  0, 96, 30, 21,  0,  0,
     & 185,0.010,  0, 96, 30, 22,  0,  0,
     & 185,0.020,  0, 96, 30, 24,  0,  0,
     & 185,0.035,  0, 96, 30, 30, 38,  0,
     & 185,0.020,  0, 96, 30, 21, 21,  0,
     & 185,0.010,  0, 96, 30, 38, 30, 21,
     & 185,0.010,  0, 96, 30, 21, 21, 21,
     & 185,0.007,  0, 96, 34, 50,  0,  0,
     & 185,0.011,  0, 97, 30,  0,  0,  0,
     & 185,0.022,  0, 97, 30, 21,  0,  0,
     & 185,0.013,  0, 97, 30, 38, 30,  0,
     & 185,0.010,  0, 97, 30, 21, 21,  0,
     & 185,0.007,  0, 97, 30, 38, 30, 21,
     & 185,0.005,  0, 97, 30, 21, 21, 21,
     & 185,0.005,  0, 98, 30,  0,  0,  0,
     & 185,0.015,  0, 98, 31,  0,  0,  0,
     & 185,0.011,  0,104, 21,  0,  0,  0,
     & 185,0.007,  0,104, 22,  0,  0,  0,
     & 185,0.010,  0,104, 23,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1027,1045)/
     & 185,0.031,  0,104, 24,  0,  0,  0,
     & 185,0.010,  0,104, 25,  0,  0,  0,
     & 185,0.004,  0,104, 56,  0,  0,  0,
     & 185,0.026,  0,104, 38, 30,  0,  0,
     & 185,0.005,  0,104, 38, 38, 30, 30,
     & 185,0.005,  0,104, 38, 30, 21, 21,
     & 185,0.005,  0,105, 21,  0,  0,  0,
     & 185,0.006,  0,105, 23,  0,  0,  0,
     & 185,0.004,  0,104, 46, 34,  0,  0,
     & 185,0.002,  0,104, 34, 38,  0,  0,
     & 185,0.001,  0,104, 34, 38, 21,  0,
     & 185,0.016,  0, 99, 30, 30,  0,  0,
     & 185,0.003,  0,106, 34,  0,  0,  0,
     & 185,0.002,  0,107, 34,  0,  0,  0,
     & 185,0.003,  0,101, 34, 30,  0,  0,
     & 185,0.040,  0, 93, 34, 21,  0,  0,
     & 185,0.040,  0, 93, 34, 38, 30,  0,
     & 185,0.020,  0, 93, 34, 21, 21,  0,
     & 185,0.010,  0, 93, 34, 38, 30, 21/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1046,1064)/
     & 185,0.010,  0, 93, 34, 21, 21, 21,
     & 185,0.020,  0, 93, 35, 21,  0,  0,
     & 185,0.040,  0, 93, 50, 30,  0,  0,
     & 185,0.020,  0, 93, 50, 31,  0,  0,
     & 185,0.010,  0, 93, 50, 30, 38, 30,
     & 185,0.010,  0, 93, 50, 30, 21, 21,
     & 185,0.006,  0, 93, 51, 30,  0,  0,
     & 186,1.000,  0,185, 21,  0,  0,  0,
     & 187,1.000,  0,185, 21,  0,  0,  0,
     & 188,1.000,  0,185, 38,  0,  0,  0,
     & 189,1.000,  0,185, 38,  0,  0,  0,
     & 190,0.045,101,128,121,106,  0,  0,
     & 190,0.005,101,128,121,107,  0,  0,
     & 190,0.045,101,130,123,106,  0,  0,
     & 190,0.005,101,130,123,107,  0,  0,
     & 190,0.021,  0,104, 50,  0,  0,  0,
     & 190,0.032,  0,105, 50,  0,  0,  0,
     & 190,0.032,  0, 97, 30, 50,  0,  0,
     & 190,0.045,  0,104, 51,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1065,1083)/
     & 190,0.065,  0,105, 51,  0,  0,  0,
     & 190,0.065,  0, 97, 30, 51,  0,  0,
     & 190,0.055,  0,106, 30,  0,  0,  0,
     & 190,0.160,  0,106, 31,  0,  0,  0,
     & 190,0.105,  0,107, 30,  0,  0,  0,
     & 190,0.320,  0,107, 31,  0,  0,  0,
     & 191,1.000,  0,190, 59,  0,  0,  0,
     & 192,0.667,  0,193, 30,  0,  0,  0,
     & 192,0.333,  0,190, 21,  0,  0,  0,
     & 193,0.045,101,128,121,101,  0,  0,
     & 193,0.045,101,130,123,101,  0,  0,
     & 193,0.005,101,128,121,102,  0,  0,
     & 193,0.005,101,130,123,102,  0,  0,
     & 193,0.020,  0, 97, 50,  0,  0,  0,
     & 193,0.020,  0, 97, 21, 50,  0,  0,
     & 193,0.020,  0, 98, 50,  0,  0,  0,
     & 193,0.060,  0, 97, 51,  0,  0,  0,
     & 193,0.060,  0, 97, 21, 51,  0,  0,
     & 193,0.060,  0, 98, 51,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1084,1102)/
     & 193,0.020,  0,104, 46,  0,  0,  0,
     & 193,0.060,  0,104, 47,  0,  0,  0,
     & 193,0.040,  0,105, 46,  0,  0,  0,
     & 193,0.120,  0,105, 47,  0,  0,  0,
     & 193,0.020,  0,101, 30,  0,  0,  0,
     & 193,0.060,  0,101, 31,  0,  0,  0,
     & 193,0.040,  0,102, 30,  0,  0,  0,
     & 193,0.120,  0,102, 31,  0,  0,  0,
     & 193,0.010,  0,106, 21,  0,  0,  0,
     & 193,0.030,  0,106, 23,  0,  0,  0,
     & 193,0.020,  0,107, 21,  0,  0,  0,
     & 193,0.060,  0,107, 23,  0,  0,  0,
     & 193,0.030,  0,106, 56,  0,  0,  0,
     & 193,0.030,  0,108, 34,  0,  0,  0,
     & 194,1.000,  0,193, 59,  0,  0,  0,
     & 195,0.670,  0,190, 38,  0,  0,  0,
     & 195,0.330,  0,193, 21,  0,  0,  0,
     & 196,0.050,101,128,121,108,  0,  0,
     & 196,0.050,101,130,123,108,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1103,1121)/
     & 196,0.075,  0,106, 50,  0,  0,  0,
     & 196,0.225,  0,106, 51,  0,  0,  0,
     & 196,0.150,  0,107, 50,  0,  0,  0,
     & 196,0.450,  0,107, 51,  0,  0,  0,
     & 197,1.000,  0,196, 59,  0,  0,  0,
     & 209,0.250,100,  1,  8,  4,  0,  0,
     & 209,0.250,100,  3, 10,  4,  0,  0,
     & 209,0.250,100,  5, 12,  4,  0,  0,
     & 209,0.085,100,121,128,  4,  0,  0,
     & 209,0.085,100,123,130,  4,  0,  0,
     & 209,0.080,100,125,132,  4,  0,  0,
     & 210,0.250,100,  2,  7,209,  0,  0,
     & 210,0.250,100,  4,  9,209,  0,  0,
     & 210,0.250,100,  6, 11,209,  0,  0,
     & 210,0.085,100,122,127,209,  0,  0,
     & 210,0.085,100,124,129,209,  0,  0,
     & 210,0.080,100,126,131,209,  0,  0,
     & 211,0.250,100,  1,  8,  6,  0,  0,
     & 211,0.250,100,  3, 10,  6,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1122,1140)/
     & 211,0.250,100,  5, 12,  6,  0,  0,
     & 211,0.085,100,121,128,  6,  0,  0,
     & 211,0.085,100,123,130,  6,  0,  0,
     & 211,0.080,100,125,132,  6,  0,  0,
     & 212,0.250,100,  2,  7,211,  0,  0,
     & 212,0.250,100,  4,  9,211,  0,  0,
     & 212,0.250,100,  6, 11,211,  0,  0,
     & 212,0.085,100,122,127,211,  0,  0,
     & 212,0.085,100,124,129,211,  0,  0,
     & 212,0.080,100,126,131,211,  0,  0,
     & 215,0.250,100,  7,  2, 10,  0,  0,
     & 215,0.250,100,  9,  4, 10,  0,  0,
     & 215,0.250,100, 11,  6, 10,  0,  0,
     & 215,0.085,100,127,122, 10,  0,  0,
     & 215,0.085,100,129,124, 10,  0,  0,
     & 215,0.080,100,131,126, 10,  0,  0,
     & 216,0.250,100,  8,  1,215,  0,  0,
     & 216,0.250,100, 10,  3,215,  0,  0,
     & 216,0.250,100, 12,  5,215,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1141,1159)/
     & 216,0.085,100,128,121,215,  0,  0,
     & 216,0.085,100,130,123,215,  0,  0,
     & 216,0.080,100,132,125,215,  0,  0,
     & 217,0.250,100,  7,  2, 12,  0,  0,
     & 217,0.250,100,  9,  4, 12,  0,  0,
     & 217,0.250,100, 11,  6, 12,  0,  0,
     & 217,0.085,100,127,122, 12,  0,  0,
     & 217,0.085,100,129,124, 12,  0,  0,
     & 217,0.080,100,131,126, 12,  0,  0,
     & 218,0.250,100,  8,  1,217,  0,  0,
     & 218,0.250,100, 10,  3,217,  0,  0,
     & 218,0.250,100, 12,  5,217,  0,  0,
     & 218,0.085,100,128,121,217,  0,  0,
     & 218,0.085,100,130,123,217,  0,  0,
     & 218,0.080,100,132,125,217,  0,  0,
     & 221,0.016,101,121,128,136,  0,  0,
     & 221,0.016,101,123,130,136,  0,  0,
     & 221,0.008,101,125,132,136,  0,  0,
     & 221,0.048,101,121,128,137,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1160,1178)/
     & 221,0.048,101,123,130,137,  0,  0,
     & 221,0.022,101,125,132,137,  0,  0,
     & 221,0.003,101,121,128,331,  0,  0,
     & 221,0.003,101,123,130,331,  0,  0,
     & 221,0.001,101,125,132,331,  0,  0,
     & 221,0.008,101,121,128,138,  0,  0,
     & 221,0.008,101,123,130,138,  0,  0,
     & 221,0.004,101,125,132,138,  0,  0,
     & 221,0.008,101,121,128,313,  0,  0,
     & 221,0.008,101,123,130,313,  0,  0,
     & 221,0.004,101,125,132,313,  0,  0,
     & 221,0.013,101,121,128,139,  0,  0,
     & 221,0.013,101,123,130,139,  0,  0,
     & 221,0.006,101,125,132,139,  0,  0,
     & 221,0.004,  0,136, 30,  0,  0,  0,
     & 221,0.010,  0,136, 31,  0,  0,  0,
     & 221,0.006,  0,136, 32,  0,  0,  0,
     & 221,0.003,  0,137, 30,  0,  0,  0,
     & 221,0.009,  0,137, 31,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1179,1197)/
     & 221,0.017,  0,137, 32,  0,  0,  0,
     & 221,0.011,  0,136,179,  0,  0,  0,
     & 221,0.015,  0,136,180,  0,  0,  0,
     & 221,0.011,  0,137,179,  0,  0,  0,
     & 221,0.022,  0,137,180,  0,  0,  0,
     & 221,0.001,  0,164, 42,  0,  0,  0,
     & 221,0.002,  0,164, 43,  0,  0,  0,
     & 221,0.001,  0,165, 42,  0,  0,  0,
     & 221,0.001,  0,165, 43,  0,  0,  0,
     & 221,0.001,  0,166, 42,  0,  0,  0,
     & 221,0.001,  0,166, 43,  0,  0,  0,
     & 221,0.207,100,  1,  8,  4,  7,  0,
     & 221,0.207,100,  3, 10,  4,  7,  0,
     & 221,0.024,100,  1,  8,  2,  7,  0,
     & 221,0.024,100,  3, 10,  2,  7,  0,
     & 221,0.012,100,  3,  8,  4,  7,  0,
     & 221,0.012,100,  1, 10,  4,  7,  0,
     & 221,0.069,100,  4,  8,  1,  7,  0,
     & 221,0.069,100,  4, 10,  3,  7,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1198,1216)/
     & 221,0.008,100,  2,  8,  1,  7,  0,
     & 221,0.008,100,  2, 10,  3,  7,  0,
     & 221,0.004,100,  4,  8,  3,  7,  0,
     & 221,0.004,100,  4, 10,  1,  7,  0,
     & 222,0.016,101,121,128,140,  0,  0,
     & 222,0.016,101,123,130,140,  0,  0,
     & 222,0.008,101,125,132,140,  0,  0,
     & 222,0.048,101,121,128,141,  0,  0,
     & 222,0.048,101,123,130,141,  0,  0,
     & 222,0.022,101,125,132,141,  0,  0,
     & 222,0.003,101,121,128,332,  0,  0,
     & 222,0.003,101,123,130,332,  0,  0,
     & 222,0.001,101,125,132,332,  0,  0,
     & 222,0.008,101,121,128,142,  0,  0,
     & 222,0.008,101,123,130,142,  0,  0,
     & 222,0.004,101,125,132,142,  0,  0,
     & 222,0.008,101,121,128,314,  0,  0,
     & 222,0.008,101,123,130,314,  0,  0,
     & 222,0.004,101,125,132,314,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1217,1235)/
     & 222,0.013,101,121,128,143,  0,  0,
     & 222,0.013,101,123,130,143,  0,  0,
     & 222,0.006,101,125,132,143,  0,  0,
     & 222,0.004,  0,140, 30,  0,  0,  0,
     & 222,0.010,  0,140, 31,  0,  0,  0,
     & 222,0.006,  0,140, 32,  0,  0,  0,
     & 222,0.003,  0,141, 30,  0,  0,  0,
     & 222,0.009,  0,141, 31,  0,  0,  0,
     & 222,0.017,  0,141, 32,  0,  0,  0,
     & 222,0.011,  0,140,179,  0,  0,  0,
     & 222,0.015,  0,140,180,  0,  0,  0,
     & 222,0.011,  0,141,179,  0,  0,  0,
     & 222,0.022,  0,141,180,  0,  0,  0,
     & 222,0.001,  0,164, 34,  0,  0,  0,
     & 222,0.002,  0,164, 35,  0,  0,  0,
     & 222,0.001,  0,165, 34,  0,  0,  0,
     & 222,0.001,  0,165, 35,  0,  0,  0,
     & 222,0.001,  0,166, 34,  0,  0,  0,
     & 222,0.001,  0,166, 35,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1236,1254)/
     & 222,0.207,100,  1,  8,  4,  8,  0,
     & 222,0.207,100,  3, 10,  4,  8,  0,
     & 222,0.024,100,  1,  8,  2,  8,  0,
     & 222,0.024,100,  3, 10,  2,  8,  0,
     & 222,0.012,100,  3,  8,  4,  8,  0,
     & 222,0.012,100,  1, 10,  4,  8,  0,
     & 222,0.069,100,  4,  8,  1,  8,  0,
     & 222,0.069,100,  4, 10,  3,  8,  0,
     & 222,0.008,100,  2,  8,  1,  8,  0,
     & 222,0.008,100,  2, 10,  3,  8,  0,
     & 222,0.004,100,  4,  8,  3,  8,  0,
     & 222,0.004,100,  4, 10,  1,  8,  0,
     & 223,0.016,101,121,128,144,  0,  0,
     & 223,0.016,101,123,130,144,  0,  0,
     & 223,0.008,101,125,132,144,  0,  0,
     & 223,0.048,101,121,128,145,  0,  0,
     & 223,0.048,101,123,130,145,  0,  0,
     & 223,0.022,101,125,132,145,  0,  0,
     & 223,0.003,101,121,128,333,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1255,1273)/
     & 223,0.003,101,123,130,333,  0,  0,
     & 223,0.001,101,125,132,333,  0,  0,
     & 223,0.008,101,121,128,146,  0,  0,
     & 223,0.008,101,123,130,146,  0,  0,
     & 223,0.004,101,125,132,146,  0,  0,
     & 223,0.008,101,121,128,315,  0,  0,
     & 223,0.008,101,123,130,315,  0,  0,
     & 223,0.004,101,125,132,315,  0,  0,
     & 223,0.013,101,121,128,147,  0,  0,
     & 223,0.013,101,123,130,147,  0,  0,
     & 223,0.006,101,125,132,147,  0,  0,
     & 223,0.004,  0,144, 30,  0,  0,  0,
     & 223,0.010,  0,144, 31,  0,  0,  0,
     & 223,0.006,  0,144, 32,  0,  0,  0,
     & 223,0.003,  0,145, 30,  0,  0,  0,
     & 223,0.009,  0,145, 31,  0,  0,  0,
     & 223,0.017,  0,145, 32,  0,  0,  0,
     & 223,0.011,  0,144,179,  0,  0,  0,
     & 223,0.015,  0,144,180,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1274,1292)/
     & 223,0.011,  0,145,179,  0,  0,  0,
     & 223,0.022,  0,145,180,  0,  0,  0,
     & 223,0.001,  0,164, 25,  0,  0,  0,
     & 223,0.002,  0,164, 56,  0,  0,  0,
     & 223,0.001,  0,165, 25,  0,  0,  0,
     & 223,0.001,  0,165, 56,  0,  0,  0,
     & 223,0.001,  0,166, 25,  0,  0,  0,
     & 223,0.001,  0,166, 56,  0,  0,  0,
     & 223,0.207,100,  1,  8,  4,  9,  0,
     & 223,0.207,100,  3, 10,  4,  9,  0,
     & 223,0.024,100,  1,  8,  2,  9,  0,
     & 223,0.024,100,  3, 10,  2,  9,  0,
     & 223,0.012,100,  3,  8,  4,  9,  0,
     & 223,0.012,100,  1, 10,  4,  9,  0,
     & 223,0.069,100,  4,  8,  1,  9,  0,
     & 223,0.069,100,  4, 10,  3,  9,  0,
     & 223,0.008,100,  2,  8,  1,  9,  0,
     & 223,0.008,100,  2, 10,  3,  9,  0,
     & 223,0.004,100,  4,  8,  3,  9,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1293,1311)/
     & 223,0.004,100,  4, 10,  1,  9,  0,
     & 224,0.090,100,121,128,  4,109,  0,
     & 224,0.090,100,123,130,  4,109,  0,
     & 224,0.045,100,125,132,  4,109,  0,
     & 224,0.010,100,121,128,  2,109,  0,
     & 224,0.010,100,123,130,  2,109,  0,
     & 224,0.005,100,125,132,  2,109,  0,
     & 224,0.242,100,  1,  8,  4,109,  0,
     & 224,0.242,100,  3, 10,  4,109,  0,
     & 224,0.027,100,  1,  8,  2,109,  0,
     & 224,0.027,100,  3, 10,  2,109,  0,
     & 224,0.012,100,  3,  8,  4,109,  0,
     & 224,0.012,100,  1, 10,  4,109,  0,
     & 224,0.081,100,  4,  8,  1,109,  0,
     & 224,0.081,100,  4, 10,  3,109,  0,
     & 224,0.009,100,  2,  8,  1,109,  0,
     & 224,0.009,100,  2, 10,  3,109,  0,
     & 224,0.004,100,  4,  8,  3,109,  0,
     & 224,0.004,100,  4, 10,  1,109,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1312,1330)/
     & 225,0.090,100,121,128,  4,110,  0,
     & 225,0.090,100,123,130,  4,110,  0,
     & 225,0.045,100,125,132,  4,110,  0,
     & 225,0.010,100,121,128,  2,110,  0,
     & 225,0.010,100,123,130,  2,110,  0,
     & 225,0.005,100,125,132,  2,110,  0,
     & 225,0.242,100,  1,  8,  4,110,  0,
     & 225,0.242,100,  3, 10,  4,110,  0,
     & 225,0.027,100,  1,  8,  2,110,  0,
     & 225,0.027,100,  3, 10,  2,110,  0,
     & 225,0.012,100,  3,  8,  4,110,  0,
     & 225,0.012,100,  1, 10,  4,110,  0,
     & 225,0.081,100,  4,  8,  1,110,  0,
     & 225,0.081,100,  4, 10,  3,110,  0,
     & 225,0.009,100,  2,  8,  1,110,  0,
     & 225,0.009,100,  2, 10,  3,110,  0,
     & 225,0.004,100,  4,  8,  3,110,  0,
     & 225,0.004,100,  4, 10,  1,110,  0,
     & 226,0.090,100,121,128,  4,111,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1331,1349)/
     & 226,0.090,100,123,130,  4,111,  0,
     & 226,0.045,100,125,132,  4,111,  0,
     & 226,0.010,100,121,128,  2,111,  0,
     & 226,0.010,100,123,130,  2,111,  0,
     & 226,0.005,100,125,132,  2,111,  0,
     & 226,0.242,100,  1,  8,  4,111,  0,
     & 226,0.242,100,  3, 10,  4,111,  0,
     & 226,0.027,100,  1,  8,  2,111,  0,
     & 226,0.027,100,  3, 10,  2,111,  0,
     & 226,0.012,100,  3,  8,  4,111,  0,
     & 226,0.012,100,  1, 10,  4,111,  0,
     & 226,0.081,100,  4,  8,  1,111,  0,
     & 226,0.081,100,  4, 10,  3,111,  0,
     & 226,0.009,100,  2,  8,  1,111,  0,
     & 226,0.009,100,  2, 10,  3,111,  0,
     & 226,0.004,100,  4,  8,  3,111,  0,
     & 226,0.004,100,  4, 10,  1,111,  0,
     & 227,0.090,100,121,128,  4,112,  0,
     & 227,0.090,100,123,130,  4,112,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1350,1368)/
     & 227,0.045,100,125,132,  4,112,  0,
     & 227,0.010,100,121,128,  2,112,  0,
     & 227,0.010,100,123,130,  2,112,  0,
     & 227,0.005,100,125,132,  2,112,  0,
     & 227,0.242,100,  1,  8,  4,112,  0,
     & 227,0.242,100,  3, 10,  4,112,  0,
     & 227,0.027,100,  1,  8,  2,112,  0,
     & 227,0.027,100,  3, 10,  2,112,  0,
     & 227,0.012,100,  3,  8,  4,112,  0,
     & 227,0.012,100,  1, 10,  4,112,  0,
     & 227,0.081,100,  4,  8,  1,112,  0,
     & 227,0.081,100,  4, 10,  3,112,  0,
     & 227,0.009,100,  2,  8,  1,112,  0,
     & 227,0.009,100,  2, 10,  3,112,  0,
     & 227,0.004,100,  4,  8,  3,112,  0,
     & 227,0.004,100,  4, 10,  1,112,  0,
     & 228,0.090,100,121,128,  4,113,  0,
     & 228,0.090,100,123,130,  4,113,  0,
     & 228,0.045,100,125,132,  4,113,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1369,1387)/
     & 228,0.010,100,121,128,  2,113,  0,
     & 228,0.010,100,123,130,  2,113,  0,
     & 228,0.005,100,125,132,  2,113,  0,
     & 228,0.242,100,  1,  8,  4,113,  0,
     & 228,0.242,100,  3, 10,  4,113,  0,
     & 228,0.027,100,  1,  8,  2,113,  0,
     & 228,0.027,100,  3, 10,  2,113,  0,
     & 228,0.012,100,  3,  8,  4,113,  0,
     & 228,0.012,100,  1, 10,  4,113,  0,
     & 228,0.081,100,  4,  8,  1,113,  0,
     & 228,0.081,100,  4, 10,  3,113,  0,
     & 228,0.009,100,  2,  8,  1,113,  0,
     & 228,0.009,100,  2, 10,  3,113,  0,
     & 228,0.004,100,  4,  8,  3,113,  0,
     & 228,0.004,100,  4, 10,  1,113,  0,
     & 229,0.090,100,121,128,  4,114,  0,
     & 229,0.090,100,123,130,  4,114,  0,
     & 229,0.045,100,125,132,  4,114,  0,
     & 229,0.010,100,121,128,  2,114,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1388,1406)/
     & 229,0.010,100,123,130,  2,114,  0,
     & 229,0.005,100,125,132,  2,114,  0,
     & 229,0.242,100,  1,  8,  4,114,  0,
     & 229,0.242,100,  3, 10,  4,114,  0,
     & 229,0.027,100,  1,  8,  2,114,  0,
     & 229,0.027,100,  3, 10,  2,114,  0,
     & 229,0.012,100,  3,  8,  4,114,  0,
     & 229,0.012,100,  1, 10,  4,114,  0,
     & 229,0.081,100,  4,  8,  1,114,  0,
     & 229,0.081,100,  4, 10,  3,114,  0,
     & 229,0.009,100,  2,  8,  1,114,  0,
     & 229,0.009,100,  2, 10,  3,114,  0,
     & 229,0.004,100,  4,  8,  3,114,  0,
     & 229,0.004,100,  4, 10,  1,114,  0,
     & 230,0.080,100,121,128,  4, 10,  0,
     & 230,0.080,100,123,130,  4, 10,  0,
     & 230,0.040,100,125,132,  4, 10,  0,
     & 230,0.080,100,121,128,  9,  5,  0,
     & 230,0.080,100,123,130,  9,  5,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1407,1425)/
     & 230,0.228,100,  1,  8,  4, 10,  0,
     & 230,0.228,100,  3, 10,  4, 10,  0,
     & 230,0.012,100,  3,  8,  4, 10,  0,
     & 230,0.012,100,  1, 10,  4, 10,  0,
     & 230,0.076,100,  4,  8,  1, 10,  0,
     & 230,0.076,100,  4, 10,  3, 10,  0,
     & 230,0.004,100,  4,  8,  3, 10,  0,
     & 230,0.004,100,  4, 10,  1, 10,  0,
     & 231,0.025,  0,121,127,  0,  0,  0,
     & 231,0.025,  0,123,129,  0,  0,  0,
     & 231,0.025,  0,125,131,  0,  0,  0,
     & 231,0.008,  0,  1,  7,  0,  0,  0,
     & 231,0.033,  0,  2,  8,  0,  0,  0,
     & 231,0.008,  0,  3,  9,  0,  0,  0,
     & 231,0.033,  0,  4, 10,  0,  0,  0,
     & 231,0.801,130, 13, 13, 13,  0,  0,
     & 231,0.042,130, 13, 13, 59,  0,  0,
     & 245,0.016,101,127,122,171,  0,  0,
     & 245,0.016,101,129,124,171,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1426,1444)/
     & 245,0.008,101,131,126,171,  0,  0,
     & 245,0.048,101,127,122,172,  0,  0,
     & 245,0.048,101,129,124,172,  0,  0,
     & 245,0.022,101,131,126,172,  0,  0,
     & 245,0.003,101,127,122,334,  0,  0,
     & 245,0.003,101,129,124,334,  0,  0,
     & 245,0.001,101,131,126,334,  0,  0,
     & 245,0.008,101,127,122,173,  0,  0,
     & 245,0.008,101,129,124,173,  0,  0,
     & 245,0.004,101,131,126,173,  0,  0,
     & 245,0.008,101,127,122,316,  0,  0,
     & 245,0.008,101,129,124,316,  0,  0,
     & 245,0.004,101,131,126,316,  0,  0,
     & 245,0.013,101,127,122,174,  0,  0,
     & 245,0.013,101,129,124,174,  0,  0,
     & 245,0.006,101,131,126,174,  0,  0,
     & 245,0.004,  0,171, 38,  0,  0,  0,
     & 245,0.010,  0,171, 39,  0,  0,  0,
     & 245,0.006,  0,171, 40,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1445,1463)/
     & 245,0.003,  0,172, 38,  0,  0,  0,
     & 245,0.009,  0,172, 39,  0,  0,  0,
     & 245,0.017,  0,172, 40,  0,  0,  0,
     & 245,0.011,  0,171,144,  0,  0,  0,
     & 245,0.015,  0,171,145,  0,  0,  0,
     & 245,0.011,  0,172,144,  0,  0,  0,
     & 245,0.022,  0,172,145,  0,  0,  0,
     & 245,0.001,  0,164, 50,  0,  0,  0,
     & 245,0.002,  0,164, 51,  0,  0,  0,
     & 245,0.001,  0,165, 50,  0,  0,  0,
     & 245,0.001,  0,165, 51,  0,  0,  0,
     & 245,0.001,  0,166, 50,  0,  0,  0,
     & 245,0.001,  0,166, 51,  0,  0,  0,
     & 245,0.207,100,  7,  2, 10,  1,  0,
     & 245,0.207,100,  9,  4, 10,  1,  0,
     & 245,0.024,100,  7,  2,  8,  1,  0,
     & 245,0.024,100,  9,  4,  8,  1,  0,
     & 245,0.012,100,  9,  2, 10,  1,  0,
     & 245,0.012,100,  7,  4, 10,  1,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1464,1482)/
     & 245,0.069,100, 10,  2,  7,  1,  0,
     & 245,0.069,100, 10,  4,  9,  1,  0,
     & 245,0.008,100,  8,  2,  7,  1,  0,
     & 245,0.008,100,  8,  4,  9,  1,  0,
     & 245,0.004,100, 10,  2,  9,  1,  0,
     & 245,0.004,100, 10,  4,  7,  1,  0,
     & 246,0.016,101,127,122,175,  0,  0,
     & 246,0.016,101,129,124,175,  0,  0,
     & 246,0.008,101,131,126,175,  0,  0,
     & 246,0.048,101,127,122,176,  0,  0,
     & 246,0.048,101,129,124,176,  0,  0,
     & 246,0.022,101,131,126,176,  0,  0,
     & 246,0.003,101,127,122,335,  0,  0,
     & 246,0.003,101,129,124,335,  0,  0,
     & 246,0.001,101,131,126,335,  0,  0,
     & 246,0.008,101,127,122,177,  0,  0,
     & 246,0.008,101,129,124,177,  0,  0,
     & 246,0.004,101,131,126,177,  0,  0,
     & 246,0.008,101,127,122,317,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1483,1501)/
     & 246,0.008,101,129,124,317,  0,  0,
     & 246,0.004,101,131,126,317,  0,  0,
     & 246,0.013,101,127,122,178,  0,  0,
     & 246,0.013,101,129,124,178,  0,  0,
     & 246,0.006,101,131,126,178,  0,  0,
     & 246,0.004,  0,175, 38,  0,  0,  0,
     & 246,0.010,  0,175, 39,  0,  0,  0,
     & 246,0.006,  0,175, 40,  0,  0,  0,
     & 246,0.003,  0,176, 38,  0,  0,  0,
     & 246,0.009,  0,176, 39,  0,  0,  0,
     & 246,0.017,  0,176, 40,  0,  0,  0,
     & 246,0.011,  0,175,144,  0,  0,  0,
     & 246,0.015,  0,175,145,  0,  0,  0,
     & 246,0.011,  0,176,144,  0,  0,  0,
     & 246,0.022,  0,176,145,  0,  0,  0,
     & 246,0.001,  0,164, 46,  0,  0,  0,
     & 246,0.002,  0,164, 47,  0,  0,  0,
     & 246,0.001,  0,165, 46,  0,  0,  0,
     & 246,0.001,  0,165, 47,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1502,1520)/
     & 246,0.001,  0,166, 46,  0,  0,  0,
     & 246,0.001,  0,166, 47,  0,  0,  0,
     & 246,0.207,100,  7,  2, 10,  2,  0,
     & 246,0.207,100,  9,  4, 10,  2,  0,
     & 246,0.024,100,  7,  2,  8,  2,  0,
     & 246,0.024,100,  9,  4,  8,  2,  0,
     & 246,0.012,100,  9,  2, 10,  2,  0,
     & 246,0.012,100,  7,  4, 10,  2,  0,
     & 246,0.069,100, 10,  2,  7,  2,  0,
     & 246,0.069,100, 10,  4,  9,  2,  0,
     & 246,0.008,100,  8,  2,  7,  2,  0,
     & 246,0.008,100,  8,  4,  9,  2,  0,
     & 246,0.004,100, 10,  2,  9,  2,  0,
     & 246,0.004,100, 10,  4,  7,  2,  0,
     & 247,0.016,101,127,122,179,  0,  0,
     & 247,0.016,101,129,124,179,  0,  0,
     & 247,0.008,101,131,126,179,  0,  0,
     & 247,0.048,101,127,122,180,  0,  0,
     & 247,0.048,101,129,124,180,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1521,1539)/
     & 247,0.022,101,131,126,180,  0,  0,
     & 247,0.003,101,127,122,336,  0,  0,
     & 247,0.003,101,129,124,336,  0,  0,
     & 247,0.001,101,131,126,336,  0,  0,
     & 247,0.008,101,127,122,181,  0,  0,
     & 247,0.008,101,129,124,181,  0,  0,
     & 247,0.004,101,131,126,181,  0,  0,
     & 247,0.008,101,127,122,318,  0,  0,
     & 247,0.008,101,129,124,318,  0,  0,
     & 247,0.004,101,131,126,318,  0,  0,
     & 247,0.013,101,127,122,182,  0,  0,
     & 247,0.013,101,129,124,182,  0,  0,
     & 247,0.006,101,131,126,182,  0,  0,
     & 247,0.004,  0,179, 38,  0,  0,  0,
     & 247,0.010,  0,179, 39,  0,  0,  0,
     & 247,0.006,  0,179, 40,  0,  0,  0,
     & 247,0.003,  0,180, 38,  0,  0,  0,
     & 247,0.009,  0,180, 39,  0,  0,  0,
     & 247,0.017,  0,180, 40,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1540,1558)/
     & 247,0.011,  0,179,144,  0,  0,  0,
     & 247,0.015,  0,179,145,  0,  0,  0,
     & 247,0.011,  0,180,144,  0,  0,  0,
     & 247,0.022,  0,180,145,  0,  0,  0,
     & 247,0.001,  0,164, 25,  0,  0,  0,
     & 247,0.002,  0,164, 56,  0,  0,  0,
     & 247,0.001,  0,165, 25,  0,  0,  0,
     & 247,0.001,  0,165, 56,  0,  0,  0,
     & 247,0.001,  0,166, 25,  0,  0,  0,
     & 247,0.001,  0,166, 56,  0,  0,  0,
     & 247,0.207,100,  7,  2, 10,  3,  0,
     & 247,0.207,100,  9,  4, 10,  3,  0,
     & 247,0.024,100,  7,  2,  8,  3,  0,
     & 247,0.024,100,  9,  4,  8,  3,  0,
     & 247,0.012,100,  9,  2, 10,  3,  0,
     & 247,0.012,100,  7,  4, 10,  3,  0,
     & 247,0.069,100, 10,  2,  7,  3,  0,
     & 247,0.069,100, 10,  4,  9,  3,  0,
     & 247,0.008,100,  8,  2,  7,  3,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1559,1577)/
     & 247,0.008,100,  8,  4,  9,  3,  0,
     & 247,0.004,100, 10,  2,  9,  3,  0,
     & 247,0.004,100, 10,  4,  7,  3,  0,
     & 248,0.090,100,127,122, 10,115,  0,
     & 248,0.090,100,129,124, 10,115,  0,
     & 248,0.045,100,131,126, 10,115,  0,
     & 248,0.010,100,127,122,  8,115,  0,
     & 248,0.010,100,129,124,  8,115,  0,
     & 248,0.005,100,131,126,  8,115,  0,
     & 248,0.242,100,  7,  2, 10,115,  0,
     & 248,0.242,100,  9,  4, 10,115,  0,
     & 248,0.027,100,  7,  2,  8,115,  0,
     & 248,0.027,100,  9,  4,  8,115,  0,
     & 248,0.012,100,  9,  2, 10,115,  0,
     & 248,0.012,100,  7,  4, 10,115,  0,
     & 248,0.081,100, 10,  2,  7,115,  0,
     & 248,0.081,100, 10,  4,  9,115,  0,
     & 248,0.009,100,  8,  2,  7,115,  0,
     & 248,0.009,100,  8,  4,  9,115,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1578,1596)/
     & 248,0.004,100, 10,  2,  9,115,  0,
     & 248,0.004,100, 10,  4,  7,115,  0,
     & 249,0.090,100,127,122, 10,116,  0,
     & 249,0.090,100,129,124, 10,116,  0,
     & 249,0.045,100,131,126, 10,116,  0,
     & 249,0.010,100,127,122,  8,116,  0,
     & 249,0.010,100,129,124,  8,116,  0,
     & 249,0.005,100,131,126,  8,116,  0,
     & 249,0.242,100,  7,  2, 10,116,  0,
     & 249,0.242,100,  9,  4, 10,116,  0,
     & 249,0.027,100,  7,  2,  8,116,  0,
     & 249,0.027,100,  9,  4,  8,116,  0,
     & 249,0.012,100,  9,  2, 10,116,  0,
     & 249,0.012,100,  7,  4, 10,116,  0,
     & 249,0.081,100, 10,  2,  7,116,  0,
     & 249,0.081,100, 10,  4,  9,116,  0,
     & 249,0.009,100,  8,  2,  7,116,  0,
     & 249,0.009,100,  8,  4,  9,116,  0,
     & 249,0.004,100, 10,  2,  9,116,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1597,1615)/
     & 249,0.004,100, 10,  4,  7,116,  0,
     & 250,0.090,100,127,122, 10,117,  0,
     & 250,0.090,100,129,124, 10,117,  0,
     & 250,0.045,100,131,126, 10,117,  0,
     & 250,0.010,100,127,122,  8,117,  0,
     & 250,0.010,100,129,124,  8,117,  0,
     & 250,0.005,100,131,126,  8,117,  0,
     & 250,0.242,100,  7,  2, 10,117,  0,
     & 250,0.242,100,  9,  4, 10,117,  0,
     & 250,0.027,100,  7,  2,  8,117,  0,
     & 250,0.027,100,  9,  4,  8,117,  0,
     & 250,0.012,100,  9,  2, 10,117,  0,
     & 250,0.012,100,  7,  4, 10,117,  0,
     & 250,0.081,100, 10,  2,  7,117,  0,
     & 250,0.081,100, 10,  4,  9,117,  0,
     & 250,0.009,100,  8,  2,  7,117,  0,
     & 250,0.009,100,  8,  4,  9,117,  0,
     & 250,0.004,100, 10,  2,  9,117,  0,
     & 250,0.004,100, 10,  4,  7,117,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1616,1634)/
     & 251,0.090,100,127,122, 10,118,  0,
     & 251,0.090,100,129,124, 10,118,  0,
     & 251,0.045,100,131,126, 10,118,  0,
     & 251,0.010,100,127,122,  8,118,  0,
     & 251,0.010,100,129,124,  8,118,  0,
     & 251,0.005,100,131,126,  8,118,  0,
     & 251,0.242,100,  7,  2, 10,118,  0,
     & 251,0.242,100,  9,  4, 10,118,  0,
     & 251,0.027,100,  7,  2,  8,118,  0,
     & 251,0.027,100,  9,  4,  8,118,  0,
     & 251,0.012,100,  9,  2, 10,118,  0,
     & 251,0.012,100,  7,  4, 10,118,  0,
     & 251,0.081,100, 10,  2,  7,118,  0,
     & 251,0.081,100, 10,  4,  9,118,  0,
     & 251,0.009,100,  8,  2,  7,118,  0,
     & 251,0.009,100,  8,  4,  9,118,  0,
     & 251,0.004,100, 10,  2,  9,118,  0,
     & 251,0.004,100, 10,  4,  7,118,  0,
     & 252,0.090,100,127,122, 10,119,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1635,1653)/
     & 252,0.090,100,129,124, 10,119,  0,
     & 252,0.045,100,131,126, 10,119,  0,
     & 252,0.010,100,127,122,  8,119,  0,
     & 252,0.010,100,129,124,  8,119,  0,
     & 252,0.005,100,131,126,  8,119,  0,
     & 252,0.242,100,  7,  2, 10,119,  0,
     & 252,0.242,100,  9,  4, 10,119,  0,
     & 252,0.027,100,  7,  2,  8,119,  0,
     & 252,0.027,100,  9,  4,  8,119,  0,
     & 252,0.012,100,  9,  2, 10,119,  0,
     & 252,0.012,100,  7,  4, 10,119,  0,
     & 252,0.081,100, 10,  2,  7,119,  0,
     & 252,0.081,100, 10,  4,  9,119,  0,
     & 252,0.009,100,  8,  2,  7,119,  0,
     & 252,0.009,100,  8,  4,  9,119,  0,
     & 252,0.004,100, 10,  2,  9,119,  0,
     & 252,0.004,100, 10,  4,  7,119,  0,
     & 253,0.090,100,127,122, 10,120,  0,
     & 253,0.090,100,129,124, 10,120,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1654,1672)/
     & 253,0.045,100,131,126, 10,120,  0,
     & 253,0.010,100,127,122,  8,120,  0,
     & 253,0.010,100,129,124,  8,120,  0,
     & 253,0.005,100,131,126,  8,120,  0,
     & 253,0.242,100,  7,  2, 10,120,  0,
     & 253,0.242,100,  9,  4, 10,120,  0,
     & 253,0.027,100,  7,  2,  8,120,  0,
     & 253,0.027,100,  9,  4,  8,120,  0,
     & 253,0.012,100,  9,  2, 10,120,  0,
     & 253,0.012,100,  7,  4, 10,120,  0,
     & 253,0.081,100, 10,  2,  7,120,  0,
     & 253,0.081,100, 10,  4,  9,120,  0,
     & 253,0.009,100,  8,  2,  7,120,  0,
     & 253,0.009,100,  8,  4,  9,120,  0,
     & 253,0.004,100, 10,  2,  9,120,  0,
     & 253,0.004,100, 10,  4,  7,120,  0,
     & 254,0.080,100,127,122, 10,  4,  0,
     & 254,0.080,100,129,124, 10,  4,  0,
     & 254,0.040,100,131,126, 10,  4,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1673,1691)/
     & 254,0.080,100,127,122,  3, 11,  0,
     & 254,0.080,100,129,124,  3, 11,  0,
     & 254,0.228,100,  7,  2, 10,  4,  0,
     & 254,0.228,100,  9,  4, 10,  4,  0,
     & 254,0.012,100,  9,  2, 10,  4,  0,
     & 254,0.012,100,  7,  4, 10,  4,  0,
     & 254,0.076,100, 10,  2,  7,  4,  0,
     & 254,0.076,100, 10,  4,  9,  4,  0,
     & 254,0.004,100, 10,  2,  9,  4,  0,
     & 254,0.004,100, 10,  4,  7,  4,  0,
     & 265,1.000,  0,221, 59,  0,  0,  0,
     & 266,1.000,  0,222, 59,  0,  0,  0,
     & 267,1.000,  0,223, 59,  0,  0,  0,
     & 268,0.667,  0,266, 38,  0,  0,  0,
     & 268,0.333,  0,265, 21,  0,  0,  0,
     & 269,0.667,  0,265, 30,  0,  0,  0,
     & 269,0.333,  0,266, 21,  0,  0,  0,
     & 270,0.500,  0,265, 50,  0,  0,  0,
     & 270,0.500,  0,266, 46,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1692,1710)/
     & 271,0.290,  0,266, 38,  0,  0,  0,
     & 271,0.150,  0,265, 21,  0,  0,  0,
     & 271,0.290,  0,222, 38,  0,  0,  0,
     & 271,0.150,  0,221, 21,  0,  0,  0,
     & 271,0.060,  0,266, 38, 21,  0,  0,
     & 271,0.020,  0,265, 38, 30,  0,  0,
     & 271,0.010,  0,265, 21, 21,  0,  0,
     & 271,0.020,  0,222, 38, 21,  0,  0,
     & 271,0.010,  0,221, 38, 30,  0,  0,
     & 272,0.290,  0,265, 30,  0,  0,  0,
     & 272,0.150,  0,266, 21,  0,  0,  0,
     & 272,0.290,  0,221, 30,  0,  0,  0,
     & 272,0.150,  0,222, 21,  0,  0,  0,
     & 272,0.060,  0,265, 30, 21,  0,  0,
     & 272,0.020,  0,266, 38, 30,  0,  0,
     & 272,0.010,  0,266, 21, 21,  0,  0,
     & 272,0.020,  0,221, 30, 21,  0,  0,
     & 272,0.010,  0,222, 38, 30,  0,  0,
     & 273,0.350,  0,221, 50,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1711,1729)/
     & 273,0.350,  0,222, 46,  0,  0,  0,
     & 273,0.150,  0,265, 50,  0,  0,  0,
     & 273,0.150,  0,266, 46,  0,  0,  0,
     & 274,1.000,  0,245, 59,  0,  0,  0,
     & 275,1.000,  0,246, 59,  0,  0,  0,
     & 276,1.000,  0,247, 59,  0,  0,  0,
     & 277,0.667,  0,275, 30,  0,  0,  0,
     & 277,0.333,  0,274, 21,  0,  0,  0,
     & 278,0.667,  0,274, 38,  0,  0,  0,
     & 278,0.333,  0,275, 21,  0,  0,  0,
     & 279,0.500,  0,274, 42,  0,  0,  0,
     & 279,0.500,  0,275, 34,  0,  0,  0,
     & 280,0.290,  0,275, 30,  0,  0,  0,
     & 280,0.150,  0,274, 21,  0,  0,  0,
     & 280,0.290,  0,246, 30,  0,  0,  0,
     & 280,0.150,  0,245, 21,  0,  0,  0,
     & 280,0.060,  0,275, 30, 21,  0,  0,
     & 280,0.020,  0,274, 38, 30,  0,  0,
     & 280,0.010,  0,274, 21, 21,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1730,1748)/
     & 280,0.020,  0,246, 30, 21,  0,  0,
     & 280,0.010,  0,245, 38, 30,  0,  0,
     & 281,0.290,  0,274, 38,  0,  0,  0,
     & 281,0.150,  0,275, 21,  0,  0,  0,
     & 281,0.290,  0,245, 38,  0,  0,  0,
     & 281,0.150,  0,246, 21,  0,  0,  0,
     & 281,0.060,  0,274, 38, 21,  0,  0,
     & 281,0.020,  0,275, 38, 30,  0,  0,
     & 281,0.010,  0,275, 21, 21,  0,  0,
     & 281,0.020,  0,245, 38, 21,  0,  0,
     & 281,0.010,  0,246, 38, 30,  0,  0,
     & 282,0.350,  0,245, 42,  0,  0,  0,
     & 282,0.350,  0,246, 34,  0,  0,  0,
     & 282,0.150,  0,274, 42,  0,  0,  0,
     & 282,0.150,  0,275, 34,  0,  0,  0,
     & 285,1.000,  0, 24, 21,  0,  0,  0,
     & 286,0.998,  0, 24, 38,  0,  0,  0,
     & 286,0.002,  0, 38, 59,  0,  0,  0,
     & 287,0.998,  0, 24, 30,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1749,1767)/
     & 287,0.002,  0, 30, 59,  0,  0,  0,
     & 288,0.330,  0, 39, 30,  0,  0,  0,
     & 288,0.340,  0, 23, 21,  0,  0,  0,
     & 288,0.330,  0, 31, 38,  0,  0,  0,
     & 289,0.250,  0, 46, 35,  0,  0,  0,
     & 289,0.250,  0, 34, 47,  0,  0,  0,
     & 289,0.250,  0, 50, 43,  0,  0,  0,
     & 289,0.250,  0, 42, 51,  0,  0,  0,
     & 290,0.996,  0, 22, 21,  0,  0,  0,
     & 290,0.002,  0, 46, 34,  0,  0,  0,
     & 290,0.002,  0, 50, 42,  0,  0,  0,
     & 291,0.996,  0, 22, 38,  0,  0,  0,
     & 291,0.004,  0, 46, 42,  0,  0,  0,
     & 292,0.996,  0, 22, 30,  0,  0,  0,
     & 292,0.004,  0, 50, 34,  0,  0,  0,
     & 293,0.520,  0, 38, 30,  0,  0,  0,
     & 293,0.260,  0, 21, 21,  0,  0,  0,
     & 293,0.110,  0, 46, 34,  0,  0,  0,
     & 293,0.110,  0, 50, 42,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1768,1786)/
     & 294,0.620,  0, 38, 30,  0,  0,  0,
     & 294,0.310,  0, 21, 21,  0,  0,  0,
     & 294,0.035,  0, 46, 34,  0,  0,  0,
     & 294,0.035,  0, 50, 42,  0,  0,  0,
     & 295,1.000,  0,254, 59,  0,  0,  0,
     & 296,1.000,  0,230, 59,  0,  0,  0,
     & 297,1.000,  0,254, 59,  0,  0,  0,
     & 298,1.000,  0,230, 59,  0,  0,  0,
     & 299,1.000,  0,254, 59,  0,  0,  0,
     & 300,1.000,  0,230, 59,  0,  0,  0,
     & 301,0.050,  0,121,127,  0,  0,  0,
     & 301,0.050,  0,123,129,  0,  0,  0,
     & 301,0.017,  0,  1,  7,  0,  0,  0,
     & 301,0.066,  0,  2,  8,  0,  0,  0,
     & 301,0.017,  0,  3,  9,  0,  0,  0,
     & 301,0.640,130, 13, 13, 13,  0,  0,
     & 301,0.160,130, 13, 13, 59,  0,  0,
     & 302,0.022,  0, 38, 30, 38, 30, 23,
     & 302,0.016,  0, 38, 30, 38, 30,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1787,1805)/
     & 302,0.009,  0, 38, 30, 46, 34,  0,
     & 302,0.004,  0, 23, 38, 30,  0,  0,
     & 302,0.002,  0, 46, 43, 30,  0,  0,
     & 302,0.002,  0, 34, 51, 38,  0,  0,
     & 302,0.001,  0, 38, 30, 73, 91,  0,
     & 302,0.273,  0, 59,164,  0,  0,  0,
     & 302,0.671,  0, 13, 13,  0,  0,  0,
     & 303,0.022,  0, 38, 30, 38, 30,  0,
     & 303,0.019,  0, 38, 30, 46, 34,  0,
     & 303,0.012,  0, 38, 30, 38, 30, 23,
     & 303,0.007,  0, 23, 38, 30,  0,  0,
     & 303,0.002,  0, 46, 43, 30,  0,  0,
     & 303,0.002,  0, 34, 51, 38,  0,  0,
     & 303,0.003,  0, 38, 30, 73, 91,  0,
     & 303,0.002,  0, 38, 30,  0,  0,  0,
     & 303,0.002,  0, 46, 34,  0,  0,  0,
     & 303,0.001,  0, 21, 21,  0,  0,  0,
     & 303,0.135,  0, 59,164,  0,  0,  0,
     & 303,0.793,  0, 13, 13,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1806,1824)/
     & 304,1.000,  0, 13, 13,  0,  0,  0,
     & 305,1.000,  0, 13, 13,  0,  0,  0,
     & 306,0.050,  0, 59,231,  0,  0,  0,
     & 306,0.950,  0, 13, 13,  0,  0,  0,
     & 307,0.350,  0, 59,231,  0,  0,  0,
     & 307,0.650,  0, 13, 13,  0,  0,  0,
     & 308,0.220,  0, 59,231,  0,  0,  0,
     & 308,0.780,  0, 13, 13,  0,  0,  0,
     & 309,0.280,  0, 46, 31,  0,  0,  0,
     & 309,0.140,  0, 50, 23,  0,  0,  0,
     & 309,0.187,  0,327, 30,  0,  0,  0,
     & 309,0.093,  0,328, 21,  0,  0,  0,
     & 309,0.110,  0, 50, 24,  0,  0,  0,
     & 309,0.107,  0, 47, 30,  0,  0,  0,
     & 309,0.053,  0, 51, 21,  0,  0,  0,
     & 309,0.030,  0, 50,293,  0,  0,  0,
     & 310,0.280,  0, 50, 39,  0,  0,  0,
     & 310,0.140,  0, 46, 23,  0,  0,  0,
     & 310,0.187,  0,328, 38,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1825,1843)/
     & 310,0.093,  0,327, 21,  0,  0,  0,
     & 310,0.110,  0, 46, 24,  0,  0,  0,
     & 310,0.107,  0, 51, 38,  0,  0,  0,
     & 310,0.053,  0, 47, 21,  0,  0,  0,
     & 310,0.030,  0, 46,293,  0,  0,  0,
     & 311,0.280,  0, 34, 39,  0,  0,  0,
     & 311,0.140,  0, 42, 23,  0,  0,  0,
     & 311,0.187,  0,330, 38,  0,  0,  0,
     & 311,0.093,  0,329, 21,  0,  0,  0,
     & 311,0.110,  0, 42, 24,  0,  0,  0,
     & 311,0.107,  0, 35, 38,  0,  0,  0,
     & 311,0.053,  0, 43, 21,  0,  0,  0,
     & 311,0.030,  0, 42,293,  0,  0,  0,
     & 312,0.280,  0, 42, 31,  0,  0,  0,
     & 312,0.140,  0, 34, 23,  0,  0,  0,
     & 312,0.187,  0,329, 30,  0,  0,  0,
     & 312,0.093,  0,330, 21,  0,  0,  0,
     & 312,0.110,  0, 34, 24,  0,  0,  0,
     & 312,0.107,  0, 43, 30,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1844,1862)/
     & 312,0.053,  0, 35, 21,  0,  0,  0,
     & 312,0.030,  0, 34,293,  0,  0,  0,
     & 313,0.430,  0,140, 38,  0,  0,  0,
     & 313,0.215,  0,136, 21,  0,  0,  0,
     & 313,0.235,  0,140, 38, 21,  0,  0,
     & 313,0.120,  0,136, 38, 30,  0,  0,
     & 314,0.430,  0,136, 30,  0,  0,  0,
     & 314,0.215,  0,140, 21,  0,  0,  0,
     & 314,0.235,  0,136, 30, 21,  0,  0,
     & 314,0.120,  0,140, 38, 30,  0,  0,
     & 315,0.480,  0,136, 50,  0,  0,  0,
     & 315,0.480,  0,140, 46,  0,  0,  0,
     & 315,0.040,  0,145, 59,  0,  0,  0,
     & 316,0.430,  0,175, 30,  0,  0,  0,
     & 316,0.215,  0,171, 21,  0,  0,  0,
     & 316,0.235,  0,175, 30, 21,  0,  0,
     & 316,0.120,  0,171, 38, 30,  0,  0,
     & 317,0.430,  0,171, 38,  0,  0,  0,
     & 317,0.215,  0,175, 21,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1863,1881)/
     & 317,0.235,  0,171, 38, 21,  0,  0,
     & 317,0.120,  0,175, 38, 30,  0,  0,
     & 318,0.480,  0,171, 42,  0,  0,  0,
     & 318,0.480,  0,175, 34,  0,  0,  0,
     & 318,0.040,  0,180, 59,  0,  0,  0,
     & 319,0.540,  0,275, 30,  0,  0,  0,
     & 319,0.270,  0,274, 21,  0,  0,  0,
     & 319,0.030,  0,275, 30, 21,  0,  0,
     & 319,0.010,  0,274, 38, 30,  0,  0,
     & 319,0.010,  0,274, 21, 21,  0,  0,
     & 319,0.090,  0,246, 30, 21,  0,  0,
     & 319,0.030,  0,245, 38, 30,  0,  0,
     & 319,0.020,  0,245, 21, 21,  0,  0,
     & 320,0.540,  0,274, 38,  0,  0,  0,
     & 320,0.270,  0,275, 21,  0,  0,  0,
     & 320,0.030,  0,274, 38, 21,  0,  0,
     & 320,0.010,  0,275, 38, 30,  0,  0,
     & 320,0.010,  0,275, 21, 21,  0,  0,
     & 320,0.090,  0,245, 38, 21,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1882,1900)/
     & 320,0.030,  0,246, 38, 30,  0,  0,
     & 320,0.020,  0,246, 21, 21,  0,  0,
     & 321,0.500,  0,266, 46,  0,  0,  0,
     & 321,0.500,  0,265, 50,  0,  0,  0,
     & 322,1.000,  0,254, 59,  0,  0,  0,
     & 323,0.540,  0,266, 38,  0,  0,  0,
     & 323,0.270,  0,265, 21,  0,  0,  0,
     & 323,0.030,  0,266, 38, 21,  0,  0,
     & 323,0.010,  0,265, 38, 30,  0,  0,
     & 323,0.010,  0,265, 21, 21,  0,  0,
     & 323,0.090,  0,222, 38, 21,  0,  0,
     & 323,0.030,  0,221, 38, 30,  0,  0,
     & 323,0.020,  0,221, 21, 21,  0,  0,
     & 324,0.540,  0,265, 30,  0,  0,  0,
     & 324,0.270,  0,266, 21,  0,  0,  0,
     & 324,0.030,  0,265, 30, 21,  0,  0,
     & 324,0.010,  0,266, 38, 30,  0,  0,
     & 324,0.010,  0,266, 21, 21,  0,  0,
     & 324,0.090,  0,221, 30, 21,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1901,1919)/
     & 324,0.030,  0,222, 38, 30,  0,  0,
     & 324,0.020,  0,222, 21, 21,  0,  0,
     & 325,0.500,  0,275, 34,  0,  0,  0,
     & 325,0.500,  0,274, 42,  0,  0,  0,
     & 326,1.000,  0,230, 59,  0,  0,  0,
     & 327,0.667,  0, 50, 38,  0,  0,  0,
     & 327,0.333,  0, 46, 21,  0,  0,  0,
     & 328,0.667,  0, 46, 30,  0,  0,  0,
     & 328,0.333,  0, 50, 21,  0,  0,  0,
     & 329,0.667,  0, 34, 38,  0,  0,  0,
     & 329,0.333,  0, 42, 21,  0,  0,  0,
     & 330,0.667,  0, 42, 30,  0,  0,  0,
     & 330,0.333,  0, 34, 21,  0,  0,  0,
     & 331,0.667,  0,140, 38,  0,  0,  0,
     & 331,0.333,  0,136, 21,  0,  0,  0,
     & 332,0.667,  0,136, 30,  0,  0,  0,
     & 332,0.333,  0,140, 21,  0,  0,  0,
     & 333,0.500,  0,136, 50,  0,  0,  0,
     & 333,0.500,  0,140, 46,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1920,1938)/
     & 334,0.667,  0,175, 30,  0,  0,  0,
     & 334,0.333,  0,171, 21,  0,  0,  0,
     & 335,0.667,  0,171, 38,  0,  0,  0,
     & 335,0.333,  0,175, 21,  0,  0,  0,
     & 336,0.500,  0,171, 42,  0,  0,  0,
     & 336,0.500,  0,175, 34,  0,  0,  0,
     & 337,0.667,  0,246, 30,  0,  0,  0,
     & 337,0.333,  0,245, 21,  0,  0,  0,
     & 338,0.667,  0,245, 38,  0,  0,  0,
     & 338,0.333,  0,246, 21,  0,  0,  0,
     & 339,0.500,  0,246, 34,  0,  0,  0,
     & 339,0.500,  0,245, 42,  0,  0,  0,
     & 340,1.000,  0,254, 59,  0,  0,  0,
     & 341,0.667,  0,222, 38,  0,  0,  0,
     & 341,0.333,  0,221, 21,  0,  0,  0,
     & 342,0.667,  0,221, 30,  0,  0,  0,
     & 342,0.333,  0,222, 21,  0,  0,  0,
     & 343,0.500,  0,222, 46,  0,  0,  0,
     & 343,0.500,  0,221, 50,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1939,1957)/
     & 344,1.000,  0,230, 59,  0,  0,  0,
     & 345,1.000,  0,225, 30,  0,  0,  0,
     & 346,1.000,  0,225, 21,  0,  0,  0,
     & 347,1.000,  0,225, 21,  0,  0,  0,
     & 348,1.000,  0,225, 38,  0,  0,  0,
     & 349,0.600,  0,228, 38,  0,  0,  0,
     & 349,0.300,  0,227, 21,  0,  0,  0,
     & 349,0.100,  0,227, 59,  0,  0,  0,
     & 350,0.600,  0,228, 38,  0,  0,  0,
     & 350,0.300,  0,227, 21,  0,  0,  0,
     & 350,0.100,  0,227, 59,  0,  0,  0,
     & 351,0.600,  0,227, 30,  0,  0,  0,
     & 351,0.300,  0,228, 21,  0,  0,  0,
     & 351,0.100,  0,228, 59,  0,  0,  0,
     & 352,0.600,  0,227, 30,  0,  0,  0,
     & 352,0.300,  0,228, 21,  0,  0,  0,
     & 352,0.100,  0,228, 59,  0,  0,  0,
     & 353,1.000,  0,229, 59,  0,  0,  0,
     & 354,1.000,  0,249, 38,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1958,1976)/
     & 355,1.000,  0,249, 21,  0,  0,  0,
     & 356,1.000,  0,249, 21,  0,  0,  0,
     & 357,1.000,  0,249, 30,  0,  0,  0,
     & 358,0.600,  0,252, 30,  0,  0,  0,
     & 358,0.300,  0,251, 21,  0,  0,  0,
     & 358,0.100,  0,251, 59,  0,  0,  0,
     & 359,0.600,  0,252, 30,  0,  0,  0,
     & 359,0.300,  0,251, 21,  0,  0,  0,
     & 359,0.100,  0,251, 59,  0,  0,  0,
     & 360,0.600,  0,251, 38,  0,  0,  0,
     & 360,0.300,  0,252, 21,  0,  0,  0,
     & 360,0.100,  0,252, 59,  0,  0,  0,
     & 361,0.600,  0,251, 38,  0,  0,  0,
     & 361,0.300,  0,252, 21,  0,  0,  0,
     & 361,0.100,  0,252, 59,  0,  0,  0,
     & 362,1.000,  0,253, 59,  0,  0,  0,
     & 363,0.400,  0, 53, 38,  0,  0,  0,
     & 363,0.200,  0, 49, 21,  0,  0,  0,
     & 363,0.100,  0, 51, 38,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1977,1995)/
     & 363,0.050,  0, 47, 21,  0,  0,  0,
     & 363,0.150,  0, 46, 26,  0,  0,  0,
     & 363,0.050,  0, 46, 56,  0,  0,  0,
     & 363,0.050,  0, 46, 24,  0,  0,  0,
     & 364,0.400,  0, 49, 30,  0,  0,  0,
     & 364,0.200,  0, 53, 21,  0,  0,  0,
     & 364,0.100,  0, 47, 30,  0,  0,  0,
     & 364,0.050,  0, 51, 21,  0,  0,  0,
     & 364,0.150,  0, 50, 26,  0,  0,  0,
     & 364,0.050,  0, 50, 56,  0,  0,  0,
     & 364,0.050,  0, 50, 24,  0,  0,  0,
     & 365,0.400,  0, 37, 38,  0,  0,  0,
     & 365,0.200,  0, 45, 21,  0,  0,  0,
     & 365,0.100,  0, 35, 38,  0,  0,  0,
     & 365,0.050,  0, 43, 21,  0,  0,  0,
     & 365,0.150,  0, 42, 26,  0,  0,  0,
     & 365,0.050,  0, 42, 56,  0,  0,  0,
     & 365,0.050,  0, 42, 24,  0,  0,  0,
     & 366,0.400,  0, 45, 30,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=1996,2014)/
     & 366,0.200,  0, 37, 21,  0,  0,  0,
     & 366,0.100,  0, 43, 30,  0,  0,  0,
     & 366,0.050,  0, 35, 21,  0,  0,  0,
     & 366,0.150,  0, 34, 26,  0,  0,  0,
     & 366,0.050,  0, 34, 56,  0,  0,  0,
     & 366,0.050,  0, 34, 24,  0,  0,  0,
     & 367,0.258,  0, 50, 38,  0,  0,  0,
     & 367,0.129,  0, 46, 21,  0,  0,  0,
     & 367,0.209,  0, 50, 39,  0,  0,  0,
     & 367,0.105,  0, 46, 23,  0,  0,  0,
     & 367,0.199,  0, 51, 38,  0,  0,  0,
     & 367,0.100,  0, 47, 21,  0,  0,  0,
     & 368,0.258,  0, 46, 30,  0,  0,  0,
     & 368,0.129,  0, 50, 21,  0,  0,  0,
     & 368,0.209,  0, 46, 31,  0,  0,  0,
     & 368,0.105,  0, 50, 23,  0,  0,  0,
     & 368,0.199,  0, 47, 30,  0,  0,  0,
     & 368,0.100,  0, 51, 21,  0,  0,  0,
     & 369,0.258,  0, 34, 38,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=2015,2033)/
     & 369,0.129,  0, 42, 21,  0,  0,  0,
     & 369,0.209,  0, 34, 39,  0,  0,  0,
     & 369,0.105,  0, 42, 23,  0,  0,  0,
     & 369,0.199,  0, 35, 38,  0,  0,  0,
     & 369,0.100,  0, 43, 21,  0,  0,  0,
     & 370,0.258,  0, 42, 30,  0,  0,  0,
     & 370,0.129,  0, 34, 21,  0,  0,  0,
     & 370,0.209,  0, 42, 31,  0,  0,  0,
     & 370,0.105,  0, 34, 23,  0,  0,  0,
     & 370,0.199,  0, 43, 30,  0,  0,  0,
     & 370,0.100,  0, 35, 21,  0,  0,  0,
     & 371,0.400,  0, 53, 38,  0,  0,  0,
     & 371,0.200,  0, 49, 21,  0,  0,  0,
     & 371,0.100,  0, 51, 38,  0,  0,  0,
     & 371,0.050,  0, 47, 21,  0,  0,  0,
     & 371,0.150,  0, 46, 26,  0,  0,  0,
     & 371,0.050,  0, 46, 56,  0,  0,  0,
     & 371,0.050,  0, 46, 24,  0,  0,  0,
     & 372,0.400,  0, 49, 30,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=2034,2052)/
     & 372,0.200,  0, 53, 21,  0,  0,  0,
     & 372,0.100,  0, 47, 30,  0,  0,  0,
     & 372,0.050,  0, 51, 21,  0,  0,  0,
     & 372,0.150,  0, 50, 26,  0,  0,  0,
     & 372,0.050,  0, 50, 56,  0,  0,  0,
     & 372,0.050,  0, 50, 24,  0,  0,  0,
     & 373,0.400,  0, 37, 38,  0,  0,  0,
     & 373,0.200,  0, 45, 21,  0,  0,  0,
     & 373,0.100,  0, 35, 38,  0,  0,  0,
     & 373,0.050,  0, 43, 21,  0,  0,  0,
     & 373,0.150,  0, 42, 26,  0,  0,  0,
     & 373,0.050,  0, 42, 56,  0,  0,  0,
     & 373,0.050,  0, 42, 24,  0,  0,  0,
     & 374,0.400,  0, 45, 30,  0,  0,  0,
     & 374,0.200,  0, 37, 21,  0,  0,  0,
     & 374,0.100,  0, 43, 30,  0,  0,  0,
     & 374,0.050,  0, 35, 21,  0,  0,  0,
     & 374,0.150,  0, 34, 26,  0,  0,  0,
     & 374,0.050,  0, 34, 56,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=2053,2071)/
     & 374,0.050,  0, 34, 24,  0,  0,  0,
     & 375,0.300,  0, 50, 39,  0,  0,  0,
     & 375,0.150,  0, 46, 23,  0,  0,  0,
     & 375,0.182,  0, 51, 38,  0,  0,  0,
     & 375,0.091,  0, 47, 21,  0,  0,  0,
     & 375,0.130,  0, 50, 38,  0,  0,  0,
     & 375,0.065,  0, 46, 21,  0,  0,  0,
     & 375,0.082,  0, 46, 22,  0,  0,  0,
     & 376,0.300,  0, 46, 31,  0,  0,  0,
     & 376,0.150,  0, 50, 23,  0,  0,  0,
     & 376,0.182,  0, 47, 30,  0,  0,  0,
     & 376,0.091,  0, 51, 21,  0,  0,  0,
     & 376,0.130,  0, 46, 30,  0,  0,  0,
     & 376,0.065,  0, 50, 21,  0,  0,  0,
     & 376,0.082,  0, 50, 22,  0,  0,  0,
     & 377,0.300,  0, 34, 39,  0,  0,  0,
     & 377,0.150,  0, 42, 23,  0,  0,  0,
     & 377,0.182,  0, 35, 38,  0,  0,  0,
     & 377,0.091,  0, 43, 21,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=2072,2090)/
     & 377,0.130,  0, 34, 38,  0,  0,  0,
     & 377,0.065,  0, 42, 21,  0,  0,  0,
     & 377,0.082,  0, 42, 22,  0,  0,  0,
     & 378,0.300,  0, 42, 31,  0,  0,  0,
     & 378,0.150,  0, 34, 23,  0,  0,  0,
     & 378,0.182,  0, 43, 30,  0,  0,  0,
     & 378,0.091,  0, 35, 21,  0,  0,  0,
     & 378,0.130,  0, 42, 30,  0,  0,  0,
     & 378,0.065,  0, 34, 21,  0,  0,  0,
     & 378,0.082,  0, 34, 22,  0,  0,  0,
     & 379,0.562,  0, 26, 38,  0,  0,  0,
     & 379,0.155,  0, 39, 21,  0,  0,  0,
     & 379,0.155,  0, 23, 38,  0,  0,  0,
     & 379,0.088,  0,293, 38,  0,  0,  0,
     & 379,0.020,  0, 46, 43,  0,  0,  0,
     & 379,0.020,  0, 42, 47,  0,  0,  0,
     & 380,0.562,  0, 26, 21,  0,  0,  0,
     & 380,0.155,  0, 39, 30,  0,  0,  0,
     & 380,0.155,  0, 31, 38,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=2091,2109)/
     & 380,0.088,  0,293, 21,  0,  0,  0,
     & 380,0.010,  0, 46, 35,  0,  0,  0,
     & 380,0.010,  0, 50, 43,  0,  0,  0,
     & 380,0.010,  0, 34, 47,  0,  0,  0,
     & 380,0.010,  0, 42, 51,  0,  0,  0,
     & 381,0.562,  0, 26, 30,  0,  0,  0,
     & 381,0.155,  0, 31, 21,  0,  0,  0,
     & 381,0.155,  0, 23, 30,  0,  0,  0,
     & 381,0.088,  0,293, 30,  0,  0,  0,
     & 381,0.020,  0, 34, 51,  0,  0,  0,
     & 381,0.020,  0, 50, 35,  0,  0,  0,
     & 382,0.360,  0, 31, 38, 38,  0,  0,
     & 382,0.180,  0, 23, 38, 21,  0,  0,
     & 382,0.040,  0, 39, 21, 21,  0,  0,
     & 382,0.020,  0, 39, 38, 30,  0,  0,
     & 382,0.300,  0, 38, 21,  0,  0,  0,
     & 382,0.040,  0, 46, 43,  0,  0,  0,
     & 382,0.040,  0, 42, 47,  0,  0,  0,
     & 382,0.020,  0, 22, 39,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=2110,2128)/
     & 383,0.180,  0, 39, 30, 21,  0,  0,
     & 383,0.180,  0, 31, 38, 21,  0,  0,
     & 383,0.160,  0, 23, 21, 21,  0,  0,
     & 383,0.080,  0, 23, 38, 30,  0,  0,
     & 383,0.300,  0, 38, 30,  0,  0,  0,
     & 383,0.020,  0, 46, 35,  0,  0,  0,
     & 383,0.020,  0, 50, 43,  0,  0,  0,
     & 383,0.020,  0, 34, 47,  0,  0,  0,
     & 383,0.020,  0, 42, 51,  0,  0,  0,
     & 383,0.020,  0, 22, 23,  0,  0,  0,
     & 384,0.360,  0, 39, 30, 30,  0,  0,
     & 384,0.180,  0, 23, 30, 21,  0,  0,
     & 384,0.040,  0, 31, 21, 21,  0,  0,
     & 384,0.020,  0, 31, 30, 38,  0,  0,
     & 384,0.300,  0, 30, 21,  0,  0,  0,
     & 384,0.040,  0, 34, 51,  0,  0,  0,
     & 384,0.040,  0, 50, 35,  0,  0,  0,
     & 384,0.020,  0, 22, 31,  0,  0,  0,
     & 385,0.184,  0, 41, 21,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=2129,2147)/
     & 385,0.184,  0, 29, 38,  0,  0,  0,
     & 385,0.184,  0, 39, 23,  0,  0,  0,
     & 385,0.236,  0, 38, 21,  0,  0,  0,
     & 385,0.160,  0, 24, 38,  0,  0,  0,
     & 385,0.018,  0, 46, 43,  0,  0,  0,
     & 385,0.018,  0, 42, 47,  0,  0,  0,
     & 385,0.016,  0, 46, 42,  0,  0,  0,
     & 386,0.184,  0, 41, 30,  0,  0,  0,
     & 386,0.184,  0, 33, 38,  0,  0,  0,
     & 386,0.184,  0, 39, 31,  0,  0,  0,
     & 386,0.236,  0, 38, 30,  0,  0,  0,
     & 386,0.160,  0, 24, 21,  0,  0,  0,
     & 386,0.009,  0, 46, 35,  0,  0,  0,
     & 386,0.009,  0, 50, 43,  0,  0,  0,
     & 386,0.009,  0, 34, 47,  0,  0,  0,
     & 386,0.009,  0, 42, 51,  0,  0,  0,
     & 386,0.008,  0, 46, 34,  0,  0,  0,
     & 386,0.008,  0, 42, 50,  0,  0,  0,
     & 387,0.184,  0, 33, 21,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=2148,2166)/
     & 387,0.184,  0, 29, 30,  0,  0,  0,
     & 387,0.184,  0, 31, 23,  0,  0,  0,
     & 387,0.236,  0, 30, 21,  0,  0,  0,
     & 387,0.160,  0, 24, 30,  0,  0,  0,
     & 387,0.018,  0, 34, 51,  0,  0,  0,
     & 387,0.018,  0, 50, 35,  0,  0,  0,
     & 387,0.016,  0, 34, 50,  0,  0,  0,
     & 388,0.183,  0,231, 38, 30,  0,  0,
     & 388,0.091,  0,231, 21, 21,  0,  0,
     & 388,0.067,  0, 59,307,  0,  0,  0,
     & 388,0.066,  0, 59,308,  0,  0,  0,
     & 388,0.043,  0, 59,309,  0,  0,  0,
     & 388,0.446,130, 13, 13, 13,  0,  0,
     & 388,0.023,130, 13, 13, 59,  0,  0,
     & 388,0.013,  0,121,127,  0,  0,  0,
     & 388,0.013,  0,123,129,  0,  0,  0,
     & 388,0.013,  0,125,131,  0,  0,  0,
     & 388,0.004,  0,  1,  7,  0,  0,  0,
     & 388,0.017,  0,  2,  8,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=2167,2185)/
     & 388,0.004,  0,  3,  9,  0,  0,  0,
     & 388,0.017,  0,  4, 10,  0,  0,  0,
     & 389,0.046,  0, 59,388,  0,  0,  0,
     & 389,0.009,  0, 59,231,  0,  0,  0,
     & 389,0.755,  0, 13, 13,  0,  0,  0,
     & 389,0.030,  0,121,127,  0,  0,  0,
     & 389,0.030,  0,123,129,  0,  0,  0,
     & 389,0.030,  0,125,131,  0,  0,  0,
     & 389,0.010,  0,  1,  7,  0,  0,  0,
     & 389,0.040,  0,  2,  8,  0,  0,  0,
     & 389,0.010,  0,  3,  9,  0,  0,  0,
     & 389,0.040,  0,  4, 10,  0,  0,  0,
     & 390,0.210,  0, 59,388,  0,  0,  0,
     & 390,0.085,  0, 59,231,  0,  0,  0,
     & 390,0.565,  0, 13, 13,  0,  0,  0,
     & 390,0.022,  0,121,127,  0,  0,  0,
     & 390,0.022,  0,123,129,  0,  0,  0,
     & 390,0.022,  0,125,131,  0,  0,  0,
     & 390,0.007,  0,  1,  7,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=2186,2204)/
     & 390,0.030,  0,  2,  8,  0,  0,  0,
     & 390,0.007,  0,  3,  9,  0,  0,  0,
     & 390,0.030,  0,  4, 10,  0,  0,  0,
     & 391,0.162,  0, 59,388,  0,  0,  0,
     & 391,0.071,  0, 59,231,  0,  0,  0,
     & 391,0.615,  0, 13, 13,  0,  0,  0,
     & 391,0.024,  0,121,127,  0,  0,  0,
     & 391,0.024,  0,123,129,  0,  0,  0,
     & 391,0.024,  0,125,131,  0,  0,  0,
     & 391,0.008,  0,  1,  7,  0,  0,  0,
     & 391,0.032,  0,  2,  8,  0,  0,  0,
     & 391,0.008,  0,  3,  9,  0,  0,  0,
     & 391,0.032,  0,  4, 10,  0,  0,  0,
     & 392,0.034,  0,267, 38, 30,  0,  0,
     & 392,0.017,  0,267, 21, 21,  0,  0,
     & 392,0.044,  0,231, 38, 30,  0,  0,
     & 392,0.022,  0,231, 21, 21,  0,  0,
     & 392,0.050,  0,267, 59, 59,  0,  0,
     & 392,0.114,  0, 59,389,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=2205,2223)/
     & 392,0.113,  0, 59,390,  0,  0,  0,
     & 392,0.054,  0, 59,391,  0,  0,  0,
     & 392,0.403,130, 13, 13, 13,  0,  0,
     & 392,0.021,130, 13, 13, 59,  0,  0,
     & 392,0.020,  0,121,127,  0,  0,  0,
     & 392,0.020,  0,123,129,  0,  0,  0,
     & 392,0.020,  0,125,131,  0,  0,  0,
     & 392,0.007,  0,  1,  7,  0,  0,  0,
     & 392,0.027,  0,  2,  8,  0,  0,  0,
     & 392,0.007,  0,  3,  9,  0,  0,  0,
     & 392,0.027,  0,  4, 10,  0,  0,  0,
     & 393,0.250,  0,246,222,  0,  0,  0,
     & 393,0.250,  0,245,221,  0,  0,  0,
     & 393,0.385,130, 13, 13, 13,  0,  0,
     & 393,0.020,130, 13, 13, 59,  0,  0,
     & 393,0.015,  0,121,127,  0,  0,  0,
     & 393,0.015,  0,123,129,  0,  0,  0,
     & 393,0.015,  0,125,131,  0,  0,  0,
     & 393,0.005,  0,  1,  7,  0,  0,  0/
      DATA (IDK(I),BRFRAC(I),NME(I),(IDKPRD(J,I),J=1,5),I=2224,2226)/
     & 393,0.020,  0,  2,  8,  0,  0,  0,
     & 393,0.005,  0,  3,  9,  0,  0,  0,
     & 393,0.020,  0,  4, 10,  0,  0,  0/
      END
