# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class DataArraySelection(Object):
    r"""
    DataArraySelection - Store on/off settings for data arrays, etc.
    
    Superclass: Object
    
    DataArraySelection is intended to be used by algorithms that want
    to expose a API that allow the user to enable/disable a collection of
    entities, such as arrays. Readers, for example, can use
    DataArraySelection to let the user choose which array to read from
    the file.
    
    Originally intended for selecting data arrays (hence the name), this
    class can be used for letting users choose other items too, for
    example, IOSSReader uses DataArraySelection to let users choose
    which blocks to read.
    
    Unlike most other Object subclasses, DataArraySelection has
    public API that need not modify the MTime for the object. These
    M-Time non-modifying methods are typically intended for use within
    the algorithm or reader to populate the DataArraySelection
    instance with available array names and their default values.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkDataArraySelection, obj, update, **traits)
    
    def get_array_setting(self, *args):
        """
        get_array_setting(self, index:int) -> int
        C++: int get_array_setting(int index)
        get_array_setting(self, name:str) -> int
        C++: int get_array_setting(const char *name)
        Get whether the array at the given index is enabled.
        """
        ret = self._wrap_call(self._vtk_obj.GetArraySetting, *args)
        return ret

    def set_array_setting(self, *args):
        """
        set_array_setting(self, name:str, setting:int) -> None
        C++: void set_array_setting(const char *name, int setting)
        Set array setting given the name. If the array doesn't exist, it
        will be added.
        
        This method will call `this->Modified()` if the enable state for
        the array changed.
        """
        ret = self._wrap_call(self._vtk_obj.SetArraySetting, *args)
        return ret

    unknown_array_setting = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Get/Set enabled state for any unknown arrays. Default is 0 i.e.
        not enabled. When set to 1, `array_is_enabled` will return 1 for
        any array not explicitly specified.
        """
    )

    def _unknown_array_setting_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUnknownArraySetting,
                        self.unknown_array_setting)

    def get_array_index(self, *args):
        """
        get_array_index(self, name:str) -> int
        C++: int get_array_index(const char *name)
        Get an index of the array with the given name.
        """
        ret = self._wrap_call(self._vtk_obj.GetArrayIndex, *args)
        return ret

    def get_array_name(self, *args):
        """
        get_array_name(self, index:int) -> str
        C++: const char *get_array_name(int index)
        Get the name of the array entry at the given index.
        """
        ret = self._wrap_call(self._vtk_obj.GetArrayName, *args)
        return ret

    def get_enabled_array_index(self, *args):
        """
        get_enabled_array_index(self, name:str) -> int
        C++: int get_enabled_array_index(const char *name)
        Get the index of an array with the given name among those that
        are enabled.  Returns -1 if the array is not enabled.
        """
        ret = self._wrap_call(self._vtk_obj.GetEnabledArrayIndex, *args)
        return ret

    def _get_number_of_arrays(self):
        return self._vtk_obj.GetNumberOfArrays()
    number_of_arrays = traits.Property(_get_number_of_arrays, desc=\
        r"""
        Get the number of arrays that currently have an entry.
        """
    )

    def _get_number_of_arrays_enabled(self):
        return self._vtk_obj.GetNumberOfArraysEnabled()
    number_of_arrays_enabled = traits.Property(_get_number_of_arrays_enabled, desc=\
        r"""
        Get the number of arrays that are enabled.
        """
    )

    def add_array(self, *args):
        """
        add_array(self, name:str, state:bool=True) -> int
        C++: int add_array(const char *name, bool state=true)
        Add to the list of arrays that have entries.  For arrays that
        already have entries, the settings are untouched.  For arrays
        that don't already have an entry, they are assumed to be enabled
        by default. The state can also be passed as the second argument.
        This method should be called only by the filter owning this
        object.
        
        This method **does not** call `this->Modified()`.
        
        Also note for arrays already known to this instance (i.e.
        `this->array_exists(name) == true`, this method has no effect.
        """
        ret = self._wrap_call(self._vtk_obj.AddArray, *args)
        return ret

    def array_exists(self, *args):
        """
        array_exists(self, name:str) -> int
        C++: int array_exists(const char *name)
        Return whether the array with the given name exists.
        """
        ret = self._wrap_call(self._vtk_obj.ArrayExists, *args)
        return ret

    def array_is_enabled(self, *args):
        """
        array_is_enabled(self, name:str) -> int
        C++: int array_is_enabled(const char *name)
        Return whether the array with the given name is enabled.  If
        there is no entry, the array is assumed to be disabled.
        """
        ret = self._wrap_call(self._vtk_obj.ArrayIsEnabled, *args)
        return ret

    def copy_selections(self, *args):
        """
        copy_selections(self, selections:DataArraySelection) -> None
        C++: void copy_selections(DataArraySelection *selections)
        Copy the selections from the given DataArraySelection
        instance.
        
        This method will call `this->Modified()` if the array selections
        changed.
        """
        my_args = deref_array(args, [['vtkDataArraySelection']])
        ret = self._wrap_call(self._vtk_obj.CopySelections, *my_args)
        return ret

    def deep_copy(self, *args):
        """
        deep_copy(self, other:DataArraySelection) -> None
        C++: void deep_copy(const DataArraySelection *other)
        Copy contents of other. The MTime for this instance is modified
        only if values are different.
        """
        my_args = deref_array(args, [['vtkDataArraySelection']])
        ret = self._wrap_call(self._vtk_obj.DeepCopy, *my_args)
        return ret

    def disable_all_arrays(self):
        """
        disable_all_arrays(self) -> None
        C++: void disable_all_arrays()
        Disable all arrays that currently have an entry.
        
        This method will call `this->Modified()` if the enable state for
        any of the known arrays is changed.
        """
        ret = self._vtk_obj.DisableAllArrays()
        return ret
        

    def disable_array(self, *args):
        """
        disable_array(self, name:str) -> None
        C++: void disable_array(const char *name)
        Disable the array with the given name.  Creates a new entry if
        none exists.
        
        This method will call `this->Modified()` if the enable state for
        the array changed.
        """
        ret = self._wrap_call(self._vtk_obj.DisableArray, *args)
        return ret

    def enable_all_arrays(self):
        """
        enable_all_arrays(self) -> None
        C++: void enable_all_arrays()
        Enable all arrays that currently have an entry.
        
        This method will call `this->Modified()` if the enable state for
        any of the known arrays is changed.
        """
        ret = self._vtk_obj.EnableAllArrays()
        return ret
        

    def enable_array(self, *args):
        """
        enable_array(self, name:str) -> None
        C++: void enable_array(const char *name)
        Enable the array with the given name.  Creates a new entry if
        none exists.
        
        This method will call `this->Modified()` if the enable state for
        the array changed.
        """
        ret = self._wrap_call(self._vtk_obj.EnableArray, *args)
        return ret

    def is_equal(self, *args):
        """
        is_equal(self, other:DataArraySelection) -> bool
        C++: bool is_equal(const DataArraySelection *other)
        Returns true if the two array selections are equivalent.
        """
        my_args = deref_array(args, [['vtkDataArraySelection']])
        ret = self._wrap_call(self._vtk_obj.IsEqual, *my_args)
        return ret

    def remove_all_arrays(self):
        """
        remove_all_arrays(self) -> None
        C++: void remove_all_arrays()
        Remove all array entries.
        
        This method will call `this->Modified()` if the arrays were
        cleared.
        """
        ret = self._vtk_obj.RemoveAllArrays()
        return ret
        

    def remove_array_by_index(self, *args):
        """
        remove_array_by_index(self, index:int) -> None
        C++: void remove_array_by_index(int index)
        Remove an array setting given its index.
        
        This method **does not** call `this->Modified()`.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveArrayByIndex, *args)
        return ret

    def remove_array_by_name(self, *args):
        """
        remove_array_by_name(self, name:str) -> None
        C++: void remove_array_by_name(const char *name)
        Remove an array setting given its name.
        
        This method **does not** call `this->Modified()`.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveArrayByName, *args)
        return ret

    def union(self, *args):
        """
        union(self, other:DataArraySelection) -> None
        C++: void union(DataArraySelection *other)
        union(self, other:DataArraySelection, skipModified:bool)
            -> None
        C++: void union(DataArraySelection *other, bool skipModified)
        Update `this` to include values from `other`. For arrays that
        don't exist in `this` but exist in `other`, they will get added
        to `this` with the same array setting as in `other`. Array
        settings for arrays already in `this` are left unchanged.
        
        This method will call `this->Modified()` if the array selections
        changed unless skipModified is set to true (default is false).
        """
        my_args = deref_array(args, [['vtkDataArraySelection'], ('vtkDataArraySelection', 'bool')])
        ret = self._wrap_call(self._vtk_obj.Union, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('unknown_array_setting',
    'GetUnknownArraySetting'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name',
    'unknown_array_setting'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(DataArraySelection, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit DataArraySelection properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name', 'unknown_array_setting']),
            title='Edit DataArraySelection properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit DataArraySelection properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

