<div align="center"><img src="https://magit.vc/assets/magit-168x200px.png"/></div>
<h2 align="center">A Git Porcelain inside Emacs</h2>
<p align="center">
  <a href="https://magit.vc"><b>homepage</b></a> |
  <a href="https://magit.vc/manual"><b>manual</b></a> |
  <a href="https://magit.vc/manual/magit/FAQ.html"><b>faq</b></a> |
  <a href="https://github.com/magit/magit/wiki"><b>wiki</b></a> |
  <a href="https://groups.google.com/forum/?fromgroups#!forum/magit"><b>mailing list</b></a> |
  <a href="https://emacs.stackexchange.com/questions/tagged/magit"><b>forum</b></a> |
  <a href="https://twitter.com/magit_emacs"><b>news</b></a>
</p>
<hr>

<p align="justify">
  Magit is an interface to the version control system
  <a href="https://git-scm.com">Git</a>, implemented as an
  <a href="https://www.gnu.org/software/emacs">Emacs</a> package.
  Magit aspires to be a complete Git porcelain.  While we cannot
  (yet) claim that Magit wraps and improves upon each and every Git
  command, it is complete enough to allow even experienced Git users
  to perform almost all of their daily version control tasks directly
  from within Emacs.  While many fine Git clients exist, only Magit
  and Git itself deserve to be called porcelains.
  <a href="https://magit.vc/about">(more)</a>
</p>
<hr>

<div align="center">
  <a href="https://magit.vc/buy">
	<img src="https://magit.vc/assets/stickers1x.png">
  </a>
  <br>
  Please support Magit by
  <a href="https://magit.vc/buy">buying some stickers</a>!
</div>
<hr>

<div align="justify">
  <a href="https://github.com/magit/magit/blob/master/Documentation/BACKERS.md">1987 backers</a>
  made sure the Kickstarter campaign was a huge success!
  Thanks for your generosity and enthusiastic support!
</div>
<div align="center">
  <em><b>Thank you!</b> &mdash; Jonas Bernoulli</em><br><br>
  <img src="https://magit.vc/assets/pixel-heart.png">
</div>
<br>
<div align="center">
  <em>My thanks also go to these three sponsors!</em><br><br>
  <a href="https://www.mojotech.com">
    <img title="Mojotech"
         alt="Mojotech"
         src="https://magit.vc/assets/mojotech.png"></a>
  <a href="https://opensource.google.com">
    <img title="Google Open Source"
         alt="Google Open Source"
         src="https://magit.vc/assets/google-os.png"></a>
  <a href="http://www.directangular.com">
    <img title="Directangular"
         alt="Directangular"
         src="https://magit.vc/assets/directangular.png"></a>
</div>
<br>
<hr>

Support
=======

When something doesn't work as expected then please first see the
[FAQ][faq].  Then also try the list of [open issues][issues] and use
the search box at the top of that page to find older related issues.
You should also consult the [manual][manual] and ask a general-purpose
search engine.

If that doesn't answer your question, then ask for help on the
**[Emacs Stackexchange site][forum]** or the [mailing list][list].
We only use the GitHub issue tracker for feature requests and bug
reports, so please don't ask for help there.

Contributing
============

To report bugs and suggest new feature use the
[issue tracker][issues].  If you have some code which you would like
to be merged, then open a [pull request][pulls]. Please also see
[CONTRIBUTING.md][contrib].

Acknowledgments
===============

Magit was started by [Marius Vollmer][marius], and is now maintained
by [Jonas Bernoulli][jonas], [Kyle Meyer][kyle], and
[Noam Postavsky][noam].  Other former maintainers are
[Nicolas Dudebout][nicolas], [Peter J. Weisberg][peter],
[Phil Jackson][phil], [Rémi Vanicat][remi], and [Yann Hodique][yann].
Many more people have [contributed code][authors] and suggested
features.

Thanks to all of you, may (the history of) the source be with you!

***
[![GPL v3](https://img.shields.io/badge/license-GPL_v3-green.svg)](http://www.gnu.org/licenses/gpl-3.0.txt)
[![Build Status](https://travis-ci.org/magit/magit.svg?branch=master)](https://travis-ci.org/magit/magit)
[![Melpa](https://melpa.org/packages/magit-badge.svg)](https://melpa.org/#/magit)
[![Melpa Stable](https://stable.melpa.org/packages/magit-badge.svg)](https://stable.melpa.org/#/magit)
[![Git Xkcd](https://img.shields.io/badge/xkcd-git-orange.svg)](https://xkcd.com/1597)
[![Eierlegende Wollmilchsau](https://img.shields.io/badge/eierlegende-Wollmilchsau-green.svg)](https://magit.vc/manual/magit)
[![Swiss Made](https://img.shields.io/badge/swiss-made-red.svg?colorA=E11A27&colorB=555555)](https://magit.vc/stats/authors.html#commits_per_author)
[![Netscape](https://magit.vc/assets/netscape-20px.png)](https://en.wikipedia.org/wiki/Browser_wars)
[![Paren Xkcb](https://img.shields.io/badge/%28-%20%20%20-red.svg)](https://xkcd.com/859)


[contrib]: https://github.com/magit/magit/blob/master/.github/CONTRIBUTING.md
[issues]:  https://github.com/magit/magit/issues
[pulls]:   https://github.com/magit/magit/pulls

[authors]: https://magit.vc/stats/authors.html
[faq]:     https://magit.vc/manual/magit/FAQ.html
[manual]:  https://magit.vc/manual

[forum]:   https://emacs.stackexchange.com/questions/tagged/magit
[list]:    https://groups.google.com/forum/?fromgroups#!forum/magit

[jonas]:   https://emacsair.me
[kyle]:    https://github.com/kyleam
[marius]:  https://github.com/mvollmer
[nicolas]: http://dudebout.com
[noam]:    https://github.com/npostavs
[peter]:   https://github.com/pjweisberg
[phil]:    https://github.com/philjackson
[remi]:    https://github.com/vanicat
[yann]:    http://www.hodique.info
