/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file IsoShadingAttributes.cc
    \brief Implementation of IsoShading Attributes class.
    \author Meteorological Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Mon Apr 15 17:55:21 2013
*/    

#include "IsoShadingAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


IsoShadingAttributes::IsoShadingAttributes():
	technique_(MagTranslator<string, ShadingTechnique>().magics("contour_shade_technique")),
	max_(ParameterManager::getDouble("contour_shade_max_level")),
	min_(ParameterManager::getDouble("contour_shade_min_level")),
	colourMethod_(MagTranslator<string, ColourTechnique>().magics("contour_shade_colour_method"))
{
} 



IsoShadingAttributes::~IsoShadingAttributes()
{
}

    
void IsoShadingAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(5);
	prefix[0] = "contour_shade";
	prefix[1] = "contour_shade";
	prefix[2] = "contour_shade";
	prefix[3] = "contour";
	prefix[4] = "contour";

	setMember(prefix, "contour_shade_technique", technique_, params);
	setAttribute(prefix, "contour_shade_max_level", max_, params);
	setAttribute(prefix, "contour_shade_min_level", min_, params);
	setMember(prefix, "contour_shade_colour_method", colourMethod_, params);
}

void IsoShadingAttributes::copy(const IsoShadingAttributes& other)
{
	technique_ = auto_ptr<ShadingTechnique>(other.technique_->clone());
	max_ = other.max_;
	min_ = other.min_;
	colourMethod_ = auto_ptr<ColourTechnique>(other.colourMethod_->clone());
} 


bool IsoShadingAttributes::accept(const string& node)
{	
	if ( magCompare(node, "shading")  )
		return true;

	if ( acceptNode(node, technique_) )
		return true;

	if ( acceptNode(node, colourMethod_) )
		return true;
	return false;
}

void IsoShadingAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "shading") )
		set(node.attributes());
	else {
		setMember(node.name(), technique_, node);
		setMember(node.name(), colourMethod_, node);
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
		setMember((*elt)->name(), technique_, *(*elt)); 
		setMember((*elt)->name(), colourMethod_, *(*elt)); 
	}
}

void IsoShadingAttributes::print(ostream& out)  const
{
	out << "IsoShadingAttributes[";
	out << "technique = " << *technique_;
	out << ", max = " << max_;
	out << ", min = " << min_;
	out << ", colourMethod = " << *colourMethod_;
	out << "]" << "\n";
}


void IsoShadingAttributes::toxml(ostream& out)  const
{
     out <<  "\"shading\"";
	 out << ", \"contour_shade_technique\":";
	 technique_->toxml(out);
	 out << ", \"contour_shade_max_level\":";
	 niceprint(out,max_);
	 out << ", \"contour_shade_min_level\":";
	 niceprint(out,min_);
	 out << ", \"contour_shade_colour_method\":";
	 colourMethod_->toxml(out);
}
static MagicsParameter<string> contour_shade_technique("contour_shade_technique", "polygon_shading", "");
static MagicsParameter<double> contour_shade_max_level("contour_shade_max_level", 1.0e+21, "");
static MagicsParameter<double> contour_shade_min_level("contour_shade_min_level", -1.0e+21, "");
static MagicsParameter<string> contour_shade_colour_method("contour_shade_colour_method", "calculate", "");
#include "PolyShadingTechnique.h"
#include "MarkerShadingTechnique.h"
#include "CellShading.h"
static SimpleObjectMaker<PolyShadingTechnique, ShadingTechnique> polygon_shading_PolyShadingTechnique("polygon_shading");
static SimpleObjectMaker<PolyShadingTechnique, ShadingTechnique> polygon_PolyShadingTechnique("polygon");
static SimpleObjectMaker<GridShading, ShadingTechnique> grid_shading_GridShading("grid_shading");
static SimpleObjectMaker<CellShading, ShadingTechnique> cell_shading_CellShading("cell_shading");
static SimpleObjectMaker<MarkerShadingTechnique, ShadingTechnique> marker_MarkerShadingTechnique("marker");
#include "CalculateColourTechnique.h"
#include "ListColourTechnique.h"
static SimpleObjectMaker<CalculateColourTechnique, ColourTechnique> calculate_CalculateColourTechnique("calculate");
static SimpleObjectMaker<ListColourTechnique, ColourTechnique> list_ListColourTechnique("list");
