/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * Authors:
 *  Olivier Tilloy <olivier.tilloy@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import Qt 4.7

Rectangle {

    // A simple key
    GConfItem {
        id: key1
        key: "/desktop/unity/panel/search_hint"

        function printme() {
            console.log(key + " = " + value)
        }

        Component.onCompleted: printme()
        onValueChanged: printme()
    }

    // A key that has several entries
    GConfItem {
        id: key2
        key: "/desktop/unity/panel"

        function printme() {
            console.log(key)
            for (var i = 0; i < entries.length; ++i)
            {
                var entry = Qt.createQmlObject("GConfItem {key: \"" + entries[i] + "\" }", key2)
                if (entry.value != undefined) {
                    console.log("   » " + entry.key + " = " + entry.value)
                }
                // FIXME: the entry dynamically instantiated is kept around and
                // leaks memory. Calling entry.destroy() has the weird side
                // effect that some entries are not printed on the console.
                //entry.destroy()
            }
        }

        Component.onCompleted: printme()
        onEntriesChanged: printme()
    }

    // A key that has several sub-directories
    GConfItem {
        id: key3
        key: "/desktop/unity/launcher/favorites"

        function printme() {
            console.log(key)
            for (var i = 0; i < dirs.length; ++i)
            {
                console.log("   » " + dirs[i])
            }
        }

        Component.onCompleted: printme()
        onDirsChanged: printme()
    }
}

