#include "osl/hash/hashRandom.h"
#include "osl/stat/variance.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>
#include <fstream>
#include <sstream>
#include <cmath>

class HashRandomTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(HashRandomTest);
  CPPUNIT_TEST(testSetUp);
  CPPUNIT_TEST_SUITE_END();
public:
  void testSetUp();
};

using namespace osl;

CPPUNIT_TEST_SUITE_REGISTRATION(HashRandomTest);

void HashRandomTest::testSetUp()
{
    double sigma = 10.0;
    HashRandom::setUp(sigma);
    stat::Variance var;
    
    for (size_t i=0; i<HashRandom::Length; ++i)
	var.add(HashRandom::value(i));
    CPPUNIT_ASSERT_DOUBLES_EQUAL(0.0, var.getAverage(), 1);
    CPPUNIT_ASSERT_DOUBLES_EQUAL(sigma, sqrt(var.variance()), 1.2);
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
