/*
 * Known folder identifier functions
 *
 * Copyright (C) 2010-2024, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include <common.h>
#include <memory.h>
#include <types.h>

#include "libfwsi_known_folder_identifier.h"
#include "libfwsi_libcerror.h"

uint8_t libfwsi_known_folder_identifier_3d_objects[ 16 ] = {
	0x25, 0xdd, 0xc0, 0x31, 0x39, 0x94, 0x12, 0x4f, 0xbf, 0x41, 0x7f, 0xf4, 0xed, 0xa3, 0x87, 0x22 };

uint8_t libfwsi_known_folder_identifier_accountpictures[ 16 ] = {
	0xb1, 0xa0, 0x8c, 0x00, 0xb4, 0x55, 0x56, 0x4c, 0xb8, 0xa8, 0x4d, 0xe4, 0xb2, 0x99, 0xd3, 0xbe };

uint8_t libfwsi_known_folder_identifier_addnewprogramsfolder[ 16 ] = {
	0x71, 0xd9, 0x61, 0xde, 0xbc, 0x5e, 0x02, 0x4f, 0xa3, 0xa9, 0x6c, 0x82, 0x89, 0x5e, 0x5c, 0x04 };

uint8_t libfwsi_known_folder_identifier_administrative_tools[ 16 ] = {
	0x70, 0xf1, 0x4e, 0x72, 0x2d, 0xa4, 0xef, 0x4f, 0x9f, 0x26, 0xb6, 0x0e, 0x84, 0x6f, 0xba, 0x4f };

uint8_t libfwsi_known_folder_identifier_appdata[ 16 ] = {
	0xdb, 0x85, 0xb6, 0x3e, 0xf9, 0x65, 0xf6, 0x4c, 0xa0, 0x3a, 0xe3, 0xef, 0x65, 0x72, 0x9f, 0x3d };

uint8_t libfwsi_known_folder_identifier_appdatadesktop[ 16 ] = {
	0x79, 0xe2, 0xc5, 0xb2, 0xdd, 0x7a, 0x9f, 0x43, 0xb2, 0x8c, 0xc4, 0x1f, 0xe1, 0xbb, 0xf6, 0x72 };

uint8_t libfwsi_known_folder_identifier_appdatadocuments[ 16 ] = {
	0x10, 0x66, 0xe1, 0x7b, 0x7f, 0x1f, 0xac, 0x44, 0xbf, 0xf0, 0x83, 0xe1, 0x5f, 0x2f, 0xfc, 0xa1 };

uint8_t libfwsi_known_folder_identifier_appdatafavorites[ 16 ] = {
	0xbc, 0xef, 0xfb, 0x7c, 0x1f, 0xde, 0xaa, 0x45, 0xb8, 0x43, 0xa5, 0x42, 0xac, 0x53, 0x6c, 0xc9 };

uint8_t libfwsi_known_folder_identifier_appdataprogramdata[ 16 ] = {
	0xa3, 0x40, 0x9d, 0x55, 0x36, 0xa0, 0xfa, 0x40, 0xaf, 0x61, 0x84, 0xcb, 0x43, 0x0a, 0x4d, 0x34 };

uint8_t libfwsi_known_folder_identifier_application_shortcuts[ 16 ] = {
	0x81, 0x87, 0x91, 0xa3, 0xf2, 0xe5, 0x90, 0x48, 0xb3, 0xd9, 0xa7, 0xe5, 0x43, 0x32, 0x32, 0x8c };

uint8_t libfwsi_known_folder_identifier_appmods[ 16 ] = {
	0x99, 0x78, 0xd6, 0x7a, 0xaf, 0x66, 0xba, 0x43, 0x91, 0x56, 0x6a, 0xad, 0x42, 0xe6, 0xc5, 0x96 };

uint8_t libfwsi_known_folder_identifier_appsfolder[ 16 ] = {
	0x8d, 0x50, 0x87, 0x1e, 0xc2, 0x89, 0xf0, 0x42, 0x8a, 0x7e, 0x64, 0x5a, 0x0f, 0x50, 0xca, 0x58 };

uint8_t libfwsi_known_folder_identifier_appupdatesfolder[ 16 ] = {
	0x99, 0xce, 0x05, 0xa3, 0x27, 0xf5, 0x2b, 0x49, 0x8b, 0x1a, 0x7e, 0x76, 0xfa, 0x98, 0xd6, 0xe4 };

uint8_t libfwsi_known_folder_identifier_cache[ 16 ] = {
	0xe8, 0x81, 0x24, 0x35, 0xbe, 0x33, 0x51, 0x42, 0xba, 0x85, 0x60, 0x07, 0xca, 0xed, 0xcf, 0x9d };

uint8_t libfwsi_known_folder_identifier_camera_roll[ 16 ] = {
	0x7b, 0xb8, 0x5f, 0xab, 0xe2, 0x7c, 0x83, 0x4f, 0x91, 0x5d, 0x55, 0x08, 0x46, 0xc9, 0x53, 0x7b };

uint8_t libfwsi_known_folder_identifier_camerarolllibrary[ 16 ] = {
	0x75, 0xdf, 0x20, 0x2b, 0xda, 0x1e, 0x39, 0x40, 0x80, 0x97, 0x38, 0x79, 0x82, 0x27, 0xd5, 0xb7 };

uint8_t libfwsi_known_folder_identifier_captures[ 16 ] = {
	0x71, 0xfe, 0xc0, 0xed, 0xd8, 0x98, 0x4a, 0x4f, 0xb9, 0x20, 0xc8, 0xdc, 0x13, 0x3c, 0xb1, 0x65 };

uint8_t libfwsi_known_folder_identifier_cd_burning[ 16 ] = {
	0x10, 0xab, 0x52, 0x9e, 0x0d, 0xf8, 0xdf, 0x49, 0xac, 0xb8, 0x43, 0x30, 0xf5, 0x68, 0x78, 0x55 };

uint8_t libfwsi_known_folder_identifier_changeremoveprogramsfolder[ 16 ] = {
	0xac, 0x66, 0x72, 0xdf, 0x74, 0x92, 0x67, 0x48, 0x8d, 0x55, 0x3b, 0xd6, 0x61, 0xde, 0x87, 0x2d };

uint8_t libfwsi_known_folder_identifier_common_administrative_tools[ 16 ] = {
	0x7d, 0x4e, 0x38, 0xd0, 0xc3, 0xba, 0x97, 0x47, 0x8f, 0x14, 0xcb, 0xa2, 0x29, 0xb3, 0x92, 0xb5 };

uint8_t libfwsi_known_folder_identifier_common_appdata[ 16 ] = {
	0x82, 0x5d, 0xab, 0x62, 0xc1, 0xfd, 0xc3, 0x4d, 0xa9, 0xdd, 0x07, 0x0d, 0x1d, 0x49, 0x5d, 0x97 };

uint8_t libfwsi_known_folder_identifier_common_desktop[ 16 ] = {
	0x0d, 0x34, 0xaa, 0xc4, 0x0f, 0xf2, 0x63, 0x48, 0xaf, 0xef, 0xf8, 0x7e, 0xf2, 0xe6, 0xba, 0x25 };

uint8_t libfwsi_known_folder_identifier_common_documents[ 16 ] = {
	0xaf, 0x24, 0x48, 0xed, 0xe4, 0xdc, 0xa8, 0x45, 0x81, 0xe2, 0xfc, 0x79, 0x65, 0x08, 0x36, 0x34 };

uint8_t libfwsi_known_folder_identifier_common_programs[ 16 ] = {
	0x4e, 0xd4, 0x39, 0x01, 0xfe, 0x6a, 0xf2, 0x49, 0x86, 0x90, 0x3d, 0xaf, 0xca, 0xe6, 0xff, 0xb8 };

uint8_t libfwsi_known_folder_identifier_common_start_menu[ 16 ] = {
	0x19, 0x57, 0x11, 0xa4, 0x2e, 0xd6, 0x1d, 0x49, 0xaa, 0x7c, 0xe7, 0x4b, 0x8b, 0xe3, 0xb0, 0x67 };

uint8_t libfwsi_known_folder_identifier_common_start_menu_places[ 16 ] = {
	0x9f, 0x87, 0x40, 0xa4, 0xa0, 0x87, 0x7d, 0x4f, 0xb7, 0x00, 0x02, 0x07, 0xb9, 0x66, 0x19, 0x4a };

uint8_t libfwsi_known_folder_identifier_common_startup[ 16 ] = {
	0x35, 0xea, 0xa5, 0x82, 0xcd, 0xd9, 0xc5, 0x47, 0x96, 0x29, 0xe1, 0x5d, 0x2f, 0x71, 0x4e, 0x6e };

uint8_t libfwsi_known_folder_identifier_common_templates[ 16 ] = {
	0xe7, 0x37, 0x42, 0xb9, 0xac, 0x57, 0x47, 0x43, 0x91, 0x51, 0xb0, 0x8c, 0x6c, 0x32, 0xd1, 0xf7 };

uint8_t libfwsi_known_folder_identifier_commondownloads[ 16 ] = {
	0x9b, 0x4c, 0x64, 0x3d, 0xb8, 0x1f, 0x30, 0x4f, 0x9b, 0x45, 0xf6, 0x70, 0x23, 0x5f, 0x79, 0xc0 };

uint8_t libfwsi_known_folder_identifier_commonmusic[ 16 ] = {
	0xb5, 0xfa, 0x14, 0x32, 0x57, 0x97, 0x98, 0x42, 0xbb, 0x61, 0x92, 0xa9, 0xde, 0xaa, 0x44, 0xff };

uint8_t libfwsi_known_folder_identifier_commonpictures[ 16 ] = {
	0x86, 0xfb, 0xeb, 0xb6, 0x07, 0x69, 0x3c, 0x41, 0x9a, 0xf7, 0x4f, 0xc2, 0xab, 0xf0, 0x7c, 0xc5 };

uint8_t libfwsi_known_folder_identifier_commonringtones[ 16 ] = {
	0x60, 0xab, 0x55, 0xe5, 0x3b, 0x15, 0x17, 0x4d, 0x9f, 0x04, 0xa5, 0xfe, 0x99, 0xfc, 0x15, 0xec };

uint8_t libfwsi_known_folder_identifier_commonvideo[ 16 ] = {
	0x3a, 0x18, 0x00, 0x24, 0x85, 0x61, 0xfb, 0x49, 0xa2, 0xd8, 0x4a, 0x39, 0x2a, 0x60, 0x2b, 0xa3 };

uint8_t libfwsi_known_folder_identifier_conflictfolder[ 16 ] = {
	0x45, 0xfb, 0xfe, 0x4b, 0x7d, 0x34, 0x06, 0x40, 0xa5, 0xbe, 0xac, 0x0c, 0xb0, 0x56, 0x71, 0x92 };

uint8_t libfwsi_known_folder_identifier_connectionsfolder[ 16 ] = {
	0x2b, 0xd9, 0x0c, 0x6f, 0x97, 0x2e, 0xd1, 0x45, 0x88, 0xff, 0xb0, 0xd1, 0x86, 0xb8, 0xde, 0xdd };

uint8_t libfwsi_known_folder_identifier_contacts[ 16 ] = {
	0x54, 0x48, 0x78, 0x56, 0xcb, 0xc6, 0x2b, 0x46, 0x81, 0x69, 0x88, 0xe3, 0x50, 0xac, 0xb8, 0x82 };

uint8_t libfwsi_known_folder_identifier_controlpanelfolder[ 16 ] = {
	0xeb, 0x4a, 0xa7, 0x82, 0xb4, 0xae, 0x5c, 0x46, 0xa0, 0x14, 0xd0, 0x97, 0xee, 0x34, 0x6d, 0x63 };

uint8_t libfwsi_known_folder_identifier_cookies[ 16 ] = {
	0x5d, 0x76, 0x0f, 0x2b, 0xe9, 0xc0, 0x71, 0x41, 0x90, 0x8e, 0x08, 0xa6, 0x11, 0xb8, 0x4f, 0xf6 };

uint8_t libfwsi_known_folder_identifier_credentialmanager[ 16 ] = {
	0xfb, 0x21, 0x52, 0x91, 0xfe, 0x9e, 0xda, 0x4b, 0x8f, 0xd7, 0xf7, 0x8d, 0xca, 0x77, 0x4f, 0x87 };

uint8_t libfwsi_known_folder_identifier_cryptokeys[ 16 ] = {
	0xaa, 0x4d, 0x8f, 0xb8, 0xbd, 0xe7, 0xa9, 0x49, 0xb7, 0x4d, 0x02, 0x88, 0x5a, 0x5d, 0xc7, 0x65 };

uint8_t libfwsi_known_folder_identifier_cscfolder[ 16 ] = {
	0x46, 0xe4, 0x32, 0xee, 0xca, 0x31, 0xba, 0x4a, 0x81, 0x4f, 0xa5, 0xeb, 0xd2, 0xfd, 0x6d, 0x5e };

uint8_t libfwsi_known_folder_identifier_default_gadgets[ 16 ] = {
	0x54, 0x6e, 0x39, 0x7b, 0xc5, 0x9e, 0x00, 0x43, 0xbe, 0x0a, 0x24, 0x82, 0xeb, 0xae, 0x1a, 0x26 };

uint8_t libfwsi_known_folder_identifier_desktop[ 16 ] = {
	0x3a, 0xcc, 0xbf, 0xb4, 0x2c, 0xdb, 0x4c, 0x42, 0xb0, 0x29, 0x7f, 0xe9, 0x9a, 0x87, 0xc6, 0x41 };

uint8_t libfwsi_known_folder_identifier_development_files[ 16 ] = {
	0x8e, 0xe0, 0xe8, 0xdb, 0x53, 0x30, 0xbc, 0x4b, 0xb1, 0x83, 0x2a, 0x7b, 0x2b, 0x19, 0x1e, 0x59 };

uint8_t libfwsi_known_folder_identifier_device_metadata_store[ 16 ] = {
	0xe9, 0xa5, 0xe4, 0x5c, 0xeb, 0xe4, 0x9d, 0x47, 0xb8, 0x9f, 0x13, 0x0c, 0x02, 0x88, 0x61, 0x55 };

uint8_t libfwsi_known_folder_identifier_documentslibrary[ 16 ] = {
	0x7d, 0xb1, 0x0d, 0x7b, 0xd2, 0x9c, 0x93, 0x4a, 0x97, 0x33, 0x46, 0xcc, 0x89, 0x02, 0x2e, 0x7c };

uint8_t libfwsi_known_folder_identifier_downloads[ 16 ] = {
	0x90, 0xe2, 0x4d, 0x37, 0x3f, 0x12, 0x65, 0x45, 0x91, 0x64, 0x39, 0xc4, 0x92, 0x5e, 0x46, 0x7b };

uint8_t libfwsi_known_folder_identifier_dpapikeys[ 16 ] = {
	0xd0, 0x7c, 0xc0, 0x10, 0x91, 0xef, 0x67, 0x45, 0xb8, 0x50, 0x44, 0x8b, 0x77, 0xcb, 0x37, 0xf9 };

uint8_t libfwsi_known_folder_identifier_favorites[ 16 ] = {
	0x61, 0xf7, 0x77, 0x17, 0xad, 0x68, 0x8a, 0x4d, 0x87, 0xbd, 0x30, 0xb7, 0x59, 0xfa, 0x33, 0xdd };

uint8_t libfwsi_known_folder_identifier_fonts[ 16 ] = {
	0xb7, 0x8c, 0x22, 0xfd, 0x11, 0xae, 0xe3, 0x4a, 0x86, 0x4c, 0x16, 0xf3, 0x91, 0x0a, 0xb8, 0xfe };

uint8_t libfwsi_known_folder_identifier_gadgets[ 16 ] = {
	0x2e, 0x36, 0x5d, 0xa7, 0xfc, 0x50, 0xb7, 0x4f, 0xac, 0x2c, 0xa8, 0xbe, 0xaa, 0x31, 0x44, 0x93 };

uint8_t libfwsi_known_folder_identifier_games[ 16 ] = {
	0x1a, 0x2c, 0xc5, 0xca, 0x3d, 0xb5, 0xdc, 0x4e, 0x92, 0xd7, 0x6b, 0x2e, 0x8a, 0xc1, 0x94, 0x34 };

uint8_t libfwsi_known_folder_identifier_gametasks[ 16 ] = {
	0x61, 0xae, 0x4f, 0x05, 0xd8, 0x4d, 0x87, 0x47, 0x80, 0xb6, 0x09, 0x02, 0x20, 0xc4, 0xb7, 0x00 };

uint8_t libfwsi_known_folder_identifier_history[ 16 ] = {
	0x3b, 0x8a, 0xdc, 0xd9, 0x84, 0xb7, 0x2e, 0x43, 0xa7, 0x81, 0x5a, 0x11, 0x30, 0xa7, 0x59, 0x63 };

uint8_t libfwsi_known_folder_identifier_homegroupcurrentuserfolder[ 16 ] = {
	0xa3, 0xb6, 0x74, 0x9b, 0xfd, 0x0d, 0x11, 0x4f, 0x9e, 0x78, 0x5f, 0x78, 0x00, 0xf2, 0xe7, 0x72 };

uint8_t libfwsi_known_folder_identifier_homegroupfolder[ 16 ] = {
	0x6b, 0x8a, 0x52, 0x52, 0xe3, 0xb9, 0xdd, 0x4a, 0xb6, 0x0d, 0x58, 0x8c, 0x2d, 0xba, 0x84, 0x2d };

uint8_t libfwsi_known_folder_identifier_implicitappshortcuts[ 16 ] = {
	0x6f, 0x25, 0xb5, 0xbc, 0xf6, 0x79, 0xee, 0x4c, 0xb7, 0x25, 0xdc, 0x34, 0xe4, 0x02, 0xfd, 0x46 };

uint8_t libfwsi_known_folder_identifier_internetfolder[ 16 ] = {
	0x74, 0x78, 0x9f, 0x4d, 0x0c, 0x4e, 0x04, 0x49, 0x96, 0x7b, 0x40, 0xb0, 0xd2, 0x0c, 0x3e, 0x4b };

uint8_t libfwsi_known_folder_identifier_libraries[ 16 ] = {
	0xdc, 0xa5, 0x3e, 0x1b, 0x87, 0xb5, 0x86, 0x47, 0xb4, 0xef, 0xbd, 0x1d, 0xc3, 0x32, 0xae, 0xae };

uint8_t libfwsi_known_folder_identifier_links[ 16 ] = {
	0xe0, 0xd5, 0xb9, 0xbf, 0xa9, 0xc6, 0x4c, 0x40, 0xb2, 0xb2, 0xae, 0x6d, 0xb6, 0xaf, 0x49, 0x68 };

uint8_t libfwsi_known_folder_identifier_local_appdata[ 16 ] = {
	0x85, 0x27, 0xb3, 0xf1, 0xba, 0x6f, 0xcf, 0x4f, 0x9d, 0x55, 0x7b, 0x8e, 0x7f, 0x15, 0x70, 0x91 };

uint8_t libfwsi_known_folder_identifier_local_documents[ 16 ] = {
	0xd3, 0xe2, 0x2e, 0xf4, 0x9f, 0x90, 0x07, 0x49, 0x88, 0x71, 0x4c, 0x22, 0xfc, 0x0b, 0xf7, 0x56 };

uint8_t libfwsi_known_folder_identifier_local_downloads[ 16 ] = {
	0x9b, 0xee, 0x83, 0x7d, 0x44, 0x22, 0x70, 0x4e, 0xb1, 0xf5, 0x53, 0x93, 0x04, 0x2a, 0xf1, 0xe4 };

uint8_t libfwsi_known_folder_identifier_local_music[ 16 ] = {
	0x99, 0x9a, 0xc6, 0xa0, 0xc8, 0x21, 0x71, 0x46, 0x87, 0x03, 0x79, 0x34, 0x16, 0x2f, 0xcf, 0x1d };

uint8_t libfwsi_known_folder_identifier_local_pictures[ 16 ] = {
	0x5d, 0x01, 0xdd, 0x0d, 0x6c, 0xb0, 0xd5, 0x45, 0x8c, 0x4c, 0xf5, 0x97, 0x13, 0x85, 0x46, 0x39 };

uint8_t libfwsi_known_folder_identifier_local_videos[ 16 ] = {
	0x68, 0x6a, 0x28, 0x35, 0x57, 0x3c, 0xa1, 0x41, 0xbb, 0xb1, 0x0e, 0xae, 0x73, 0xd7, 0x6c, 0x95 };

uint8_t libfwsi_known_folder_identifier_localappdatalow[ 16 ] = {
	0xa4, 0xa1, 0x20, 0xa5, 0x80, 0x17, 0xf6, 0x4f, 0xbd, 0x18, 0x16, 0x73, 0x43, 0xc5, 0xaf, 0x16 };

uint8_t libfwsi_known_folder_identifier_localizedresourcesdir[ 16 ] = {
	0x5e, 0x37, 0x00, 0x2a, 0x4c, 0x22, 0xde, 0x49, 0xb8, 0xd1, 0x44, 0x0d, 0xf7, 0xef, 0x3d, 0xdc };

uint8_t libfwsi_known_folder_identifier_mapifolder[ 16 ] = {
	0x18, 0x0e, 0xec, 0x98, 0x98, 0x20, 0x44, 0x4d, 0x86, 0x44, 0x66, 0x97, 0x93, 0x15, 0xa2, 0x81 };

uint8_t libfwsi_known_folder_identifier_musiclibrary[ 16 ] = {
	0x0a, 0xab, 0x12, 0x21, 0x6a, 0xc8, 0xfe, 0x4f, 0xa3, 0x68, 0x0d, 0xe9, 0x6e, 0x47, 0x01, 0x2e };

uint8_t libfwsi_known_folder_identifier_my_music[ 16 ] = {
	0x71, 0xd5, 0xd8, 0x4b, 0x19, 0x6d, 0xd3, 0x48, 0xbe, 0x97, 0x42, 0x22, 0x20, 0x08, 0x0e, 0x43 };

uint8_t libfwsi_known_folder_identifier_my_pictures[ 16 ] = {
	0x30, 0x81, 0xe2, 0x33, 0x1e, 0x4e, 0x76, 0x46, 0x83, 0x5a, 0x98, 0x39, 0x5c, 0x3b, 0xc3, 0xbb };

uint8_t libfwsi_known_folder_identifier_my_video[ 16 ] = {
	0x1d, 0x9b, 0x98, 0x18, 0xb5, 0x99, 0x5b, 0x45, 0x84, 0x1c, 0xab, 0x7c, 0x74, 0xe4, 0xdd, 0xfc };

uint8_t libfwsi_known_folder_identifier_mycomputerfolder[ 16 ] = {
	0x7c, 0x83, 0xc0, 0x0a, 0xf8, 0xbb, 0x2a, 0x45, 0x85, 0x0d, 0x79, 0xd0, 0x8e, 0x66, 0x7c, 0xa7 };

uint8_t libfwsi_known_folder_identifier_nethood[ 16 ] = {
	0x53, 0xbf, 0xab, 0xc5, 0x7f, 0xe1, 0x21, 0x41, 0x89, 0x00, 0x86, 0x62, 0x6f, 0xc2, 0xc9, 0x73 };

uint8_t libfwsi_known_folder_identifier_networkplacesfolder[ 16 ] = {
	0xc4, 0xee, 0x0b, 0xd2, 0xa8, 0x5c, 0x05, 0x49, 0xae, 0x3b, 0xbf, 0x25, 0x1e, 0xa0, 0x9b, 0x53 };

uint8_t libfwsi_known_folder_identifier_oem_links[ 16 ] = {
	0xd0, 0xe2, 0xba, 0xc1, 0xdf, 0x10, 0x34, 0x43, 0xbe, 0xdd, 0x7a, 0xa2, 0x0b, 0x22, 0x7a, 0x9d };

uint8_t libfwsi_known_folder_identifier_onedrive[ 16 ] = {
	0x46, 0xba, 0x2b, 0xa5, 0xe1, 0xe9, 0x5f, 0x43, 0xb3, 0xd9, 0x28, 0xda, 0xa6, 0x48, 0xc0, 0xf6 };

uint8_t libfwsi_known_folder_identifier_onedrivecameraroll[ 16 ] = {
	0x11, 0x68, 0x7e, 0x76, 0xcb, 0x49, 0x73, 0x42, 0x87, 0xc2, 0x20, 0xf3, 0x55, 0xe1, 0x08, 0x5b };

uint8_t libfwsi_known_folder_identifier_onedrivedocuments[ 16 ] = {
	0x24, 0x9e, 0xd8, 0x24, 0x19, 0x2f, 0x34, 0x45, 0x9d, 0xde, 0x6a, 0x66, 0x71, 0xfb, 0xb8, 0xfe };

uint8_t libfwsi_known_folder_identifier_onedrivemusic[ 16 ] = {
	0x9e, 0x45, 0xf2, 0xc3, 0xd6, 0x80, 0xdc, 0x45, 0xbf, 0xef, 0x1f, 0x76, 0x9f, 0x2b, 0xe7, 0x30 };

uint8_t libfwsi_known_folder_identifier_onedrivepictures[ 16 ] = {
	0xb5, 0x19, 0x97, 0x33, 0x47, 0x8c, 0x94, 0x48, 0x94, 0xc2, 0xd8, 0xf7, 0x7a, 0xdd, 0x44, 0xa6 };

uint8_t libfwsi_known_folder_identifier_original_images[ 16 ] = {
	0xaa, 0xc0, 0x36, 0x2c, 0x12, 0x58, 0x87, 0x4b, 0xbf, 0xd0, 0x4c, 0xd0, 0xdf, 0xb1, 0x9b, 0x39 };

uint8_t libfwsi_known_folder_identifier_personal[ 16 ] = {
	0xd0, 0x9a, 0xd3, 0xfd, 0x8f, 0x23, 0xaf, 0x46, 0xad, 0xb4, 0x6c, 0x85, 0x48, 0x03, 0x69, 0xc7 };

uint8_t libfwsi_known_folder_identifier_photoalbums[ 16 ] = {
	0x90, 0xcf, 0xd2, 0x69, 0x33, 0xfc, 0xb7, 0x4f, 0x9a, 0x0c, 0xeb, 0xb0, 0xf0, 0xfc, 0xb4, 0x3c };

uint8_t libfwsi_known_folder_identifier_pictureslibrary[ 16 ] = {
	0x9f, 0xae, 0x90, 0xa9, 0x3b, 0xa0, 0x80, 0x4e, 0x94, 0xbc, 0x99, 0x12, 0xd7, 0x50, 0x41, 0x04 };

uint8_t libfwsi_known_folder_identifier_playlists[ 16 ] = {
	0xc7, 0xc1, 0x92, 0xde, 0x7f, 0x83, 0x69, 0x4f, 0xa3, 0xbb, 0x86, 0xe6, 0x31, 0x20, 0x4a, 0x23 };

uint8_t libfwsi_known_folder_identifier_printersfolder[ 16 ] = {
	0x2d, 0x4e, 0xfc, 0x76, 0xad, 0xd6, 0x19, 0x45, 0xa6, 0x63, 0x37, 0xbd, 0x56, 0x06, 0x81, 0x85 };

uint8_t libfwsi_known_folder_identifier_printhood[ 16 ] = {
	0x8d, 0xbd, 0x74, 0x92, 0xd1, 0xcf, 0xc3, 0x41, 0xb3, 0x5e, 0xb1, 0x3f, 0x55, 0xa7, 0x58, 0xf4 };

uint8_t libfwsi_known_folder_identifier_profile[ 16 ] = {
	0x8f, 0x85, 0x6c, 0x5e, 0x22, 0x0e, 0x60, 0x47, 0x9a, 0xfe, 0xea, 0x33, 0x17, 0xb6, 0x71, 0x73 };

uint8_t libfwsi_known_folder_identifier_programfiles[ 16 ] = {
	0xb6, 0x63, 0x5e, 0x90, 0xbf, 0xc1, 0x4e, 0x49, 0xb2, 0x9c, 0x65, 0xb7, 0x32, 0xd3, 0xd2, 0x1a };

uint8_t libfwsi_known_folder_identifier_programfilescommon[ 16 ] = {
	0x05, 0xed, 0xf1, 0xf7, 0x6d, 0x9f, 0xa2, 0x47, 0xaa, 0xae, 0x29, 0xd3, 0x17, 0xc6, 0xf0, 0x66 };

uint8_t libfwsi_known_folder_identifier_programfilescommonx64[ 16 ] = {
	0xa7, 0xd5, 0x65, 0x63, 0x0d, 0x0f, 0xe5, 0x45, 0x87, 0xf6, 0x0d, 0xa5, 0x6b, 0x6a, 0x4f, 0x7d };

uint8_t libfwsi_known_folder_identifier_programfilescommonx86[ 16 ] = {
	0x24, 0x4d, 0x97, 0xde, 0xc6, 0xd9, 0x3e, 0x4d, 0xbf, 0x91, 0xf4, 0x45, 0x51, 0x20, 0xb9, 0x17 };

uint8_t libfwsi_known_folder_identifier_programfilesx64[ 16 ] = {
	0x77, 0x93, 0x80, 0x6d, 0xf0, 0x6a, 0x4b, 0x44, 0x89, 0x57, 0xa3, 0x77, 0x3f, 0x02, 0x20, 0x0e };

uint8_t libfwsi_known_folder_identifier_programfilesx86[ 16 ] = {
	0xef, 0x40, 0x5a, 0x7c, 0xfb, 0xa0, 0xfc, 0x4b, 0x87, 0x4a, 0xc0, 0xf2, 0xe0, 0xb9, 0xfa, 0x8e };

uint8_t libfwsi_known_folder_identifier_programs[ 16 ] = {
	0x77, 0x5d, 0x7f, 0xa7, 0x2b, 0x2e, 0xc3, 0x44, 0xa6, 0xa2, 0xab, 0xa6, 0x01, 0x05, 0x4a, 0x51 };

uint8_t libfwsi_known_folder_identifier_public[ 16 ] = {
	0xa2, 0x76, 0xdf, 0xdf, 0x2a, 0xc8, 0x63, 0x4d, 0x90, 0x6a, 0x56, 0x44, 0xac, 0x45, 0x73, 0x85 };

uint8_t libfwsi_known_folder_identifier_publicaccountpictures[ 16 ] = {
	0x6c, 0xaf, 0x82, 0x04, 0xf1, 0x08, 0x34, 0x4c, 0x8c, 0x90, 0xe1, 0x7e, 0xc9, 0x8b, 0x1e, 0x17 };

uint8_t libfwsi_known_folder_identifier_publicgametasks[ 16 ] = {
	0x36, 0x25, 0xbf, 0xde, 0xa8, 0xe1, 0x59, 0x4c, 0xb6, 0xa2, 0x41, 0x45, 0x86, 0x47, 0x6a, 0xea };

uint8_t libfwsi_known_folder_identifier_publiclibraries[ 16 ] = {
	0x0b, 0xf8, 0xda, 0x48, 0xcf, 0xe6, 0x4e, 0x4f, 0xb8, 0x00, 0x0e, 0x69, 0xd8, 0x4e, 0xe3, 0x84 };

uint8_t libfwsi_known_folder_identifier_quick_launch[ 16 ] = {
	0x21, 0xf0, 0xa4, 0x52, 0x75, 0x7b, 0xa9, 0x48, 0x9f, 0x6b, 0x4b, 0x87, 0xa2, 0x10, 0xbc, 0x8f };

uint8_t libfwsi_known_folder_identifier_recent[ 16 ] = {
	0x81, 0xc0, 0x50, 0xae, 0xd2, 0xeb, 0x8a, 0x43, 0x86, 0x55, 0x8a, 0x09, 0x2e, 0x34, 0x98, 0x7a };

uint8_t libfwsi_known_folder_identifier_recorded_calls[ 16 ] = {
	0xc2, 0x40, 0x8b, 0x2f, 0xed, 0x83, 0xee, 0x48, 0xb3, 0x83, 0xa1, 0xf1, 0x57, 0xec, 0x6f, 0x9a };

uint8_t libfwsi_known_folder_identifier_recordedtvlibrary[ 16 ] = {
	0xa2, 0xdb, 0x6f, 0x1a, 0x2d, 0xf4, 0x58, 0x43, 0xa7, 0x98, 0xb7, 0x4d, 0x74, 0x59, 0x26, 0xc5 };

uint8_t libfwsi_known_folder_identifier_recyclebinfolder[ 16 ] = {
	0x46, 0x40, 0x53, 0xb7, 0xcb, 0x3e, 0x18, 0x4c, 0xbe, 0x4e, 0x64, 0xcd, 0x4c, 0xb7, 0xd6, 0xac };

uint8_t libfwsi_known_folder_identifier_resourcedir[ 16 ] = {
	0x31, 0x0c, 0xd1, 0x8a, 0xdb, 0x2a, 0x96, 0x42, 0xa8, 0xf7, 0xe4, 0x70, 0x12, 0x32, 0xc9, 0x72 };

uint8_t libfwsi_known_folder_identifier_retail_demo[ 16 ] = {
	0x9e, 0xc6, 0xd4, 0x12, 0xad, 0x24, 0x23, 0x49, 0xbe, 0x19, 0x31, 0x32, 0x1c, 0x43, 0xa7, 0x67 };

uint8_t libfwsi_known_folder_identifier_ringtones[ 16 ] = {
	0x4b, 0x04, 0x70, 0xc8, 0x9e, 0xf4, 0x26, 0x41, 0xa9, 0xc3, 0xb5, 0x2a, 0x1f, 0xf4, 0x11, 0xe8 };

uint8_t libfwsi_known_folder_identifier_roamed_tile_images[ 16 ] = {
	0xa5, 0xd5, 0xa8, 0xaa, 0xd6, 0xf1, 0x59, 0x42, 0xba, 0xa8, 0x78, 0xe7, 0xef, 0x60, 0x83, 0x5e };

uint8_t libfwsi_known_folder_identifier_roaming_tiles[ 16 ] = {
	0x5a, 0xfc, 0xbc, 0x00, 0x94, 0xed, 0x48, 0x4e, 0x96, 0xa1, 0x3f, 0x62, 0x17, 0xf2, 0x19, 0x90 };

uint8_t libfwsi_known_folder_identifier_samplemusic[ 16 ] = {
	0x68, 0xc6, 0x50, 0xb2, 0x7d, 0xf5, 0xe1, 0x4e, 0xa6, 0x3c, 0x29, 0x0e, 0xe7, 0xd1, 0xaa, 0x1f };

uint8_t libfwsi_known_folder_identifier_samplepictures[ 16 ] = {
	0x40, 0x05, 0x90, 0xc4, 0x79, 0x23, 0x75, 0x4c, 0x84, 0x4b, 0x64, 0xe6, 0xfa, 0xf8, 0x71, 0x6b };

uint8_t libfwsi_known_folder_identifier_sampleplaylists[ 16 ] = {
	0xb3, 0x69, 0xca, 0x15, 0xee, 0x30, 0xc1, 0x49, 0xac, 0xe1, 0x6b, 0x5e, 0xc3, 0x72, 0xaf, 0xb5 };

uint8_t libfwsi_known_folder_identifier_samplevideos[ 16 ] = {
	0x94, 0xad, 0x9e, 0x85, 0x85, 0x2e, 0xad, 0x48, 0xa7, 0x1a, 0x09, 0x69, 0xcb, 0x56, 0xa6, 0xcd };

uint8_t libfwsi_known_folder_identifier_savedgames[ 16 ] = {
	0xff, 0x32, 0x5c, 0x4c, 0x9d, 0xbb, 0xb0, 0x43, 0xb5, 0xb4, 0x2d, 0x72, 0xe5, 0x4e, 0xaa, 0xa4 };

uint8_t libfwsi_known_folder_identifier_savedpictures[ 16 ] = {
	0x82, 0x38, 0x19, 0x3b, 0xad, 0xd3, 0xab, 0x4e, 0x96, 0x5a, 0x69, 0x82, 0x9d, 0x1f, 0xb5, 0x9f };

uint8_t libfwsi_known_folder_identifier_savedpictureslibrary[ 16 ] = {
	0x12, 0x58, 0x5b, 0xe2, 0x88, 0xbe, 0xd9, 0x4b, 0x94, 0xb0, 0x29, 0x23, 0x34, 0x77, 0xb6, 0xc3 };

uint8_t libfwsi_known_folder_identifier_screenshots[ 16 ] = {
	0x81, 0xde, 0xbe, 0xb7, 0x94, 0xdf, 0x82, 0x46, 0xa7, 0xd8, 0x57, 0xa5, 0x26, 0x20, 0xb8, 0x6f };

uint8_t libfwsi_known_folder_identifier_searches[ 16 ] = {
	0x04, 0x3a, 0x1d, 0x7d, 0xbb, 0xde, 0x15, 0x41, 0x95, 0xcf, 0x2f, 0x29, 0xda, 0x29, 0x20, 0xda };

uint8_t libfwsi_known_folder_identifier_searchhistoryfolder[ 16 ] = {
	0xb6, 0x3d, 0x4c, 0x0d, 0xa3, 0x03, 0x2f, 0x46, 0xa0, 0xe6, 0x08, 0x92, 0x4c, 0x41, 0xb5, 0xd4 };

uint8_t libfwsi_known_folder_identifier_searchhomefolder[ 16 ] = {
	0xd1, 0x37, 0x03, 0x19, 0xca, 0xb8, 0x21, 0x41, 0xa6, 0x39, 0x6d, 0x47, 0x2d, 0x16, 0x97, 0x2a };

uint8_t libfwsi_known_folder_identifier_searchtemplatesfolder[ 16 ] = {
	0xfe, 0x6b, 0x63, 0x7e, 0xa9, 0xdf, 0x5e, 0x4d, 0xb4, 0x56, 0xd7, 0xb3, 0x98, 0x51, 0xd8, 0xa9 };

uint8_t libfwsi_known_folder_identifier_sendto[ 16 ] = {
	0x6c, 0x03, 0x83, 0x89, 0xc0, 0x27, 0x4b, 0x40, 0x8f, 0x08, 0x10, 0x2d, 0x10, 0xdc, 0xfd, 0x74 };

uint8_t libfwsi_known_folder_identifier_start_menu[ 16 ] = {
	0xc3, 0x53, 0x5b, 0x62, 0x48, 0xab, 0xc1, 0x4e, 0xba, 0x1f, 0xa1, 0xef, 0x41, 0x46, 0xfc, 0x19 };

uint8_t libfwsi_known_folder_identifier_startmenuallprograms[ 16 ] = {
	0xef, 0x05, 0x63, 0xf2, 0x48, 0x69, 0xb9, 0x40, 0xb2, 0x55, 0x81, 0x45, 0x3d, 0x09, 0xc7, 0x85 };

uint8_t libfwsi_known_folder_identifier_startup[ 16 ] = {
	0xbb, 0x20, 0x7d, 0xb9, 0x6a, 0xf4, 0x97, 0x4c, 0xba, 0x10, 0x5e, 0x36, 0x08, 0x43, 0x08, 0x54 };

uint8_t libfwsi_known_folder_identifier_synccenterfolder[ 16 ] = {
	0xf8, 0x8b, 0x66, 0x43, 0x4e, 0xc1, 0xb2, 0x49, 0x97, 0xc9, 0x74, 0x77, 0x84, 0xd7, 0x84, 0xb7 };

uint8_t libfwsi_known_folder_identifier_syncresultsfolder[ 16 ] = {
	0x43, 0x9a, 0x9a, 0x28, 0x44, 0xbe, 0x57, 0x40, 0xa4, 0x1b, 0x58, 0x7a, 0x76, 0xd7, 0xe7, 0xf9 };

uint8_t libfwsi_known_folder_identifier_syncsetupfolder[ 16 ] = {
	0x38, 0x41, 0x21, 0x0f, 0xd3, 0xb1, 0x90, 0x4a, 0xbb, 0xa9, 0x27, 0xcb, 0xc0, 0xc5, 0x38, 0x9a };

uint8_t libfwsi_known_folder_identifier_system[ 16 ] = {
	0x77, 0x4e, 0xc1, 0x1a, 0xe7, 0x02, 0x5d, 0x4e, 0xb7, 0x44, 0x2e, 0xb1, 0xae, 0x51, 0x98, 0xb7 };

uint8_t libfwsi_known_folder_identifier_systemcertificates[ 16 ] = {
	0xe0, 0xd2, 0xee, 0x54, 0xca, 0xe7, 0xdb, 0x4f, 0x91, 0x48, 0x0f, 0x42, 0x47, 0x29, 0x1c, 0xfa };

uint8_t libfwsi_known_folder_identifier_systemx86[ 16 ] = {
	0xb0, 0x31, 0x52, 0xd6, 0xf1, 0xb2, 0x57, 0x48, 0xa4, 0xce, 0xa8, 0xe7, 0xc6, 0xea, 0x7d, 0x27 };

uint8_t libfwsi_known_folder_identifier_templates[ 16 ] = {
	0xe8, 0x93, 0x32, 0xa6, 0x4e, 0x66, 0xdb, 0x48, 0xa0, 0x79, 0xdf, 0x75, 0x9e, 0x05, 0x09, 0xf7 };

uint8_t libfwsi_known_folder_identifier_thisdevicefolder[ 16 ] = {
	0xdc, 0xc1, 0x2a, 0x1c, 0x58, 0x43, 0x6c, 0x4b, 0x97, 0x33, 0xaf, 0x21, 0x15, 0x65, 0x76, 0xf0 };

uint8_t libfwsi_known_folder_identifier_thispcdesktopfolder[ 16 ] = {
	0x86, 0xc8, 0x4a, 0x75, 0x64, 0xdf, 0xba, 0x4c, 0x86, 0xb5, 0xf7, 0xfb, 0xf4, 0xfb, 0xce, 0xf5 };

uint8_t libfwsi_known_folder_identifier_treepropertiesfolder[ 16 ] = {
	0xad, 0x49, 0x37, 0x5b, 0x9f, 0xb4, 0xc1, 0x49, 0x83, 0xeb, 0x15, 0x37, 0x0f, 0xbd, 0x48, 0x82 };

uint8_t libfwsi_known_folder_identifier_user_pinned[ 16 ] = {
	0xab, 0x95, 0x39, 0x9e, 0x9c, 0x1f, 0x13, 0x4f, 0xb8, 0x27, 0x48, 0xb2, 0x4b, 0x6c, 0x71, 0x74 };

uint8_t libfwsi_known_folder_identifier_userprofiles[ 16 ] = {
	0x72, 0xd2, 0x62, 0x07, 0x0a, 0xc5, 0xb0, 0x4b, 0xa3, 0x82, 0x69, 0x7d, 0xcd, 0x72, 0x9b, 0x80 };

uint8_t libfwsi_known_folder_identifier_userprogramfiles[ 16 ] = {
	0xe2, 0xae, 0xd7, 0x5c, 0x19, 0x22, 0x67, 0x4a, 0xb8, 0x5d, 0x6c, 0x9c, 0xe1, 0x56, 0x60, 0xcb };

uint8_t libfwsi_known_folder_identifier_userprogramfilescommon[ 16 ] = {
	0x57, 0x30, 0xbd, 0xbc, 0x5c, 0xca, 0x22, 0x46, 0xb4, 0x2d, 0xbc, 0x56, 0xdb, 0x0a, 0xe5, 0x16 };

uint8_t libfwsi_known_folder_identifier_usersfilesfolder[ 16 ] = {
	0x7c, 0x0f, 0xce, 0xf3, 0x01, 0x49, 0xcc, 0x4a, 0x86, 0x48, 0xd5, 0xd4, 0x4b, 0x04, 0xef, 0x8f };

uint8_t libfwsi_known_folder_identifier_userslibrariesfolder[ 16 ] = {
	0x5d, 0x54, 0x02, 0xa3, 0xff, 0xde, 0x4b, 0x46, 0xab, 0xe8, 0x61, 0xc8, 0x64, 0x8d, 0x93, 0x9b };

uint8_t libfwsi_known_folder_identifier_videoslibrary[ 16 ] = {
	0x2f, 0x92, 0x1e, 0x49, 0x43, 0x56, 0xf4, 0x4a, 0xa7, 0xeb, 0x4e, 0x7a, 0x13, 0x8d, 0x81, 0x74 };

uint8_t libfwsi_known_folder_identifier_windows[ 16 ] = {
	0x04, 0xf4, 0x8b, 0xf3, 0x43, 0x1d, 0xf2, 0x42, 0x93, 0x05, 0x67, 0xde, 0x0b, 0x28, 0xfc, 0x23 };


uint8_t libfwsi_known_folder_identifier_unknown[ 16 ] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff };

/* The known folder identifiers
 */
libfwsi_known_folder_identifier_definition_t libfwsi_known_folder_identifier_definitions[ ] = {

	{ libfwsi_known_folder_identifier_3d_objects,
	  "3D Objects" },
	{ libfwsi_known_folder_identifier_accountpictures,
	  "Account Pictures" },
	{ libfwsi_known_folder_identifier_addnewprogramsfolder,
	  "Get Programs" },
	{ libfwsi_known_folder_identifier_administrative_tools,
	  "Administrative Tools" },
	{ libfwsi_known_folder_identifier_appdata,
	  "Roaming" },
	{ libfwsi_known_folder_identifier_appdatadesktop,
	  "AppDataDesktop" },
	{ libfwsi_known_folder_identifier_appdatadocuments,
	  "AppDataDocuments" },
	{ libfwsi_known_folder_identifier_appdatafavorites,
	  "AppDataFavorites" },
	{ libfwsi_known_folder_identifier_appdataprogramdata,
	  "AppDataProgramData" },
	{ libfwsi_known_folder_identifier_application_shortcuts,
	  "Application Shortcuts" },
	{ libfwsi_known_folder_identifier_appmods,
	  "AppMods" },
	{ libfwsi_known_folder_identifier_appsfolder,
	  "Applications" },
	{ libfwsi_known_folder_identifier_appupdatesfolder,
	  "Installed Updates" },
	{ libfwsi_known_folder_identifier_cache,
	  "Temporary Internet Files" },
	{ libfwsi_known_folder_identifier_camera_roll,
	  "Camera Roll" },
	{ libfwsi_known_folder_identifier_camerarolllibrary,
	  "CameraRollLibrary" },
	{ libfwsi_known_folder_identifier_captures,
	  "Captures" },
	{ libfwsi_known_folder_identifier_cd_burning,
	  "Temporary Burn Folder" },
	{ libfwsi_known_folder_identifier_changeremoveprogramsfolder,
	  "Programs and Features" },
	{ libfwsi_known_folder_identifier_common_administrative_tools,
	  "Administrative Tools" },
	{ libfwsi_known_folder_identifier_common_appdata,
	  "ProgramData" },
	{ libfwsi_known_folder_identifier_common_desktop,
	  "Public Desktop" },
	{ libfwsi_known_folder_identifier_common_documents,
	  "Public Documents" },
	{ libfwsi_known_folder_identifier_common_programs,
	  "Programs" },
	{ libfwsi_known_folder_identifier_common_start_menu,
	  "Start Menu" },
	{ libfwsi_known_folder_identifier_common_start_menu_places,
	  "Common Start Menu Places" },
	{ libfwsi_known_folder_identifier_common_startup,
	  "Startup" },
	{ libfwsi_known_folder_identifier_common_templates,
	  "Templates" },
	{ libfwsi_known_folder_identifier_commondownloads,
	  "Public Downloads" },
	{ libfwsi_known_folder_identifier_commonmusic,
	  "Public Music" },
	{ libfwsi_known_folder_identifier_commonpictures,
	  "Public Pictures" },
	{ libfwsi_known_folder_identifier_commonringtones,
	  "Ringtones" },
	{ libfwsi_known_folder_identifier_commonvideo,
	  "Public Videos" },
	{ libfwsi_known_folder_identifier_conflictfolder,
	  "Conflicts" },
	{ libfwsi_known_folder_identifier_connectionsfolder,
	  "Network Connections" },
	{ libfwsi_known_folder_identifier_contacts,
	  "Contacts" },
	{ libfwsi_known_folder_identifier_controlpanelfolder,
	  "Control Panel" },
	{ libfwsi_known_folder_identifier_cookies,
	  "Cookies" },
	{ libfwsi_known_folder_identifier_credentialmanager,
	  "CredentialManager" },
	{ libfwsi_known_folder_identifier_cryptokeys,
	  "CryptoKeys" },
	{ libfwsi_known_folder_identifier_cscfolder,
	  "Offline Files" },
	{ libfwsi_known_folder_identifier_default_gadgets,
	  "Gadgets" },
	{ libfwsi_known_folder_identifier_desktop,
	  "Desktop" },
	{ libfwsi_known_folder_identifier_development_files,
	  "Development Files" },
	{ libfwsi_known_folder_identifier_device_metadata_store,
	  "DeviceMetadataStore" },
	{ libfwsi_known_folder_identifier_documentslibrary,
	  "Documents" },
	{ libfwsi_known_folder_identifier_downloads,
	  "Downloads" },
	{ libfwsi_known_folder_identifier_dpapikeys,
	  "DpapiKeys" },
	{ libfwsi_known_folder_identifier_favorites,
	  "Favorites" },
	{ libfwsi_known_folder_identifier_fonts,
	  "Fonts" },
	{ libfwsi_known_folder_identifier_gadgets,
	  "Gadgets" },
	{ libfwsi_known_folder_identifier_games,
	  "Games" },
	{ libfwsi_known_folder_identifier_gametasks,
	  "GameExplorer" },
	{ libfwsi_known_folder_identifier_history,
	  "History" },
	{ libfwsi_known_folder_identifier_homegroupcurrentuserfolder,
	  "%USERNAME%" },
	{ libfwsi_known_folder_identifier_homegroupfolder,
	  "Homegroup" },
	{ libfwsi_known_folder_identifier_implicitappshortcuts,
	  "ImplicitAppShortcuts" },
	{ libfwsi_known_folder_identifier_internetfolder,
	  "The Internet" },
	{ libfwsi_known_folder_identifier_libraries,
	  "Libraries" },
	{ libfwsi_known_folder_identifier_links,
	  "Links" },
	{ libfwsi_known_folder_identifier_local_appdata,
	  "Local" },
	{ libfwsi_known_folder_identifier_local_documents,
	  "Local Documents" },
	{ libfwsi_known_folder_identifier_local_downloads,
	  "Local Downloads" },
	{ libfwsi_known_folder_identifier_local_music,
	  "Local Music" },
	{ libfwsi_known_folder_identifier_local_pictures,
	  "Local Pictures" },
	{ libfwsi_known_folder_identifier_local_videos,
	  "Local Videos" },
	{ libfwsi_known_folder_identifier_localappdatalow,
	  "LocalLow" },
	{ libfwsi_known_folder_identifier_localizedresourcesdir,
	  "None" },
	{ libfwsi_known_folder_identifier_mapifolder,
	  "Microsoft Office Outlook" },
	{ libfwsi_known_folder_identifier_musiclibrary,
	  "Music" },
	{ libfwsi_known_folder_identifier_my_music,
	  "Music" },
	{ libfwsi_known_folder_identifier_my_pictures,
	  "Pictures" },
	{ libfwsi_known_folder_identifier_my_video,
	  "Videos" },
	{ libfwsi_known_folder_identifier_mycomputerfolder,
	  "Computer" },
	{ libfwsi_known_folder_identifier_nethood,
	  "Network Shortcuts" },
	{ libfwsi_known_folder_identifier_networkplacesfolder,
	  "Network" },
	{ libfwsi_known_folder_identifier_oem_links,
	  "OEM Links" },
	{ libfwsi_known_folder_identifier_onedrive,
	  "OneDrive" },
	{ libfwsi_known_folder_identifier_onedrivecameraroll,
	  "Camera Roll" },
	{ libfwsi_known_folder_identifier_onedrivedocuments,
	  "Documents" },
	{ libfwsi_known_folder_identifier_onedrivemusic,
	  "OneDriveMusic" },
	{ libfwsi_known_folder_identifier_onedrivepictures,
	  "Pictures" },
	{ libfwsi_known_folder_identifier_original_images,
	  "Original Images" },
	{ libfwsi_known_folder_identifier_personal,
	  "Documents" },
	{ libfwsi_known_folder_identifier_photoalbums,
	  "Slide Shows" },
	{ libfwsi_known_folder_identifier_pictureslibrary,
	  "Pictures" },
	{ libfwsi_known_folder_identifier_playlists,
	  "Playlists" },
	{ libfwsi_known_folder_identifier_printersfolder,
	  "Printers" },
	{ libfwsi_known_folder_identifier_printhood,
	  "Printer Shortcuts" },
	{ libfwsi_known_folder_identifier_profile,
	  "%USERNAME%" },
	{ libfwsi_known_folder_identifier_programfiles,
	  "Program Files" },
	{ libfwsi_known_folder_identifier_programfilescommon,
	  "Common Files" },
	{ libfwsi_known_folder_identifier_programfilescommonx64,
	  "Common Files" },
	{ libfwsi_known_folder_identifier_programfilescommonx86,
	  "Common Files" },
	{ libfwsi_known_folder_identifier_programfilesx64,
	  "Program Files" },
	{ libfwsi_known_folder_identifier_programfilesx86,
	  "Program Files" },
	{ libfwsi_known_folder_identifier_programs,
	  "Programs" },
	{ libfwsi_known_folder_identifier_public,
	  "Public" },
	{ libfwsi_known_folder_identifier_publicaccountpictures,
	  "Public Account Pictures" },
	{ libfwsi_known_folder_identifier_publicgametasks,
	  "GameExplorer" },
	{ libfwsi_known_folder_identifier_publiclibraries,
	  "Libraries" },
	{ libfwsi_known_folder_identifier_quick_launch,
	  "Quick Launch" },
	{ libfwsi_known_folder_identifier_recent,
	  "Recent Items" },
	{ libfwsi_known_folder_identifier_recorded_calls,
	  "Recorded Calls" },
	{ libfwsi_known_folder_identifier_recordedtvlibrary,
	  "Recorded TV" },
	{ libfwsi_known_folder_identifier_recyclebinfolder,
	  "Recycle Bin" },
	{ libfwsi_known_folder_identifier_resourcedir,
	  "Resources" },
	{ libfwsi_known_folder_identifier_retail_demo,
	  "Retail Demo" },
	{ libfwsi_known_folder_identifier_ringtones,
	  "Ringtones" },
	{ libfwsi_known_folder_identifier_roamed_tile_images,
	  "RoamedTileImages" },
	{ libfwsi_known_folder_identifier_roaming_tiles,
	  "RoamingTiles" },
	{ libfwsi_known_folder_identifier_samplemusic,
	  "Sample Music" },
	{ libfwsi_known_folder_identifier_samplepictures,
	  "Sample Pictures" },
	{ libfwsi_known_folder_identifier_sampleplaylists,
	  "Sample Playlists" },
	{ libfwsi_known_folder_identifier_samplevideos,
	  "Sample Videos" },
	{ libfwsi_known_folder_identifier_savedgames,
	  "Saved Games" },
	{ libfwsi_known_folder_identifier_savedpictures,
	  "Saved Pictures" },
	{ libfwsi_known_folder_identifier_savedpictureslibrary,
	  "Saved Pictures Library" },
	{ libfwsi_known_folder_identifier_screenshots,
	  "Screenshots" },
	{ libfwsi_known_folder_identifier_searches,
	  "Searches" },
	{ libfwsi_known_folder_identifier_searchhistoryfolder,
	  "History" },
	{ libfwsi_known_folder_identifier_searchhomefolder,
	  "Search Results" },
	{ libfwsi_known_folder_identifier_searchtemplatesfolder,
	  "Templates" },
	{ libfwsi_known_folder_identifier_sendto,
	  "SendTo" },
	{ libfwsi_known_folder_identifier_start_menu,
	  "Start Menu" },
	{ libfwsi_known_folder_identifier_startmenuallprograms,
	  "StartMenuAllPrograms" },
	{ libfwsi_known_folder_identifier_startup,
	  "Startup" },
	{ libfwsi_known_folder_identifier_synccenterfolder,
	  "Sync Center" },
	{ libfwsi_known_folder_identifier_syncresultsfolder,
	  "Sync Results" },
	{ libfwsi_known_folder_identifier_syncsetupfolder,
	  "Sync Setup" },
	{ libfwsi_known_folder_identifier_system,
	  "System32" },
	{ libfwsi_known_folder_identifier_systemcertificates,
	  "SystemCertificates" },
	{ libfwsi_known_folder_identifier_systemx86,
	  "System32" },
	{ libfwsi_known_folder_identifier_templates,
	  "Templates" },
	{ libfwsi_known_folder_identifier_thisdevicefolder,
	  "ThisDeviceFolder" },
	{ libfwsi_known_folder_identifier_thispcdesktopfolder,
	  "ThisPCDesktopFolder" },
	{ libfwsi_known_folder_identifier_treepropertiesfolder,
	  "TreePropertiesFolder" },
	{ libfwsi_known_folder_identifier_user_pinned,
	  "User Pinned" },
	{ libfwsi_known_folder_identifier_userprofiles,
	  "Users" },
	{ libfwsi_known_folder_identifier_userprogramfiles,
	  "Programs" },
	{ libfwsi_known_folder_identifier_userprogramfilescommon,
	  "Programs" },
	{ libfwsi_known_folder_identifier_usersfilesfolder,
	  "UsersFilesFolder" },
	{ libfwsi_known_folder_identifier_userslibrariesfolder,
	  "Libraries" },
	{ libfwsi_known_folder_identifier_videoslibrary,
	  "Videos" },
	{ libfwsi_known_folder_identifier_windows,
	  "Windows" },

	{ libfwsi_known_folder_identifier_unknown,
	  "Unknown" } };

/* Retrieves a string containing the name of the folder identifier
 */
const char *libfwsi_known_folder_identifier_get_name(
             const uint8_t *known_folder_identifier )
{
	int iterator = 0;

	if( known_folder_identifier == NULL )
	{
		return( "Invalid known folder identifier" );
	}
	while( memory_compare(
	        ( libfwsi_known_folder_identifier_definitions[ iterator ] ).identifier,
	        libfwsi_known_folder_identifier_unknown,
	        16 ) != 0 )
	{
		if( memory_compare(
		     ( libfwsi_known_folder_identifier_definitions[ iterator ] ).identifier,
		     known_folder_identifier,
		     16 ) == 0 )
		{
			break;
		}
		iterator++;
	}
	return(
	 ( libfwsi_known_folder_identifier_definitions[ iterator ] ).name );
}

