//start of LhaRetainedOutputStream.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * LhaRetainedOutputStream.java
 * 
 * Copyright (C) 2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Vector;
import java.util.Properties;
import jp.gr.java_conf.dangan.util.lha.CRC16;
import jp.gr.java_conf.dangan.util.lha.LhaHeader;
import jp.gr.java_conf.dangan.util.lha.LhaProperty;
import jp.gr.java_conf.dangan.util.lha.CompressMethod;


//import exceptions
import java.io.IOException;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;

/**
 * ڑꂽRandomAccessFile kf[^o͂邽߂̃[eBeBNXB<br>
 * java.util.zip.ZipOutputStream ƎC^[tFCX悤ɍB<br>
 * ks( kTCYkOTCYꍇ )̏IɍsB
 * i񍐂ꍇÂ悤ȏNXɉBƐi񍐂͉bԂ
 * ɂĂ͉\ȂȂB(Ⴆ΃MKoCg̃f[^ꍇ)
 * ̂悤ȎԂꍇ LhaImmediateOutputStreamgp邱ƁB<br>
 * ܂AJDK 1.1 ȑOł RandomAccessFile  setLength Ȃ߁A
 * Ƀf[^̌ɑ̃f[^ꍇłt@CTCY؂l߂邱ƂoȂB
 * ̖_͏ɃTCY0̐Vt@CJɂĉ鎖łB<br>
 * 
 * <pre>
 * -- revision history --
 * $Log: LhaRetainedOutputStream.java,v $
 * Revision 1.2  2002/12/11 02:25:14  dangan
 * [bug fix]
 *     jdk1.2 ŃRpCłȂӏCB
 *
 * Revision 1.1  2002/12/08 00:00:00  dangan
 * [maintenance]
 *     LhaConstants  CompressMethod ւ̃NX̕ύXɍ킹ďCB
 *
 * Revision 1.0  2002/08/05 00:00:00  dangan
 * add to version control
 * [change]
 *     RXgN^  String encode ̂p~A
 *     Properties Ɏ̂ǉB
 * [maintenance]
 *     \[X
 *     ^up~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.2 $
 */
public class LhaRetainedOutputStream extends OutputStream{


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  sink
    //------------------------------------------------------------------
    //  private RandomAccessFile archive
    //------------------------------------------------------------------
    /**
     * Ƀt@C
     */
    private RandomAccessFile archive;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  to compress a file
    //------------------------------------------------------------------
    //  private OutputStream out
    //  private RandomAccessFileOutputStream rafo
    //  private LhaHeader header
    //  private String encoding
    //  private long headerpos
    //  private CRC16 crc
    //------------------------------------------------------------------
    /**
     * kpo̓Xg[
     */
    private OutputStream out;

    /**
     * kpo̓Xg[
     */
    private RandomAccessFileOutputStream rafo;

    /**
     * ݈k̃wb_
     */
    private LhaHeader header;

    /**
     * wb_̏o͂ɎgpGR[fBO
     */
    private String encoding;

    /**
     * wb_ʒu
     */
    private long headerpos;

    /**
     * CRClZop
     */
    private CRC16 crc;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  property
    //------------------------------------------------------------------
    //  private Properties property
    //------------------------------------------------------------------
    /**
     * ek`ɑΉ̐܂܂vpeB
     */
    private Properties property;


    //------------------------------------------------------------------
    //  constructor
    //------------------------------------------------------------------
    //  private LhaRetainedOutputStream()
    //  public LhaRetainedOutputStream( String filename )
    //  public LhaRetainedOutputStream( String filename, Properties property )
    //  public LhaRetainedOutputStream( File file )
    //  public LhaRetainedOutputStream( File file, Properties property )
    //  public LhaRetainedOutputStream( RandomAccessFile archive )
    //  public LhaRetainedOutputStream( RandomAccessFile archive, Properties property )
    //  private void constructerHelper( RandomAccesFile archive, Properties property )
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^
     * gps
     */
    private LhaRetainedOutputStream(){  }

    /**
     * filename ̃t@C kf[^o͂OutputStream\zB<br>
     * ek`ɑΉ̐vpeBɂ
     * LhaProperty.getProperties() œꂽvpeBgpB<br>
     * 
     * @param filename kf[^ރt@C̖O
     * 
     * @exception FileNotFoundException
     *               filename ŗ^ꂽt@CȂꍇB
     * @exception SecurityException
     *               ZLeB}l[Wt@Cւ̃ANZXȂꍇB
     * 
     * @see LhaProperty#getProperties()
     */
    public LhaRetainedOutputStream( String filename ) 
                                                throws FileNotFoundException {

        if( filename != null ){
            RandomAccessFile file = new RandomAccessFile( filename, "rw" );     //throws FileNotFoundException, SecurityException
            Properties property   = LhaProperty.getProperties();
        
            this.constructerHelper( file, property );
        }else{
            throw new NullPointerException( "filename" );
        }
    }

    /**
     * filename ̃t@C kf[^o͂OutputStream\zB<br>
     * 
     * @param filename kf[^ރt@C̖O
     * @param property ek`ɑΉ̐܂܂vpeB
     * 
     * @exception FileNotFoundException
     *               filename ŗ^ꂽt@CȂꍇB
     * @exception SecurityException
     *               ZLeB}l[Wt@Cւ̃ANZXȂꍇB
     * 
     * @see LhaProperty
     */
    public LhaRetainedOutputStream( String filename, Properties property )
                                                  throws FileNotFoundException {

        if( filename != null ){
            RandomAccessFile file = new RandomAccessFile( filename, "rw" );     //throws FileNotFoundException, SecurityException
            this.constructerHelper( file, property );
        }else{
            throw new NullPointerException( "filename" );
        }
    }

    /**
     * filename ̃t@C kf[^o͂OutputStream\zB<br>
     * ek`ɑΉ̐vpeBɂ
     * LhaProperty.getProperties() œꂽvpeBgpB<br>
     * 
     * @param filename kf[^ރt@C̖O
     * 
     * @exception FileNotFoundException
     *               filename ŗ^ꂽt@CȂꍇB
     * @exception SecurityException
     *               ZLeB}l[Wt@Cւ̃ANZXȂꍇB
     * @exception IOException
     *               JDK1.2 ŃRpC邽߂ɑ݂B
     * 
     * @see LhaProperty#getProperties()
     */
    public LhaRetainedOutputStream( File filename ) throws IOException {

        if( filename != null ){
            RandomAccessFile file = new RandomAccessFile( filename, "rw" );     //throws FileNotFoundException, SecurityException
            Properties property   = LhaProperty.getProperties();
        
            this.constructerHelper( file, property );
        }else{
            throw new NullPointerException( "filename" );
        }
    }

    /**
     * filename ̃t@C kf[^o͂OutputStream\zB<br>
     * 
     * @param filename kf[^ރt@C̖O
     * @param property ek`ɑΉ̐܂܂vpeB
     * 
     * @exception FileNotFoundException
     *               filename ŗ^ꂽt@CȂꍇB
     * @exception SecurityException
     *               ZLeB}l[Wt@Cւ̃ANZXȂꍇB
     * @exception IOException
     *               JDK1.2 ŃRpC邽߂ɑ݂B
     * 
     * @see LhaProperty
     */
    public LhaRetainedOutputStream( File filename, Properties property )
                                                            throws IOException {

        if( filename != null ){
            RandomAccessFile file = new RandomAccessFile( filename, "rw" );     //throws FileNotFoundException, SecurityException
            this.constructerHelper( file, property );
        }else{
            throw new NullPointerException( "filename" );
        }
    }

    /**
     * file kf[^o͂OutputStream\zB<br>
     * ek`ɑΉ̐vpeBɂ
     * LhaProperty.getProperties() œꂽvpeBgpB<br>
     * 
     * @param file RandomAccessFile ̃CX^XB<br>
     *             <ul>
     *                <li> close() ĂȂB
     *                <li>RXgN^ mode ɂ "rw" IvVgpāA
     *                    ǂ݂݂Ə݂o悤ɐꂽCX^Xł邱ƁB
     *              </ul>
     *              ̏𖞂́B
     * 
     * @see LhaProperty#getProperties()
     */
    public LhaRetainedOutputStream( RandomAccessFile file ){

        if( file != null ){
            Properties property   = LhaProperty.getProperties();
            this.constructerHelper( file, property );
        }else{
            throw new NullPointerException( "out" );
        }
    }

    /**
     * file kf[^o͂OutputStream\zB<br>
     * ek`ɑΉ̐vpeBɂ
     * LhaProperty.getProperties() œꂽvpeBgpB<br>
     * 
     * @param file     RandomAccessFile ̃CX^XB<br>
     *                 <ul>
     *                   <li> close() ĂȂB
     *                   <li>RXgN^ mode ɂ "rw" IvVgpāA
     *                       ǂ݂݂Ə݂o悤ɐꂽCX^Xł邱ƁB
     *                 </ul>
     *                 ̏𖞂́B
     * @param property ek`ɑΉ̐܂܂vpeB
     * 
     * @see LhaProperty
     */
    public LhaRetainedOutputStream( RandomAccessFile file, 
                                    Properties       property ){

        if( file != null
         && property != null ){

            this.constructerHelper( file, property );                           //throws UnsupportedEncodingException

        }else if( file == null ){
            throw new NullPointerException( "null" );
        }else{
            throw new NullPointerException( "property" );
        }

    }

    /**
     * RXgN^̏S郁\bhB
     * 
     * @param file     RandomAccessFile ̃CX^XB<br>
     *                 <ul>
     *                   <li> close() ĂȂB
     *                   <li>RXgN^ mode ɂ "rw" IvVgpāA
     *                       ǂ݂݂Ə݂o悤ɐꂽCX^Xł邱ƁB
     *                 </ul>
     *                 ̏𖞂́B
     * @param property ek`ɑΉ̐܂܂vpeB
     */
    private void constructerHelper( RandomAccessFile file, 
                                    Properties       property ){

        this.archive   = file;

        this.out       = null;
        this.header    = null;
        this.headerpos = -1;
        this.crc       = new CRC16();
        this.property  = property;
    }

    //------------------------------------------------------------------
    //  method of java.io.OutputStream
    //------------------------------------------------------------------
    //  write
    //------------------------------------------------------------------
    //  public void write( int data )
    //  public void write( byte[] buffer )
    //  public void write( byte[] buffer, int index, int length )
    //------------------------------------------------------------------
    /**
     * ݂̃Gg1oCg̃f[^ށB
     * 
     * @param data ރf[^
     * 
     * @exception IOException o̓G[ꍇB
     */
    public void write( int data ) throws IOException {
        if( this.out != null ){
            if( this.header != null ){
                crc.update( data );
            }

            this.out.write( data );
        }else{
            throw new IOException( "no entry" );
        }
    }

    /**
     * ݂̃Gg buffer̓eSďoB
     * 
     * @param buffer of[^̓oCgz
     * 
     * @exception IOException o̓G[ꍇB
     */
    public void write( byte[] buffer ) throws IOException {
        this.write( buffer, 0, buffer.length );
    }

    /**
     * ݂̃Gg buffer index
     * lengthoCg̃f[^oB
     * 
     * @param buffer of[^̓oCgz
     * @param index  buffeȑoׂf[^̊Jnʒu
     * @param length f[^̃oCg
     * 
     * @exception IOException o̓G[ꍇB
     */
    public void write( byte[] buffer, int index, int length ) throws IOException {
        if( this.out != null ){
            if( this.header != null ){
                crc.update( buffer, index, length );
            }

            this.out.write( buffer, index, length );
        }else{
            throw new IOException( "no entry" );
        }
    }


    //------------------------------------------------------------------
    //  method of java.io.OutputStream
    //------------------------------------------------------------------
    //  other
    //------------------------------------------------------------------
    //  public void flush()
    //  public void close()
    //------------------------------------------------------------------
    /**
     * ݏݒ̃Gg̃f[^Iɏo͐ɏoB
     *  PostLzssEncoder, LzssOutputStream ̋Kǂ
     * flush() ȂꍇƂ͕ʂ̃f[^o͂B
     * (̏ꍇ PɈkቺ邾łB)
     * 
     * @exception IOException o̓G[ꍇ
     * 
     * @see PostLzssEncoder#flush()
     * @see LzssOutputStream#flush()
     */
    public void flush() throws IOException {
        if( this.out != null ){
            this.out.flush();                                                   //throws IOException
        }else{
            throw new IOException( "no entry" );
        }
    }

    /**
     * o͐ɑSẴf[^o͂AXg[B<br>
     * ܂AgpĂSẴ\[XB
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void close() throws IOException {
        if( this.out != null ){
            this.closeEntry();                                                  //throws IOException
        }

        //^[~l[^o
        this.archive.write( 0 );                                                //throws IOException
        try{
            this.archive.setLength( this.archive.getFilePointer() );            //After Java1.2 throws IOException
        }catch( NoSuchMethodError error ){
        }

        this.archive.close();                                                   //throws IOException
        this.archive  = null;
        this.header   = null;
        this.crc      = null;
        this.property = null;
        this.rafo     = null;
    }


    //------------------------------------------------------------------
    //  original method ( on the model of java.util.zip.ZipOutputStream  )
    //------------------------------------------------------------------
    //  manipulate entry
    //------------------------------------------------------------------
    //  public void putNextEntry( LhaHeader header )
    //  public void putNextEntryAlreadyCompressed( LhaHeader header )
    //  public void putNextEntryNotYetCompressed( LhaHeader header )
    //  public void closeEntry()
    //------------------------------------------------------------------
    /**
     * VGgނ悤ɃXg[ݒ肷B<br>
     * ̃\bh Ɉkς݂̃Gg̏ꍇ
     * putNextEntryAlreadyCompressed(),
     * ɈkĂȂꍇ
     * putNextEntryNotYetCompressed() ĂяoB<br>
     * kĂ邩̔́A
     * <ul>
     *   <li>header.getCompressedSize()<br>
     *   <li>header.getCRC()<br>
     * </ul>
     * ̂ǂꂩł LhaHeader.UNKNOWN łΖɈkĂȂƂB<br>
     * header ɂ͐m OriginalSize w肳ĂKvB<br>
     * 
     * @param header ރGgɂĂ̏
     *               LhaHeader̃CX^XB
     * 
     * @exception IOException o̓G[ꍇ
     * @exception IllegalArgumentException
     *                        header.getOriginalSize()  LhaHeader.UNKNOWN Ԃꍇ
     */
    public void putNextEntry( LhaHeader header ) throws IOException {
        if( header.getCompressedSize() == LhaHeader.UNKNOWN
         || header.getCRC()            == LhaHeader.UNKNOWN ){
            this.putNextEntryNotYetCompressed( header );                        //throws IOException
        }else{
            this.putNextEntryAlreadyCompressed( header );                       //throws IOException
        }
    }

    /**
     * Ɉkς݂̃Ggނ悤ɃXg[ݒ肷B<br>
     * kς݃f[^́AĂяoۏ؂鎖B
     * 
     * @param header ރGgɂĂ̏
     *               LhaHeader̃CX^XB
     * 
     * @exception IOException o̓G[ꍇ
     * @exception IllegalArgumentException
     *               <ol>
     *                  <li>header.getOriginalSize()  LhaHeader.UNKNOWN Ԃꍇ
     *                  <li>header.getComressedSize()  LhaHeader.UNKNOWN Ԃꍇ
     *                  <li>header.getCRC()  LhaHeader.UNKNOWN Ԃꍇ
     *               </ol>
     *               ̉ꂩB
     */
    public void putNextEntryAlreadyCompressed( LhaHeader header )
                                                throws IOException {
        if( header.getOriginalSize()   != LhaHeader.UNKNOWN
         && header.getCompressedSize() != LhaHeader.UNKNOWN
         && header.getCRC()            != LhaHeader.UNKNOWN ){

            if( this.out != null ){
                this.closeEntry();
            }

            this.headerpos = this.archive.getFilePointer();

            this.encoding = this.property.getProperty( "lha.encoding" );
            if( this.encoding == null ){
                this.encoding = LhaProperty.getProperty( "lha.encoding" );
            }

            this.archive.write( header.getBytes( encoding ) );                  //throws IOException
            this.out = new RandomAccessFileOutputStream( this.archive, header.getCompressedSize() );

        }else if( header.getOriginalSize() == LhaHeader.UNKNOWN ){
            throw new IllegalArgumentException( "OriginalSize must not \"LhaHeader.UNKNOWN\"." );
        }else if( header.getCompressedSize() == LhaHeader.UNKNOWN ){
            throw new IllegalArgumentException( "CompressedSize must not \"LhaHeader.UNKNOWN\"." );
        }else{
            throw new IllegalArgumentException( "CRC must not \"LhaHeader.UNKNOWN\"." );
        }
    }

    /**
     * ɈkĂȂGgނ悤ɃXg[ݒ肷B<br>
     * header ɂ͐m OriginalSize w肳ĂKvB<br>
     * header  CompressedSize, CRCw肳ĂĂB<br>
     * 
     * @param header ރGgɂĂ̏
     *               LhaHeader̃CX^XB
     * 
     * @exception IOException o̓G[ꍇ
     * @exception IllegalArgumentException
     *                        header.getOriginalSize()  LhaHeader.UNKNOWN Ԃꍇ
     */
    public void putNextEntryNotYetCompressed( LhaHeader header ) 
                                                        throws IOException {
        if( header.getOriginalSize() != LhaHeader.UNKNOWN ){
            if( this.out != null ){
                this.closeEntry();
            }

            this.crc.reset();
            this.headerpos = this.archive.getFilePointer();
            this.header    = (LhaHeader)header.clone();
            this.header.setCompressedSize( 0 );
            this.header.setCRC( 0 );

            this.encoding = this.property.getProperty( "lha.encoding" );
            if( this.encoding == null ){
                this.encoding = LhaProperty.getProperty( "lha.encoding" );
            }

            this.archive.write( this.header.getBytes( encoding ) );
            this.rafo = new RandomAccessFileOutputStream( this.archive, header.getOriginalSize() );
            this.out = CompressMethod.connectEncoder( this.rafo, 
                                                      header.getCompressMethod(), 
                                                      this.property  );

        }else{
            throw new IllegalArgumentException( "OriginalSize must not \"LhaHeader.UNKNOWN\"." );
        }
    }

    /**
     * ݏo͒̃GgÃGgo͉\ȏԂɂB<br>
     * kɎs(kTCYkOTCY)ꍇA
     * 𓀂kŊi[BGg̃TCY傫ꍇA
     * ̏ɂ͂Ȃ̎ԂB
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void closeEntry() throws IOException {
        if( this.header != null ){
            this.out.close();

            if( !this.rafo.cache.isEmpty() ){
                RandomAccessFileInputStream rafi;
                InputStream in;
                long pos = this.rafo.start;
                rafi = new RandomAccessFileInputStream( this.archive, this.rafo  );
                in = CompressMethod.connectDecoder( rafi, 
                                                    header.getCompressMethod(), 
                                                    this.property,
                                                    this.header.getOriginalSize() );

                byte[] buffer = new byte[8192];
                int length;
                while( 0 <= ( length = in.read( buffer ) ) ){
                    rafi.cache( pos + length );
                    this.archive.seek( pos );
                    this.archive.write( buffer, 0, length );
                    pos += length;
                }
                in.close();

                this.header.setCompressMethod( CompressMethod.LH0 );
            }

            long pos  = this.archive.getFilePointer();
            long size = ( pos - this.headerpos
                              - this.header.getBytes( this.encoding ).length );
            this.header.setCompressedSize( size );
            if( this.header.getCRC() != LhaHeader.NO_CRC ){
                this.header.setCRC( (int)this.crc.getValue() );
            }

            this.archive.seek( this.headerpos );
            this.archive.write( this.header.getBytes( this.encoding ) );
            this.archive.seek( pos );
        }
        this.header = null;
        this.out    = null;
    }


    //------------------------------------------------------------------
    //  inner classes
    //------------------------------------------------------------------
    //  private static class RandomAccessFileOutputStream
    //  private static class RandomAccessFileInputStream
    //  private static class Cache
    //------------------------------------------------------------------
    /**
     * RandomAccessFile  OutputStream C^tFCXɍ킹邽߂̃bpNX
     */
    private static class RandomAccessFileOutputStream extends OutputStream {

        //------------------------------------------------------------------
        //  instance field
        //------------------------------------------------------------------
        //  sink
        //------------------------------------------------------------------
        //  private RandomAccessFile archive
        //  private GrowthByteBuffer cache
        //------------------------------------------------------------------
        /**
         * o͐RandomAccessFile
         */
        private RandomAccessFile archive;

        /**
         * i[E𒴂ďƂ
         * ꍇ̃LbV
         */
        private Cache cache;


        //------------------------------------------------------------------
        //  instance field
        //------------------------------------------------------------------
        //  position
        //------------------------------------------------------------------
        //  private long start
        //  private long pos
        //  private long limit
        //------------------------------------------------------------------
        /**
         * i[Jnʒu
         */
        private long start;

        /**
         * ݏʒu
         */
        private long pos;

        /**
         * i[E
         */
        private long limit;


        //------------------------------------------------------------------
        //  consutructor
        //------------------------------------------------------------------
        //  public RandomAccessFileOutputStream( RandomAccessFile archive,
        //                                       long length )
        //------------------------------------------------------------------
        /**
         * RandomAccessFile bv OutputStream \zB
         * 
         * @param archive o͐RandomAccessFile
         * @param length  o͌E
         * 
         * @exception IOException o̓G[G[ꍇ
         */
        public RandomAccessFileOutputStream( RandomAccessFile archive,
                                             long length ) throws IOException {
            this.archive = archive;
            this.start   = this.archive.getFilePointer();                       //throws IOException
            this.pos     = this.start;
            this.limit   = this.start + length;
            this.cache   = new Cache();
        }


        //------------------------------------------------------------------
        //  method of java.io.OutputStream
        //------------------------------------------------------------------
        //  write
        //------------------------------------------------------------------
        //  public void write( int data )
        //  public void write( byte[] buffer )
        //  public void write( byte[] buffer, int index, int length )
        //------------------------------------------------------------------
        /**
         * ڑꂽ RandomAccessFile 1oCgށB
         * 
         * @param data 1bytẽf[^
         * 
         * @exception IOException  o̓G[ꍇ
         */
        public void write( int data ) throws IOException {
            if( this.pos < this.limit && this.cache.isEmpty() ){
                this.pos++;
                this.archive.write( data );                                     //throws IOException
            }else{
                this.cache.add( new byte[]{ (byte)data } );
            }
        }

        /**
         * ڑꂽ RandomAccessFile  buffer ̓eSďށB
         * 
         * @param buffer ރf[^̓oCgz
         * 
         * @exception IOException  o̓G[ꍇ
         * @exception EOFException RXgN^ɓnꂽ𒴂
         *                         Ƃꍇ
         */
        public void write( byte[] buffer ) throws IOException {
            this.write( buffer, 0, buffer.length );                             //throws IOException
        }

        /**
         * ڑꂽRandomAccessFilebuffer̓eindexlengthoCgށB
         * 
         * @param buffer ރf[^̓oCgz
         * @param index  buffeȑރf[^̊Jnʒu
         * @param length ރf[^
         * 
         * @exception IOException  o̓G[ꍇ
         */
        public void write( byte[] buffer, int index, int length )
                                                        throws IOException {

            if( this.pos + length < this.limit && this.cache.isEmpty() ){
                this.pos += length;
                this.archive.write( buffer, index, length );                    //throws IOException
            }else{
                this.cache.add( buffer, index, length );
            }
        }


        //------------------------------------------------------------------
        //  method of java.io.OutputStream
        //------------------------------------------------------------------
        //  other
        //------------------------------------------------------------------
        //  public void close()
        //------------------------------------------------------------------
        /**
         * ̃Xg[ĎgpĂ\[XJB
         */
        public void close(){
            this.archive = null;
        }

    }

    /**
     * RandomAccessFile  InputStream̃C^[tFCXԂ郉bpNXB
     * k̃TCYkÕTCYƂɉ𓀂 
     * kŊi[Ȃ̂߂ɕKvB
     */
    private static class RandomAccessFileInputStream extends InputStream {

        //------------------------------------------------------------------
        //  instance field
        //------------------------------------------------------------------
        //  source
        //------------------------------------------------------------------
        //  private RandomAccessFile archive
        //  private Cache front
        //  private Cache rear
        //------------------------------------------------------------------
        /**
         * ǂݍ݌RandomAccessFile
         */
        private RandomAccessFile archive;

        /**
         * OLbV
         * ݂ǂݍ݂ǂz̃LbV
         */
        private Cache front;

        /**
         * 㕔LbV
         * ݌E𒴂̃f[^̃LbV
         */
        private Cache rear;


        //------------------------------------------------------------------
        //  instance field
        //------------------------------------------------------------------
        //  position
        //------------------------------------------------------------------
        //  private long pos
        //  private long limit
        //------------------------------------------------------------------
        /**
         * ݏʒu
         */
        private long pos;

        /**
         * ǂݍ݌E
         */
        private long limit;


        //------------------------------------------------------------------
        //  consutructor
        //------------------------------------------------------------------
        //  public RandomAccessFileInputStream( RandomAccessFile archive,
        //                                      RandomAccessFileOutputStream out )
        //------------------------------------------------------------------
        /**
         * RandomAccessFile bv InputStream \zB
         * 
         * @param archive f[^ RandomAccessFile
         * @param out     OɈkf[^󂯎Ă RandomAccessFileOutputStream
         */
        public RandomAccessFileInputStream( RandomAccessFile archive,
                                            RandomAccessFileOutputStream out ){
            this.archive = archive;
            this.pos     = out.start;
            this.limit   = out.pos;
            this.front   = new Cache();
            this.rear    = out.cache;
        }


        //------------------------------------------------------------------
        //  method of java.io.InputStream
        //------------------------------------------------------------------
        //  read
        //------------------------------------------------------------------
        //  public int read()
        //  public int read( byte[] buffer )
        //  public int read( byte[] buffer, int index, int length )
        //------------------------------------------------------------------
        /**
         * LbVRandomAccessFile 1oCg̃f[^ǂݍށB
         * 
         * @return ǂݍ܂ꂽ1oCg̃f[^<br>
         *         ǂݍރf[^ -1
         * 
         * @exception IOException o̓G[ꍇ
         */
        public int read() throws IOException {
            int return_value = this.front.read();
            if( return_value < 0 ){
                if( this.pos < this.limit ){
                    this.archive.seek( this.pos++ );
                    return_value = this.archive.read();
                }else{
                    return_value = this.rear.read();
                }
            }

            return return_value;
        }

        /**
         * LbV RandomAccessFile buffer𖞂悤Ƀf[^ǂݍށB
         * 
         * @param buffer ǂݍ܂ꂽf[^i[obt@
         * 
         * @return ۂɓǂݍ܂ꂽf[^
         * 
         * @exception IOException o̓G[ꍇ
         */
        public int read( byte[] buffer ) throws IOException {
            return this.read( buffer, 0, buffer.length );
        }

        /**
         * LbV RandomAccessFile bufferindexlengthoCgǂݍށB
         * 
         * @param buffer ǂݍ܂ꂽf[^i[obt@
         * @param index  buffer̓ǂݍ݊Jnʒu
         * @param length ǂݍރf[^
         * 
         * @return ۂɓǂݍ܂ꂽf[^
         * 
         * @exception IOException o̓G[ꍇ
         */
        public int read( byte[] buffer, int index, int length ) throws IOException {

            int count = 0;
            int ret   = this.front.read( buffer, index, length );
            if( 0 <= ret ){
                count += ret;
            }

            this.archive.seek( this.pos );                                      //throws IOException
            ret = Math.min( length - count, 
                            Math.max( (int)( this.limit - this.pos ), 0 ) );
            this.archive.readFully( buffer, index + count, ret );               //throws IOException
            if( 0 <= ret ){
                this.pos += ret;
                count    += ret;
            }

            ret = this.rear.read( buffer, index + count, length - count );
            if( 0 <= ret ){
                count += ret;
            }

            if( 0 < count ){
                return count;
            }else{
                return -1;
            }
        }


        //------------------------------------------------------------------
        //  method of java.io.InputStream 
        //------------------------------------------------------------------
        //  other
        //------------------------------------------------------------------
        //  public void close()
        //------------------------------------------------------------------
        /**
         * ̃Xg[
         * gpĂ\[XJB
         */
        public void close(){
            this.front   = null;
            this.rear    = null;
            this.archive = null;
        }


        //------------------------------------------------------------------
        //  original method
        //------------------------------------------------------------------
        //  public void cache( long pos )
        //------------------------------------------------------------------
        /**
         * pos܂œǂݍłȂ΁A
         * ݓǂݍ݈ʒupos܂ł̃f[^
         * OLbVɃf[^ǉB
         * 
         * @param pos archivȅoʒu
         */
        public void cache( long pos ) throws IOException {
            int length = (int)Math.min( this.limit - this.pos,
                                        pos - this.pos );

            byte[] buffer = new byte[ length ];
            if( 0 < length ){
                this.archive.seek( this.pos );                                  //throws IOException
                this.archive.readFully( buffer );                               //throws IOException
                this.front.add( buffer );
 
                this.pos += length;
            }
        }
    }

    /**
     * ݌E𒴂݂
     * ǂݍ݈ʒu𒴂݂ꍇ
     * f[^LbV邽߂ɎgpB
     */
    private static class Cache{

        //------------------------------------------------------------------
        //  instance field
        //------------------------------------------------------------------
        //  private Vector cache
        //  private byte[] current
        //  private int position
        //------------------------------------------------------------------
        /**
         * byte[]  Vector
         * evf Sēǂݍ܂ꂽ
         * Ɏ̂ĂB
         */
        private Vector cache;

        /**
         * ݓǂݍݒ̗vf
         */
        private byte[] current;

        /**
         * currenťݏʒu
         */
        private int position;


        //------------------------------------------------------------------
        //  constructor
        //------------------------------------------------------------------
        //  public Cache()
        //------------------------------------------------------------------
        /**
         * f[^̈ꎞޔ@\\zB
         */
        public Cache(){
            this.current  = null;
            this.position = 0;
            this.cache    = new Vector();
        }


        //------------------------------------------------------------------
        //  read
        //------------------------------------------------------------------
        //  public int read()
        //  public int read( byte[] buffer, int index, int length )
        //------------------------------------------------------------------
        /**
         * LbV 1oCg̃f[^
         * 0`255Ƀ}bvēǂݍށB
         * 
         * @return ǂݍ܂ꂽ1bytẽf[^<br>
         *         LbVŃf[^ꍇ -1
         */
        public int read(){
            if( null != this.current ){
                int ret = this.current[ this.position++ ] & 0xFF;

                if( this.current.length <= this.position ){
                    if( 0 < this.cache.size() ){
                        this.current = (byte[])this.cache.firstElement();
                        this.cache.removeElementAt( 0 );
                    }else{
                        this.current = null;
                    }
                    this.position = 0;
                }
                
                return ret;
            }else{
                return -1;
            }
        }

        /**
         * LbV bufferindexŎn܂ꏊlengthoCgǂݍށB
         * 
         * @param buffer ǂݍ񂾃f[^ێobt@
         * @param index  buffer̓ǂݍ݊Jnʒu
         * @param length ǂݍރf[^
         * 
         * @return ۂɓǂݍ܂ꂽf[^<br>
         *         LbVŃf[^ꍇ -1
         */
        public int read( byte[] buffer, int index, int length ){
            int count = 0;

            while( null != this.current && count < length ){
                int copylen = Math.min( this.current.length - this.position,
                                        length - count );
                System.arraycopy( this.current, this.position,
                                  buffer,       index + count,  copylen );

                this.position += copylen;
                count         += copylen;

                if( this.current.length <= this.position ){
                    if( 0 < this.cache.size() ){
                        this.current = (byte[])this.cache.firstElement();
                        this.cache.removeElementAt( 0 );
                    }else{
                        this.current = null;
                    }
                    this.position = 0;
                }
            }

            if( count == 0 ){
                return -1;
            }else{
                return count;
            }
        }


        //------------------------------------------------------------------
        //  write
        //------------------------------------------------------------------
        //  public void add( byte[] buffer )
        //  public void add( byte[] buffer, int index, int length )
        //------------------------------------------------------------------
        /**
         * LbVɃf[^ǉB
         * 
         * @param buffer f[^̊i[ꂽobt@
         */
        public void add( byte[] buffer ){
            if( this.current == null ){
                this.current = buffer;
            }else{
                this.cache.addElement( buffer );
            }
        }

        /**
         * LbVɃf[^ǉB
         * 
         * @parma buffer f[^̊i[ꂽobt@
         * @param index  buffer̃f[^Jnʒu
         * @param length i[Ăf[^̗
         */
        public void add( byte[] buffer, int index, int length ){
            byte[] buf = new byte[ length ];
            System.arraycopy( buffer, index, buf, 0, length );

            if( this.current == null ){
                this.current = buf;
            }else{
                this.cache.addElement( buf );
            }
        }


        //------------------------------------------------------------------
        //  other
        //------------------------------------------------------------------
        //  public boolean isEmpty()
        //------------------------------------------------------------------
        /**
         * ̃LbV󂩂𓾂B
         * 
         * @return ̃LbVȂ true
         *         łȂ false
         */
        public boolean isEmpty(){
            return this.current == null;
        }

    }

}
//end of LhaRetainedOutputStream.java
