package org.jboss.cache.factories;

import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.DefaultFactoryFor;
import org.jboss.cache.factories.annotations.NonVolatile;

/**
 * // TODO: MANIK: Document this
 *
 * @author Manik Surtani (<a href="mailto:manik@jboss.org">manik@jboss.org</a>)
 * @since 2.2.0
 */
@DefaultFactoryFor(classes = {CacheSPI.class, Configuration.class, ComponentRegistry.class})
@NonVolatile
public class BootstrapFactory extends ComponentFactory
{
   CacheSPI cacheSPI;

   public BootstrapFactory(CacheSPI cacheSPI, Configuration configuration, ComponentRegistry componentRegistry)
   {
      super(componentRegistry, configuration);
      this.cacheSPI = cacheSPI;
   }

   @Override
   protected <T> T construct(Class<T> componentType)
   {
      if (componentType.isAssignableFrom(CacheSPI.class) ||
          componentType.isAssignableFrom(Configuration.class) ||
          componentType.isAssignableFrom(ComponentRegistry.class)) 
      {
         return componentType.cast(cacheSPI);
      }

      throw new CacheException("Don't know how to handle type " + componentType);
   }
}
