/**************************************************************************\
 ibtk (Insomnia's Basic ToolKit)

  By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#ifndef ITEXTBOX_H
#define ITEXTBOX_H

#include <X11/X.h>   
#include <X11/Xlib.h>
#include "idodad.h"
#include "iwindow.h"

class ITextBox : public IDoDad  {
public:
  ITextBox(char *txt, IWindow *w, int xp, int yp, int xs, int ys);
  virtual ~ITextBox();
  virtual int Type()  { return DODAD_TEXTBOX; };
  virtual void Redraw();
  virtual void Rebuild();
  virtual int Press(int b, int x, int y);
  virtual int Release(int b, int x, int y);
protected:
  ITextBox() {};
  void Init(char *txt, IWindow *w, int xp, int yp, int xs, int ys);
  Pixmap Img;
  int xpos, ypos, xsize, ysize;
  };

#endif

