/*
 * libexplain - Explain errno values returned by libc functions
 * Copyright (C) 2009 Peter Miller
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef LIBEXPLAIN_BUFFER_TCFLOW_ACTION_H
#define LIBEXPLAIN_BUFFER_TCFLOW_ACTION_H

#include <libexplain/string_buffer.h>

/**
  * The explain_buffer_tcflow_action function may be used
  * to print a representation of a tcflow action value.
  *
  * @param sb
  *     The string buffer to print into.
  * @param data
  *     The tcflow action value to be printed.
  */
void explain_buffer_tcflow_action(explain_string_buffer_t *sb, int data);

/**
  * The explain_parse_tcflow_action_or_die function is used to parse
  * a text value, to transform it into a tcflow action argument value.
  *
  * @param text
  *     The text string to be parsed.
  * @param caption
  *     Additinal information for error message.
  * @returns
  *     the int value on success, does not return on failure but instead
  *     prints and error messages and exits.
  */
int explain_parse_tcflow_action_or_die(const char *text, const char *caption);

#endif /* LIBEXPLAIN_BUFFER_TCFLOW_ACTION_H */
