/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.Choose;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLOtherwise;
import net.sf.saxon.style.XSLStyleSheet;
import net.sf.saxon.style.XSLWhen;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.BooleanValue;

public class XSLChoose
extends StyleElement {
    private StyleElement otherwise;
    private int numberOfWhens = 0;

    public boolean isInstruction() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        return this.getCommonChildItemType();
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            this.checkUnknownAttribute(n2);
            ++n;
        }
    }

    public void validate() throws TransformerConfigurationException {
        NodeInfo nodeInfo;
        this.checkWithinTemplate();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (nodeInfo instanceof XSLWhen) {
                if (this.otherwise != null) {
                    this.compileError("xsl:otherwise must come last");
                }
                ++this.numberOfWhens;
                continue;
            }
            if (nodeInfo instanceof XSLOtherwise) {
                if (this.otherwise != null) {
                    this.compileError("Only one xsl:otherwise allowed in an xsl:choose");
                    continue;
                }
                this.otherwise = (StyleElement)nodeInfo;
                continue;
            }
            if (nodeInfo.getNodeKind() == 3 && Navigator.isWhite(nodeInfo.getStringValue())) {
                this.compileError("Text node inside xsl:choose");
                continue;
            }
            this.compileError("Only xsl:when and xsl:otherwise are allowed here");
        }
        if (this.numberOfWhens == 0) {
            this.compileError("xsl:choose must contain at least one xsl:when");
        }
    }

    public void markTailCalls() {
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        NodeInfo nodeInfo;
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (!(nodeInfo instanceof StyleElement)) continue;
            ((StyleElement)nodeInfo).markTailCalls();
        }
        return;
    }

    public Instruction compile() throws TransformerConfigurationException {
        Instruction[] instructionArray;
        Expression[] expressionArray;
        XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
        int n = this.numberOfWhens + (this.otherwise == null ? 0 : 1);
        Expression[] expressionArray2 = new Expression[n];
        Instruction[] instructionArray2 = new Instruction[n];
        int n2 = 0;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((expressionArray = (Expression[])axisIterator.next()) != null) {
            if (expressionArray instanceof XSLWhen) {
                expressionArray2[n2] = ((XSLWhen)expressionArray).getCondition();
                instructionArray = new Block();
                ((XSLWhen)expressionArray).compileChildren((Instruction)instructionArray);
                instructionArray2[n2] = instructionArray;
                instructionArray.setInstructionName((byte)6);
                instructionArray.setSourceLocation(xSLStyleSheet.putModuleNumber(expressionArray.getSystemId()), expressionArray.getLineNumber());
                if (expressionArray2[n2] instanceof BooleanValue) {
                    if (((BooleanValue)expressionArray2[n2]).getValue()) {
                        n = n2 + 1;
                        break;
                    }
                    --n2;
                    --n;
                }
                ++n2;
                continue;
            }
            if (expressionArray instanceof XSLOtherwise) {
                expressionArray2[n2] = BooleanValue.TRUE;
                instructionArray = new Block();
                ((XSLOtherwise)expressionArray).compileChildren((Instruction)instructionArray);
                instructionArray2[n2++] = instructionArray;
                instructionArray.setInstructionName((byte)1);
                instructionArray.setSourceLocation(xSLStyleSheet.putModuleNumber(expressionArray.getSystemId()), expressionArray.getLineNumber());
                continue;
            }
            new AssertionError((Object)"Expected xsl:when or xsl:otherwise");
        }
        if (expressionArray2.length != n) {
            expressionArray = new Expression[n];
            System.arraycopy(expressionArray2, 0, expressionArray, 0, n);
            instructionArray = new Instruction[n];
            System.arraycopy(instructionArray2, 0, instructionArray, 0, n);
            expressionArray2 = expressionArray;
            instructionArray2 = instructionArray;
        }
        return new Choose(expressionArray2, instructionArray2);
    }
}

