/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <QtGui/QSpinBox>

#include "integerfield.h"

using namespace Form;

IntegerField::IntegerField( const QString &name, QWidget *parent )
  : Field( name, parent )
{
  mSpinBox = new QSpinBox( this );

  fieldLayout()->addWidget( mSpinBox, 0, 0 );
}

void IntegerField::loadEntry( const Entry &entry )
{
  if ( !defaultValue().isEmpty() )
    mSpinBox->setValue( defaultValue().toInt() );

  if ( !entry.value( name() ).isEmpty() )
    mSpinBox->setValue( entry.value( name() ).toInt() );
}

void IntegerField::saveEntry( Entry &entry ) const
{
  entry.setValue( name(), QString::number( mSpinBox->value() ) );
}

bool IntegerField::isValid( QString&, PagePolicy::State ) const
{
  return true;
}

void IntegerField::setEditable( bool editable )
{
  mSpinBox->setEnabled( editable );
}

