(function (root, factory) {
 if (typeof define === 'function' && define.amd) {
 define('jsxgraphcore', [], factory);
 } else if (typeof module === 'object' && module.exports) {
 module.exports = factory();
 } else {
 root.returnExports = factory();
 }
}(this, function () {
/**
 * @license almond 0.3.3 Copyright jQuery Foundation and other contributors.
 * Released under MIT license, http://github.com/requirejs/almond/LICENSE
 */
//Going sloppy to avoid 'use strict' string cost, but strict practices should
//be followed.
/*global setTimeout: false */

var requirejs, require, define;
(function (undef) {
    var main, req, makeMap, handlers,
        defined = {},
        waiting = {},
        config = {},
        defining = {},
        hasOwn = Object.prototype.hasOwnProperty,
        aps = [].slice,
        jsSuffixRegExp = /\.js$/;

    function hasProp(obj, prop) {
        return hasOwn.call(obj, prop);
    }

    /**
     * Given a relative module name, like ./something, normalize it to
     * a real name that can be mapped to a path.
     * @param {String} name the relative name
     * @param {String} baseName a real name that the name arg is relative
     * to.
     * @returns {String} normalized name
     */
    function normalize(name, baseName) {
        var nameParts, nameSegment, mapValue, foundMap, lastIndex,
            foundI, foundStarMap, starI, i, j, part, normalizedBaseParts,
            baseParts = baseName && baseName.split("/"),
            map = config.map,
            starMap = (map && map['*']) || {};

        //Adjust any relative paths.
        if (name) {
            name = name.split('/');
            lastIndex = name.length - 1;

            // If wanting node ID compatibility, strip .js from end
            // of IDs. Have to do this here, and not in nameToUrl
            // because node allows either .js or non .js to map
            // to same file.
            if (config.nodeIdCompat && jsSuffixRegExp.test(name[lastIndex])) {
                name[lastIndex] = name[lastIndex].replace(jsSuffixRegExp, '');
            }

            // Starts with a '.' so need the baseName
            if (name[0].charAt(0) === '.' && baseParts) {
                //Convert baseName to array, and lop off the last part,
                //so that . matches that 'directory' and not name of the baseName's
                //module. For instance, baseName of 'one/two/three', maps to
                //'one/two/three.js', but we want the directory, 'one/two' for
                //this normalization.
                normalizedBaseParts = baseParts.slice(0, baseParts.length - 1);
                name = normalizedBaseParts.concat(name);
            }

            //start trimDots
            for (i = 0; i < name.length; i++) {
                part = name[i];
                if (part === '.') {
                    name.splice(i, 1);
                    i -= 1;
                } else if (part === '..') {
                    // If at the start, or previous value is still ..,
                    // keep them so that when converted to a path it may
                    // still work when converted to a path, even though
                    // as an ID it is less than ideal. In larger point
                    // releases, may be better to just kick out an error.
                    if (i === 0 || (i === 1 && name[2] === '..') || name[i - 1] === '..') {
                        continue;
                    } else if (i > 0) {
                        name.splice(i - 1, 2);
                        i -= 2;
                    }
                }
            }
            //end trimDots

            name = name.join('/');
        }

        //Apply map config if available.
        if ((baseParts || starMap) && map) {
            nameParts = name.split('/');

            for (i = nameParts.length; i > 0; i -= 1) {
                nameSegment = nameParts.slice(0, i).join("/");

                if (baseParts) {
                    //Find the longest baseName segment match in the config.
                    //So, do joins on the biggest to smallest lengths of baseParts.
                    for (j = baseParts.length; j > 0; j -= 1) {
                        mapValue = map[baseParts.slice(0, j).join('/')];

                        //baseName segment has  config, find if it has one for
                        //this name.
                        if (mapValue) {
                            mapValue = mapValue[nameSegment];
                            if (mapValue) {
                                //Match, update name to the new value.
                                foundMap = mapValue;
                                foundI = i;
                                break;
                            }
                        }
                    }
                }

                if (foundMap) {
                    break;
                }

                //Check for a star map match, but just hold on to it,
                //if there is a shorter segment match later in a matching
                //config, then favor over this star map.
                if (!foundStarMap && starMap && starMap[nameSegment]) {
                    foundStarMap = starMap[nameSegment];
                    starI = i;
                }
            }

            if (!foundMap && foundStarMap) {
                foundMap = foundStarMap;
                foundI = starI;
            }

            if (foundMap) {
                nameParts.splice(0, foundI, foundMap);
                name = nameParts.join('/');
            }
        }

        return name;
    }

    function makeRequire(relName, forceSync) {
        return function () {
            //A version of a require function that passes a moduleName
            //value for items that may need to
            //look up paths relative to the moduleName
            var args = aps.call(arguments, 0);

            //If first arg is not require('string'), and there is only
            //one arg, it is the array form without a callback. Insert
            //a null so that the following concat is correct.
            if (typeof args[0] !== 'string' && args.length === 1) {
                args.push(null);
            }
            return req.apply(undef, args.concat([relName, forceSync]));
        };
    }

    function makeNormalize(relName) {
        return function (name) {
            return normalize(name, relName);
        };
    }

    function makeLoad(depName) {
        return function (value) {
            defined[depName] = value;
        };
    }

    function callDep(name) {
        if (hasProp(waiting, name)) {
            var args = waiting[name];
            delete waiting[name];
            defining[name] = true;
            main.apply(undef, args);
        }

        if (!hasProp(defined, name) && !hasProp(defining, name)) {
            throw new Error('No ' + name);
        }
        return defined[name];
    }

    //Turns a plugin!resource to [plugin, resource]
    //with the plugin being undefined if the name
    //did not have a plugin prefix.
    function splitPrefix(name) {
        var prefix,
            index = name ? name.indexOf('!') : -1;
        if (index > -1) {
            prefix = name.substring(0, index);
            name = name.substring(index + 1, name.length);
        }
        return [prefix, name];
    }

    //Creates a parts array for a relName where first part is plugin ID,
    //second part is resource ID. Assumes relName has already been normalized.
    function makeRelParts(relName) {
        return relName ? splitPrefix(relName) : [];
    }

    /**
     * Makes a name map, normalizing the name, and using a plugin
     * for normalization if necessary. Grabs a ref to plugin
     * too, as an optimization.
     */
    makeMap = function (name, relParts) {
        var plugin,
            parts = splitPrefix(name),
            prefix = parts[0],
            relResourceName = relParts[1];

        name = parts[1];

        if (prefix) {
            prefix = normalize(prefix, relResourceName);
            plugin = callDep(prefix);
        }

        //Normalize according
        if (prefix) {
            if (plugin && plugin.normalize) {
                name = plugin.normalize(name, makeNormalize(relResourceName));
            } else {
                name = normalize(name, relResourceName);
            }
        } else {
            name = normalize(name, relResourceName);
            parts = splitPrefix(name);
            prefix = parts[0];
            name = parts[1];
            if (prefix) {
                plugin = callDep(prefix);
            }
        }

        //Using ridiculous property names for space reasons
        return {
            f: prefix ? prefix + '!' + name : name, //fullName
            n: name,
            pr: prefix,
            p: plugin
        };
    };

    function makeConfig(name) {
        return function () {
            return (config && config.config && config.config[name]) || {};
        };
    }

    handlers = {
        require: function (name) {
            return makeRequire(name);
        },
        exports: function (name) {
            var e = defined[name];
            if (typeof e !== 'undefined') {
                return e;
            } else {
                return (defined[name] = {});
            }
        },
        module: function (name) {
            return {
                id: name,
                uri: '',
                exports: defined[name],
                config: makeConfig(name)
            };
        }
    };

    main = function (name, deps, callback, relName) {
        var cjsModule, depName, ret, map, i, relParts,
            args = [],
            callbackType = typeof callback,
            usingExports;

        //Use name if no relName
        relName = relName || name;
        relParts = makeRelParts(relName);

        //Call the callback to define the module, if necessary.
        if (callbackType === 'undefined' || callbackType === 'function') {
            //Pull out the defined dependencies and pass the ordered
            //values to the callback.
            //Default to [require, exports, module] if no deps
            deps = !deps.length && callback.length ? ['require', 'exports', 'module'] : deps;
            for (i = 0; i < deps.length; i += 1) {
                map = makeMap(deps[i], relParts);
                depName = map.f;

                //Fast path CommonJS standard dependencies.
                if (depName === "require") {
                    args[i] = handlers.require(name);
                } else if (depName === "exports") {
                    //CommonJS module spec 1.1
                    args[i] = handlers.exports(name);
                    usingExports = true;
                } else if (depName === "module") {
                    //CommonJS module spec 1.1
                    cjsModule = args[i] = handlers.module(name);
                } else if (hasProp(defined, depName) ||
                           hasProp(waiting, depName) ||
                           hasProp(defining, depName)) {
                    args[i] = callDep(depName);
                } else if (map.p) {
                    map.p.load(map.n, makeRequire(relName, true), makeLoad(depName), {});
                    args[i] = defined[depName];
                } else {
                    throw new Error(name + ' missing ' + depName);
                }
            }

            ret = callback ? callback.apply(defined[name], args) : undefined;

            if (name) {
                //If setting exports via "module" is in play,
                //favor that over return value and exports. After that,
                //favor a non-undefined return value over exports use.
                if (cjsModule && cjsModule.exports !== undef &&
                        cjsModule.exports !== defined[name]) {
                    defined[name] = cjsModule.exports;
                } else if (ret !== undef || !usingExports) {
                    //Use the return value from the function.
                    defined[name] = ret;
                }
            }
        } else if (name) {
            //May just be an object definition for the module. Only
            //worry about defining if have a module name.
            defined[name] = callback;
        }
    };

    requirejs = require = req = function (deps, callback, relName, forceSync, alt) {
        if (typeof deps === "string") {
            if (handlers[deps]) {
                //callback in this case is really relName
                return handlers[deps](callback);
            }
            //Just return the module wanted. In this scenario, the
            //deps arg is the module name, and second arg (if passed)
            //is just the relName.
            //Normalize module name, if it contains . or ..
            return callDep(makeMap(deps, makeRelParts(callback)).f);
        } else if (!deps.splice) {
            //deps is a config object, not an array.
            config = deps;
            if (config.deps) {
                req(config.deps, config.callback);
            }
            if (!callback) {
                return;
            }

            if (callback.splice) {
                //callback is an array, which means it is a dependency list.
                //Adjust args if there are dependencies
                deps = callback;
                callback = relName;
                relName = null;
            } else {
                deps = undef;
            }
        }

        //Support require(['a'])
        callback = callback || function () {};

        //If relName is a function, it is an errback handler,
        //so remove it.
        if (typeof relName === 'function') {
            relName = forceSync;
            forceSync = alt;
        }

        //Simulate async callback;
        if (forceSync) {
            main(undef, deps, callback, relName);
        } else {
            //Using a non-zero value because of concern for what old browsers
            //do, and latest browsers "upgrade" to 4 if lower value is used:
            //http://www.whatwg.org/specs/web-apps/current-work/multipage/timers.html#dom-windowtimers-settimeout:
            //If want a value immediately, use require('id') instead -- something
            //that works in almond on the global level, but not guaranteed and
            //unlikely to work in other AMD implementations.
            setTimeout(function () {
                main(undef, deps, callback, relName);
            }, 4);
        }

        return req;
    };

    /**
     * Just drops the config on the floor, but returns req in case
     * the config return value is used.
     */
    req.config = function (cfg) {
        return req(cfg);
    };

    /**
     * Expose module registry for debugging and tooling
     */
    requirejs._defined = defined;

    define = function (name, deps, callback) {
        if (typeof name !== 'string') {
            throw new Error('See almond README: incorrect module build, no module name');
        }

        //This module may not have dependencies
        if (!deps.splice) {
            //deps is not an array, so probably means
            //an object literal or factory function for
            //the value. Adjust args.
            callback = deps;
            deps = [];
        }

        if (!hasProp(defined, name) && !hasProp(waiting, name)) {
            waiting[name] = [name, deps, callback];
        }
    };

    define.amd = {
        jQuery: true
    };
}());

define("../node_modules/almond/almond", function(){});

/*
    Copyright 2008-2022
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Andreas Walter,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph and JSXCompressor.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.
    JSXCompressor is free software dual licensed under the GNU LGPL or Apache License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT
      OR
      * Apache License Version 2.0

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License, Apache
    License, and the MIT License along with JSXGraph. If not, see
    <http://www.gnu.org/licenses/>, <https://www.apache.org/licenses/LICENSE-2.0.html>,
    and <http://opensource.org/licenses/MIT/>.

 */

/*global JXG: true, define: true, jQuery: true, window: true, document: true, navigator: true, require: true, module: true, console: true */
/*jslint nomen:true, plusplus:true, forin:true*/

/* depends:
 */

/**
 * @fileoverview The JSXGraph object is defined in this file. JXG.JSXGraph controls all boards.
 * It has methods to create, save, load and free boards. Additionally some helper functions are
 * defined in this file directly in the JXG namespace.
 */

define('jxg',[], function () {

    'use strict';

    /**
     * JXG is the top object of JSXGraph and defines the namespace
     * @exports jxg as JXG
     */
    var jxg = {};

    // Make sure JXG.extend is not defined
    // If jsxgraph is loaded via loadjsxgraph.js, this is required, but JXG.extend will be undefined
    // If jsxgraph is compiled as an amd module, it is possible that another jsxgraph version is already loaded and we
    // therefore must not re-use the global JXG variable. But in this case JXG.extend will already be defined.
    // This is the reason for this check.
    if (typeof JXG === 'object' && !JXG.extend) {
        jxg = JXG;
    }

    // We need the following two methods "extend" and "shortcut" to create the JXG object via JXG.extend.

    /**
     * Copy all properties of the <tt>extension</tt> object to <tt>object</tt>.
     * @param {Object} object
     * @param {Object} extension
     * @param {Boolean} [onlyOwn=false] Only consider properties that belong to extension itself, not any inherited properties.
     * @param {Boolean} [toLower=false] If true the keys are convert to lower case. This is needed for visProp, see JXG#copyAttributes
     */
    jxg.extend = function (object, extension, onlyOwn, toLower) {
        var e, e2;

        onlyOwn = onlyOwn || false;
        toLower = toLower || false;

        // the purpose of this for...in loop is indeed to use hasOwnProperty only if the caller
        // explicitly wishes so.
        for (e in extension) {
            if (!onlyOwn || (onlyOwn && extension.hasOwnProperty(e))) {
                if (toLower) {
                    e2 = e.toLowerCase();
                } else {
                    e2 = e;
                }

                object[e2] = extension[e];
            }
        }
    };

    /**
     * Set a constant <tt>name</tt> in <tt>object</tt> to <tt>value</tt>. The value can't be changed after declaration.
     * @param {Object} object
     * @param {String} name
     * @param {Number|String|Boolean} value
     * @param {Boolean} ignoreRedefine This should be left at its default: false.
     */
    jxg.defineConstant = function (object, name, value, ignoreRedefine) {
        ignoreRedefine = ignoreRedefine || false;

        if (ignoreRedefine && jxg.exists(object[name])) {
            return;
        }

        Object.defineProperty(object, name, {
            value: value,
            writable: false,
            enumerable: true,
            configurable: false,
        });
    };

    /**
     * Copy all properties of the <tt>constants</tt> object in <tt>object</tt> as a constant.
     * @param {Object} object
     * @param {Object} constants
     * @param {Boolean} [onlyOwn=false] Only consider properties that belong to extension itself, not any inherited properties.
     * @param {Boolean} [toUpper=false] If true the keys are convert to lower case. This is needed for visProp, see JXG#copyAttributes
     */
    jxg.extendConstants = function (object, constants, onlyOwn, toUpper) {
        var e, e2;

        onlyOwn = onlyOwn || false;
        toUpper = toUpper || false;

        // The purpose of this for...in loop is indeed to use hasOwnProperty only if the caller explicitly wishes so.
        for (e in constants) {
            if (!onlyOwn || (onlyOwn && constants.hasOwnProperty(e))) {
                if (toUpper) {
                    e2 = e.toUpperCase();
                } else {
                    e2 = e;
                }

                this.defineConstant(object, e2, constants[e]);
            }
        }
    };

    jxg.extend(jxg, /** @lends JXG */ {
        /**
         * Store a reference to every board in this central list. This will at some point
         * replace JXG.JSXGraph.boards.
         * @type Object
         */
        boards: {},

        /**
         * Store the available file readers in this structure.
         * @type Object
         */
        readers: {},

        /**
         * Associative array that keeps track of all constructable elements registered
         * via {@link JXG.registerElement}.
         * @type Object
         */
        elements: {},

        /**
         * This registers a new construction element to JSXGraph for the construction via the {@link JXG.Board.create}
         * interface.
         * @param {String} element The elements name. This is case-insensitive, existing elements with the same name
         * will be overwritten.
         * @param {Function} creator A reference to a function taking three parameters: First the board, the element is
         * to be created on, a parent element array, and an attributes object. See {@link JXG.createPoint} or any other
         * <tt>JXG.create...</tt> function for an example.
         */
        registerElement: function (element, creator) {
            element = element.toLowerCase();
            this.elements[element] = creator;
        },

        /**
         * Register a file reader.
         * @param {function} reader A file reader. This object has to provide two methods: <tt>prepareString()</tt>
         * and <tt>read()</tt>.
         * @param {Array} ext
         */
        registerReader: function (reader, ext) {
            var i, e;

            for (i = 0; i < ext.length; i++) {
                e = ext[i].toLowerCase();

                if (typeof this.readers[e] !== 'function') {
                    this.readers[e] = reader;
                }
            }
        },

        /**
         * Creates a shortcut to a method, e.g. {@link JXG.Board#createElement} is a shortcut to {@link JXG.Board#create}.
         * Sometimes the target is undefined by the time you want to define the shortcut so we need this little helper.
         * @param {Object} object The object the method we want to create a shortcut for belongs to.
         * @param {String} fun The method we want to create a shortcut for.
         * @returns {Function} A function that calls the given method.
         */
        shortcut: function (object, fun) {
            return function () {
                return object[fun].apply(this, arguments);
            };
        },

        /**
         * s may be a string containing the name or id of an element or even a reference
         * to the element itself. This function returns a reference to the element. Search order: id, name.
         * @param {JXG.Board} board Reference to the board the element belongs to.
         * @param {String} s String or reference to a JSXGraph element.
         * @returns {Object} Reference to the object given in parameter object
         * @deprecated Use {@link JXG.Board#select}
         */
        getRef: function (board, s) {
            jxg.deprecated('JXG.getRef()', 'Board.select()');
            return board.select(s);
        },

        /**
         * This is just a shortcut to {@link JXG.getRef}.
         * @deprecated Use {@link JXG.Board#select}.
         */
        getReference: function (board, s) {
            jxg.deprecated('JXG.getReference()', 'Board.select()');
            return board.select(s);
        },

        /**
         * s may be the string containing the id of an HTML tag that hosts a JSXGraph board.
         * This function returns the reference to the board.
         * @param  {String} s String of an HTML tag that hosts a JSXGraph board
         * @returns {Object} Reference to the board or null.
         */
        getBoardByContainerId: function (s) {
            var b;
            for (b in JXG.boards) {
                if (JXG.boards.hasOwnProperty(b) &&
                    JXG.boards[b].container === s) {
                    return JXG.boards[b];
                }
            }

            return null;
        },

        /**
         * This method issues a warning to the developer that the given function is deprecated
         * and, if available, offers an alternative to the deprecated function.
         * @param {String} what Describes the function that is deprecated
         * @param {String} [replacement] The replacement that should be used instead.
         */
        deprecated: function (what, replacement) {
            var warning = what + ' is deprecated.';

            if (replacement) {
                warning += ' Please use ' + replacement + ' instead.';
            }

            jxg.warn(warning);
        },

        /**
         * Outputs a warning via console.warn(), if available. If console.warn() is
         * unavailable this function will look for an HTML element with the id 'warning'
         * and append the warning to this element's innerHTML.
         * @param {String} warning The warning text
         */
        warn: function (warning) {
            if (typeof window === 'object' && window.console && console.warn) {
                console.warn('WARNING:', warning);
            } else if (typeof document === 'object' && document.getElementById('warning')) {
                document.getElementById('debug').innerHTML += 'WARNING: ' + warning + '<br />';
            }
        },

        /**
         * Add something to the debug log. If available a JavaScript debug console is used. Otherwise
         * we're looking for a HTML div with id "debug". If this doesn't exist, too, the output is omitted.
         * @param s An arbitrary number of parameters.
         * @see JXG#debugWST
         */
        debugInt: function (s) {
            var i, p;

            for (i = 0; i < arguments.length; i++) {
                p = arguments[i];
                if (typeof window === 'object' && window.console && console.log) {
                    console.log(p);
                } else if (typeof document === 'object' && document.getElementById('debug')) {
                    document.getElementById('debug').innerHTML += p + '<br/>';
                }
            }
        },

        /**
         * Add something to the debug log. If available a JavaScript debug console is used. Otherwise
         * we're looking for a HTML div with id "debug". If this doesn't exist, too, the output is omitted.
         * This method adds a stack trace (if available).
         * @param s An arbitrary number of parameters.
         * @see JXG#debug
         */
        debugWST: function (s) {
            var e = new Error();

            jxg.debugInt.apply(this, arguments);

            if (e && e.stack) {
                jxg.debugInt('stacktrace');
                jxg.debugInt(e.stack.split('\n').slice(1).join('\n'));
            }
        },

        /**
         * Add something to the debug log. If available a JavaScript debug console is used. Otherwise
         * we're looking for a HTML div with id "debug". If this doesn't exist, too, the output is omitted.
         * This method adds a line of the stack trace (if available).
         *
         * @param s An arbitrary number of parameters.
         * @see JXG#debug
         */
        debugLine: function (s) {
            var e = new Error();

            jxg.debugInt.apply(this, arguments);

            if (e && e.stack) {
                jxg.debugInt('Called from', e.stack.split('\n').slice(2, 3).join('\n'));
            }
        },

        /**
         * Add something to the debug log. If available a JavaScript debug console is used. Otherwise
         * we're looking for a HTML div with id "debug". If this doesn't exist, too, the output is omitted.
         * @param s An arbitrary number of parameters.
         * @see JXG#debugWST
         * @see JXG#debugLine
         * @see JXG#debugInt
         */
        debug: function (s) {
            jxg.debugInt.apply(this, arguments);
        }
    });

    return jxg;
});

/*
    Copyright 2008-2022
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Andreas Walter,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <http://www.gnu.org/licenses/>
    and <http://opensource.org/licenses/MIT/>.
 */

/*global JXG: true, define: true*/
/*jslint nomen: true, plusplus: true*/

/* depends:
 jxg
 */

define('base/constants',['jxg'], function (JXG) {
    'use strict';

    var major = 1,
        minor = 4,
        patch = 2,
        add = '', //'dev'
        version = major + '.' + minor + '.' + patch + (add ? '-' + add : ''),
        constants;

    constants = /** @lends JXG */ {
        /**
         * Constant: the currently used JSXGraph version.
         *
         * @name JXG.version
         * @type String
         */
        version: version,

        /**
         * Constant: the small gray version indicator in the top left corner of every JSXGraph board (if
         * showCopyright is not set to false on board creation).
         *
         * @name JXG.licenseText
         * @type String
         */
        licenseText: 'JSXGraph v' + version + ' Copyright (C) see https://jsxgraph.org',

        /**
         *  Constant: user coordinates relative to the coordinates system defined by the bounding box.
         *  @name JXG.COORDS_BY_USER
         *  @type Number
         */
        COORDS_BY_USER: 0x0001,

        /**
         *  Constant: screen coordinates in pixel relative to the upper left corner of the div element.
         *  @name JXG.COORDS_BY_SCREEN
         *  @type Number
         */
        COORDS_BY_SCREEN: 0x0002,

        // object types
        OBJECT_TYPE_ARC: 1,
        OBJECT_TYPE_ARROW: 2,
        OBJECT_TYPE_AXIS: 3,
        OBJECT_TYPE_AXISPOINT: 4,
        OBJECT_TYPE_TICKS: 5,
        OBJECT_TYPE_CIRCLE: 6,
        OBJECT_TYPE_CONIC: 7,
        OBJECT_TYPE_CURVE: 8,
        OBJECT_TYPE_GLIDER: 9,
        OBJECT_TYPE_IMAGE: 10,
        OBJECT_TYPE_LINE: 11,
        OBJECT_TYPE_POINT: 12,
        OBJECT_TYPE_SLIDER: 13,
        OBJECT_TYPE_CAS: 14,
        OBJECT_TYPE_GXTCAS: 15,
        OBJECT_TYPE_POLYGON: 16,
        OBJECT_TYPE_SECTOR: 17,
        OBJECT_TYPE_TEXT: 18,
        OBJECT_TYPE_ANGLE: 19,
        OBJECT_TYPE_INTERSECTION: 20,
        OBJECT_TYPE_TURTLE: 21,
        OBJECT_TYPE_VECTOR: 22,
        OBJECT_TYPE_OPROJECT: 23,
        OBJECT_TYPE_GRID: 24,
        OBJECT_TYPE_TANGENT: 25,
        OBJECT_TYPE_HTMLSLIDER: 26,
        OBJECT_TYPE_CHECKBOX: 27,
        OBJECT_TYPE_INPUT: 28,
        OBJECT_TYPE_BUTTON: 29,
        OBJECT_TYPE_TRANSFORMATION: 30,
        OBJECT_TYPE_FOREIGNOBJECT: 31,
        OBJECT_TYPE_VIEW3D: 32,

        // IMPORTANT:
        // ----------
        // For being able to differentiate between the (sketchometry specific) SPECIAL_OBJECT_TYPEs and
        // (core specific) OBJECT_TYPEs, the non-sketchometry types MUST NOT be changed
        // to values > 100.

        // object classes
        OBJECT_CLASS_POINT: 1,
        OBJECT_CLASS_LINE: 2,
        OBJECT_CLASS_CIRCLE: 3,
        OBJECT_CLASS_CURVE: 4,
        OBJECT_CLASS_AREA: 5,
        OBJECT_CLASS_OTHER: 6,
        OBJECT_CLASS_TEXT: 7,

        // SketchReader constants
        GENTYPE_ABC: 1, // unused
        GENTYPE_AXIS: 2,
        GENTYPE_MID: 3,

        /**
         * @ignore
         * @deprecated, now use {@link JXG.GENTYPE_REFLECTION_ON_LINE}
         *
         */
        GENTYPE_REFLECTION: 4,
        /**
         * @ignore
         * @deprecated, now use {@link JXG.GENTYPE_REFLECTION_ON_POINT}
         */
        GENTYPE_MIRRORELEMENT: 5,

        GENTYPE_REFLECTION_ON_LINE: 4,
        GENTYPE_REFLECTION_ON_POINT: 5,
        GENTYPE_TANGENT: 6,
        GENTYPE_PARALLEL: 7,
        GENTYPE_BISECTORLINES: 8,
        GENTYPE_BOARDIMG: 9,
        GENTYPE_BISECTOR: 10,
        GENTYPE_NORMAL: 11,
        GENTYPE_POINT: 12,
        GENTYPE_GLIDER: 13,
        GENTYPE_INTERSECTION: 14,
        GENTYPE_CIRCLE: 15,
        /**
         * @ignore @deprecated NOT USED ANY MORE SINCE SKETCHOMETRY 2.0 (only for old constructions needed)
         */
        GENTYPE_CIRCLE2POINTS: 16,

        GENTYPE_LINE: 17,
        GENTYPE_TRIANGLE: 18,
        GENTYPE_QUADRILATERAL: 19,
        GENTYPE_TEXT: 20,
        GENTYPE_POLYGON: 21,
        GENTYPE_REGULARPOLYGON: 22,
        GENTYPE_SECTOR: 23,
        GENTYPE_ANGLE: 24,
        GENTYPE_PLOT: 25,
        GENTYPE_SLIDER: 26,
        GENTYPE_TRUNCATE: 27,
        GENTYPE_JCODE: 28,
        GENTYPE_MOVEMENT: 29,
        GENTYPE_COMBINED: 30,
        GENTYPE_RULER: 31,
        GENTYPE_SLOPETRIANGLE: 32,
        GENTYPE_PERPSEGMENT: 33,
        GENTYPE_LABELMOVEMENT: 34,
        GENTYPE_VECTOR: 35,
        GENTYPE_NONREFLEXANGLE: 36,
        GENTYPE_REFLEXANGLE: 37,
        GENTYPE_PATH: 38,
        GENTYPE_DERIVATIVE: 39,
        // 40 // unused ...
        GENTYPE_DELETE: 41,
        GENTYPE_COPY: 42,
        GENTYPE_MIRROR: 43,
        GENTYPE_ROTATE: 44,
        GENTYPE_ABLATION: 45,
        GENTYPE_MIGRATE: 46,
        GENTYPE_VECTORCOPY: 47,
        GENTYPE_POLYGONCOPY: 48,    /**
        * Constants
        * @name Constants
        * @namespace
        */

        //        GENTYPE_TRANSFORM: 48, // unused
        // 49 ... 50 // unused ...

        // IMPORTANT:
        // ----------
        // For being able to differentiate between the (GUI-specific) CTX and
        // (CORE-specific) non-CTX steps, the non-CTX steps MUST NOT be changed
        // to values > 50.

        GENTYPE_CTX_TYPE_G: 51,
        GENTYPE_CTX_TYPE_P: 52,
        GENTYPE_CTX_TRACE: 53,
        GENTYPE_CTX_VISIBILITY: 54,
        GENTYPE_CTX_CCVISIBILITY: 55, // unused
        GENTYPE_CTX_MPVISIBILITY: 56,
        GENTYPE_CTX_WITHLABEL: 57,
        GENTYPE_CTX_LABEL: 58,
        GENTYPE_CTX_FIXED: 59,
        GENTYPE_CTX_STROKEWIDTH: 60,
        GENTYPE_CTX_LABELSIZE: 61,
        GENTYPE_CTX_SIZE: 62,
        GENTYPE_CTX_FACE: 63,
        GENTYPE_CTX_STRAIGHT: 64,
        GENTYPE_CTX_ARROW: 65,
        GENTYPE_CTX_COLOR: 66,
        GENTYPE_CTX_RADIUS: 67,
        GENTYPE_CTX_COORDS: 68,
        GENTYPE_CTX_TEXT: 69,
        GENTYPE_CTX_ANGLERADIUS: 70,
        GENTYPE_CTX_DOTVISIBILITY: 71,
        GENTYPE_CTX_FILLOPACITY: 72,
        GENTYPE_CTX_PLOT: 73,
        GENTYPE_CTX_SCALE: 74,
        GENTYPE_CTX_INTVAL: 75,
        GENTYPE_CTX_POINT1: 76,
        GENTYPE_CTX_POINT2: 77,
        GENTYPE_CTX_LABELSTICKY: 78,
        GENTYPE_CTX_TYPE_I: 79,
        GENTYPE_CTX_HASINNERPOINTS: 80,
        GENTYPE_CTX_SNAPWIDTH: 81,
        GENTYPE_CTX_SNAPTOGRID: 82
    };

    JXG.extendConstants(JXG, constants);

    return constants;
});

/*
    Copyright 2008-2022
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Andreas Walter,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <http://www.gnu.org/licenses/>
    and <http://opensource.org/licenses/MIT/>.
 */

/*global JXG: true, define: true, html_sanitize: true*/
/*jslint nomen: true, plusplus: true*/

/* depends:
 jxg
 base/constants
 */

/**
 * @fileoverview type.js contains several functions to help deal with javascript's weak types.
 * This file mainly consists of detector functions which verify if a variable is or is not of
 * a specific type and converter functions that convert variables to another type or normalize
 * the type of a variable.
 */

define('utils/type',[
    'jxg', 'base/constants'
], function (JXG, Const) {

    'use strict';

    JXG.extend(JXG, /** @lends JXG */ {
        /**
         * Checks if the given string is an id within the given board.
         * @param {JXG.Board} board
         * @param {String} s
         * @returns {Boolean}
         */
        isId: function (board, s) {
            return (typeof s === 'string') && !!board.objects[s];
        },

        /**
         * Checks if the given string is a name within the given board.
         * @param {JXG.Board} board
         * @param {String} s
         * @returns {Boolean}
         */
        isName: function (board, s) {
            return typeof s === 'string' && !!board.elementsByName[s];
        },

        /**
         * Checks if the given string is a group id within the given board.
         * @param {JXG.Board} board
         * @param {String} s
         * @returns {Boolean}
         */
        isGroup: function (board, s) {
            return typeof s === 'string' && !!board.groups[s];
        },

        /**
         * Checks if the value of a given variable is of type string.
         * @param v A variable of any type.
         * @returns {Boolean} True, if v is of type string.
         */
        isString: function (v) {
            return typeof v === 'string';
        },

        /**
         * Checks if the value of a given variable is of type number.
         * @param v A variable of any type.
         * @returns {Boolean} True, if v is of type number.
         */
        isNumber: function (v) {
            return typeof v === 'number' || Object.prototype.toString.call(v) === '[Object Number]';
        },

        /**
         * Checks if a given variable references a function.
         * @param v A variable of any type.
         * @returns {Boolean} True, if v is a function.
         */
        isFunction: function (v) {
            return typeof v === 'function';
        },

        /**
         * Checks if a given variable references an array.
         * @param v A variable of any type.
         * @returns {Boolean} True, if v is of type array.
         */
        isArray: function (v) {
            var r;

            // use the ES5 isArray() method and if that doesn't exist use a fallback.
            if (Array.isArray) {
                r = Array.isArray(v);
            } else {
                r = (v !== null && typeof v === 'object' && typeof v.splice === 'function' && typeof v.join === 'function');
            }

            return r;
        },

        /**
         * Tests if the input variable is an Object
         * @param v
         */
        isObject: function (v) {
            return typeof v === 'object' && !this.isArray(v);
        },

        /**
         * Checks if a given variable is a reference of a JSXGraph Point element.
         * @param v A variable of any type.
         * @returns {Boolean} True, if v is of type JXG.Point.
         */
        isPoint: function (v) {
            if (v !== null && typeof v === 'object') {
                return (v.elementClass === Const.OBJECT_CLASS_POINT);
            }

            return false;
        },

        /**
         * Checks if a given variable is a reference of a JSXGraph Point element or an array of length at least two or
         * a function returning an array of length two or three.
         * @param {JXG.Board} board
         * @param v A variable of any type.
         * @returns {Boolean} True, if v is of type JXG.Point.
         */
        isPointType: function (board, v) {
            var val, p;

            if (this.isArray(v)) {
                return true;
            }
            if (this.isFunction(v)) {
                val = v();
                if (this.isArray(val) && val.length > 1) {
                    return true;
                }
            }
            p = board.select(v);
            return this.isPoint(p);
        },

        /**
         * Checks if a given variable is a reference of a JSXGraph transformation element or an array
         * of JSXGraph transformation elements.
         * @param v A variable of any type.
         * @returns {Boolean} True, if v is of type JXG.Transformation.
         */
        isTransformationOrArray: function (v) {
            if (v !== null) {
                if (this.isArray(v) && v.length > 0) {
                    return this.isTransformationOrArray(v[0]);
                }
                if (typeof v === 'object') {
                    return (v.type === Const.OBJECT_TYPE_TRANSFORMATION);
                }
            }
            return false;
        },

        /**
         * Checks if a given variable is neither undefined nor null. You should not use this together with global
         * variables!
         * @param v A variable of any type.
         * @param {Boolean} [checkEmptyString=false] If set to true, it is also checked whether v is not equal to ''.
         * @returns {Boolean} True, if v is neither undefined nor null.
         */
        exists: function (v, checkEmptyString) {
            /* eslint-disable eqeqeq */
            var result = !(v == undefined || v === null);
            /* eslint-enable eqeqeq */
            checkEmptyString = checkEmptyString || false;

            if (checkEmptyString) {
                return result && v !== '';
            }
            return result;
        },
        // exists: (function (undef) {
        //     return function (v, checkEmptyString) {
        //         var result = !(v === undef || v === null);

        //         checkEmptyString = checkEmptyString || false;

        //         if (checkEmptyString) {
        //             return result && v !== '';
        //         }
        //         return result;
        //     };
        // }()),

        /**
         * Checks if v is an empty object or empty.
         * @param v {Object|Array}
         * @returns {boolean} True, if v is an empty object or array.
         */
        isEmpty: function(v) {
            return Object.keys(v).length === 0;
        },

        /**
         * Handle default parameters.
         * @param v Given value
         * @param d Default value
         * @returns <tt>d</tt>, if <tt>v</tt> is undefined or null.
         */
        def: function (v, d) {
            if (this.exists(v)) {
                return v;
            }

            return d;
        },

        /**
         * Converts a string containing either <strong>true</strong> or <strong>false</strong> into a boolean value.
         * @param {String} s String containing either <strong>true</strong> or <strong>false</strong>.
         * @returns {Boolean} String typed boolean value converted to boolean.
         */
        str2Bool: function (s) {
            if (!this.exists(s)) {
                return true;
            }

            if (typeof s === 'boolean') {
                return s;
            }

            if (this.isString(s)) {
                return (s.toLowerCase() === 'true');
            }

            return false;
        },

        /**
         * Convert a String, a number or a function into a function. This method is used in Transformation.js
         * @param {JXG.Board} board Reference to a JSXGraph board. It is required to resolve dependencies given
         * by a GEONE<sub>X</sub>T string, thus it must be a valid reference only in case one of the param
         * values is of type string.
         * @param {Array} param An array containing strings, numbers, or functions.
         * @param {Number} n Length of <tt>param</tt>.
         * @returns {Function} A function taking one parameter k which specifies the index of the param element
         * to evaluate.
         */
        createEvalFunction: function (board, param, n) {
            var f = [], i;

            for (i = 0; i < n; i++) {
                f[i] = JXG.createFunction(param[i], board, '', true);
            }

            return function (k) {
                return f[k]();
            };
        },

        /**
         * Convert a String, number or function into a function.
         * @param {String|Number|Function} term A variable of type string, function or number.
         * @param {JXG.Board} board Reference to a JSXGraph board. It is required to resolve dependencies given
         * by a GEONE<sub>X</sub>T string, thus it must be a valid reference only in case one of the param
         * values is of type string.
         * @param {String} variableName Only required if evalGeonext is set to true. Describes the variable name
         * of the variable in a GEONE<sub>X</sub>T string given as term.
         * @param {Boolean} [evalGeonext=true] Set this true, if term should be treated as a GEONE<sub>X</sub>T string.
         * @returns {Function} A function evaluation the value given by term or null if term is not of type string,
         * function or number.
         */
        createFunction: function (term, board, variableName, evalGeonext) {
            var f = null;

            if ((!this.exists(evalGeonext) || evalGeonext) && this.isString(term)) {
                // Convert GEONExT syntax into  JavaScript syntax
                //newTerm = JXG.GeonextParser.geonext2JS(term, board);
                //return new Function(variableName,'return ' + newTerm + ';');

                //term = JXG.GeonextParser.replaceNameById(term, board);
                //term = JXG.GeonextParser.geonext2JS(term, board);
                f = board.jc.snippet(term, true, variableName, true);
            } else if (this.isFunction(term)) {
                f = term;
            } else if (this.isNumber(term)) {
                /** @ignore */
                f = function () {
                    return term;
                };
            } else if (this.isString(term)) {
                // In case of string function like fontsize
                /** @ignore */
                f = function () {
                    return term;
                };
            }

            if (f !== null) {
                f.origin = term;
            }

            return f;
        },

        /**
         *  Test if the parents array contains existing points. If instead parents contains coordinate arrays or
         *  function returning coordinate arrays
         *  free points with these coordinates are created.
         *
         * @param {JXG.Board} board Board object
         * @param {Array} parents Array containing parent elements for a new object. This array may contain
         *    <ul>
         *      <li> {@link JXG.Point} objects
         *      <li> {@link JXG.GeometryElement#name} of {@link JXG.Point} objects
         *      <li> {@link JXG.GeometryElement#id} of {@link JXG.Point} objects
         *      <li> Coordinates of points given as array of numbers of length two or three, e.g. [2, 3].
         *      <li> Coordinates of points given as array of functions of length two or three. Each function returns one coordinate, e.g.
         *           [function(){ return 2; }, function(){ return 3; }]
         *      <li> Function returning coordinates, e.g. function() { return [2, 3]; }
         *    </ul>
         *  In the last three cases a new point will be created.
         * @param {String} attrClass Main attribute class of newly created points, see {@link JXG#copyAttributes}
         * @param {Array} attrArray List of subtype attributes for the newly created points. The list of subtypes is mapped to the list of new points.
         * @returns {Array} List of newly created {@link JXG.Point} elements or false if not all returned elements are points.
         */
        providePoints: function (board, parents, attributes, attrClass, attrArray) {
            var i, j,
                len,
                lenAttr = 0,
                points = [], attr, val;

            if (!this.isArray(parents)) {
                parents = [parents];
            }
            len = parents.length;
            if (this.exists(attrArray)) {
                lenAttr = attrArray.length;
            }
            if (lenAttr === 0) {
                attr = this.copyAttributes(attributes, board.options, attrClass);
            }

            for (i = 0; i < len; ++i) {
                if (lenAttr > 0) {
                    j = Math.min(i, lenAttr - 1);
                    attr = this.copyAttributes(attributes, board.options, attrClass, attrArray[j]);
                }
                if (this.isArray(parents[i]) && parents[i].length > 1) {
                    points.push(board.create('point', parents[i], attr));
                    points[points.length - 1]._is_new = true;
                } else if (this.isFunction(parents[i])) {
                    val = parents[i]();
                    if (this.isArray(val) && (val.length > 1)) {
                        points.push(board.create('point', [parents[i]], attr));
                        points[points.length - 1]._is_new = true;
                    }
                } else {
                    points.push(board.select(parents[i]));
                }

                if (!this.isPoint(points[i])) {
                    return false;
                }
            }

            return points;
        },

        /**
         * Generates a function which calls the function fn in the scope of owner.
         * @param {Function} fn Function to call.
         * @param {Object} owner Scope in which fn is executed.
         * @returns {Function} A function with the same signature as fn.
         */
        bind: function (fn, owner) {
            return function () {
                return fn.apply(owner, arguments);
            };
        },

        /**
         * If <tt>val</tt> is a function, it will be evaluated without giving any parameters, else the input value
         * is just returned.
         * @param val Could be anything. Preferably a number or a function.
         * @returns If <tt>val</tt> is a function, it is evaluated and the result is returned. Otherwise <tt>val</tt> is returned.
         */
        evaluate: function (val) {
            if (this.isFunction(val)) {
                return val();
            }

            return val;
        },

        /**
         * Search an array for a given value.
         * @param {Array} array
         * @param value
         * @param {String} [sub] Use this property if the elements of the array are objects.
         * @returns {Number} The index of the first appearance of the given value, or
         * <tt>-1</tt> if the value was not found.
         */
        indexOf: function (array, value, sub) {
            var i, s = this.exists(sub);

            if (Array.indexOf && !s) {
                return array.indexOf(value);
            }

            for (i = 0; i < array.length; i++) {
                if ((s && array[i][sub] === value) || (!s && array[i] === value)) {
                    return i;
                }
            }

            return -1;
        },

        /**
         * Eliminates duplicate entries in an array consisting of numbers and strings.
         * @param {Array} a An array of numbers and/or strings.
         * @returns {Array} The array with duplicate entries eliminated.
         */
        eliminateDuplicates: function (a) {
            var i,
                len = a.length,
                result = [],
                obj = {};

            for (i = 0; i < len; i++) {
                obj[a[i]] = 0;
            }

            for (i in obj) {
                if (obj.hasOwnProperty(i)) {
                    result.push(i);
                }
            }

            return result;
        },

        /**
         * Swaps to array elements.
         * @param {Array} arr
         * @param {Number} i
         * @param {Number} j
         * @returns {Array} Reference to the given array.
         */
        swap: function (arr, i, j) {
            var tmp;

            tmp = arr[i];
            arr[i] = arr[j];
            arr[j] = tmp;

            return arr;
        },

        /**
         * Generates a copy of an array and removes the duplicate entries. The original
         * Array will be altered.
         * @param {Array} arr
         * @returns {Array}
         */
        uniqueArray: function (arr) {
            var i, j, isArray, ret = [];

            if (arr.length === 0) {
                return [];
            }

            for (i = 0; i < arr.length; i++) {
                isArray = this.isArray(arr[i]);

                if (!this.exists(arr[i])) {
                    arr[i] = '';
                    continue;
                }
                for (j = i + 1; j < arr.length; j++) {
                    if (isArray && JXG.cmpArrays(arr[i], arr[j])) {
                        arr[i] = [];
                    } else if (!isArray && arr[i] === arr[j]) {
                        arr[i] = '';
                    }
                }
            }

            j = 0;

            for (i = 0; i < arr.length; i++) {
                isArray = this.isArray(arr[i]);

                if (!isArray && arr[i] !== '') {
                    ret[j] = arr[i];
                    j++;
                } else if (isArray && arr[i].length !== 0) {
                    ret[j] = (arr[i].slice(0));
                    j++;
                }
            }

            arr = ret;
            return ret;
        },

        /**
         * Checks if an array contains an element equal to <tt>val</tt> but does not check the type!
         * @param {Array} arr
         * @param val
         * @returns {Boolean}
         */
        isInArray: function (arr, val) {
            return JXG.indexOf(arr, val) > -1;
        },

        /**
         * Converts an array of {@link JXG.Coords} objects into a coordinate matrix.
         * @param {Array} coords
         * @param {Boolean} split
         * @returns {Array}
         */
        coordsArrayToMatrix: function (coords, split) {
            var i,
                x = [],
                m = [];

            for (i = 0; i < coords.length; i++) {
                if (split) {
                    x.push(coords[i].usrCoords[1]);
                    m.push(coords[i].usrCoords[2]);
                } else {
                    m.push([coords[i].usrCoords[1], coords[i].usrCoords[2]]);
                }
            }

            if (split) {
                m = [x, m];
            }

            return m;
        },

        /**
         * Compare two arrays.
         * @param {Array} a1
         * @param {Array} a2
         * @returns {Boolean} <tt>true</tt>, if the arrays coefficients are of same type and value.
         */
        cmpArrays: function (a1, a2) {
            var i;

            // trivial cases
            if (a1 === a2) {
                return true;
            }

            if (a1.length !== a2.length) {
                return false;
            }

            for (i = 0; i < a1.length; i++) {
                if (this.isArray(a1[i]) && this.isArray(a2[i])) {
                    if (!this.cmpArrays(a1[i], a2[i])) {
                        return false;
                    }
                } else if (a1[i] !== a2[i]) {
                    return false;
                }
            }

            return true;
        },

        /**
         * Removes an element from the given array
         * @param {Array} ar
         * @param el
         * @returns {Array}
         */
        removeElementFromArray: function (ar, el) {
            var i;

            for (i = 0; i < ar.length; i++) {
                if (ar[i] === el) {
                    ar.splice(i, 1);
                    return ar;
                }
            }

            return ar;
        },

        /**
         * Truncate a number <tt>n</tt> after <tt>p</tt> decimals.
         * @param {Number} n
         * @param {Number} p
         * @returns {Number}
         */
        trunc: function (n, p) {
            p = JXG.def(p, 0);

            return this.toFixed(n, p);
        },

        /**
         * Decimal adjustment of a number.
         * From https://developer.mozilla.org/de/docs/Web/JavaScript/Reference/Global_Objects/Math/round
         *
         * @param    {String}    type    The type of adjustment.
         * @param    {Number}    value    The number.
         * @param    {Number}    exp        The exponent (the 10 logarithm of the adjustment base).
         * @returns    {Number}            The adjusted value.
         *
         * @private
         */
        _decimalAdjust: function (type, value, exp) {
            // If the exp is undefined or zero...
            if (exp === undefined || +exp === 0) {
                return Math[type](value);
            }

            value = +value;
            exp = +exp;
            // If the value is not a number or the exp is not an integer...
            if (isNaN(value) || !(typeof exp === 'number' && exp % 1 === 0)) {
                return NaN;
            }

            // Shift
            value = value.toString().split('e');
            value = Math[type](+(value[0] + 'e' + (value[1] ? (+value[1] - exp) : -exp)));

            // Shift back
            value = value.toString().split('e');
            return +(value[0] + 'e' + (value[1] ? (+value[1] + exp) : exp));
        },

        /**
         * Round a number to given number of decimal digits.
         *
         * Example: JXG._toFixed(3.14159, -2) gives 3.14
         * @param  {Number} value Number to be rounded
         * @param  {Number} exp   Number of decimal digits given as negative exponent
         * @return {Number}       Rounded number.
         *
         * @private
         */
        _round10: function (value, exp) {
            return this._decimalAdjust('round', value, exp);
        },

        /**
         * "Floor" a number to given number of decimal digits.
         *
         * Example: JXG._toFixed(3.14159, -2) gives 3.14
         * @param  {Number} value Number to be floored
         * @param  {Number} exp   Number of decimal digits given as negative exponent
         * @return {Number}       "Floored" number.
         *
         * @private
         */
        _floor10: function (value, exp) {
            return this._decimalAdjust('floor', value, exp);
        },

        /**
         * "Ceil" a number to given number of decimal digits.
         *
         * Example: JXG._toFixed(3.14159, -2) gives 3.15
         * @param  {Number} value Number to be ceiled
         * @param  {Number} exp   Number of decimal digits given as negative exponent
         * @return {Number}       "Ceiled" number.
         *
         * @private
         */
        _ceil10: function (value, exp) {
            return this._decimalAdjust('ceil', value, exp);
        },

        /**
         * Replacement of the default toFixed() method.
         * It does a correct rounding (independent of the browser) and
         * returns "0.00" for toFixed(-0.000001, 2) instead of "-0.00" which
         * is returned by JavaScript's toFixed()
         *
         * @memberOf JXG
         * @param  {Number} num    Number tp be rounded
         * @param  {Number} digits Decimal digits
         * @return {String}        Rounded number is returned as string
         */
        toFixed: function (num, digits) {
            return this._round10(num, -digits).toFixed(digits);
        },

        /**
         * Truncate a number <tt>val</tt> automatically.
         * @memberOf JXG
         * @param val
         * @returns {Number}
         */
        autoDigits: function (val) {
            var x = Math.abs(val),
                str;

            if (x > 0.1) {
                str = this.toFixed(val, 2);
            } else if (x >= 0.01) {
                str = this.toFixed(val, 4);
            } else if (x >= 0.0001) {
                str = this.toFixed(val, 6);
            } else {
                str = val;
            }
            return str;
        },

        /**
         * Extracts the keys of a given object.
         * @param object The object the keys are to be extracted
         * @param onlyOwn If true, hasOwnProperty() is used to verify that only keys are collected
         * the object owns itself and not some other object in the prototype chain.
         * @returns {Array} All keys of the given object.
         */
        keys: function (object, onlyOwn) {
            var keys = [], property;

            // the caller decides if we use hasOwnProperty
            /*jslint forin:true*/
            for (property in object) {
                if (onlyOwn) {
                    if (object.hasOwnProperty(property)) {
                        keys.push(property);
                    }
                } else {
                    keys.push(property);
                }
            }
            /*jslint forin:false*/

            return keys;
        },

        /**
         * This outputs an object with a base class reference to the given object. This is useful if
         * you need a copy of an e.g. attributes object and want to overwrite some of the attributes
         * without changing the original object.
         * @param {Object} obj Object to be embedded.
         * @returns {Object} An object with a base class reference to <tt>obj</tt>.
         */
        clone: function (obj) {
            var cObj = {};

            cObj.prototype = obj;

            return cObj;
        },

        /**
         * Embeds an existing object into another one just like {@link #clone} and copies the contents of the second object
         * to the new one. Warning: The copied properties of obj2 are just flat copies.
         * @param {Object} obj Object to be copied.
         * @param {Object} obj2 Object with data that is to be copied to the new one as well.
         * @returns {Object} Copy of given object including some new/overwritten data from obj2.
         */
        cloneAndCopy: function (obj, obj2) {
            var r,
                cObj = function () { return undefined; };

            cObj.prototype = obj;

            // no hasOwnProperty on purpose
            /*jslint forin:true*/
            /*jshint forin:true*/

            for (r in obj2) {
                cObj[r] = obj2[r];
            }

            /*jslint forin:false*/
            /*jshint forin:false*/

            return cObj;
        },

        /**
         * Recursively merges obj2 into obj1. Contrary to {@link JXG#deepCopy} this won't create a new object
         * but instead will overwrite obj1.
         * @param {Object} obj1
         * @param {Object} obj2
         * @returns {Object}
         */
        merge: function (obj1, obj2) {
            var i, j;

            for (i in obj2) {
                if (obj2.hasOwnProperty(i)) {
                    if (this.isArray(obj2[i])) {
                        if (!obj1[i]) {
                            obj1[i] = [];
                        }

                        for (j = 0; j < obj2[i].length; j++) {
                            if (typeof obj2[i][j] === 'object') {
                                obj1[i][j] = this.merge(obj1[i][j], obj2[i][j]);
                            } else {
                                obj1[i][j] = obj2[i][j];
                            }
                        }
                    } else if (typeof obj2[i] === 'object') {
                        if (!obj1[i]) {
                            obj1[i] = {};
                        }

                        obj1[i] = this.merge(obj1[i], obj2[i]);
                    } else {
                        obj1[i] = obj2[i];
                    }
                }
            }

            return obj1;
        },

        /**
         * Creates a deep copy of an existing object, i.e. arrays or sub-objects are copied component resp.
         * element-wise instead of just copying the reference. If a second object is supplied, the two objects
         * are merged into one object. The properties of the second object have priority.
         * @param {Object} obj This object will be copied.
         * @param {Object} obj2 This object will merged into the newly created object
         * @param {Boolean} [toLower=false] If true the keys are convert to lower case. This is needed for visProp, see JXG#copyAttributes
         * @returns {Object} copy of obj or merge of obj and obj2.
         */
        deepCopy: function (obj, obj2, toLower) {
            var c, i, prop, i2;

            toLower = toLower || false;

            if (typeof obj !== 'object' || obj === null) {
                return obj;
            }

            // missing hasOwnProperty is on purpose in this function
            if (this.isArray(obj)) {
                c = [];
                for (i = 0; i < obj.length; i++) {
                    prop = obj[i];
                    if (typeof prop === 'object') {
                        // We certainly do not want to recurse into a JSXGraph object.
                        // This would for sure result in an infinite recursion.
                        // As alternative we copy the id of the object.
                        if (this.exists(prop.board)) {
                            c[i] = prop.id;
                        } else {
                            c[i] = this.deepCopy(prop);
                        }
                    } else {
                        c[i] = prop;
                    }
                }
            } else {
                c = {};
                for (i in obj) {
                    if (obj.hasOwnProperty(i)) {
                        i2 = toLower ? i.toLowerCase() : i;
                        prop = obj[i];
                        if (prop !== null && typeof prop === 'object') {
                            if (this.exists(prop.board)) {
                                c[i2] = prop.id;
                            } else {
                                c[i2] = this.deepCopy(prop);
                            }
                        } else {
                            c[i2] = prop;
                        }
                    }
                }

                for (i in obj2) {
                    if (obj2.hasOwnProperty(i)) {
                        i2 = toLower ? i.toLowerCase() : i;

                        prop = obj2[i];
                        if (typeof prop === 'object') {
                            if (this.isArray(prop) || !this.exists(c[i2])) {
                                c[i2] = this.deepCopy(prop);
                            } else {
                                c[i2] = this.deepCopy(c[i2], prop, toLower);
                            }
                        } else {
                            c[i2] = prop;
                        }
                    }
                }
            }

            return c;
        },

        /**
         * Generates an attributes object that is filled with default values from the Options object
         * and overwritten by the user specified attributes.
         * @param {Object} attributes user specified attributes
         * @param {Object} options defaults options
         * @param {String} s variable number of strings, e.g. 'slider', subtype 'point1'.
         * @returns {Object} The resulting attributes object
         */
        copyAttributes: function (attributes, options, s) {
            var a, i, len, o, isAvail,
                primitives = {
                    'circle': 1,
                    'curve': 1,
                    'image': 1,
                    'line': 1,
                    'point': 1,
                    'polygon': 1,
                    'text': 1,
                    'ticks': 1,
                    'integral': 1
                };

            len = arguments.length;
            if (len < 3 || primitives[s]) {
                // default options from Options.elements
                a = JXG.deepCopy(options.elements, null, true);
            } else {
                a = {};
            }

            // Only the layer of the main element is set.
            if (len < 4 && this.exists(s) && this.exists(options.layer[s])) {
                a.layer = options.layer[s];
            }

            // default options from specific elements
            o = options;
            isAvail = true;
            for (i = 2; i < len; i++) {
                if (this.exists(o[arguments[i]])) {
                    o = o[arguments[i]];
                } else {
                    isAvail = false;
                    break;
                }
            }
            if (isAvail) {
                a = JXG.deepCopy(a, o, true);
            }

            // options from attributes
            o = attributes;
            isAvail = true;
            for (i = 3; i < len; i++) {
                if (this.exists(o[arguments[i]])) {
                    o = o[arguments[i]];
                } else {
                    isAvail = false;
                    break;
                }
            }
            if (isAvail) {
                this.extend(a, o, null, true);
            }

            if (arguments[2] === 'board') {
                // For board attributes we are done now.
                return a;
            }

            // Special treatment of labels
            o = options;
            isAvail = true;
            for (i = 2; i < len; i++) {
                if (this.exists(o[arguments[i]])) {
                    o = o[arguments[i]];
                } else {
                    isAvail = false;
                    break;
                }
            }
            if (isAvail && this.exists(o.label)) {
                a.label = JXG.deepCopy(o.label, a.label);
            }
            a.label = JXG.deepCopy(options.label, a.label);

            return a;
        },

        /**
         * Copy all prototype methods from object "superObject" to object
         * "subObject". The constructor of superObject will be available
         * in subObject as subObject.constructor[constructorName].
         * @param {Object} subObj A JavaScript object which receives new methods.
         * @param {Object} superObj A JavaScript object which lends its prototype methods to subObject
         * @returns {String} constructorName Under this name the constructor of superObj will be available
         * in subObject.
         * @private
         */
        copyPrototypeMethods: function (subObject, superObject, constructorName) {
            var key;

            subObject.prototype[constructorName] = superObject.prototype.constructor;
            for (key in superObject.prototype) {
                if (superObject.prototype.hasOwnProperty(key)) {
                    subObject.prototype[key] = superObject.prototype[key];
                }
            }
        },

        /**
         * Converts a JavaScript object into a JSON string.
         * @param {Object} obj A JavaScript object, functions will be ignored.
         * @param {Boolean} [noquote=false] No quotes around the name of a property.
         * @returns {String} The given object stored in a JSON string.
         */
        toJSON: function (obj, noquote) {
            var list, prop, i, s, val;

            noquote = JXG.def(noquote, false);

            // check for native JSON support:
            if (typeof JSON && JSON.stringify && !noquote) {
                try {
                    s = JSON.stringify(obj);
                    return s;
                } catch (e) {
                    // if something goes wrong, e.g. if obj contains functions we won't return
                    // and use our own implementation as a fallback
                }
            }

            switch (typeof obj) {
                case 'object':
                    if (obj) {
                        list = [];

                        if (this.isArray(obj)) {
                            for (i = 0; i < obj.length; i++) {
                                list.push(JXG.toJSON(obj[i], noquote));
                            }

                            return '[' + list.join(',') + ']';
                        }

                        for (prop in obj) {
                            if (obj.hasOwnProperty(prop)) {
                                try {
                                    val = JXG.toJSON(obj[prop], noquote);
                                } catch (e2) {
                                    val = '';
                                }

                                if (noquote) {
                                    list.push(prop + ':' + val);
                                } else {
                                    list.push('"' + prop + '":' + val);
                                }
                            }
                        }

                        return '{' + list.join(',') + '} ';
                    }
                    return 'null';
                case 'string':
                    return '\'' + obj.replace(/(["'])/g, '\\$1') + '\'';
                case 'number':
                case 'boolean':
                    return obj.toString();
            }

            return '0';
        },

        /**
         * Resets visPropOld.
         * @param {JXG.GeometryElement} el
         * @returns {GeometryElement}
         */
        clearVisPropOld: function (el) {
            el.visPropOld = {
                cssclass: '',
                cssdefaultstyle: '',
                cssstyle: '',
                fillcolor: '',
                fillopacity: '',
                firstarrow: false,
                fontsize: -1,
                lastarrow: false,
                left: -100000,
                linecap: '',
                shadow: false,
                strokecolor: '',
                strokeopacity: '',
                strokewidth: '',
                tabindex: -100000,
                transitionduration: 0,
                top: -100000,
                visible: null
            };

            return el;
        },

        /**
         * Checks if an object contains a key, whose value equals to val.
         * @param {Object} obj
         * @param val
         * @returns {Boolean}
         */
        isInObject: function (obj, val) {
            var el;

            for (el in obj) {
                if (obj.hasOwnProperty(el)) {
                    if (obj[el] === val) {
                        return true;
                    }
                }
            }

            return false;
        },

        /**
         * Replaces all occurences of &amp; by &amp;amp;, &gt; by &amp;gt;, and &lt; by &amp;lt;.
         * @param {String} str
         * @returns {String}
         */
        escapeHTML: function (str) {
            return str.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;');
        },

        /**
         * Eliminates all substrings enclosed by &lt; and &gt; and replaces all occurences of
         * &amp;amp; by &amp;, &amp;gt; by &gt;, and &amp;lt; by &lt;.
         * @param {String} str
         * @returns {String}
         */
        unescapeHTML: function (str) {
            // This regex is NOT insecure. We are replacing everything found with ''
            /*jslint regexp:true*/
            return str.replace(/<\/?[^>]+>/gi, '').replace(/&amp;/g, '&').replace(/&lt;/g, '<').replace(/&gt;/g, '>');
        },

        /**
         * Makes a string lower case except for the first character which will be upper case.
         * @param {String} str Arbitrary string
         * @returns {String} The capitalized string.
         */
        capitalize: function (str) {
            return str.charAt(0).toUpperCase() + str.substring(1).toLowerCase();
        },

        /**
         * Make numbers given as strings nicer by removing all unnecessary leading and trailing zeroes.
         * @param {String} str
         * @returns {String}
         */
        trimNumber: function (str) {
            str = str.replace(/^0+/, '');
            str = str.replace(/0+$/, '');

            if (str[str.length - 1] === '.' || str[str.length - 1] === ',') {
                str = str.slice(0, -1);
            }

            if (str[0] === '.' || str[0] === ',') {
                str = '0' + str;
            }

            return str;
        },

        /**
         * Filter an array of elements.
         * @param {Array} list
         * @param {Object|function} filter
         * @returns {Array}
         */
        filterElements: function (list, filter) {
            var i, f, item, flower, value, visPropValue, pass,
                l = list.length,
                result = [];

            if (typeof filter !== 'function' && typeof filter !== 'object') {
                return result;
            }

            for (i = 0; i < l; i++) {
                pass = true;
                item = list[i];

                if (typeof filter === 'object') {
                    for (f in filter) {
                        if (filter.hasOwnProperty(f)) {
                            flower = f.toLowerCase();

                            if (typeof item[f] === 'function') {
                                value = item[f]();
                            } else {
                                value = item[f];
                            }

                            if (item.visProp && typeof item.visProp[flower] === 'function') {
                                visPropValue = item.visProp[flower]();
                            } else {
                                visPropValue = item.visProp && item.visProp[flower];
                            }

                            if (typeof filter[f] === 'function') {
                                pass = filter[f](value) || filter[f](visPropValue);
                            } else {
                                pass = (value === filter[f] || visPropValue === filter[f]);
                            }

                            if (!pass) {
                                break;
                            }
                        }
                    }
                } else if (typeof filter === 'function') {
                    pass = filter(item);
                }

                if (pass) {
                    result.push(item);
                }
            }

            return result;
        },

        /**
         * Remove all leading and trailing whitespaces from a given string.
         * @param {String} str
         * @returns {String}
         */
        trim: function (str) {
            // str = str.replace(/^\s+/, '');
            // str = str.replace(/\s+$/, '');
            //
            // return str;
            return str.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, '');
        },

        /**
         * Convert HTML tags to entities or use html_sanitize if the google caja html sanitizer is available.
         * @param {String} str
         * @param {Boolean} caja
         * @returns {String} Sanitized string
         */
        sanitizeHTML: function (str, caja) {
            if (typeof html_sanitize === 'function' && caja) {
                return html_sanitize(str, function () { return undefined; }, function (id) { return id; });
            }

            if (str) {
                str = str.replace(/</g, '&lt;').replace(/>/g, '&gt;');
            }

            return str;
        },

        /**
         * If <tt>s</tt> is a slider, it returns the sliders value, otherwise it just returns the given value.
         * @param {*} s
         * @returns {*} s.Value() if s is an element of type slider, s otherwise
         */
        evalSlider: function (s) {
            if (s && s.type === Const.OBJECT_TYPE_GLIDER && typeof s.Value === 'function') {
                return s.Value();
            }

            return s;
        }
    });

    return JXG;
});

/*
    Copyright 2008-2022
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Andreas Walter,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <http://www.gnu.org/licenses/>
    and <http://opensource.org/licenses/MIT/>.
 */

/*global JXG: true, define: true, window: true, document: true, navigator: true, module: true, global: true, self: true, require: true*/
/*jslint nomen: true, plusplus: true*/

/* depends:
 jxg
 utils/type
 */

/**
 * @fileoverview The functions in this file help with the detection of the environment JSXGraph runs in. We can distinguish
 * between node.js, windows 8 app and browser, what rendering techniques are supported and (most of the time) if the device
 * the browser runs on is a tablet/cell or a desktop computer.
 */

define('utils/env',['jxg', 'utils/type'], function (JXG, Type) {

    'use strict';

    JXG.extendConstants(JXG, /** @lends JXG */{
        /**
         * Determines the property that stores the relevant information in the event object.
         * @type String
         * @default 'touches'
         * @private
         */
        touchProperty: 'touches',
    });

    JXG.extend(JXG, /** @lends JXG */ {
        /**
         * Determines whether evt is a touch event.
         * @param evt {Event}
         * @returns {Boolean}
         */
        isTouchEvent: function (evt) {
            return JXG.exists(evt[JXG.touchProperty]);
        },

        /**
         * Determines whether evt is a pointer event.
         * @param evt {Event}
         * @returns {Boolean}
         */
        isPointerEvent: function (evt) {
            return JXG.exists(evt.pointerId);
        },

        /**
         * Determines whether evt is neither a touch event nor a pointer event.
         * @param evt {Event}
         * @returns {Boolean}
         */
        isMouseEvent: function (evt) {
            return !JXG.isTouchEvent(evt)&&!JXG.isPointerEvent(evt);
        },

        /**
         * Determines the number of touch points in a touch event.
         * For other events, -1 is returned.
         * @param evt {Event}
         * @returns {Number}
         */
        getNumberOfTouchPoints: function (evt) {
            var n = -1;

            if (JXG.isTouchEvent(evt)) {
                n = evt[JXG.touchProperty].length;
            }

            return n;
        },

        /**
         * Checks whether an mouse, pointer or touch event evt is the first event of a multitouch event.
         * Attention: When two or more pointer device types are being used concurrently,
         *            it is only checked whether the passed event is the first one of its type!
         * @param evt {Event}
         * @returns {boolean}
         */
        isFirstTouch: function (evt) {
            var touchPoints = JXG.getNumberOfTouchPoints(evt);

            if (JXG.isPointerEvent(evt)) {
                return evt.isPrimary;
            }

            return (touchPoints === 1);
        },

        /**
         * A document/window environment is available.
         * @type Boolean
         * @default false
         */
        isBrowser: typeof window === 'object' && typeof document === 'object',

        /**
         * Features of ECMAScript 6+ are available.
         * @type Boolean
         * @default false
         */
        supportsES6: function () {
            var testMap;
            /* jshint ignore:start */
            try {
                // This would kill the old uglifyjs: testMap = (a = 0) => a;
                new Function('(a = 0) => a');
                return true;
            } catch (err) {
                return false;
            }
            /* jshint ignore:end */
        },

        /**
         * Detect browser support for VML.
         * @returns {Boolean} True, if the browser supports VML.
         */
        supportsVML: function () {
            // From stackoverflow.com
            return this.isBrowser && !!document.namespaces;
        },

        /**
         * Detect browser support for SVG.
         * @returns {Boolean} True, if the browser supports SVG.
         */
        supportsSVG: function () {
            return this.isBrowser && document.implementation.hasFeature('http://www.w3.org/TR/SVG11/feature#BasicStructure', '1.1');
        },

        /**
         * Detect browser support for Canvas.
         * @returns {Boolean} True, if the browser supports HTML canvas.
         */
        supportsCanvas: function () {
            var c, hasCanvas = false;

            if (this.isNode()) {
                try {
                    c = (typeof module === 'object' ? module.require('canvas') : require('canvas'));
                    hasCanvas = !!c;
                } catch (err) {
                }
            }

            return hasCanvas || (this.isBrowser && !!document.createElement('canvas').getContext);
        },

        /**
         * True, if run inside a node.js environment.
         * @returns {Boolean}
         */
        isNode: function () {
            // this is not a 100% sure but should be valid in most cases

            // we are not inside a browser
            return !this.isBrowser && (
                // there is a module object (plain node, no requirejs)
                (typeof module === 'object' && !!module.exports) ||
                // there is a global object and requirejs is loaded
                (typeof global === 'object' && global.requirejsVars && !global.requirejsVars.isBrowser)
            );
        },

        /**
         * True if run inside a webworker environment.
         * @returns {Boolean}
         */
        isWebWorker: function () {
            return !this.isBrowser && (typeof self === 'object' && typeof self.postMessage === 'function');
        },

        /**
         * Checks if the environments supports the W3C Pointer Events API {@link http://www.w3.org/Submission/pointer-events/}
         * @returns {Boolean}
         */
        supportsPointerEvents: function () {
            return !!(this.isBrowser && window.navigator &&
                (window.PointerEvent ||             // Chrome/Edge/IE11+
                    window.navigator.pointerEnabled || // IE11+
                    window.navigator.msPointerEnabled  // IE10-
                )
            );
        },

        /**
         * Determine if the current browser supports touch events
         * @returns {Boolean} True, if the browser supports touch events.
         */
        isTouchDevice: function () {
            return this.isBrowser && window.ontouchstart !== undefined;
        },

        /**
         * Detects if the user is using an Android powered device.
         * @returns {Boolean}
         */
        isAndroid: function () {
            return Type.exists(navigator) && navigator.userAgent.toLowerCase().indexOf('android') > -1;
        },

        /**
         * Detects if the user is using the default Webkit browser on an Android powered device.
         * @returns {Boolean}
         */
        isWebkitAndroid: function () {
            return this.isAndroid() && navigator.userAgent.indexOf(' AppleWebKit/') > -1;
        },

        /**
         * Detects if the user is using a Apple iPad / iPhone.
         * @returns {Boolean}
         */
        isApple: function () {
            return Type.exists(navigator) && (navigator.userAgent.indexOf('iPad') > -1 || navigator.userAgent.indexOf('iPhone') > -1);
        },

        /**
         * Detects if the user is using Safari on an Apple device.
         * @returns {Boolean}
         */
        isWebkitApple: function () {
            return this.isApple() && (navigator.userAgent.search(/Mobile\/[0-9A-Za-z.]*Safari/) > -1);
        },

        /**
         * Returns true if the run inside a Windows 8 "Metro" App.
         * @returns {Boolean}
         */
        isMetroApp: function () {
            return typeof window === 'object' && window.clientInformation && window.clientInformation.appVersion && window.clientInformation.appVersion.indexOf('MSAppHost') > -1;
        },

        /**
         * Detects if the user is using a Mozilla browser
         * @returns {Boolean}
         */
        isMozilla: function () {
            return Type.exists(navigator) &&
                navigator.userAgent.toLowerCase().indexOf('mozilla') > -1 &&
                navigator.userAgent.toLowerCase().indexOf('apple') === -1;
        },

        /**
         * Detects if the user is using a firefoxOS powered device.
         * @returns {Boolean}
         */
        isFirefoxOS: function () {
            return Type.exists(navigator) &&
                navigator.userAgent.toLowerCase().indexOf('android') === -1 &&
                navigator.userAgent.toLowerCase().indexOf('apple') === -1 &&
                navigator.userAgent.toLowerCase().indexOf('mobile') > -1 &&
                navigator.userAgent.toLowerCase().indexOf('mozilla') > -1;
        },

        /**
         * Internet Explorer version. Works only for IE > 4.
         * @type Number
         */
        ieVersion: (function () {
            var div, all,
                v = 3;

            if (typeof document !== 'object') {
                return 0;
            }

            div = document.createElement('div');
            all = div.getElementsByTagName('i');

            do {
                div.innerHTML = '<!--[if gt IE ' + (++v) + ']><' + 'i><' + '/i><![endif]-->';
            } while (all[0]);

            return v > 4 ? v : undefined;

        }()),

        /**
         * Reads the width and height of an HTML element.
         * @param {String} elementId The HTML id of an HTML DOM node.
         * @returns {Object} An object with the two properties width and height.
         */
        getDimensions: function (elementId, doc) {
            var element, display, els, originalVisibility, originalPosition,
                originalDisplay, originalWidth, originalHeight, style,
                pixelDimRegExp = /\d+(\.\d*)?px/;

            if (!this.isBrowser || elementId === null) {
                return {
                    width: 500,
                    height: 500
                };
            }

            doc = doc || document;
            // Borrowed from prototype.js
            element = doc.getElementById(elementId);
            if (!Type.exists(element)) {
                throw new Error('\nJSXGraph: HTML container element \'' + elementId + '\' not found.');
            }

            display = element.style.display;

            // Work around a bug in Safari
            if (display !== 'none' && display !== null) {
                if (element.clientWidth > 0 && element.clientHeight > 0) {
                    return {width: element.clientWidth, height: element.clientHeight};
                }

                // a parent might be set to display:none; try reading them from styles
                style = window.getComputedStyle ? window.getComputedStyle(element) : element.style;
                return {
                    width: pixelDimRegExp.test(style.width) ? parseFloat(style.width) : 0,
                    height: pixelDimRegExp.test(style.height) ? parseFloat(style.height) : 0
                };
            }

            // All *Width and *Height properties give 0 on elements with display set to none,
            // hence we show the element temporarily
            els = element.style;

            // save style
            originalVisibility = els.visibility;
            originalPosition = els.position;
            originalDisplay = els.display;

            // show element
            els.visibility = 'hidden';
            els.position = 'absolute';
            els.display = 'block';

            // read the dimension
            originalWidth = element.clientWidth;
            originalHeight = element.clientHeight;

            // restore original css values
            els.display = originalDisplay;
            els.position = originalPosition;
            els.visibility = originalVisibility;

            return {
                width: originalWidth,
                height: originalHeight
            };
        },

        /**
         * Adds an event listener to a DOM element.
         * @param {Object} obj Reference to a DOM node.
         * @param {String} type The event to catch, without leading 'on', e.g. 'mousemove' instead of 'onmousemove'.
         * @param {Function} fn The function to call when the event is triggered.
         * @param {Object} owner The scope in which the event trigger is called.
         */
        addEvent: function (obj, type, fn, owner) {
            var el = function () {
                return fn.apply(owner, arguments);
            };

            el.origin = fn;
            owner['x_internal' + type] = owner['x_internal' + type] || [];
            owner['x_internal' + type].push(el);

            // Non-IE browser
            if (Type.exists(obj) && Type.exists(obj.addEventListener)) {
                obj.addEventListener(type, el, false);
            }

            // IE
            if (Type.exists(obj) && Type.exists(obj.attachEvent)) {
                obj.attachEvent('on' + type, el);
            }
        },

        /**
         * Removes an event listener from a DOM element.
         * @param {Object} obj Reference to a DOM node.
         * @param {String} type The event to catch, without leading 'on', e.g. 'mousemove' instead of 'onmousemove'.
         * @param {Function} fn The function to call when the event is triggered.
         * @param {Object} owner The scope in which the event trigger is called.
         */
        removeEvent: function (obj, type, fn, owner) {
            var i;

            if (!Type.exists(owner)) {
                JXG.debug('no such owner');
                return;
            }

            if (!Type.exists(owner['x_internal' + type])) {
                JXG.debug('no such type: ' + type);
                return;
            }

            if (!Type.isArray(owner['x_internal' + type])) {
                JXG.debug('owner[x_internal + ' + type + '] is not an array');
                return;
            }

            i = Type.indexOf(owner['x_internal' + type], fn, 'origin');

            if (i === -1) {
                JXG.debug('removeEvent: no such event function in internal list: ' + fn);
                return;
            }

            try {
                // Non-IE browser
                if (Type.exists(obj) && Type.exists(obj.removeEventListener)) {
                    obj.removeEventListener(type, owner['x_internal' + type][i], false);
                }

                // IE
                if (Type.exists(obj) && Type.exists(obj.detachEvent)) {
                    obj.detachEvent('on' + type, owner['x_internal' + type][i]);
                }
            } catch (e) {
                JXG.debug('event not registered in browser: (' + type + ' -- ' + fn + ')');
            }

            owner['x_internal' + type].splice(i, 1);
        },

        /**
         * Removes all events of the given type from a given DOM node; Use with caution and do not use it on a container div
         * of a {@link JXG.Board} because this might corrupt the event handling system.
         * @param {Object} obj Reference to a DOM node.
         * @param {String} type The event to catch, without leading 'on', e.g. 'mousemove' instead of 'onmousemove'.
         * @param {Object} owner The scope in which the event trigger is called.
         */
        removeAllEvents: function (obj, type, owner) {
            var i, len;
            if (owner['x_internal' + type]) {
                len = owner['x_internal' + type].length;

                for (i = len - 1; i >= 0; i--) {
                    JXG.removeEvent(obj, type, owner['x_internal' + type][i].origin, owner);
                }

                if (owner['x_internal' + type].length > 0) {
                    JXG.debug('removeAllEvents: Not all events could be removed.');
                }
            }
        },

        /**
         * Cross browser mouse / touch coordinates retrieval relative to the board's top left corner.
         * @param {Object} [e] The browsers event object. If omitted, <tt>window.event</tt> will be used.
         * @param {Number} [index] If <tt>e</tt> is a touch event, this provides the index of the touch coordinates, i.e. it determines which finger.
         * @param {Object} [doc] The document object.
         * @returns {Array} Contains the position as x,y-coordinates in the first resp. second component.
         */
        getPosition: function (e, index, doc) {
            var i, len, evtTouches,
                posx = 0,
                posy = 0;

            if (!e) {
                e = window.event;
            }

            doc = doc || document;
            evtTouches = e[JXG.touchProperty];

            // touchend events have their position in "changedTouches"
            if (Type.exists(evtTouches) && evtTouches.length === 0) {
                evtTouches = e.changedTouches;
            }

            if (Type.exists(index) && Type.exists(evtTouches)) {
                if (index === -1) {
                    len = evtTouches.length;

                    for (i = 0; i < len; i++) {
                        if (evtTouches[i]) {
                            e = evtTouches[i];
                            break;
                        }
                    }

                } else {
                    e = evtTouches[index];
                }
            }

            // Scrolling is ignored.
            // e.clientX is supported since IE6
            if (e.clientX) {
                posx = e.clientX;
                posy = e.clientY;
            }

            return [posx, posy];
        },

        /**
         * Calculates recursively the offset of the DOM element in which the board is stored.
         * @param {Object} obj A DOM element
         * @returns {Array} An array with the elements left and top offset.
         */
        getOffset: function (obj) {
            var cPos,
                o = obj,
                o2 = obj,
                l = o.offsetLeft - o.scrollLeft,
                t = o.offsetTop - o.scrollTop;

            cPos = this.getCSSTransform([l, t], o);
            l = cPos[0];
            t = cPos[1];

            /*
             * In Mozilla and Webkit: offsetParent seems to jump at least to the next iframe,
             * if not to the body. In IE and if we are in an position:absolute environment
             * offsetParent walks up the DOM hierarchy.
             * In order to walk up the DOM hierarchy also in Mozilla and Webkit
             * we need the parentNode steps.
             */
            o = o.offsetParent;
            while (o) {
                l += o.offsetLeft;
                t += o.offsetTop;

                if (o.offsetParent) {
                    l += o.clientLeft - o.scrollLeft;
                    t += o.clientTop - o.scrollTop;
                }

                cPos = this.getCSSTransform([l, t], o);
                l = cPos[0];
                t = cPos[1];

                o2 = o2.parentNode;

                while (o2 !== o) {
                    l += o2.clientLeft - o2.scrollLeft;
                    t += o2.clientTop - o2.scrollTop;

                    cPos = this.getCSSTransform([l, t], o2);
                    l = cPos[0];
                    t = cPos[1];

                    o2 = o2.parentNode;
                }
                o = o.offsetParent;
            }

            return [l, t];
        },

        /**
         * Access CSS style sheets.
         * @param {Object} obj A DOM element
         * @param {String} stylename The CSS property to read.
         * @returns The value of the CSS property and <tt>undefined</tt> if it is not set.
         */
        getStyle: function (obj, stylename) {
            var r,
                doc = obj.ownerDocument;

            // Non-IE
            if (doc.defaultView && doc.defaultView.getComputedStyle) {
                r = doc.defaultView.getComputedStyle(obj, null).getPropertyValue(stylename);
                // IE
            } else if (obj.currentStyle && JXG.ieVersion >= 9) {
                r = obj.currentStyle[stylename];
            } else {
                if (obj.style) {
                    // make stylename lower camelcase
                    stylename = stylename.replace(/-([a-z]|[0-9])/ig, function (all, letter) {
                        return letter.toUpperCase();
                    });
                    r = obj.style[stylename];
                }
            }

            return r;
        },

        /**
         * Reads css style sheets of a given element. This method is a getStyle wrapper and
         * defaults the read value to <tt>0</tt> if it can't be parsed as an integer value.
         * @param {DOMElement} el
         * @param {string} css
         * @returns {number}
         */
        getProp: function (el, css) {
            var n = parseInt(this.getStyle(el, css), 10);
            return isNaN(n) ? 0 : n;
        },

        /**
         * Correct position of upper left corner in case of
         * a CSS transformation. Here, only translations are
         * extracted. All scaling transformations are corrected
         * in {@link JXG.Board#getMousePosition}.
         * @param {Array} cPos Previously determined position
         * @param {Object} obj A DOM element
         * @returns {Array} The corrected position.
         */
        getCSSTransform: function (cPos, obj) {
            var i, j, str, arrStr, start, len, len2, arr,
                t = ['transform', 'webkitTransform', 'MozTransform', 'msTransform', 'oTransform'];

            // Take the first transformation matrix
            len = t.length;

            for (i = 0, str = ''; i < len; i++) {
                if (Type.exists(obj.style[t[i]])) {
                    str = obj.style[t[i]];
                    break;
                }
            }

            /**
             * Extract the coordinates and apply the transformation
             * to cPos
             */
            if (str !== '') {
                start = str.indexOf('(');

                if (start > 0) {
                    len = str.length;
                    arrStr = str.substring(start + 1, len - 1);
                    arr = arrStr.split(',');

                    for (j = 0, len2 = arr.length; j < len2; j++) {
                        arr[j] = parseFloat(arr[j]);
                    }

                    if (str.indexOf('matrix') === 0) {
                        cPos[0] += arr[4];
                        cPos[1] += arr[5];
                    } else if (str.indexOf('translateX') === 0) {
                        cPos[0] += arr[0];
                    } else if (str.indexOf('translateY') === 0) {
                        cPos[1] += arr[0];
                    } else if (str.indexOf('translate') === 0) {
                        cPos[0] += arr[0];
                        cPos[1] += arr[1];
                    }
                }
            }

            // Zoom is used by reveal.js
            if (Type.exists(obj.style.zoom)) {
                str = obj.style.zoom;
                if (str !== '') {
                    cPos[0] *= parseFloat(str);
                    cPos[1] *= parseFloat(str);
                }
            }

            return cPos;
        },

        /**
         * Scaling CSS transformations applied to the div element containing the JSXGraph constructions
         * are determined. In IE prior to 9, 'rotate', 'skew', 'skewX', 'skewY' are not supported.
         * @returns {Array} 3x3 transformation matrix without translation part. See {@link JXG.Board#updateCSSTransforms}.
         */
        getCSSTransformMatrix: function (obj) {
            var i, j, str, arrstr, start, len, len2, arr,
                st,
                doc = obj.ownerDocument,
                t = ['transform', 'webkitTransform', 'MozTransform', 'msTransform', 'oTransform'],
                mat = [[1, 0, 0],
                    [0, 1, 0],
                    [0, 0, 1]];

            // This should work on all browsers except IE 6-8
            if (doc.defaultView && doc.defaultView.getComputedStyle) {
                st = doc.defaultView.getComputedStyle(obj, null);
                str = st.getPropertyValue('-webkit-transform') ||
                    st.getPropertyValue('-moz-transform') ||
                    st.getPropertyValue('-ms-transform') ||
                    st.getPropertyValue('-o-transform') ||
                    st.getPropertyValue('transform');
            } else {
                // Take the first transformation matrix
                len = t.length;
                for (i = 0, str = ''; i < len; i++) {
                    if (Type.exists(obj.style[t[i]])) {
                        str = obj.style[t[i]];
                        break;
                    }
                }
            }

            if (str !== '') {
                start = str.indexOf('(');

                if (start > 0) {
                    len = str.length;
                    arrstr = str.substring(start + 1, len - 1);
                    arr = arrstr.split(',');

                    for (j = 0, len2 = arr.length; j < len2; j++) {
                        arr[j] = parseFloat(arr[j]);
                    }

                    if (str.indexOf('matrix') === 0) {
                        mat = [[1, 0, 0],
                            [0, arr[0], arr[1]],
                            [0, arr[2], arr[3]]];
                    } else if (str.indexOf('scaleX') === 0) {
                        mat[1][1] = arr[0];
                    } else if (str.indexOf('scaleY') === 0) {
                        mat[2][2] = arr[0];
                    } else if (str.indexOf('scale') === 0) {
                        mat[1][1] = arr[0];
                        mat[2][2] = arr[1];
                    }
                }
            }

            // CSS style zoom is used by reveal.js
            // Recursively search for zoom style entries.
            // This is necessary for reveal.js on webkit.
            // It fails if the user does zooming
            if (Type.exists(obj.style.zoom)) {
                str = obj.style.zoom;
                if (str !== '') {
                    mat[1][1] *= parseFloat(str);
                    mat[2][2] *= parseFloat(str);
                }
            }

            return mat;
        },

        /**
         * Process data in timed chunks. Data which takes long to process, either because it is such
         * a huge amount of data or the processing takes some time, causes warnings in browsers about
         * irresponsive scripts. To prevent these warnings, the processing is split into smaller pieces
         * called chunks which will be processed in serial order.
         * Copyright 2009 Nicholas C. Zakas. All rights reserved. MIT Licensed
         * @param {Array} items to do
         * @param {Function} process Function that is applied for every array item
         * @param {Object} context The scope of function process
         * @param {Function} callback This function is called after the last array element has been processed.
         */
        timedChunk: function (items, process, context, callback) {
            //create a clone of the original
            var todo = items.concat(),
                timerFun = function () {
                    var start = +new Date();

                    do {
                        process.call(context, todo.shift());
                    } while (todo.length > 0 && (+new Date() - start < 300));

                    if (todo.length > 0) {
                        window.setTimeout(timerFun, 1);
                    } else {
                        callback(items);
                    }
                };

            window.setTimeout(timerFun, 1);
        },

        /**
         * Calculate the scale factor and vertical shift for the JSXGraph div
         * in full screen mode.
         *
         * @param {Object} obj Reference to a DOM node.
         * @returns Object {scale: number, vshift: number}
         * @see JXG.Board#fullscreenListener
         * @private
         */
        _getScaleFactors: function (node) {
            var width = node.getBoundingClientRect().width,
                height = node.getBoundingClientRect().height,

                // Determine the maximum scale factor.
                r_w = window.screen.width / width,
                r_h = window.screen.height / height,

                // Determine the vertical shift to place the div in the center of the screen
                vshift = (window.screen.height - height) * 0.5,

                // Scaling factor: if not supplied, it's taken as large as possible
                scale = Math.min(r_w, r_h);

            // Adapt vshift and scale for landscape on tablets
            if (window.matchMedia && window.matchMedia('(orientation:landscape)').matches &&
                window.screen.width < window.screen.height) {
                // Landscape on iOS: it returns 'landscape', but still width < height.
                r_w = window.screen.height / width;
                r_h = window.screen.width / height;
                scale = Math.min(r_w, r_h);
                vshift = (window.screen.width - height) * 0.5;
            }
            scale *= 0.85;

            return { scale: scale, vshift: vshift, width: width };
        },

        /**
         * Scale and vertically shift a DOM element (usually a JSXGraph div)
         * inside of a parent DOM
         * element which is set to fullscreen.
         * This is realized with a CSS transformation.
         *          *
         * @param  {String} wrap_id  id of the parent DOM element which is in fullscreen mode
         * @param  {String} inner_id id of the DOM element which is scaled and shifted
         * @param  {Number} scale    Scaling factor
         * @param  {Number} vshift   Vertical shift (in pixel)
         *
         * @private
         * @see JXG.Board#toFullscreen
         * @see JXG.Board#fullscreenListener
         *
         */
        scaleJSXGraphDiv: function (wrap_id, inner_id, scale, vshift) {
            var len = document.styleSheets.length, style,

                pseudo_keys = [':fullscreen', ':-webkit-full-screen', ':-moz-full-screen', ':-ms-fullscreen'],
                len_pseudo = pseudo_keys.length, i,

                // CSS rules to center the inner div horizontally and vertically.
                rule_inner = '{margin:0 auto;transform:matrix(' + scale + ',0,0,' + scale + ',0,' + vshift + ');}',

                // A previously installed CSS rule to center the JSXGraph div has to
                // be searched and removed again.
                regex = new RegExp('.*#' + wrap_id + ':.*full.*screen.*#' + inner_id + '.*auto;.*transform:.*matrix');

            if (len === 0) {
                // In case there is not a single CSS rule defined at all.
                style = document.createElement('style');
                // WebKit hack :(
                style.appendChild(document.createTextNode(''));
                // Add the <style> element to the page
                document.body.appendChild(style);
                len = document.styleSheets.length;
            }

            // Remove a previously installed CSS rule.
            if (document.styleSheets[len - 1].cssRules.length > 0 &&
                regex.test(document.styleSheets[len - 1].cssRules[0].cssText) &&
                document.styleSheets[len - 1].deleteRule) {

                document.styleSheets[len - 1].deleteRule(0);
            }

            // Install a CSS rule to center the JSXGraph div at the first position of the list.
            for (i = 0; i < len_pseudo; i++) {
                try {
                    document.styleSheets[len - 1].insertRule('#' + wrap_id + pseudo_keys[i] + ' #' + inner_id + rule_inner, 0);
                    break;
                } catch (err) {
                    // console.log('JXG.scaleJSXGraphDiv: Could not add CSS rule "' + pseudo_keys[i] + '".');
                    // console.log('One possible reason could be that the id of the JSXGraph container does not start with a letter.');
                }
            }
            if (i === len_pseudo) {
                console.log('JXG.scaleJSXGraphDiv: Could not add any CSS rule.');
                console.log('One possible reason could be that the id of the JSXGraph container does not start with a letter.');
            }
        }
    });

    return JXG;
});

/*
 Copyright 2008-2022
 Matthias Ehmann,
 Michael Gerhaeuser,
 Carsten Miller,
 Bianca Valentin,
 Alfred Wassermann,
 Peter Wilfahrt

 This file is part of JSXGraph.

 JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

 You can redistribute it and/or modify it under the terms of the

 * GNU Lesser General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version
 OR
 * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

 JSXGraph is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public License and
 the MIT License along with JSXGraph. If not, see <http://www.gnu.org/licenses/>
 and <http://opensource.org/licenses/MIT/>.
 */


/*global JXG: true, define: true, DOMParser: true, ActiveXObject: true*/
/*jslint nomen: true, plusplus: true*/

/* depends:
 jxg
 utils/type
 */

define('utils/xml',['jxg', 'utils/type'], function (JXG, Type) {

    "use strict";

    /**
     * Holds browser independent xml parsing routines. Won't work in environments other than browsers.
     * @namespace
     */
    JXG.XML = {
        /**
         * Cleans out unneccessary whitespaces in a chunk of xml.
         * @param {Object} el
         */
        cleanWhitespace: function (el) {
            var cur = el.firstChild;

            while (Type.exists(cur)) {
                if (cur.nodeType === 3 && !/\S/.test(cur.nodeValue)) {
                    el.removeChild(cur);
                } else if (cur.nodeType === 1) {
                    this.cleanWhitespace(cur);
                }
                cur = cur.nextSibling;
            }
        },

        /**
         * Converts a given string into a XML tree.
         * @param {String} str
         * @returns {Object} The xml tree represented by the root node.
         */
        parse: function (str) {
            var parser, tree, DP;

            // DOMParser is a function in all browsers, except older IE and Safari.
            // In IE it does not exists (workaround in else branch), in Safari it's an object.
            if (typeof DOMParser === 'function' || typeof DOMParser === 'object') {
                DP = DOMParser;
            } else {
                // IE workaround, since there is no DOMParser
                DP = function () {
                    this.parseFromString = function (str) {
                        var d;

                        if (typeof ActiveXObject === 'function') {
                            d = new ActiveXObject('MSXML.DomDocument');
                            d.loadXML(str);
                        }

                        return d;
                    };
                };
            }

            parser = new DP();
            tree = parser.parseFromString(str, 'text/xml');
            this.cleanWhitespace(tree);

            return tree;
        }
    };

    return JXG.XML;
});
/*
    Copyright 2008-2022
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <http://www.gnu.org/licenses/>
    and <http://opensource.org/licenses/MIT/>.
 */


/*global JXG: true, define: true*/
/*jslint nomen: true, plusplus: true*/

/* depends:
 jxg
 utils/type
 */

/**
 * @fileoverview In this file the EventEmitter interface is defined.
 */

define('utils/event',['jxg', 'utils/type'], function (JXG, Type) {

    "use strict";

    /**
     * Event namespace
     * @namespace
     */
    JXG.EventEmitter = {
        /**
         * Holds the registered event handlers.
         * @type Object
         */
        eventHandlers: {},

        /**
         * Events can be suspended to prevent endless loops.
         * @type Object
         */
        suspended: {},

        /**
         * Triggers all event handlers of this element for a given event.
         * @param {Array} event
         * @param {Array} args The arguments passed onto the event handler
         * @returns Reference to the object.
         */
        trigger: function (event, args) {
            var i, j, h, evt, len1, len2;

            len1 = event.length;
            for (j = 0; j < len1; j++) {
                evt = this.eventHandlers[event[j]];

                if (!this.suspended[event[j]]) {
                    this.suspended[event[j]] = true;

                    if (evt) {
                        len2 = evt.length;

                        for (i = 0; i < len2; i++) {
                            h = evt[i];
                            h.handler.apply(h.context, args);
                        }
                    }

                    this.suspended[event[j]] = false;
                }
            }

            return this;
        },

        /**
         * Register a new event handler. For a list of possible events see documentation
         * of the elements and objects implementing
         * the {@link EventEmitter} interface.
         * @param {String} event
         * @param {Function} handler
         * @param {Object} [context] The context the handler will be called in, default is the element itself.
         * @returns Reference to the object.
         */
        on: function (event, handler, context) {
            if (!Type.isArray(this.eventHandlers[event])) {
                this.eventHandlers[event] = [];
            }

            context = Type.def(context, this);

            this.eventHandlers[event].push({
                handler: handler,
                context: context
            });

            return this;
        },

        /**
         * Unregister an event handler.
         * @param {String} event
         * @param {Function} [handler]
         * @returns Reference to the object.
         */
        off: function (event, handler) {
            var i;

            if (!event || !Type.isArray(this.eventHandlers[event])) {
                return this;
            }

            if (handler) {
                i = Type.indexOf(this.eventHandlers[event], handler, 'handler');
                if (i > -1) {
                    this.eventHandlers[event].splice(i, 1);
                }

                if (this.eventHandlers[event].length === 0) {
                    delete this.eventHandlers[event];
                }
            } else {
                delete this.eventHandlers[event];
            }

            return this;
        },

        /**
         * @description Implements the functionality from this interface in the given object.
         * All objects getting their event handling
         * capabilities from this method should document it by adding
         * the <tt>on, off, triggerEventHandlers</tt> via the
         * borrows tag as methods to their documentation:
         * <pre>@borrows JXG.EventEmitter#on as this.on</pre>
         * @param {Object} o
         */
        eventify: function (o) {
            o.eventHandlers = {};
            o.on = this.on;
            o.off = this.off;
            o.triggerEventHandlers = this.trigger;
            o.trigger = this.trigger;
            o.suspended = {};
        }
    };

    return JXG.EventEmitter;
});

/*
    Copyright 2008-2022
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <http://www.gnu.org/licenses/>
    and <http://opensource.org/licenses/MIT/>.
 */


/*global JXG: true, define: true, Float32Array: true */
/*jslint nomen: true, plusplus: true, bitwise: true*/

/* depends:
 jxg
 */

/**
 * @fileoverview In this file the namespace JXG.Math is defined, which is the base namespace
 * for namespaces like Math.Numerics, Math.Algebra, Math.Statistics etc.
 */

define('math/math',['jxg', 'utils/type'], function (JXG, Type) {

    "use strict";

    var undef,

        /*
         * Dynamic programming approach for recursive functions.
         * From "Speed up your JavaScript, Part 3" by Nicholas C. Zakas.
         * @see JXG.Math.factorial
         * @see JXG.Math.binomial
         * http://blog.thejit.org/2008/09/05/memoization-in-javascript/
         *
         * This method is hidden, because it is only used in JXG.Math. If someone wants
         * to use it in JSXGraph outside of JXG.Math, it should be moved to jsxgraph.js
         */
        memoizer = function (f) {
            var cache, join;

            if (f.memo) {
                return f.memo;
            }

            cache = {};
            join = Array.prototype.join;

            f.memo = function () {
                var key = join.call(arguments);

                // Seems to be a bit faster than "if (a in b)"
                return (cache[key] !== undef) ?
                        cache[key] :
                        cache[key] = f.apply(this, arguments);
            };

            return f.memo;
        };

    /**
     * Math namespace.
     * @namespace
     */
    JXG.Math = {
        /**
         * eps defines the closeness to zero. If the absolute value of a given number is smaller
         * than eps, it is considered to be equal to zero.
         * @type Number
         */
        eps: 0.000001,

        /**
         * Determine the relative difference between two numbers.
         * @param  {Number} a First number
         * @param  {Number} b Second number
         * @returns {Number}  Relative difference between a and b: |a-b| / max(|a|, |b|)
         */
        relDif: function(a, b) {
            var c = Math.abs(a),
                d = Math.abs(b);

            d = Math.max(c, d);

            return (d === 0.0) ? 0.0 : Math.abs(a - b) / d;
        },

        /**
         * The JavaScript implementation of the % operator returns the symmetric modulo.
         * mod and "%" are both identical if a >= 0 and m >= 0 but the results differ if a or m < 0.
         * @param {Number} a
         * @param {Number} m
         * @returns {Number} Mathematical modulo <tt>a mod m</tt>
         */
        mod: function (a, m) {
            return a - Math.floor(a / m) * m;
        },

        /**
         * Initializes a vector as an array with the coefficients set to the given value resp. zero.
         * @param {Number} n Length of the vector
         * @param {Number} [init=0] Initial value for each coefficient
         * @returns {Array} A <tt>n</tt> times <tt>m</tt>-matrix represented by a
         * two-dimensional array. The inner arrays hold the columns, the outer array holds the rows.
         */
        vector: function (n, init) {
            var r, i;

            init = init || 0;
            r = [];

            for (i = 0; i < n; i++) {
                r[i] = init;
            }

            return r;
        },

        /**
         * Initializes a matrix as an array of rows with the given value.
         * @param {Number} n Number of rows
         * @param {Number} [m=n] Number of columns
         * @param {Number} [init=0] Initial value for each coefficient
         * @returns {Array} A <tt>n</tt> times <tt>m</tt>-matrix represented by a
         * two-dimensional array. The inner arrays hold the columns, the outer array holds the rows.
         */
        matrix: function (n, m, init) {
            var r, i, j;

            init = init || 0;
            m = m || n;
            r = [];

            for (i = 0; i < n; i++) {
                r[i] = [];

                for (j = 0; j < m; j++) {
                    r[i][j] = init;
                }
            }

            return r;
        },

        /**
         * Generates an identity matrix. If n is a number and m is undefined or not a number, a square matrix is generated,
         * if n and m are both numbers, an nxm matrix is generated.
         * @param {Number} n Number of rows
         * @param {Number} [m=n] Number of columns
         * @returns {Array} A square matrix of length <tt>n</tt> with all coefficients equal to 0 except a_(i,i), i out of (1, ..., n), if <tt>m</tt> is undefined or not a number
         * or a <tt>n</tt> times <tt>m</tt>-matrix with a_(i,j) = 0 and a_(i,i) = 1 if m is a number.
         */
        identity: function (n, m) {
            var r, i;

            if ((m === undef) && (typeof m !== 'number')) {
                m = n;
            }

            r = this.matrix(n, m);

            for (i = 0; i < Math.min(n, m); i++) {
                r[i][i] = 1;
            }

            return r;
        },

        /**
         * Generates a 4x4 matrix for 3D to 2D projections.
         * @param {Number} l Left
         * @param {Number} r Right
         * @param {Number} t Top
         * @param {Number} b Bottom
         * @param {Number} n Near
         * @param {Number} f Far
         * @returns {Array} 4x4 Matrix
         */
        frustum: function (l, r, b, t, n, f) {
            var ret = this.matrix(4, 4);

            ret[0][0] = (n * 2) / (r - l);
            ret[0][1] = 0;
            ret[0][2] = (r + l) / (r - l);
            ret[0][3] = 0;

            ret[1][0] = 0;
            ret[1][1] = (n * 2) / (t - b);
            ret[1][2] = (t + b) / (t - b);
            ret[1][3] = 0;

            ret[2][0] = 0;
            ret[2][1] = 0;
            ret[2][2] = -(f + n) / (f - n);
            ret[2][3] = -(f * n * 2) / (f - n);

            ret[3][0] = 0;
            ret[3][1] = 0;
            ret[3][2] = -1;
            ret[3][3] = 0;

            return ret;
        },

        /**
         * Generates a 4x4 matrix for 3D to 2D projections.
         * @param {Number} fov Field of view in vertical direction, given in rad.
         * @param {Number} ratio Aspect ratio of the projection plane.
         * @param {Number} n Near
         * @param {Number} f Far
         * @returns {Array} 4x4 Projection Matrix
         */
        projection: function (fov, ratio, n, f) {
            var t = n * Math.tan(fov / 2),
                r = t * ratio;

            return this.frustum(-r, r, -t, t, n, f);
        },

        /**
         * Multiplies a vector vec to a matrix mat: mat * vec. The matrix is interpreted by this function as an array of rows. Please note: This
         * function does not check if the dimensions match.
         * @param {Array} mat Two dimensional array of numbers. The inner arrays describe the columns, the outer ones the matrix' rows.
         * @param {Array} vec Array of numbers
         * @returns {Array} Array of numbers containing the result
         * @example
         * var A = [[2, 1],
         *          [1, 3]],
         *     b = [4, 5],
         *     c;
         * c = JXG.Math.matVecMult(A, b)
         * // c === [13, 19];
         */
        matVecMult: function (mat, vec) {
            var i, s, k,
                m = mat.length,
                n = vec.length,
                res = [];

            if (n === 3) {
                for (i = 0; i < m; i++) {
                    res[i] = mat[i][0] * vec[0] + mat[i][1] * vec[1] + mat[i][2] * vec[2];
                }
            } else {
                for (i = 0; i < m; i++) {
                    s = 0;
                    for (k = 0; k < n; k++) {
                        s += mat[i][k] * vec[k];
                    }
                    res[i] = s;
                }
            }
            return res;
        },

        /**
         * Computes the product of the two matrices mat1*mat2.
         * @param {Array} mat1 Two dimensional array of numbers
         * @param {Array} mat2 Two dimensional array of numbers
         * @returns {Array} Two dimensional Array of numbers containing result
         */
        matMatMult: function (mat1, mat2) {
            var i, j, s, k,
                m = mat1.length,
                n = m > 0 ? mat2[0].length : 0,
                m2 = mat2.length,
                res = this.matrix(m, n);

            for (i = 0; i < m; i++) {
                for (j = 0; j < n; j++) {
                    s = 0;
                    for (k = 0; k < m2; k++) {
                        s += mat1[i][k] * mat2[k][j];
                    }
                    res[i][j] = s;
                }
            }
            return res;
        },

        /**
         * Transposes a matrix given as a two dimensional array.
         * @param {Array} M The matrix to be transposed
         * @returns {Array} The transpose of M
         */
        transpose: function (M) {
            var MT, i, j,
                m, n;

            // number of rows of M
            m = M.length;
            // number of columns of M
            n = M.length > 0 ? M[0].length : 0;
            MT = this.matrix(n, m);

            for (i = 0; i < n; i++) {
                for (j = 0; j < m; j++) {
                    MT[i][j] = M[j][i];
                }
            }

            return MT;
        },

        /**
         * Compute the inverse of an nxn matrix with Gauss elimination.
         * @param {Array} Ain
         * @returns {Array} Inverse matrix of Ain
         */
        inverse: function (Ain) {
            var i, j, k, s, ma, r, swp,
                n = Ain.length,
                A = [],
                p = [],
                hv = [];

            for (i = 0; i < n; i++) {
                A[i] = [];
                for (j = 0; j < n; j++) {
                    A[i][j] = Ain[i][j];
                }
                p[i] = i;
            }

            for (j = 0; j < n; j++) {
                // pivot search:
                ma = Math.abs(A[j][j]);
                r = j;

                for (i = j + 1; i < n; i++) {
                    if (Math.abs(A[i][j]) > ma) {
                        ma = Math.abs(A[i][j]);
                        r = i;
                    }
                }

                // Singular matrix
                if (ma <= this.eps) {
                    return [];
                }

                // swap rows:
                if (r > j) {
                    for (k = 0; k < n; k++) {
                        swp = A[j][k];
                        A[j][k] = A[r][k];
                        A[r][k] = swp;
                    }

                    swp = p[j];
                    p[j] = p[r];
                    p[r] = swp;
                }

                // transformation:
                s = 1.0 / A[j][j];
                for (i = 0; i < n; i++) {
                    A[i][j] *= s;
                }
                A[j][j] = s;

                for (k = 0; k < n; k++) {
                    if (k !== j) {
                        for (i = 0; i < n; i++) {
                            if (i !== j) {
                                A[i][k] -= A[i][j] * A[j][k];
                            }
                        }
                        A[j][k] = -s * A[j][k];
                    }
                }
            }

            // swap columns:
            for (i = 0; i < n; i++) {
                for (k = 0; k < n; k++) {
                    hv[p[k]] = A[i][k];
                }
                for (k = 0; k < n; k++) {
                    A[i][k] = hv[k];
                }
            }

            return A;
        },

        /**
         * Inner product of two vectors a and b. n is the length of the vectors.
         * @param {Array} a Vector
         * @param {Array} b Vector
         * @param {Number} [n] Length of the Vectors. If not given the length of the first vector is taken.
         * @returns {Number} The inner product of a and b.
         */
        innerProduct: function (a, b, n) {
            var i,
                s = 0;

            if (n === undef || !Type.isNumber(n)) {
                n = a.length;
            }

            for (i = 0; i < n; i++) {
                s += a[i] * b[i];
            }

            return s;
        },

        /**
         * Calculates the cross product of two vectors both of length three.
         * In case of homogeneous coordinates this is either
         * <ul>
         * <li>the intersection of two lines</li>
         * <li>the line through two points</li>
         * </ul>
         * @param {Array} c1 Homogeneous coordinates of line or point 1
         * @param {Array} c2 Homogeneous coordinates of line or point 2
         * @returns {Array} vector of length 3: homogeneous coordinates of the resulting point / line.
         */
        crossProduct: function (c1, c2) {
            return [c1[1] * c2[2] - c1[2] * c2[1],
                c1[2] * c2[0] - c1[0] * c2[2],
                c1[0] * c2[1] - c1[1] * c2[0]];
        },

        /**
         * Euclidean norm of a vector.
         *
         * @param {Array} a Array containing a vector.
         * @param {Number} n (Optional) length of the array.
         * @returns {Number} Euclidean norm of the vector.
         */
        norm: function(a, n) {
            var i, sum = 0.0;

            if (n === undef || !Type.isNumber(n)) {
                n = a.length;
            }

            for (i = 0; i < n; i++) {
                sum += a[i] * a[i];
            }

            return Math.sqrt(sum);
        },

        /**
         * Compute the factorial of a positive integer. If a non-integer value
         * is given, the fraction will be ignored.
         * @function
         * @param {Number} n
         * @returns {Number} n! = n*(n-1)*...*2*1
         */
        factorial: memoizer(function (n) {
            if (n < 0) {
                return NaN;
            }

            n = Math.floor(n);

            if (n === 0 || n === 1) {
                return 1;
            }

            return n * this.factorial(n - 1);
        }),

        /**
         * Computes the binomial coefficient n over k.
         * @function
         * @param {Number} n Fraction will be ignored
         * @param {Number} k Fraction will be ignored
         * @returns {Number} The binomial coefficient n over k
         */
        binomial: memoizer(function (n, k) {
            var b, i;

            if (k > n || k < 0) {
                return NaN;
            }

            k = Math.round(k);
            n = Math.round(n);

            if (k === 0 || k === n) {
                return 1;
            }

            b = 1;

            for (i = 0; i < k; i++) {
                b *= (n - i);
                b /= (i + 1);
            }

            return b;
        }),

        /**
         * Calculates the cosine hyperbolicus of x.
         * @function
         * @param {Number} x The number the cosine hyperbolicus will be calculated of.
         * @returns {Number} Cosine hyperbolicus of the given value.
         */
        cosh: Math.cosh || function (x) {
            return (Math.exp(x) + Math.exp(-x)) * 0.5;
        },

        /**
         * Sine hyperbolicus of x.
         * @function
         * @param {Number} x The number the sine hyperbolicus will be calculated of.
         * @returns {Number} Sine hyperbolicus of the given value.
         */
        sinh: Math.sinh || function (x) {
            return (Math.exp(x) - Math.exp(-x)) * 0.5;
        },

        /**
         * Hyperbolic arc-cosine of a number.
         *
         * @param {Number} x
         * @returns {Number}
         */
        acosh: Math.acosh || function(x) {
            return Math.log(x + Math.sqrt(x * x - 1));
        },

        /**
         * Hyperbolic arcsine of a number
         * @param {Number} x
         * @returns {Number}
         */
        asinh: Math.asinh || function(x) {
            if (x === -Infinity) {
                return x;
            }
            return Math.log(x + Math.sqrt(x * x + 1));
        },

        /**
         * Computes the cotangent of x.
         * @function
         * @param {Number} x The number the cotangent will be calculated of.
         * @returns {Number} Cotangent of the given value.
         */
        cot: function (x) {
            return 1 / Math.tan(x);
        },

        /**
         * Computes the inverse cotangent of x.
         * @param {Number} x The number the inverse cotangent will be calculated of.
         * @returns {Number} Inverse cotangent of the given value.
         */
        acot: function (x) {
            return ((x >= 0) ? (0.5) : (-0.5)) * Math.PI - Math.atan(x);
        },

        /**
         * Compute n-th real root of a real number. n must be strictly positive integer.
         * If n is odd, the real n-th root exists and is negative.
         * For n even, for negative valuees of x NaN is returned
         * @param  {Number} x radicand. Must be non-negative, if n even.
         * @param  {Number} n index of the root. must be strictly positive integer.
         * @returns {Number} returns real root or NaN
         *
         * @example
         * nthroot(16, 4): 2
         * nthroot(-27, 3): -3
         * nthroot(-4, 2): NaN
         */
        nthroot: function(x, n) {
            var inv = 1 / n;

            if (n <= 0 || Math.floor(n) !== n) {
                return NaN;
            }

            if (x === 0.0) {
                return 0.0;
            }

            if (x > 0) {
                return Math.exp(inv * Math.log(x));
            }

            // From here on, x is negative
            if (n % 2 === 1) {
                return -Math.exp(inv * Math.log(-x));
            }

            // x negative, even root
            return NaN;
        },

        /**
         * Computes cube root of real number
         * Polyfill for Math.cbrt().
         *
         * @function
         * @param  {Number} x Radicand
         * @returns {Number} Cube root of x.
         */
        cbrt: Math.cbrt || function(x) {
            return this.nthroot(x, 3);
        },

        /**
         * Compute base to the power of exponent.
         * @param {Number} base
         * @param {Number} exponent
         * @returns {Number} base to the power of exponent.
         */
        pow: function (base, exponent) {
            if (base === 0) {
                if (exponent === 0) {
                    return 1;
                }
                return 0;
            }

            // exponent is an integer
            if (Math.floor(exponent) === exponent) {
                return Math.pow(base, exponent);
            }

            // exponent is not an integer
            if (base > 0) {
                return Math.exp(exponent * Math.log(base));
            }

            return NaN;
        },

        /**
         * Compute base to the power of the rational exponent m / n.
         * This function first reduces the fraction m/n and then computes
         * JXG.Math.pow(base, m/n).
         *
         * This function is necessary to have the same results for e.g.
         * (-8)^(1/3) = (-8)^(2/6) = -2
         * @param {Number} base
         * @param {Number} m numerator of exponent
         * @param {Number} n denominator of exponent
         * @returns {Number} base to the power of exponent.
         */
        ratpow: function(base, m, n) {
            var g;
            if (m === 0) {
                return 1;
            }
            if (n === 0) {
                return NaN;
            }

            g = this.gcd(m, n);
            return this.nthroot(this.pow(base, m / g), n / g);
        },

        /**
         * Logarithm to base 10.
         * @param {Number} x
         * @returns {Number} log10(x) Logarithm of x to base 10.
         */
        log10: function (x) {
            return Math.log(x) / Math.log(10.0);
        },

        /**
         * Logarithm to base 2.
         * @param {Number} x
         * @returns {Number} log2(x) Logarithm of x to base 2.
         */
        log2: function (x) {
            return Math.log(x) / Math.log(2.0);
        },

        /**
         * Logarithm to arbitrary base b. If b is not given, natural log is taken, i.e. b = e.
         * @param {Number} x
         * @param {Number} b base
         * @returns {Number} log(x, b) Logarithm of x to base b, that is log(x)/log(b).
         */
        log: function (x, b) {
            if (b !== undefined && Type.isNumber(b)) {
                return Math.log(x) / Math.log(b);
            }

            return Math.log(x);
        },

        /**
         * The sign() function returns the sign of a number, indicating whether the number is positive, negative or zero.
         *
         * @function
         * @param  {Number} x A Number
         * @returns {[type]}  This function has 5 kinds of return values,
         *    1, -1, 0, -0, NaN, which represent "positive number", "negative number", "positive zero", "negative zero"
         *    and NaN respectively.
         */
        sign: Math.sign || function(x) {
            x = +x; // convert to a number
            if (x === 0 || isNaN(x)) {
                return x;
            }
            return x > 0 ? 1 : -1;
        },

        /**
         * A square & multiply algorithm to compute base to the power of exponent.
         * Implementated by Wolfgang Riedl.
         *
         * @param {Number} base
         * @param {Number} exponent
         * @returns {Number} Base to the power of exponent
         */
        squampow: function (base, exponent) {
            var result;

            if (Math.floor(exponent) === exponent) {
                // exponent is integer (could be zero)
                result = 1;

                if (exponent < 0) {
                    // invert: base
                    base = 1.0 / base;
                    exponent *= -1;
                }

                while (exponent !== 0) {
                    if (exponent & 1) {
                        result *= base;
                    }

                    exponent >>= 1;
                    base *= base;
                }
                return result;
            }

            return this.pow(base, exponent);
        },

        /**
         * Greatest common divisor (gcd) of two numbers.
         * @see <a href="http://rosettacode.org/wiki/Greatest_common_divisor#JavaScript">rosettacode.org</a>
         *
         * @param  {Number} a First number
         * @param  {Number} b Second number
         * @returns {Number}   gcd(a, b) if a and b are numbers, NaN else.
         */
        gcd: function (a, b) {
            a = Math.abs(a);
            b = Math.abs(b);

            if (!(Type.isNumber(a) && Type.isNumber(b))) {
                return NaN;
            }
            if (b > a) {
                var temp = a;
                a = b;
                b = temp;
            }

            while (true) {
                a %= b;
                if (a === 0) { return b; }
                b %= a;
                if (b === 0) { return a; }
            }
        },

        /**
         * Least common multiple (lcm) of two numbers.
         *
         * @param  {Number} a First number
         * @param  {Number} b Second number
         * @returns {Number}   lcm(a, b) if a and b are numbers, NaN else.
         */
        lcm: function (a, b) {
            var ret;

            if (!(Type.isNumber(a) && Type.isNumber(b))) {
                return NaN;
            }

            ret = a * b;
            if (ret !== 0) {
                return ret / this.gcd(a, b);
            }

            return 0;
        },

        /**
         *  Error function, see {@link https://en.wikipedia.org/wiki/Error_function}.
         *
         * @see JXG.Math.PropFunc.erf
         * @param  {Number} x
         * @returns {Number}
         */
        erf: function(x) {
            return this.ProbFuncs.erf(x);
        },

        /**
         * Complementary error function, i.e. 1 - erf(x).
         *
         * @see JXG.Math.erf
         * @see JXG.Math.PropFunc.erfc
         * @param  {Number} x
         * @returns {Number}
         */
         erfc: function(x) {
            return this.ProbFuncs.erfc(x);
        },

        /**
         * Inverse of error function
         *
         * @see JXG.Math.erf
         * @see JXG.Math.PropFunc.erfi
         * @param  {Number} x
         * @returns {Number}
         */
         erfi: function(x) {
            return this.ProbFuncs.erfi(x);
        },

        /**
         * Normal distribution function
         *
         * @see JXG.Math.PropFunc.ndtr
         * @param  {Number} x
         * @returns {Number}
         */
         ndtr: function(x) {
            return this.ProbFuncs.ndtr(x);
        },

        /**
         * Inverse of normal distribution function
         *
         * @see JXG.Math.ndtr
         * @see JXG.Math.PropFunc.ndtri
         * @param  {Number} x
         * @returns {Number}
         */
         ndtri: function(x) {
            return this.ProbFuncs.ndtri(x);
        },

        /* ********************  Comparisons and logical operators ************** */

        /**
         * Logical test: a < b?
         *
         * @param {Number} a
         * @param {Number} b
         * @returns {Boolean}
         */
        lt: function(a, b) {
            return a < b;
        },

        /**
         * Logical test: a <= b?
         *
         * @param {Number} a
         * @param {Number} b
         * @returns {Boolean}
         */
        leq: function(a, b) {
            return a <= b;
        },

        /**
         * Logical test: a > b?
         *
         * @param {Number} a
         * @param {Number} b
         * @returns {Boolean}
         */
        gt: function(a, b) {
            return a > b;
        },

        /**
         * Logical test: a >= b?
         *
         * @param {Number} a
         * @param {Number} b
         * @returns {Boolean}
         */
        geq: function(a, b) {
            return a >= b;
        },

        /**
         * Logical test: a === b?
         *
         * @param {Number} a
         * @param {Number} b
         * @returns {Boolean}
         */
        eq: function(a, b) {
            return a === b;
        },

        /**
         * Logical test: a !== b?
         *
         * @param {Number} a
         * @param {Number} b
         * @returns {Boolean}
         */
        neq: function(a, b) {
            return a !== b;
        },

        /**
         * Logical operator: a && b?
         *
         * @param {Boolean} a
         * @param {Boolean} b
         * @returns {Boolean}
         */
        and: function(a, b) {
            return a && b;
        },

        /**
         * Logical operator: !a?
         *
         * @param {Boolean} a
         * @returns {Boolean}
         */
        not: function(a) {
            return !a;
        },

        /**
         * Logical operator: a || b?
         *
         * @param {Boolean} a
         * @param {Boolean} b
         * @returns {Boolean}
         */
        or: function(a, b) {
            return a || b;
        },

        /**
         * Logical operator: either a or b?
         *
         * @param {Boolean} a
         * @param {Boolean} b
         * @returns {Boolean}
         */
        xor: function(a, b) {
            return (a || b) && !(a && b);
        },

        /* *************************** Normalize *************************** */

        /**
         * Normalize the standard form [c, b0, b1, a, k, r, q0, q1].
         * @private
         * @param {Array} stdform The standard form to be normalized.
         * @returns {Array} The normalized standard form.
         */
        normalize: function (stdform) {
            var n, signr,
                a2 = 2 * stdform[3],
                r = stdform[4] / a2;

            stdform[5] = r;
            stdform[6] = -stdform[1] / a2;
            stdform[7] = -stdform[2] / a2;

            if (!isFinite(r)) {
                n = Math.sqrt(stdform[1] * stdform[1] + stdform[2] * stdform[2]);

                stdform[0] /= n;
                stdform[1] /= n;
                stdform[2] /= n;
                stdform[3] = 0;
                stdform[4] = 1;
            } else if (Math.abs(r) >= 1) {
                stdform[0] = (stdform[6] * stdform[6] + stdform[7] * stdform[7] - r * r) / (2 * r);
                stdform[1] = -stdform[6] / r;
                stdform[2] = -stdform[7] / r;
                stdform[3] = 1 / (2 * r);
                stdform[4] = 1;
            } else {
                signr = (r <= 0 ? -1 : 1);
                stdform[0] = signr * (stdform[6] * stdform[6] + stdform[7] * stdform[7] - r * r) * 0.5;
                stdform[1] = -signr * stdform[6];
                stdform[2] = -signr * stdform[7];
                stdform[3] = signr / 2;
                stdform[4] = signr * r;
            }

            return stdform;
        },

        /**
         * Converts a two dimensional array to a one dimensional Float32Array that can be processed by WebGL.
         * @param {Array} m A matrix in a two dimensional array.
         * @returns {Float32Array} A one dimensional array containing the matrix in column wise notation. Provides a fall
         * back to the default JavaScript Array if Float32Array is not available.
         */
        toGL: function (m) {
            var v, i, j;

            if (typeof Float32Array === 'function') {
                v = new Float32Array(16);
            } else {
                v = new Array(16);
            }

            if (m.length !== 4 && m[0].length !== 4) {
                return v;
            }

            for (i = 0; i < 4; i++) {
                for (j = 0; j < 4; j++) {
                    v[i + 4 * j] = m[i][j];
                }
            }

            return v;
        },

        /**
         * Theorem of Vieta: Given a set of simple zeroes x_0, ..., x_n
         * of a polynomial f, compute the coefficients s_k, (k=0,...,n-1)
         * of the polynomial of the form. See {@link https://de.wikipedia.org/wiki/Elementarsymmetrisches_Polynom}.
         * <p>
         *  f(x) = (x-x_0)*...*(x-x_n) =
         *  x^n + sum_{k=1}^{n} (-1)^(k) s_{k-1} x^(n-k)
         * </p>
         * @param {Array} x Simple zeroes of the polynomial.
         * @returns {Array} Coefficients of the polynomial.
         *
         */
        Vieta: function(x) {
            var n = x.length,
                s = [],
                m, k, y;

            s = x.slice();
            for (m = 1; m < n; ++m) {
                y = s[m];
                s[m] *= s[m - 1];
                for (k = m - 1; k >= 1; --k) {
                    s[k] += s[k - 1] * y;
                }
                s[0] += y;
            }
            return s;
        }
    };

    return JXG.Math;
});

/*
    Copyright 2008-2022
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <http://www.gnu.org/licenses/>
    and <http://opensource.org/licenses/MIT/>.
 */


/*global JXG: true, define: true, AMprocessNode: true, MathJax: true, document: true */
/*jslint nomen: true, plusplus: true*/

/* depends:
 jxg
 base/constants
 utils/event
 math/math
 */

define('base/coords',[
    'jxg', 'base/constants', 'utils/event', 'utils/type', 'math/math'
], function (JXG, Const, EventEmitter, Type, Mat) {

    "use strict";

    /**
     * @fileoverview In this file the Coords object is defined, a class to manage all
     * properties and methods coordinates usually have.
     */

    /**
     * Constructs a new Coordinates object.
     * @class This is the Coordinates class.
     * All members a coordinate has to provide
     * are defined here.
     * @param {Number} method The type of coordinates given by the user. Accepted values are <b>COORDS_BY_SCREEN</b> and <b>COORDS_BY_USER</b>.
     * @param {Array} coordinates An array of affine coordinates.
     * @param {JXG.Board} board A reference to a board.
     * @oaram {Boolean} [emitter=true]
     * @borrows JXG.EventEmitter#on as this.on
     * @borrows JXG.EventEmitter#off as this.off
     * @borrows JXG.EventEmitter#triggerEventHandlers as this.triggerEventHandlers
     * @borrows JXG.EventEmitter#eventHandlers as this.eventHandlers
     * @constructor
     */
    JXG.Coords = function (method, coordinates, board, emitter) {
        /**
         * Stores the board the object is used on.
         * @type JXG.Board
         */
        this.board = board;

        /**
         * Stores coordinates for user view as homogeneous coordinates.
         * @type Array
         */
        this.usrCoords = [];
        //this.usrCoords = new Float64Array(3);

        /**
         * Stores coordinates for screen view as homogeneous coordinates.
         * @type Array
         */
        this.scrCoords = [];
        //this.scrCoords = new Float64Array(3);

        /**
         * If true, this coordinates object will emit update events every time
         * the coordinates are set.
         * @type boolean
         * @default true
         */
        this.emitter = !Type.exists(emitter) || emitter;

        if (this.emitter) {
            EventEmitter.eventify(this);
        }
        this.setCoordinates(method, coordinates, false, true);
    };

    JXG.extend(JXG.Coords.prototype, /** @lends JXG.Coords.prototype */ {
        /**
         * Normalize homogeneous coordinates
         * @private
         */
        normalizeUsrCoords: function () {
            if (Math.abs(this.usrCoords[0]) > Mat.eps) {
                this.usrCoords[1] /= this.usrCoords[0];
                this.usrCoords[2] /= this.usrCoords[0];
                this.usrCoords[0] = 1.0;
            }
        },

        /**
         * Compute screen coordinates out of given user coordinates.
         * @private
         */
        usr2screen: function (doRound) {
            var mround = Math.round,  // Is faster on IE, maybe slower with JIT compilers
                b = this.board,
                uc = this.usrCoords,
                oc = b.origin.scrCoords;

            if (doRound === true) {
                this.scrCoords[0] = mround(uc[0]);
                this.scrCoords[1] = mround(uc[0] * oc[1] + uc[1] * b.unitX);
                this.scrCoords[2] = mround(uc[0] * oc[2] - uc[2] * b.unitY);
            } else {
                this.scrCoords[0] = uc[0];
                this.scrCoords[1] = uc[0] * oc[1] + uc[1] * b.unitX;
                this.scrCoords[2] = uc[0] * oc[2] - uc[2] * b.unitY;
            }
        },

        /**
         * Compute user coordinates out of given screen coordinates.
         * @private
         */
        screen2usr: function () {
            var o = this.board.origin.scrCoords,
                sc = this.scrCoords,
                b = this.board;

            this.usrCoords[0] =  1.0;
            this.usrCoords[1] = (sc[1] - o[1]) / b.unitX;
            this.usrCoords[2] = (o[2] - sc[2]) / b.unitY;
        },

        /**
         * Calculate distance of one point to another.
         * @param {Number} coord_type The type of coordinates used here. Possible values are <b>JXG.COORDS_BY_USER</b> and <b>JXG.COORDS_BY_SCREEN</b>.
         * @param {JXG.Coords} coordinates The Coords object to which the distance is calculated.
         * @returns {Number} The distance
         */
        distance: function (coord_type, coordinates) {
            var sum = 0,
                c,
                ucr = this.usrCoords,
                scr = this.scrCoords,
                f;

            if (coord_type === Const.COORDS_BY_USER) {
                c = coordinates.usrCoords;
                f = ucr[0] - c[0];
                sum = f * f;

                if (sum > Mat.eps * Mat.eps) {
                    return Number.POSITIVE_INFINITY;
                }
                f = ucr[1] - c[1];
                sum += f * f;
                f = ucr[2] - c[2];
                sum += f * f;
            } else {
                c = coordinates.scrCoords;
                //f = scr[0]-c[0];
                //sum = f*f;
                f = scr[1] - c[1];
                sum += f * f;
                f = scr[2] - c[2];
                sum += f * f;
            }

            return Math.sqrt(sum);
        },

        /**
         * Set coordinates by either user coordinates or screen coordinates and recalculate the other one.
         * @param {Number} coord_type The type of coordinates used here. Possible values are <b>COORDS_BY_USER</b> and <b>COORDS_BY_SCREEN</b>.
         * @param {Array} coordinates An array of affine coordinates the Coords object is set to.
         * @param {Boolean} [doRound=true] flag If true or null round the coordinates in usr2screen. This is used in smooth curve plotting.
         * The IE needs rounded coordinates. Id doRound==false we have to round in updatePathString.
         * @param {Boolean} [noevent=false]
         * @returns {JXG.Coords} Reference to the coords object.
         */
        setCoordinates: function (coord_type, coordinates, doRound, noevent) {
            var uc = this.usrCoords,
                sc = this.scrCoords,
                // Original values
                ou = [uc[0], uc[1], uc[2]],
                os = [sc[0], sc[1], sc[2]];

            if (coord_type === Const.COORDS_BY_USER) {
                if (coordinates.length === 2) { // Euclidean coordinates
                    uc[0] = 1.0;
                    uc[1] = coordinates[0];
                    uc[2] = coordinates[1];
                } else { // Homogeneous coordinates (normalized)
                    uc[0] = coordinates[0];
                    uc[1] = coordinates[1];
                    uc[2] = coordinates[2];
                    this.normalizeUsrCoords();
                }
                this.usr2screen(doRound);
            } else {
                if (coordinates.length === 2) { // Euclidean coordinates
                    sc[1] = coordinates[0];
                    sc[2] = coordinates[1];
                } else { // Homogeneous coordinates (normalized)
                    sc[1] = coordinates[1];
                    sc[2] = coordinates[2];
                }
                this.screen2usr();
            }

            if (this.emitter && !noevent && (os[1] !== sc[1] || os[2] !== sc[2])) {
                this.triggerEventHandlers(['update'], [ou, os]);
            }

            return this;
        },

        /**
        * Copy array, either scrCoords or usrCoords
        * Uses slice() in case of standard arrays and set() in case of
        * typed arrays.
        * @private
        * @param {String} obj Either 'scrCoords' or 'usrCoords'
        * @param {Number} offset Offset, defaults to 0 if not given
        * @returns {Array} Returns copy of the coords array either as standard array or as
        *   typed array.
        */
        copy: function (obj, offset) {
            if (offset === undefined) {
                offset = 0;
            }

            return this[obj].slice(offset);
        },

        /**
         * Test if one of the usrCoords is NaN or the coordinates are infinite.
         * @returns {Boolean} true if the coordinates are finite, false otherwise.
         */
        isReal: function() {
            return (!isNaN(this.usrCoords[1] + this.usrCoords[2])) && (Math.abs(this.usrCoords[0]) > Mat.eps);
        },

        /**
         * Triggered whenever the coordinates change.
         * @name JXG.Coords#update
         * @param {Array} ou Old user coordinates
         * @param {Array} os Old screen coordinates
         * @event
         */
        __evt__update: function (ou, os) { },

        /**
         * @ignore
         */
        __evt: function () {}
    });

    return JXG.Coords;
});

/*
    Copyright 2008-2022
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <http://www.gnu.org/licenses/>
    and <http://opensource.org/licenses/MIT/>.
 */


/*global JXG: true, define: true, html_sanitize: true*/
/*jslint nomen: true, plusplus: true*/

/* depends:
 jxg
 base/constants
 */

/**
 * @fileoverview expect.js provides utilities for parameter magic by normalizing multi-type parameters.
 */

define('utils/expect',[
    'jxg', 'utils/type', 'base/constants', 'base/coords'
], function (JXG, Type, Const, Coords) {

    "use strict";

    var Expect = {
        /**
         * Apply an expect method on every element of an array.
         *
         * @param {Array} a
         * @param {function} format
         * @param {Boolean} [copy=false]
         *
         * @returns {Array}
         */
        each: function (a, format, copy) {
            var i, len,
                r = [];

            if (Type.exists(a.length)) {
                len = a.length;
                for (i = 0; i < len; i++) {
                    r.push(format.call(this, a[i], copy));
                }
            }

            return r;
        },

        /**
         * Normalize points and coord objects into a coord object.
         *
         * @param {JXG.Point|JXG.Coords} c
         * @param {Boolean} [copy=false] Return a copy, not a reference
         *
         * @returns {JXG.Coords}
         */
        coords: function (c, copy) {
            var coord = c;

            if (c && c.elementClass === Const.OBJECT_CLASS_POINT) {
                coord = c.coords;
            } else if (c.usrCoords && c.scrCoords && c.usr2screen) {
                coord = c;
            }

            if (copy) {
                coord = new Coords(Const.COORDS_BY_USER, coord.usrCoords, coord.board);
            }

            return coord;
        },

        /**
         * Normalize points, coordinate arrays and coord objects into a coordinate array.
         *
         * @param {JXG.Point|JXG.Coords|Array} c
         * @param {Boolean} [copy=false] Return a copy, not a reference
         *
         * @returns {Array} Homogeneous coordinates
         */
        coordsArray: function (c, copy) {
            var coord;

            if (!Type.isArray(c)) {
                coord = this.coords(c).usrCoords;
            } else {
                coord = c;
            }

            if (coord.length < 3) {
                coord.unshift(1);
            }

            if (copy) {
                coord = [coord[0], coord[1], coord[2]];
            }

            return coord;
        }
    };

    JXG.Expect = Expect;

    return Expect;
});

/*
    Copyright 2008-2022
        Matthias Ehmann,
        Carsten Miller,
        Andreas Walter,
        Alfred Wassermann

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <http://www.gnu.org/licenses/>
    and <http://opensource.org/licenses/MIT/>.
 */


/*global JXG: true, define: true*/
/*jslint nomen: true, plusplus: true*/
/*eslint no-loss-of-precision: off */

/* depends:
 jxg
 math/math
 utils/type
 */

define('math/probfuncs',['math/math', 'utils/type'], function (Mat, Type) {

    "use strict";

    /**
     * Probability functions, e.g. error function,
     * see: https://en.wikipedia.org/wiki/Error_function
     * Ported from
     * by https://github.com/jeremybarnes/cephes/blob/master/cprob/ndtr.c,
     *
     * Cephes Math Library Release 2.9:  November, 2000
     * Copyright 1984, 1987, 1988, 1992, 2000 by Stephen L. Moshier
     *
     * @name JXG.Math.ProbFuncs
     * @exports Mat.ProbFuncs as JXG.Math.ProbFuncs
     * @namespace
     */
    Mat.ProbFuncs = {
        MAXNUM: 1.701411834604692317316873e38,  // 2**127
        SQRTH:  7.07106781186547524401E-1,      // sqrt(2)/2
        SQRT2:  1.41421356237309504880,         // sqrt(2)
        MAXLOG: 7.08396418532264106224E2,       // log 2**1022

        P: [
            2.46196981473530512524E-10,
            5.64189564831068821977E-1,
            7.46321056442269912687E0,
            4.86371970985681366614E1,
            1.96520832956077098242E2,
            5.26445194995477358631E2,
            9.34528527171957607540E2,
            1.02755188689515710272E3,
            5.57535335369399327526E2
        ],

        Q: [
            1.32281951154744992508E1,
            8.67072140885989742329E1,
            3.54937778887819891062E2,
            9.75708501743205489753E2,
            1.82390916687909736289E3,
            2.24633760818710981792E3,
            1.65666309194161350182E3,
            5.57535340817727675546E2
        ],

        R: [
            5.64189583547755073984E-1,
            1.27536670759978104416E0,
            5.01905042251180477414E0,
            6.16021097993053585195E0,
            7.40974269950448939160E0,
            2.97886665372100240670E0
        ],

        S: [
            2.26052863220117276590E0,
            9.39603524938001434673E0,
            1.20489539808096656605E1,
            1.70814450747565897222E1,
            9.60896809063285878198E0,
            3.36907645100081516050E0
        ],

        T: [
            9.60497373987051638749E0,
            9.00260197203842689217E1,
            2.23200534594684319226E3,
            7.00332514112805075473E3,
            5.55923013010394962768E4
        ],

        U: [
            3.35617141647503099647E1,
            5.21357949780152679795E2,
            4.59432382970980127987E3,
            2.26290000613890934246E4,
            4.92673942608635921086E4
        ],

        // UTHRESH: 37.519379347,
        M: 128.0,
        MINV: 0.0078125,

        /**
         *
         *	Exponential of squared argument
         *
         * SYNOPSIS:
         *
         * double x, y, expx2();
         * int sign;
         *
         * y = expx2( x, sign );
         *
         *
         *
         * DESCRIPTION:
         *
         * Computes y = exp(x*x) while suppressing error amplification
         * that would ordinarily arise from the inexactness of the
         * exponential argument x*x.
         *
         * If sign < 0, the result is inverted; i.e., y = exp(-x*x) .
         *
         *
         * ACCURACY:
         *
         *                      Relative error:
         * arithmetic    domain     # trials      peak         rms
         *   IEEE      -26.6, 26.6    10^7       3.9e-16     8.9e-17
         *
         * @private
         * @param  {Number} x
         * @param  {Number} sign (int)
         * @returns {Number}
         */
        expx2: function(x, sign) {
            // double x;
            // int sign;
            var u, u1, m, f;

            x = Math.abs(x);
            if (sign < 0) {
                x = -x;
            }

            // Represent x as an exact multiple of M plus a residual.
            //    M is a power of 2 chosen so that exp(m * m) does not overflow
            //    or underflow and so that |x - m| is small.
            m = this.MINV * Math.floor(this.M * x + 0.5);
            f = x - m;

            // x^2 = m^2 + 2mf + f^2
            u = m * m;
            u1 = 2 * m * f  +  f * f;

            if (sign < 0) {
                u = -u;
                u1 = -u1;
            }

            if ( u + u1 > this.MAXLOG) {
                return Infinity;
            }

            // u is exact, u1 is small.
            u = Math.exp(u) * Math.exp(u1);
            return u;
        },

        /**
         *
         *	Evaluate polynomial
         *
         * SYNOPSIS:
         *
         * int N;
         * double x, y, coef[N+1], polevl[];
         *
         * y = polevl( x, coef, N );
         *
         * DESCRIPTION:
         *
         * Evaluates polynomial of degree N:
         *
         *                     2          N
         * y  =  C  + C x + C x  +...+ C x
         *        0    1     2          N
         *
         * Coefficients are stored in reverse order:
         *
         * coef[0] = C  , ..., coef[N] = C  .
         *            N                   0
         *
         *  The function p1evl() assumes that coef[N] = 1.0 and is
         * omitted from the array.  Its calling arguments are
         * otherwise the same as polevl().
         *
         *
         * SPEED:
         *
         * In the interest of speed, there are no checks for out
         * of bounds arithmetic.  This routine is used by most of
         * the functions in the library.  Depending on available
         * equipment features, the user may wish to rewrite the
         * program in microcode or assembly language.
         *
         * @private
         * @param  {Number} x
         * @param  {Number} coef
         * @param  {Number} N
         * @returns {Number}
         */
        polevl: function(x, coef, N) {
            var ans, i;

            if (Type.exists(coef.reduce)) {
                return coef.reduce(function(acc, c) {
                    return acc * x + c;
                }, 0);
            }
            // Polyfill
            for (i = 0, ans = 0; i <= N; i++) {
                ans = ans * x + coef[i];
            }
            return ans;

        },

        /**
         * Evaluate polynomial when coefficient of x is 1.0.
         * Otherwise same as polevl.
         *
         * @private
         * @param  {Number} x
         * @param  {Number} coef
         * @param  {Number} N
         * @returns {Number}
         */
        p1evl: function(x, coef, N) {
            var ans, i;

            if (Type.exists(coef.reduce)) {
                return coef.reduce(function(acc, c) {
                    return acc * x + c;
                }, 1);
            }
            // Polyfill
            for (i = 0, ans = 1; i < N; i++) {
                ans = ans * x + coef[i];
            }
            return ans;
        },

        /**
         *
         *	Normal distribution function
         *
         * SYNOPSIS:
         *
         * y = ndtr( x );
         *
         * DESCRIPTION:
         *
         * Returns the area under the Gaussian probability density
         * function, integrated from minus infinity to x:
         *
         *                            x
         *                             -
         *                   1        | |          2
         *    ndtr(x)  = ---------    |    exp( - t /2 ) dt
         *               sqrt(2pi)  | |
         *                           -
         *                          -inf.
         *
         *             =  ( 1 + erf(z) ) / 2
         *             =  erfc(z) / 2
         *
         * where z = x/sqrt(2). Computation is via the functions
         * erf and erfc with care to avoid error amplification in computing exp(-x^2).
         *
         *
         * ACCURACY:
         *
         *                      Relative error:
         * arithmetic   domain     # trials      peak         rms
         *    IEEE     -13,0        30000       1.3e-15     2.2e-16
         *
         *
         * ERROR MESSAGES:
         *
         *   message         condition         value returned
         * erfc underflow    x > 37.519379347       0.0
         *
         * @param  {Number} a
         * @returns {Number}
         */
        ndtr: function(a) {
            // a: double, return double
            var x, y, z;

            x = a * this.SQRTH;
            z = Math.abs(x);

            if (z < 1.0) {
                y = 0.5 + 0.5 * this.erf(x);
            } else {
                y = 0.5 * this.erfce(z);
                /* Multiply by exp(-x^2 / 2)  */
                z = this.expx2(a, -1);
                y = y * Math.sqrt(z);
                if (x > 0) {
                    y = 1.0 - y;
                }
            }
            return y;
        },

        /**
         * @private
         * @param  {Number} a
         * @returns {Number}
         */
        _underflow: function(a) {
            console.log('erfc', 'UNDERFLOW');
            if (a < 0) {
                return 2.0;
            }
            return 0.0;
        },

        /**
         *
         *	Complementary error function
         *
         * SYNOPSIS:
         *
         * double x, y, erfc();
         *
         * y = erfc( x );
         *
         *
         *
         * DESCRIPTION:
         *
         *
         *  1 - erf(x) =
         *
         *                           inf.
         *                             -
         *                  2         | |          2
         *   erfc(x)  =  --------     |    exp( - t  ) dt
         *               sqrt(pi)   | |
         *                           -
         *                            x
         *
         *
         * For small x, erfc(x) = 1 - erf(x); otherwise rational
         * approximations are computed.
         *
         * A special function expx2.c is used to suppress error amplification
         * in computing exp(-x^2).
         *
         *
         * ACCURACY:
         *
         *                      Relative error:
         * arithmetic   domain     # trials      peak         rms
         *    IEEE      0,26.6417   30000       1.3e-15     2.2e-16
         *
         *
         * ERROR MESSAGES:
         *
         *   message         condition              value returned
         * erfc underflow    x > 9.231948545 (DEC)       0.0
         *
         * @param  {Number} a
         * @returns {Number}
         */
        erfc: function(a) {
            var p, q, x, y, z;

            if (a < 0.0) {
                x = -a;
            } else {
                x = a;
            }
            if (x < 1.0) {
                return 1.0 - this.erf(a);
            }

            z = -a * a;
            if (z < -this.MAXLOG) {
                return this._underflow(a);
            }

            z = this.expx2(a, -1);  // Compute z = exp(z).

            if (x < 8.0) {
                p = this.polevl(x, this.P, 8);
                q = this.p1evl(x, this.Q, 8);
            } else {
                p = this.polevl(x, this.R, 5);
                q = this.p1evl(x, this.S, 6);
            }

            y = (z * p) / q;

            if (a < 0) {
                y = 2.0 - y;
            }

            if (y === 0.0) {
                return this._underflow(a);
            }

            return y;
        },

        /**
         * Exponentially scaled erfc function
         *   exp(x^2) erfc(x)
         *   valid for x > 1.
         *   Use with ndtr and expx2.
         *
         * @private
         * @param {Number} x
         * @returns {Number}
         */
        erfce: function(x) {
            var p, q;

            if (x < 8.0) {
                p = this.polevl(x, this.P, 8);
                q = this.p1evl(x, this.Q, 8);
            } else {
                p = this.polevl( x, this.R, 5 );
                q = this.p1evl( x, this.S, 6 );
            }
            return p / q;
        },

        /**
         *	Error function
         *
         * SYNOPSIS:
         *
         * double x, y, erf();
         *
         * y = erf( x );
         *
         *
         *
         * DESCRIPTION:
         *
         * The integral is
         *
         *                           x
         *                            -
         *                 2         | |          2
         *   erf(x)  =  --------     |    exp( - t  ) dt.
         *              sqrt(pi)   | |
         *                          -
         *                           0
         *
         * For 0 <= |x| < 1, erf(x) = x * P4(x**2)/Q5(x**2); otherwise
         * erf(x) = 1 - erfc(x).
         *
         *
         * ACCURACY:
         *
         *                      Relative error:
         * arithmetic   domain     # trials      peak         rms
         *    DEC       0,1         14000       4.7e-17     1.5e-17
         *    IEEE      0,1         30000       3.7e-16     1.0e-16
         *
         * @param  {Number} x
         * @returns {Number}
         */
        erf: function(x) {
            var y, z;

            if (Math.abs(x) > 1.0) {
                return 1.0 - this.erfc(x);
            }
            z = x * x;
            y = x * this.polevl(z, this.T, 4) / this.p1evl(z, this.U, 5);
            return y;
        },

        s2pi: 2.50662827463100050242E0, // sqrt(2pi)

        // approximation for 0 <= |y - 0.5| <= 3/8 */
        P0: [
            -5.99633501014107895267E1,
             9.80010754185999661536E1,
            -5.66762857469070293439E1,
             1.39312609387279679503E1,
            -1.23916583867381258016E0
        ],

        Q0: [
             1.95448858338141759834E0,
             4.67627912898881538453E0,
             8.63602421390890590575E1,
            -2.25462687854119370527E2,
             2.00260212380060660359E2,
            -8.20372256168333339912E1,
             1.59056225126211695515E1,
            -1.18331621121330003142E0,
        ],

        //  Approximation for interval z = sqrt(-2 log y ) between 2 and 8
        //  i.e., y between exp(-2) = .135 and exp(-32) = 1.27e-14.
        P1: [
            4.05544892305962419923E0,
            3.15251094599893866154E1,
            5.71628192246421288162E1,
            4.40805073893200834700E1,
            1.46849561928858024014E1,
            2.18663306850790267539E0,
           -1.40256079171354495875E-1,
           -3.50424626827848203418E-2,
           -8.57456785154685413611E-4
        ],

        Q1: [
            1.57799883256466749731E1,
            4.53907635128879210584E1,
            4.13172038254672030440E1,
            1.50425385692907503408E1,
            2.50464946208309415979E0,
           -1.42182922854787788574E-1,
           -3.80806407691578277194E-2,
           -9.33259480895457427372E-4
        ],

        // Approximation for interval z = sqrt(-2 log y ) between 8 and 64
        // i.e., y between exp(-32) = 1.27e-14 and exp(-2048) = 3.67e-890.
        P2: [
            3.23774891776946035970E0,
            6.91522889068984211695E0,
            3.93881025292474443415E0,
            1.33303460815807542389E0,
            2.01485389549179081538E-1,
            1.23716634817820021358E-2,
            3.01581553508235416007E-4,
            2.65806974686737550832E-6,
            6.23974539184983293730E-9
        ],

        Q2: [
            6.02427039364742014255E0,
            3.67983563856160859403E0,
            1.37702099489081330271E0,
            2.16236993594496635890E-1,
            1.34204006088543189037E-2,
            3.28014464682127739104E-4,
            2.89247864745380683936E-6,
            6.79019408009981274425E-9
        ],

        /**
         *
         *	Inverse of Normal distribution function
         *
         * SYNOPSIS:
         *
         * double x, y, ndtri();
         *
         * x = ndtri( y );
         *
         * DESCRIPTION:
         *
         * Returns the argument, x, for which the area under the
         * Gaussian probability density function (integrated from
         * minus infinity to x) is equal to y.
         *
         *
         * For small arguments 0 < y < exp(-2), the program computes
         * z = sqrt( -2.0 * log(y) );  then the approximation is
         * x = z - log(z)/z  - (1/z) P(1/z) / Q(1/z).
         * There are two rational functions P/Q, one for 0 < y < exp(-32)
         * and the other for y up to exp(-2).  For larger arguments,
         * w = y - 0.5, and  x/sqrt(2pi) = w + w**3 R(w**2)/S(w**2)).
         *
         *
         * ACCURACY:
         *
         *                      Relative error:
         * arithmetic   domain        # trials      peak         rms
         *    DEC      0.125, 1         5500       9.5e-17     2.1e-17
         *    DEC      6e-39, 0.135     3500       5.7e-17     1.3e-17
         *    IEEE     0.125, 1        20000       7.2e-16     1.3e-16
         *    IEEE     3e-308, 0.135   50000       4.6e-16     9.8e-17
         *
         *
         * ERROR MESSAGES:
         *
         *   message         condition    value returned
         * ndtri domain       x <= 0        -MAXNUM
         * ndtri domain       x >= 1         MAXNUM
         *
         * @param  {Number} y0
         * @returns {Number}
         */
        ndtri: function(y0) {
            var x, y, z, y2, x0, x1, code;

            if (y0 <= 0.0) {
                //console.log("ndtri", "DOMAIN ");
                return -Infinity; // -this.MAXNUM;
            }
            if (y0 >= 1.0) {
                // console.log("ndtri", "DOMAIN");
                return Infinity; // this.MAXNUM;
            }

            code = 1;
            y = y0;
            if (y > (1.0 - 0.13533528323661269189))  {  // 0.135... = exp(-2)
                y = 1.0 - y;
                code = 0;
            }

            if (y > 0.13533528323661269189) {
                y = y - 0.5;
                y2 = y * y;
                x = y + y * (y2 * this.polevl(y2, this.P0, 4) / this.p1evl(y2, this.Q0, 8));
                x = x * this.s2pi;
                return x;
            }

            x = Math.sqrt( -2.0 * Math.log(y) );
            x0 = x - Math.log(x) / x;

            z = 1.0 / x;
            if (x < 8.0) {           // y > exp(-32) = 1.2664165549e-14
                x1 = z * this.polevl(z, this.P1, 8 ) / this.p1evl(z, this.Q1, 8);
            } else {
                x1 = z * this.polevl(z, this.P2, 8) / this.p1evl(z, this.Q2, 8);
            }
            x = x0 - x1;
            if (code !== 0) {
                x = -x;
            }
            return x;
        },

        /**
         * Inverse of error function erf.
         * 
         * @param  {Number} x
         * @returns {Number}
         */
        erfi: function(x) {
            return this.ndtri((x + 1) * 0.5) * this.SQRTH;
        }
    };

    return Mat.ProbFuncs;
});

/*
    Copyright 2008-2022
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Alfred Wassermann

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <http://www.gnu.org/licenses/>
    and <http://opensource.org/licenses/MIT/>.
 */


/*global JXG: true, define: true*/
/*jslint nomen: true, plusplus: true*/

/* depends:
 jxg
 math/math
 utils/type
 */

define('math/ia',['jxg', 'math/math', 'utils/type'], function (JXG, Mat, Type) {

    "use strict";

    JXG.Math.DoubleBits = function() {
        var hasTypedArrays = false,
            DOUBLE_VIEW = new Float64Array(1),
            UINT_VIEW   = new Uint32Array(DOUBLE_VIEW.buffer),
            doubleBitsLE, toDoubleLE, lowUintLE, highUintLE,
            doubleBitsBE, toDoubleBE, lowUintBE, highUintBE,
            doubleBits, toDouble, lowUint, highUint;

        if (Float64Array !== undefined) {

            DOUBLE_VIEW[0] = 1.0;
            hasTypedArrays = true;
            if (UINT_VIEW[1] === 0x3ff00000) {
                // Use little endian
                doubleBitsLE = function(n) {
                    DOUBLE_VIEW[0] = n;
                    return [UINT_VIEW[0], UINT_VIEW[1]];
                };
                toDoubleLE = function(lo, hi) {
                    UINT_VIEW[0] = lo;
                    UINT_VIEW[1] = hi;
                    return DOUBLE_VIEW[0];
                };

                lowUintLE = function(n) {
                    DOUBLE_VIEW[0] = n;
                    return UINT_VIEW[0];
                };

                highUintLE = function(n) {
                    DOUBLE_VIEW[0] = n;
                    return UINT_VIEW[1];
                };

                this.doubleBits = doubleBitsLE;
                this.pack = toDoubleLE;
                this.lo = lowUintLE;
                this.hi = highUintLE;
            } else if (UINT_VIEW[0] === 0x3ff00000) {
                //Use big endian
                doubleBitsBE = function(n) {
                    DOUBLE_VIEW[0] = n;
                    return [UINT_VIEW[1], UINT_VIEW[0]];
                };

                toDoubleBE = function(lo, hi) {
                    UINT_VIEW[1] = lo;
                    UINT_VIEW[0] = hi;
                    return DOUBLE_VIEW[0];
                };

                lowUintBE = function(n) {
                    DOUBLE_VIEW[0] = n;
                    return UINT_VIEW[1];
                };

                highUintBE = function(n) {
                    DOUBLE_VIEW[0] = n;
                    return UINT_VIEW[0];
                };

                this.doubleBits = doubleBitsBE;
                this.pack = toDoubleBE;
                this.lo = lowUintBE;
                this.hi = highUintBE;
            } else {
                hasTypedArrays = false;
            }
        }

        // if (!hasTypedArrays) {
        //     var buffer = new Buffer(8)
        //     doubleBits = function(n) {
        //         buffer.writeDoubleLE(n, 0, true);
        //         return [buffer.readUInt32LE(0, true), buffer.readUInt32LE(4, true)];
        //     };

        //     toDouble = function(lo, hi) {
        //         buffer.writeUInt32LE(lo, 0, true);
        //         buffer.writeUInt32LE(hi, 4, true);
        //         return buffer.readDoubleLE(0, true);
        //     };
        //     lowUint = function(n) {
        //         buffer.writeDoubleLE(n, 0, true);
        //         return buffer.readUInt32LE(0, true);
        //     };

        //     highUint = function(n) {
        //         buffer.writeDoubleLE(n, 0, true);
        //         return buffer.readUInt32LE(4, true);
        //     };

        //     this.doubleBits = doubleBits;
        //     this.pack = toDouble;
        //     this.lo = lowUint;
        //     this.hi = highUint;
        // }
    };

    JXG.extend(JXG.Math.DoubleBits.prototype, /** @lends JXG.Math.DoubleBits.prototype */ {

        sign: function(n) {
            return this.hi(n) >>> 31;
        },

        exponent: function(n) {
            var b = this.hi(n);
            return ((b<<1) >>> 21) - 1023;
        },

        fraction: function(n) {
            var lo = this.lo(n),
                hi = this.hi(n),
                b = hi & ((1<<20) - 1);

            if (hi & 0x7ff00000) {
                b += (1<<20);
            }
            return [lo, b];
        },

        denormalized: function(n) {
            var hi = this.hi(n);
            return !(hi & 0x7ff00000);
        }
    });

    var doubleBits = new JXG.Math.DoubleBits(),

        /**
         * Interval for interval arithmetics. Consists of the properties
         * <ul>
         *  <li>lo
         *  <li>hi
         * </ul>
         * @name JXG.Math.Interval
         * @type Object
         */
        MatInterval = function (lo, hi) {
            if (lo !== undefined && hi !== undefined) {
                // possible cases:
                // - Interval(1, 2)
                // - Interval(Interval(1, 1), Interval(2, 2))     // singletons are required
                if (Mat.IntervalArithmetic.isInterval(lo)) {
                    if (!Mat.IntervalArithmetic.isSingleton(lo)) {
                        throw new TypeError('JXG.Math.IntervalArithmetic: interval `lo` must be a singleton');
                    }
                    this.lo = lo.lo;
                } else {
                    this.lo = lo;
                }
                if (Mat.IntervalArithmetic.isInterval(hi)) {
                    if (!Mat.IntervalArithmetic.isSingleton(hi)) {
                        throw new TypeError('JXG.Math.IntervalArithmetic: interval `hi` must be a singleton');
                    }
                    this.hi = hi.hi;
                } else {
                    this.hi = hi;
                }
            } else if (lo !== undefined) {
                // possible cases:
                // - Interval([1, 2])
                // - Interval([Interval(1, 1), Interval(2, 2)])
                if (Array.isArray(lo)) {
                  return new MatInterval(lo[0], lo[1]);
                }
                // - Interval(1)
                return new MatInterval(lo, lo);
            } else { // This else is necessary even if jslint declares it as redundant
                // possible cases:
                // - Interval()
                this.lo = this.hi = 0;
            }
        };

    JXG.extend(MatInterval.prototype, {
        print: function() {
            console.log('[',this.lo, this.hi,']');
        },

        set: function(lo, hi) {
            this.lo = lo;
            this.hi = hi;
            return this;
        },

        bounded: function(lo, hi) {
            return this.set(Mat.IntervalArithmetic.prev(lo), Mat.IntervalArithmetic.next(hi));
        },

        boundedSingleton: function(v) {
            return this.bounded(v, v);
        },

        assign: function(lo, hi) {
            if (typeof lo !== 'number' || typeof hi !== 'number') {
                throw new TypeError('JXG.Math.Interval#assign: arguments must be numbers');
            }
            if (isNaN(lo) || isNaN(hi) || lo > hi) {
                return this.setEmpty();
            }
            return this.set(lo, hi);
        },

        setEmpty: function() {
            return this.set(Number.POSITIVE_INFINITY, Number.NEGATIVE_INFINITY);
        },

        setWhole: function() {
            return this.set(Number.NEGATIVE_INFINITY, Number.POSITIVE_INFINITY);
        },

        open: function(lo, hi){
            return this.assign(Mat.IntervalArithmetic.next(lo), Mat.IntervalArithmetic.prev(hi));
        },

        halfOpenLeft: function(lo, hi) {
            return this.assign(Mat.IntervalArithmetic.next(lo), hi);
        },

        halfOpenRight: function(lo, hi) {
            return this.assign(lo, Mat.IntervalArithmetic.prev(hi));
        },

        toArray: function() {
            return [this.lo, this.hi];
        },

        clone: function() {
            return new MatInterval().set(this.lo, this.hi);
        }
    });

    /**
     * Object for interval arithmetics.
     * @name JXG.Math.IntervalArithmetic
     * @namespace
     */
    JXG.Math.IntervalArithmetic =  {

        Interval: function(lo, hi) {
            return new MatInterval(lo, hi);
        },

        isInterval: function(i) {
            return i !== null && typeof i === 'object' && typeof i.lo === 'number' && typeof i.hi === 'number';
        },

        isSingleton: function(i) {
            return i.lo === i.hi;
        },

        /*
         * Arithmetics
         */

        /**
         * Addition
         *
         * @param {JXG.Math.Interval|Number} x
         * @param {JXG.Math.Interval|Number} y
         * @returns JXG.Math.Interval
         */
        add: function(x, y) {
            if (Type.isNumber(x)) {
                x = this.Interval(x);
            }
            if (Type.isNumber(y)) {
                y = this.Interval(y);
            }
            return new MatInterval(this.addLo(x.lo, y.lo), this.addHi(x.hi, y.hi));
        },

        /**
         * Subtraction
         *
         * @param {JXG.Math.Interval|Number} x
         * @param {JXG.Math.Interval|Number} y
         * @returns JXG.Math.Interval
         */
         sub: function(x, y) {
            if (Type.isNumber(x)) {
                x = this.Interval(x);
            }
            if (Type.isNumber(y)) {
                y = this.Interval(y);
            }
            return new MatInterval(this.subLo(x.lo, y.hi), this.subHi(x.hi, y.lo));
        },

        /**
         * Multiplication
         *
         * @param {JXG.Math.Interval|Number} x
         * @param {JXG.Math.Interval|Number} y
         * @returns JXG.Math.Interval
         */
         mul: function(x, y) {
            var xl, xh, yl, yh, out;

            if (Type.isNumber(x)) {
                x = this.Interval(x);
            }
            if (Type.isNumber(y)) {
                y = this.Interval(y);
            }

            if (this.isEmpty(x) || this.isEmpty(y)) {
              return this.EMPTY.clone();
            }
            xl = x.lo;
            xh = x.hi;
            yl = y.lo;
            yh = y.hi;
            out = new MatInterval();

            if (xl < 0) {
                if (xh > 0) {
                    if (yl < 0) {
                        if (yh > 0) {
                            // mixed * mixed
                            out.lo = Math.min(this.mulLo(xl, yh), this.mulLo(xh, yl));
                            out.hi = Math.max(this.mulHi(xl, yl), this.mulHi(xh, yh));
                        } else {
                            // mixed * negative
                            out.lo = this.mulLo(xh, yl);
                            out.hi = this.mulHi(xl, yl);
                        }
                    } else {
                        if (yh > 0) {
                            // mixed * positive
                            out.lo = this.mulLo(xl, yh);
                            out.hi = this.mulHi(xh, yh);
                        } else {
                            // mixed * zero
                            out.lo = 0;
                            out.hi = 0;
                        }
                    }
                } else {
                    if (yl < 0) {
                        if (yh > 0) {
                            // negative * mixed
                            out.lo = this.mulLo(xl, yh);
                            out.hi = this.mulHi(xl, yl);
                        } else {
                            // negative * negative
                            out.lo = this.mulLo(xh, yh);
                            out.hi = this.mulHi(xl, yl);
                        }
                    } else {
                        if (yh > 0) {
                            // negative * positive
                            out.lo = this.mulLo(xl, yh);
                            out.hi = this.mulHi(xh, yl);
                        } else {
                            // negative * zero
                            out.lo = 0;
                            out.hi = 0;
                        }
                    }
                }
            } else {
                if (xh > 0) {
                    if (yl < 0) {
                        if (yh > 0) {
                            // positive * mixed
                            out.lo = this.mulLo(xh, yl);
                            out.hi = this.mulHi(xh, yh);
                        } else {
                            // positive * negative
                            out.lo = this.mulLo(xh, yl);
                            out.hi = this.mulHi(xl, yh);
                        }
                    } else {
                        if (yh > 0) {
                            // positive * positive
                            out.lo = this.mulLo(xl, yl);
                            out.hi = this.mulHi(xh, yh);
                        } else {
                            // positive * zero
                            out.lo = 0;
                            out.hi = 0;
                        }
                    }
                } else {
                    // zero * any other value
                    out.lo = 0;
                    out.hi = 0;
                }
            }
            return out;
        },

        /**
         * Division
         *
         * @param {JXG.Math.Interval|Number} x
         * @param {JXG.Math.Interval|Number} y
         * @returns JXG.Math.Interval
         */
         div: function(x, y) {
            if (Type.isNumber(x)) {
                x = this.Interval(x);
            }
            if (Type.isNumber(y)) {
                y = this.Interval(y);
            }

            if (this.isEmpty(x) || this.isEmpty(y)) {
                return this.EMPTY.clone();
            }
            if (this.zeroIn(y)) {
                if (y.lo !== 0) {
                    if (y.hi !== 0) {
                        return this.divZero(x);
                    }
                    return this.divNegative(x, y.lo);
                }
                if (y.hi !== 0) {
                    return this.divPositive(x, y.hi);
                }
                return this.EMPTY.clone();
            }
            return this.divNonZero(x, y);
        },

        /**
         * Return +x (i.e. identity)
         *
         * @param {JXG.Math.Interval} x
         * @returns JXG.Math.Interval
         */
         positive: function(x) {
            return new MatInterval(x.lo, x.hi);
        },

        /**
         * Return -x
         *
         * @param {JXG.Math.Interval} x
         * @returns JXG.Math.Interval
         */
         negative: function(x) {
            if (Type.isNumber(x)) {
                return new MatInterval(-x);
            }
            return new MatInterval(-x.hi, -x.lo);
        },

        /*
         * Utils
         */

        /**
         * Test if interval is empty set.
         * @param {JXG.Math.Interval} i
         * @returns Boolean
         */
        isEmpty: function(i) {
            return i.lo > i.hi;
        },

        /**
         * Test if interval is (-Infinity, Infinity).
         * @param {JXG.Math.Interval} i
         * @returns Boolean
         */
        isWhole: function(i){
            return i.lo === -Infinity && i.hi === Infinity;
        },

        /**
         * Test if interval contains 0.
         * @param {JXG.Math.Interval} i
         * @returns Boolean
         */
         zeroIn: function(i) {
            return this.hasValue(i, 0);
        },

        /**
         * Test if interval contains a specific value.
         * @param {JXG.Math.Interval} i
         * @param {Number} value
         * @returns Boolean
         */
         hasValue: function(i, value) {
            if (this.isEmpty(i)) {
                return false;
            }
            return i.lo <= value && value <= i.hi;
        },

        /**
         * Test if interval x contains interval y.
         * @param {JXG.Math.Interval} x
         * @param {JXG.Math.Interval} y
         * @returns Boolean
         */
         hasInterval: function(x, y) {
            if (this.isEmpty(x)) {
                return true;
            }
            return !this.isEmpty(y) && y.lo <= x.lo && x.hi <= y.hi;
        },

        /**
         * Test if intervals x and y have non-zero intersection.
         * @param {JXG.Math.Interval} x
         * @param {JXG.Math.Interval} y
         * @returns Boolean
         */
         intervalsOverlap: function(x, y) {
            if (this.isEmpty(x) || this.isEmpty(y)) {
                return false;
            }
            return (x.lo <= y.lo && y.lo <= x.hi) || (y.lo <= x.lo && x.lo <= y.hi);
        },

        /*
         * Division
         */
        /**
         * @private
         * @param {JXG.Math.Interval} x
         * @param {JXG.Math.Interval} y
         * @returns JXG.Math.Interval
         */
        divNonZero: function(x, y) {
            var xl = x.lo,
                xh = x.hi,
                yl = y.lo,
                yh = y.hi,
                out = new MatInterval();

            if (xh < 0) {
                if (yh < 0) {
                    out.lo = this.divLo(xh, yl);
                    out.hi = this.divHi(xl, yh);
                } else {
                    out.lo = this.divLo(xl, yl);
                    out.hi = this.divHi(xh, yh);
                }
            } else if (xl < 0) {
                if (yh < 0) {
                    out.lo = this.divLo(xh, yh);
                    out.hi = this.divHi(xl, yh);
                } else {
                    out.lo = this.divLo(xl, yl);
                    out.hi = this.divHi(xh, yl);
                }
            } else {
                if (yh < 0) {
                    out.lo = this.divLo(xh, yh);
                    out.hi = this.divHi(xl, yl);
                } else {
                    out.lo = this.divLo(xl, yh);
                    out.hi = this.divHi(xh, yl);
                }
            }
            return out;
        },

        /**
         * @private
         * @param {JXG.Math.Interval} x
         * @param {JXG.Math.Interval} y
         * @returns JXG.Math.Interval
         */
         divPositive: function(x, v) {
            if (x.lo === 0 && x.hi === 0) {
                return x;
            }

            if (this.zeroIn(x)) {
                // mixed considering zero in both ends
                return this.WHOLE;
            }

            if (x.hi < 0) {
                // negative / v
                return new MatInterval(Number.NEGATIVE_INFINITY, this.divHi(x.hi, v));
            }
            // positive / v
            return new MatInterval(this.divLo(x.lo, v), Number.POSITIVE_INFINITY);
        },

        /**
         * @private
         * @param {JXG.Math.Interval} x
         * @param {JXG.Math.Interval} y
         * @returns JXG.Math.Interval
         */
         divNegative: function(x, v) {
            if (x.lo === 0 && x.hi === 0) {
                return x;
            }

            if (this.zeroIn(x)) {
                // mixed considering zero in both ends
                return this.WHOLE;
            }

            if (x.hi < 0) {
                // negative / v
                return new MatInterval(this.divLo(x.hi, v), Number.POSITIVE_INFINITY);
            }
            // positive / v
            return new MatInterval(Number.NEGATIVE_INFINITY, this.divHi(x.lo, v));
        },

        /**
         * @private
         * @param {JXG.Math.Interval} x
         * @returns JXG.Math.Interval
         */
         divZero: function(x) {
            if (x.lo === 0 && x.hi === 0) {
                return x;
            }
            return this.WHOLE;
        },

        /*
         * Algebra
         */
        /**
         * x mod y:  x - n * y
         * @param {JXG.Math.Interval|Number} x
         * @param {JXG.Math.Interval|Number} y
         * @returns JXG.Math.Interval
         */
        fmod: function(x, y) {
            var yb, n;
            if (Type.isNumber(x)) {
                x = this.Interval(x);
            }
            if (Type.isNumber(y)) {
                y = this.Interval(y);
            }
            if (this.isEmpty(x) || this.isEmpty(y)) {
                return this.EMPTY.clone();
            }
            yb = x.lo < 0 ? y.lo : y.hi;
            n = x.lo / yb;
            if (n < 0) {
                n = Math.ceil(n);
            } else {
                n = Math.floor(n);
            }
            // x mod y = x - n * y
            return this.sub(x, this.mul(y, new MatInterval(n)));
        },

        /**
         * 1 / x
         * @param {JXG.Math.Interval|Number} x
         * @returns JXG.Math.Interval
         */
        multiplicativeInverse: function(x) {
            if (Type.isNumber(x)) {
                x = this.Interval(x);
            }
            if (this.isEmpty(x)) {
                return this.EMPTY.clone();
            }
            if (this.zeroIn(x)) {
                if (x.lo !== 0) {
                    if (x.hi !== 0) {
                        // [negative, positive]
                        return this.WHOLE;
                    }
                    // [negative, zero]
                    return new MatInterval(Number.NEGATIVE_INFINITY, this.divHi(1, x.lo));
                }
                if (x.hi !== 0) {
                    // [zero, positive]
                    return new MatInterval(this.divLo(1, x.hi), Number.POSITIVE_INFINITY);
                }
                // [zero, zero]
                return this.EMPTY.clone();
            }
            // [positive, positive]
            return new MatInterval(this.divLo(1, x.hi), this.divHi(1, x.lo));
        },

        /**
         * x<sup>power</sup>
         * @param {JXG.Math.Interval|Number} x
         * @param {JXG.Math.Interval|Number} power
         * @returns JXG.Math.Interval
         */
        pow: function(x, power) {
            var yl, yh;

            if (Type.isNumber(x)) {
                x = this.Interval(x);
            }
            if (this.isEmpty(x)) {
                return this.EMPTY.clone();
            }
            if (this.isInterval(power)) {
                if (!this.isSingleton(power)) {
                    return this.EMPTY.clone();
                }
                power = power.lo;
            }

            if (power === 0) {
                if (x.lo === 0 && x.hi === 0) {
                    // 0^0
                    return this.EMPTY.clone();
                }
                // x^0
                return this.ONE.clone();
            }
            if (power < 0) {
                // compute [1 / x]^-power if power is negative
                return this.pow(this.multiplicativeInverse(x), -power);
            }

            // power > 0
            if (power % 1 === 0) { // isSafeInteger(power) as boolean) {
                // power is integer
                if (x.hi < 0) {
                    // [negative, negative]
                    // assume that power is even so the operation will yield a positive interval
                    // if not then just switch the sign and order of the interval bounds
                    yl = this.powLo(-x.hi, power);
                    yh = this.powHi(-x.lo, power);
                    if ((power & 1) === 1) {
                        // odd power
                        return new MatInterval(-yh, -yl);
                    }
                    // even power
                    return new MatInterval(yl, yh);
                }
                if (x.lo < 0) {
                    // [negative, positive]
                    if ((power & 1) === 1) {
                        return new MatInterval(-this.powLo(-x.lo, power), this.powHi(x.hi, power));
                    }
                    // even power means that any negative number will be zero (min value = 0)
                    // and the max value will be the max of x.lo^power, x.hi^power
                    return new MatInterval(0, this.powHi(Math.max(-x.lo, x.hi), power));
                }
                // [positive, positive]
                return new MatInterval(this.powLo(x.lo, power), this.powHi(x.hi, power));
            }
            console.warn('power is not an integer, you should use nth-root instead, returning an empty interval');
            return this.EMPTY.clone();
        },

        /**
         * sqrt(x)
         * @param {JXG.Math.Interval|Number} x
         * @returns JXG.Math.Interval
         */
         sqrt: function(x) {
            if (Type.isNumber(x)) {
                x = this.Interval(x);
            }
            return this.nthRoot(x, 2);
        },

        /**
         * x<sup>1/n</sup>
         * @param {JXG.Math.Interval|Number} x
         * @param {Number} n
         * @returns JXG.Math.Interval
         */
        nthRoot: function(x, n) {
            var power,yl, yh, yp, yn;

            if (Type.isNumber(x)) {
                x = this.Interval(x);
            }
            if (this.isEmpty(x) || n < 0) {
              // compute 1 / x^-power if power is negative
              return this.EMPTY.clone();
            }

            // singleton interval check
            if (this.isInterval(n)) {
                if (!this.isSingleton(n)) {
                    return this.EMPTY.clone();
                }
                n = n.lo;
            }

            power = 1 / n;
            if (x.hi < 0) {
                // [negative, negative]
                //if ((isSafeInteger(n) as boolean) && (n & 1) === 1) {
                if (n % 1 === 0 && (n & 1) === 1) {
                    // when n is odd we can always take the nth root
                    yl = this.powHi(-x.lo, power);
                    yh = this.powLo(-x.hi, power);
                    return new MatInterval(-yl, -yh);
                }

                // n is not odd therefore there's no nth root
                return this.EMPTY.clone();
            }
            if (x.lo < 0) {
                // [negative, positive]
                yp = this.powHi(x.hi, power);
                // if ((isSafeInteger(n) as boolean) && (n & 1) === 1) {
                if (n % 1 === 0 && (n & 1) === 1) {
                    // nth root of x.lo is possible (n is odd)
                    yn = -this.powHi(-x.lo, power);
                    return new MatInterval(yn, yp);
                }
                return new MatInterval(0, yp);
            }
            // [positive, positive]
            return new MatInterval(this.powLo(x.lo, power), this.powHi(x.hi, power));
        },

        /*
         * Misc
         */
        /**
         *
         * @param {JXG.Math.Interval|Number} x
         * @returns JXG.Math.Interval
         */
        exp: function(x) {
            if (Type.isNumber(x)) {
                x = this.Interval(x);
            }
            if (this.isEmpty(x)) {
                return this.EMPTY.clone();
            }
            return new MatInterval(this.expLo(x.lo), this.expHi(x.hi));
        },

        /**
         * Natural log
         * @param {JXG.Math.Interval|Number} x
         * @returns JXG.Math.Interval
         */
        log: function(x) {
            var l;
            if (Type.isNumber(x)) {
                x = this.Interval(x);
            }
            if (this.isEmpty(x)) {
                return this.EMPTY.clone();
            }
            l = x.lo <= 0 ? Number.NEGATIVE_INFINITY : this.logLo(x.lo);
            return new MatInterval(l, this.logHi(x.hi));
        },

        /**
         * Natural log, alias for {@link JXG.Math.IntervalArithmetic#log}.
         * @param {JXG.Math.Interval|Number} x
         * @returns JXG.Math.Interval
         */
        ln: function(x) {
            return this.log(x);
        },

        // export const LOG_EXP_10 = this.log(new MatInterval(10, 10))
        // export const LOG_EXP_2 = log(new MatInterval(2, 2))
        /**
         * Logarithm to base 10.
         * @param {JXG.Math.Interval|Number} x
         * @returns JXG.Math.Interval
         */
        log10: function(x) {
            if (this.isEmpty(x)) {
                return this.EMPTY.clone();
            }
            return this.div(this.log(x), this.log(new MatInterval(10, 10)));
        },

        /**
         * Logarithm to base 2.
         * @param {JXG.Math.Interval|Number} x
         * @returns JXG.Math.Interval
         */
        log2: function(x) {
            if (this.isEmpty(x)) {
                return this.EMPTY.clone();
            }
            return this.div(this.log(x), this.log(new MatInterval(2, 2)));
        },

        /**
         * Hull of intervals x and y
         * @param {JXG.Math.Interval} x
         * @param {JXG.Math.Interval} y
         * @returns JXG.Math.Interval
         */
        hull: function(x, y) {
            var badX = this.isEmpty(x),
                badY = this.isEmpty(y);
            if (badX && badY) {
                return this.EMPTY.clone();
            }
            if (badX) {
                return y.clone();
            }
            if (badY) {
                return x.clone();
            }
            return new MatInterval(Math.min(x.lo, y.lo), Math.max(x.hi, y.hi));
        },

        /**
         * Intersection of intervals x and y
         * @param {JXG.Math.Interval} x
         * @param {JXG.Math.Interval} y
         * @returns JXG.Math.Interval
         */
        intersection: function(x, y) {
            var lo, hi;
            if (this.isEmpty(x) || this.isEmpty(y)) {
                return this.EMPTY.clone();
            }
            lo = Math.max(x.lo, y.lo);
            hi = Math.min(x.hi, y.hi);
            if (lo <= hi) {
                return new MatInterval(lo, hi);
            }
            return this.EMPTY.clone();
        },

        /**
         * Union of overlapping intervals x and y
         * @param {JXG.Math.Interval} x
         * @param {JXG.Math.Interval} y
         * @returns JXG.Math.Interval
         */
        union: function(x, y) {
            if (!this.intervalsOverlap(x, y)) {
                throw new Error('Interval#unions do not overlap');
            }
            return new MatInterval(Math.min(x.lo, y.lo), Math.max(x.hi, y.hi));
        },

        /**
         * Difference of overlapping intervals x and y
         * @param {JXG.Math.Interval} x
         * @param {JXG.Math.Interval} y
         * @returns JXG.Math.Interval
         */
        difference: function(x, y) {
            if (this.isEmpty(x) || this.isWhole(y)) {
              return this.EMPTY.clone();
            }
            if (this.intervalsOverlap(x, y)) {
                if (x.lo < y.lo && y.hi < x.hi) {
                    // difference creates multiple subsets
                    throw new Error('Interval.difference: difference creates multiple intervals');
                }

                // handle corner cases first
                if ((y.lo <= x.lo && y.hi === Infinity) || (y.hi >= x.hi && y.lo === -Infinity)) {
                    return this.EMPTY.clone();
                }

                // NOTE: empty interval is handled automatically
                // e.g.
                //
                //    n = difference([0,1], [0,1]) // n = Interval(next(1), 1) = EMPTY
                //    isEmpty(n) === true
                //
                if (y.lo <= x.lo) {
                    return new MatInterval().halfOpenLeft(y.hi, x.hi);
                }

                // y.hi >= x.hi
                return new MatInterval().halfOpenRight(x.lo, y.lo);
            }
            return x.clone();
        },

        /**
         * @param {JXG.Math.Interval} x
         * @returns JXG.Math.Interval
         */
        width: function(x) {
            if (this.isEmpty(x)) {
              return 0;
            }
            return this.subHi(x.hi, x.lo);
        },

        /**
         * @param {JXG.Math.Interval} x
         * @returns JXG.Math.Interval
         */
        abs: function(x) {
            if (Type.isNumber(x)) {
                x = this.Interval(x);
            }
            if (this.isEmpty(x)) {
                return this.EMPTY.clone();
            }
            if (x.lo >= 0) {
                return x.clone();
            }
            if (x.hi <= 0) {
                return this.negative(x);
            }
            return new MatInterval(0, Math.max(-x.lo, x.hi));
        },

        /**
         * @param {JXG.Math.Interval} x
         * @param {JXG.Math.Interval} y
         * @returns JXG.Math.Interval
         */
        max: function(x, y) {
            var badX = this.isEmpty(x),
                badY = this.isEmpty(y);
            if (badX && badY) {
                return this.EMPTY.clone();
            }
            if (badX) {
                return y.clone();
            }
            if (badY) {
                return x.clone();
            }
            return new MatInterval(Math.max(x.lo, y.lo), Math.max(x.hi, y.hi));
        },

        /**
         * @param {JXG.Math.Interval} x
         * @param {JXG.Math.Interval} y
         * @returns JXG.Math.Interval
         */
        min: function(x, y) {
            var badX = this.isEmpty(x),
                badY = this.isEmpty(y);
            if (badX && badY) {
                return this.EMPTY.clone();
            }
            if (badX) {
                return y.clone();
            }
            if (badY) {
                return x.clone();
            }
            return new MatInterval(Math.min(x.lo, y.lo), Math.min(x.hi, y.hi));
        },

        /*
         * Trigonometric
         */
        onlyInfinity: function(x) {
            return !isFinite(x.lo) && x.lo === x.hi;
        },

        _handleNegative: function(interval) {
            var n;
            if (interval.lo < 0) {
                if (interval.lo === -Infinity) {
                    interval.lo = 0;
                    interval.hi = Infinity;
                } else {
                    n = Math.ceil(-interval.lo / this.piTwiceLow);
                    interval.lo += this.piTwiceLow * n;
                    interval.hi += this.piTwiceLow * n;
                }
            }
            return interval;
        },

        /**
         * @param {JXG.Math.Interval} x
         * @returns JXG.Math.Interval
         */
        cos: function(x) {
            var cache, pi2, t, cosv,
                lo, hi, rlo, rhi;

            if (this.isEmpty(x) || this.onlyInfinity(x)) {
                return this.EMPTY.clone();
            }

            // create a clone of `x` because the clone is going to be modified
            cache = new MatInterval().set(x.lo, x.hi);
            this._handleNegative(cache);

            pi2 = this.PI_TWICE;
            t = this.fmod(cache, pi2);
            if (this.width(t) >= pi2.lo) {
                return new MatInterval(-1, 1);
            }

            // when t.lo > pi it's the same as
            // -cos(t - pi)
            if (t.lo >= this.piHigh) {
                cosv = this.cos(this.sub(t, this.PI));
                return this.negative(cosv);
            }

            lo = t.lo;
            hi = t.hi;
            rlo = this.cosLo(hi);
            rhi = this.cosHi(lo);
            // it's ensured that t.lo < pi and that t.lo >= 0
            if (hi <= this.piLow) {
                // when t.hi < pi
                // [cos(t.lo), cos(t.hi)]
                return new MatInterval(rlo, rhi);
            }
            if (hi <= pi2.lo) {
                // when t.hi < 2pi
                // [-1, max(cos(t.lo), cos(t.hi))]
                return new MatInterval(-1, Math.max(rlo, rhi));
            }
            // t.lo < pi and t.hi > 2pi
            return new MatInterval(-1, 1);
        },

        /**
         * @param {JXG.Math.Interval} x
         * @returns JXG.Math.Interval
         */
        sin: function(x) {
            if (this.isEmpty(x) || this.onlyInfinity(x)) {
                return this.EMPTY.clone();
            }
            return this.cos(this.sub(x, this.PI_HALF));
        },

        /**
         * @param {JXG.Math.Interval} x
         * @returns JXG.Math.Interval
         */
        tan: function(x) {
            var cache, t, pi;
            if (this.isEmpty(x) || this.onlyInfinity(x)) {
                return this.EMPTY.clone();
            }

            // create a clone of `x` because the clone is going to be modified
            cache = new MatInterval().set(x.lo, x.hi);
            this._handleNegative(cache);

            pi = this.PI;
            t = this.fmod(cache, pi);
            if (t.lo >= this.piHalfLow) {
                t = this.sub(t, pi);
            }
            if (t.lo <= -this.piHalfLow || t.hi >= this.piHalfLow) {
                return this.WHOLE.clone();
            }
            return new MatInterval(this.tanLo(t.lo), this.tanHi(t.hi));
        },

        /**
         * @param {JXG.Math.Interval} x
         * @returns JXG.Math.Interval
         */
        asin: function(x) {
            var lo, hi;
            if (this.isEmpty(x) || x.hi < -1 || x.lo > 1) {
                return this.EMPTY.clone();
            }
            lo = x.lo <= -1 ? -this.piHalfHigh : this.asinLo(x.lo);
            hi = x.hi >= 1 ? this.piHalfHigh : this.asinHi(x.hi);
            return new MatInterval(lo, hi);
        },

        /**
         * @param {JXG.Math.Interval} x
         * @returns JXG.Math.Interval
         */
        acos: function(x) {
            var lo, hi;
            if (this.isEmpty(x) || x.hi < -1 || x.lo > 1) {
                  return this.EMPTY.clone();
            }
            lo = x.hi >= 1 ? 0 : this.acosLo(x.hi);
            hi = x.lo <= -1 ? this.piHigh : this.acosHi(x.lo);
            return new MatInterval(lo, hi);
        },

        /**
         * @param {JXG.Math.Interval} x
         * @returns JXG.Math.Interval
         */
        atan: function(x) {
            if (this.isEmpty(x)) {
                return this.EMPTY.clone();
            }
            return new MatInterval(this.atanLo(x.lo), this.atanHi(x.hi));
        },

        /**
         * @param {JXG.Math.Interval} x
         * @returns JXG.Math.Interval
         */
        sinh: function(x) {
            if (this.isEmpty(x)) {
                return this.EMPTY.clone();
            }
            return new MatInterval(this.sinhLo(x.lo), this.sinhHi(x.hi));
        },

        /**
         * @param {JXG.Math.Interval} x
         * @returns JXG.Math.Interval
         */
        cosh: function(x) {
            if (this.isEmpty(x)) {
              return this.EMPTY.clone();
            }
            if (x.hi < 0) {
                return new MatInterval(this.coshLo(x.hi), this.coshHi(x.lo));
            }
            if (x.lo >= 0) {
                return new MatInterval(this.coshLo(x.lo), this.coshHi(x.hi));
            }
            return new MatInterval(1, this.coshHi(-x.lo > x.hi ? x.lo : x.hi));
        },

        /**
         * @param {JXG.Math.Interval} x
         * @returns JXG.Math.Interval
         */
        tanh: function(x) {
            if (this.isEmpty(x)) {
                return this.EMPTY.clone();
            }
            return new MatInterval(this.tanhLo(x.lo), this.tanhHi(x.hi));
        },

        /*
         * Relational
         */

        /**
         * @param {JXG.Math.Interval} x
         * @param {JXG.Math.Interval} y
         * @returns Boolean
         */
        equal: function(x, y) {
            if (this.isEmpty(x)) {
                return this.isEmpty(y);
            }
            return !this.isEmpty(y) && x.lo === y.lo && x.hi === y.hi;
        },

        // almostEqual: function(x, y): void {
        //     x = Array.isArray(x) ? x : x.toArray();
        //     y = Array.isArray(y) ? y : y.toArray();
        //     assertEps(x[0], y[0])
        //     assertEps(x[1], y[1])
        // },

        /**
         * @param {JXG.Math.Interval} x
         * @param {JXG.Math.Interval} y
         * @returns Boolean
         */
        notEqual: function(x, y) {
            if (this.isEmpty(x)) {
                return !this.isEmpty(y);
            }
            return this.isEmpty(y) || x.hi < y.lo || x.lo > y.hi;
        },

        /**
         * @param {JXG.Math.Interval} x
         * @param {JXG.Math.Interval} y
         * @returns Boolean
         */
        lt: function(x, y) {
            if (Type.isNumber(x)) {
                x = this.Interval(x);
            }
            if (Type.isNumber(y)) {
                y = this.Interval(y);
            }
            if (this.isEmpty(x) || this.isEmpty(y)) {
                return false;
            }
            return x.hi < y.lo;
        },

        /**
         * @param {JXG.Math.Interval} x
         * @param {JXG.Math.Interval} y
         * @returns Boolean
         */
        gt: function(x, y) {
            if (Type.isNumber(x)) {
                x = this.Interval(x);
            }
            if (Type.isNumber(y)) {
                y = this.Interval(y);
            }
            if (this.isEmpty(x) || this.isEmpty(y)) {
                return false;
            }
            return x.lo > y.hi;
        },

        /**
         * @param {JXG.Math.Interval} x
         * @param {JXG.Math.Interval} y
         * @returns Boolean
         */
        leq: function(x, y) {
            if (Type.isNumber(x)) {
                x = this.Interval(x);
            }
            if (Type.isNumber(y)) {
                y = this.Interval(y);
            }
            if (this.isEmpty(x) || this.isEmpty(y)) {
                return false;
            }
            return x.hi <= y.lo;
        },

        /**
         * @param {JXG.Math.Interval} x
         * @param {JXG.Math.Interval} y
         * @returns Boolean
         */
        geq: function(x, y) {
            if (Type.isNumber(x)) {
                x = this.Interval(x);
            }
            if (Type.isNumber(y)) {
                y = this.Interval(y);
            }
            if (this.isEmpty(x) || this.isEmpty(y)) {
                return false;
            }
            return x.lo >= y.hi;
        },

        /*
         * Constants
         */
        piLow: (3373259426.0 + 273688.0 / (1 << 21)) / (1 << 30),
        piHigh: (3373259426.0 + 273689.0 / (1 << 21)) / (1 << 30),
        piHalfLow: (3373259426.0 + 273688.0 / (1 << 21)) / (1 << 30) * 0.5,
        piHalfHigh: (3373259426.0 + 273689.0 / (1 << 21)) / (1 << 30) * 0.5,
        piTwiceLow: (3373259426.0 + 273688.0 / (1 << 21)) / (1 << 30) * 2,
        piTwiceHigh: (3373259426.0 + 273689.0 / (1 << 21)) / (1 << 30) * 2,

        /*
         * Round
         * Rounding functions for numbers
         */
        identity: function(v) {
            return v;
        },

        _prev: function(v) {
            if (v === Infinity) {
              return v;
            }
            return this.nextafter(v, -Infinity);
        },

        _next: function(v) {
            if (v === -Infinity) {
              return v;
            }
            return this.nextafter(v, Infinity);
        },

        prev: function(v) {
            return this._prev(v);
        },

        next: function(v) {
            return this._next(v);
        },

        toInteger: function(x) {
            return x < 0 ? Math.ceil(x) : Math.floor(x);
        },

        addLo: function(x, y) { return this.prev(x + y); },
        addHi: function(x, y) { return this.next(x + y); },
        subLo: function(x, y) { return this.prev(x - y); },
        subHi: function(x, y) { return this.next(x - y); },
        mulLo: function(x, y) { return this.prev(x * y); },
        mulHi: function(x, y) { return this.next(x * y); },
        divLo: function(x, y) { return this.prev(x / y); },
        divHi: function(x, y) { return this.next(x / y); },
        intLo: function(x) { return this.toInteger(this.prev(x)); },
        intHi: function(x) { return this.toInteger(this.next(x)); },
        logLo: function(x) { return this.prev(Math.log(x)); },
        logHi: function(x) { return this.next(Math.log(x)); },
        expLo: function(x) { return this.prev(Math.exp(x)); },
        expHi: function(x) { return this.next(Math.exp(x)); },
        sinLo: function(x) { return this.prev(Math.sin(x)); },
        sinHi: function(x) { return this.next(Math.sin(x)); },
        cosLo: function(x) { return this.prev(Math.cos(x)); },
        cosHi: function(x) { return this.next(Math.cos(x)); },
        tanLo: function(x) { return this.prev(Math.tan(x)); },
        tanHi: function(x) { return this.next(Math.tan(x)); },
        asinLo: function(x) { return this.prev(Math.asin(x)); },
        asinHi: function(x) { return this.next(Math.asin(x)); },
        acosLo: function(x) { return this.prev(Math.acos(x)); },
        acosHi: function(x) { return this.next(Math.acos(x)); },
        atanLo: function(x) { return this.prev(Math.atan(x)); },
        atanHi: function(x) { return this.next(Math.atan(x)); },
        sinhLo: function(x) { return this.prev(Mat.sinh(x)); },
        sinhHi: function(x) { return this.next(Mat.sinh(x)); },
        coshLo: function(x) { return this.prev(Mat.cosh(x)); },
        coshHi: function(x) { return this.next(Mat.cosh(x)); },
        tanhLo: function(x) { return this.prev(Mat.tanh(x)); },
        tanhHi: function(x) { return this.next(Mat.tanh(x)); },
        sqrtLo: function(x) { return this.prev(Math.sqrt(x)); },
        sqrtHi: function(x) { return this.next(Math.sqrt(x)); },

        powLo: function(x, power) {
            var y;
            if (power % 1 !== 0) {
                // power has decimals
                return this.prev(Math.pow(x, power));
            }

            y = (power & 1) === 1 ? x : 1;
            power >>= 1;
            while (power > 0) {
                x = this.mulLo(x, x);
                if ((power & 1) === 1) {
                    y = this.mulLo(x, y);
                }
                power >>= 1;
            }
            return y;
        },

        powHi: function(x, power) {
            var y;
            if (power % 1 !== 0) {
                // power has decimals
                return this.next(Math.pow(x, power));
            }

            y = (power & 1) === 1 ? x : 1;
            power >>= 1;
            while (power > 0) {
                x = this.mulHi(x, x);
                if ((power & 1) === 1) {
                    y = this.mulHi(x, y);
                }
                power >>= 1;
            }
            return y;
        },

        /**
         * @ignore
         * @private
         */
        disable: function() {
            this.next = this.prev = this.identity;
        },

        /**
         * @ignore
         * @private
         */
         enable: function() {
            this.prev = function(v) {
                return this._prev(v);
            };

            this.next = function(v) {
                return this._next(v);
            };
        },


        /*
         * nextafter
         */
        SMALLEST_DENORM: Math.pow(2, -1074),
        UINT_MAX: (-1)>>>0,

        nextafter: function(x, y) {
            var lo, hi;

            if (isNaN(x) || isNaN(y)) {
                return NaN;
            }
            if (x === y) {
                return x;
            }
            if (x === 0) {
                if (y < 0) {
                    return -this.SMALLEST_DENORM;
                }
                return this.SMALLEST_DENORM;
            }
            hi = doubleBits.hi(x);
            lo = doubleBits.lo(x);
            if ((y > x) === (x > 0)) {
                if (lo === this.UINT_MAX) {
                    hi += 1;
                    lo = 0;
                } else {
                  lo += 1;
                }
            } else {
                if (lo === 0) {
                    lo = this.UINT_MAX;
                    hi -= 1;
                } else {
                    lo -= 1;
                }
            }
            return doubleBits.pack(lo, hi);
        }

    };

    JXG.Math.IntervalArithmetic.PI       = new MatInterval(Mat.IntervalArithmetic.piLow, Mat.IntervalArithmetic.piHigh);
    JXG.Math.IntervalArithmetic.PI_HALF  = new MatInterval(Mat.IntervalArithmetic.piHalfLow, Mat.IntervalArithmetic.piHalfHigh);
    JXG.Math.IntervalArithmetic.PI_TWICE = new MatInterval(Mat.IntervalArithmetic.piTwiceLow, Mat.IntervalArithmetic.piTwiceHigh);
    JXG.Math.IntervalArithmetic.ZERO     = new MatInterval(0);
    JXG.Math.IntervalArithmetic.ONE      = new MatInterval(1);
    JXG.Math.IntervalArithmetic.WHOLE    = new MatInterval().setWhole();
    JXG.Math.IntervalArithmetic.EMPTY    = new MatInterval().setEmpty();

    return JXG.Math.IntervalArithmetic;
});



/*
    Copyright 2008-2022
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Alfred Wassermann

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <http://www.gnu.org/licenses/>
    and <http://opensource.org/licenses/MIT/>.
 */


/*global JXG: true, define: true*/
/*jslint nomen: true, plusplus: true*/

/* depends:
 jxg
 math/math
 utils/type
 */

define('math/extrapolate',['math/math'], function (Mat) {

    "use strict";

    /**
     * Functions for extrapolation of sequences. Used for finding limits of sequences which is used for curve plotting.
     * @name JXG.Math.Extrapolate
     * @exports Mat.Extrapolate as JXG.Math.Extrapolate
     * @namespace
     */
    Mat.Extrapolate = {
        upper: 15,
        infty: 1.e+4,

        /**
         * Wynn's epsilon algorithm. Ported from the FORTRAN version in
         * Ernst Joachim Weniger, "Nonlinear sequence transformations for the acceleration of convergence
         * and the summation of divergent series", Computer Physics Reports Vol. 10, 189-371 (1989).
         *
         * @param {Number} s_n next value of sequence, i.e. n-th element of sequence
         * @param {Number} n index of s_n in the sequence
         * @param {Array} e One-dimensional array containing the extrapolation data. Has to be supplied by the calling routine.
         * @returns {Number} New estimate of the limit of the sequence.
         *
         * @memberof JXG.Math.Extrapolate
         */
        wynnEps: function(s_n, n, e) {
            var HUGE = 1.e+20,
                TINY = 1.e-15,
                f0 = 1, // f0 may be changed to other values, see vanden Broeck, Schwartz (1979)
                f, j, aux1, aux2, diff, estlim;

            e[n] = s_n;
            if (n === 0) {
                estlim = s_n;
            } else {
                aux2 = 0.0;
                for (j = n; j > 0; j--) {
                    aux1 = aux2;
                    aux2 = e[j - 1];
                    diff = e[j] - aux2;
                    if (Math.abs(diff) <= TINY) {
                        e[j - 1] = HUGE;
                    } else {
                        f = ((n - j + 1) % 2 === 1) ? f0 : 1;
                        e[j - 1] = aux1 * f + 1 / diff;
                    }
                }
                estlim = e[n % 2];
            }

            return estlim;
        },

        // wynnRho: function(s_n, n, e) {
        //     var HUGE = 1.e+20,
        //         TINY = 1.e-15,
        //         j, f,
        //         aux1, aux2, diff, estlim;

        //     e[n] = s_n;
        //     if (n === 0) {
        //         estlim = s_n;
        //     } else {
        //         aux2 = 0.0;
        //         for (j = n; j >= 1; j--) {
        //             aux1 = aux2;
        //             aux2 = e[j - 1];
        //             diff = e[j] - aux2;
        //             if (Math.abs(diff) <= TINY) {
        //                 e[j - 1] = HUGE;
        //             } else {
        //                 f = ((n - j + 1) % 2 === 1) ? n - j + 1  : 1;
        //                 e[j - 1] = aux1 + f / diff;
        //             }
        //         }
        //         estlim = e[n % 2];
        //     }

        //     return estlim;
        // },

        /**
         * Aitken transformation. Ported from the FORTRAN version in
         * Ernst Joachim Weniger, "Nonlinear sequence transformations for the acceleration of convergence
         * and the summation of divergent series", Computer Physics Reports Vol. 10, 189-371 (1989).
         *
         * @param {Number} s_n next value of sequence, i.e. n-th element of sequence
         * @param {Number} n index of s_n in the sequence
         * @param {Array} a One-dimensional array containing the extrapolation data. Has to be supplied by the calling routine.
         * @returns {Number} New estimate of the limit of the sequence.
         *
         * @memberof JXG.Math.Extrapolate
         */
        aitken: function(s_n, n, a) {
            var estlim,
                HUGE = 1.e+20,
                TINY = 1.e-15,
                denom, v,
                lowmax, j, m;

            a[n] = s_n;
            if (n < 2) {
                estlim = s_n;
            } else {
                lowmax = n / 2;
                for (j = 1; j <= lowmax; j++) {
                    m = n - 2 * j;
                    denom = a[m + 2] - 2 * a[m + 1] + a[m];
                    if (Math.abs(denom) < TINY) {
                         a[m] = HUGE;
                    } else {
                        v = a[m] - a[m + 1];
                        a[m] -= v * v / denom;
                    }
                }
                estlim = a[n % 2];
            }
            return estlim;
        },

        /**
         * Iterated Brezinski transformation. Ported from the FORTRAN version in
         * Ernst Joachim Weniger, "Nonlinear sequence transformations for the acceleration of convergence
         * and the summation of divergent series", Computer Physics Reports Vol. 10, 189-371 (1989).
         *
         * @param {Number} s_n next value of sequence, i.e. n-th element of sequence
         * @param {Number} n index of s_n in the sequence
         * @param {Array} a One-dimensional array containing the extrapolation data. Has to be supplied by the calling routine.
         * @returns {Number} New estimate of the limit of the sequence.
         *
         * @memberof JXG.Math.Extrapolate
         */
        brezinski: function(s_n, n, a) {
            var estlim,
                HUGE = 1.e+20,
                TINY = 1.e-15,
                denom,
                d0, d1, d2,
                lowmax, j, m;

            a[n] = s_n;
            if (n < 3) {
                estlim = s_n;
            } else {
                lowmax = n / 3;
                m = n;
                for (j = 1; j <= lowmax; j++) {
                    m -= 3;
                    d0 = a[m + 1] - a[m];
                    d1 = a[m + 2] - a[m + 1];
                    d2 = a[m + 3] - a[m + 2];
                    denom = d2 * (d1 - d0) - d0 * (d2 - d1);
                    if (Math.abs(denom) < TINY) {
                        a[m] = HUGE;
                    } else {
                        a[m] = a[m + 1] - d0 * d1 * (d2 - d1) / denom;
                    }
                }
                estlim = a[n % 3];
            }
            return estlim;
        },

        /**
         * Extrapolated iteration to approximate the value f(x_0).
         *
         * @param {Number} x0 Value for which the limit of f is to be determined. f(x0) may or may not exist.
         * @param {Number} h0 Initial (signed) distance from x0.
         * @param {Function} f Function for which the limit at x0 is to be determined
         * @param {String} method String to choose the method. Available values: "wynnEps", "aitken", "brezinski"
         * @param {Number} step_type Approximation method. step_type = 0 uses the sequence x0 + h0/n; step_type = 1 uses the sequence x0 + h0 * 2^(-n)
         *
         * @returns {Array} Array of length 3. Position 0: estimated value for f(x0), position 1: 'finite', 'infinite', or 'NaN'.
         * Position 2: value between 0 and 1 judging the reliability of the result (1: high, 0: not successful).
         *
         * @memberof JXG.Math.Extrapolate
         * @see JXG.Math.Extrapolate.limit
         * @see JXG.Math.Extrapolate.wynnEps
         * @see JXG.Math.Extrapolate.aitken
         * @see JXG.Math.Extrapolate.brezinski
         */
        iteration: function(x0, h0, f, method, step_type) {
            var n, v, w,
                estlim = NaN,
                diff,
                r = 0.5,
                E = [],
                result = 'finite',
                h = h0;

            step_type = step_type || 0;

            for (n = 1; n <= this.upper; n++) {
                h = (step_type === 0) ?  h0 / (n + 1) : h * r;
                v = f(x0 + h, true);

                w = this[method](v, n - 1, E);
//console.log(n, x0 + h, v, w);
                if (isNaN(w)) {
                    result = 'NaN';
                    break;
                }
                if (v !== 0 && w / v > this.infty) {
                    estlim = w;
                    result = 'infinite';
                    break;
                }
                diff = w - estlim;
                if (Math.abs(diff) < 1.e-7) {
                    break;
                }
                estlim = w;
            }
            return [estlim, result, 1 - (n - 1) / this.upper];
        },

        /**
         * Levin transformation. See Numerical Recipes, ed. 3.
         * Not yet ready for use.
         *
         * @param {Number} s_n next value of sequence, i.e. n-th element of sequence
         * @param {Number} n index of s_n in the sequence
         * @param {Array} numer One-dimensional array containing the extrapolation data for the numerator. Has to be supplied by the calling routine.
         * @param {Array} denom One-dimensional array containing the extrapolation data for the denominator. Has to be supplied by the calling routine.
         *
         * @memberof JXG.Math.Extrapolate
        */
        levin: function(s_n, n, omega, beta, numer, denom) {
            var HUGE = 1.e+20,
                TINY = 1.e-15,
                j,
                fact, ratio, term, estlim;

            term = 1.0 / (beta + n);
            numer[n] = s_n / omega;
            denom[n] = 1 / omega;
            if (n > 0) {
                numer[n - 1] = numer[n] - numer[n - 1];
                denom[n - 1] = denom[n] - denom[n - 1];
                if (n > 1) {
                    ratio = (beta + n - 1) * term;
                    for (j = 2; j <= n; j++) {
                        fact = (beta + n - j) * Math.pow(ratio, j - 2) * term;
                        numer[n - j] = numer[n - j + 1] - fact * numer[n - j];
                        denom[n - j] = denom[n - j + 1] - fact * denom[n - j];
                        term *= ratio;
                    }
                }
            }
            if (Math.abs(denom[0]) < TINY) {
                estlim = HUGE;
            } else {
                estlim = numer[0] / denom[0];
            }
            return estlim;
        },

        iteration_levin: function(x0, h0, f, step_type) {
            var n, v, w,
                estlim = NaN,
                v_prev,
                delta, diff, omega,
                beta = 1,
                r = 0.5,
                numer = [],
                denom = [],
                result = 'finite',
                h = h0, transform = 'u';

            step_type = step_type || 0;

            v_prev = f(x0 + h0, true);
            for (n = 1; n <= this.upper; n++) {
                h = (step_type === 0) ?  h0 / (n + 1) : h * r;
                v = f(x0 + h, true);
                delta = v - v_prev;
                if (Math.abs(delta) < 1) {
                    transform = 'u';
                } else {
                    transform = 't';
                }
                if (transform === 'u') {
                    omega = (beta + n) * delta; // u transformation
                } else {
                    omega = delta;              // t transformation
                }

                v_prev = v;
                w = this.levin(v, n - 1, omega, beta, numer, denom);
                diff = w - estlim;
// console.log(n, delta, transform, x0 + h, v, w, diff);

                if (isNaN(w)) {
                    result = 'NaN';
                    break;
                }
                if (v !== 0 && w / v > this.infty) {
                    estlim = w;
                    result = 'infinite';
                    break;
                }
                if (Math.abs(diff) < 1.e-7) {
                    break;
                }
                estlim = w;
            }
            return [estlim, result, 1 - (n - 1) / this.upper];
        },

        /**
         *
         * @param {Number} x0 Value for which the limit of f is to be determined. f(x0) may or may not exist.
         * @param {Number} h0 Initial (signed) distance from x0.
         * @param {Function} f Function for which the limit at x0 is to be determined
         *
         * @returns {Array} Array of length 3. Position 0: estimated value for f(x0), position 1: 'finite', 'infinite', or 'NaN'.
         * Position 2: value between 0 and 1 judging the reliability of the result (1: high, 0: not successful).
         * In case that the extrapolation fails, position 1 and 2 contain 'direct' and 0.
         *
         * @example
         * var f1 = (x) => Math.log(x),
         *     f2 = (x) => Math.tan(x - Math.PI * 0.5),
         *     f3 = (x) => 4 / x;
         *
         * var x0 = 0.0000001;
         * var h = 0.1;
         * for (let f of [f1, f2, f3]) {
         *     console.log("x0=", x0, f.toString());
         *     console.log(JXG.Math.Extrapolate.limit(x0, h, f));
         *  }
         *
         * </pre><div id="JXG5e8c6a7e-eeae-43fb-a669-26b5c9e40cab" class="jxgbox" style="width: 300px; height: 300px;"></div>
         * <script type="text/javascript">
         *     (function() {
         *         var board = JXG.JSXGraph.initBoard('JXG5e8c6a7e-eeae-43fb-a669-26b5c9e40cab',
         *             {boundingbox: [-8, 8, 8,-8], axis: true, showcopyright: false, shownavigation: false});
         *     var f1 = (x) => Math.log(x),
         *         f2 = (x) => Math.tan(x - Math.PI * 0.5),
         *         f3 = (x) => 4 / x;
         *
         *     var x0 = 0.0000001;
         *     var h = 0.1;
         *     for (let f of [f1, f2, f3]) {
         *         console.log("x0=", x0, f.toString());
         *         console.log(JXG.Math.Extrapolate.limit(x0, h, f));
         *      }
         * 
         *     })();
         * 
         * </script><pre>
         *
         *
         * @see JXG.Math.Extrapolate.iteration
         * @memberof JXG.Math.Extrapolate
         */
        limit: function(x0, h0, f) {
            return this.iteration_levin(x0, h0, f, 0);
            //return this.iteration(x0, h0, f, 'wynnEps', 1);

            // var algs = ['wynnEps', 'levin'], //, 'wynnEps', 'levin', 'aitken', 'brezinski'],
            //     le = algs.length,
            //     i, t, res;
            // for (i = 0; i < le; i++) {
            //     for (t = 0; t < 1; t++) {
            //         if (algs[i] === 'levin') {
            //             res = this.iteration_levin(x0, h0, f, t);
            //         } else {
            //             res = this.iteration(x0, h0, f, algs[i], t);
            //         }
            //         if (res[2] > 0.6) {
            //             return res;
            //         }
            //         console.log(algs[i], t, res)
            //     }
            // }
            // return [f(x0 + Math.sign(h0) * Math.sqrt(Mat.eps)), 'direct', 0];
        }
    };

    return Mat.Extrapolate;
});

/*
    Copyright 2008-2022
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <http://www.gnu.org/licenses/>
    and <http://opensource.org/licenses/MIT/>.
 */


/*global JXG:true, define: true*/
/*jslint nomen: true, plusplus: true*/

/* depends:
 math/math
 utils/type
 */

define('math/qdt',['math/math', 'utils/type'], function (Mat, Type) {

    "use strict";

    /**
     * Instantiate a new quad tree.
     *
     * @name JXG.Math.Quadtree
     * @exports Mat.Quadtree as JXG.Math.Quadtree
     * @param {Array} bbox Bounding box of the new quad (sub)tree.
     * @constructor
     */
    Mat.Quadtree = function (bbox) {
        /**
         * The maximum number of points stored in a quad tree node
         * before it is subdivided.
         * @type Number
         * @default 10
         */
        this.capacity = 10;

        /**
         * Point storage.
         * @name JXG.Math.Quadtree#points
         * @type Array
         */
        this.points = [];
        this.xlb = bbox[0];
        this.xub = bbox[2];
        this.ylb = bbox[3];
        this.yub = bbox[1];

        /**
         * In a subdivided quad tree this represents the top left subtree.
         * @name JXG.Math.Quadtree#northWest
         * @type JXG.Math.Quadtree
         */
        this.northWest = null;

        /**
         * In a subdivided quad tree this represents the top right subtree.
         * @name JXG.Math.Quadtree#northEast
         * @type JXG.Math.Quadtree
         */
        this.northEast = null;

        /**
         * In a subdivided quad tree this represents the bottom right subtree.
         * @name JXG.Math.Quadtree#southEast
         * @type JXG.Math.Quadtree
         */
        this.southEast = null;

        /**
         * In a subdivided quad tree this represents the bottom left subtree.
         * @name JXG.Math.Quadtree#southWest
         * @type JXG.Math.Quadtree
         */
        this.southWest = null;
    };

    Type.extend(Mat.Quadtree.prototype, /** @lends JXG.Math.Quadtree.prototype */ {
        /**
         * Checks if the given coordinates are inside the quad tree.
         * @param {Number} x
         * @param {Number} y
         * @returns {Boolean}
         */
        contains: function (x, y) {
            return this.xlb < x && x <= this.xub && this.ylb < y && y <= this.yub;
        },

        /**
         * Insert a new point into this quad tree.
         * @param {JXG.Coords} p
         * @returns {Boolean}
         */
        insert: function (p) {
            if (!this.contains(p.usrCoords[1], p.usrCoords[2])) {
                return false;
            }

            if (this.points.length < this.capacity) {
                this.points.push(p);
                return true;
            }

            if (this.northWest === null) {
                this.subdivide();
            }

            if (this.northWest.insert(p)) {
                return true;
            }

            if (this.northEast.insert(p)) {
                return true;
            }

            if (this.southEast.insert(p)) {
                return true;
            }

            return !!this.southWest.insert(p);


        },

        /**
         * Subdivide the quad tree.
         */
        subdivide: function () {
            var i,
                l = this.points.length,
                mx = this.xlb + (this.xub - this.xlb) / 2,
                my = this.ylb + (this.yub - this.ylb) / 2;

            this.northWest = new Mat.Quadtree([this.xlb, this.yub, mx, my]);
            this.northEast = new Mat.Quadtree([mx, this.yub, this.xub, my]);
            this.southEast = new Mat.Quadtree([this.xlb, my, mx, this.ylb]);
            this.southWest = new Mat.Quadtree([mx, my, this.xub, this.ylb]);

            for (i = 0; i < l; i += 1) {
                this.northWest.insert(this.points[i]);
                this.northEast.insert(this.points[i]);
                this.southEast.insert(this.points[i]);
                this.southWest.insert(this.points[i]);
            }
        },

        /**
         * Internal _query method that lacks adjustment of the parameter.
         * @name JXG.Math.Quadtree#_query
         * @param {Number} x
         * @param {Number} y
         * @returns {Boolean|JXG.Quadtree} The quad tree if the point is found, false
         * if none of the quad trees contains the point (i.e. the point is not inside
         * the root tree's AABB).
         * @private
         */
        _query: function (x, y) {
            var r;

            if (this.contains(x, y)) {
                if (this.northWest === null) {
                    return this;
                }

                r = this.northWest._query(x, y);
                if (r) {
                    return r;
                }

                r = this.northEast._query(x, y);
                if (r) {
                    return r;
                }

                r = this.southEast._query(x, y);
                if (r) {
                    return r;
                }

                r = this.southWest._query(x, y);
                if (r) {
                    return r;
                }
            }

            return false;
        },

        /**
         * Retrieve the smallest quad tree that contains the given point.
         * @name JXG.Math.Quadtree#_query
         * @param {JXG.Coords|Number} xp
         * @param {Number} y
         * @returns {Boolean|JXG.Quadtree} The quad tree if the point is found, false
         * if none of the quad trees contains the point (i.e. the point is not inside
         * the root tree's AABB).
         * @private
         */
        query: function (xp, y) {
            var _x, _y;

            if (Type.exists(y)) {
                _x = xp;
                _y = y;
            } else {
                _x = xp.usrCoords[1];
                _y = xp.usrCoords[2];
            }

            return this._query(_x, _y);
        }
    });

    return Mat.Quadtree;
});

/*
    Copyright 2008-2022
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <http://www.gnu.org/licenses/>
    and <http://opensource.org/licenses/MIT/>.
 */

/*global JXG: true, define: true*/
/*jslint nomen: true, plusplus: true*/
/*eslint no-loss-of-precision: off */

/* depends:
 utils/type
 math/math
 */

/**
 * @fileoverview In this file the namespace Math.Numerics is defined, which holds numerical
 * algorithms for solving linear equations etc.
 */

define('math/numerics',['jxg', 'utils/type', 'utils/env', 'math/math'], function (JXG, Type, Env, Mat) {

    "use strict";

    // Predefined butcher tableaus for the common Runge-Kutta method (fourth order), Heun method (second order), and Euler method (first order).
    var predefinedButcher = {
        rk4: {
            s: 4,
            A: [
                [ 0,  0,  0, 0],
                [0.5, 0,  0, 0],
                [ 0, 0.5, 0, 0],
                [ 0,  0,  1, 0]
            ],
            b: [1.0 / 6.0, 1.0 / 3.0, 1.0 / 3.0, 1.0 / 6.0],
            c: [0, 0.5, 0.5, 1]
        },
        heun: {
            s: 2,
            A: [
                [0, 0],
                [1, 0]
            ],
            b: [0.5, 0.5],
            c: [0, 1]
        },
        euler: {
            s: 1,
            A: [
                [0]
            ],
            b: [1],
            c: [0]
        }
    };

    /**
     * The JXG.Math.Numerics namespace holds numerical algorithms, constants, and variables.
     * @name JXG.Math.Numerics
     * @exports Mat.Numerics as JXG.Math.Numerics
     * @namespace
     */
    Mat.Numerics = {

    //JXG.extend(Mat.Numerics, /** @lends JXG.Math.Numerics */ {
        /**
         * Solves a system of linear equations given by A and b using the Gauss-Jordan-elimination.
         * The algorithm runs in-place. I.e. the entries of A and b are changed.
         * @param {Array} A Square matrix represented by an array of rows, containing the coefficients of the lineare equation system.
         * @param {Array} b A vector containing the linear equation system's right hand side.
         * @throws {Error} If a non-square-matrix is given or if b has not the right length or A's rank is not full.
         * @returns {Array} A vector that solves the linear equation system.
         * @memberof JXG.Math.Numerics
         */
        Gauss: function (A, b) {
            var i, j, k,
                // copy the matrix to prevent changes in the original
                Acopy,
                // solution vector, to prevent changing b
                x,
                eps = Mat.eps,
                // number of columns of A
                n = A.length > 0 ? A[0].length : 0;

            if ((n !== b.length) || (n !== A.length)) {
                throw new Error("JXG.Math.Numerics.Gauss: Dimensions don't match. A must be a square matrix and b must be of the same length as A.");
            }

            // initialize solution vector
            Acopy = [];
            x = b.slice(0, n);

            for (i = 0; i < n; i++) {
                Acopy[i] = A[i].slice(0, n);
            }

            // Gauss-Jordan-elimination
            for (j = 0; j < n; j++) {
                for (i = n - 1; i > j; i--) {
                    // Is the element which is to eliminate greater than zero?
                    if (Math.abs(Acopy[i][j]) > eps) {
                        // Equals pivot element zero?
                        if (Math.abs(Acopy[j][j]) < eps) {
                            // At least numerically, so we have to exchange the rows
                            Type.swap(Acopy, i, j);
                            Type.swap(x, i, j);
                        } else {
                            // Saves the L matrix of the LR-decomposition. unnecessary.
                            Acopy[i][j] /= Acopy[j][j];
                            // Transform right-hand-side b
                            x[i] -= Acopy[i][j] * x[j];

                            // subtract the multiple of A[i][j] / A[j][j] of the j-th row from the i-th.
                            for (k = j + 1; k < n; k++) {
                                Acopy[i][k] -= Acopy[i][j] * Acopy[j][k];
                            }
                        }
                    }
                }

                // The absolute values of all coefficients below the j-th row in the j-th column are smaller than JXG.Math.eps.
                if (Math.abs(Acopy[j][j]) < eps) {
                    throw new Error("JXG.Math.Numerics.Gauss(): The given matrix seems to be singular.");
                }
            }

            this.backwardSolve(Acopy, x, true);

            return x;
        },

        /**
         * Solves a system of linear equations given by the right triangular matrix R and vector b.
         * @param {Array} R Right triangular matrix represented by an array of rows. All entries a_(i,j) with i &lt; j are ignored.
         * @param {Array} b Right hand side of the linear equation system.
         * @param {Boolean} [canModify=false] If true, the right hand side vector is allowed to be changed by this method.
         * @returns {Array} An array representing a vector that solves the system of linear equations.
         * @memberof JXG.Math.Numerics
         */
        backwardSolve: function (R, b, canModify) {
            var x, m, n, i, j;

            if (canModify) {
                x = b;
            } else {
                x = b.slice(0, b.length);
            }

            // m: number of rows of R
            // n: number of columns of R
            m = R.length;
            n = R.length > 0 ? R[0].length : 0;

            for (i = m - 1; i >= 0; i--) {
                for (j = n - 1; j > i; j--) {
                    x[i] -= R[i][j] * x[j];
                }
                x[i] /= R[i][i];
            }

            return x;
        },

        /**
         * @private
         * Gauss-Bareiss algorithm to compute the
         * determinant of matrix without fractions.
         * See Henri Cohen, "A Course in Computational
         * Algebraic Number Theory (Graduate texts
         * in mathematics; 138)", Springer-Verlag,
         * ISBN 3-540-55640-0 / 0-387-55640-0
         * Third, Corrected Printing 1996
         * "Algorithm 2.2.6", pg. 52-53
         * @memberof JXG.Math.Numerics
         */
        gaussBareiss: function (mat) {
            var k, c, s, i, j, p, n, M, t,
                eps = Mat.eps;

            n = mat.length;

            if (n <= 0) {
                return 0;
            }

            if (mat[0].length < n) {
                n = mat[0].length;
            }

            // Copy the input matrix to M
            M = [];

            for (i = 0; i < n; i++) {
                M[i] = mat[i].slice(0, n);
            }

            c = 1;
            s = 1;

            for (k = 0; k < n - 1; k++) {
                p = M[k][k];

                // Pivot step
                if (Math.abs(p) < eps) {
                    for (i = k + 1; i < n; i++) {
                        if (Math.abs(M[i][k]) >= eps) {
                            break;
                        }
                    }

                    // No nonzero entry found in column k -> det(M) = 0
                    if (i === n) {
                        return 0.0;
                    }

                    // swap row i and k partially
                    for (j = k; j < n; j++) {
                        t = M[i][j];
                        M[i][j] = M[k][j];
                        M[k][j] = t;
                    }
                    s = -s;
                    p = M[k][k];
                }

                // Main step
                for (i = k + 1; i < n; i++) {
                    for (j = k + 1; j < n; j++) {
                        t = p * M[i][j] - M[i][k] * M[k][j];
                        M[i][j] = t / c;
                    }
                }

                c = p;
            }

            return s * M[n - 1][n - 1];
        },

        /**
         * Computes the determinant of a square nxn matrix with the
         * Gauss-Bareiss algorithm.
         * @param {Array} mat Matrix.
         * @returns {Number} The determinant pf the matrix mat.
         *                   The empty matrix returns 0.
         * @memberof JXG.Math.Numerics
         */
        det: function (mat) {
            var n = mat.length;

            if (n === 2 && mat[0].length === 2) {
                return mat[0][0] * mat[1][1] - mat[1][0] * mat[0][1];
            }

            return this.gaussBareiss(mat);
        },

        /**
         * Compute the Eigenvalues and Eigenvectors of a symmetric 3x3 matrix with the Jacobi method
         * Adaption of a FORTRAN program by Ed Wilson, Dec. 25, 1990
         * @param {Array} Ain A symmetric 3x3 matrix.
         * @returns {Array} [A,V] the matrices A and V. The diagonal of A contains the Eigenvalues, V contains the Eigenvectors.
         * @memberof JXG.Math.Numerics
         */
        Jacobi: function (Ain) {
            var i, j, k, aa, si, co, tt, ssum, amax,
                eps = Mat.eps * Mat.eps,
                sum = 0.0,
                n = Ain.length,
                V = [
                    [0, 0, 0],
                    [0, 0, 0],
                    [0, 0, 0]
                ],
                A = [
                    [0, 0, 0],
                    [0, 0, 0],
                    [0, 0, 0]
                ],
                nloops = 0;

            // Initialization. Set initial Eigenvectors.
            for (i = 0; i < n; i++) {
                for (j = 0; j < n; j++) {
                    V[i][j] = 0.0;
                    A[i][j] = Ain[i][j];
                    sum += Math.abs(A[i][j]);
                }
                V[i][i] = 1.0;
            }

            // Trivial problems
            if (n === 1) {
                return [A, V];
            }

            if (sum <= 0.0) {
                return [A, V];
            }

            sum /= (n * n);

            // Reduce matrix to diagonal
            do {
                ssum = 0.0;
                amax = 0.0;
                for (j = 1; j < n; j++) {
                    for (i = 0; i < j; i++) {
                        // Check if A[i][j] is to be reduced
                        aa = Math.abs(A[i][j]);

                        if (aa > amax) {
                            amax = aa;
                        }

                        ssum += aa;

                        if (aa >= eps) {
                            // calculate rotation angle
                            aa = Math.atan2(2.0 * A[i][j], A[i][i] - A[j][j]) * 0.5;
                            si = Math.sin(aa);
                            co = Math.cos(aa);

                            // Modify 'i' and 'j' columns
                            for (k = 0; k < n; k++) {
                                tt = A[k][i];
                                A[k][i] = co * tt + si * A[k][j];
                                A[k][j] = -si * tt + co * A[k][j];
                                tt = V[k][i];
                                V[k][i] = co * tt + si * V[k][j];
                                V[k][j] = -si * tt + co * V[k][j];
                            }

                            // Modify diagonal terms
                            A[i][i] = co * A[i][i] + si * A[j][i];
                            A[j][j] = -si * A[i][j] + co * A[j][j];
                            A[i][j] = 0.0;

                            // Make 'A' matrix symmetrical
                            for (k = 0; k < n; k++) {
                                A[i][k] = A[k][i];
                                A[j][k] = A[k][j];
                            }
                            // A[i][j] made zero by rotation
                        }
                    }
                }
                nloops += 1;
            } while (Math.abs(ssum) / sum > eps && nloops < 2000);

            return [A, V];
        },

        /**
         * Calculates the integral of function f over interval using Newton-Cotes-algorithm.
         * @param {Array} interval The integration interval, e.g. [0, 3].
         * @param {function} f A function which takes one argument of type number and returns a number.
         * @param {Object} [config] The algorithm setup. Accepted properties are number_of_nodes of type number and integration_type
         * with value being either 'trapez', 'simpson', or 'milne'.
         * @param {Number} [config.number_of_nodes=28]
         * @param {String} [config.integration_type='milne'] Possible values are 'milne', 'simpson', 'trapez'
         * @returns {Number} Integral value of f over interval
         * @throws {Error} If config.number_of_nodes doesn't match config.integration_type an exception is thrown. If you want to use
         * simpson rule respectively milne rule config.number_of_nodes must be dividable by 2 respectively 4.
         * @example
         * function f(x) {
         *   return x*x;
         * }
         *
         * // calculates integral of <tt>f</tt> from 0 to 2.
         * var area1 = JXG.Math.Numerics.NewtonCotes([0, 2], f);
         *
         * // the same with an anonymous function
         * var area2 = JXG.Math.Numerics.NewtonCotes([0, 2], function (x) { return x*x; });
         *
         * // use trapez rule with 16 nodes
         * var area3 = JXG.Math.Numerics.NewtonCotes([0, 2], f,
         *                                   {number_of_nodes: 16, integration_type: 'trapez'});
         * @memberof JXG.Math.Numerics
         */
        NewtonCotes: function (interval, f, config) {
            var evaluation_point, i, number_of_intervals,
                integral_value = 0.0,
                number_of_nodes = config && Type.isNumber(config.number_of_nodes) ? config.number_of_nodes : 28,
                available_types = {trapez: true, simpson: true, milne: true},
                integration_type = config && config.integration_type && available_types.hasOwnProperty(config.integration_type) && available_types[config.integration_type] ? config.integration_type : 'milne',
                step_size = (interval[1] - interval[0]) / number_of_nodes;

            switch (integration_type) {
            case 'trapez':
                integral_value = (f(interval[0]) + f(interval[1])) * 0.5;
                evaluation_point = interval[0];

                for (i = 0; i < number_of_nodes - 1; i++) {
                    evaluation_point += step_size;
                    integral_value += f(evaluation_point);
                }

                integral_value *= step_size;
                break;
            case 'simpson':
                if (number_of_nodes % 2 > 0) {
                    throw new Error("JSXGraph:  INT_SIMPSON requires config.number_of_nodes dividable by 2.");
                }

                number_of_intervals = number_of_nodes / 2.0;
                integral_value = f(interval[0]) + f(interval[1]);
                evaluation_point = interval[0];

                for (i = 0; i < number_of_intervals - 1; i++) {
                    evaluation_point += 2.0 * step_size;
                    integral_value += 2.0 * f(evaluation_point);
                }

                evaluation_point = interval[0] - step_size;

                for (i = 0; i < number_of_intervals; i++) {
                    evaluation_point += 2.0 * step_size;
                    integral_value += 4.0 * f(evaluation_point);
                }

                integral_value *= step_size / 3.0;
                break;
            default:
                if (number_of_nodes % 4 > 0) {
                    throw new Error("JSXGraph: Error in INT_MILNE: config.number_of_nodes must be a multiple of 4");
                }

                number_of_intervals = number_of_nodes * 0.25;
                integral_value = 7.0 * (f(interval[0]) + f(interval[1]));
                evaluation_point = interval[0];

                for (i = 0; i < number_of_intervals - 1; i++) {
                    evaluation_point += 4.0 * step_size;
                    integral_value += 14.0 * f(evaluation_point);
                }

                evaluation_point = interval[0] - 3.0 * step_size;

                for (i = 0; i < number_of_intervals; i++) {
                    evaluation_point += 4.0 * step_size;
                    integral_value += 32.0 * (f(evaluation_point) + f(evaluation_point + 2 * step_size));
                }

                evaluation_point = interval[0] - 2.0 * step_size;

                for (i = 0; i < number_of_intervals; i++) {
                    evaluation_point += 4.0 * step_size;
                    integral_value += 12.0 * f(evaluation_point);
                }

                integral_value *= 2.0 * step_size / 45.0;
            }
            return integral_value;
        },

       /**
         * Calculates the integral of function f over interval using Romberg iteration.
         * @param {Array} interval The integration interval, e.g. [0, 3].
         * @param {function} f A function which takes one argument of type number and returns a number.
         * @param {Object} [config] The algorithm setup. Accepted properties are max_iterations of type number and precision eps.
         * @param {Number} [config.max_iterations=20]
         * @param {Number} [config.eps=0.0000001]
         * @returns {Number} Integral value of f over interval
         * @example
         * function f(x) {
         *   return x*x;
         * }
         *
         * // calculates integral of <tt>f</tt> from 0 to 2.
         * var area1 = JXG.Math.Numerics.Romberg([0, 2], f);
         *
         * // the same with an anonymous function
         * var area2 = JXG.Math.Numerics.Romberg([0, 2], function (x) { return x*x; });
         *
         * // use trapez rule with maximum of 16 iterations or stop if the precision 0.0001 has been reached.
         * var area3 = JXG.Math.Numerics.Romberg([0, 2], f,
         *                                   {max_iterations: 16, eps: 0.0001});
         * @memberof JXG.Math.Numerics
         */
        Romberg: function (interval, f, config) {
            var a, b, h, s, n,
                k, i, q,
                p = [],
                integral = 0.0,
                last = Infinity,
                m = config && Type.isNumber(config.max_iterations) ? config.max_iterations : 20,
                eps = config && Type.isNumber(config.eps) ? config.eps : config.eps || 0.0000001;

            a = interval[0];
            b = interval[1];
            h = b - a;
            n = 1;

            p[0] = 0.5 * h * (f(a) + f(b));

            for (k = 0; k < m; ++k) {
                s = 0;
                h *= 0.5;
                n *= 2;
                q = 1;

                for (i = 1; i < n; i += 2) {
                    s += f(a + i * h);
                }

                p[k + 1] = 0.5 * p[k] + s * h;

                integral = p[k + 1];
                for (i = k - 1; i >= 0; --i) {
                    q *= 4;
                    p[i] = p[i + 1] + (p[i + 1] - p[i]) / (q - 1.0);
                    integral = p[i];
                }

                if (Math.abs(integral - last) < eps * Math.abs(integral)) {
                    break;
                }
                last = integral;
            }

            return integral;
        },

       /**
         * Calculates the integral of function f over interval using Gauss-Legendre quadrature.
         * @param {Array} interval The integration interval, e.g. [0, 3].
         * @param {function} f A function which takes one argument of type number and returns a number.
         * @param {Object} [config] The algorithm setup. Accepted property is the order n of type number. n is allowed to take
         * values between 2 and 18, default value is 12.
         * @param {Number} [config.n=16]
         * @returns {Number} Integral value of f over interval
         * @example
         * function f(x) {
         *   return x*x;
         * }
         *
         * // calculates integral of <tt>f</tt> from 0 to 2.
         * var area1 = JXG.Math.Numerics.GaussLegendre([0, 2], f);
         *
         * // the same with an anonymous function
         * var area2 = JXG.Math.Numerics.GaussLegendre([0, 2], function (x) { return x*x; });
         *
         * // use 16 point Gauss-Legendre rule.
         * var area3 = JXG.Math.Numerics.GaussLegendre([0, 2], f,
         *                                   {n: 16});
         * @memberof JXG.Math.Numerics
         */
        GaussLegendre: function (interval, f, config) {
            var a, b,
                i, m,
                xp, xm,
                result = 0.0,
                table_xi = [],
                table_w = [],
                xi, w,
                n = config && Type.isNumber(config.n) ? config.n : 12;

            if (n > 18) {
                n = 18;
            }

            /* n = 2 */
            table_xi[2] = [0.5773502691896257645091488];
            table_w[2] = [1.0000000000000000000000000];

            /* n = 4 */
            table_xi[4] = [0.3399810435848562648026658, 0.8611363115940525752239465];
            table_w[4] = [0.6521451548625461426269361, 0.3478548451374538573730639];

            /* n = 6 */
            table_xi[6] = [0.2386191860831969086305017, 0.6612093864662645136613996, 0.9324695142031520278123016];
            table_w[6] = [0.4679139345726910473898703, 0.3607615730481386075698335, 0.1713244923791703450402961];

            /* n = 8 */
            table_xi[8] = [0.1834346424956498049394761, 0.5255324099163289858177390, 0.7966664774136267395915539, 0.9602898564975362316835609];
            table_w[8] = [0.3626837833783619829651504, 0.3137066458778872873379622, 0.2223810344533744705443560, 0.1012285362903762591525314];

            /* n = 10 */
            table_xi[10] = [0.1488743389816312108848260, 0.4333953941292471907992659, 0.6794095682990244062343274, 0.8650633666889845107320967, 0.9739065285171717200779640];
            table_w[10] = [0.2955242247147528701738930, 0.2692667193099963550912269, 0.2190863625159820439955349, 0.1494513491505805931457763, 0.0666713443086881375935688];

            /* n = 12 */
            table_xi[12] = [0.1252334085114689154724414, 0.3678314989981801937526915, 0.5873179542866174472967024, 0.7699026741943046870368938, 0.9041172563704748566784659, 0.9815606342467192506905491];
            table_w[12] = [0.2491470458134027850005624, 0.2334925365383548087608499, 0.2031674267230659217490645, 0.1600783285433462263346525, 0.1069393259953184309602547, 0.0471753363865118271946160];

            /* n = 14 */
            table_xi[14] = [0.1080549487073436620662447, 0.3191123689278897604356718, 0.5152486363581540919652907, 0.6872929048116854701480198, 0.8272013150697649931897947, 0.9284348836635735173363911, 0.9862838086968123388415973];
            table_w[14] = [0.2152638534631577901958764, 0.2051984637212956039659241, 0.1855383974779378137417166, 0.1572031671581935345696019, 0.1215185706879031846894148, 0.0801580871597602098056333, 0.0351194603317518630318329];

            /* n = 16 */
            table_xi[16] = [0.0950125098376374401853193, 0.2816035507792589132304605, 0.4580167776572273863424194, 0.6178762444026437484466718, 0.7554044083550030338951012, 0.8656312023878317438804679, 0.9445750230732325760779884, 0.9894009349916499325961542];
            table_w[16] = [0.1894506104550684962853967, 0.1826034150449235888667637, 0.1691565193950025381893121, 0.1495959888165767320815017, 0.1246289712555338720524763, 0.0951585116824927848099251, 0.0622535239386478928628438, 0.0271524594117540948517806];

            /* n = 18 */
            table_xi[18] = [0.0847750130417353012422619, 0.2518862256915055095889729, 0.4117511614628426460359318, 0.5597708310739475346078715, 0.6916870430603532078748911, 0.8037049589725231156824175, 0.8926024664975557392060606, 0.9558239495713977551811959, 0.9915651684209309467300160];
            table_w[18] = [0.1691423829631435918406565, 0.1642764837458327229860538, 0.1546846751262652449254180, 0.1406429146706506512047313, 0.1225552067114784601845191, 0.1009420441062871655628140, 0.0764257302548890565291297, 0.0497145488949697964533349, 0.0216160135264833103133427];

            /* n = 3 */
            table_xi[3] = [0.0000000000000000000000000, 0.7745966692414833770358531];
            table_w[3] = [0.8888888888888888888888889, 0.5555555555555555555555556];

            /* n = 5 */
            table_xi[5] = [0.0000000000000000000000000, 0.5384693101056830910363144, 0.9061798459386639927976269];
            table_w[5] = [0.5688888888888888888888889, 0.4786286704993664680412915, 0.2369268850561890875142640];

            /* n = 7 */
            table_xi[7] = [0.0000000000000000000000000, 0.4058451513773971669066064, 0.7415311855993944398638648, 0.9491079123427585245261897];
            table_w[7] = [0.4179591836734693877551020, 0.3818300505051189449503698, 0.2797053914892766679014678, 0.1294849661688696932706114];

            /* n = 9 */
            table_xi[9] = [0.0000000000000000000000000, 0.3242534234038089290385380, 0.6133714327005903973087020, 0.8360311073266357942994298, 0.9681602395076260898355762];
            table_w[9] = [0.3302393550012597631645251, 0.3123470770400028400686304, 0.2606106964029354623187429, 0.1806481606948574040584720, 0.0812743883615744119718922];

            /* n = 11 */
            table_xi[11] = [0.0000000000000000000000000, 0.2695431559523449723315320, 0.5190961292068118159257257, 0.7301520055740493240934163, 0.8870625997680952990751578, 0.9782286581460569928039380];
            table_w[11] = [0.2729250867779006307144835, 0.2628045445102466621806889, 0.2331937645919904799185237, 0.1862902109277342514260976, 0.1255803694649046246346943, 0.0556685671161736664827537];

            /* n = 13 */
            table_xi[13] = [0.0000000000000000000000000, 0.2304583159551347940655281, 0.4484927510364468528779129, 0.6423493394403402206439846, 0.8015780907333099127942065, 0.9175983992229779652065478, 0.9841830547185881494728294];
            table_w[13] = [0.2325515532308739101945895, 0.2262831802628972384120902, 0.2078160475368885023125232, 0.1781459807619457382800467, 0.1388735102197872384636018, 0.0921214998377284479144218, 0.0404840047653158795200216];

            /* n = 15 */
            table_xi[15] = [0.0000000000000000000000000, 0.2011940939974345223006283, 0.3941513470775633698972074, 0.5709721726085388475372267, 0.7244177313601700474161861, 0.8482065834104272162006483, 0.9372733924007059043077589, 0.9879925180204854284895657];
            table_w[15] = [0.2025782419255612728806202, 0.1984314853271115764561183, 0.1861610000155622110268006, 0.1662692058169939335532009, 0.1395706779261543144478048, 0.1071592204671719350118695, 0.0703660474881081247092674, 0.0307532419961172683546284];

            /* n = 17 */
            table_xi[17] = [0.0000000000000000000000000, 0.1784841814958478558506775, 0.3512317634538763152971855, 0.5126905370864769678862466, 0.6576711592166907658503022, 0.7815140038968014069252301, 0.8802391537269859021229557, 0.9506755217687677612227170, 0.9905754753144173356754340];
            table_w[17] = [0.1794464703562065254582656, 0.1765627053669926463252710, 0.1680041021564500445099707, 0.1540457610768102880814316, 0.1351363684685254732863200, 0.1118838471934039710947884, 0.0850361483171791808835354, 0.0554595293739872011294402, 0.0241483028685479319601100];

            a = interval[0];
            b = interval[1];

            //m = Math.ceil(n * 0.5);
            m = (n + 1) >> 1;

            xi = table_xi[n];
            w = table_w[n];

            xm = 0.5 * (b - a);
            xp = 0.5 * (b + a);

            if (n & 1 === 1) { // n odd
                result = w[0] * f(xp);
                for (i = 1; i < m; ++i) {
                    result += w[i] * (f(xp + xm * xi[i]) + f(xp - xm * xi[i]));
                }
            } else { // n even
                result = 0.0;
                for (i = 0; i < m; ++i) {
                    result += w[i] * (f(xp + xm * xi[i]) + f(xp - xm * xi[i]));
                }
            }

            return xm * result;
        },

        /**
         * Scale error in Gauss Kronrod quadrature.
         * Internal method used in {@link JXG.Math.Numerics._gaussKronrod}.
         * @private
         */
        _rescale_error: function (err, result_abs, result_asc) {
            var scale, min_err,
                DBL_MIN = 2.2250738585072014e-308,
                DBL_EPS = 2.2204460492503131e-16;

            err = Math.abs(err);
            if (result_asc !== 0 && err !== 0) {
                scale = Math.pow((200 * err / result_asc), 1.5);

                if (scale < 1.0) {
                    err = result_asc * scale;
                } else {
                    err = result_asc;
                }
            }
            if (result_abs > DBL_MIN / (50 * DBL_EPS)) {
                min_err = 50 * DBL_EPS * result_abs;

                if (min_err > err) {
                    err = min_err;
                }
            }

            return err;
        },

        /**
         * Generic Gauss-Kronrod quadrature algorithm.
         * Internal method used in {@link JXG.Math.Numerics.GaussKronrod15},
         * {@link JXG.Math.Numerics.GaussKronrod21},
         * {@link JXG.Math.Numerics.GaussKronrod31}.
         * Taken from QUADPACK.
         *
         * @param {Array} interval The integration interval, e.g. [0, 3].
         * @param {function} f A function which takes one argument of type number and returns a number.
         * @param {Number} n order
         * @param {Array} xgk Kronrod quadrature abscissae
         * @param {Array} wg Weights of the Gauss rule
         * @param {Array} wgk Weights of the Kronrod rule
         * @param {Object} resultObj Object returning resultObj.abserr, resultObj.resabs, resultObj.resasc.
         * See the library QUADPACK for an explanation.
         *
         * @returns {Number} Integral value of f over interval
         *
         * @private
         */
        _gaussKronrod: function (interval, f, n, xgk, wg, wgk, resultObj) {
            var a = interval[0],
                b = interval[1],
                up,
                result,

                center = 0.5 * (a + b),
                half_length = 0.5 * (b - a),
                abs_half_length = Math.abs(half_length),
                f_center = f(center),

                result_gauss = 0.0,
                result_kronrod = f_center * wgk[n - 1],

                result_abs = Math.abs(result_kronrod),
                result_asc = 0.0,
                mean = 0.0,
                err = 0.0,

                j, jtw, abscissa, fval1, fval2, fsum,
                jtwm1,
                fv1 = [], fv2 = [];

            if (n % 2 === 0) {
                result_gauss = f_center * wg[n / 2 - 1];
            }

            up = Math.floor((n - 1) / 2);
            for (j = 0; j < up; j++) {
                jtw = j * 2 + 1;  // in original fortran j=1,2,3 jtw=2,4,6
                abscissa = half_length * xgk[jtw];
                fval1 = f(center - abscissa);
                fval2 = f(center + abscissa);
                fsum = fval1 + fval2;
                fv1[jtw] = fval1;
                fv2[jtw] = fval2;
                result_gauss += wg[j] * fsum;
                result_kronrod += wgk[jtw] * fsum;
                result_abs += wgk[jtw] * (Math.abs(fval1) + Math.abs(fval2));
            }

            up = Math.floor(n / 2);
            for (j = 0; j < up; j++) {
                jtwm1 = j * 2;
                abscissa = half_length * xgk[jtwm1];
                fval1 = f(center - abscissa);
                fval2 = f(center + abscissa);
                fv1[jtwm1] = fval1;
                fv2[jtwm1] = fval2;
                result_kronrod += wgk[jtwm1] * (fval1 + fval2);
                result_abs += wgk[jtwm1] * (Math.abs(fval1) + Math.abs(fval2));
            }

            mean = result_kronrod * 0.5;
            result_asc = wgk[n - 1] * Math.abs(f_center - mean);

            for (j = 0; j < n - 1; j++) {
                result_asc += wgk[j] * (Math.abs(fv1[j] - mean) + Math.abs(fv2[j] - mean));
            }

            // scale by the width of the integration region
            err = (result_kronrod - result_gauss) * half_length;

            result_kronrod *= half_length;
            result_abs *= abs_half_length;
            result_asc *= abs_half_length;
            result = result_kronrod;

            resultObj.abserr = this._rescale_error(err, result_abs, result_asc);
            resultObj.resabs = result_abs;
            resultObj.resasc = result_asc;

            return result;
        },

        /**
         * 15 point Gauss-Kronrod quadrature algorithm, see the library QUADPACK
         * @param {Array} interval The integration interval, e.g. [0, 3].
         * @param {function} f A function which takes one argument of type number and returns a number.
         * @param {Object} resultObj Object returning resultObj.abserr, resultObj.resabs, resultObj.resasc. See the library
         *  QUADPACK for an explanation.
         *
         * @returns {Number} Integral value of f over interval
         *
         * @memberof JXG.Math.Numerics
         */
        GaussKronrod15: function (interval, f, resultObj) {
            /* Gauss quadrature weights and kronrod quadrature abscissae and
                weights as evaluated with 80 decimal digit arithmetic by
                L. W. Fullerton, Bell Labs, Nov. 1981. */

            var xgk =    /* abscissae of the 15-point kronrod rule */
                    [
                        0.991455371120812639206854697526329,
                        0.949107912342758524526189684047851,
                        0.864864423359769072789712788640926,
                        0.741531185599394439863864773280788,
                        0.586087235467691130294144838258730,
                        0.405845151377397166906606412076961,
                        0.207784955007898467600689403773245,
                        0.000000000000000000000000000000000
                    ],

            /* xgk[1], xgk[3], ... abscissae of the 7-point gauss rule.
                xgk[0], xgk[2], ... abscissae to optimally extend the 7-point gauss rule */

                wg =     /* weights of the 7-point gauss rule */
                    [
                        0.129484966168869693270611432679082,
                        0.279705391489276667901467771423780,
                        0.381830050505118944950369775488975,
                        0.417959183673469387755102040816327
                    ],

                wgk =    /* weights of the 15-point kronrod rule */
                    [
                        0.022935322010529224963732008058970,
                        0.063092092629978553290700663189204,
                        0.104790010322250183839876322541518,
                        0.140653259715525918745189590510238,
                        0.169004726639267902826583426598550,
                        0.190350578064785409913256402421014,
                        0.204432940075298892414161999234649,
                        0.209482141084727828012999174891714
                    ];

            return this._gaussKronrod(interval, f, 8, xgk, wg, wgk, resultObj);
        },

        /**
         * 21 point Gauss-Kronrod quadrature algorithm, see the library QUADPACK
         * @param {Array} interval The integration interval, e.g. [0, 3].
         * @param {function} f A function which takes one argument of type number and returns a number.
         * @param {Object} resultObj Object returning resultObj.abserr, resultObj.resabs, resultObj.resasc. See the library
         *  QUADPACK for an explanation.
         *
         * @returns {Number} Integral value of f over interval
         *
         * @memberof JXG.Math.Numerics
         */
        GaussKronrod21: function (interval, f, resultObj) {
            /* Gauss quadrature weights and kronrod quadrature abscissae and
                weights as evaluated with 80 decimal digit arithmetic by
                L. W. Fullerton, Bell Labs, Nov. 1981. */

            var xgk =   /* abscissae of the 21-point kronrod rule */
                    [
                        0.995657163025808080735527280689003,
                        0.973906528517171720077964012084452,
                        0.930157491355708226001207180059508,
                        0.865063366688984510732096688423493,
                        0.780817726586416897063717578345042,
                        0.679409568299024406234327365114874,
                        0.562757134668604683339000099272694,
                        0.433395394129247190799265943165784,
                        0.294392862701460198131126603103866,
                        0.148874338981631210884826001129720,
                        0.000000000000000000000000000000000
                    ],

                /* xgk[1], xgk[3], ... abscissae of the 10-point gauss rule.
                xgk[0], xgk[2], ... abscissae to optimally extend the 10-point gauss rule */
                wg =     /* weights of the 10-point gauss rule */
                    [
                        0.066671344308688137593568809893332,
                        0.149451349150580593145776339657697,
                        0.219086362515982043995534934228163,
                        0.269266719309996355091226921569469,
                        0.295524224714752870173892994651338
                    ],

                wgk =   /* weights of the 21-point kronrod rule */
                    [
                        0.011694638867371874278064396062192,
                        0.032558162307964727478818972459390,
                        0.054755896574351996031381300244580,
                        0.075039674810919952767043140916190,
                        0.093125454583697605535065465083366,
                        0.109387158802297641899210590325805,
                        0.123491976262065851077958109831074,
                        0.134709217311473325928054001771707,
                        0.142775938577060080797094273138717,
                        0.147739104901338491374841515972068,
                        0.149445554002916905664936468389821
                    ];

            return this._gaussKronrod(interval, f, 11, xgk, wg, wgk, resultObj);
        },

        /**
         * 31 point Gauss-Kronrod quadrature algorithm, see the library QUADPACK
         * @param {Array} interval The integration interval, e.g. [0, 3].
         * @param {function} f A function which takes one argument of type number and returns a number.
         * @param {Object} resultObj Object returning resultObj.abserr, resultObj.resabs, resultObj.resasc. See the library
         *  QUADPACK for an explanation.
         *
         * @returns {Number} Integral value of f over interval
         *
         * @memberof JXG.Math.Numerics
         */
        GaussKronrod31: function (interval, f, resultObj) {
            /* Gauss quadrature weights and kronrod quadrature abscissae and
                weights as evaluated with 80 decimal digit arithmetic by
                L. W. Fullerton, Bell Labs, Nov. 1981. */

            var xgk =   /* abscissae of the 21-point kronrod rule */
                    [
                        0.998002298693397060285172840152271,
                        0.987992518020485428489565718586613,
                        0.967739075679139134257347978784337,
                        0.937273392400705904307758947710209,
                        0.897264532344081900882509656454496,
                        0.848206583410427216200648320774217,
                        0.790418501442465932967649294817947,
                        0.724417731360170047416186054613938,
                        0.650996741297416970533735895313275,
                        0.570972172608538847537226737253911,
                        0.485081863640239680693655740232351,
                        0.394151347077563369897207370981045,
                        0.299180007153168812166780024266389,
                        0.201194093997434522300628303394596,
                        0.101142066918717499027074231447392,
                        0.000000000000000000000000000000000
                    ],

                /* xgk[1], xgk[3], ... abscissae of the 10-point gauss rule.
                xgk[0], xgk[2], ... abscissae to optimally extend the 10-point gauss rule */
                wg =     /* weights of the 10-point gauss rule */
                    [
                        0.030753241996117268354628393577204,
                        0.070366047488108124709267416450667,
                        0.107159220467171935011869546685869,
                        0.139570677926154314447804794511028,
                        0.166269205816993933553200860481209,
                        0.186161000015562211026800561866423,
                        0.198431485327111576456118326443839,
                        0.202578241925561272880620199967519
                    ],

                wgk =   /* weights of the 21-point kronrod rule */
                    [
                        0.005377479872923348987792051430128,
                        0.015007947329316122538374763075807,
                        0.025460847326715320186874001019653,
                        0.035346360791375846222037948478360,
                        0.044589751324764876608227299373280,
                        0.053481524690928087265343147239430,
                        0.062009567800670640285139230960803,
                        0.069854121318728258709520077099147,
                        0.076849680757720378894432777482659,
                        0.083080502823133021038289247286104,
                        0.088564443056211770647275443693774,
                        0.093126598170825321225486872747346,
                        0.096642726983623678505179907627589,
                        0.099173598721791959332393173484603,
                        0.100769845523875595044946662617570,
                        0.101330007014791549017374792767493
                    ];

            return this._gaussKronrod(interval, f, 16, xgk, wg, wgk, resultObj);
        },

        /**
         * Generate workspace object for {@link JXG.Math.Numerics.Qag}.
         * @param {Array} interval The integration interval, e.g. [0, 3].
         * @param {Number} n Max. limit
         * @returns {Object} Workspace object
         *
         * @private
         * @memberof JXG.Math.Numerics
         */
        _workspace: function (interval, n) {
            return {
                limit: n,
                size: 0,
                nrmax: 0,
                i: 0,
                alist: [interval[0]],
                blist: [interval[1]],
                rlist: [0.0],
                elist: [0.0],
                order: [0],
                level: [0],

                qpsrt: function () {
                    var last = this.size - 1,
                        limit = this.limit,
                        errmax, errmin, i, k, top,
                        i_nrmax = this.nrmax,
                        i_maxerr = this.order[i_nrmax];

                    /* Check whether the list contains more than two error estimates */
                    if (last < 2) {
                        this.order[0] = 0;
                        this.order[1] = 1;
                        this.i = i_maxerr;
                        return;
                    }

                    errmax = this.elist[i_maxerr];

                    /* This part of the routine is only executed if, due to a difficult
                        integrand, subdivision increased the error estimate. In the normal
                        case the insert procedure should start after the nrmax-th largest
                        error estimate. */
                    while (i_nrmax > 0 && errmax > this.elist[this.order[i_nrmax - 1]]) {
                        this.order[i_nrmax] = this.order[i_nrmax - 1];
                        i_nrmax--;
                    }

                    /* Compute the number of elements in the list to be maintained in
                        descending order. This number depends on the number of
                        subdivisions still allowed. */
                    if (last < (limit / 2 + 2)) {
                        top = last;
                    } else {
                        top = limit - last + 1;
                    }

                    /* Insert errmax by traversing the list top-down, starting
                        comparison from the element elist(order(i_nrmax+1)). */
                    i = i_nrmax + 1;

                    /* The order of the tests in the following line is important to
                        prevent a segmentation fault */
                    while (i < top && errmax < this.elist[this.order[i]]) {
                        this.order[i - 1] = this.order[i];
                        i++;
                    }

                    this.order[i - 1] = i_maxerr;

                    /* Insert errmin by traversing the list bottom-up */
                    errmin = this.elist[last];
                    k = top - 1;

                    while (k > i - 2 && errmin >= this.elist[this.order[k]]) {
                        this.order[k + 1] = this.order[k];
                        k--;
                    }

                    this.order[k + 1] = last;

                    /* Set i_max and e_max */
                    i_maxerr = this.order[i_nrmax];
                    this.i = i_maxerr;
                    this.nrmax = i_nrmax;
                },

                set_initial_result: function (result, error) {
                    this.size = 1;
                    this.rlist[0] = result;
                    this.elist[0] = error;
                },

                update: function (a1, b1, area1, error1, a2, b2, area2, error2) {
                    var i_max = this.i,
                        i_new = this.size,
                        new_level = this.level[this.i] + 1;

                    /* append the newly-created intervals to the list */

                    if (error2 > error1) {
                        this.alist[i_max] = a2;        /* blist[maxerr] is already == b2 */
                        this.rlist[i_max] = area2;
                        this.elist[i_max] = error2;
                        this.level[i_max] = new_level;

                        this.alist[i_new] = a1;
                        this.blist[i_new] = b1;
                        this.rlist[i_new] = area1;
                        this.elist[i_new] = error1;
                        this.level[i_new] = new_level;
                    } else {
                        this.blist[i_max] = b1;        /* alist[maxerr] is already == a1 */
                        this.rlist[i_max] = area1;
                        this.elist[i_max] = error1;
                        this.level[i_max] = new_level;

                        this.alist[i_new] = a2;
                        this.blist[i_new] = b2;
                        this.rlist[i_new] = area2;
                        this.elist[i_new] = error2;
                        this.level[i_new] = new_level;
                    }

                    this.size++;

                    if (new_level > this.maximum_level) {
                        this.maximum_level = new_level;
                    }

                    this.qpsrt();
                },

                retrieve: function() {
                    var i = this.i;
                    return {
                        a: this.alist[i],
                        b: this.blist[i],
                        r: this.rlist[i],
                        e: this.elist[i]
                    };
                },

                sum_results: function () {
                    var nn = this.size,
                        k,
                        result_sum = 0.0;

                    for (k = 0; k < nn; k++) {
                        result_sum += this.rlist[k];
                    }

                    return result_sum;
                },

                subinterval_too_small: function (a1, a2,  b2) {
                    var e = 2.2204460492503131e-16,
                        u = 2.2250738585072014e-308,
                        tmp = (1 + 100 * e) * (Math.abs(a2) + 1000 * u);

                    return Math.abs(a1) <= tmp && Math.abs(b2) <= tmp;
                }

            };
        },

        /**
         * Quadrature algorithm qag from QUADPACK.
         * Internal method used in {@link JXG.Math.Numerics.GaussKronrod15},
         * {@link JXG.Math.Numerics.GaussKronrod21},
         * {@link JXG.Math.Numerics.GaussKronrod31}.
         *
         * @param {Array} interval The integration interval, e.g. [0, 3].
         * @param {function} f A function which takes one argument of type number and returns a number.
         * @param {Object} [config] The algorithm setup. Accepted propert are max. recursion limit of type number,
         * and epsrel and epsabs, the relative and absolute required precision of type number. Further,
         * q the internal quadrature sub-algorithm of type function.
         * @param {Number} [config.limit=15]
         * @param {Number} [config.epsrel=0.0000001]
         * @param {Number} [config.epsabs=0.0000001]
         * @param {Number} [config.q=JXG.Math.Numerics.GaussKronrod15]
         * @returns {Number} Integral value of f over interval
         *
         * @example
         * function f(x) {
         *   return x*x;
         * }
         *
         * // calculates integral of <tt>f</tt> from 0 to 2.
         * var area1 = JXG.Math.Numerics.Qag([0, 2], f);
         *
         * // the same with an anonymous function
         * var area2 = JXG.Math.Numerics.Qag([0, 2], function (x) { return x*x; });
         *
         * // use JXG.Math.Numerics.GaussKronrod31 rule as sub-algorithm.
         * var area3 = JXG.Math.Numerics.Quag([0, 2], f,
         *                                   {q: JXG.Math.Numerics.GaussKronrod31});
         * @memberof JXG.Math.Numerics
         */
        Qag: function (interval, f, config) {
            var DBL_EPS = 2.2204460492503131e-16,
                ws = this._workspace(interval, 1000),

                limit = config && Type.isNumber(config.limit) ? config.limit : 15,
                epsrel = config && Type.isNumber(config.epsrel) ? config.epsrel : 0.0000001,
                epsabs = config && Type.isNumber(config.epsabs) ? config.epsabs : 0.0000001,
                q = config && Type.isFunction(config.q) ? config.q : this.GaussKronrod15,

                resultObj = {},
                area, errsum,
                result0, abserr0, resabs0, resasc0,
                result,
                tolerance,
                iteration = 0,
                roundoff_type1 = 0, roundoff_type2 = 0, error_type = 0,
                round_off,

                a1, b1, a2, b2,
                a_i, b_i, r_i, e_i,
                area1 = 0, area2 = 0, area12 = 0,
                error1 = 0, error2 = 0, error12 = 0,
                resasc1, resasc2,
                // resabs1, resabs2,
                wsObj,
                delta;


            if (limit > ws.limit) {
                JXG.warn('iteration limit exceeds available workspace');
            }
            if (epsabs <= 0 && (epsrel < 50 * Mat.eps || epsrel < 0.5e-28)) {
                JXG.warn('tolerance cannot be acheived with given epsabs and epsrel');
            }

            result0 = q.apply(this, [interval, f, resultObj]);
            abserr0 = resultObj.abserr;
            resabs0 = resultObj.resabs;
            resasc0 = resultObj.resasc;

            ws.set_initial_result(result0, abserr0);
            tolerance = Math.max(epsabs, epsrel * Math.abs(result0));
            round_off = 50 * DBL_EPS * resabs0;

            if (abserr0 <= round_off && abserr0 > tolerance) {
                result = result0;
                // abserr = abserr0;

                JXG.warn('cannot reach tolerance because of roundoff error on first attempt');
                return -Infinity;
            }

            if ((abserr0 <= tolerance && abserr0 !== resasc0) || abserr0 === 0.0) {
                result = result0;
                // abserr = abserr0;

                return result;
            }

            if (limit === 1) {
                result = result0;
                // abserr = abserr0;

                JXG.warn('a maximum of one iteration was insufficient');
                return -Infinity;
            }

            area = result0;
            errsum = abserr0;
            iteration = 1;

            do {
                area1 = 0;
                area2 = 0;
                area12 = 0;
                error1 = 0;
                error2 = 0;
                error12 = 0;

                /* Bisect the subinterval with the largest error estimate */
                wsObj = ws.retrieve();
                a_i = wsObj.a;
                b_i = wsObj.b;
                r_i = wsObj.r;
                e_i = wsObj.e;

                a1 = a_i;
                b1 = 0.5 * (a_i + b_i);
                a2 = b1;
                b2 = b_i;

                area1 = q.apply(this, [[a1, b1], f, resultObj]);
                error1 = resultObj.abserr;
                // resabs1 = resultObj.resabs;
                resasc1 = resultObj.resasc;

                area2 = q.apply(this, [[a2, b2], f, resultObj]);
                error2 = resultObj.abserr;
                // resabs2 = resultObj.resabs;
                resasc2 = resultObj.resasc;

                area12 = area1 + area2;
                error12 = error1 + error2;

                errsum += (error12 - e_i);
                area += area12 - r_i;

                if (resasc1 !== error1 && resasc2 !== error2) {
                    delta = r_i - area12;
                    if (Math.abs(delta) <= 1.0e-5 * Math.abs(area12) && error12 >= 0.99 * e_i) {
                        roundoff_type1++;
                    }
                    if (iteration >= 10 && error12 > e_i) {
                        roundoff_type2++;
                    }
                }

                tolerance = Math.max(epsabs, epsrel * Math.abs(area));

                if (errsum > tolerance) {
                    if (roundoff_type1 >= 6 || roundoff_type2 >= 20) {
                        error_type = 2;   /* round off error */
                    }

                /* set error flag in the case of bad integrand behaviour at
                    a point of the integration range */

                    if (ws.subinterval_too_small(a1, a2, b2)) {
                        error_type = 3;
                    }
                }

                ws.update(a1, b1, area1, error1, a2, b2, area2, error2);
                wsObj = ws.retrieve();
                a_i = wsObj.a_i;
                b_i = wsObj.b_i;
                r_i = wsObj.r_i;
                e_i = wsObj.e_i;

                iteration++;

            } while (iteration < limit && !error_type && errsum > tolerance);

            result = ws.sum_results();
            // abserr = errsum;
/*
  if (errsum <= tolerance)
    {
      return GSL_SUCCESS;
    }
  else if (error_type == 2)
    {
      GSL_ERROR ("roundoff error prevents tolerance from being achieved",
                 GSL_EROUND);
    }
  else if (error_type == 3)
    {
      GSL_ERROR ("bad integrand behavior found in the integration interval",
                 GSL_ESING);
    }
  else if (iteration == limit)
    {
      GSL_ERROR ("maximum number of subdivisions reached", GSL_EMAXITER);
    }
  else
    {
      GSL_ERROR ("could not integrate function", GSL_EFAILED);
    }
*/

            return result;
        },

        /**
         * Integral of function f over interval.
         * @param {Array} interval The integration interval, e.g. [0, 3].
         * @param {function} f A function which takes one argument of type number and returns a number.
         * @returns {Number} The value of the integral of f over interval
         * @see JXG.Math.Numerics.NewtonCotes
         * @see JXG.Math.Numerics.Romberg
         * @see JXG.Math.Numerics.Qag
         * @memberof JXG.Math.Numerics
         */
        I: function (interval, f) {
            // return this.NewtonCotes(interval, f, {number_of_nodes: 16, integration_type: 'milne'});
            // return this.Romberg(interval, f, {max_iterations: 20, eps: 0.0000001});
            return this.Qag(interval, f, {q: this.GaussKronrod15, limit: 15, epsrel: 0.0000001, epsabs: 0.0000001});
        },

        /**
         * Newton's method to find roots of a funtion in one variable.
         * @param {function} f We search for a solution of f(x)=0.
         * @param {Number} x initial guess for the root, i.e. start value.
         * @param {Object} context optional object that is treated as "this" in the function body. This is useful if
         * the function is a method of an object and contains a reference to its parent object via "this".
         * @returns {Number} A root of the function f.
         * @memberof JXG.Math.Numerics
         */
        Newton: function (f, x, context) {
            var df,
                i = 0,
                h = Mat.eps,
                newf = f.apply(context, [x]);
                // nfev = 1;

            // For compatibility
            if (Type.isArray(x)) {
                x = x[0];
            }

            while (i < 50 && Math.abs(newf) > h) {
                df = this.D(f, context)(x);
                // nfev += 2;

                if (Math.abs(df) > h) {
                    x -= newf / df;
                } else {
                    x += (Math.random() * 0.2 - 1.0);
                }

                newf = f.apply(context, [x]);
                // nfev += 1;
                i += 1;
            }

            return x;
        },

        /**
         * Abstract method to find roots of univariate functions, which - for the time being -
         * is an alias for {@link JXG.Math.Numerics.chandrupatla}.
         * @param {function} f We search for a solution of f(x)=0.
         * @param {Number|Array} x initial guess for the root, i.e. starting value, or start interval enclosing the root.
         * @param {Object} context optional object that is treated as "this" in the function body. This is useful if
         * the function is a method of an object and contains a reference to its parent object via "this".
         * @returns {Number} A root of the function f.
         *
         * @see JXG.Math.Numerics.chandrupatla
         * @see JXG.Math.Numerics.fzero
         * @memberof JXG.Math.Numerics
         */
        root: function (f, x, context) {
            //return this.fzero(f, x, context);
            return this.chandrupatla(f, x, context);
        },

        /**
         * Compute an intersection of the curves c1 and c2
         * with a generalized Newton method.
         * We want to find values t1, t2 such that
         * c1(t1) = c2(t2), i.e.
         * (c1_x(t1)-c2_x(t2),c1_y(t1)-c2_y(t2)) = (0,0).
         * We set
         * (e,f) := (c1_x(t1)-c2_x(t2),c1_y(t1)-c2_y(t2))
         *
         * The Jacobian J is defined by
         * J = (a, b)
         *     (c, d)
         * where
         * a = c1_x'(t1)
         * b = -c2_x'(t2)
         * c = c1_y'(t1)
         * d = -c2_y'(t2)
         *
         * The inverse J^(-1) of J is equal to
         *  (d, -b)/
         *  (-c, a) / (ad-bc)
         *
         * Then, (t1new, t2new) := (t1,t2) - J^(-1)*(e,f).
         * If the function meetCurveCurve possesses the properties
         * t1memo and t2memo then these are taken as start values
         * for the Newton algorithm.
         * After stopping of the Newton algorithm the values of t1 and t2 are stored in
         * t1memo and t2memo.
         *
         * @param {JXG.Curve} c1 Curve, Line or Circle
         * @param {JXG.Curve} c2 Curve, Line or Circle
         * @param {Number} t1ini start value for t1
         * @param {Number} t2ini start value for t2
         * @returns {JXG.Coords} intersection point
         * @memberof JXG.Math.Numerics
         */
        generalizedNewton: function (c1, c2, t1ini, t2ini) {
            var t1, t2,
                a, b, c, d, disc,
                e, f, F,
                D00, D01,
                D10, D11,
                count = 0;

            if (this.generalizedNewton.t1memo) {
                t1 = this.generalizedNewton.t1memo;
                t2 = this.generalizedNewton.t2memo;
            } else {
                t1 = t1ini;
                t2 = t2ini;
            }

            e = c1.X(t1) - c2.X(t2);
            f = c1.Y(t1) - c2.Y(t2);
            F = e * e + f * f;

            D00 = this.D(c1.X, c1);
            D01 = this.D(c2.X, c2);
            D10 = this.D(c1.Y, c1);
            D11 = this.D(c2.Y, c2);

            while (F > Mat.eps && count < 10) {
                a = D00(t1);
                b = -D01(t2);
                c = D10(t1);
                d = -D11(t2);
                disc = a * d - b * c;
                t1 -= (d * e - b * f) / disc;
                t2 -= (a * f - c * e) / disc;
                e = c1.X(t1) - c2.X(t2);
                f = c1.Y(t1) - c2.Y(t2);
                F = e * e + f * f;
                count += 1;
            }

            this.generalizedNewton.t1memo = t1;
            this.generalizedNewton.t2memo = t2;

            if (Math.abs(t1) < Math.abs(t2)) {
                return [c1.X(t1), c1.Y(t1)];
            }

            return [c2.X(t2), c2.Y(t2)];
        },

        /**
         * Returns the Lagrange polynomials for curves with equidistant nodes, see
         * Jean-Paul Berrut, Lloyd N. Trefethen: Barycentric Lagrange Interpolation,
         * SIAM Review, Vol 46, No 3, (2004) 501-517.
         * The graph of the parametric curve [x(t),y(t)] runs through the given points.
         * @param {Array} p Array of JXG.Points
         * @returns {Array} An array consisting of two functions x(t), y(t) which define a parametric curve
         * f(t) = (x(t), y(t)), a number x1 (which equals 0) and a function x2 defining the curve's domain.
         * That means the curve is defined between x1 and x2(). x2 returns the (length of array p minus one).
         * @memberof JXG.Math.Numerics
         *
         * @example
         * var p = [];
         *
         * p[0] = board.create('point', [0, -2], {size:2, name: 'C(a)'});
         * p[1] = board.create('point', [-1.5, 5], {size:2, name: ''});
         * p[2] = board.create('point', [1, 4], {size:2, name: ''});
         * p[3] = board.create('point', [3, 3], {size:2, name: 'C(b)'});
         *
         * // Curve
         * var fg = JXG.Math.Numerics.Neville(p);
         * var graph = board.create('curve', fg, {strokeWidth:3, strokeOpacity:0.5});
         *
         * </pre><div id="JXG88a8b3a8-6561-44f5-a678-76bca13fd484" class="jxgbox" style="width: 300px; height: 300px;"></div>
         * <script type="text/javascript">
         *     (function() {
         *         var board = JXG.JSXGraph.initBoard('JXG88a8b3a8-6561-44f5-a678-76bca13fd484',
         *             {boundingbox: [-8, 8, 8,-8], axis: true, showcopyright: false, shownavigation: false});
         *     var p = [];
         *
         *     p[0] = board.create('point', [0, -2], {size:2, name: 'C(a)'});
         *     p[1] = board.create('point', [-1.5, 5], {size:2, name: ''});
         *     p[2] = board.create('point', [1, 4], {size:2, name: ''});
         *     p[3] = board.create('point', [3, 3], {size:2, name: 'C(b)'});
         *
         *     // Curve
         *     var fg = JXG.Math.Numerics.Neville(p);
         *     var graph = board.create('curve', fg, {strokeWidth:3, strokeOpacity:0.5});
         *
         *     })();
         *
         * </script><pre>
         *
         */
        Neville: function (p) {
            var w = [],
                /** @ignore */
                makeFct = function (fun) {
                    return function (t, suspendedUpdate) {
                        var i, d, s,
                            bin = Mat.binomial,
                            len = p.length,
                            len1 = len - 1,
                            num = 0.0,
                            denom = 0.0;

                        if (!suspendedUpdate) {
                            s = 1;
                            for (i = 0; i < len; i++) {
                                w[i] = bin(len1, i) * s;
                                s *= (-1);
                            }
                        }

                        d = t;

                        for (i = 0; i < len; i++) {
                            if (d === 0) {
                                return p[i][fun]();
                            }
                            s = w[i] / d;
                            d -= 1;
                            num += p[i][fun]() * s;
                            denom += s;
                        }
                        return num / denom;
                    };
                },

                xfct = makeFct('X'),
                yfct = makeFct('Y');

            return [xfct, yfct, 0, function () {
                return p.length - 1;
            }];
        },

        /**
         * Calculates second derivatives at the given knots.
         * @param {Array} x x values of knots
         * @param {Array} y y values of knots
         * @returns {Array} Second derivatives of the interpolated function at the knots.
         * @see #splineEval
         * @memberof JXG.Math.Numerics
         */
        splineDef: function (x, y) {
            var pair, i, l,
                n = Math.min(x.length, y.length),
                diag = [],
                z = [],
                data = [],
                dx = [],
                delta = [],
                F = [];

            if (n === 2) {
                return [0, 0];
            }

            for (i = 0; i < n; i++) {
                pair = {X: x[i], Y: y[i]};
                data.push(pair);
            }
            data.sort(function (a, b) {
                return a.X - b.X;
            });
            for (i = 0; i < n; i++) {
                x[i] = data[i].X;
                y[i] = data[i].Y;
            }

            for (i = 0; i < n - 1; i++) {
                dx.push(x[i + 1] - x[i]);
            }
            for (i = 0; i < n - 2; i++) {
                delta.push(6 * (y[i + 2] - y[i + 1]) / (dx[i + 1]) - 6 * (y[i + 1] - y[i]) / (dx[i]));
            }

            // ForwardSolve
            diag.push(2 * (dx[0] + dx[1]));
            z.push(delta[0]);

            for (i = 0; i < n - 3; i++) {
                l = dx[i + 1] / diag[i];
                diag.push(2 * (dx[i + 1] + dx[i + 2]) - l * dx[i + 1]);
                z.push(delta[i + 1] - l * z[i]);
            }

            // BackwardSolve
            F[n - 3] = z[n - 3] / diag[n - 3];
            for (i = n - 4; i >= 0; i--) {
                F[i] = (z[i] - (dx[i + 1] * F[i + 1])) / diag[i];
            }

            // Generate f''-Vector
            for (i = n - 3; i >= 0; i--) {
                F[i + 1] = F[i];
            }

            // natural cubic spline
            F[0] = 0;
            F[n - 1] = 0;

            return F;
        },

        /**
         * Evaluate points on spline.
         * @param {Number,Array} x0 A single float value or an array of values to evaluate
         * @param {Array} x x values of knots
         * @param {Array} y y values of knots
         * @param {Array} F Second derivatives at knots, calculated by {@link JXG.Math.Numerics.splineDef}
         * @see #splineDef
         * @returns {Number,Array} A single value or an array, depending on what is given as x0.
         * @memberof JXG.Math.Numerics
         */
        splineEval: function (x0, x, y, F) {
            var i, j, a, b, c, d, x_,
                n = Math.min(x.length, y.length),
                l = 1,
                asArray = false,
                y0 = [];

            // number of points to be evaluated
            if (Type.isArray(x0)) {
                l = x0.length;
                asArray = true;
            } else {
                x0 = [x0];
            }

            for (i = 0; i < l; i++) {
                // is x0 in defining interval?
                if ((x0[i] < x[0]) || (x[i] > x[n - 1])) {
                    return NaN;
                }

                // determine part of spline in which x0 lies
                for (j = 1; j < n; j++) {
                    if (x0[i] <= x[j]) {
                        break;
                    }
                }

                j -= 1;

                // we're now in the j-th partial interval, i.e. x[j] < x0[i] <= x[j+1];
                // determine the coefficients of the polynomial in this interval
                a = y[j];
                b = (y[j + 1] - y[j]) / (x[j + 1] - x[j]) - (x[j + 1] - x[j]) / 6 * (F[j + 1] + 2 * F[j]);
                c = F[j] / 2;
                d = (F[j + 1] - F[j]) / (6 * (x[j + 1] - x[j]));
                // evaluate x0[i]
                x_ = x0[i] - x[j];
                //y0.push(a + b*x_ + c*x_*x_ + d*x_*x_*x_);
                y0.push(a + (b + (c + d * x_) * x_) * x_);
            }

            if (asArray) {
                return y0;
            }

            return y0[0];
        },

        /**
         * Generate a string containing the function term of a polynomial.
         * @param {Array} coeffs Coefficients of the polynomial. The position i belongs to x^i.
         * @param {Number} deg Degree of the polynomial
         * @param {String} varname Name of the variable (usually 'x')
         * @param {Number} prec Precision
         * @returns {String} A string containg the function term of the polynomial.
         * @memberof JXG.Math.Numerics
         */
        generatePolynomialTerm: function (coeffs, deg, varname, prec) {
            var i, t = [];

            for (i = deg; i >= 0; i--) {
                t = t.concat(['(', coeffs[i].toPrecision(prec), ')']);

                if (i > 1) {
                    t = t.concat(['*', varname, '<sup>', i, '<', '/sup> + ']);
                } else if (i === 1) {
                    t = t.concat(['*', varname, ' + ']);
                }
            }

            return t.join('');
        },

        /**
         * Computes the polynomial through a given set of coordinates in Lagrange form.
         * Returns the Lagrange polynomials, see
         * Jean-Paul Berrut, Lloyd N. Trefethen: Barycentric Lagrange Interpolation,
         * SIAM Review, Vol 46, No 3, (2004) 501-517.
         * <p>
         * It possesses the method getTerm() which returns the string containing the function term of the polynomial.
         * @param {Array} p Array of JXG.Points
         * @returns {function} A function of one parameter which returns the value of the polynomial, whose graph runs through the given points.
         * @memberof JXG.Math.Numerics
         *
         * @example
         * var p = [];
         * p[0] = board.create('point', [-1,2], {size:4});
         * p[1] = board.create('point', [0,3], {size:4});
         * p[2] = board.create('point', [1,1], {size:4});
         * p[3] = board.create('point', [3,-1], {size:4});
         * var f = JXG.Math.Numerics.lagrangePolynomial(p);
         * var graph = board.create('functiongraph', [f,-10, 10], {strokeWidth:3});
         *
         * </pre><div id="JXGc058aa6b-74d4-41e1-af94-df06169a2d89" class="jxgbox" style="width: 300px; height: 300px;"></div>
         * <script type="text/javascript">
         *     (function() {
         *         var board = JXG.JSXGraph.initBoard('JXGc058aa6b-74d4-41e1-af94-df06169a2d89',
         *             {boundingbox: [-8, 8, 8,-8], axis: true, showcopyright: false, shownavigation: false});
         *     var p = [];
         *     p[0] = board.create('point', [-1,2], {size:4});
         *     p[1] = board.create('point', [0,3], {size:4});
         *     p[2] = board.create('point', [1,1], {size:4});
         *     p[3] = board.create('point', [3,-1], {size:4});
         *     var f = JXG.Math.Numerics.lagrangePolynomial(p);
         *     var graph = board.create('functiongraph', [f,-10, 10], {strokeWidth:3});
         *
         *     })();
         *
         * </script><pre>
         *
         * @example
         * var points = [];
         * points[0] = board.create('point', [-1,2], {size:4});
         * points[1] = board.create('point', [0, 0], {size:4});
         * points[2] = board.create('point', [2, 1], {size:4});
         *
         * var f = JXG.Math.Numerics.lagrangePolynomial(points);
         * var graph = board.create('functiongraph', [f,-10, 10], {strokeWidth:3});
         * var txt = board.create('text', [-3, -4,  () => f.getTerm(2, 't', ' * ')], {fontSize: 16});
         *
         * </pre><div id="JXG73fdaf12-e257-4374-b488-ae063e4eecbb" class="jxgbox" style="width: 300px; height: 300px;"></div>
         * <script type="text/javascript">
         *     (function() {
         *         var board = JXG.JSXGraph.initBoard('JXG73fdaf12-e257-4374-b488-ae063e4eecbb',
         *             {boundingbox: [-8, 8, 8,-8], axis: true, showcopyright: false, shownavigation: false});
         *     var points = [];
         *     points[0] = board.create('point', [-1,2], {size:4});
         *     points[1] = board.create('point', [0, 0], {size:4});
         *     points[2] = board.create('point', [2, 1], {size:4});
         *
         *     var f = JXG.Math.Numerics.lagrangePolynomial(points);
         *     var graph = board.create('functiongraph', [f,-10, 10], {strokeWidth:3});
         *     var txt = board.create('text', [-3, -4,  () => f.getTerm(2, 't', ' * ')], {fontSize: 16});
         *
         *     })();
         *
         * </script><pre>
         *
         */
        lagrangePolynomial: function (p) {
            var w = [],
                that = this,
                /** @ignore */
                fct = function (x, suspendedUpdate) {
                    var i, // j,
                        k, xi, s, //M,
                        len = p.length,
                        num = 0,
                        denom = 0;

                    if (!suspendedUpdate) {
                        for (i = 0; i < len; i++) {
                            w[i] = 1.0;
                            xi = p[i].X();

                            for (k = 0; k < len; k++) {
                                if (k !== i) {
                                    w[i] *= (xi - p[k].X());
                                }
                            }

                            w[i] = 1 / w[i];
                        }

                        // M = [];
                        // for (k = 0; k < len; k++) {
                        //     M.push([1]);
                        // }
                    }

                    for (i = 0; i < len; i++) {
                        xi = p[i].X();

                        if (x === xi) {
                            return p[i].Y();
                        }

                        s = w[i] / (x - xi);
                        denom += s;
                        num += s * p[i].Y();
                    }

                    return num / denom;
                };

            /**
             * Get the term of the Lagrange polynomial as string.
             * Calls {@link JXG.Math.Numerics#lagrangePolynomialTerm}.
             *
             * @name JXG.Math.Numerics#lagrangePolynomial.getTerm
             * @param {Number} digits Number of digits of the coefficients
             * @param {String} param Variable name
             * @param {String} dot Dot symbol
             * @returns {String} containing the term of Lagrange polynomial as string.
             * @see JXG.Math.Numerics#lagrangePolynomialTerm
             * @example
             * var points = [];
             * points[0] = board.create('point', [-1,2], {size:4});
             * points[1] = board.create('point', [0, 0], {size:4});
             * points[2] = board.create('point', [2, 1], {size:4});
             *
             * var f = JXG.Math.Numerics.lagrangePolynomial(points);
             * var graph = board.create('functiongraph', [f,-10, 10], {strokeWidth:3});
             * var txt = board.create('text', [-3, -4,  () => f.getTerm(2, 't', ' * ')], {fontSize: 16});
             *
             * </pre><div id="JXG73fdaf12-e257-4374-b488-ae063e4eeccf" class="jxgbox" style="width: 300px; height: 300px;"></div>
             * <script type="text/javascript">
             *     (function() {
             *         var board = JXG.JSXGraph.initBoard('JXG73fdaf12-e257-4374-b488-ae063e4eeccf',
             *             {boundingbox: [-8, 8, 8,-8], axis: true, showcopyright: false, shownavigation: false});
             *     var points = [];
             *     points[0] = board.create('point', [-1,2], {size:4});
             *     points[1] = board.create('point', [0, 0], {size:4});
             *     points[2] = board.create('point', [2, 1], {size:4});
             *
             *     var f = JXG.Math.Numerics.lagrangePolynomial(points);
             *     var graph = board.create('functiongraph', [f,-10, 10], {strokeWidth:3});
             *     var txt = board.create('text', [-3, -4,  () => f.getTerm(2, 't', ' * ')], {fontSize: 16});
             *
             *     })();
             *
             * </script><pre>
             *
             */
            fct.getTerm = function(digits, param, dot) {
                return that.lagrangePolynomialTerm(p, digits, param, dot)();
            };

            return fct;
        },
        // fct.getTerm = that.lagrangePolynomialTerm(p, 2, 'x');

        /**
         * Determine the Lagrange polynomial through an array of points and
         * return the term of the polynomial as string.
         *
         * @param {Array} points Array of JXG.Points
         * @param {Number} digits Number of decimal digits of the coefficients
         * @param {String} param Name of the parameter. Default: 'x'.
         * @param {String} dot Multiplication symbol. Default: ' * '.
         * @returns {String} containing the Lagrange polynomial through
         *    the supplied points.
         * @memberof JXG.Math.Numerics
         *
         * @example
         * var points = [];
         * points[0] = board.create('point', [-1,2], {size:4});
         * points[1] = board.create('point', [0, 0], {size:4});
         * points[2] = board.create('point', [2, 1], {size:4});
         *
         * var f = JXG.Math.Numerics.lagrangePolynomial(points);
         * var graph = board.create('functiongraph', [f,-10, 10], {strokeWidth:3});
         *
         * var f_txt = JXG.Math.Numerics.lagrangePolynomialTerm(points, 2, 't', ' * ');
         * var txt = board.create('text', [-3, -4, f_txt], {fontSize: 16});
         *
         * </pre><div id="JXGd45e9e96-7526-486d-aa43-e1178d5f2baa" class="jxgbox" style="width: 300px; height: 300px;"></div>
         * <script type="text/javascript">
         *     (function() {
         *         var board = JXG.JSXGraph.initBoard('JXGd45e9e96-7526-486d-aa43-e1178d5f2baa',
         *             {boundingbox: [-8, 8, 8,-8], axis: true, showcopyright: false, shownavigation: false});
         *     var points = [];
         *     points[0] = board.create('point', [-1,2], {size:4});
         *     points[1] = board.create('point', [0, 0], {size:4});
         *     points[2] = board.create('point', [2, 1], {size:4});
         *
         *     var f = JXG.Math.Numerics.lagrangePolynomial(points);
         *     var graph = board.create('functiongraph', [f,-10, 10], {strokeWidth:3});
         *
         *     var f_txt = JXG.Math.Numerics.lagrangePolynomialTerm(points, 2, 't', ' * ');
         *     var txt = board.create('text', [-3, -4, f_txt], {fontSize: 16});
         *
         *     })();
         *
         * </script><pre>
         *
         */
        lagrangePolynomialTerm: function(points, digits, param, dot) {
            return function() {
                var len = points.length,
                    zeroes = [],
                    coeffs = [],
                    coeffs_sum = [],
                    isLeading = true,
                    n, t,
                    i, j, c, p;

                param = param || 'x';
                if (dot === undefined) {
                    dot = ' * ';
                }

                n = len - 1;  // (Max) degree of the polynomial
                for (j = 0; j < len; j++) {
                    coeffs_sum[j] = 0;
                }

                for (i = 0; i < len; i++) {
                    c = points[i].Y();
                    p = points[i].X();
                    zeroes = [];
                    for (j = 0; j < len; j++) {
                        if (j !== i) {
                            c /= p - points[j].X();
                            zeroes.push(points[j].X());
                        }
                    }
                    coeffs = [1].concat(Mat.Vieta(zeroes));
                    for (j = 0; j < coeffs.length; j++) {
                        coeffs_sum[j] += (j%2===1?(-1):1) * coeffs[j] * c;
                    }
                }

                t = '';
                for (j = 0; j < coeffs_sum.length; j++) {
                    c = coeffs_sum[j];
                    if (Math.abs(c) < Mat.eps) {
                        continue;
                    }
                    if (JXG.exists(digits)) {
                        c = Env._round10(c, -digits);
                    }
                    if (isLeading) {
                        t += (c > 0) ? (c) : ('-' + (-c));
                        isLeading = false;
                    } else {
                        t += (c > 0) ? (' + ' + c) : (' - ' + (-c));
                    }

                    if (n - j > 1) {
                        t += dot + param + '^' + (n - j);
                    } else if (n - j === 1) {
                        t += dot + param;
                    }
                }
                return t; // board.jc.manipulate('f = map(x) -> ' + t + ';');
            };
        },

        /**
         * Determine the coefficients of a cardinal spline polynom, See
         * http://stackoverflow.com/questions/9489736/catmull-rom-curve-with-no-cusps-and-no-self-intersections
         * @param  {Number} x1 point 1
         * @param  {Number} x2 point 2
         * @param  {Number} t1 tangent slope 1
         * @param  {Number} t2 tangent slope 2
         * @return {Array}    coefficents array c for the polynomial t maps to
         * c[0] + c[1]*t + c[2]*t*t + c[3]*t*t*t
         */
        _initCubicPoly: function(x1, x2, t1, t2) {
            return [
                x1,
                t1,
                -3 * x1 + 3 * x2 - 2 * t1 - t2,
                2 * x1 -  2 * x2 + t1 + t2
            ];
        },

        /**
         * Computes the cubic cardinal spline curve through a given set of points. The curve
         * is uniformly parametrized.
         * Two artificial control points at the beginning and the end are added.
         *
         * The implementation (especially  the centripetal parametrization) is from
         * http://stackoverflow.com/questions/9489736/catmull-rom-curve-with-no-cusps-and-no-self-intersections .
         * @param {Array} points Array consisting of JXG.Points.
         * @param {Number|Function} tau The tension parameter, either a constant number or a function returning a number. This number is between 0 and 1.
         * tau=1/2 give Catmull-Rom splines.
         * @param {String} type (Optional) parameter which allows to choose between "uniform" (default) and
         * "centripetal" parameterization. Thus the two possible values are "uniform" or "centripetal".
         * @returns {Array} An Array consisting of four components: Two functions each of one parameter t
         * which return the x resp. y coordinates of the Catmull-Rom-spline curve in t, a zero value,
         * and a function simply returning the length of the points array
         * minus three.
         * @memberof JXG.Math.Numerics
        */
        CardinalSpline: function (points, tau_param, type) {
            var p,
                coeffs = [],
                makeFct,
                tau, _tau,
                that = this;

            if (Type.isFunction(tau_param)) {
                _tau = tau_param;
            } else {
                _tau = function () { return tau_param; };
            }

            if (type === undefined) {
                type = 'uniform';
            }

            /** @ignore */
            makeFct = function (which) {
                return function (t, suspendedUpdate) {
                    var s, c,
                        // control point at the beginning and at the end
                        first, last,
                        t1, t2, dt0, dt1, dt2,
                        // dx, dy,
                        len;

                    if (points.length < 2) {
                        return NaN;
                    }

                    if (!suspendedUpdate) {
                        tau = _tau();

                        // New point list p: [first, points ..., last]
                        first = {
                            X: function () { return 2 * points[0].X() - points[1].X(); },
                            Y: function () { return 2 * points[0].Y() - points[1].Y(); },
                            Dist: function(p) {
                                var dx = this.X() - p.X(),
                                    dy = this.Y() - p.Y();
                                return Math.sqrt(dx * dx + dy * dy);
                            }
                        };

                        last = {
                            X: function () { return 2 * points[points.length - 1].X() - points[points.length - 2].X(); },
                            Y: function () { return 2 * points[points.length - 1].Y() - points[points.length - 2].Y(); },
                            Dist: function(p) {
                                var dx = this.X() - p.X(),
                                    dy = this.Y() - p.Y();
                                return Math.sqrt(dx * dx + dy * dy);
                            }
                        };

                        p = [first].concat(points, [last]);
                        len = p.length;

                        coeffs[which] = [];

                        for (s = 0; s < len - 3; s++) {
                            if (type === 'centripetal') {
                                // The order is important, since p[0].coords === undefined
                                dt0 = p[s].Dist(p[s + 1]);
                                dt1 = p[s + 2].Dist(p[s + 1]);
                                dt2 = p[s + 3].Dist(p[s + 2]);

                                dt0 = Math.sqrt(dt0);
                                dt1 = Math.sqrt(dt1);
                                dt2 = Math.sqrt(dt2);

                                if (dt1 < Mat.eps) { dt1 = 1.0; }
                                if (dt0 < Mat.eps) { dt0 = dt1; }
                                if (dt2 < Mat.eps) { dt2 = dt1; }

                                t1 = (p[s + 1][which]() - p[s][which]()) / dt0 -
                                     (p[s + 2][which]() - p[s][which]()) / (dt1 + dt0) +
                                     (p[s + 2][which]() - p[s + 1][which]()) / dt1;

                                t2 = (p[s + 2][which]() - p[s + 1][which]()) / dt1 -
                                     (p[s + 3][which]() - p[s + 1][which]()) / (dt2 + dt1) +
                                     (p[s + 3][which]() - p[s + 2][which]()) / dt2;

                                t1 *= dt1;
                                t2 *= dt1;

                                coeffs[which][s] = that._initCubicPoly(
                                     p[s + 1][which](),
                                     p[s + 2][which](),
                                     tau * t1,
                                     tau * t2
                                );
                            } else {
                                coeffs[which][s] = that._initCubicPoly(
                                    p[s + 1][which](),
                                    p[s + 2][which](),
                                    tau * (p[s + 2][which]() - p[s][which]()),
                                    tau * (p[s + 3][which]() - p[s + 1][which]())
                                );
                            }
                        }
                    }

                    if (isNaN(t)) {
                        return NaN;
                    }

                    len = points.length;
                    // This is necessary for our advanced plotting algorithm:
                    if (t <= 0.0) {
                        return points[0][which]();
                    }
                    if (t >= len) {
                        return points[len - 1][which]();
                    }

                    s = Math.floor(t);
                    if (s === t) {
                        return points[s][which]();
                    }

                    t -= s;
                    c = coeffs[which][s];
                    if (c === undefined) {
                        return NaN;
                    }

                    return (((c[3] * t + c[2]) * t + c[1]) * t + c[0]);
                };
            };

            return [makeFct('X'), makeFct('Y'), 0,
                function () {
                    return points.length - 1;
                }];
        },

        /**
         * Computes the cubic Catmull-Rom spline curve through a given set of points. The curve
         * is uniformly parametrized. The curve is the cardinal spline curve for tau=0.5.
         * Two artificial control points at the beginning and the end are added.
         * @param {Array} points Array consisting of JXG.Points.
         * @param {String} type (Optional) parameter which allows to choose between "uniform" (default) and
         * "centripetal" parameterization. Thus the two possible values are "uniform" or "centripetal".
         * @returns {Array} An Array consisting of four components: Two functions each of one parameter t
         * which return the x resp. y coordinates of the Catmull-Rom-spline curve in t, a zero value, and a function simply
         * returning the length of the points array minus three.
         * @memberof JXG.Math.Numerics
        */
        CatmullRomSpline: function (points, type) {
            return this.CardinalSpline(points, 0.5, type);
        },

        /**
         * Computes the regression polynomial of a given degree through a given set of coordinates.
         * Returns the regression polynomial function.
         * @param {Number,function,Slider} degree number, function or slider.
         * Either
         * @param {Array} dataX Array containing either the x-coordinates of the data set or both coordinates in
         * an array of {@link JXG.Point}s or {@link JXG.Coords}.
         * In the latter case, the <tt>dataY</tt> parameter will be ignored.
         * @param {Array} dataY Array containing the y-coordinates of the data set,
         * @returns {function} A function of one parameter which returns the value of the regression polynomial of the given degree.
         * It possesses the method getTerm() which returns the string containing the function term of the polynomial.
         * @memberof JXG.Math.Numerics
         */
        regressionPolynomial: function (degree, dataX, dataY) {
            var coeffs, deg, dX, dY, inputType, fct,
                term = '';

            // Slider
            if (Type.isPoint(degree) && Type.isFunction(degree.Value)) {
                /** @ignore */
                deg = function () {
                    return degree.Value();
                };
            // function
            } else if (Type.isFunction(degree)) {
                deg = degree;
            // number
            } else if (Type.isNumber(degree)) {
                /** @ignore */
                deg = function () {
                    return degree;
                };
            } else {
                throw new Error("JSXGraph: Can't create regressionPolynomial from degree of type'" + (typeof degree) + "'.");
            }

            // Parameters degree, dataX, dataY
            if (arguments.length === 3 && Type.isArray(dataX) && Type.isArray(dataY)) {
                inputType = 0;
            // Parameters degree, point array
            } else if (arguments.length === 2 && Type.isArray(dataX) && dataX.length > 0 && Type.isPoint(dataX[0])) {
                inputType = 1;
            } else if (arguments.length === 2 && Type.isArray(dataX) && dataX.length > 0 && dataX[0].usrCoords && dataX[0].scrCoords) {
                inputType = 2;
            } else {
                throw new Error("JSXGraph: Can't create regressionPolynomial. Wrong parameters.");
            }

            /** @ignore */
            fct = function (x, suspendedUpdate) {
                var i, j, M, MT, y, B, c, s, d,
                    // input data
                    len = dataX.length;

                d = Math.floor(deg());

                if (!suspendedUpdate) {
                    // point list as input
                    if (inputType === 1) {
                        dX = [];
                        dY = [];

                        for (i = 0; i < len; i++) {
                            dX[i] = dataX[i].X();
                            dY[i] = dataX[i].Y();
                        }
                    }

                    if (inputType === 2) {
                        dX = [];
                        dY = [];

                        for (i = 0; i < len; i++) {
                            dX[i] = dataX[i].usrCoords[1];
                            dY[i] = dataX[i].usrCoords[2];
                        }
                    }

                    // check for functions
                    if (inputType === 0) {
                        dX = [];
                        dY = [];

                        for (i = 0; i < len; i++) {
                            if (Type.isFunction(dataX[i])) {
                                dX.push(dataX[i]());
                            } else {
                                dX.push(dataX[i]);
                            }

                            if (Type.isFunction(dataY[i])) {
                                dY.push(dataY[i]());
                            } else {
                                dY.push(dataY[i]);
                            }
                        }
                    }

                    M = [];

                    for (j = 0; j < len; j++) {
                        M.push([1]);
                    }

                    for (i = 1; i <= d; i++) {
                        for (j = 0; j < len; j++) {
                            M[j][i] = M[j][i - 1] * dX[j];
                        }
                    }

                    y = dY;
                    MT = Mat.transpose(M);
                    B = Mat.matMatMult(MT, M);
                    c = Mat.matVecMult(MT, y);
                    coeffs = Mat.Numerics.Gauss(B, c);
                    term = Mat.Numerics.generatePolynomialTerm(coeffs, d, 'x', 3);
                }

                // Horner's scheme to evaluate polynomial
                s = coeffs[d];

                for (i = d - 1; i >= 0; i--) {
                    s = (s * x + coeffs[i]);
                }

                return s;
            };

            fct.getTerm = function () {
                return term;
            };

            return fct;
        },

        /**
         * Computes the cubic Bezier curve through a given set of points.
         * @param {Array} points Array consisting of 3*k+1 {@link JXG.Points}.
         * The points at position k with k mod 3 = 0 are the data points,
         * points at position k with k mod 3 = 1 or 2 are the control points.
         * @returns {Array} An array consisting of two functions of one parameter t which return the
         * x resp. y coordinates of the Bezier curve in t, one zero value, and a third function accepting
         * no parameters and returning one third of the length of the points.
         * @memberof JXG.Math.Numerics
         */
        bezier: function (points) {
            var len, flen,
                /** @ignore */
                makeFct = function (which) {
                    return function (t, suspendedUpdate) {
                        var z = Math.floor(t) * 3,
                            t0 = t % 1,
                            t1 = 1 - t0;

                        if (!suspendedUpdate) {
                            flen = 3 * Math.floor((points.length - 1) / 3);
                            len = Math.floor(flen / 3);
                        }

                        if (t < 0) {
                            return points[0][which]();
                        }

                        if (t >= len) {
                            return points[flen][which]();
                        }

                        if (isNaN(t)) {
                            return NaN;
                        }

                        return t1 * t1 * (t1 * points[z][which]() + 3 * t0 * points[z + 1][which]()) + (3 * t1 * points[z + 2][which]() + t0 * points[z + 3][which]()) * t0 * t0;
                    };
                };

            return [makeFct('X'), makeFct('Y'), 0,
                function () {
                    return Math.floor(points.length / 3);
                }];
        },

        /**
         * Computes the B-spline curve of order k (order = degree+1) through a given set of points.
         * @param {Array} points Array consisting of JXG.Points.
         * @param {Number} order Order of the B-spline curve.
         * @returns {Array} An Array consisting of four components: Two functions each of one parameter t
         * which return the x resp. y coordinates of the B-spline curve in t, a zero value, and a function simply
         * returning the length of the points array minus one.
         * @memberof JXG.Math.Numerics
         */
        bspline: function (points, order) {
            var knots,
                _knotVector = function (n, k) {
                    var j,
                        kn = [];

                    for (j = 0; j < n + k + 1; j++) {
                        if (j < k) {
                            kn[j] = 0.0;
                        } else if (j <= n) {
                            kn[j] = j - k + 1;
                        } else {
                            kn[j] = n - k + 2;
                        }
                    }

                    return kn;
                },

                _evalBasisFuncs = function (t, kn, k, s) {
                    var i, j, a, b, den,
                        N = [];

                    if (kn[s] <= t && t < kn[s + 1]) {
                        N[s] = 1;
                    } else {
                        N[s] = 0;
                    }

                    for (i = 2; i <= k; i++) {
                        for (j = s - i + 1; j <= s; j++) {
                            if (j <= s - i + 1 || j < 0) {
                                a = 0.0;
                            } else {
                                a = N[j];
                            }

                            if (j >= s) {
                                b = 0.0;
                            } else {
                                b = N[j + 1];
                            }

                            den = kn[j + i - 1] - kn[j];

                            if (den === 0) {
                                N[j] = 0;
                            } else {
                                N[j] = (t - kn[j]) / den * a;
                            }

                            den = kn[j + i] - kn[j + 1];

                            if (den !== 0) {
                                N[j] += (kn[j + i] - t) / den * b;
                            }
                        }
                    }
                    return N;
                },
                /** @ignore */
                makeFct = function (which) {
                    return function (t, suspendedUpdate) {
                        var y, j, s, N = [],
                            len = points.length,
                            n = len - 1,
                            k = order;

                        if (n <= 0) {
                            return NaN;
                        }

                        if (n + 2 <= k) {
                            k = n + 1;
                        }

                        if (t <= 0) {
                            return points[0][which]();
                        }

                        if (t >= n - k + 2) {
                            return points[n][which]();
                        }

                        s = Math.floor(t) + k - 1;
                        knots = _knotVector(n, k);
                        N = _evalBasisFuncs(t, knots, k, s);

                        y = 0.0;
                        for (j = s - k + 1; j <= s; j++) {
                            if (j < len && j >= 0) {
                                y += points[j][which]() * N[j];
                            }
                        }

                        return y;
                    };
                };

            return [makeFct('X'), makeFct('Y'), 0,
                function () {
                    return points.length - 1;
                }];
        },

        /**
         * Numerical (symmetric) approximation of derivative. suspendUpdate is piped through,
         * see {@link JXG.Curve#updateCurve}
         * and {@link JXG.Curve#hasPoint}.
         * @param {function} f Function in one variable to be differentiated.
         * @param {object} [obj] Optional object that is treated as "this" in the function body. This is useful, if the function is a
         * method of an object and contains a reference to its parent object via "this".
         * @returns {function} Derivative function of a given function f.
         * @memberof JXG.Math.Numerics
         */
        D: function (f, obj) {
            if (!Type.exists(obj)) {
                return function (x, suspendedUpdate) {
                    var h = 0.00001,
                        h2 = (h * 2.0);

                    // Experiments with Richardsons rule
                    /*
                    var phi = (f(x + h, suspendedUpdate) - f(x - h, suspendedUpdate)) / h2;
                    var phi2;
                    h *= 0.5;
                    h2 *= 0.5;
                    phi2 = (f(x + h, suspendedUpdate) - f(x - h, suspendedUpdate)) / h2;

                    return phi2 + (phi2 - phi) / 3.0;
                    */
                    return (f(x + h, suspendedUpdate) - f(x - h, suspendedUpdate)) / h2;
                };
            }

            return function (x, suspendedUpdate) {
                var h = 0.00001,
                    h2 = (h * 2.0);

                return (f.apply(obj, [x + h, suspendedUpdate]) - f.apply(obj, [x - h, suspendedUpdate])) / h2;
            };
        },

        /**
         * Evaluate the function term for {@see #riemann}.
         * @private
         * @param {Number} x function argument
         * @param {function} f JavaScript function returning a number
         * @param {String} type Name of the Riemann sum type, e.g. 'lower', see {@see #riemann}.
         * @param {Number} delta Width of the bars in user coordinates
         * @returns {Number} Upper (delta > 0) or lower (delta < 0) value of the bar containing x of the Riemann sum.
         *
         * @memberof JXG.Math.Numerics
         */
        _riemannValue: function (x, f, type, delta) {
            var y, y1, x1, delta1;

            if (delta < 0) { // delta is negative if the lower function term is evaluated
                if (type !== 'trapezoidal') {
                    x = x + delta;
                }
                delta *= -1;
                if (type === 'lower') {
                    type = 'upper';
                } else if (type === 'upper') {
                    type = 'lower';
                }
            }

            delta1 = delta * 0.01; // for 'lower' and 'upper'

            if (type === 'right') {
                y = f(x + delta);
            } else if (type === 'middle') {
                y = f(x + delta * 0.5);
            } else if (type === 'left' || type === 'trapezoidal') {
                y = f(x);
            } else if (type === 'lower') {
                y = f(x);

                for (x1 = x + delta1; x1 <= x + delta; x1 += delta1) {
                    y1 = f(x1);

                    if (y1 < y) {
                        y = y1;
                    }
                }

                y1 = f(x + delta);
                if (y1 < y) {
                    y = y1;
                }
            } else if (type === 'upper') {
                y = f(x);

                for (x1 = x + delta1; x1 <= x + delta; x1 += delta1) {
                    y1 = f(x1);
                    if (y1 > y) {
                        y = y1;
                    }
                }

                y1 = f(x + delta);
                if (y1 > y) {
                    y = y1;
                }
            } else if (type === 'random') {
                y = f(x + delta * Math.random());
            } else if (type === 'simpson') {
                y = (f(x) + 4 * f(x + delta * 0.5) + f(x + delta)) / 6.0;
            } else {
                y = f(x);  // default is lower
            }

            return y;
        },

        /**
         * Helper function to create curve which displays Riemann sums.
         * Compute coordinates for the rectangles showing the Riemann sum.
         * @param {Function,Array} f Function or array of two functions.
         * If f is a function the integral of this function is approximated by the Riemann sum.
         * If f is an array consisting of two functions the area between the two functions is filled
         * by the Riemann sum bars.
         * @param {Number} n number of rectangles.
         * @param {String} type Type of approximation. Possible values are: 'left', 'right', 'middle', 'lower', 'upper', 'random', 'simpson', or 'trapezoidal'.
         * @param {Number} start Left border of the approximation interval
         * @param {Number} end Right border of the approximation interval
         * @returns {Array} An array of two arrays containing the x and y coordinates for the rectangles showing the Riemann sum. This
         * array may be used as parent array of a {@link JXG.Curve}. The third parameteris the riemann sum, i.e. the sum of the volumes of all
         * rectangles.
         * @memberof JXG.Math.Numerics
         */
        riemann: function (gf, n, type, start, end) {
            var i, delta,
                xarr = [],
                yarr = [],
                j = 0,
                x = start, y,
                sum = 0,
                f, g,
                ylow, yup;

            if (Type.isArray(gf)) {
                g = gf[0];
                f = gf[1];
            } else {
                f = gf;
            }

            n = Math.floor(n);

            if (n <= 0) {
                return [xarr, yarr, sum];
            }

            delta = (end - start) / n;

            // Upper bar ends
            for (i = 0; i < n; i++) {
                y = this._riemannValue(x, f, type, delta);
                xarr[j] = x;
                yarr[j] = y;

                j += 1;
                x += delta;
                if (type === 'trapezoidal') {
                    y = f(x);
                }
                xarr[j] = x;
                yarr[j] = y;

                j += 1;
            }

            // Lower bar ends
            for (i = 0; i < n; i++) {
                if (g) {
                    y = this._riemannValue(x, g, type, -delta);
                } else {
                    y = 0.0;
                }
                xarr[j] = x;
                yarr[j] = y;

                j += 1;
                x -= delta;
                if (type === 'trapezoidal' && g) {
                    y = g(x);
                }
                xarr[j] = x;
                yarr[j] = y;

                // Add the area of the bar to 'sum'
                if (type !== 'trapezoidal') {
                    ylow = y;
                    yup = yarr[2 * (n - 1) - 2 * i];
                } else {
                    yup = 0.5 * (f(x + delta) + f(x));
                    if (g) {
                        ylow = 0.5 * (g(x + delta) + g(x));
                    } else {
                        ylow = 0.0;
                    }
                }
                sum += (yup - ylow) * delta;

                // Draw the vertical lines
                j += 1;
                xarr[j] = x;
                yarr[j] = yarr[2 * (n - 1) - 2 * i];

                j += 1;
            }

            return [xarr, yarr, sum];
        },

        /**
         * Approximate the integral by Riemann sums.
         * Compute the area described by the riemann sum rectangles.
         *
         * If there is an element of type {@link Riemannsum}, then it is more efficient
         * to use the method JXG.Curve.Value() of this element instead.
         *
         * @param {Function_Array} f Function or array of two functions.
         * If f is a function the integral of this function is approximated by the Riemann sum.
         * If f is an array consisting of two functions the area between the two functions is approximated
         * by the Riemann sum.
         * @param {Number} n number of rectangles.
         * @param {String} type Type of approximation. Possible values are: 'left', 'right', 'middle', 'lower', 'upper', 'random', 'simpson' or 'trapezoidal'.
         *
         * @param {Number} start Left border of the approximation interval
         * @param {Number} end Right border of the approximation interval
         * @returns {Number} The sum of the areas of the rectangles.
         * @memberof JXG.Math.Numerics
         */
        riemannsum: function (f, n, type, start, end) {
            JXG.deprecated('Numerics.riemannsum()', 'Numerics.riemann()');
            return this.riemann(f, n, type, start, end)[2];
        },

        /**
         * Solve initial value problems numerically using Runge-Kutta-methods.
         * See {@link http://en.wikipedia.org/wiki/Runge-Kutta_methods} for more information on the algorithm.
         * @param {object,String} butcher Butcher tableau describing the Runge-Kutta method to use. This can be either a string describing
         * a Runge-Kutta method with a Butcher tableau predefined in JSXGraph like 'euler', 'heun', 'rk4' or an object providing the structure
         * <pre>
         * {
         *     s: &lt;Number&gt;,
         *     A: &lt;matrix&gt;,
         *     b: &lt;Array&gt;,
         *     c: &lt;Array&gt;
         * }
         * </pre>
         * which corresponds to the Butcher tableau structure shown here: http://en.wikipedia.org/w/index.php?title=List_of_Runge%E2%80%93Kutta_methods&oldid=357796696
         * @param {Array} x0 Initial value vector. If the problem is of one-dimensional, the initial value also has to be given in an array.
         * @param {Array} I Interval on which to integrate.
         * @param {Number} N Number of evaluation points.
         * @param {function} f Function describing the right hand side of the first order ordinary differential equation, i.e. if the ode
         * is given by the equation <pre>dx/dt = f(t, x(t)).</pre> So f has to take two parameters, a number <tt>t</tt> and a
         * vector <tt>x</tt>, and has to return a vector of the same dimension as <tt>x</tt> has.
         * @returns {Array} An array of vectors describing the solution of the ode on the given interval I.
         * @example
         * // A very simple autonomous system dx(t)/dt = x(t);
         * function f(t, x) {
         *     return x;
         * }
         *
         * // Solve it with initial value x(0) = 1 on the interval [0, 2]
         * // with 20 evaluation points.
         * var data = JXG.Math.Numerics.rungeKutta('heun', [1], [0, 2], 20, f);
         *
         * // Prepare data for plotting the solution of the ode using a curve.
         * var dataX = [];
         * var dataY = [];
         * var h = 0.1;        // (I[1] - I[0])/N  = (2-0)/20
         * for(var i=0; i&lt;data.length; i++) {
         *     dataX[i] = i*h;
         *     dataY[i] = data[i][0];
         * }
         * var g = board.create('curve', [dataX, dataY], {strokeWidth:'2px'});
         * </pre><div class="jxgbox" id="JXGd2432d04-4ef7-4159-a90b-a2eb8d38c4f6" style="width: 300px; height: 300px;"></div>
         * <script type="text/javascript">
         * var board = JXG.JSXGraph.initBoard('JXGd2432d04-4ef7-4159-a90b-a2eb8d38c4f6', {boundingbox: [-1, 5, 5, -1], axis: true, showcopyright: false, shownavigation: false});
         * function f(t, x) {
         *     // we have to copy the value.
         *     // return x; would just return the reference.
         *     return [x[0]];
         * }
         * var data = JXG.Math.Numerics.rungeKutta('heun', [1], [0, 2], 20, f);
         * var dataX = [];
         * var dataY = [];
         * var h = 0.1;
         * for(var i=0; i<data.length; i++) {
         *     dataX[i] = i*h;
         *     dataY[i] = data[i][0];
         * }
         * var g = board.create('curve', [dataX, dataY], {strokeColor:'red', strokeWidth:'2px'});
         * </script><pre>
         * @memberof JXG.Math.Numerics
         */
        rungeKutta: function (butcher, x0, I, N, f) {
            var e, i, j, k, l, s,
                x = [],
                y = [],
                h = (I[1] - I[0]) / N,
                t = I[0],
                dim = x0.length,
                result = [],
                r = 0;

            if (Type.isString(butcher)) {
                butcher = predefinedButcher[butcher] || predefinedButcher.euler;
            }
            s = butcher.s;

            // don't change x0, so copy it
            for (e = 0; e < dim; e++) {
                x[e] = x0[e];
            }

            for (i = 0; i < N; i++) {
                // Optimization doesn't work for ODEs plotted using time
                //        if((i % quotient == 0) || (i == N-1)) {
                result[r] = [];
                for (e = 0; e < dim; e++) {
                    result[r][e] = x[e];
                }

                r += 1;
                k = [];

                for (j = 0; j < s; j++) {
                    // init y = 0
                    for (e = 0; e < dim; e++) {
                        y[e] = 0.0;
                    }


                    // Calculate linear combination of former k's and save it in y
                    for (l = 0; l < j; l++) {
                        for (e = 0; e < dim; e++) {
                            y[e] += (butcher.A[j][l]) * h * k[l][e];
                        }
                    }

                    // add x(t) to y
                    for (e = 0; e < dim; e++) {
                        y[e] += x[e];
                    }

                    // calculate new k and add it to the k matrix
                    k.push(f(t + butcher.c[j] * h, y));
                }

                // init y = 0
                for (e = 0; e < dim; e++) {
                    y[e] = 0.0;
                }

                for (l = 0; l < s; l++) {
                    for (e = 0; e < dim; e++) {
                        y[e] += butcher.b[l] * k[l][e];
                    }
                }

                for (e = 0; e < dim; e++) {
                    x[e] = x[e] + h * y[e];
                }

                t += h;
            }

            return result;
        },

        /**
         * Maximum number of iterations in {@link JXG.Math.Numerics.fzero} and
         * {@link JXG.Math.Numerics.chandrupatla}
         * @type Number
         * @default 80
         * @memberof JXG.Math.Numerics
         */
        maxIterationsRoot: 80,

        /**
         * Maximum number of iterations in {@link JXG.Math.Numerics.fminbr}
         * @type Number
         * @default 500
         * @memberof JXG.Math.Numerics
         */
        maxIterationsMinimize: 500,

        /**
         * Given a value x_0, this function tries to find a second value x_1 such that
         * the function f has opposite signs at x_0 and x_1.
         * The return values have to be tested if the method succeeded.
         *
         * @param {Function} f Function, whose root is to be found
         * @param {Number} x0 Start value
         * @param {Object} object Parent object in case f is method of it
         * @returns {Array} [x_0, f(x_0), x_1, f(x_1)]
         *
         * @see JXG.Math.Numerics.fzero
         * @see JXG.Math.Numerics.chandrupatla
         *
         * @memberof JXG.Math.Numerics
         */
        findBracket: function(f, x0, object) {
            var a, aa, fa,
                blist, b, fb,
                u, fu,
                i, len;

            if (Type.isArray(x0)) {
                return x0;
            }

            a = x0;
            fa = f.call(object, a);
            // nfev += 1;

            // Try to get b, by trying several values related to a
            aa = (a === 0) ? 1 : a;
            blist = [
                a - 0.1 * aa, a + 0.1 * aa,
                a - 1, a + 1,
                a - 0.5 * aa, a + 0.5 * aa,
                a - 0.6 * aa, a + 0.6 * aa,
                a - 1 * aa, a + 1 * aa,
                a - 2 * aa, a + 2 * aa,
                a - 5 * aa, a + 5 * aa,
                a - 10 * aa, a + 10 * aa,
                a - 50 * aa, a + 50 * aa,
                a - 100 * aa, a + 100 * aa
            ];
            len = blist.length;

            for (i = 0; i < len; i++) {
                b = blist[i];
                fb = f.call(object, b);
                // nfev += 1;

                if (fa * fb <= 0) {
                    break;
                }
            }
            if (b < a) {
                u = a;
                a = b;
                b = u;

                fu = fa;
                fa = fb;
                fb = fu;
            }
            return [a, fa, b, fb];
        },

        /**
         *
         * Find zero of an univariate function f.
         * @param {function} f Function, whose root is to be found
         * @param {Array,Number} x0  Start value or start interval enclosing the root
         * @param {Object} object Parent object in case f is method of it
         * @returns {Number} the approximation of the root
         * Algorithm:
         *  Brent's root finder from
         *  G.Forsythe, M.Malcolm, C.Moler, Computer methods for mathematical
         *  computations. M., Mir, 1980, p.180 of the Russian edition
         *  http://www.netlib.org/c/brent.shar
         *
         * If x0 is an array containing lower and upper bound for the zero
         * algorithm 748 is applied. Otherwise, if x0 is a number,
         * the algorithm tries to bracket a zero of f starting from x0.
         * If this fails, we fall back to Newton's method.
         *
         * @see JXG.Math.Numerics.chandrupatla
         * @see JXG.Math.Numerics.root
         * @memberof JXG.Math.Numerics
         */
        fzero: function (f, x0, object) {
            var a, b, c,
                d, e,
                fa, fb, fc,
                res,
                prev_step, t1, cb, t2,
                // Actual tolerance
                tol_act,
                // Interpolation step is calculated in the form p/q; division
                // operations is delayed until the last moment
                p, q,
                // Step at this iteration
                new_step,
                eps = Mat.eps,
                maxiter = this.maxIterationsRoot,
                niter = 0;
                // nfev = 0;

            if (Type.isArray(x0)) {
                if (x0.length < 2) {
                    throw new Error("JXG.Math.Numerics.fzero: length of array x0 has to be at least two.");
                }

                a = x0[0];
                fa = f.call(object, a);
                // nfev += 1;
                b = x0[1];
                fb = f.call(object, b);
                // nfev += 1;
            } else {
                res = this.findBracket(f, x0, object);
                a = res[0];
                fa = res[1];
                b = res[2];
                fb = res[3];
            }

            if (Math.abs(fa) <= eps) {
                return a;
            }
            if (Math.abs(fb) <= eps) {
                return b;
            }

            if (fa * fb > 0) {
                // Bracketing not successful, fall back to Newton's method or to fminbr
                if (Type.isArray(x0)) {
                    return this.fminbr(f, [a, b], object);
                }

                return this.Newton(f, a, object);
            }

            // OK, we have enclosed a zero of f.
            // Now we can start Brent's method
            c = a;
            fc = fa;

            // Main iteration loop
            while (niter < maxiter) {
                // Distance from the last but one to the last approximation
                prev_step = b - a;

                // Swap data for b to be the best approximation
                if (Math.abs(fc) < Math.abs(fb)) {
                    a = b;
                    b = c;
                    c = a;

                    fa = fb;
                    fb = fc;
                    fc = fa;
                }
                tol_act = 2 * eps * Math.abs(b) + eps * 0.5;
                new_step = (c - b) * 0.5;

                if (Math.abs(new_step) <= tol_act || Math.abs(fb) <= eps) {
                    //  Acceptable approx. is found
                    return b;
                }

                // Decide if the interpolation can be tried
                // If prev_step was large enough and was in true direction Interpolatiom may be tried
                if (Math.abs(prev_step) >= tol_act && Math.abs(fa) > Math.abs(fb)) {
                    cb = c - b;

                    // If we have only two distinct points linear interpolation can only be applied
                    if (a === c) {
                        t1 = fb / fa;
                        p = cb * t1;
                        q = 1.0 - t1;
                    // Quadric inverse interpolation
                    } else {
                        q = fa / fc;
                        t1 = fb / fc;
                        t2 = fb / fa;

                        p = t2 * (cb * q * (q - t1) - (b - a) * (t1 - 1.0));
                        q = (q - 1.0) * (t1 - 1.0) * (t2 - 1.0);
                    }

                    // p was calculated with the opposite sign; make p positive
                    if (p > 0) {
                        q = -q;
                    // and assign possible minus to q
                    } else {
                        p = -p;
                    }

                    // If b+p/q falls in [b,c] and isn't too large it is accepted
                    // If p/q is too large then the bissection procedure can reduce [b,c] range to more extent
                    if (p < (0.75 * cb * q - Math.abs(tol_act * q) * 0.5) &&
                            p < Math.abs(prev_step * q * 0.5)) {
                        new_step = p / q;
                    }
                }

                // Adjust the step to be not less than tolerance
                if (Math.abs(new_step) < tol_act) {
                    new_step = (new_step > 0) ? tol_act : -tol_act;
                }

                // Save the previous approx.
                a  = b;
                fa = fb;
                b += new_step;
                fb = f.call(object, b);
                // Do step to a new approxim.
                // nfev += 1;

                // Adjust c for it to have a sign opposite to that of b
                if ((fb > 0 && fc > 0) || (fb < 0 && fc < 0)) {
                    c = a;
                    fc = fa;
                }
                niter++;
            } // End while

            return b;
        },

        /**
         * Find zero of an univariate function f.
         * @param {function} f Function, whose root is to be found
         * @param {Array,Number} x0  Start value or start interval enclosing the root
         * @param {Object} object Parent object in case f is method of it
         * @returns {Number} the approximation of the root
         * Algorithm:
         * Chandrupatla's method, see
         * Tirupathi R. Chandrupatla,
         * "A new hybrid quadratic/bisection algorithm for finding the zero of a nonlinear function without using derivatives",
         * Advances in Engineering Software, Volume 28, Issue 3, April 1997, Pages 145-149.
         *
         * If x0 is an array containing lower and upper bound for the zero
         * algorithm 748 is applied. Otherwise, if x0 is a number,
         * the algorithm tries to bracket a zero of f starting from x0.
         * If this fails, we fall back to Newton's method.
         *
         * @see JXG.Math.Numerics.root
         * @see JXG.Math.Numerics.fzero
         * @memberof JXG.Math.Numerics
         */
        chandrupatla: function (f, x0, object) {
            var a, fa, b, fb, res,
                niter = 0,
                maxiter = this.maxIterationsRoot,
                rand = (1 + Math.random() * 0.001),
                t = 0.5 * rand,
                eps = Mat.eps, // 1.e-10,
                dlt = 0.00001,
                x1, x2, x3, x,
                f1, f2, f3, y,
                xm, fm, tol, tl,
                xi, ph, fl, fh,
                AL, A, B, C, D;

            if (Type.isArray(x0)) {
                if (x0.length < 2) {
                    throw new Error("JXG.Math.Numerics.fzero: length of array x0 has to be at least two.");
                }

                a = x0[0];
                fa = f.call(object, a);
                // nfev += 1;
                b = x0[1];
                fb = f.call(object, b);
                // nfev += 1;
            } else {
                res = this.findBracket(f, x0, object);
                a = res[0];
                fa = res[1];
                b = res[2];
                fb = res[3];
            }

            if (fa * fb > 0) {
                // Bracketing not successful, fall back to Newton's method or to fminbr
                if (Type.isArray(x0)) {
                    return this.fminbr(f, [a, b], object);
                }

                return this.Newton(f, a, object);
            }

            x1 = a;  x2 = b;
            f1 = fa; f2 = fb;
            do {
                x = x1 + t * (x2 - x1);
                y = f.call(object, x);

                // Arrange 2-1-3: 2-1 interval, 1 middle, 3 discarded point
                if (Math.sign(y) === Math.sign(f1)) {
                    x3 = x1; x1 = x;
                    f3 = f1; f1 = y;
                } else {
                    x3 = x2; x2 = x1;
                    f3 = f2; f2 = f1;
                }
                x1 = x; f1 = y;

                xm = x1; fm = f1;
                if (Math.abs(f2) < Math.abs(f1)) {
                    xm = x2; fm = f2;
                }
                tol = 2 * eps * Math.abs(xm) + 0.5 * dlt;
                tl = tol / Math.abs(x2 - x1);
                if (tl > 0.5 || fm === 0) {
                    break;
                }
                // If inverse quadratic interpolation holds, use it
                xi = (x1 - x2) / (x3 - x2);
                ph = (f1 - f2) / (f3 - f2);
                fl = 1 - Math.sqrt(1 - xi);
                fh = Math.sqrt(xi);
                if (fl < ph && ph < fh) {
                    AL = (x3 - x1) / (x2 - x1);
                    A = f1 / (f2 - f1);
                    B = f3 / (f2 - f3);
                    C = f1 / (f3 - f1);
                    D = f2 / (f3 - f2);
                    t = A * B + C * D * AL;
                } else {
                    t = 0.5 * rand;
                }
                // Adjust t away from the interval boundary
                if (t < tl) {
                    t = tl;
                }
                if (t > 1 - tl) {
                    t = 1 - tl;
                }
                niter++;
            } while (niter <= maxiter);
            // console.log(niter);

            return xm;
        },

        /**
         *
         * Find minimum of an univariate function f.
         * <p>
         * Algorithm:
         *  G.Forsythe, M.Malcolm, C.Moler, Computer methods for mathematical
         *  computations. M., Mir, 1980, p.180 of the Russian edition
         *
         * @param {function} f Function, whose minimum is to be found
         * @param {Array} x0  Start interval enclosing the minimum
         * @param {Object} context Parent object in case f is method of it
         * @returns {Number} the approximation of the minimum value position
         * @memberof JXG.Math.Numerics
         **/
        fminbr: function (f, x0, context) {
            var a, b, x, v, w,
                fx, fv, fw,
                range, middle_range, tol_act, new_step,
                p, q, t, ft,
                // Golden section ratio
                r = (3.0 - Math.sqrt(5.0)) * 0.5,
                tol = Mat.eps,
                sqrteps = Mat.eps, //Math.sqrt(Mat.eps),
                maxiter = this.maxIterationsMinimize,
                niter = 0;
                // nfev = 0;

            if (!Type.isArray(x0) || x0.length < 2) {
                throw new Error("JXG.Math.Numerics.fminbr: length of array x0 has to be at least two.");
            }

            a = x0[0];
            b = x0[1];
            v = a + r * (b - a);
            fv = f.call(context, v);

            // First step - always gold section
            // nfev += 1;
            x = v;
            w = v;
            fx = fv;
            fw = fv;

            while (niter < maxiter) {
                // Range over the interval in which we are looking for the minimum
                range = b - a;
                middle_range = (a + b) * 0.5;

                // Actual tolerance
                tol_act = sqrteps * Math.abs(x) + tol / 3.0;

                if (Math.abs(x - middle_range) + range * 0.5 <= 2.0 * tol_act) {
                    // Acceptable approx. is found
                    return x;
                }

                // Obtain the golden section step
                new_step = r * (x < middle_range ? b - x : a - x);

                // Decide if the interpolation can be tried. If x and w are distinct interpolatiom may be tried
                if (Math.abs(x - w) >= tol_act) {
                    // Interpolation step is calculated as p/q;
                    // division operation is delayed until last moment
                    t = (x - w) * (fx - fv);
                    q = (x - v) * (fx - fw);
                    p = (x - v) * q - (x - w) * t;
                    q = 2 * (q - t);

                    if (q > 0) {                        // q was calculated with the op-
                        p = -p;                         // posite sign; make q positive
                    } else {                            // and assign possible minus to
                        q = -q;                         // p
                    }
                    if (Math.abs(p) < Math.abs(new_step * q) &&     // If x+p/q falls in [a,b]
                            p > q * (a - x + 2 * tol_act) &&        //  not too close to a and
                            p < q * (b - x - 2 * tol_act)) {        // b, and isn't too large
                        new_step = p / q;                          // it is accepted
                    }
                    // If p/q is too large then the
                    // golden section procedure can
                    // reduce [a,b] range to more
                    // extent
                }

                // Adjust the step to be not less than tolerance
                if (Math.abs(new_step) < tol_act) {
                    if (new_step > 0) {
                        new_step = tol_act;
                    } else {
                        new_step = -tol_act;
                    }
                }

                // Obtain the next approximation to min
                // and reduce the enveloping range

                // Tentative point for the min
                t = x + new_step;
                ft = f.call(context, t);
                // nfev += 1;

                // t is a better approximation
                if (ft <= fx) {
                    // Reduce the range so that t would fall within it
                    if (t < x) {
                        b = x;
                    } else {
                        a = x;
                    }

                    // Assign the best approx to x
                    v = w;
                    w = x;
                    x = t;

                    fv = fw;
                    fw = fx;
                    fx = ft;
                // x remains the better approx
                } else {
                    // Reduce the range enclosing x
                    if (t < x) {
                        a = t;
                    } else {
                        b = t;
                    }

                    if (ft <= fw || w === x) {
                        v = w;
                        w = t;
                        fv = fw;
                        fw = ft;
                    } else if (ft <= fv || v === x || v === w) {
                        v = t;
                        fv = ft;
                    }
                }
                niter += 1;
            }

            return x;
        },

        /**
         * Implements the Ramer-Douglas-Peucker algorithm.
         * It discards points which are not necessary from the polygonal line defined by the point array
         * pts. The computation is done in screen coordinates.
         * Average runtime is O(nlog(n)), worst case runtime is O(n^2), where n is the number of points.
         * @param {Array} pts Array of {@link JXG.Coords}
         * @param {Number} eps If the absolute value of a given number <tt>x</tt> is smaller than <tt>eps</tt> it is considered to be equal <tt>0</tt>.
         * @returns {Array} An array containing points which represent an apparently identical curve as the points of pts do, but contains fewer points.
         * @memberof JXG.Math.Numerics
         */
        RamerDouglasPeucker: function (pts, eps) {
            var allPts = [], newPts = [], i, k, len,

                /**
                 * findSplit() is a subroutine of {@link JXG.Math.Numerics.RamerDouglasPeucker}.
                 * It searches for the point between index i and j which
                 * has the largest distance from the line between the points i and j.
                 * @param {Array} pts Array of {@link JXG.Coords}
                 * @param {Number} i Index of a point in pts
                 * @param {Number} j Index of a point in pts
                 * @ignore
                 * @private
                 */
                findSplit = function (pts, i, j) {
                    var d, k, ci, cj, ck,
                        x0, y0, x1, y1,
                        den, lbda,
                        huge = 10000,
                        dist = 0,
                        f = i;

                    if (j - i < 2) {
                        return [-1.0, 0];
                    }

                    ci = pts[i].scrCoords;
                    cj = pts[j].scrCoords;

                    if (isNaN(ci[1]) || isNaN(ci[2])) {
                        return [NaN, i];
                    }
                    if (isNaN(cj[1]) || isNaN(cj[2])) {
                        return [NaN, j];
                    }

                    for (k = i + 1; k < j; k++) {
                        ck = pts[k].scrCoords;
                        if (isNaN(ck[1]) || isNaN(ck[2])) {
                            return [NaN, k];
                        }

                        x0 = ck[1] - ci[1];
                        y0 = ck[2] - ci[2];
                        x1 = cj[1] - ci[1];
                        y1 = cj[2] - ci[2];
                        x0 = x0 === Infinity ? huge : x0;
                        y0 = y0 === Infinity ? huge : y0;
                        x1 = x1 === Infinity ? huge : x1;
                        y1 = y1 === Infinity ? huge : y1;
                        x0 = x0 === -Infinity ? -huge : x0;
                        y0 = y0 === -Infinity ? -huge : y0;
                        x1 = x1 === -Infinity ? -huge : x1;
                        y1 = y1 === -Infinity ? -huge : y1;
                        den = x1 * x1 + y1 * y1;

                        if (den >= Mat.eps) {
                            lbda = (x0 * x1 + y0 * y1) / den;

                            if (lbda < 0.0) {
                                lbda = 0.0;
                            } else if (lbda > 1.0) {
                                lbda = 1.0;
                            }

                            x0 = x0 - lbda * x1;
                            y0 = y0 - lbda * y1;
                            d = x0 * x0 + y0 * y0;
                        } else {
                            lbda = 0.0;
                            d = x0 * x0 + y0 * y0;
                        }

                        if (d > dist) {
                            dist = d;
                            f = k;
                        }
                    }
                    return [Math.sqrt(dist), f];
                },

                /**
                 * RDP() is a private subroutine of {@link JXG.Math.Numerics.RamerDouglasPeucker}.
                 * It runs recursively through the point set and searches the
                 * point which has the largest distance from the line between the first point and
                 * the last point. If the distance from the line is greater than eps, this point is
                 * included in our new point set otherwise it is discarded.
                 * If it is taken, we recursively apply the subroutine to the point set before
                 * and after the chosen point.
                 * @param {Array} pts Array of {@link JXG.Coords}
                 * @param {Number} i Index of an element of pts
                 * @param {Number} j Index of an element of pts
                 * @param {Number} eps If the absolute value of a given number <tt>x</tt> is smaller than <tt>eps</tt> it is considered to be equal <tt>0</tt>.
                 * @param {Array} newPts Array of {@link JXG.Coords}
                 * @ignore
                 * @private
                 */
                RDP = function (pts, i, j, eps, newPts) {
                    var result = findSplit(pts, i, j),
                        k = result[1];

                    if (isNaN(result[0])) {
                        RDP(pts, i, k - 1, eps, newPts);
                        newPts.push(pts[k]);
                        do {
                            ++k;
                        } while (k <= j && isNaN(pts[k].scrCoords[1] + pts[k].scrCoords[2]));
                        if (k <= j) {
                            newPts.push(pts[k]);
                        }
                        RDP(pts, k + 1, j, eps, newPts);
                    } else if (result[0] > eps) {
                        RDP(pts, i, k, eps, newPts);
                        RDP(pts, k, j, eps, newPts);
                    } else {
                        newPts.push(pts[j]);
                    }
                };

            len = pts.length;

            i = 0;
            while (true) {
                // Search for the next point without NaN coordinates
                while (i < len && isNaN(pts[i].scrCoords[1] + pts[i].scrCoords[2])) {
                    i += 1;
                }
                // Search for the next position of a NaN point
                k = i + 1;
                while (k < len && !isNaN(pts[k].scrCoords[1] + pts[k].scrCoords[2])) {
                    k += 1;
                }
                k--;

                // Only proceed if something is left
                if (i < len && k > i) {
                    newPts = [];
                    newPts[0] = pts[i];
                    RDP(pts, i, k, eps, newPts);
                    allPts = allPts.concat(newPts);
                }
                if (i >= len) {
                    break;
                }
                // Push the NaN point
                if (k < len - 1) {
                    allPts.push(pts[k + 1]);
                }
                i = k + 1;
            }

            return allPts;
        },

        /**
         * Old name for the implementation of the Ramer-Douglas-Peucker algorithm.
         * @deprecated Use {@link JXG.Math.Numerics.RamerDouglasPeucker}
         * @memberof JXG.Math.Numerics
         */
        RamerDouglasPeuker: function (pts, eps) {
            JXG.deprecated('Numerics.RamerDouglasPeuker()', 'Numerics.RamerDouglasPeucker()');
            return this.RamerDouglasPeucker(pts, eps);
        },

        /**
         * Implements the Visvalingam-Whyatt algorithm.
         * See M. Visvalingam, J. D. Whyatt:
         * "Line generalisation by repeated elimination of the smallest area", C.I.S.R.G Discussion paper 10, July 1992
         *
         * The algorithm discards points which are not necessary from the polygonal line defined by the point array
         * pts (consisting of type JXG.Coords).
         * @param {Array} pts Array of {@link JXG.Coords}
         * @param {Number} numPoints Number of remaining intermediate points. The first and the last point of the original points will
         *    be taken in any case.
         * @returns {Array} An array containing points which approximates the curve defined by pts.
         * @memberof JXG.Math.Numerics
         *
         * @example
         *     var i, p = [];
         *     for (i = 0; i < 5; ++i) {
         *         p.push(board.create('point', [Math.random() * 12 - 6, Math.random() * 12 - 6]));
         *     }
         *
         *     // Plot a cardinal spline curve
         *     var splineArr = JXG.Math.Numerics.CardinalSpline(p, 0.5);
         *     var cu1 = board.create('curve', splineArr, {strokeColor: 'green'});
         *
         *     var c = board.create('curve', [[0],[0]], {strokeWidth: 2, strokeColor: 'black'});
         *     c.updateDataArray = function() {
         *         var i, len, points;
         *
         *         // Reduce number of intermediate points with Visvakingam-Whyatt to 6
         *         points = JXG.Math.Numerics.Visvalingam(cu1.points, 6);
         *         // Plot the remaining points
         *         len = points.length;
         *         this.dataX = [];
         *         this.dataY = [];
         *         for (i = 0; i < len; i++) {
         *             this.dataX.push(points[i].usrCoords[1]);
         *             this.dataY.push(points[i].usrCoords[2]);
         *         }
         *     };
         *     board.update();
         *
         * </pre><div id="JXGce0cc55c-b592-11e6-8270-104a7d3be7eb" class="jxgbox" style="width: 300px; height: 300px;"></div>
         * <script type="text/javascript">
         *     (function() {
         *         var board = JXG.JSXGraph.initBoard('JXGce0cc55c-b592-11e6-8270-104a7d3be7eb',
         *             {boundingbox: [-8, 8, 8,-8], axis: true, showcopyright: false, shownavigation: false});
         *
         *         var i, p = [];
         *         for (i = 0; i < 5; ++i) {
         *             p.push(board.create('point', [Math.random() * 12 - 6, Math.random() * 12 - 6]));
         *         }
         *
         *         // Plot a cardinal spline curve
         *         var splineArr = JXG.Math.Numerics.CardinalSpline(p, 0.5);
         *         var cu1 = board.create('curve', splineArr, {strokeColor: 'green'});
         *
         *         var c = board.create('curve', [[0],[0]], {strokeWidth: 2, strokeColor: 'black'});
         *         c.updateDataArray = function() {
         *             var i, len, points;
         *
         *             // Reduce number of intermediate points with Visvakingam-Whyatt to 6
         *             points = JXG.Math.Numerics.Visvalingam(cu1.points, 6);
         *             // Plot the remaining points
         *             len = points.length;
         *             this.dataX = [];
         *             this.dataY = [];
         *             for (i = 0; i < len; i++) {
         *                 this.dataX.push(points[i].usrCoords[1]);
         *                 this.dataY.push(points[i].usrCoords[2]);
         *             }
         *         };
         *         board.update();
         *
         *     })();
         *
         * </script><pre>
         *
         */
        Visvalingam: function(pts, numPoints) {
            var i, len, vol, lastVol,
                linkedList = [],
                heap = [],
                points = [],
                lft, rt, lft2, rt2,
                obj;

            len = pts.length;

            // At least one intermediate point is needed
            if (len <= 2) {
                return pts;
            }

            // Fill the linked list
            // Add first point to the linked list
            linkedList[0] = {
                    used: true,
                    lft: null,
                    node: null
                };

            // Add all intermediate points to the linked list,
            // whose triangle area is nonzero.
            lft = 0;
            for (i = 1; i < len - 1; i++) {
                vol = Math.abs(JXG.Math.Numerics.det([pts[i - 1].usrCoords,
                                              pts[i].usrCoords,
                                              pts[i + 1].usrCoords]));
                if (!isNaN(vol)) {
                    obj = {
                        v: vol,
                        idx: i
                    };
                    heap.push(obj);
                    linkedList[i] = {
                            used: true,
                            lft: lft,
                            node: obj
                        };
                    linkedList[lft].rt = i;
                    lft = i;
                }
            }

            // Add last point to the linked list
            linkedList[len - 1] = {
                    used: true,
                    rt: null,
                    lft: lft,
                    node: null
                };
            linkedList[lft].rt = len - 1;

            // Remove points until only numPoints intermediate points remain
            lastVol = -Infinity;
            while (heap.length > numPoints) {
                // Sort the heap with the updated volume values
                heap.sort(function(a, b) {
                    // descending sort
                    return b.v - a.v;
                });

                // Remove the point with the smallest triangle
                i = heap.pop().idx;
                linkedList[i].used = false;
                lastVol = linkedList[i].node.v;

                // Update the pointers of the linked list
                lft = linkedList[i].lft;
                rt = linkedList[i].rt;
                linkedList[lft].rt = rt;
                linkedList[rt].lft = lft;

                // Update the values for the volumes in the linked list
                lft2 = linkedList[lft].lft;
                if (lft2 !== null) {
                    vol = Math.abs(JXG.Math.Numerics.det(
                                [pts[lft2].usrCoords,
                                 pts[lft].usrCoords,
                                 pts[rt].usrCoords]));

                    linkedList[lft].node.v = (vol >= lastVol) ? vol : lastVol;
                }
                rt2 = linkedList[rt].rt;
                if (rt2 !== null) {
                    vol = Math.abs(JXG.Math.Numerics.det(
                                [pts[lft].usrCoords,
                                 pts[rt].usrCoords,
                                 pts[rt2].usrCoords]));

                    linkedList[rt].node.v = (vol >= lastVol) ? vol : lastVol;
                }
            }

            // Return an array with the remaining points
            i = 0;
            points = [pts[i]];
            do {
                i = linkedList[i].rt;
                points.push(pts[i]);
            } while (linkedList[i].rt !== null);

            return points;
        }
    };

    return Mat.Numerics;
});

/*
    Copyright 2008-2022
        Matthias Ehmann,
        Carsten Miller,
        Reinhard Oldenburg,
        Alfred Wassermann

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <http://www.gnu.org/licenses/>
    and <http://opensource.org/licenses/MIT/>.

    This is a port of jcobyla

    - to JavaScript by Reihard Oldenburg and
    - to JSXGraph By Alfred Wassermann
*/
/*
 * jcobyla
 * 
 * The MIT License
 *
 * Copyright (c) 2012 Anders Gustafsson, Cureos AB.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, 
 * publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE 
 * FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION 
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * Remarks:
 * 
 * The original Fortran 77 version of this code was by Michael Powell (M.J.D.Powell @ damtp.cam.ac.uk)
 * The Fortran 90 version was by Alan Miller (Alan.Miller @ vic.cmis.csiro.au). Latest revision - 30 October 1998
 */

/**
 * Constrained Optimization BY Linear Approximation in Java.
 * 
 * COBYLA2 is an implementation of Powell's nonlinear derivative free constrained optimization that uses
 * a linear approximation approach. The algorithm is a sequential trust region algorithm that employs linear
 * approximations to the objective and constraint functions, where the approximations are formed by linear
 * interpolation at n + 1 points in the space of the variables and tries to maintain a regular shaped simplex
 * over iterations.
 * 
 * It solves nonsmooth NLP with a moderate number of variables (about 100). Inequality constraints only.
 * 
 * The initial point X is taken as one vertex of the initial simplex with zero being another, so, X should
 * not be entered as the zero vector.
 * 
 * @author Anders Gustafsson, Cureos AB. Translation to Javascript by Reinhard Oldenburg, Goethe-University
 */

/*global JXG: true, define: true*/
/*jslint nomen: true, plusplus: true, continue: true*/

/* depends:
 jxg
 math/math
 utils/type
 */

define('math/nlp',['jxg'], function (JXG) {

    "use strict";

    /**
     * The JXG.Math.Nlp namespace holds numerical algorithms for non-linear optimization.
     * @name JXG.Math.Nlp
     * @namespace
     * 
     */
    JXG.Math.Nlp =  {

        arr: function(n) {
            var a = new Array(n),
                i;
            for (i = 0; i <n ; i++) {
                a[i] = 0.0;
            }
            return a;
        },

        arr2: function(n, m) {
            var i = 0,
                a = new Array(n);

            while (i < n) {
                a[i] = this.arr(m);
                i++;
            }
            return a;
        },

        arraycopy: function(x, a, iox, b, n) {
            var i = 0;
            while (i < n) {
                iox[i + b] = x[i + a];
                i++;
            }
        },

        // status Variables
        Normal: 0,
        MaxIterationsReached: 1,
        DivergingRoundingErrors: 2,

        /**
         * Minimizes the objective function F with respect to a set of inequality constraints CON,
         * and returns the optimal variable array. F and CON may be non-linear, and should preferably be smooth.
         * Calls {@link JXG.Math.Nlp#cobylb}.
         *
         * @param calcfc Interface implementation for calculating objective function and constraints.
         * @param n Number of variables.
         * @param m Number of constraints.
         * @param x On input initial values of the variables (zero-based array). On output
         * optimal values of the variables obtained in the COBYLA minimization.
         * @param rhobeg Initial size of the simplex.
         * @param rhoend Final value of the simplex.
         * @param iprint Print level, 0 <= iprint <= 3, where 0 provides no output and
         * 3 provides full output to the console.
         * @param maxfun Maximum number of function evaluations before terminating.
         * @returns {Number} Exit status of the COBYLA2 optimization.
         */
        FindMinimum: function(calcfc, n,  m, x, rhobeg, rhoend,  iprint,  maxfun) {
            // CobylaExitStatus FindMinimum(final Calcfc calcfc, int n, int m, double[] x, double rhobeg, double rhoend, int iprint, int maxfun)
            //     This subroutine minimizes an objective function F(X) subject to M
            //     inequality constraints on X, where X is a vector of variables that has
            //     N components.  The algorithm employs linear approximations to the
            //     objective and constraint functions, the approximations being formed by
            //     linear interpolation at N+1 points in the space of the variables.
            //     We regard these interpolation points as vertices of a simplex.  The
            //     parameter RHO controls the size of the simplex and it is reduced
            //     automatically from RHOBEG to RHOEND.  For each RHO the subroutine tries
            //     to achieve a good vector of variables for the current size, and then
            //     RHO is reduced until the value RHOEND is reached.  Therefore RHOBEG and
            //     RHOEND should be set to reasonable initial changes to and the required
            //     accuracy in the variables respectively, but this accuracy should be
            //     viewed as a subject for experimentation because it is not guaranteed.
            //     The subroutine has an advantage over many of its competitors, however,
            //     which is that it treats each constraint individually when calculating
            //     a change to the variables, instead of lumping the constraints together
            //     into a single penalty function.  The name of the subroutine is derived
            //     from the phrase Constrained Optimization BY Linear Approximations.

            //     The user must set the values of N, M, RHOBEG and RHOEND, and must
            //     provide an initial vector of variables in X.  Further, the value of
            //     IPRINT should be set to 0, 1, 2 or 3, which controls the amount of
            //     printing during the calculation. Specifically, there is no output if
            //     IPRINT=0 and there is output only at the end of the calculation if
            //     IPRINT=1.  Otherwise each new value of RHO and SIGMA is printed.
            //     Further, the vector of variables and some function information are
            //     given either when RHO is reduced or when each new value of F(X) is
            //     computed in the cases IPRINT=2 or IPRINT=3 respectively. Here SIGMA
            //     is a penalty parameter, it being assumed that a change to X is an
            //     improvement if it reduces the merit function
            //                F(X)+SIGMA*MAX(0.0, - C1(X), - C2(X),..., - CM(X)),
            //     where C1,C2,...,CM denote the constraint functions that should become
            //     nonnegative eventually, at least to the precision of RHOEND. In the
            //     printed output the displayed term that is multiplied by SIGMA is
            //     called MAXCV, which stands for 'MAXimum Constraint Violation'.  The
            //     argument ITERS is an integer variable that must be set by the user to a
            //     limit on the number of calls of CALCFC, the purpose of this routine being
            //     given below.  The value of ITERS will be altered to the number of calls
            //     of CALCFC that are made.
            //     In order to define the objective and constraint functions, we require
            //     a subroutine that has the name and arguments
            //                SUBROUTINE CALCFC (N,M,X,F,CON)
            //                DIMENSION X(:),CON(:)  .
            //     The values of N and M are fixed and have been defined already, while
            //     X is now the current vector of variables. The subroutine should return
            //     the objective and constraint functions at X in F and CON(1),CON(2),
            //     ...,CON(M).  Note that we are trying to adjust X so that F(X) is as
            //     small as possible subject to the constraint functions being nonnegative.

            // Local variables
            var mpp = m + 2,
                status,
                // Internal base-1 X array
                iox = this.arr(n + 1),
                that = this,
                fcalcfc;

            iox[0] = 0.0;
            this.arraycopy(x, 0, iox, 1, n);

            // Internal representation of the objective and constraints calculation method,
            // accounting for that X and CON arrays in the cobylb method are base-1 arrays.
            fcalcfc = function(n, m, thisx, con) {  // int n, int m, double[] x, double[] con
                    var ix = that.arr(n),
                        ocon, f;

                    that.arraycopy(thisx, 1, ix, 0, n);
                    ocon = that.arr(m);
                    f = calcfc(n, m, ix, ocon);
                    that.arraycopy(ocon, 0, con, 1, m);
                    return f;
                };

            status = this.cobylb(fcalcfc, n, m, mpp, iox, rhobeg, rhoend, iprint, maxfun);
            this.arraycopy(iox, 1, x, 0, n);

            return status;
        },

        //    private static CobylaExitStatus cobylb(Calcfc calcfc, int n, int m, int mpp, double[] x,
        //      double rhobeg, double rhoend, int iprint, int maxfun)
        /**
         * JavaScript implementation of the non-linear optimization method COBYLA.
         * @param {Function} calcfc 
         * @param {Number} n 
         * @param {Number} m 
         * @param {Number} mpp 
         * @param {Number} x 
         * @param {Number} rhobeg 
         * @param {Number} rhoend 
         * @param {Number} iprint 
         * @param {Number} maxfun 
         * @returns {Number} Exit status of the COBYLA2 optimization
         */
        cobylb: function (calcfc, n,  m,  mpp,  x, rhobeg,  rhoend,  iprint,  maxfun) {
            // calcf ist funktion die aufgerufen wird wie calcfc(n, m, ix, ocon)
            // N.B. Arguments CON, SIM, SIMI, DATMAT, A, VSIG, VETA, SIGBAR, DX, W & IACT
            //      have been removed.

            //     Set the initial values of some parameters. The last column of SIM holds
            //     the optimal vertex of the current simplex, and the preceding N columns
            //     hold the displacements from the optimal vertex to the other vertices.
            //     Further, SIMI holds the inverse of the matrix that is contained in the
            //     first N columns of SIM.

            // Local variables
            var status = -1,

                alpha = 0.25,
                beta = 2.1,
                gamma = 0.5,
                delta = 1.1,

                f = 0.0,
                resmax = 0.0,
                total,

                np = n + 1,
                mp = m + 1,
                rho = rhobeg,
                parmu = 0.0,

                iflag = false,
                ifull = false,
                parsig = 0.0,
                prerec = 0.0,
                prerem = 0.0,

                con = this.arr(1 + mpp),
                sim = this.arr2(1 + n, 1 + np),
                simi = this.arr2(1 + n, 1 + n),
                datmat = this.arr2(1 + mpp, 1 + np),
                a = this.arr2(1 + n, 1 + mp),
                vsig = this.arr(1 + n),
                veta = this.arr(1 + n),
                sigbar = this.arr(1 + n),
                dx = this.arr(1 + n),
                w = this.arr(1 + n),
                i, j, k, l,
                temp, tempa, nfvals,
                jdrop, ibrnch,
                skipVertexIdent,
                phimin, nbest,
                error,
                pareta, wsig, weta,
                cvmaxp, cvmaxm, dxsign,
                resnew, barmu, phi,
                vmold, vmnew, trured, ratio, edgmax, cmin, cmax, denom;

            if (iprint >= 2) {
                console.log("The initial value of RHO is " + rho + " and PARMU is set to zero.");
            }

            nfvals = 0;
            temp = 1.0 / rho;

            for (i = 1; i <= n; ++i) {
                sim[i][np] = x[i];
                sim[i][i] = rho;
                simi[i][i] = temp;
            }

            jdrop = np;
            ibrnch = false;

            //     Make the next call of the user-supplied subroutine CALCFC. These
            //     instructions are also used for calling CALCFC during the iterations of
            //     the algorithm.
            //alert("Iteration "+nfvals+" x="+x);
            L_40:
            do {
                if (nfvals >= maxfun && nfvals > 0) {
                    status = this.MaxIterationsReached;
                    break L_40;
                }

                ++nfvals;
                f = calcfc(n, m, x, con);
                resmax = 0.0;
                for (k = 1; k <= m; ++k) {
                    resmax = Math.max(resmax, -con[k]);
                }
                //alert(    "   f="+f+"  resmax="+resmax);

                if (nfvals === iprint - 1 || iprint === 3) {
                    this.PrintIterationResult(nfvals, f, resmax, x, n, iprint);
                }

                con[mp] = f;
                con[mpp] = resmax;

                //     Set the recently calculated function values in a column of DATMAT. This
                //     array has a column for each vertex of the current simplex, the entries of
                //     each column being the values of the constraint functions (if any)
                //     followed by the objective function and the greatest constraint violation
                //     at the vertex.
                skipVertexIdent = true;
                if (!ibrnch) {
                    skipVertexIdent = false;

                    for (i = 1; i <= mpp; ++i) {
                        datmat[i][jdrop] = con[i];
                    }

                    if (nfvals <= np) {
                        //     Exchange the new vertex of the initial simplex with the optimal vertex if
                        //     necessary. Then, if the initial simplex is not complete, pick its next
                        //     vertex and calculate the function values there.

                        if (jdrop <= n) {
                            if (datmat[mp][np] <= f) {
                                x[jdrop] = sim[jdrop][np];
                            } else {
                                sim[jdrop][np] = x[jdrop];
                                for (k = 1; k <= mpp; ++k) {
                                    datmat[k][jdrop] = datmat[k][np];
                                    datmat[k][np] = con[k];
                                }
                                for (k = 1; k <= jdrop; ++k) {
                                    sim[jdrop][k] = -rho;
                                    temp = 0.0;
                                    for (i = k; i <= jdrop; ++i) {
                                        temp -= simi[i][k];
                                    }
                                    simi[jdrop][k] = temp;
                                }
                            }
                        }
                        if (nfvals <= n) {
                            jdrop = nfvals;
                            x[jdrop] += rho;
                            continue L_40;
                        }
                    }
                    ibrnch = true;
                }

                L_140:
                do {
                    L_550:
                    do {
                        if (!skipVertexIdent) {
                            //     Identify the optimal vertex of the current simplex.
                            phimin = datmat[mp][np] + parmu * datmat[mpp][np];
                            nbest = np;

                            for (j = 1; j <= n; ++j) {
                                temp = datmat[mp][j] + parmu * datmat[mpp][j];
                                if (temp < phimin) {
                                    nbest = j;
                                    phimin = temp;
                                } else if (temp === phimin && parmu === 0.0 && datmat[mpp][j] < datmat[mpp][nbest]) {
                                    nbest = j;
                                }
                            }

                            //     Switch the best vertex into pole position if it is not there already,
                            //     and also update SIM, SIMI and DATMAT.
                            if (nbest <= n) {
                                for (i = 1; i <= mpp; ++i) {
                                    temp = datmat[i][np];
                                    datmat[i][np] = datmat[i][nbest];
                                    datmat[i][nbest] = temp;
                                }
                                for (i = 1; i <= n; ++i) {
                                    temp = sim[i][nbest];
                                    sim[i][nbest] = 0.0;
                                    sim[i][np] += temp;

                                    tempa = 0.0;
                                    for (k = 1; k <= n; ++k)
                                    {
                                        sim[i][k] -= temp;
                                        tempa -= simi[k][i];
                                    }
                                    simi[nbest][i] = tempa;
                                }
                            }

                            //     Make an error return if SIGI is a poor approximation to the inverse of
                            //     the leading N by N submatrix of SIG.
                            error = 0.0;
                            for (i = 1; i <= n; ++i) {
                                for (j = 1; j <= n; ++j) {
                                    temp = this.DOT_PRODUCT(
                                            this.PART(this.ROW(simi, i), 1, n),
                                            this.PART(this.COL(sim, j), 1, n)
                                        ) - (i === j ? 1.0 : 0.0);
                                    error = Math.max(error, Math.abs(temp));
                                }
                            }
                            if (error > 0.1) {
                                status = this.DivergingRoundingErrors;
                                break L_40;
                            }

                            //     Calculate the coefficients of the linear approximations to the objective
                            //     and constraint functions, placing minus the objective function gradient
                            //     after the constraint gradients in the array A. The vector W is used for
                            //     working space.
                            for (k = 1; k <= mp; ++k) {
                                con[k] = -datmat[k][np];
                                for (j = 1; j <= n; ++j) {
                                    w[j] = datmat[k][j] + con[k];
                                }

                                for (i = 1; i <= n; ++i) {
                                    a[i][k] = (k === mp ? -1.0 : 1.0) * this.DOT_PRODUCT(
                                        this.PART(w, 1, n), this.PART(this.COL(simi, i), 1, n));
                                }
                            }

                            //     Calculate the values of sigma and eta, and set IFLAG = 0 if the current
                            //     simplex is not acceptable.
                            iflag = true;
                            parsig = alpha * rho;
                            pareta = beta * rho;

                            for (j = 1; j <= n; ++j) {
                                wsig = 0.0;
                                for (k = 1; k <= n; ++k) {
                                    wsig += simi[j][k] * simi[j][k];
                                }
                                weta = 0.0;
                                for (k = 1; k <= n; ++k) {
                                    weta += sim[k][j] * sim[k][j];
                                }
                                vsig[j] = 1.0 / Math.sqrt(wsig);
                                veta[j] = Math.sqrt(weta);
                                if (vsig[j] < parsig || veta[j] > pareta) { iflag = false; }
                            }

                            //     If a new vertex is needed to improve acceptability, then decide which
                            //     vertex to drop from the simplex.
                            if (!ibrnch && !iflag) {
                                jdrop = 0;
                                temp = pareta;
                                for (j = 1; j <= n; ++j) {
                                    if (veta[j] > temp) {
                                        jdrop = j;
                                        temp = veta[j];
                                    }
                                }
                                if (jdrop === 0) {
                                    for (j = 1; j <= n; ++j) {
                                        if (vsig[j] < temp) {
                                            jdrop = j;
                                            temp = vsig[j];
                                        }
                                    }
                                }

                                //     Calculate the step to the new vertex and its sign.
                                temp = gamma * rho * vsig[jdrop];
                                for (k = 1; k <= n; ++k) {
                                    dx[k] = temp * simi[jdrop][k];
                                }
                                cvmaxp = 0.0;
                                cvmaxm = 0.0;
                                total = 0.0;
                                for (k = 1; k <= mp; ++k) {
                                    total = this.DOT_PRODUCT(
                                        this.PART(this.COL(a, k), 1, n),
                                        this.PART(dx, 1, n)
                                        );
                                    if (k < mp) {
                                        temp = datmat[k][np];
                                        cvmaxp = Math.max(cvmaxp, -total - temp);
                                        cvmaxm = Math.max(cvmaxm, total - temp);
                                    }
                                }
                                dxsign = parmu * (cvmaxp - cvmaxm) > 2.0 * total ? -1.0 : 1.0;

                                //     Update the elements of SIM and SIMI, and set the next X.
                                temp = 0.0;
                                for (i = 1; i <= n; ++i) {
                                    dx[i] = dxsign * dx[i];
                                    sim[i][jdrop] = dx[i];
                                    temp += simi[jdrop][i] * dx[i];
                                }
                                for (k = 1; k <= n; ++k) {
                                    simi[jdrop][k] /= temp;
                                }

                                for (j = 1; j <= n; ++j) {
                                    if (j !== jdrop) {
                                        temp = this.DOT_PRODUCT(
                                            this.PART(this.ROW(simi, j), 1, n),
                                            this.PART(dx, 1, n)
                                            );
                                        for (k = 1; k <= n; ++k) {
                                            simi[j][k] -= temp * simi[jdrop][k];
                                        }
                                    }
                                    x[j] = sim[j][np] + dx[j];
                                }
                                continue L_40;
                            }

                            //     Calculate DX = x(*)-x(0).
                            //     Branch if the length of DX is less than 0.5*RHO.
                            ifull = this.trstlp(n, m, a, con, rho, dx);
                            if (!ifull) {
                                temp = 0.0;
                                for (k = 1; k <= n; ++k) {
                                    temp += dx[k] * dx[k];
                                }
                                if (temp < 0.25 * rho * rho) {
                                    ibrnch = true;
                                    break L_550;
                                }
                            }

                            //     Predict the change to F and the new maximum constraint violation if the
                            //     variables are altered from x(0) to x(0) + DX.
                            total = 0.0;
                            resnew = 0.0;
                            con[mp] = 0.0;
                            for (k = 1; k <= mp; ++k) {
                                total = con[k] - this.DOT_PRODUCT(this.PART(this.COL(a, k), 1, n), this.PART(dx, 1, n));
                                if (k < mp) { resnew = Math.max(resnew, total); }
                            }

                            //     Increase PARMU if necessary and branch back if this change alters the
                            //     optimal vertex. Otherwise PREREM and PREREC will be set to the predicted
                            //     reductions in the merit function and the maximum constraint violation
                            //     respectively.
                            prerec = datmat[mpp][np] - resnew;
                            barmu = prerec > 0.0 ? total / prerec : 0.0;
                            if (parmu < 1.5 * barmu) {
                                parmu = 2.0 * barmu;
                                if (iprint >= 2) { console.log("Increase in PARMU to " + parmu); }
                                phi = datmat[mp][np] + parmu * datmat[mpp][np];
                                for (j = 1; j <= n; ++j) {
                                    temp = datmat[mp][j] + parmu * datmat[mpp][j];
                                    if (temp < phi || (temp === phi && parmu === 0.0 && datmat[mpp][j] < datmat[mpp][np])) {
                                        continue L_140;
                                    }
                                }
                            }
                            prerem = parmu * prerec - total;

                            //     Calculate the constraint and objective functions at x(*).
                            //     Then find the actual reduction in the merit function.
                            for (k = 1; k <= n; ++k) {
                                x[k] = sim[k][np] + dx[k];
                            }
                            ibrnch = true;
                            continue L_40;
                        }

                        skipVertexIdent = false;
                        vmold = datmat[mp][np] + parmu * datmat[mpp][np];
                        vmnew = f + parmu * resmax;
                        trured = vmold - vmnew;
                        if (parmu === 0.0 && f === datmat[mp][np]) {
                            prerem = prerec;
                            trured = datmat[mpp][np] - resmax;
                        }

                        //     Begin the operations that decide whether x(*) should replace one of the
                        //     vertices of the current simplex, the change being mandatory if TRURED is
                        //     positive. Firstly, JDROP is set to the index of the vertex that is to be
                        //     replaced.
                        ratio = trured <= 0.0 ? 1.0 : 0.0;
                        jdrop = 0;
                        for (j = 1; j <= n; ++j) {
                            temp = Math.abs(this.DOT_PRODUCT(this.PART(this.ROW(simi, j), 1, n), this.PART(dx, 1, n)));
                            if (temp > ratio) {
                                jdrop = j;
                                ratio = temp;
                            }
                            sigbar[j] = temp * vsig[j];
                        }

                        //     Calculate the value of ell.

                        edgmax = delta * rho;
                        l = 0;
                        for (j = 1; j <= n; ++j) {
                            if (sigbar[j] >= parsig || sigbar[j] >= vsig[j]) {
                                temp = veta[j];
                                if (trured > 0.0) {
                                    temp = 0.0;
                                    for (k = 1; k <= n; ++k) {
                                        temp += Math.pow(dx[k] - sim[k][j], 2.0);
                                    }
                                    temp = Math.sqrt(temp);
                                }
                                if (temp > edgmax) {
                                    l = j;
                                    edgmax = temp;
                                }
                            }
                        }
                        if (l > 0) { jdrop = l; }

                        if (jdrop !== 0) {
                            //     Revise the simplex by updating the elements of SIM, SIMI and DATMAT.
                            temp = 0.0;
                            for (i = 1; i <= n; ++i) {
                                sim[i][jdrop] = dx[i];
                                temp += simi[jdrop][i] * dx[i];
                            }
                            for (k = 1; k <= n; ++k) { simi[jdrop][k] /= temp; }
                            for (j = 1; j <= n; ++j) {
                                if (j !== jdrop) {
                                    temp = this.DOT_PRODUCT(this.PART(this.ROW(simi, j), 1, n), this.PART(dx, 1, n));
                                    for (k = 1; k <= n; ++k) {
                                        simi[j][k] -= temp * simi[jdrop][k];
                                    }
                                }
                            }
                            for (k = 1; k <= mpp; ++k) {
                                datmat[k][jdrop] = con[k];
                            }

                            //     Branch back for further iterations with the current RHO.
                            if (trured > 0.0 && trured >= 0.1 * prerem) {
                                continue L_140;
                            }
                        }
                    } while (false);

                    if (!iflag) {
                        ibrnch = false;
                        continue L_140;
                    }

                    if (rho <= rhoend) {
                        status = this.Normal;
                        break L_40;
                    }

                    //     Otherwise reduce RHO if it is not at its least value and reset PARMU.
                    cmin = 0.0;
                    cmax = 0.0;
                    rho *= 0.5;
                    if (rho <= 1.5 * rhoend) { rho = rhoend; }
                    if (parmu > 0.0) {
                        denom = 0.0;
                        for (k = 1; k <= mp; ++k) {
                            cmin = datmat[k][np];
                            cmax = cmin;
                            for (i = 1; i <= n; ++i) {
                                cmin = Math.min(cmin, datmat[k][i]);
                                cmax = Math.max(cmax, datmat[k][i]);
                            }
                            if (k <= m && cmin < 0.5 * cmax) {
                                temp = Math.max(cmax, 0.0) - cmin;
                                denom = denom <= 0.0 ? temp : Math.min(denom, temp);
                            }
                        }
                        if (denom === 0.0) {
                            parmu = 0.0;
                        } else if (cmax - cmin < parmu * denom) {
                            parmu = (cmax - cmin) / denom;
                        }
                    }
                    if (iprint >= 2) {
                        console.log("Reduction in RHO to "+rho+"  and PARMU = "+parmu);
                    }
                    if (iprint === 2) {
                        this.PrintIterationResult(nfvals, datmat[mp][np], datmat[mpp][np], this.COL(sim, np), n, iprint);
                    }
                } while (true);
            } while (true);

            switch (status) {
                case this.Normal:
                    if (iprint >= 1) { console.log("%nNormal return from subroutine COBYLA%n"); }
                    if (ifull) {
                        if (iprint >= 1) { this.PrintIterationResult(nfvals, f, resmax, x, n, iprint); }
                        return status;
                    }
                    break;
                case this.MaxIterationsReached:
                    if (iprint >= 1) {
                        console.log("%nReturn from subroutine COBYLA because the MAXFUN limit has been reached.%n");
                    }
                    break;
                case this.DivergingRoundingErrors:
                    if (iprint >= 1) {
                        console.log("%nReturn from subroutine COBYLA because rounding errors are becoming damaging.%n");
                    }
                    break;
            }

            for (k = 1; k <= n; ++k) { x[k] = sim[k][np]; }
            f = datmat[mp][np];
            resmax = datmat[mpp][np];
            if (iprint >= 1) { this.PrintIterationResult(nfvals, f, resmax, x, n, iprint); }

            return status;
        },

        trstlp: function(n,  m,  a, b, rho,  dx) { //(int n, int m, double[][] a, double[] b, double rho, double[] dx)
            // N.B. Arguments Z, ZDOTA, VMULTC, SDIRN, DXNEW, VMULTD & IACT have been removed.

            //     This subroutine calculates an N-component vector DX by applying the
            //     following two stages. In the first stage, DX is set to the shortest
            //     vector that minimizes the greatest violation of the constraints
            //       A(1,K)*DX(1)+A(2,K)*DX(2)+...+A(N,K)*DX(N) .GE. B(K), K = 2,3,...,M,
            //     subject to the Euclidean length of DX being at most RHO. If its length is
            //     strictly less than RHO, then we use the resultant freedom in DX to
            //     minimize the objective function
            //              -A(1,M+1)*DX(1) - A(2,M+1)*DX(2) - ... - A(N,M+1)*DX(N)
            //     subject to no increase in any greatest constraint violation. This
            //     notation allows the gradient of the objective function to be regarded as
            //     the gradient of a constraint. Therefore the two stages are distinguished
            //     by MCON .EQ. M and MCON .GT. M respectively. It is possible that a
            //     degeneracy may prevent DX from attaining the target length RHO. Then the
            //     value IFULL = 0 would be set, but usually IFULL = 1 on return.
            //
            //     In general NACT is the number of constraints in the active set and
            //     IACT(1),...,IACT(NACT) are their indices, while the remainder of IACT
            //     contains a permutation of the remaining constraint indices.  Further, Z
            //     is an orthogonal matrix whose first NACT columns can be regarded as the
            //     result of Gram-Schmidt applied to the active constraint gradients.  For
            //     J = 1,2,...,NACT, the number ZDOTA(J) is the scalar product of the J-th
            //     column of Z with the gradient of the J-th active constraint.  DX is the
            //     current vector of variables and here the residuals of the active
            //     constraints should be zero. Further, the active constraints have
            //     nonnegative Lagrange multipliers that are held at the beginning of
            //     VMULTC. The remainder of this vector holds the residuals of the inactive
            //     constraints at DX, the ordering of the components of VMULTC being in
            //     agreement with the permutation of the indices of the constraints that is
            //     in IACT. All these residuals are nonnegative, which is achieved by the
            //     shift RESMAX that makes the least residual zero.

            //     Initialize Z and some other variables. The value of RESMAX will be
            //     appropriate to DX = 0, while ICON will be the index of a most violated
            //     constraint if RESMAX is positive. Usually during the first stage the
            //     vector SDIRN gives a search direction that reduces all the active
            //     constraint violations by one simultaneously.

            // Local variables

            var temp = 0,
                nactx = 0,
                resold = 0.0,

                z = this.arr2(1 + n, 1 + n),
                zdota = this.arr(2 + m),
                vmultc = this.arr(2 + m),
                sdirn = this.arr(1 + n),
                dxnew = this.arr(1 + n),
                vmultd = this.arr(2 + m),
                iact = this.arr(2 + m),

                mcon = m,
                nact = 0,
                icon, resmax,
                i, k,
                first,
                optold, icount, step, stpful, optnew,
                ratio, isave, vsave,
                total,
                kp, kk, sp, alpha, beta,
                tot, spabs, acca, accb,
                zdotv, zdvabs, kw,
                dd, ss, sd,
                zdotw, zdwabs,
                kl, sumabs, tempa;

            for (i = 1; i <= n; ++i) {
                z[i][i] = 1.0;
                dx[i] = 0.0;
            }

            icon = 0;
            resmax = 0.0;
            if (m >= 1) {
                for (k = 1; k <= m; ++k) {
                    if (b[k] > resmax) {
                        resmax = b[k];
                        icon = k;
                    }
                }
                for (k = 1; k <= m; ++k) {
                    iact[k] = k;
                    vmultc[k] = resmax - b[k];
                }
            }

            //     End the current stage of the calculation if 3 consecutive iterations
            //     have either failed to reduce the best calculated value of the objective
            //     function or to increase the number of active constraints since the best
            //     value was calculated. This strategy prevents cycling, but there is a
            //     remote possibility that it will cause premature termination.

            first = true;
            do {
                L_60:
                do {
                    if (!first || (first && resmax === 0.0)) {
                        mcon = m + 1;
                        icon = mcon;
                        iact[mcon] = mcon;
                        vmultc[mcon] = 0.0;
                    }
                    first = false;

                    optold = 0.0;
                    icount = 0;
                    step = 0;
                    stpful = 0;

                    L_70:
                    do {
                        optnew = (mcon === m) ? resmax : -this.DOT_PRODUCT(
                                this.PART(dx, 1, n), this.PART(this.COL(a, mcon), 1, n)
                            );

                        if (icount === 0 || optnew < optold) {
                            optold = optnew;
                            nactx = nact;
                            icount = 3;
                        } else if (nact > nactx) {
                            nactx = nact;
                            icount = 3;
                        } else {
                            --icount;
                        }
                        if (icount === 0) { break L_60; }

                        //     If ICON exceeds NACT, then we add the constraint with index IACT(ICON) to
                        //     the active set. Apply Givens rotations so that the last N-NACT-1 columns
                        //     of Z are orthogonal to the gradient of the new constraint, a scalar
                        //     product being set to zero if its nonzero value could be due to computer
                        //     rounding errors. The array DXNEW is used for working space.
                        ratio = 0;
                        if (icon <= nact) {
                            if (icon < nact) {
                                //     Delete the constraint that has the index IACT(ICON) from the active set.

                                isave = iact[icon];
                                vsave = vmultc[icon];
                                k = icon;
                                do {
                                    kp = k + 1;
                                    kk = iact[kp];
                                    sp = this.DOT_PRODUCT(
                                            this.PART(this.COL(z, k), 1, n),
                                            this.PART(this.COL(a, kk), 1, n)
                                        );
                                    temp = Math.sqrt(sp * sp + zdota[kp] * zdota[kp]);
                                    alpha = zdota[kp] / temp;
                                    beta = sp / temp;
                                    zdota[kp] = alpha * zdota[k];
                                    zdota[k] = temp;
                                    for (i = 1; i <= n; ++i) {
                                        temp = alpha * z[i][kp] + beta * z[i][k];
                                        z[i][kp] = alpha * z[i][k] - beta * z[i][kp];
                                        z[i][k] = temp;
                                    }
                                    iact[k] = kk;
                                    vmultc[k] = vmultc[kp];
                                    k = kp;
                                } while (k < nact);

                                iact[k] = isave;
                                vmultc[k] = vsave;
                            }
                            --nact;

                            //     If stage one is in progress, then set SDIRN to the direction of the next
                            //     change to the current vector of variables.
                            if (mcon > m) {
                                //     Pick the next search direction of stage two.
                                temp = 1.0 / zdota[nact];
                                for (k = 1; k <= n; ++k) { sdirn[k] = temp * z[k][nact]; }
                            } else {
                                temp = this.DOT_PRODUCT(
                                        this.PART(sdirn, 1, n), this.PART(this.COL(z, nact + 1), 1, n)
                                    );
                                for (k = 1; k <= n; ++k) { sdirn[k] -= temp * z[k][nact + 1]; }
                            }
                        } else {
                            kk = iact[icon];
                            for (k = 1; k <= n; ++k) { dxnew[k] = a[k][kk]; }
                            tot = 0.0;

                            // {
                                k = n;
                                while (k > nact) {
                                    sp = 0.0;
                                    spabs = 0.0;
                                    for (i = 1; i <= n; ++i) {
                                        temp = z[i][k] * dxnew[i];
                                        sp += temp;
                                        spabs += Math.abs(temp);
                                    }
                                    acca = spabs + 0.1 * Math.abs(sp);
                                    accb = spabs + 0.2 * Math.abs(sp);
                                    if (spabs >= acca || acca >= accb) { sp = 0.0; }
                                    if (tot === 0.0) {
                                        tot = sp;
                                    } else {
                                        kp = k + 1;
                                        temp = Math.sqrt(sp * sp + tot * tot);
                                        alpha = sp / temp;
                                        beta = tot / temp;
                                        tot = temp;
                                        for (i = 1; i <= n; ++i) {
                                            temp = alpha * z[i][k] + beta * z[i][kp];
                                            z[i][kp] = alpha * z[i][kp] - beta * z[i][k];
                                            z[i][k] = temp;
                                        }
                                    }
                                    --k;
                                }
                            // }

                            if (tot === 0.0) {
                                //     The next instruction is reached if a deletion has to be made from the
                                //     active set in order to make room for the new active constraint, because
                                //     the new constraint gradient is a linear combination of the gradients of
                                //     the old active constraints.  Set the elements of VMULTD to the multipliers
                                //     of the linear combination.  Further, set IOUT to the index of the
                                //     constraint to be deleted, but branch if no suitable index can be found.

                                ratio = -1.0;
                                //{
                                    k = nact;
                                    do {
                                        zdotv = 0.0;
                                        zdvabs = 0.0;

                                        for (i = 1; i <= n; ++i) {
                                            temp = z[i][k] * dxnew[i];
                                            zdotv += temp;
                                            zdvabs += Math.abs(temp);
                                        }
                                        acca = zdvabs + 0.1 * Math.abs(zdotv);
                                        accb = zdvabs + 0.2 * Math.abs(zdotv);
                                        if (zdvabs < acca && acca < accb) {
                                            temp = zdotv / zdota[k];
                                            if (temp > 0.0 && iact[k] <= m) {
                                                tempa = vmultc[k] / temp;
                                                if (ratio < 0.0 || tempa < ratio) { ratio = tempa; }
                                            }

                                            if (k >= 2) {
                                                kw = iact[k];
                                                for (i = 1; i <= n; ++i) { dxnew[i] -= temp * a[i][kw]; }
                                            }
                                            vmultd[k] = temp;
                                        } else {
                                            vmultd[k] = 0.0;
                                        }
                                    } while (--k > 0);
                                //}
                                if (ratio < 0.0) { break L_60; }

                                //     Revise the Lagrange multipliers and reorder the active constraints so
                                //     that the one to be replaced is at the end of the list. Also calculate the
                                //     new value of ZDOTA(NACT) and branch if it is not acceptable.

                                for (k = 1; k <= nact; ++k) {
                                    vmultc[k] = Math.max(0.0, vmultc[k] - ratio * vmultd[k]);
                                }
                                if (icon < nact) {
                                    isave = iact[icon];
                                    vsave = vmultc[icon];
                                    k = icon;
                                    do {
                                        kp = k + 1;
                                        kw = iact[kp];
                                        sp = this.DOT_PRODUCT(
                                                this.PART(this.COL(z, k), 1, n),
                                                this.PART(this.COL(a, kw), 1, n)
                                            );
                                        temp = Math.sqrt(sp * sp + zdota[kp] * zdota[kp]);
                                        alpha = zdota[kp] / temp;
                                        beta = sp / temp;
                                        zdota[kp] = alpha * zdota[k];
                                        zdota[k] = temp;
                                        for (i = 1; i <= n; ++i) {
                                            temp = alpha * z[i][kp] + beta * z[i][k];
                                            z[i][kp] = alpha * z[i][k] - beta * z[i][kp];
                                            z[i][k] = temp;
                                        }
                                        iact[k] = kw;
                                        vmultc[k] = vmultc[kp];
                                        k = kp;
                                    } while (k < nact);
                                    iact[k] = isave;
                                    vmultc[k] = vsave;
                                }
                                temp = this.DOT_PRODUCT(
                                            this.PART(this.COL(z, nact), 1, n),
                                            this.PART(this.COL(a, kk), 1, n)
                                        );
                                if (temp === 0.0) { break L_60; }
                                zdota[nact] = temp;
                                vmultc[icon] = 0.0;
                                vmultc[nact] = ratio;
                            } else {
                                //     Add the new constraint if this can be done without a deletion from the
                                //     active set.

                                ++nact;
                                zdota[nact] = tot;
                                vmultc[icon] = vmultc[nact];
                                vmultc[nact] = 0.0;
                            }

                            //     Update IACT and ensure that the objective function continues to be
                            //     treated as the last active constraint when MCON>M.

                            iact[icon] = iact[nact];
                            iact[nact] = kk;
                            if (mcon > m && kk !== mcon) {
                                k = nact - 1;
                                sp = this.DOT_PRODUCT(
                                        this.PART(this.COL(z, k), 1, n),
                                        this.PART(this.COL(a, kk), 1, n)
                                    );
                                temp = Math.sqrt(sp * sp + zdota[nact] * zdota[nact]);
                                alpha = zdota[nact] / temp;
                                beta = sp / temp;
                                zdota[nact] = alpha * zdota[k];
                                zdota[k] = temp;
                                for (i = 1; i <= n; ++i) {
                                    temp = alpha * z[i][nact] + beta * z[i][k];
                                    z[i][nact] = alpha * z[i][k] - beta * z[i][nact];
                                    z[i][k] = temp;
                                }
                                iact[nact] = iact[k];
                                iact[k] = kk;
                                temp = vmultc[k];
                                vmultc[k] = vmultc[nact];
                                vmultc[nact] = temp;
                            }

                            //     If stage one is in progress, then set SDIRN to the direction of the next
                            //     change to the current vector of variables.
                            if (mcon > m) {
                                //     Pick the next search direction of stage two.
                                temp = 1.0 / zdota[nact];
                                for (k = 1; k <= n; ++k) { sdirn[k] = temp * z[k][nact]; }
                            } else {
                                kk = iact[nact];
                                temp = (this.DOT_PRODUCT(
                                            this.PART(sdirn, 1, n),
                                            this.PART(this.COL(a, kk), 1, n)
                                        ) - 1.0) / zdota[nact];
                                for (k = 1; k <= n; ++k) { sdirn[k] -= temp * z[k][nact]; }
                            }
                        }

                        //     Calculate the step to the boundary of the trust region or take the step
                        //     that reduces RESMAX to zero. The two statements below that include the
                        //     factor 1.0E-6 prevent some harmless underflows that occurred in a test
                        //     calculation. Further, we skip the step if it could be zero within a
                        //     reasonable tolerance for computer rounding errors.
                        dd = rho * rho;
                        sd = 0.0;
                        ss = 0.0;
                        for (i = 1; i <= n; ++i) {
                            if (Math.abs(dx[i]) >= 1.0E-6 * rho) { dd -= dx[i] * dx[i]; }
                            sd += dx[i] * sdirn[i];
                            ss += sdirn[i] * sdirn[i];
                        }
                        if (dd <= 0.0) { break L_60; }
                        temp = Math.sqrt(ss * dd);
                        if (Math.abs(sd) >= 1.0E-6 * temp) { temp = Math.sqrt(ss * dd + sd * sd); }
                        stpful = dd / (temp + sd);
                        step = stpful;
                        if (mcon === m) {
                            acca = step + 0.1 * resmax;
                            accb = step + 0.2 * resmax;
                            if (step >= acca || acca >= accb) { break L_70; }
                            step = Math.min(step, resmax);
                        }

                        //     Set DXNEW to the new variables if STEP is the steplength, and reduce
                        //     RESMAX to the corresponding maximum residual if stage one is being done.
                        //     Because DXNEW will be changed during the calculation of some Lagrange
                        //     multipliers, it will be restored to the following value later.
                        for (k = 1; k <= n; ++k) { dxnew[k] = dx[k] + step * sdirn[k]; }
                        if (mcon === m) {
                            resold = resmax;
                            resmax = 0.0;
                            for (k = 1; k <= nact; ++k) {
                                kk = iact[k];
                                temp = b[kk] - this.DOT_PRODUCT(
                                        this.PART(this.COL(a, kk), 1, n), this.PART(dxnew, 1, n)
                                    );
                                resmax = Math.max(resmax, temp);
                            }
                        }

                        //     Set VMULTD to the VMULTC vector that would occur if DX became DXNEW. A
                        //     device is included to force VMULTD(K) = 0.0 if deviations from this value
                        //     can be attributed to computer rounding errors. First calculate the new
                        //     Lagrange multipliers.
                        //{
                            k = nact;
                            do {
                                zdotw = 0.0;
                                zdwabs = 0.0;
                                for (i = 1; i <= n; ++i) {
                                    temp = z[i][k] * dxnew[i];
                                    zdotw += temp;
                                    zdwabs += Math.abs(temp);
                                }
                                acca = zdwabs + 0.1 * Math.abs(zdotw);
                                accb = zdwabs + 0.2 * Math.abs(zdotw);
                                if (zdwabs >= acca || acca >= accb) { zdotw = 0.0; }
                                vmultd[k] = zdotw / zdota[k];
                                if (k >= 2) {
                                    kk = iact[k];
                                    for (i = 1; i <= n; ++i) { dxnew[i] -= vmultd[k] * a[i][kk]; }
                                }
                            } while (k-- >= 2);
                            if (mcon > m) { vmultd[nact] = Math.max(0.0, vmultd[nact]); }
                        //}

                        //     Complete VMULTC by finding the new constraint residuals.

                        for (k = 1; k <= n; ++k) { dxnew[k] = dx[k] + step * sdirn[k]; }
                        if (mcon > nact) {
                            kl = nact + 1;
                            for (k = kl; k <= mcon; ++k) {
                                kk = iact[k];
                                total = resmax - b[kk];
                                sumabs = resmax + Math.abs(b[kk]);
                                for (i = 1; i <= n; ++i) {
                                    temp = a[i][kk] * dxnew[i];
                                    total += temp;
                                    sumabs += Math.abs(temp);
                                }
                                acca = sumabs + 0.1 * Math.abs(total);
                                accb = sumabs + 0.2 * Math.abs(total);
                                if (sumabs >= acca || acca >= accb) { total = 0.0; }
                                vmultd[k] = total;
                            }
                        }

                        //     Calculate the fraction of the step from DX to DXNEW that will be taken.

                        ratio = 1.0;
                        icon = 0;
                        for (k = 1; k <= mcon; ++k) {
                            if (vmultd[k] < 0.0) {
                                temp = vmultc[k] / (vmultc[k] - vmultd[k]);
                                if (temp < ratio) {
                                    ratio = temp;
                                    icon = k;
                                }
                            }
                        }

                        //     Update DX, VMULTC and RESMAX.

                        temp = 1.0 - ratio;
                        for (k = 1; k <= n; ++k) { dx[k] = temp * dx[k] + ratio * dxnew[k]; }
                        for (k = 1; k <= mcon; ++k) {
                            vmultc[k] = Math.max(0.0, temp * vmultc[k] + ratio * vmultd[k]);
                        }
                        if (mcon === m) { resmax = resold + ratio * (resmax - resold); }

                        //     If the full step is not acceptable then begin another iteration.
                        //     Otherwise switch to stage two or end the calculation.
                    } while (icon > 0);

                    if (step === stpful) {
                        return true;
                    }

                } while (true);

                //     We employ any freedom that may be available to reduce the objective
                //     function before returning a DX whose length is less than RHO.

            } while (mcon === m);

            return false;
        },

        PrintIterationResult: function(nfvals, f, resmax,  x,  n, iprint) {
            if (iprint > 1) { console.log("NFVALS = "+nfvals+"  F = "+f+"  MAXCV = "+resmax); }
            if (iprint > 1) { console.log("X = " + this.PART(x, 1, n)); }
        },

        ROW: function(src, rowidx) {
            return src[rowidx].slice();
            // var col,
            //     cols = src[0].length,
            //     dest = this.arr(cols);

            // for (col = 0; col < cols; ++col) {
            //     dest[col] = src[rowidx][col];
            // }
            // return dest;
        },

        COL: function(src, colidx) {
            var row,
                rows = src.length,
                dest = this.arr(rows);
            for (row = 0; row < rows; ++row) {
                dest[row] = src[row][colidx];
            }
            return dest;
        },

        PART: function(src, from, to) {
            return src.slice(from, to + 1);
            // var srcidx,
            //     dest = this.arr(to - from + 1),
            //     destidx = 0;
            // for (srcidx = from; srcidx <= to; ++srcidx, ++destidx) {
            //     dest[destidx] = src[srcidx];
            // }
            // return dest;
        },

        FORMAT: function(x) {
            return x.join(',');
            // var i, fmt = "";
            // for (i = 0; i < x.length; ++i) {
            //     fmt += ", " + x[i];
            // }
            // return fmt;
        },

        DOT_PRODUCT: function(lhs,  rhs) {
            var i, sum = 0.0,
                len = lhs.length;
            for (i = 0; i < len; ++i) {
                sum += lhs[i] * rhs[i];
            }
            return sum;
        }

    };

    return JXG.Math.Nlp;
});

/*
    Copyright 2008-2022
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <http://www.gnu.org/licenses/>
    and <http://opensource.org/licenses/MIT/>.
 */


/*global JXG: true, define: true*/
/*jslint nomen: true, plusplus: true*/

/* depends:
 jxg
 math/math
 utils/type
 */

define('math/statistics',['jxg', 'math/math', 'utils/type'], function (JXG, Mat, Type) {

    "use strict";

    /**
     * Functions for mathematical statistics. Most functions are like in the statistics package R.
     * @name JXG.Math.Statistics
     * @exports Mat.Statistics as JXG.Math.Statistics
     * @namespace
     */
    Mat.Statistics = {
        /**
         * Sums up all elements of the given array.
         * @param {Array} arr An array of numbers.
         * @returns {Number}
         * @memberof JXG.Math.Statistics
         */
        sum: function (arr) {
            var i,
                len = arr.length,
                res = 0;

            for (i = 0; i < len; i++) {
                res += arr[i];
            }
            return res;
        },

        /**
         * Multiplies all elements of the given array.
         * @param {Array} arr An array of numbers.
         * @returns {Number}
         * @memberof JXG.Math.Statistics
         */
        prod: function (arr) {
            var i,
                len = arr.length,
                res = 1;

            for (i = 0; i < len; i++) {
                res *= arr[i];
            }
            return res;
        },

        /**
         * Determines the mean value of the values given in an array.
         * @param {Array} arr
         * @returns {Number}
         * @memberof JXG.Math.Statistics
         */
        mean: function (arr) {
            if (arr.length > 0) {
                return this.sum(arr) / arr.length;
            }

            return 0.0;
        },

        /**
         * The median of a finite set of values is the value that divides the set
         * into two equal sized subsets.
         * @param {Array} arr The set of values.
         * @returns {Number}
         * @memberof JXG.Math.Statistics
         */
        median: function (arr) {
            var tmp, len;

            if (arr.length > 0) {
                if (ArrayBuffer.isView(arr)) {
                    tmp = new Float64Array(arr);
                    tmp.sort();
                } else {
                    tmp = arr.slice(0);
                    tmp.sort(function (a, b) {
                        return a - b;
                    });
                }
                len = tmp.length;

                if (len & 1) { // odd
                    return tmp[parseInt(len * 0.5, 10)];
                }

                return (tmp[len * 0.5 - 1] + tmp[len * 0.5]) * 0.5;
            }

            return 0.0;
        },

        /**
         * The P-th percentile ( 0 < P ≤ 100 ) of a list of N ordered values (sorted from least to greatest)
         * is the smallest value in the list such that no more than P percent of the data is strictly less
         * than the value and at least P percent of the data is less than or equal to that value. See {@link https://en.wikipedia.org/wiki/Percentile}.
         *
         * Here, the <i>linear interpolation between closest ranks</i> method is used.
         * @param {Array} arr The set of values, need not be ordered.
         * @param {Number|Array} percentile One or several percentiles
         * @returns {Number|Array} Depending if a number or an array is the input for percentile, a number or an array containing the percentils
         * is returned.
         */
        percentile: function(arr, percentile) {
            var tmp, len, i, p, res = [], per;

            if (arr.length > 0) {
                if (ArrayBuffer.isView(arr)) {
                    tmp = new Float64Array(arr);
                    tmp.sort();
                } else {
                    tmp = arr.slice(0);
                    tmp.sort(function (a, b) {
                        return a - b;
                    });
                }
                len = tmp.length;

                if (Type.isArray(percentile)) {
                    p = percentile;
                } else {
                    p = [percentile];
                }

                for (i = 0; i < p.length; i++) {
                    per = len * p[i] * 0.01;
                    if (parseInt(per, 10) === per) {
                        res.push( (tmp[per - 1] + tmp[per]) * 0.5 );
                    } else {
                        res.push( tmp[parseInt(per, 10)] );
                    }
                }

                if (Type.isArray(percentile)) {
                    return res;
                } else {
                    return res[0];
                }
            }

            return 0.0;
        },

        /**
         * Bias-corrected sample variance. A variance is a measure of how far a
         * set of numbers are spread out from each other.
         * @param {Array} arr
         * @returns {Number}
         * @memberof JXG.Math.Statistics
         */
        variance: function (arr) {
            var m, res, i, len = arr.length;

            if (len > 1) {
                m = this.mean(arr);
                res = 0;
                for (i = 0; i < len; i++) {
                    res += (arr[i] - m) * (arr[i] - m);
                }
                return res / (arr.length - 1);
            }

            return 0.0;
        },

        /**
         * Determines the <strong>s</strong>tandard <strong>d</strong>eviation which shows how much
         * variation there is from the average value of a set of numbers.
         * @param {Array} arr
         * @returns {Number}
         * @memberof JXG.Math.Statistics
         */
        sd: function (arr) {
            return Math.sqrt(this.variance(arr));
        },

        /**
         * Weighted mean value is basically the same as {@link JXG.Math.Statistics.mean} but here the values
         * are weighted, i.e. multiplied with another value called <em>weight</em>. The weight values are given
         * as a second array with the same length as the value array..
         * @throws {Error} If the dimensions of the arrays don't match.
         * @param {Array} arr Set of alues.
         * @param {Array} w Weight values.
         * @returns {Number}
         * @memberof JXG.Math.Statistics
         */
        weightedMean: function (arr, w) {
            if (arr.length !== w.length) {
                throw new Error('JSXGraph error (Math.Statistics.weightedMean): Array dimension mismatch.');
            }

            if (arr.length > 0) {
                return this.mean(this.multiply(arr, w));
            }

            return 0.0;
        },

        /**
         * Extracts the maximum value from the array.
         * @param {Array} arr
         * @returns {Number} The highest number from the array. It returns <tt>NaN</tt> if not every element could be
         * interpreted as a number and <tt>-Infinity</tt> if an empty array is given or no element could be interpreted
         * as a number.
         * @memberof JXG.Math.Statistics
         */
        max: function (arr) {
            return Math.max.apply(this, arr);
        },

        /**
         * Extracts the minimum value from the array.
         * @param {Array} arr
         * @returns {Number} The lowest number from the array. It returns <tt>NaN</tt> if not every element could be
         * interpreted as a number and <tt>Infinity</tt> if an empty array is given or no element could be interpreted
         * as a number.
         * @memberof JXG.Math.Statistics
         */
        min: function (arr) {
            return Math.min.apply(this, arr);
        },

        /**
         * Determines the lowest and the highest value from the given array.
         * @param {Array} arr
         * @returns {Array} The minimum value as the first and the maximum value as the second value.
         * @memberof JXG.Math.Statistics
         */
        range: function (arr) {
            return [this.min(arr), this.max(arr)];
        },

        /**
         * Determines the absolute value of every given value.
         * @param {Array|Number} arr
         * @returns {Array|Number}
         * @memberof JXG.Math.Statistics
         */
        abs: function (arr) {
            var i, len, res;

            if (Type.isArray(arr)) {
                if (arr.map) {
                    res = arr.map(Math.abs);
                } else {
                    len = arr.length;
                    res = [];

                    for (i = 0; i < len; i++) {
                        res[i] = Math.abs(arr[i]);
                    }
                }
            } else if (ArrayBuffer.isView(arr)) {
                res = arr.map(Math.abs);
            } else {
                res = Math.abs(arr);
            }
            return res;
        },

        /**
         * Adds up two (sequences of) values. If one value is an array and the other one is a number the number
         * is added to every element of the array. If two arrays are given and the lengths don't match the shortest
         * length is taken.
         * @param {Array|Number} arr1
         * @param {Array|Number} arr2
         * @returns {Array|Number}
         * @memberof JXG.Math.Statistics
         */
        add: function (arr1, arr2) {
            var i, len, res = [];

            arr1 = Type.evalSlider(arr1);
            arr2 = Type.evalSlider(arr2);

            if (Type.isArray(arr1) && Type.isNumber(arr2)) {
                len = arr1.length;

                for (i = 0; i < len; i++) {
                    res[i] = arr1[i] + arr2;
                }
            } else if (Type.isNumber(arr1) && Type.isArray(arr2)) {
                len = arr2.length;

                for (i = 0; i < len; i++) {
                    res[i] = arr1 + arr2[i];
                }
            } else if (Type.isArray(arr1) && Type.isArray(arr2)) {
                len = Math.min(arr1.length, arr2.length);

                for (i = 0; i < len; i++) {
                    res[i] = arr1[i] + arr2[i];
                }
            } else {
                res = arr1 + arr2;
            }

            return res;
        },

        /**
         * Divides two (sequences of) values. If two arrays are given and the lengths don't match the shortest length
         * is taken.
         * @param {Array|Number} arr1 Dividend
         * @param {Array|Number} arr2 Divisor
         * @returns {Array|Number}
         * @memberof JXG.Math.Statistics
         */
        div: function (arr1, arr2) {
            var i, len, res = [];

            arr1 = Type.evalSlider(arr1);
            arr2 = Type.evalSlider(arr2);

            if (Type.isArray(arr1) && Type.isNumber(arr2)) {
                len = arr1.length;

                for (i = 0; i < len; i++) {
                    res[i] = arr1[i] / arr2;
                }
            } else if (Type.isNumber(arr1) && Type.isArray(arr2)) {
                len = arr2.length;

                for (i = 0; i < len; i++) {
                    res[i] = arr1 / arr2[i];
                }
            } else if (Type.isArray(arr1) && Type.isArray(arr2)) {
                len = Math.min(arr1.length, arr2.length);

                for (i = 0; i < len; i++) {
                    res[i] = arr1[i] / arr2[i];
                }
            } else {
                res = arr1 / arr2;
            }

            return res;
        },

        /**
         * @function
         * @deprecated Use {@link JXG.Math.Statistics.div} instead.
         * @memberof JXG.Math.Statistics
         */
        divide: function () {
            JXG.deprecated('Statistics.divide()', 'Statistics.div()');
            Mat.Statistics.div.apply(Mat.Statistics, arguments);
        },

        /**
         * Divides two (sequences of) values and returns the remainder. If two arrays are given and the lengths don't
         * match the shortest length is taken.
         * @param {Array|Number} arr1 Dividend
         * @param {Array|Number} arr2 Divisor
         * @param {Boolean} [math=false] Mathematical mod or symmetric mod? Default is symmetric, the JavaScript <tt>%</tt> operator.
         * @returns {Array|Number}
         * @memberof JXG.Math.Statistics
         */
        mod: function (arr1, arr2, math) {
            var i, len, res = [], mod = function (a, m) {
                return a % m;
            };

            math = Type.def(math, false);

            if (math) {
                mod = Mat.mod;
            }

            arr1 = Type.evalSlider(arr1);
            arr2 = Type.evalSlider(arr2);

            if (Type.isArray(arr1) && Type.isNumber(arr2)) {
                len = arr1.length;

                for (i = 0; i < len; i++) {
                    res[i] = mod(arr1[i], arr2);
                }
            } else if (Type.isNumber(arr1) && Type.isArray(arr2)) {
                len = arr2.length;

                for (i = 0; i < len; i++) {
                    res[i] = mod(arr1, arr2[i]);
                }
            } else if (Type.isArray(arr1) && Type.isArray(arr2)) {
                len = Math.min(arr1.length, arr2.length);

                for (i = 0; i < len; i++) {
                    res[i] = mod(arr1[i], arr2[i]);
                }
            } else {
                res = mod(arr1, arr2);
            }

            return res;
        },

        /**
         * Multiplies two (sequences of) values. If one value is an array and the other one is a number the number
         * is multiplied to every element of the array. If two arrays are given and the lengths don't match the shortest
         * length is taken.
         * @param {Array|Number} arr1
         * @param {Array|Number} arr2
         * @returns {Array|Number}
         * @memberof JXG.Math.Statistics
         */
        multiply: function (arr1, arr2) {
            var i, len, res = [];

            arr1 = Type.evalSlider(arr1);
            arr2 = Type.evalSlider(arr2);

            if (Type.isArray(arr1) && Type.isNumber(arr2)) {
                len = arr1.length;

                for (i = 0; i < len; i++) {
                    res[i] = arr1[i] * arr2;
                }
            } else if (Type.isNumber(arr1) && Type.isArray(arr2)) {
                len = arr2.length;

                for (i = 0; i < len; i++) {
                    res[i] = arr1 * arr2[i];
                }
            } else if (Type.isArray(arr1) && Type.isArray(arr2)) {
                len = Math.min(arr1.length, arr2.length);

                for (i = 0; i < len; i++) {
                    res[i] = arr1[i] * arr2[i];
                }
            } else {
                res = arr1 * arr2;
            }

            return res;
        },

        /**
         * Subtracts two (sequences of) values. If two arrays are given and the lengths don't match the shortest
         * length is taken.
         * @param {Array|Number} arr1 Minuend
         * @param {Array|Number} arr2 Subtrahend
         * @returns {Array|Number}
         * @memberof JXG.Math.Statistics
         */
        subtract: function (arr1, arr2) {
            var i, len, res = [];

            arr1 = Type.evalSlider(arr1);
            arr2 = Type.evalSlider(arr2);

            if (Type.isArray(arr1) && Type.isNumber(arr2)) {
                len = arr1.length;

                for (i = 0; i < len; i++) {
                    res[i] = arr1[i] - arr2;
                }
            } else if (Type.isNumber(arr1) && Type.isArray(arr2)) {
                len = arr2.length;

                for (i = 0; i < len; i++) {
                    res[i] = arr1 - arr2[i];
                }
            } else if (Type.isArray(arr1) && Type.isArray(arr2)) {
                len = Math.min(arr1.length, arr2.length);

                for (i = 0; i < len; i++) {
                    res[i] = arr1[i] - arr2[i];
                }
            } else {
                res = arr1 - arr2;
            }

            return res;
        },

        /**
         * The Theil-Sen estimator can be used to determine a more robust linear regression of a set of sample
         * points than least squares regression in {@link JXG.Math.Numerics.regressionPolynomial}.
         *
         * If the function should be applied to an array a of points, a the coords array can be generated with
         * JavaScript array.map:
         *
         * <pre>
         * JXG.Math.Statistics.TheilSenRegression(a.map(el => el.coords));
         * </pre>
         *
         * @param {Array} coords Array of {@link JXG.Coords}.
         * @returns {Array} A stdform array of the regression line.
         * @memberof JXG.Math.Statistics
         *
         * @example
         * var board = JXG.JSXGraph.initBoard('jxgbox', { boundingbox: [-6,6,6,-6], axis : true });
         * var a=[];
         * a[0]=board.create('point', [0,0]);
         * a[1]=board.create('point', [3,0]);
         * a[2]=board.create('point', [0,3]);
         *
         * board.create('line', [
         *     () => JXG.Math.Statistics.TheilSenRegression(a.map(el => el.coords))
         *   ],
         *   {strokeWidth:1, strokeColor:'black'});
         *
         * </pre><div id="JXG0a28be85-91c5-44d3-aae6-114e81217cf0" class="jxgbox" style="width: 300px; height: 300px;"></div>
         * <script type="text/javascript">
         *     (function() {
         *         var board = JXG.JSXGraph.initBoard('JXG0a28be85-91c5-44d3-aae6-114e81217cf0',
         *             {boundingbox: [-8, 8, 8,-8], axis: true, showcopyright: false, shownavigation: false});
         *     var board = JXG.JSXGraph.initBoard('jxgbox', { boundingbox: [-6,6,6,-6], axis : true });
         *     var a=[];
         *     a[0]=board.create('point', [0,0]);
         *     a[1]=board.create('point', [3,0]);
         *     a[2]=board.create('point', [0,3]);
         *
         *     board.create('line', [
         *         () => JXG.Math.Statistics.TheilSenRegression(a.map(el => el.coords))
         *       ],
         *       {strokeWidth:1, strokeColor:'black'});
         *
         *     })();
         *
         * </script><pre>
         *
         */
        TheilSenRegression: function (coords) {
            var i, j,
                slopes = [],
                tmpslopes = [],
                yintercepts = [];

            for (i = 0; i < coords.length; i++) {
                tmpslopes.length = 0;

                for (j = 0; j < coords.length; j++) {
                    if (Math.abs(coords[j].usrCoords[1] - coords[i].usrCoords[1]) > Mat.eps) {
                        tmpslopes[j] = (coords[j].usrCoords[2] - coords[i].usrCoords[2]) /
                            (coords[j].usrCoords[1] - coords[i].usrCoords[1]);
                    }
                }

                slopes[i] = this.median(tmpslopes);
                yintercepts.push(coords[i].usrCoords[2] - slopes[i] * coords[i].usrCoords[1]);
            }

            return [this.median(yintercepts), this.median(slopes), -1];
        },

        /**
         * Generate values of a standard normal random variable with the Marsaglia polar method, see
         * https://en.wikipedia.org/wiki/Marsaglia_polar_method .
         *
         * @param {Number} mean mean value of the normal distribution
         * @param {Number} stdDev standard deviation of the normal distribution
         * @returns {Number} value of a standard normal random variable
         */
        generateGaussian: function (mean, stdDev) {
            var u, v, s;

            if (this.hasSpare) {
                this.hasSpare = false;
                return this.spare * stdDev + mean;
            }

            do {
                u = Math.random() * 2 - 1;
                v = Math.random() * 2 - 1;
                s = u * u + v * v;
            } while (s >= 1 || s === 0);

            s = Math.sqrt(-2.0 * Math.log(s) / s);

            this.spare = v * s;
            this.hasSpare = true;
            return mean + stdDev * u * s;
        }
    };

    return Mat.Statistics;
});

/*
    Copyright 2008-2022
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Andreas Walter,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <http://www.gnu.org/licenses/>
    and <http://opensource.org/licenses/MIT/>.
 */


/*global JXG: true, define: true*/
/*jslint nomen: true, plusplus: true*/

/* depends:
 jxg
 base/constants
 base/coords
 math/math
 math/numerics
 utils/type
 */

/**
 * @fileoverview This file contains the Math.Geometry namespace for calculating algebraic/geometric
 * stuff like intersection points, angles, midpoint, and so on.
 */

define('math/geometry',[
    'jxg', 'base/constants', 'base/coords', 'math/math', 'math/numerics', 'utils/type', 'utils/expect'
], function (JXG, Const, Coords, Mat, Numerics, Type, Expect) {

    "use strict";

    /**
     * Math.Geometry namespace definition. This namespace holds geometrical algorithms,
     * especially intersection algorithms.
     * @name JXG.Math.Geometry
     * @namespace
     */
    Mat.Geometry = {};

// the splitting is necessary due to the shortcut for the circumcircleMidpoint method to circumcenter.

    JXG.extend(Mat.Geometry, /** @lends JXG.Math.Geometry */ {
        /* ***************************************/
        /* *** GENERAL GEOMETRIC CALCULATIONS ****/
        /* ***************************************/

        /**
         * Calculates the angle defined by the points A, B, C.
         * @param {JXG.Point,Array} A A point  or [x,y] array.
         * @param {JXG.Point,Array} B Another point or [x,y] array.
         * @param {JXG.Point,Array} C A circle - no, of course the third point or [x,y] array.
         * @deprecated Use {@link JXG.Math.Geometry.rad} instead.
         * @see #rad
         * @see #trueAngle
         * @returns {Number} The angle in radian measure.
         */
        angle: function (A, B, C) {
            var u, v, s, t,
                a = [],
                b = [],
                c = [];

            JXG.deprecated('Geometry.angle()', 'Geometry.rad()');
            if (A.coords) {
                a[0] = A.coords.usrCoords[1];
                a[1] = A.coords.usrCoords[2];
            } else {
                a[0] = A[0];
                a[1] = A[1];
            }

            if (B.coords) {
                b[0] = B.coords.usrCoords[1];
                b[1] = B.coords.usrCoords[2];
            } else {
                b[0] = B[0];
                b[1] = B[1];
            }

            if (C.coords) {
                c[0] = C.coords.usrCoords[1];
                c[1] = C.coords.usrCoords[2];
            } else {
                c[0] = C[0];
                c[1] = C[1];
            }

            u = a[0] - b[0];
            v = a[1] - b[1];
            s = c[0] - b[0];
            t = c[1] - b[1];

            return Math.atan2(u * t - v * s, u * s + v * t);
        },

        /**
         * Calculates the angle defined by the three points A, B, C if you're going from A to C around B counterclockwise.
         * @param {JXG.Point,Array} A Point or [x,y] array
         * @param {JXG.Point,Array} B Point or [x,y] array
         * @param {JXG.Point,Array} C Point or [x,y] array
         * @see #rad
         * @returns {Number} The angle in degrees.
         */
        trueAngle: function (A, B, C) {
            return this.rad(A, B, C) * 57.295779513082323; // *180.0/Math.PI;
        },

        /**
         * Calculates the internal angle defined by the three points A, B, C if you're going from A to C around B counterclockwise.
         * @param {JXG.Point,Array} A Point or [x,y] array
         * @param {JXG.Point,Array} B Point or [x,y] array
         * @param {JXG.Point,Array} C Point or [x,y] array
         * @see #trueAngle
         * @returns {Number} Angle in radians.
         */
        rad: function (A, B, C) {
            var ax, ay, bx, by, cx, cy, phi;

            if (A.coords) {
                ax = A.coords.usrCoords[1];
                ay = A.coords.usrCoords[2];
            } else {
                ax = A[0];
                ay = A[1];
            }

            if (B.coords) {
                bx = B.coords.usrCoords[1];
                by = B.coords.usrCoords[2];
            } else {
                bx = B[0];
                by = B[1];
            }

            if (C.coords) {
                cx = C.coords.usrCoords[1];
                cy = C.coords.usrCoords[2];
            } else {
                cx = C[0];
                cy = C[1];
            }

            phi = Math.atan2(cy - by, cx - bx) - Math.atan2(ay - by, ax - bx);

            if (phi < 0) {
                phi += 6.2831853071795862;
            }

            return phi;
        },

        /**
         * Calculates a point on the bisection line between the three points A, B, C.
         * As a result, the bisection line is defined by two points:
         * Parameter B and the point with the coordinates calculated in this function.
         * Does not work for ideal points.
         * @param {JXG.Point} A Point
         * @param {JXG.Point} B Point
         * @param {JXG.Point} C Point
         * @param [board=A.board] Reference to the board
         * @returns {JXG.Coords} Coordinates of the second point defining the bisection.
         */
        angleBisector: function (A, B, C, board) {
            var phiA, phiC, phi,
                Ac = A.coords.usrCoords,
                Bc = B.coords.usrCoords,
                Cc = C.coords.usrCoords,
                x, y;

            if (!Type.exists(board)) {
                board = A.board;
            }

            // Parallel lines
            if (Bc[0] === 0) {
                return new Coords(Const.COORDS_BY_USER,
                    [1, (Ac[1] + Cc[1]) * 0.5, (Ac[2] + Cc[2]) * 0.5], board);
            }

            // Non-parallel lines
            x = Ac[1] - Bc[1];
            y = Ac[2] - Bc[2];
            phiA =  Math.atan2(y, x);

            x = Cc[1] - Bc[1];
            y = Cc[2] - Bc[2];
            phiC =  Math.atan2(y, x);

            phi = (phiA + phiC) * 0.5;

            if (phiA > phiC) {
                phi += Math.PI;
            }

            x = Math.cos(phi) + Bc[1];
            y = Math.sin(phi) + Bc[2];

            return new Coords(Const.COORDS_BY_USER, [1, x, y], board);
        },

        // /**
        //  * Calculates a point on the m-section line between the three points A, B, C.
        //  * As a result, the m-section line is defined by two points:
        //  * Parameter B and the point with the coordinates calculated in this function.
        //  * The m-section generalizes the bisector to any real number.
        //  * For example, the trisectors of an angle are simply the 1/3-sector and the 2/3-sector.
        //  * Does not work for ideal points.
        //  * @param {JXG.Point} A Point
        //  * @param {JXG.Point} B Point
        //  * @param {JXG.Point} C Point
        //  * @param {Number} m Number
        //  * @param [board=A.board] Reference to the board
        //  * @returns {JXG.Coords} Coordinates of the second point defining the bisection.
        //  */
        // angleMsector: function (A, B, C, m, board) {
        //     var phiA, phiC, phi,
        //         Ac = A.coords.usrCoords,
        //         Bc = B.coords.usrCoords,
        //         Cc = C.coords.usrCoords,
        //         x, y;

        //     if (!Type.exists(board)) {
        //         board = A.board;
        //     }

        //     // Parallel lines
        //     if (Bc[0] === 0) {
        //         return new Coords(Const.COORDS_BY_USER,
        //             [1, (Ac[1] + Cc[1]) * m, (Ac[2] + Cc[2]) * m], board);
        //     }

        //     // Non-parallel lines
        //     x = Ac[1] - Bc[1];
        //     y = Ac[2] - Bc[2];
        //     phiA =  Math.atan2(y, x);

        //     x = Cc[1] - Bc[1];
        //     y = Cc[2] - Bc[2];
        //     phiC =  Math.atan2(y, x);

        //     phi = phiA + ((phiC - phiA) * m);

        //     if (phiA - phiC > Math.PI) {
        //         phi += 2*m*Math.PI;
        //     }

        //     x = Math.cos(phi) + Bc[1];
        //     y = Math.sin(phi) + Bc[2];

        //     return new Coords(Const.COORDS_BY_USER, [1, x, y], board);
        // },

        /**
         * Reflects the point along the line.
         * @param {JXG.Line} line Axis of reflection.
         * @param {JXG.Point} point Point to reflect.
         * @param [board=point.board] Reference to the board
         * @returns {JXG.Coords} Coordinates of the reflected point.
         */
        reflection: function (line, point, board) {
            // (v,w) defines the slope of the line
            var x0, y0, x1, y1, v, w, mu,
                pc = point.coords.usrCoords,
                p1c = line.point1.coords.usrCoords,
                p2c = line.point2.coords.usrCoords;

            if (!Type.exists(board)) {
                board = point.board;
            }

            v = p2c[1] - p1c[1];
            w = p2c[2] - p1c[2];

            x0 = pc[1] - p1c[1];
            y0 = pc[2] - p1c[2];

            mu = (v * y0 - w * x0) / (v * v + w * w);

            // point + mu*(-y,x) is the perpendicular foot
            x1 = pc[1] + 2 * mu * w;
            y1 = pc[2] - 2 * mu * v;

            return new Coords(Const.COORDS_BY_USER, [x1, y1], board);
        },

        /**
         * Computes the new position of a point which is rotated
         * around a second point (called rotpoint) by the angle phi.
         * @param {JXG.Point} rotpoint Center of the rotation
         * @param {JXG.Point} point point to be rotated
         * @param {Number} phi rotation angle in arc length
         * @param {JXG.Board} [board=point.board] Reference to the board
         * @returns {JXG.Coords} Coordinates of the new position.
         */
        rotation: function (rotpoint, point, phi, board) {
            var x0, y0, c, s, x1, y1,
                pc = point.coords.usrCoords,
                rotpc = rotpoint.coords.usrCoords;

            if (!Type.exists(board)) {
                board = point.board;
            }

            x0 = pc[1] - rotpc[1];
            y0 = pc[2] - rotpc[2];

            c = Math.cos(phi);
            s = Math.sin(phi);

            x1 = x0 * c - y0 * s + rotpc[1];
            y1 = x0 * s + y0 * c + rotpc[2];

            return new Coords(Const.COORDS_BY_USER, [x1, y1], board);
        },

        /**
         * Calculates the coordinates of a point on the perpendicular to the given line through
         * the given point.
         * @param {JXG.Line} line A line.
         * @param {JXG.Point} point Point which is projected to the line.
         * @param {JXG.Board} [board=point.board] Reference to the board
         * @returns {Array} Array of length two containing coordinates of a point on the perpendicular to the given line
         *                  through the given point and boolean flag "change".
         */
        perpendicular: function (line, point, board) {
            var x, y, change,
                c, z,
                A = line.point1.coords.usrCoords,
                B = line.point2.coords.usrCoords,
                C = point.coords.usrCoords;

            if (!Type.exists(board)) {
                board = point.board;
            }

            // special case: point is the first point of the line
            if (point === line.point1) {
                x = A[1] + B[2] - A[2];
                y = A[2] - B[1] + A[1];
                z = A[0] * B[0];

                if (Math.abs(z) < Mat.eps) {
                    x =  B[2];
                    y = -B[1];
                }
                c = [z, x, y];
                change = true;

            // special case: point is the second point of the line
            } else if (point === line.point2) {
                x = B[1] + A[2] - B[2];
                y = B[2] - A[1] + B[1];
                z = A[0] * B[0];

                if (Math.abs(z) < Mat.eps) {
                    x =  A[2];
                    y = -A[1];
                }
                c = [z, x, y];
                change = false;

            // special case: point lies somewhere else on the line
            } else if (Math.abs(Mat.innerProduct(C, line.stdform, 3)) < Mat.eps) {
                x = C[1] + B[2] - C[2];
                y = C[2] - B[1] + C[1];
                z = B[0];

                if (Math.abs(z) < Mat.eps) {
                    x =  B[2];
                    y = -B[1];
                }

                change = true;
                if (Math.abs(z) > Mat.eps && Math.abs(x - C[1]) < Mat.eps && Math.abs(y - C[2]) < Mat.eps) {
                    x = C[1] + A[2] - C[2];
                    y = C[2] - A[1] + C[1];
                    change = false;
                }
                c = [z, x, y];

            // general case: point does not lie on the line
            // -> calculate the foot of the dropped perpendicular
            } else {
                c = [0, line.stdform[1], line.stdform[2]];
                c = Mat.crossProduct(c, C);                  // perpendicuar to line
                c = Mat.crossProduct(c, line.stdform);       // intersection of line and perpendicular
                change = true;
            }

            return [new Coords(Const.COORDS_BY_USER, c, board), change];
        },

        /**
         * @deprecated Please use {@link JXG.Math.Geometry.circumcenter} instead.
         */
        circumcenterMidpoint: function () {
            JXG.deprecated('Geometry.circumcenterMidpoint()', 'Geometry.circumcenter()');
            this.circumcenter.apply(this, arguments);
        },

        /**
         * Calculates the center of the circumcircle of the three given points.
         * @param {JXG.Point} point1 Point
         * @param {JXG.Point} point2 Point
         * @param {JXG.Point} point3 Point
         * @param {JXG.Board} [board=point1.board] Reference to the board
         * @returns {JXG.Coords} Coordinates of the center of the circumcircle of the given points.
         */
        circumcenter: function (point1, point2, point3, board) {
            var u, v, m1, m2,
                A = point1.coords.usrCoords,
                B = point2.coords.usrCoords,
                C = point3.coords.usrCoords;

            if (!Type.exists(board)) {
                board = point1.board;
            }

            u = [B[0] - A[0], -B[2] + A[2], B[1] - A[1]];
            v = [(A[0] + B[0])  * 0.5, (A[1] + B[1]) * 0.5, (A[2] + B[2]) * 0.5];
            m1 = Mat.crossProduct(u, v);

            u = [C[0] - B[0], -C[2] + B[2], C[1] - B[1]];
            v = [(B[0] + C[0]) * 0.5, (B[1] + C[1]) * 0.5, (B[2] + C[2]) * 0.5];
            m2 = Mat.crossProduct(u, v);

            return new Coords(Const.COORDS_BY_USER, Mat.crossProduct(m1, m2), board);
        },

        /**
         * Calculates the Euclidean distance for two given arrays of the same length.
         * @param {Array} array1 Array of Number
         * @param {Array} array2 Array of Number
         * @param {Number} [n] Length of the arrays. Default is the minimum length of the given arrays.
         * @returns {Number} Euclidean distance of the given vectors.
         */
        distance: function (array1, array2, n) {
            var i,
                sum = 0;

            if (!n) {
                n = Math.min(array1.length, array2.length);
            }

            for (i = 0; i < n; i++) {
                sum += (array1[i] - array2[i]) * (array1[i] - array2[i]);
            }

            return Math.sqrt(sum);
        },

        /**
         * Calculates Euclidean distance for two given arrays of the same length.
         * If one of the arrays contains a zero in the first coordinate, and the Euclidean distance
         * is different from zero it is a point at infinity and we return Infinity.
         * @param {Array} array1 Array containing elements of type number.
         * @param {Array} array2 Array containing elements of type number.
         * @param {Number} [n] Length of the arrays. Default is the minimum length of the given arrays.
         * @returns {Number} Euclidean (affine) distance of the given vectors.
         */
        affineDistance: function (array1, array2, n) {
            var d;

            d = this.distance(array1, array2, n);

            if (d > Mat.eps && (Math.abs(array1[0]) < Mat.eps || Math.abs(array2[0]) < Mat.eps)) {
                return Infinity;
            }

            return d;
        },

        /**
         * Affine ratio of three collinear points a, b, c: (c - a) / (b - a).
         * If r > 1 or r < 0 then c is outside of the segment ab.
         *
         * @param {Array|JXG.Coords} a
         * @param {Array|JXG.Coords} b
         * @param {Array|JXG.Coords} c
         * @returns {Number} affine ratio (c - a) / (b - a)
         */
        affineRatio: function(a, b, c) {
            var r = 0.0, dx;

            if (Type.exists(a.usrCoords)) {
                a = a.usrCoords;
            }
            if (Type.exists(b.usrCoords)) {
                b = b.usrCoords;
            }
            if (Type.exists(c.usrCoords)) {
                c = c.usrCoords;
            }

            dx =  b[1] - a[1];

            if (Math.abs(dx) > Mat.eps) {
                r = (c[1] - a[1]) / dx;
            } else {
                r = (c[2] - a[2]) / (b[2] - a[2]);
            }
            return r;
        },

        /**
         * Sort vertices counter clockwise starting with the first point.
         *
         * @param {Array} p An array containing {@link JXG.Point}, {@link JXG.Coords}, and/or arrays.
         *
         * @returns {Array}
         */
        sortVertices: function (p) {
            var ll,
                ps = Expect.each(p, Expect.coordsArray),
                N = ps.length,
                lastPoint = null;

            // If the last point equals the first point, we take the last point out of the array.
            // It may be that the several points at the end of the array are equal to the first point.
            // The polygonal chain is been closed by JSXGraph, but this may also have been done by the user.
            // Therefore, we use a while lopp to pop the last points.
            while (ps[0][0] === ps[N - 1][0] && ps[0][1] === ps[N - 1][1] && ps[0][2] === ps[N - 1][2]) {
                lastPoint = ps.pop();
                N--;
            }
            // Find the point with the lowest y value
            // for (i = 1; i < N; i++) {
            //     if ((ps[i][2] < ps[0][2]) ||
            //         // if the current and the lowest point have the same y value, pick the one with
            //         // the lowest x value.
            //         (Math.abs(ps[i][2] - ps[0][2]) < Mat.eps && ps[i][1] < ps[0][1])) {
            //         console.log(i, 0);
            //         ps = Type.swap(ps, i, 0);
            //     }
            // }

            ll = ps[0];
            // Sort ps in increasing order of the angle between a point and the first point ll.
            // If a point is equal to the first point ll, the angle is defined to be -Infinity.
            // Otherwise, atan2 would return zero, which is a value which also attained by points
            // on the same horizontal line.
            ps.sort(function (a, b) {
                var rad1 = (a[2] === ll[2] && a[1] === ll[1]) ? -Infinity : Math.atan2(a[2] - ll[2], a[1] - ll[1]),
                    rad2 = (b[2] === ll[2] && b[1] === ll[1]) ? -Infinity : Math.atan2(b[2] - ll[2], b[1] - ll[1]);

                return rad1 - rad2;
            });

            // If the last point has been taken out of the array, we put it in again.
            if (lastPoint !== null) {
                ps.push(lastPoint);
            }

            return ps;
        },

        /**
         * Signed triangle area of the three points given.
         *
         * @param {JXG.Point|JXG.Coords|Array} p1
         * @param {JXG.Point|JXG.Coords|Array} p2
         * @param {JXG.Point|JXG.Coords|Array} p3
         *
         * @returns {Number}
         */
        signedTriangle: function (p1, p2, p3) {
            var A = Expect.coordsArray(p1),
                B = Expect.coordsArray(p2),
                C = Expect.coordsArray(p3);

            return 0.5 * ((B[1] - A[1]) * (C[2] - A[2]) - (B[2] - A[2]) * (C[1] - A[1]));
        },

        /**
         * Determine the signed area of a non-selfintersecting polygon.
         * Surveyor's Formula
         *
         * @param {Array} p An array containing {@link JXG.Point}, {@link JXG.Coords}, and/or arrays.
         * @param {Boolean} [sort=true]
         *
         * @returns {Number}
         */
        signedPolygon: function (p, sort) {
            var i, N,
                A = 0,
                ps = Expect.each(p, Expect.coordsArray);

            if (sort === undefined) {
                sort = true;
            }

            if (!sort) {
                ps = this.sortVertices(ps);
            } else {
                // Make sure the polygon is closed. If it is already closed this won't change the sum because the last
                // summand will be 0.
                ps.unshift(ps[ps.length - 1]);
            }

            N = ps.length;

            for (i = 1; i < N; i++) {
                A += ps[i - 1][1] * ps[i][2] - ps[i][1] * ps[i - 1][2];
            }

            return 0.5 * A;
        },

        /**
         * Calculate the complex hull of a point cloud.
         *
         * @param {Array} points An array containing {@link JXG.Point}, {@link JXG.Coords}, and/or arrays.
         *
         * @returns {Array}
         */
        GrahamScan: function (points) {
            var i,
                M = 1,
                ps = Expect.each(points, Expect.coordsArray),
                N = ps.length;

            ps = this.sortVertices(ps);
            N = ps.length;

            for (i = 2; i < N; i++) {
                while (this.signedTriangle(ps[M - 1], ps[M], ps[i]) <= 0) {
                    if (M > 1) {
                        M -= 1;
                    } else if (i === N - 1) {
                        break;
                    }
                    i += 1;
                }

                M += 1;
                ps = Type.swap(ps, M, i);
            }

            return ps.slice(0, M);
        },

        /**
         * A line can be a segment, a straight, or a ray. So it is not always delimited by point1 and point2
         * calcStraight determines the visual start point and end point of the line. A segment is only drawn
         * from start to end point, a straight line is drawn until it meets the boards boundaries.
         * @param {JXG.Line} el Reference to a line object, that needs calculation of start and end point.
         * @param {JXG.Coords} point1 Coordinates of the point where line drawing begins. This value is calculated and
         * set by this method.
         * @param {JXG.Coords} point2 Coordinates of the point where line drawing ends. This value is calculated and set
         * by this method.
         * @param {Number} margin Optional margin, to avoid the display of the small sides of lines.
         * @returns null
         * @see Line
         * @see JXG.Line
         */
        calcStraight: function (el, point1, point2, margin) {
            var takePoint1, takePoint2, intersection, intersect1, intersect2, straightFirst, straightLast,
                c, p1, p2;

            if (!Type.exists(margin)) {
                // Enlarge the drawable region slightly. This hides the small sides
                // of thick lines in most cases.
                margin = 10;
            }

            straightFirst = Type.evaluate(el.visProp.straightfirst);
            straightLast = Type.evaluate(el.visProp.straightlast);

            // If one of the point is an ideal point in homogeneous coordinates
            // drawing of line segments or rays are not possible.
            if (Math.abs(point1.scrCoords[0]) < Mat.eps) {
                straightFirst = true;
            }
            if (Math.abs(point2.scrCoords[0]) < Mat.eps) {
                straightLast = true;
            }

            // Do nothing in case of line segments (inside or outside of the board)
            if (!straightFirst && !straightLast) {
                return;
            }

            // Compute the stdform of the line in screen coordinates.
            c = [];
            c[0] = el.stdform[0] -
                el.stdform[1] * el.board.origin.scrCoords[1] / el.board.unitX +
                el.stdform[2] * el.board.origin.scrCoords[2] / el.board.unitY;
            c[1] =  el.stdform[1] / el.board.unitX;
            c[2] = -el.stdform[2] / el.board.unitY;

            // p1=p2
            if (isNaN(c[0] + c[1] + c[2])) {
                return;
            }

            takePoint1 = false;
            takePoint2 = false;

            // Line starts at point1 and point1 is inside the board
            takePoint1 = !straightFirst &&
                Math.abs(point1.usrCoords[0]) >= Mat.eps &&
                point1.scrCoords[1] >= 0.0 && point1.scrCoords[1] <= el.board.canvasWidth &&
                point1.scrCoords[2] >= 0.0 && point1.scrCoords[2] <= el.board.canvasHeight;

            // Line ends at point2 and point2 is inside the board
            takePoint2 = !straightLast &&
                Math.abs(point2.usrCoords[0]) >= Mat.eps &&
                point2.scrCoords[1] >= 0.0 && point2.scrCoords[1] <= el.board.canvasWidth &&
                point2.scrCoords[2] >= 0.0 && point2.scrCoords[2] <= el.board.canvasHeight;

            // Intersect the line with the four borders of the board.
            intersection = this.meetLineBoard(c, el.board, margin);
            intersect1 = intersection[0];
            intersect2 = intersection[1];

            /**
             * At this point we have four points:
             * point1 and point2 are the first and the second defining point on the line,
             * intersect1, intersect2 are the intersections of the line with border around the board.
             */

            /*
             * Here we handle rays where both defining points are outside of the board.
             */
            // If both points are outside and the complete ray is outside we do nothing
            if (!takePoint1 && !takePoint2) {
                // Ray starting at point 1
                if (!straightFirst && straightLast &&
                        !this.isSameDirection(point1, point2, intersect1) && !this.isSameDirection(point1, point2, intersect2)) {
                    return;
                }

                // Ray starting at point 2
                if (straightFirst && !straightLast &&
                        !this.isSameDirection(point2, point1, intersect1) && !this.isSameDirection(point2, point1, intersect2)) {
                    return;
                }
            }

            /*
             * If at least one of the defining points is outside of the board
             * we take intersect1 or intersect2 as one of the end points
             * The order is also important for arrows of axes
             */
            if (!takePoint1) {
                if (!takePoint2) {
                    // Two border intersection points are used
                    if (this.isSameDir(point1, point2, intersect1, intersect2)) {
                        p1 = intersect1;
                        p2 = intersect2;
                    } else {
                        p2 = intersect1;
                        p1 = intersect2;
                    }
                } else {
                    // One border intersection points is used
                    if (this.isSameDir(point1, point2, intersect1, intersect2)) {
                        p1 = intersect1;
                    } else {
                        p1 = intersect2;
                    }
                }
            } else {
                if (!takePoint2) {
                    // One border intersection points is used
                    if (this.isSameDir(point1, point2, intersect1, intersect2)) {
                        p2 = intersect2;
                    } else {
                        p2 = intersect1;
                    }
                }
            }

            if (p1) {
                //point1.setCoordinates(Const.COORDS_BY_USER, p1.usrCoords.slice(1));
                point1.setCoordinates(Const.COORDS_BY_USER, p1.usrCoords);
            }

            if (p2) {
                //point2.setCoordinates(Const.COORDS_BY_USER, p2.usrCoords.slice(1));
                point2.setCoordinates(Const.COORDS_BY_USER, p2.usrCoords);
            }
        },

        /**
         * A line can be a segment, a straight, or a ray. so it is not always delimited by point1 and point2.
         *
         * This method adjusts the line's delimiting points taking into account its nature, the viewport defined
         * by the board.
         *
         * A segment is delimited by start and end point, a straight line or ray is delimited until it meets the
         * boards boundaries. However, if the line has infinite ticks, it will be delimited by the projection of
         * the boards vertices onto itself.
         *
         * @param {JXG.Line} el Reference to a line object, that needs calculation of start and end point.
         * @param {JXG.Coords} point1 Coordinates of the point where line drawing begins. This value is calculated and
         * set by this method.
         * @param {JXG.Coords} point2 Coordinates of the point where line drawing ends. This value is calculated and set
         * by this method.
         * @see Line
         * @see JXG.Line
         */
        calcLineDelimitingPoints: function (el, point1, point2) {
            var distP1P2, boundingBox, lineSlope,
                intersect1, intersect2, straightFirst, straightLast,
                c, p1, p2,
                takePoint1 = false,
                takePoint2 = false;

            straightFirst = Type.evaluate(el.visProp.straightfirst);
            straightLast = Type.evaluate(el.visProp.straightlast);

            // If one of the point is an ideal point in homogeneous coordinates
            // drawing of line segments or rays are not possible.
            if (Math.abs(point1.scrCoords[0]) < Mat.eps) {
                straightFirst = true;
            }
            if (Math.abs(point2.scrCoords[0]) < Mat.eps) {
                straightLast = true;
            }

            // Compute the stdform of the line in screen coordinates.
            c = [];
            c[0] = el.stdform[0] -
                el.stdform[1] * el.board.origin.scrCoords[1] / el.board.unitX +
                el.stdform[2] * el.board.origin.scrCoords[2] / el.board.unitY;
            c[1] =  el.stdform[1] / el.board.unitX;
            c[2] = -el.stdform[2] / el.board.unitY;

            // p1=p2
            if (isNaN(c[0] + c[1] + c[2])) {
                return;
            }

            takePoint1 = !straightFirst;
            takePoint2 = !straightLast;
            // Intersect the board vertices on the line to establish the available visual space for the infinite ticks
            // Based on the slope of the line we can optimise and only project the two outer vertices

            // boundingBox = [x1, y1, x2, y2] upper left, lower right vertices
            boundingBox = el.board.getBoundingBox();
            lineSlope = el.getSlope();
            if (lineSlope >= 0) {
                // project vertices (x2,y1) (x1, y2)
                intersect1 = this.projectPointToLine({ coords: { usrCoords: [1, boundingBox[2], boundingBox[1]] } }, el, el.board);
                intersect2 = this.projectPointToLine({ coords: { usrCoords: [1, boundingBox[0], boundingBox[3]] } }, el, el.board);
            } else {
                // project vertices (x1, y1) (x2, y2)
                intersect1 = this.projectPointToLine({ coords: { usrCoords: [1, boundingBox[0], boundingBox[1]] } }, el, el.board);
                intersect2 = this.projectPointToLine({ coords: { usrCoords: [1, boundingBox[2], boundingBox[3]] } }, el, el.board);
            }

            /**
             * we have four points:
             * point1 and point2 are the first and the second defining point on the line,
             * intersect1, intersect2 are the intersections of the line with border around the board.
             */

            /*
             * Here we handle rays/segments where both defining points are outside of the board.
             */
            if (!takePoint1 && !takePoint2) {
                // Segment, if segment does not cross the board, do nothing
                if (!straightFirst && !straightLast) {
                    distP1P2 = point1.distance(Const.COORDS_BY_USER, point2);
                    // if  intersect1 not between point1 and point2
                    if (Math.abs(point1.distance(Const.COORDS_BY_USER, intersect1) +
                            intersect1.distance(Const.COORDS_BY_USER, point2) - distP1P2) > Mat.eps) {
                        return;
                    }
                    // if insersect2 not between point1 and point2
                    if (Math.abs(point1.distance(Const.COORDS_BY_USER, intersect2) +
                            intersect2.distance(Const.COORDS_BY_USER, point2) - distP1P2) > Mat.eps) {
                        return;
                    }
                }

                // If both points are outside and the complete ray is outside we do nothing
                // Ray starting at point 1
                if (!straightFirst && straightLast &&
                        !this.isSameDirection(point1, point2, intersect1) && !this.isSameDirection(point1, point2, intersect2)) {
                    return;
                }

                // Ray starting at point 2
                if (straightFirst && !straightLast &&
                        !this.isSameDirection(point2, point1, intersect1) && !this.isSameDirection(point2, point1, intersect2)) {
                    return;
                }
            }

            /*
             * If at least one of the defining points is outside of the board
             * we take intersect1 or intersect2 as one of the end points
             * The order is also important for arrows of axes
             */
            if (!takePoint1) {
                if (!takePoint2) {
                    // Two border intersection points are used
                    if (this.isSameDir(point1, point2, intersect1, intersect2)) {
                        p1 = intersect1;
                        p2 = intersect2;
                    } else {
                        p2 = intersect1;
                        p1 = intersect2;
                    }
                } else {
                    // One border intersection points is used
                    if (this.isSameDir(point1, point2, intersect1, intersect2)) {
                        p1 = intersect1;
                    } else {
                        p1 = intersect2;
                    }
                }
            } else {
                if (!takePoint2) {
                    // One border intersection points is used
                    if (this.isSameDir(point1, point2, intersect1, intersect2)) {
                        p2 = intersect2;
                    } else {
                        p2 = intersect1;
                    }
                }
            }

            if (p1) {
                //point1.setCoordinates(Const.COORDS_BY_USER, p1.usrCoords.slice(1));
                point1.setCoordinates(Const.COORDS_BY_USER, p1.usrCoords);
            }

            if (p2) {
                //point2.setCoordinates(Const.COORDS_BY_USER, p2.usrCoords.slice(1));
                point2.setCoordinates(Const.COORDS_BY_USER, p2.usrCoords);
            }
        },

        /**
         * Calculates the visProp.position corresponding to a given angle.
         * @param {number} angle angle in radians. Must be in range (-2pi,2pi).
         */
        calcLabelQuadrant: function(angle) {
            var q;
            if (angle < 0) {
                angle += 2*Math.PI;
            }
            q = Math.floor((angle+Math.PI/8)/(Math.PI/4))%8;
            return ['rt','urt','top','ulft','lft','llft','lrt'][q];
        },

        /**
         * The vectors <tt>p2-p1</tt> and <tt>i2-i1</tt> are supposed to be collinear. If their cosine is positive
         * they point into the same direction otherwise they point in opposite direction.
         * @param {JXG.Coords} p1
         * @param {JXG.Coords} p2
         * @param {JXG.Coords} i1
         * @param {JXG.Coords} i2
         * @returns {Boolean} True, if <tt>p2-p1</tt> and <tt>i2-i1</tt> point into the same direction
         */
        isSameDir: function (p1, p2, i1, i2) {
            var dpx = p2.usrCoords[1] - p1.usrCoords[1],
                dpy = p2.usrCoords[2] - p1.usrCoords[2],
                dix = i2.usrCoords[1] - i1.usrCoords[1],
                diy = i2.usrCoords[2] - i1.usrCoords[2];

            if (Math.abs(p2.usrCoords[0]) < Mat.eps) {
                dpx = p2.usrCoords[1];
                dpy = p2.usrCoords[2];
            }

            if (Math.abs(p1.usrCoords[0]) < Mat.eps) {
                dpx = -p1.usrCoords[1];
                dpy = -p1.usrCoords[2];
            }

            return dpx * dix + dpy * diy >= 0;
        },

        /**
         * If you're looking from point "start" towards point "s" and you can see the point "p", return true.
         * Otherwise return false.
         * @param {JXG.Coords} start The point you're standing on.
         * @param {JXG.Coords} p The point in which direction you're looking.
         * @param {JXG.Coords} s The point that should be visible.
         * @returns {Boolean} True, if from start the point p is in the same direction as s is, that means s-start = k*(p-start) with k>=0.
         */
        isSameDirection: function (start, p, s) {
            var dx, dy, sx, sy, r = false;

            dx = p.usrCoords[1] - start.usrCoords[1];
            dy = p.usrCoords[2] - start.usrCoords[2];

            sx = s.usrCoords[1] - start.usrCoords[1];
            sy = s.usrCoords[2] - start.usrCoords[2];

            if (Math.abs(dx) < Mat.eps) {
                dx = 0;
            }

            if (Math.abs(dy) < Mat.eps) {
                dy = 0;
            }

            if (Math.abs(sx) < Mat.eps) {
                sx = 0;
            }

            if (Math.abs(sy) < Mat.eps) {
                sy = 0;
            }

            if (dx >= 0 && sx >= 0) {
                r = (dy >= 0 && sy >= 0) || (dy <= 0 && sy <= 0);
            } else if (dx <= 0 && sx <= 0) {
                r = (dy >= 0 && sy >= 0) || (dy <= 0 && sy <= 0);
            }

            return r;
        },

        /****************************************/
        /****          INTERSECTIONS         ****/
        /****************************************/

        /**
         * Generate the function which computes the coordinates of the intersection point.
         * Primarily used in {@link JXG.Point#createIntersectionPoint}.
         * @param {JXG.Board} board object
         * @param {JXG.Line,JXG.Circle_JXG.Line,JXG.Circle_Number} el1,el2,i The result will be a intersection point on el1 and el2.
         * i determines the intersection point if two points are available: <ul>
         *   <li>i==0: use the positive square root,</li>
         *   <li>i==1: use the negative square root.</li></ul>
         * See further {@link JXG.Point#createIntersectionPoint}.
         * @param {Boolean} alwaysintersect. Flag that determines if segments and arc can have an outer intersection point
         * on their defining line or circle.
         * @returns {Function} Function returning a {@link JXG.Coords} object that determines
         * the intersection point.
         */
        intersectionFunction: function (board, el1, el2, i, j, alwaysintersect) {
            var func, that = this,
                el1_isArcType = false,
                el2_isArcType = false;

            el1_isArcType = (el1.elementClass === Const.OBJECT_CLASS_CURVE &&
                (el1.type === Const.OBJECT_TYPE_ARC || el1.type === Const.OBJECT_TYPE_SECTOR)
                ) ? true : false;
            el2_isArcType = (el2.elementClass === Const.OBJECT_CLASS_CURVE &&
                (el2.type === Const.OBJECT_TYPE_ARC || el2.type === Const.OBJECT_TYPE_SECTOR)
                ) ? true : false;

            if ((el1.elementClass === Const.OBJECT_CLASS_CURVE || el2.elementClass === Const.OBJECT_CLASS_CURVE) &&
                (el1.elementClass === Const.OBJECT_CLASS_CURVE || el1.elementClass === Const.OBJECT_CLASS_CIRCLE) &&
                (el2.elementClass === Const.OBJECT_CLASS_CURVE || el2.elementClass === Const.OBJECT_CLASS_CIRCLE) /*&&
                !(el1_isArcType && el2_isArcType)*/ ) {
                // curve - curve
                // with the exception that both elements are arc types
                /** @ignore */
                func = function () {
                    return that.meetCurveCurve(el1, el2, i, j, el1.board);
                };

            } else if ((
                        el1.elementClass === Const.OBJECT_CLASS_CURVE &&
                        !el1_isArcType &&
                        el2.elementClass === Const.OBJECT_CLASS_LINE
                       ) ||
                       (
                        el2.elementClass === Const.OBJECT_CLASS_CURVE &&
                        !el2_isArcType &&
                        el1.elementClass === Const.OBJECT_CLASS_LINE
                       )
                    ) {
                // curve - line (this includes intersections between conic sections and lines)
                // with the exception that the curve is of arc type
                /** @ignore */
                func = function () {
                    return that.meetCurveLine(el1, el2, i, el1.board, alwaysintersect);
                };

            } else if (el1.elementClass === Const.OBJECT_CLASS_LINE && el2.elementClass === Const.OBJECT_CLASS_LINE) {
                // line - line, lines may also be segments.
                /** @ignore */
                func = function () {
                    var res, c,
                        first1 = Type.evaluate(el1.visProp.straightfirst),
                        last1 = Type.evaluate(el1.visProp.straightlast),
                        first2 = Type.evaluate(el2.visProp.straightfirst),
                        last2 = Type.evaluate(el2.visProp.straightlast);

                    /**
                     * If one of the lines is a segment or ray and
                     * the intersection point should disappear if outside
                     * of the segment or ray we call
                     * meetSegmentSegment
                     */
                    if (!Type.evaluate(alwaysintersect) && (!first1 || !last1 || !first2 || !last2)) {
                        res = that.meetSegmentSegment(
                            el1.point1.coords.usrCoords,
                            el1.point2.coords.usrCoords,
                            el2.point1.coords.usrCoords,
                            el2.point2.coords.usrCoords
                        );

                        if ((!first1 && res[1] < 0) || (!last1 && res[1] > 1) ||
                                (!first2 && res[2] < 0) || (!last2 && res[2] > 1)) {
                            // Non-existent
                            c = [0, NaN, NaN];
                        } else {
                            c = res[0];
                        }

                        return (new Coords(Const.COORDS_BY_USER, c, el1.board));
                    }

                    return that.meet(el1.stdform, el2.stdform, i, el1.board);
                };
            } else {
                // All other combinations of circles and lines,
                // Arc types are treated as circles.
                /** @ignore */
                func = function () {
                    var res = that.meet(el1.stdform, el2.stdform, i, el1.board),
                        has = true,
                        first, last, r, dx;

                    if (alwaysintersect) {
                        return res;
                    }
                    if (el1.elementClass === Const.OBJECT_CLASS_LINE) {
                        first = Type.evaluate(el1.visProp.straightfirst);
                        last  = Type.evaluate(el1.visProp.straightlast);
                        if (!first || !last) {
                            r = that.affineRatio(el1.point1.coords, el1.point2.coords, res);
                            if ( (!last && r > 1 + Mat.eps) || (!first && r < 0 - Mat.eps) ) {
                                return (new Coords(JXG.COORDS_BY_USER, [0, NaN, NaN], el1.board));
                            }
                        }
                    }
                    if (el2.elementClass === Const.OBJECT_CLASS_LINE) {
                        first = Type.evaluate(el2.visProp.straightfirst);
                        last  = Type.evaluate(el2.visProp.straightlast);
                        if (!first || !last) {
                            r = that.affineRatio(el2.point1.coords, el2.point2.coords, res);
                            if ( (!last && r > 1 + Mat.eps) || (!first && r < 0 - Mat.eps) ) {
                                return (new Coords(JXG.COORDS_BY_USER, [0, NaN, NaN], el1.board));
                            }
                        }
                    }
                    if (el1_isArcType) {
                        has = that.coordsOnArc(el1, res);
                        if (has && el2_isArcType) {
                            has = that.coordsOnArc(el2, res);
                        }
                        if (!has) {
                            return (new Coords(JXG.COORDS_BY_USER, [0, NaN, NaN], el1.board));
                        }
                    }
                    return res;
                };
            }

            return func;
        },

        /**
         * Returns true if the coordinates are on the arc element,
         * false otherwise. Usually, coords is an intersection
         * on the circle line. Now it is decided if coords are on the
         * circle restricted to the arc line.
         * @param  {Arc} arc arc or sector element
         * @param  {JXG.Coords} coords Coords object of an intersection
         * @returns {Boolean}
         * @private
         */
        coordsOnArc: function(arc, coords) {
            var angle = this.rad(arc.radiuspoint, arc.center, coords.usrCoords.slice(1)),
                alpha = 0.0,
                beta = this.rad(arc.radiuspoint, arc.center, arc.anglepoint),
                ev_s = Type.evaluate(arc.visProp.selection);

            if ((ev_s === 'minor' && beta > Math.PI) ||
                (ev_s === 'major' && beta < Math.PI)) {
                alpha = beta;
                beta = 2 * Math.PI;
            }
            if (angle < alpha || angle > beta) {
                return false;
            }
            return true;
        },

        /**
         * Computes the intersection of a pair of lines, circles or both.
         * It uses the internal data array stdform of these elements.
         * @param {Array} el1 stdform of the first element (line or circle)
         * @param {Array} el2 stdform of the second element (line or circle)
         * @param {Number} i Index of the intersection point that should be returned.
         * @param board Reference to the board.
         * @returns {JXG.Coords} Coordinates of one of the possible two or more intersection points.
         * Which point will be returned is determined by i.
         */
        meet: function (el1, el2, i, board) {
            var result,
                eps = Mat.eps;

            // line line
            if (Math.abs(el1[3]) < eps && Math.abs(el2[3]) < eps) {
                result = this.meetLineLine(el1, el2, i, board);
            // circle line
            } else if (Math.abs(el1[3]) >= eps && Math.abs(el2[3]) < eps) {
                result = this.meetLineCircle(el2, el1, i, board);
            // line circle
            } else if (Math.abs(el1[3]) < eps && Math.abs(el2[3]) >= eps) {
                result = this.meetLineCircle(el1, el2, i, board);
            // circle circle
            } else {
                result = this.meetCircleCircle(el1, el2, i, board);
            }

            return result;
        },

        /**
         * Intersection of the line with the board
         * @param  {Array}     line   stdform of the line in screen coordinates
         * @param  {JXG.Board} board  reference to a board.
         * @param  {Number}    margin optional margin, to avoid the display of the small sides of lines.
         * @returns {Array}            [intersection coords 1, intersection coords 2]
         */
        meetLineBoard: function (line, board, margin) {
             // Intersect the line with the four borders of the board.
            var s = [], intersect1, intersect2, i, j;

            if (!Type.exists(margin)) {
                margin = 0;
            }

            // top
            s[0] = Mat.crossProduct(line, [margin, 0, 1]);
            // left
            s[1] = Mat.crossProduct(line, [margin, 1, 0]);
            // bottom
            s[2] = Mat.crossProduct(line, [-margin - board.canvasHeight, 0, 1]);
            // right
            s[3] = Mat.crossProduct(line, [-margin - board.canvasWidth, 1, 0]);

            // Normalize the intersections
            for (i = 0; i < 4; i++) {
                if (Math.abs(s[i][0]) > Mat.eps) {
                    for (j = 2; j > 0; j--) {
                        s[i][j] /= s[i][0];
                    }
                    s[i][0] = 1.0;
                }
            }

            // line is parallel to "left", take "top" and "bottom"
            if (Math.abs(s[1][0]) < Mat.eps) {
                intersect1 = s[0];                          // top
                intersect2 = s[2];                          // bottom
            // line is parallel to "top", take "left" and "right"
            } else if (Math.abs(s[0][0]) < Mat.eps) {
                intersect1 = s[1];                          // left
                intersect2 = s[3];                          // right
            // left intersection out of board (above)
            } else if (s[1][2] < 0) {
                intersect1 = s[0];                          // top

                // right intersection out of board (below)
                if (s[3][2] > board.canvasHeight) {
                    intersect2 = s[2];                      // bottom
                } else {
                    intersect2 = s[3];                      // right
                }
            // left intersection out of board (below)
            } else if (s[1][2] > board.canvasHeight) {
                intersect1 = s[2];                          // bottom

                // right intersection out of board (above)
                if (s[3][2] < 0) {
                    intersect2 = s[0];                      // top
                } else {
                    intersect2 = s[3];                      // right
                }
            } else {
                intersect1 = s[1];                          // left

                // right intersection out of board (above)
                if (s[3][2] < 0) {
                    intersect2 = s[0];                      // top
                // right intersection out of board (below)
                } else if (s[3][2] > board.canvasHeight) {
                    intersect2 = s[2];                      // bottom
                } else {
                    intersect2 = s[3];                      // right
                }
            }

            intersect1 = new Coords(Const.COORDS_BY_SCREEN, intersect1.slice(1), board);
            intersect2 = new Coords(Const.COORDS_BY_SCREEN, intersect2.slice(1), board);
            return [intersect1, intersect2];
        },

        /**
         * Intersection of two lines.
         * @param {Array} l1 stdform of the first line
         * @param {Array} l2 stdform of the second line
         * @param {number} i unused
         * @param {JXG.Board} board Reference to the board.
         * @returns {JXG.Coords} Coordinates of the intersection point.
         */
        meetLineLine: function (l1, l2, i, board) {
            /*
            var s = Mat.crossProduct(l1, l2);

            if (Math.abs(s[0]) > Mat.eps) {
                s[1] /= s[0];
                s[2] /= s[0];
                s[0] = 1.0;
            }
            */
            var s = isNaN(l1[5] + l2[5]) ? [0, 0, 0] : Mat.crossProduct(l1, l2);
            return new Coords(Const.COORDS_BY_USER, s, board);
        },

        /**
         * Intersection of line and circle.
         * @param {Array} lin stdform of the line
         * @param {Array} circ stdform of the circle
         * @param {number} i number of the returned intersection point.
         *   i==0: use the positive square root,
         *   i==1: use the negative square root.
         * @param {JXG.Board} board Reference to a board.
         * @returns {JXG.Coords} Coordinates of the intersection point
         */
        meetLineCircle: function (lin, circ, i, board) {
            var a, b, c, d, n,
                A, B, C, k, t;

            // Radius is zero, return center of circle
            if (circ[4] < Mat.eps) {
                if (Math.abs(Mat.innerProduct([1, circ[6], circ[7]], lin, 3)) < Mat.eps) {
                    return new Coords(Const.COORDS_BY_USER, circ.slice(6, 8), board);
                }

                return new Coords(Const.COORDS_BY_USER, [NaN, NaN], board);
            }
            c = circ[0];
            b = circ.slice(1, 3);
            a = circ[3];
            d = lin[0];
            n = lin.slice(1, 3);

            // Line is assumed to be normalized. Therefore, nn==1 and we can skip some operations:
            /*
             var nn = n[0]*n[0]+n[1]*n[1];
             A = a*nn;
             B = (b[0]*n[1]-b[1]*n[0])*nn;
             C = a*d*d - (b[0]*n[0]+b[1]*n[1])*d + c*nn;
             */
            A = a;
            B = (b[0] * n[1] - b[1] * n[0]);
            C = a * d * d - (b[0] * n[0] + b[1] * n[1]) * d + c;

            k = B * B - 4 * A * C;
            if (k > -Mat.eps * Mat.eps) {
                k = Math.sqrt(Math.abs(k));
                t = [(-B + k) / (2 * A), (-B - k) / (2 * A)];

                return ((i === 0) ?
                        new Coords(Const.COORDS_BY_USER, [-t[0] * (-n[1]) - d * n[0], -t[0] * n[0] - d * n[1]], board) :
                        new Coords(Const.COORDS_BY_USER, [-t[1] * (-n[1]) - d * n[0], -t[1] * n[0] - d * n[1]], board)
                    );
            }

            return new Coords(Const.COORDS_BY_USER, [0, 0, 0], board);
        },

        /**
         * Intersection of two circles.
         * @param {Array} circ1 stdform of the first circle
         * @param {Array} circ2 stdform of the second circle
         * @param {number} i number of the returned intersection point.
         *   i==0: use the positive square root,
         *   i==1: use the negative square root.
         * @param {JXG.Board} board Reference to the board.
         * @returns {JXG.Coords} Coordinates of the intersection point
         */
        meetCircleCircle: function (circ1, circ2, i, board) {
            var radicalAxis;

            // Radius is zero, return center of circle, if on other circle
            if (circ1[4] < Mat.eps) {
                if (Math.abs(this.distance(circ1.slice(6, 2), circ2.slice(6, 8)) - circ2[4]) < Mat.eps) {
                    return new Coords(Const.COORDS_BY_USER, circ1.slice(6, 8), board);
                }

                return new Coords(Const.COORDS_BY_USER, [0, 0, 0], board);
            }

            // Radius is zero, return center of circle, if on other circle
            if (circ2[4] < Mat.eps) {
                if (Math.abs(this.distance(circ2.slice(6, 2), circ1.slice(6, 8)) - circ1[4]) < Mat.eps) {
                    return new Coords(Const.COORDS_BY_USER, circ2.slice(6, 8), board);
                }

                return new Coords(Const.COORDS_BY_USER, [0, 0, 0], board);
            }

            radicalAxis = [circ2[3] * circ1[0] - circ1[3] * circ2[0],
                circ2[3] * circ1[1] - circ1[3] * circ2[1],
                circ2[3] * circ1[2] - circ1[3] * circ2[2],
                0, 1, Infinity, Infinity, Infinity];
            radicalAxis = Mat.normalize(radicalAxis);

            return this.meetLineCircle(radicalAxis, circ1, i, board);
        },

        /**
         * Compute an intersection of the curves c1 and c2.
         * We want to find values t1, t2 such that
         * c1(t1) = c2(t2), i.e. (c1_x(t1)-c2_x(t2),c1_y(t1)-c2_y(t2)) = (0,0).
         *
         * Methods: segment-wise intersections (default) or generalized Newton method.
         * @param {JXG.Curve} c1 Curve, Line or Circle
         * @param {JXG.Curve} c2 Curve, Line or Circle
         * @param {Number} nr the nr-th intersection point will be returned.
         * @param {Number} t2ini not longer used.
         * @param {JXG.Board} [board=c1.board] Reference to a board object.
         * @param {String} [method='segment'] Intersection method, possible values are 'newton' and 'segment'.
         * @returns {JXG.Coords} intersection point
         */
        meetCurveCurve: function (c1, c2, nr, t2ini, board, method) {
            var co;

            if (Type.exists(method) && method === 'newton') {
                co = Numerics.generalizedNewton(c1, c2, nr, t2ini);
            } else {
                if (c1.bezierDegree === 3 || c2.bezierDegree === 3) {
                    co = this.meetBezierCurveRedBlueSegments(c1, c2, nr);
                } else {
                    co = this.meetCurveRedBlueSegments(c1, c2, nr);
                }
            }

            return (new Coords(Const.COORDS_BY_USER, co, board));
        },

        /**
         * Intersection of curve with line,
         * Order of input does not matter for el1 and el2.
         * From version 0.99.7 on this method calls
         * {@link JXG.Math.Geometry.meetCurveLineDiscrete}.
         * If higher precision is needed, {@link JXG.Math.Geometry.meetCurveLineContinuous}
         * has to be used.
         *
         * @param {JXG.Curve,JXG.Line} el1 Curve or Line
         * @param {JXG.Curve,JXG.Line} el2 Curve or Line
         * @param {Number} nr the nr-th intersection point will be returned.
         * @param {JXG.Board} [board=el1.board] Reference to a board object.
         * @param {Boolean} alwaysIntersect If false just the segment between the two defining points are tested for intersection
         * @returns {JXG.Coords} Intersection point. In case no intersection point is detected,
         * the ideal point [0,1,0] is returned.
         */
        meetCurveLine: function (el1, el2, nr, board, alwaysIntersect) {
            var v = [0, NaN, NaN], cu, li;

            if (!Type.exists(board)) {
                board = el1.board;
            }

            if (el1.elementClass === Const.OBJECT_CLASS_CURVE) {
                cu = el1;
                li = el2;
            } else {
                cu = el2;
                li = el1;
            }

            v = this.meetCurveLineDiscrete(cu, li, nr, board, !alwaysIntersect);

            return v;
        },

        /**
         * Intersection of line and curve, continuous case.
         * Finds the nr-the intersection point
         * Uses {@link JXG.Math.Geometry.meetCurveLineDiscrete} as a first approximation.
         * A more exact solution is then found with {@link JXG.Math.Numerics.root}.
         *
         * @param {JXG.Curve} cu Curve
         * @param {JXG.Line} li Line
         * @param {Number} nr Will return the nr-th intersection point.
         * @param {JXG.Board} board
         * @returns {JXG.Coords} Coords object containing the intersection.
         */
        meetCurveLineContinuous: function (cu, li, nr, board, testSegment) {
            var t, func0, func1, v, x, y, z,
                eps = Mat.eps,
                epsLow = Mat.eps,
                steps, delta, tnew, i,
                tmin, fmin, ft;

            v = this.meetCurveLineDiscrete(cu, li, nr, board, testSegment);
            x = v.usrCoords[1];
            y = v.usrCoords[2];

            func0 = function (t) {
                var c1, c2;

                if (t > cu.maxX() || t < cu.minX()) {
                    return Infinity;
                }
                c1 = x - cu.X(t);
                c2 = y - cu.Y(t);
                return c1 * c1 + c2 * c2;
            };

            func1 = function (t) {
                var v = li.stdform[0] + li.stdform[1] * cu.X(t) + li.stdform[2] * cu.Y(t);
                return v * v;
            };

            // Find t
            steps = 50;
            delta = (cu.maxX() - cu.minX()) / steps;
            tnew = cu.minX();

            fmin = 0.0001; //eps;
            tmin = NaN;
            for (i = 0; i < steps; i++) {
                t = Numerics.root(func0, [Math.max(tnew, cu.minX()), Math.min(tnew + delta, cu.maxX())]);
                ft = Math.abs(func0(t));
                if (ft <= fmin) {
                    fmin = ft;
                    tmin = t;
                    if (fmin < eps) {
                        break;
                    }
                }

                tnew += delta;
            }
            t = tmin;
            // Compute "exact" t
            t = Numerics.root(func1, [Math.max(t - delta, cu.minX()), Math.min(t + delta, cu.maxX())]);

            ft = func1(t);
            // Is the point on the line?
            if (isNaN(ft) || Math.abs(ft) > epsLow) {
                z = 0.0; //NaN;
            } else {
                z = 1.0;
            }

            return (new Coords(Const.COORDS_BY_USER, [z, cu.X(t), cu.Y(t)], board));
        },


        /**
         * Intersection of line and curve, discrete case.
         * Segments are treated as lines.
         * Finding the nr-th intersection point should work for all nr.
         * @param {JXG.Curve} cu
         * @param {JXG.Line} li
         * @param {Number} nr
         * @param {JXG.Board} board
         * @param {Boolean} testSegment Test if intersection has to be inside of the segment or somewhere on the
         * line defined by the segment
         *
         * @returns {JXG.Coords} Intersection point. In case no intersection point is detected,
         * the ideal point [0,1,0] is returned.
         */
        meetCurveLineDiscrete: function (cu, li, nr, board, testSegment) {
            var i, j,
                p1, p2, p, q,
                lip1 = li.point1.coords.usrCoords,
                lip2 = li.point2.coords.usrCoords,
                d, res,
                cnt = 0,
                len = cu.numberPoints,
                ev_sf = Type.evaluate(li.visProp.straightfirst),
                ev_sl = Type.evaluate(li.visProp.straightlast);

            // In case, no intersection will be found we will take this
            q = new Coords(Const.COORDS_BY_USER, [0, NaN, NaN], board);

            if (lip1[0] === 0.0) {
                lip1 = [1, lip2[1] + li.stdform[2], lip2[2] - li.stdform[1]];
            } else if (lip2[0] === 0.0) {
                lip2 = [1, lip1[1] + li.stdform[2], lip1[2] - li.stdform[1]];
            }

            p2 = cu.points[0].usrCoords;
            for (i = 1; i < len; i += cu.bezierDegree) {
                p1 = p2.slice(0);
                p2 = cu.points[i].usrCoords;
                d = this.distance(p1, p2);

                // The defining points are not identical
                if (d > Mat.eps) {
                    if (cu.bezierDegree === 3) {
                        res = this.meetBeziersegmentBeziersegment([
                            cu.points[i - 1].usrCoords.slice(1),
                            cu.points[i].usrCoords.slice(1),
                            cu.points[i + 1].usrCoords.slice(1),
                            cu.points[i + 2].usrCoords.slice(1)
                        ], [
                            lip1.slice(1),
                            lip2.slice(1)
                        ], testSegment);
                    } else {
                        res = [this.meetSegmentSegment(p1, p2, lip1, lip2)];
                    }

                    for (j = 0; j < res.length; j++) {
                        p = res[j];
                        if (0 <= p[1] && p[1] <= 1) {
                            if (cnt === nr) {
                                /**
                                * If the intersection point is not part of the segment,
                                * this intersection point is set to non-existent.
                                * This prevents jumping behavior of the intersection points.
                                * But it may be discussed if it is the desired behavior.
                                */
                                if (testSegment &&
                                        ((!ev_sf && p[2] < 0) || (!ev_sl && p[2] > 1))) {
                                    return q;  // break;
                                }

                                q = new Coords(Const.COORDS_BY_USER, p[0], board);
                                return q;      // break;
                            }
                            cnt += 1;
                        }
                    }
                }
            }

            return q;
        },

        /**
         * Find the n-th intersection point of two curves named red (first parameter) and blue (second parameter).
         * We go through each segment of the red curve and search if there is an intersection with a segemnt of the blue curve.
         * This double loop, i.e. the outer loop runs along the red curve and the inner loop runs along the blue curve, defines
         * the n-th intersection point. The segments are either line segments or Bezier curves of degree 3. This depends on
         * the property bezierDegree of the curves.
         * <p>
         * This method works also for transformed curves, since only the already
         * transformed points are used.
         *
         * @param {JXG.Curve} red
         * @param {JXG.Curve} blue
         * @param {Number} nr
         */
        meetCurveRedBlueSegments: function (red, blue, nr) {
            var i, j,
                red1, red2, blue1, blue2, m,
                minX, maxX,
                iFound = 0,
                lenBlue = blue.numberPoints, //points.length,
                lenRed = red.numberPoints; //points.length;

            if (lenBlue <= 1 || lenRed <= 1) {
                return [0, NaN, NaN];
            }

            for (i = 1; i < lenRed; i++) {
                red1 = red.points[i - 1].usrCoords;
                red2 = red.points[i].usrCoords;
                minX = Math.min(red1[1], red2[1]);
                maxX = Math.max(red1[1], red2[1]);

                blue2 = blue.points[0].usrCoords;
                for (j = 1; j < lenBlue; j++) {
                    blue1 = blue2;
                    blue2 = blue.points[j].usrCoords;

                    if (Math.min(blue1[1], blue2[1]) < maxX && Math.max(blue1[1], blue2[1]) > minX) {
                        m = this.meetSegmentSegment(red1, red2, blue1, blue2);
                        if (m[1] >= 0.0 && m[2] >= 0.0 &&
                                // The two segments meet in the interior or at the start points
                                ((m[1] < 1.0 && m[2] < 1.0) ||
                                // One of the curve is intersected in the very last point
                                (i === lenRed - 1 && m[1] === 1.0) ||
                                (j === lenBlue - 1 && m[2] === 1.0))) {
                            if (iFound === nr) {
                                return m[0];
                            }

                            iFound++;
                        }
                    }
                }
            }

            return [0, NaN, NaN];
        },

        /**
         * (Virtual) Intersection of two segments.
         * @param {Array} p1 First point of segment 1 using normalized homogeneous coordinates [1,x,y]
         * @param {Array} p2 Second point or direction of segment 1 using normalized homogeneous coordinates [1,x,y] or point at infinity [0,x,y], respectively
         * @param {Array} q1 First point of segment 2 using normalized homogeneous coordinates [1,x,y]
         * @param {Array} q2 Second point or direction of segment 2 using normalized homogeneous coordinates [1,x,y] or point at infinity [0,x,y], respectively
         * @returns {Array} [Intersection point, t, u] The first entry contains the homogeneous coordinates
         * of the intersection point. The second and third entry give the position of the intersection with respect
         * to the definiting parameters. For example, the second entry t is defined by: intersection point = p1 + t * deltaP, where
         * deltaP = (p2 - p1) when both parameters are coordinates, and deltaP = p2 if p2 is a point at infinity.
         * If the two segments are collinear, [[0,0,0], Infinity, Infinity] is returned.
         **/
        meetSegmentSegment: function (p1, p2, q1, q2) {
            var t, u, i, d,
                li1 = Mat.crossProduct(p1, p2),
                li2 = Mat.crossProduct(q1, q2),
                c = Mat.crossProduct(li1, li2);

            if (Math.abs(c[0]) < Mat.eps) {
                return [c, Infinity, Infinity];
            }

            // Normalize the intersection coordinates
            c[1] /= c[0];
            c[2] /= c[0];
            c[0] /= c[0];

            // Now compute in principle:
            //    t = dist(c - p1) / dist(p2 - p1) and
            //    u = dist(c - q1) / dist(q2 - q1)
            // However: the points q1, q2, p1, p2 might be ideal points - or in general - the
            // coordinates might be not normalized.
            // Note that the z-coordinates of p2 and q2 are used to determine whether it should be interpreted
            // as a segment coordinate or a direction.
            i = (Math.abs(p2[1] - p2[0] * p1[1]) < Mat.eps) ? 2 : 1;
            d = p1[i] / p1[0];
            t = (c[i] - d) / ( (p2[0] !== 0) ? (p2[i] / p2[0] - d) : p2[i] );

            i = (Math.abs(q2[1] - q2[0] * q1[1]) < Mat.eps) ? 2 : 1;
            d = q1[i] / q1[0];
            u = (c[i] - d) / ( (q2[0] !== 0) ? (q2[i] / q2[0] - d) : q2[i] );

            return [c, t, u];
        },

        /****************************************/
        /****   BEZIER CURVE ALGORITHMS      ****/
        /****************************************/

        /**
         * Splits a Bezier curve segment defined by four points into
         * two Bezier curve segments. Dissection point is t=1/2.
         * @param {Array} curve Array of four coordinate arrays of length 2 defining a
         * Bezier curve segment, i.e. [[x0,y0], [x1,y1], [x2,y2], [x3,y3]].
         * @returns {Array} Array consisting of two coordinate arrays for Bezier curves.
         */
        _bezierSplit: function (curve) {
            var p0, p1, p2, p00, p22, p000;

            p0 = [(curve[0][0] + curve[1][0]) * 0.5, (curve[0][1] + curve[1][1]) * 0.5];
            p1 = [(curve[1][0] + curve[2][0]) * 0.5, (curve[1][1] + curve[2][1]) * 0.5];
            p2 = [(curve[2][0] + curve[3][0]) * 0.5, (curve[2][1] + curve[3][1]) * 0.5];

            p00 = [(p0[0] + p1[0]) * 0.5, (p0[1] + p1[1]) * 0.5];
            p22 = [(p1[0] + p2[0]) * 0.5, (p1[1] + p2[1]) * 0.5];

            p000 = [(p00[0] + p22[0]) * 0.5, (p00[1] + p22[1]) * 0.5];

            return [[curve[0], p0, p00, p000], [p000, p22, p2, curve[3]]];
        },

        /**
         * Computes the bounding box [minX, maxY, maxX, minY] of a Bezier curve segment
         * from its control points.
         * @param {Array} curve Array of four coordinate arrays of length 2 defining a
         * Bezier curve segment, i.e. [[x0,y0], [x1,y1], [x2,y2], [x3,y3]].
         * @returns {Array} Bounding box [minX, maxY, maxX, minY]
         */
        _bezierBbox: function (curve) {
            var bb = [];

            if (curve.length === 4) {   // bezierDegree == 3
                bb[0] = Math.min(curve[0][0], curve[1][0], curve[2][0], curve[3][0]); // minX
                bb[1] = Math.max(curve[0][1], curve[1][1], curve[2][1], curve[3][1]); // maxY
                bb[2] = Math.max(curve[0][0], curve[1][0], curve[2][0], curve[3][0]); // maxX
                bb[3] = Math.min(curve[0][1], curve[1][1], curve[2][1], curve[3][1]); // minY
            } else {                   // bezierDegree == 1
                bb[0] = Math.min(curve[0][0], curve[1][0]); // minX
                bb[1] = Math.max(curve[0][1], curve[1][1]); // maxY
                bb[2] = Math.max(curve[0][0], curve[1][0]); // maxX
                bb[3] = Math.min(curve[0][1], curve[1][1]); // minY
            }

            return bb;
        },

        /**
         * Decide if two Bezier curve segments overlap by comparing their bounding boxes.
         * @param {Array} bb1 Bounding box of the first Bezier curve segment
         * @param {Array} bb2 Bounding box of the second Bezier curve segment
         * @returns {Boolean} true if the bounding boxes overlap, false otherwise.
         */
        _bezierOverlap: function (bb1, bb2) {
            return bb1[2] >= bb2[0] && bb1[0] <= bb2[2] && bb1[1] >= bb2[3] && bb1[3] <= bb2[1];
        },

        /**
         * Append list of intersection points to a list.
         * @private
         */
        _bezierListConcat: function (L, Lnew, t1, t2) {
            var i,
                t2exists = Type.exists(t2),
                start = 0,
                len = Lnew.length,
                le = L.length;

            if (le > 0 && len > 0 &&
                    ((L[le - 1][1] === 1 && Lnew[0][1] === 0) ||
                    (t2exists && L[le - 1][2] === 1 && Lnew[0][2] === 0))) {
                start = 1;
            }

            for (i = start; i < len; i++) {
                if (t2exists) {
                    Lnew[i][2] *= 0.5;
                    Lnew[i][2] += t2;
                }

                Lnew[i][1] *= 0.5;
                Lnew[i][1] += t1;

                L.push(Lnew[i]);
            }
        },

        /**
         * Find intersections of two Bezier curve segments by recursive subdivision.
         * Below maxlevel determine intersections by intersection line segments.
         * @param {Array} red Array of four coordinate arrays of length 2 defining the first
         * Bezier curve segment, i.e. [[x0,y0], [x1,y1], [x2,y2], [x3,y3]].
         * @param {Array} blue Array of four coordinate arrays of length 2 defining the second
         * Bezier curve segment, i.e. [[x0,y0], [x1,y1], [x2,y2], [x3,y3]].
         * @param {Number} level Recursion level
         * @returns {Array} List of intersection points (up to nine). Each intersection point is an
         * array of length three (homogeneous coordinates) plus preimages.
         */
        _bezierMeetSubdivision: function (red, blue, level) {
            var bbb, bbr,
                ar, b0, b1, r0, r1, m,
                p0, p1, q0, q1,
                L = [],
                maxLev = 5;      // Maximum recursion level

            bbr = this._bezierBbox(blue);
            bbb = this._bezierBbox(red);

            if (!this._bezierOverlap(bbr, bbb)) {
                return [];
            }

            if (level < maxLev) {
                ar = this._bezierSplit(red);
                r0 = ar[0];
                r1 = ar[1];

                ar = this._bezierSplit(blue);
                b0 = ar[0];
                b1 = ar[1];

                this._bezierListConcat(L, this._bezierMeetSubdivision(r0, b0, level + 1), 0.0, 0.0);
                this._bezierListConcat(L, this._bezierMeetSubdivision(r0, b1, level + 1), 0, 0.5);
                this._bezierListConcat(L, this._bezierMeetSubdivision(r1, b0, level + 1), 0.5, 0.0);
                this._bezierListConcat(L, this._bezierMeetSubdivision(r1, b1, level + 1), 0.5, 0.5);

                return L;
            }

            // Make homogeneous coordinates
            q0 = [1].concat(red[0]);
            q1 = [1].concat(red[3]);
            p0 = [1].concat(blue[0]);
            p1 = [1].concat(blue[3]);

            m = this.meetSegmentSegment(q0, q1, p0, p1);

            if (m[1] >= 0.0 && m[2] >= 0.0 && m[1] <= 1.0 && m[2] <= 1.0) {
                return [m];
            }

            return [];
        },

        /**
         * @param {Boolean} testSegment Test if intersection has to be inside of the segment or somewhere on the line defined by the segment
         */
        _bezierLineMeetSubdivision: function (red, blue, level, testSegment) {
            var bbb, bbr,
                ar, r0, r1, m,
                p0, p1, q0, q1,
                L = [],
                maxLev = 5;      // Maximum recursion level

            bbb = this._bezierBbox(blue);
            bbr = this._bezierBbox(red);

            if (testSegment && !this._bezierOverlap(bbr, bbb)) {
                return [];
            }

            if (level < maxLev) {
                ar = this._bezierSplit(red);
                r0 = ar[0];
                r1 = ar[1];

                this._bezierListConcat(L, this._bezierLineMeetSubdivision(r0, blue, level + 1), 0.0);
                this._bezierListConcat(L, this._bezierLineMeetSubdivision(r1, blue, level + 1), 0.5);

                return L;
            }

            // Make homogeneous coordinates
            q0 = [1].concat(red[0]);
            q1 = [1].concat(red[3]);
            p0 = [1].concat(blue[0]);
            p1 = [1].concat(blue[1]);

            m = this.meetSegmentSegment(q0, q1, p0, p1);

            if (m[1] >= 0.0 && m[1] <= 1.0) {
                if (!testSegment || (m[2] >= 0.0 && m[2] <= 1.0)) {
                    return [m];
                }
            }

            return [];
        },

        /**
         * Find the nr-th intersection point of two Bezier curve segments.
         * @param {Array} red Array of four coordinate arrays of length 2 defining the first
         * Bezier curve segment, i.e. [[x0,y0], [x1,y1], [x2,y2], [x3,y3]].
         * @param {Array} blue Array of four coordinate arrays of length 2 defining the second
         * Bezier curve segment, i.e. [[x0,y0], [x1,y1], [x2,y2], [x3,y3]].
         * @param {Boolean} testSegment Test if intersection has to be inside of the segment or somewhere on the line defined by the segment
         * @returns {Array} Array containing the list of all intersection points as homogeneous coordinate arrays plus
         * preimages [x,y], t_1, t_2] of the two Bezier curve segments.
         *
         */
        meetBeziersegmentBeziersegment: function (red, blue, testSegment) {
            var L, L2, i;

            if (red.length === 4 && blue.length === 4) {
                L = this._bezierMeetSubdivision(red, blue, 0);
            } else {
                L = this._bezierLineMeetSubdivision(red, blue, 0, testSegment);
            }

            L.sort(function (a, b) {
                return (a[1] - b[1]) * 10000000.0 + (a[2] - b[2]);
            });

            L2 = [];
            for (i = 0; i < L.length; i++) {
                // Only push entries different from their predecessor
                if (i === 0 || (L[i][1] !== L[i - 1][1] || L[i][2] !== L[i - 1][2])) {
                    L2.push(L[i]);
                }
            }
            return L2;
        },

        /**
         * Find the nr-th intersection point of two Bezier curves, i.e. curves with bezierDegree == 3.
         * @param {JXG.Curve} red Curve with bezierDegree == 3
         * @param {JXG.Curve} blue Curve with bezierDegree == 3
         * @param {Number} nr The number of the intersection point which should be returned.
         * @returns {Array} The homogeneous coordinates of the nr-th intersection point.
         */
        meetBezierCurveRedBlueSegments: function (red, blue, nr) {
            var p, i, j, k, po,
                redArr, blueArr,
                bbr, bbb, intersections,
                startRed = 0,
                startBlue = 0,
                lenBlue = blue.numberPoints,
                lenRed = red.numberPoints,
                L = [];

            if (lenBlue < blue.bezierDegree + 1 || lenRed < red.bezierDegree + 1) {
                return [0, NaN, NaN];
            }
            lenBlue -= blue.bezierDegree;
            lenRed  -= red.bezierDegree;

            // For sectors, we ignore the "legs"
            if (red.type === Const.OBJECT_TYPE_SECTOR) {
                startRed = 3;
                lenRed  -= 3;
            }
            if (blue.type === Const.OBJECT_TYPE_SECTOR) {
                startBlue = 3;
                lenBlue  -= 3;
            }

            for (i = startRed; i < lenRed; i += red.bezierDegree) {
                p = red.points;
                redArr = [
                    p[i].usrCoords.slice(1),
                    p[i + 1].usrCoords.slice(1)
                ];
                if (red.bezierDegree === 3) {
                    redArr[2] = p[i + 2].usrCoords.slice(1);
                    redArr[3] = p[i + 3].usrCoords.slice(1);
                }

                bbr = this._bezierBbox(redArr);

                for (j = startBlue; j < lenBlue; j += blue.bezierDegree) {
                    p = blue.points;
                    blueArr = [
                        p[j].usrCoords.slice(1),
                        p[j + 1].usrCoords.slice(1)
                    ];
                    if (blue.bezierDegree === 3) {
                        blueArr[2] = p[j + 2].usrCoords.slice(1);
                        blueArr[3] = p[j + 3].usrCoords.slice(1);
                    }

                    bbb = this._bezierBbox(blueArr);
                    if (this._bezierOverlap(bbr, bbb)) {
                        intersections = this.meetBeziersegmentBeziersegment(redArr, blueArr);
                        if (intersections.length === 0) {
                            continue;
                        }
                        for (k = 0; k < intersections.length; k++) {
                            po = intersections[k];
                            if (po[1] < -Mat.eps ||
                                po[1] > 1 + Mat.eps ||
                                po[2] < -Mat.eps ||
                                po[2] > 1 + Mat.eps) {
                                continue;
                            }
                            L.push(po);
                        }
                        if (L.length > nr) {
                            return L[nr][0];
                        }
                    }
                }
            }
            if (L.length > nr) {
                return L[nr][0];
            }

            return [0, NaN, NaN];
        },

        bezierSegmentEval: function (t, curve) {
            var f, x, y,
                t1 = 1.0 - t;

            x = 0;
            y = 0;

            f = t1 * t1 * t1;
            x += f * curve[0][0];
            y += f * curve[0][1];

            f = 3.0 * t * t1 * t1;
            x += f * curve[1][0];
            y += f * curve[1][1];

            f = 3.0 * t * t * t1;
            x += f * curve[2][0];
            y += f * curve[2][1];

            f = t * t * t;
            x += f * curve[3][0];
            y += f * curve[3][1];

            return [1.0, x, y];
        },

        /**
         * Generate the defining points of a 3rd degree bezier curve that approximates
         * a circle sector defined by three coordinate points A, B, C, each defined by an array of length three.
         * The coordinate arrays are given in homogeneous coordinates.
         * @param {Array} A First point
         * @param {Array} B Second point (intersection point)
         * @param {Array} C Third point
         * @param {Boolean} withLegs Flag. If true the legs to the intersection point are part of the curve.
         * @param {Number} sgn Wither 1 or -1. Needed for minor and major arcs. In case of doubt, use 1.
         */
        bezierArc: function (A, B, C, withLegs, sgn) {
            var p1, p2, p3, p4,
                r, phi, beta,
                PI2 = Math.PI * 0.5,
                x = B[1],
                y = B[2],
                z = B[0],
                dataX = [], dataY = [],
                co, si, ax, ay, bx, by, k, v, d, matrix;

            r = this.distance(B, A);

            // x,y, z is intersection point. Normalize it.
            x /= z;
            y /= z;

            phi = this.rad(A.slice(1), B.slice(1), C.slice(1));
            if (sgn === -1) {
                phi = 2 * Math.PI - phi;
            }

            p1 = A;
            p1[1] /= p1[0];
            p1[2] /= p1[0];
            p1[0] /= p1[0];

            p4 = p1.slice(0);

            if (withLegs) {
                dataX = [x, x + 0.333 * (p1[1] - x), x + 0.666 * (p1[1] - x), p1[1]];
                dataY = [y, y + 0.333 * (p1[2] - y), y + 0.666 * (p1[2] - y), p1[2]];
            } else {
                dataX = [p1[1]];
                dataY = [p1[2]];
            }

            while (phi > Mat.eps) {
                if (phi > PI2) {
                    beta = PI2;
                    phi -= PI2;
                } else {
                    beta = phi;
                    phi = 0;
                }

                co = Math.cos(sgn * beta);
                si = Math.sin(sgn * beta);

                matrix = [
                    [1, 0, 0],
                    [x * (1 - co) + y * si, co, -si],
                    [y * (1 - co) - x * si, si,  co]
                ];
                v = Mat.matVecMult(matrix, p1);
                p4 = [v[0] / v[0], v[1] / v[0], v[2] / v[0]];

                ax = p1[1] - x;
                ay = p1[2] - y;
                bx = p4[1] - x;
                by = p4[2] - y;

                d = Math.sqrt((ax + bx) * (ax + bx) + (ay + by) * (ay + by));

                if (Math.abs(by - ay) > Mat.eps) {
                    k = (ax + bx) * (r / d - 0.5) / (by - ay) * 8 / 3;
                } else {
                    k = (ay + by) * (r / d - 0.5) / (ax - bx) * 8 / 3;
                }

                p2 = [1, p1[1] - k * ay, p1[2] + k * ax];
                p3 = [1, p4[1] + k * by, p4[2] - k * bx];

                dataX = dataX.concat([p2[1], p3[1], p4[1]]);
                dataY = dataY.concat([p2[2], p3[2], p4[2]]);
                p1 = p4.slice(0);
            }

            if (withLegs) {
                dataX = dataX.concat([ p4[1] + 0.333 * (x - p4[1]), p4[1] + 0.666 * (x - p4[1]), x]);
                dataY = dataY.concat([ p4[2] + 0.333 * (y - p4[2]), p4[2] + 0.666 * (y - p4[2]), y]);
            }

            return [dataX, dataY];
        },

        /****************************************/
        /****           PROJECTIONS          ****/
        /****************************************/

        /**
         * Calculates the coordinates of the projection of a given point on a given circle. I.o.w. the
         * nearest one of the two intersection points of the line through the given point and the circles
         * center.
         * @param {JXG.Point,JXG.Coords} point Point to project or coords object to project.
         * @param {JXG.Circle} circle Circle on that the point is projected.
         * @param {JXG.Board} [board=point.board] Reference to the board
         * @returns {JXG.Coords} The coordinates of the projection of the given point on the given circle.
         */
        projectPointToCircle: function (point, circle, board) {
            var dist, P, x, y, factor,
                M = circle.center.coords.usrCoords;

            if (!Type.exists(board)) {
                board = point.board;
            }

            // gave us a point
            if (Type.isPoint(point)) {
                dist = point.coords.distance(Const.COORDS_BY_USER, circle.center.coords);
                P = point.coords.usrCoords;
            // gave us coords
            } else {
                dist = point.distance(Const.COORDS_BY_USER, circle.center.coords);
                P = point.usrCoords;
            }

            if (Math.abs(dist) < Mat.eps) {
                dist = Mat.eps;
            }

            factor = circle.Radius() / dist;
            x = M[1] + factor * (P[1] - M[1]);
            y = M[2] + factor * (P[2] - M[2]);

            return new Coords(Const.COORDS_BY_USER, [x, y], board);
        },

        /**
         * Calculates the coordinates of the orthogonal projection of a given point on a given line. I.o.w. the
         * intersection point of the given line and its perpendicular through the given point.
         * @param {JXG.Point|JXG.Coords} point Point to project.
         * @param {JXG.Line} line Line on that the point is projected.
         * @param {JXG.Board} [board=point.board|board=line.board] Reference to a board.
         * @returns {JXG.Coords} The coordinates of the projection of the given point on the given line.
         */
        projectPointToLine: function (point, line, board) {
            var v = [0, line.stdform[1], line.stdform[2]],
                coords;

            if (!Type.exists(board)) {
                if (Type.exists(point.coords)) {
                    board = point.board;
                } else {
                    board = line.board;
                }
            }

            if (Type.exists(point.coords)) {
                coords = point.coords.usrCoords;
            } else {
                coords = point.usrCoords;
            }

            v = Mat.crossProduct(v, coords);
            return new Coords(Const.COORDS_BY_USER, Mat.crossProduct(v, line.stdform), board);
        },

        /**
         * Calculates the coordinates of the orthogonal projection of a given coordinate array on a given line
         * segment defined by two coordinate arrays.
         * @param {Array} p Point to project.
         * @param {Array} q1 Start point of the line segment on that the point is projected.
         * @param {Array} q2 End point of the line segment on that the point is projected.
         * @returns {Array} The coordinates of the projection of the given point on the given segment
         * and the factor that determines the projected point as a convex combination of the
         * two endpoints q1 and q2 of the segment.
         */
        projectCoordsToSegment: function (p, q1, q2) {
            var t, denom,
                s = [q2[1] - q1[1], q2[2] - q1[2]],
                v = [p[1] - q1[1], p[2] - q1[2]];

            /**
             * If the segment has length 0, i.e. is a point,
             * the projection is equal to that point.
             */
            if (Math.abs(s[0]) < Mat.eps && Math.abs(s[1]) < Mat.eps) {
                return [q1, 0];
            }

            t = Mat.innerProduct(v, s);
            denom = Mat.innerProduct(s, s);
            t /= denom;

            return [ [1, t * s[0] + q1[1], t * s[1] + q1[2]], t];
        },

        /**
         * Finds the coordinates of the closest point on a Bezier segment of a
         * {@link JXG.Curve} to a given coordinate array.
         * @param {Array} pos Point to project in homogeneous coordinates.
         * @param {JXG.Curve} curve Curve of type "plot" having Bezier degree 3.
         * @param {Number} start Number of the Bezier segment of the curve.
         * @returns {Array} The coordinates of the projection of the given point
         * on the given Bezier segment and the preimage of the curve which
         * determines the closest point.
         */
        projectCoordsToBeziersegment: function (pos, curve, start) {
            var t0,
                /** @ignore */
                minfunc = function (t) {
                    var z = [1, curve.X(start + t), curve.Y(start + t)];

                    z[1] -= pos[1];
                    z[2] -= pos[2];

                    return z[1] * z[1] + z[2] * z[2];
                };

            t0 = JXG.Math.Numerics.fminbr(minfunc, [0.0, 1.0]);

            return [[1, curve.X(t0 + start), curve.Y(t0 + start)], t0];
        },

        /**
         * Calculates the coordinates of the projection of a given point on a given curve.
         * Uses {@link JXG.Math.Geometry.projectCoordsToCurve}.
         *
         * @param {JXG.Point} point Point to project.
         * @param {JXG.Curve} curve Curve on that the point is projected.
         * @param {JXG.Board} [board=point.board] Reference to a board.
         * @see #projectCoordsToCurve
         * @returns {Array} [JXG.Coords, position] The coordinates of the projection of the given
         * point on the given graph and the relative position on the curve (real number).
         */
        projectPointToCurve: function (point, curve, board) {
            if (!Type.exists(board)) {
                board = point.board;
            }

            var x = point.X(),
                y = point.Y(),
                t = point.position || 0.0,
                result = this.projectCoordsToCurve(x, y, t, curve, board);

            // point.position = result[1];

            return result;
        },

        /**
         * Calculates the coordinates of the projection of a coordinates pair on a given curve. In case of
         * function graphs this is the
         * intersection point of the curve and the parallel to y-axis through the given point.
         * @param {Number} x coordinate to project.
         * @param {Number} y coordinate to project.
         * @param {Number} t start value for newtons method
         * @param {JXG.Curve} curve Curve on that the point is projected.
         * @param {JXG.Board} [board=curve.board] Reference to a board.
         * @see #projectPointToCurve
         * @returns {JXG.Coords} Array containing the coordinates of the projection of the given point on the given curve and
         * the position on the curve.
         */
        projectCoordsToCurve: function (x, y, t, curve, board) {
            var newCoords, newCoordsObj, i, j,
                mindist, dist, lbda, v, coords, d,
                p1, p2, res,
                minfunc, t_new, f_new, f_old, delta, steps,
                minX, maxX,
                infty = Number.POSITIVE_INFINITY;

            if (!Type.exists(board)) {
                board = curve.board;
            }


            if (Type.evaluate(curve.visProp.curvetype) === 'plot') {
                t = 0;
                mindist = infty;
                if (curve.numberPoints === 0) {
                    newCoords = [0, 1, 1];
                } else {
                    newCoords = [curve.Z(0), curve.X(0), curve.Y(0)];
                }

                if (curve.numberPoints > 1) {
                    v = [1, x, y];
                    if (curve.bezierDegree === 3) {
                        j = 0;
                    } else {
                        p1 = [curve.Z(0), curve.X(0), curve.Y(0)];
                    }
                    for (i = 0; i < curve.numberPoints - 1; i++) {
                        if (curve.bezierDegree === 3) {
                            res = this.projectCoordsToBeziersegment(v, curve, j);
                        } else {
                            p2 = [curve.Z(i + 1), curve.X(i + 1), curve.Y(i + 1)];
                            res = this.projectCoordsToSegment(v, p1, p2);
                        }
                        lbda = res[1];
                        coords = res[0];

                        if (0.0 <= lbda && lbda <= 1.0) {
                            dist = this.distance(coords, v);
                            d = i + lbda;
                        } else if (lbda < 0.0) {
                            coords = p1;
                            dist = this.distance(p1, v);
                            d = i;
                        } else if (lbda > 1.0 && i === curve.numberPoints - 2) {
                            coords = p2;
                            dist = this.distance(coords, v);
                            d = curve.numberPoints - 1;
                        }

                        if (dist < mindist) {
                            mindist = dist;
                            t = d;
                            newCoords = coords;
                        }

                        if (curve.bezierDegree === 3) {
                            j++;
                            i += 2;
                        } else {
                            p1 = p2;
                        }
                    }
                }

                newCoordsObj = new Coords(Const.COORDS_BY_USER, newCoords, board);
            } else {   // 'parameter', 'polar', 'functiongraph'
                /** @ignore */
                minfunc = function (t) {
                    var dx, dy;
                    if (t < curve.minX() || t > curve.maxX()) {
                        return Infinity;
                    }
                    dx = x - curve.X(t);
                    dy = y - curve.Y(t);
                    return dx * dx + dy * dy;
                };

                f_old = minfunc(t);
                steps = 50;
                minX = curve.minX();
                maxX = curve.maxX();

                delta = (maxX - minX) / steps;
                t_new = minX;

                for (i = 0; i < steps; i++) {
                    f_new = minfunc(t_new);

                    if (f_new < f_old || f_old === Infinity) {
                        t = t_new;
                        f_old = f_new;
                    }

                    t_new += delta;
                }

                //t = Numerics.root(Numerics.D(minfunc), t);
                t = Numerics.fminbr(minfunc, [Math.max(t - delta, minX), Math.min(t + delta, maxX)]);

                // Distinction between closed and open curves is not necessary.
                // If closed, the cyclic projection shift will work anyhow
                // if (Math.abs(curve.X(minX) - curve.X(maxX)) < Mat.eps &&
                //     Math.abs(curve.Y(minX) - curve.Y(maxX)) < Mat.eps) {
                //     // Cyclically
                //     if (t < minX) {
                //         t = maxX + t - minX;
                //     }
                //     if (t > maxX) {
                //         t = minX + t - maxX;
                //     }
                // } else {
                    t = (t < minX) ? minX : t;
                    t = (t > maxX) ? maxX : t;
                // }

                newCoordsObj = new Coords(Const.COORDS_BY_USER, [curve.X(t), curve.Y(t)], board);
            }

            return [curve.updateTransform(newCoordsObj), t];
        },

        /**
         * Calculates the coordinates of the closest orthogonal projection of a given coordinate array onto the
         * border of a polygon.
         * @param {Array} p Point to project.
         * @param {JXG.Polygon} pol Polygon element
         * @returns {Array} The coordinates of the closest projection of the given point to the border of the polygon.
         */
        projectCoordsToPolygon: function (p, pol) {
            var i,
                len = pol.vertices.length,
                d_best = Infinity,
                d,
                projection, proj,
                bestprojection;

            for (i = 0; i < len - 1; i++) {
                projection = JXG.Math.Geometry.projectCoordsToSegment(
                    p,
                    pol.vertices[i].coords.usrCoords,
                    pol.vertices[i + 1].coords.usrCoords
                );

                if (0 <= projection[1] && projection[1] <= 1) {
                    d = JXG.Math.Geometry.distance(projection[0], p, 3);
                    proj = projection[0];
                } else if (projection[1] < 0) {
                    d = JXG.Math.Geometry.distance(pol.vertices[i].coords.usrCoords, p, 3);
                    proj = pol.vertices[i].coords.usrCoords;
                } else {
                    d = JXG.Math.Geometry.distance(pol.vertices[i + 1].coords.usrCoords, p, 3);
                    proj = pol.vertices[i + 1].coords.usrCoords;
                }
                if (d < d_best) {
                    bestprojection = proj.slice(0);
                    d_best = d;
                }
            }
            return bestprojection;
        },

        /**
         * Calculates the coordinates of the projection of a given point on a given turtle. A turtle consists of
         * one or more curves of curveType 'plot'. Uses {@link JXG.Math.Geometry.projectPointToCurve}.
         * @param {JXG.Point} point Point to project.
         * @param {JXG.Turtle} turtle on that the point is projected.
         * @param {JXG.Board} [board=point.board] Reference to a board.
         * @returns {Array} [JXG.Coords, position] Array containing the coordinates of the projection of the given point on the turtle and
         * the position on the turtle.
         */
        projectPointToTurtle: function (point, turtle, board) {
            var newCoords, t, x, y, i, dist, el, minEl,
                res, newPos,
                np = 0,
                npmin = 0,
                mindist = Number.POSITIVE_INFINITY,
                len = turtle.objects.length;

            if (!Type.exists(board)) {
                board = point.board;
            }

            // run through all curves of this turtle
            for (i = 0; i < len; i++) {
                el = turtle.objects[i];

                if (el.elementClass === Const.OBJECT_CLASS_CURVE) {
                    res = this.projectPointToCurve(point, el);
                    newCoords = res[0];
                    newPos = res[1];
                    dist = this.distance(newCoords.usrCoords, point.coords.usrCoords);

                    if (dist < mindist) {
                        x = newCoords.usrCoords[1];
                        y = newCoords.usrCoords[2];
                        t = newPos;
                        mindist = dist;
                        minEl = el;
                        npmin = np;
                    }
                    np += el.numberPoints;
                }
            }

            newCoords = new Coords(Const.COORDS_BY_USER, [x, y], board);
            // point.position = t + npmin;
            // return minEl.updateTransform(newCoords);
            return [minEl.updateTransform(newCoords), t + npmin];
        },

        /**
         * Trivial projection of a point to another point.
         * @param {JXG.Point} point Point to project (not used).
         * @param {JXG.Point} dest Point on that the point is projected.
         * @returns {JXG.Coords} The coordinates of the projection of the given point on the given circle.
         */
        projectPointToPoint: function (point, dest) {
            return dest.coords;
        },

        /**
         *
         * @param {JXG.Point|JXG.Coords} point
         * @param {JXG.Board} [board]
         */
        projectPointToBoard: function (point, board) {
            var i, l, c,
                brd = board || point.board,
                // comparison factor, point coord idx, bbox idx, 1st bbox corner x & y idx, 2nd bbox corner x & y idx
                config = [
                    // left
                    [1, 1, 0, 0, 3, 0, 1],
                    // top
                    [-1, 2, 1, 0, 1, 2, 1],
                    // right
                    [-1, 1, 2, 2, 1, 2, 3],
                    // bottom
                    [1, 2, 3, 0, 3, 2, 3]
                ],
                coords = point.coords || point,
                bbox = brd.getBoundingBox();

            for (i = 0; i < 4; i++) {
                c = config[i];
                if (c[0] * coords.usrCoords[c[1]] < c[0] * bbox[c[2]]) {
                    // define border
                    l = Mat.crossProduct([1, bbox[c[3]], bbox[c[4]]], [1, bbox[c[5]], bbox[c[6]]]);
                    l[3] = 0;
                    l = Mat.normalize(l);

                    // project point
                    coords = this.projectPointToLine({coords: coords}, {stdform: l}, brd);
                }
            }

            return coords;
        },

        /**
         * Calculates the distance of a point to a line. The point and the line are given by homogeneous
         * coordinates. For lines this can be line.stdform.
         * @param {Array} point Homogeneous coordinates of a point.
         * @param {Array} line Homogeneous coordinates of a line ([C,A,B] where A*x+B*y+C*z=0).
         * @returns {Number} Distance of the point to the line.
         */
        distPointLine: function (point, line) {
            var a = line[1],
                b = line[2],
                c = line[0],
                nom;

            if (Math.abs(a) + Math.abs(b) < Mat.eps) {
                return Number.POSITIVE_INFINITY;
            }

            nom = a * point[1] + b * point[2] + c;
            a *= a;
            b *= b;

            return Math.abs(nom) / Math.sqrt(a + b);
        },

        /**
         * Helper function to create curve which displays a Reuleaux polygons.
         * @param {Array} points Array of points which should be the vertices of the Reuleaux polygon. Typically,
         * these point list is the array vertices of a regular polygon.
         * @param {Number} nr Number of vertices
         * @returns {Array} An array containing the two functions defining the Reuleaux polygon and the two values
         * for the start and the end of the paramtric curve. array may be used as parent array of a
         * {@link JXG.Curve}.
         *
         * @example
         * var A = brd.create('point',[-2,-2]);
         * var B = brd.create('point',[0,1]);
         * var pol = brd.create('regularpolygon',[A,B,3], {withLines:false, fillColor:'none', highlightFillColor:'none', fillOpacity:0.0});
         * var reuleauxTriangle = brd.create('curve', JXG.Math.Geometry.reuleauxPolygon(pol.vertices, 3),
         *                          {strokeWidth:6, strokeColor:'#d66d55', fillColor:'#ad5544', highlightFillColor:'#ad5544'});
         *
         * </pre><div class="jxgbox" id="JXG2543a843-46a9-4372-abc1-94d9ad2db7ac" style="width: 300px; height: 300px;"></div>
         * <script type="text/javascript">
         * var brd = JXG.JSXGraph.initBoard('JXG2543a843-46a9-4372-abc1-94d9ad2db7ac', {boundingbox: [-5, 5, 5, -5], axis: true, showcopyright:false, shownavigation: false});
         * var A = brd.create('point',[-2,-2]);
         * var B = brd.create('point',[0,1]);
         * var pol = brd.create('regularpolygon',[A,B,3], {withLines:false, fillColor:'none', highlightFillColor:'none', fillOpacity:0.0});
         * var reuleauxTriangle = brd.create('curve', JXG.Math.Geometry.reuleauxPolygon(pol.vertices, 3),
         *                          {strokeWidth:6, strokeColor:'#d66d55', fillColor:'#ad5544', highlightFillColor:'#ad5544'});
         * </script><pre>
         */
        reuleauxPolygon: function (points, nr) {
            var beta,
                pi2 = Math.PI * 2,
                pi2_n = pi2 / nr,
                diag = (nr - 1) / 2,
                d = 0,
                makeFct = function (which, trig) {
                    return function (t, suspendUpdate) {
                        var t1 = (t % pi2 + pi2) % pi2,
                            j = Math.floor(t1 / pi2_n) % nr;

                        if (!suspendUpdate) {
                            d = points[0].Dist(points[diag]);
                            beta = Mat.Geometry.rad([points[0].X() + 1, points[0].Y()], points[0], points[diag % nr]);
                        }

                        if (isNaN(j)) {
                            return j;
                        }

                        t1 = t1 * 0.5 + j * pi2_n * 0.5 + beta;

                        return points[j][which]() + d * Math[trig](t1);
                    };
                };

            return [makeFct('X', 'cos'), makeFct('Y', 'sin'), 0, pi2];
        }
    });

    return Mat.Geometry;
});

/*
    Copyright 2008-2022
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Alfred Wassermann

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <http://www.gnu.org/licenses/>
    and <http://opensource.org/licenses/MIT/>.
 */


/*global JXG: true, define: true*/
/*jslint nomen: true, plusplus: true*/

/* depends:
 jxg
 math/math
 utils/type
 */

define('math/plot',['jxg', 'base/constants', 'base/coords', 'math/math', 'math/extrapolate', 'math/numerics',
        'math/statistics', 'math/geometry', 'math/ia', 'utils/type'],
        function (JXG, Const, Coords, Mat, Extrapolate, Numerics, Statistics, Geometry, IntervalArithmetic, Type) {

    "use strict";

    /**
     * Functions for plotting of curves.
     * @name JXG.Math.Plot
     * @exports Mat.Plot as JXG.Math.Plot
     * @namespace
     */
    Mat.Plot = {

        /**
         * Check if at least one point on the curve is finite and real.
         **/
        checkReal: function (points) {
            var b = false,
                i, p,
                len = points.length;

            for (i = 0; i < len; i++) {
                p = points[i].usrCoords;
                if (!isNaN(p[1]) && !isNaN(p[2]) && Math.abs(p[0]) > Mat.eps) {
                    b = true;
                    break;
                }
            }
            return b;
        },

        //----------------------------------------------------------------------
        // Plot algorithm v0
        //----------------------------------------------------------------------
        /**
         * Updates the data points of a parametric curve. This version is used if {@link JXG.Curve#doadvancedplot} is <tt>false</tt>.
         * @param {JXG.Curve} curve JSXGraph curve element
         * @param {Number} mi Left bound of curve
         * @param {Number} ma Right bound of curve
         * @param {Number} len Number of data points
         * @returns {JXG.Curve} Reference to the curve object.
         */
        updateParametricCurveNaive: function (curve, mi, ma, len) {
            var i, t,
                suspendUpdate = false,
                stepSize = (ma - mi) / len;

            for (i = 0; i < len; i++) {
                t = mi + i * stepSize;
                // The last parameter prevents rounding in usr2screen().
                curve.points[i].setCoordinates(Const.COORDS_BY_USER, [curve.X(t, suspendUpdate), curve.Y(t, suspendUpdate)], false);
                curve.points[i]._t = t;
                suspendUpdate = true;
            }
            return curve;
        },

        //----------------------------------------------------------------------
        // Plot algorithm v1
        //----------------------------------------------------------------------
        /**
         * Crude and cheap test if the segment defined by the two points <tt>(x0, y0)</tt> and <tt>(x1, y1)</tt> is
         * outside the viewport of the board. All parameters have to be given in screen coordinates.
         *
         * @private
         * @deprecated
         * @param {Number} x0
         * @param {Number} y0
         * @param {Number} x1
         * @param {Number} y1
         * @param {JXG.Board} board
         * @returns {Boolean} <tt>true</tt> if the given segment is outside the visible area.
         */
        isSegmentOutside: function (x0, y0, x1, y1, board) {
            return (y0 < 0 && y1 < 0) || (y0 > board.canvasHeight && y1 > board.canvasHeight) ||
                (x0 < 0 && x1 < 0) || (x0 > board.canvasWidth && x1 > board.canvasWidth);
        },

        /**
         * Compares the absolute value of <tt>dx</tt> with <tt>MAXX</tt> and the absolute value of <tt>dy</tt>
         * with <tt>MAXY</tt>.
         *
         * @private
         * @deprecated
         * @param {Number} dx
         * @param {Number} dy
         * @param {Number} MAXX
         * @param {Number} MAXY
         * @returns {Boolean} <tt>true</tt>, if <tt>|dx| &lt; MAXX</tt> and <tt>|dy| &lt; MAXY</tt>.
         */
        isDistOK: function (dx, dy, MAXX, MAXY) {
            return (Math.abs(dx) < MAXX && Math.abs(dy) < MAXY) && !isNaN(dx + dy);
        },

         /**
         * @private
         * @deprecated
         */
        isSegmentDefined: function (x0, y0, x1, y1) {
            return !(isNaN(x0 + y0) && isNaN(x1 + y1));
        },

        /**
         * Updates the data points of a parametric curve. This version is used if {@link JXG.Curve#doadvancedplot} is <tt>true</tt>.
         * Since 0.99 this algorithm is deprecated. It still can be used if {@link JXG.Curve#doadvancedplotold} is <tt>true</tt>.
         *
         * @deprecated
         * @param {JXG.Curve} curve JSXGraph curve element
         * @param {Number} mi Left bound of curve
         * @param {Number} ma Right bound of curve
         * @returns {JXG.Curve} Reference to the curve object.
         */
        updateParametricCurveOld: function (curve, mi, ma) {
            var i, t, d,
                x, y, t0, x0, y0, top, depth,
                MAX_DEPTH, MAX_XDIST, MAX_YDIST,
                suspendUpdate = false,
                po = new Coords(Const.COORDS_BY_USER, [0, 0], curve.board, false),
                dyadicStack = [],
                depthStack = [],
                pointStack = [],
                divisors = [],
                distOK = false,
                j = 0,
                distFromLine = function (p1, p2, p0) {
                    var lbda, d,
                        x0 = p0[1] - p1[1],
                        y0 = p0[2] - p1[2],
                        x1 = p2[0] - p1[1],
                        y1 = p2[1] - p1[2],
                        den = x1 * x1 + y1 * y1;

                    if (den >= Mat.eps) {
                        lbda = (x0 * x1 + y0 * y1) / den;
                        if (lbda > 0) {
                            if (lbda <= 1) {
                                x0 -= lbda * x1;
                                y0 -= lbda * y1;
                            // lbda = 1.0;
                            } else {
                                x0 -= x1;
                                y0 -= y1;
                            }
                        }
                    }
                    d = x0 * x0 + y0 * y0;
                    return Math.sqrt(d);
                };

            JXG.deprecated('Curve.updateParametricCurveOld()');

            if (curve.board.updateQuality === curve.board.BOARD_QUALITY_LOW) {
                MAX_DEPTH = 15;
                MAX_XDIST = 10; // 10
                MAX_YDIST = 10; // 10
            } else {
                MAX_DEPTH = 21;
                MAX_XDIST = 0.7; // 0.7
                MAX_YDIST = 0.7; // 0.7
            }

            divisors[0] = ma - mi;
            for (i = 1; i < MAX_DEPTH; i++) {
                divisors[i] = divisors[i - 1] * 0.5;
            }

            i = 1;
            dyadicStack[0] = 1;
            depthStack[0] = 0;

            t = mi;
            po.setCoordinates(Const.COORDS_BY_USER, [curve.X(t, suspendUpdate), curve.Y(t, suspendUpdate)], false);

            // Now, there was a first call to the functions defining the curve.
            // Defining elements like sliders have been evaluated.
            // Therefore, we can set suspendUpdate to false, so that these defining elements
            // need not be evaluated anymore for the rest of the plotting.
            suspendUpdate = true;
            x0 = po.scrCoords[1];
            y0 = po.scrCoords[2];
            t0 = t;

            t = ma;
            po.setCoordinates(Const.COORDS_BY_USER, [curve.X(t, suspendUpdate), curve.Y(t, suspendUpdate)], false);
            x = po.scrCoords[1];
            y = po.scrCoords[2];

            pointStack[0] = [x, y];

            top = 1;
            depth = 0;

            curve.points = [];
            curve.points[j++] = new Coords(Const.COORDS_BY_SCREEN, [x0, y0], curve.board, false);

            do {
                distOK = this.isDistOK(x - x0, y - y0, MAX_XDIST, MAX_YDIST) || this.isSegmentOutside(x0, y0, x, y, curve.board);
                while (depth < MAX_DEPTH && (!distOK || depth < 6) && (depth <= 7 || this.isSegmentDefined(x0, y0, x, y))) {
                    // We jump out of the loop if
                    // * depth>=MAX_DEPTH or
                    // * (depth>=6 and distOK) or
                    // * (depth>7 and segment is not defined)

                    dyadicStack[top] = i;
                    depthStack[top] = depth;
                    pointStack[top] = [x, y];
                    top += 1;

                    i = 2 * i - 1;
                    // Here, depth is increased and may reach MAX_DEPTH
                    depth++;
                    // In that case, t is undefined and we will see a jump in the curve.
                    t = mi + i * divisors[depth];

                    po.setCoordinates(Const.COORDS_BY_USER, [curve.X(t, suspendUpdate), curve.Y(t, suspendUpdate)], false, true);
                    x = po.scrCoords[1];
                    y = po.scrCoords[2];
                    distOK = this.isDistOK(x - x0, y - y0, MAX_XDIST, MAX_YDIST) || this.isSegmentOutside(x0, y0, x, y, curve.board);
                }

                if (j > 1) {
                    d = distFromLine(curve.points[j - 2].scrCoords, [x, y], curve.points[j - 1].scrCoords);
                    if (d < 0.015) {
                        j -= 1;
                    }
                }

                curve.points[j] = new Coords(Const.COORDS_BY_SCREEN, [x, y], curve.board, false);
                curve.points[j]._t = t;
                j += 1;

                x0 = x;
                y0 = y;
                t0 = t;

                top -= 1;
                x = pointStack[top][0];
                y = pointStack[top][1];
                depth = depthStack[top] + 1;
                i = dyadicStack[top] * 2;

            } while (top > 0 && j < 500000);

            curve.numberPoints = curve.points.length;

            return curve;
        },

        //----------------------------------------------------------------------
        // Plot algorithm v2
        //----------------------------------------------------------------------

        /**
         * Add a point to the curve plot. If the new point is too close to the previously inserted point,
         * it is skipped.
         * Used in {@link JXG.Curve._plotRecursive}.
         *
         * @private
         * @param {JXG.Coords} pnt Coords to add to the list of points
         */
        _insertPoint_v2: function (curve, pnt, t) {
            var lastReal = !isNaN(this._lastCrds[1] + this._lastCrds[2]),     // The last point was real
                newReal = !isNaN(pnt.scrCoords[1] + pnt.scrCoords[2]),        // New point is real point
                cw = curve.board.canvasWidth,
                ch = curve.board.canvasHeight,
                off = 500;

            newReal = newReal &&
                        (pnt.scrCoords[1] > -off && pnt.scrCoords[2] > -off &&
                         pnt.scrCoords[1] < cw + off && pnt.scrCoords[2] < ch + off);

            /*
             * Prevents two consecutive NaNs or points wich are too close
             */
            if ((!newReal && lastReal) ||
                    (newReal && (!lastReal ||
                        Math.abs(pnt.scrCoords[1] - this._lastCrds[1]) > 0.7 ||
                        Math.abs(pnt.scrCoords[2] - this._lastCrds[2]) > 0.7))) {
                pnt._t = t;
                curve.points.push(pnt);
                this._lastCrds = pnt.copy('scrCoords');
            }
        },

        /**
         * Check if there is a single NaN function value at t0.
         * @param {*} curve
         * @param {*} t0
         * @returns {Boolean} true if there is a second NaN point close by, false otherwise
         */
        neighborhood_isNaN_v2: function(curve, t0) {
            var is_undef,
                pnt = new Coords(Const.COORDS_BY_USER, [0, 0], curve.board, false),
                t, p;

            t = t0 + Mat.eps;
            pnt.setCoordinates(Const.COORDS_BY_USER, [curve.X(t, true), curve.Y(t, true)], false);
            p = pnt.usrCoords;
            is_undef = isNaN(p[1] + p[2]);
            if (!is_undef) {
                t = t0 - Mat.eps;
                pnt.setCoordinates(Const.COORDS_BY_USER, [curve.X(t, true), curve.Y(t, true)], false);
                p = pnt.usrCoords;
                is_undef = isNaN(p[1] + p[2]);
                if (!is_undef) {
                    return false;
                }
            }
            return true;
        },

        /**
         * Investigate a function term at the bounds of intervals where
         * the function is not defined, e.g. log(x) at x = 0.
         *
         * c is inbetween a and b
         * @private
         * @param {JXG.Curve} curve JSXGraph curve element
         * @param {Array} a Screen coordinates of the left interval bound
         * @param {Array} b Screen coordinates of the right interval bound
         * @param {Array} c Screen coordinates of the bisection point at (ta + tb) / 2
         * @param {Number} ta Parameter which evaluates to a, i.e. [1, X(ta), Y(ta)] = a in screen coordinates
         * @param {Number} tb Parameter which evaluates to b, i.e. [1, X(tb), Y(tb)] = b in screen coordinates
         * @param {Number} tc (ta + tb) / 2 = tc. Parameter which evaluates to b, i.e. [1, X(tc), Y(tc)] = c in screen coordinates
         * @param {Number} depth Actual recursion depth. The recursion stops if depth is equal to 0.
         * @returns {JXG.Boolean} true if the point is inserted and the recursion should stop, false otherwise.
         */
        _borderCase: function (curve, a, b, c, ta, tb, tc, depth) {
            var t, pnt, p,
                p_good = null,
                j,
                max_it = 30,
                is_undef = false,
                t_nan, t_real, t_real2,
                vx, vy, vx2, vy2, dx, dy;
                // asymptote;

            if (depth <= 1) {
                pnt = new Coords(Const.COORDS_BY_USER, [0, 0], curve.board, false);
                // Test if there is a single undefined point.
                // If yes, we ignore it.
                if (isNaN(a[1] + a[2]) && !isNaN(c[1] + c[2]) && !this.neighborhood_isNaN_v2(curve, ta)) {
                    return false;
                }
                if (isNaN(b[1] + b[2]) && !isNaN(c[1] + c[2]) && !this.neighborhood_isNaN_v2(curve, tb)) {
                    return false;
                }
                if (isNaN(c[1] + c[2]) && (!isNaN(a[1] + a[2]) || !isNaN(b[1] + b[2])) &&
                    !this.neighborhood_isNaN_v2(curve, tc)) {
                    return false;
                }

                j = 0;
                // Bisect a, b and c until the point t_real is inside of the definition interval
                // and as close as possible at the boundary.
                // t_real2 is the second closest point.
                do {
                    // There are four cases:
                    //  a  |  c  |  b
                    // ---------------
                    // inf | R   | R
                    // R   | R   | inf
                    // inf | inf | R
                    // R   | inf | inf
                    //
                    if (isNaN(a[1] + a[2]) && !isNaN(c[1] + c[2])) {
                        t_nan = ta;
                        t_real = tc;
                        t_real2 = tb;
                    } else if (isNaN(b[1] + b[2]) && !isNaN(c[1] + c[2])) {
                        t_nan = tb;
                        t_real = tc;
                        t_real2 = ta;
                    } else if (isNaN(c[1] + c[2]) && !isNaN(b[1] + b[2])) {
                        t_nan = tc;
                        t_real = tb;
                        t_real2 = tb + (tb - tc);
                    } else if (isNaN(c[1] + c[2]) && !isNaN(a[1] + a[2])) {
                        t_nan = tc;
                        t_real = ta;
                        t_real2 = ta - (tc - ta);
                    } else {
                        return false;
                    }
                    t = 0.5 * (t_nan + t_real);
                    pnt.setCoordinates(Const.COORDS_BY_USER, [curve.X(t, true), curve.Y(t, true)], false);
                    p = pnt.usrCoords;

                    is_undef = isNaN(p[1] + p[2]);
                    if (is_undef) {
                        t_nan = t;
                    } else {
                        t_real2 = t_real;
                        t_real = t;
                    }
                    ++j;
                } while (is_undef && j < max_it);

                // If bisection was successful, take this point.
                // Useful only for general curves, for function graph
                // the code below overwrite p_good from here.
                if (j < max_it) {
                    p_good = p.slice();
                    c = p.slice();
                    t_real = t;
                }

                // OK, bisection has been done now.
                // t_real contains the closest inner point to the border of the interval we could find.
                // t_real2 is the second nearest point to this boundary.
                // Now we approximate the derivative by computing the slope of the line through these two points
                // and test if it is "infinite", i.e larger than 400 in absolute values.
                //
                vx = curve.X(t_real, true) ;
                vx2 = curve.X(t_real2, true) ;
                dx = (vx - vx2) / (t_real - t_real2);
                vy = curve.Y(t_real, true) ;
                vy2 = curve.Y(t_real2, true) ;
                dy = (vy - vy2) / (t_real - t_real2);

                if (p_good !== null) {
                    this._insertPoint_v2(curve, new Coords(Const.COORDS_BY_USER, p_good, curve.board, false));
                    return true;
                }
           }
           return false;
       },

        /**
         * Recursive interval bisection algorithm for curve plotting.
         * Used in {@link JXG.Curve.updateParametricCurve}.
         * @private
         * @deprecated
         * @param {JXG.Curve} curve JSXGraph curve element
         * @param {Array} a Screen coordinates of the left interval bound
         * @param {Number} ta Parameter which evaluates to a, i.e. [1, X(ta), Y(ta)] = a in screen coordinates
         * @param {Array} b Screen coordinates of the right interval bound
         * @param {Number} tb Parameter which evaluates to b, i.e. [1, X(tb), Y(tb)] = b in screen coordinates
         * @param {Number} depth Actual recursion depth. The recursion stops if depth is equal to 0.
         * @param {Number} delta If the distance of the bisection point at (ta + tb) / 2 from the point (a + b) / 2 is less then delta,
         *                 the segment [a,b] is regarded as straight line.
         * @returns {JXG.Curve} Reference to the curve object.
         */
        _plotRecursive_v2: function (curve, a, ta, b, tb, depth, delta) {
            var tc, c,
                ds, mindepth = 0,
                isSmooth, isJump, isCusp,
                cusp_threshold = 0.5,
                jump_threshold = 0.99,
                pnt = new Coords(Const.COORDS_BY_USER, [0, 0], curve.board, false);

            if (curve.numberPoints > 65536) {
                return;
            }

            // Test if the function is undefined in an interval
            if (depth < this.nanLevel && this._isUndefined(curve, a, ta, b, tb)) {
                return this;
            }

            if (depth < this.nanLevel && this._isOutside(a, ta, b, tb, curve.board)) {
                return this;
            }

            tc = (ta  + tb) * 0.5;
            pnt.setCoordinates(Const.COORDS_BY_USER, [curve.X(tc, true), curve.Y(tc, true)], false);
            c = pnt.scrCoords;

            if (this._borderCase(curve, a, b, c, ta, tb, tc, depth)) {
                return this;
            }

            ds = this._triangleDists(a, b, c);           // returns [d_ab, d_ac, d_cb, d_cd]

            isSmooth = (depth < this.smoothLevel) && (ds[3] < delta);

            isJump = (depth < this.jumpLevel) &&
                        ((ds[2] > jump_threshold * ds[0]) ||
                         (ds[1] > jump_threshold * ds[0]) ||
                        ds[0] === Infinity || ds[1] === Infinity || ds[2] === Infinity);

            isCusp = (depth < this.smoothLevel + 2) && (ds[0] < cusp_threshold * (ds[1] + ds[2]));

            if (isCusp) {
                mindepth = 0;
                isSmooth = false;
            }

            --depth;

            if (isJump) {
                this._insertPoint_v2(curve, new Coords(Const.COORDS_BY_SCREEN, [NaN, NaN], curve.board, false), tc);
            } else if (depth <= mindepth || isSmooth) {
                this._insertPoint_v2(curve, pnt, tc);
                //if (this._borderCase(a, b, c, ta, tb, tc, depth)) {}
            } else {
                this._plotRecursive_v2(curve, a, ta, c, tc, depth, delta);

                if (!isNaN(pnt.scrCoords[1] + pnt.scrCoords[2])) {
                    this._insertPoint_v2(curve, pnt, tc);
                }

                this._plotRecursive_v2(curve, c, tc, b, tb, depth, delta);
            }

            return this;
        },

        /**
         * Updates the data points of a parametric curve. This version is used if {@link JXG.Curve#plotVersion} is <tt>3</tt>.
         *
         * @param {JXG.Curve} curve JSXGraph curve element
         * @param {Number} mi Left bound of curve
         * @param {Number} ma Right bound of curve
         * @returns {JXG.Curve} Reference to the curve object.
         */
        updateParametricCurve_v2: function (curve, mi, ma) {
            var ta, tb, a, b,
                suspendUpdate = false,
                pa = new Coords(Const.COORDS_BY_USER, [0, 0], curve.board, false),
                pb = new Coords(Const.COORDS_BY_USER, [0, 0], curve.board, false),
                depth, delta,
                w2, h2, bbox,
                ret_arr;

            //console.time("plot");
            if (curve.board.updateQuality === curve.board.BOARD_QUALITY_LOW) {
                depth = Type.evaluate(curve.visProp.recursiondepthlow) || 13;
                delta = 2;
                // this.smoothLevel = 5; //depth - 7;
                this.smoothLevel = depth - 6;
                this.jumpLevel = 3;
            } else {
                depth = Type.evaluate(curve.visProp.recursiondepthhigh) || 17;
                delta = 2;
                // smoothLevel has to be small for graphs in a huge interval.
                // this.smoothLevel = 3; //depth - 7; // 9
                this.smoothLevel = depth - 9; // 9
                this.jumpLevel = 2;
            }
            this.nanLevel = depth - 4;

            curve.points = [];

            if (this.xterm === 'x') {
                // For function graphs we can restrict the plot interval
                // to the visible area +plus margin
                bbox = curve.board.getBoundingBox();
                w2 = (bbox[2] - bbox[0]) * 0.3;
                h2 = (bbox[1] - bbox[3]) * 0.3;
                ta = Math.max(mi, bbox[0] - w2);
                tb = Math.min(ma, bbox[2] + w2);
            } else {
                ta = mi;
                tb = ma;
            }
            pa.setCoordinates(Const.COORDS_BY_USER, [curve.X(ta, suspendUpdate), curve.Y(ta, suspendUpdate)], false);

            // The first function calls of X() and Y() are done. We can now
            // switch `suspendUpdate` on. If supported by the functions, this
            // avoids for the rest of the plotting algorithm, evaluation of any
            // parent elements.
            suspendUpdate = true;

            pb.setCoordinates(Const.COORDS_BY_USER, [curve.X(tb, suspendUpdate), curve.Y(tb, suspendUpdate)], false);

            // Find start and end points of the visible area (plus a certain margin)
            ret_arr = this._findStartPoint(curve, pa.scrCoords, ta, pb.scrCoords, tb);
            pa.setCoordinates(Const.COORDS_BY_SCREEN, ret_arr[0], false);
            ta = ret_arr[1];
            ret_arr = this._findStartPoint(curve, pb.scrCoords, tb, pa.scrCoords, ta);
            pb.setCoordinates(Const.COORDS_BY_SCREEN, ret_arr[0], false);
            tb = ret_arr[1];

            // Save the visible area.
            // This can be used in Curve.hasPoint().
            this._visibleArea = [ta, tb];

            // Start recursive plotting algorithm
            a = pa.copy('scrCoords');
            b = pb.copy('scrCoords');
            pa._t = ta;
            curve.points.push(pa);
            this._lastCrds = pa.copy('scrCoords');   // Used in _insertPoint
            this._plotRecursive_v2(curve, a, ta, b, tb, depth, delta);
            pb._t = tb;
            curve.points.push(pb);

            curve.numberPoints = curve.points.length;
            //console.timeEnd("plot");

            return curve;
        },

        //----------------------------------------------------------------------
        // Plot algorithm v3
        //----------------------------------------------------------------------
        /**
         *
         * @param {JXG.Curve} curve JSXGraph curve element
         * @param {*} pnt
         * @param {*} t
         * @param {*} depth
         * @param {*} limes
         * @private
         */
        _insertLimesPoint: function(curve, pnt, t, depth, limes) {
            var p0, p1, p2;

            // Ignore jump point if it follows limes
            if ((Math.abs(this._lastUsrCrds[1]) === Infinity && Math.abs(limes.left_x) === Infinity) ||
                (Math.abs(this._lastUsrCrds[2]) === Infinity && Math.abs(limes.left_y) === Infinity)) {
                // console.log("SKIP:", pnt.usrCoords, this._lastUsrCrds, limes);
                return;
            }

            // // Ignore jump left from limes
            // if (Math.abs(limes.left_x) > 100 * Math.abs(this._lastUsrCrds[1])) {
            //     x = Math.sign(limes.left_x) * Infinity;
            // } else {
            //     x = limes.left_x;
            // }
            // if (Math.abs(limes.left_y) > 100 * Math.abs(this._lastUsrCrds[2])) {
            //     y = Math.sign(limes.left_y) * Infinity;
            // } else {
            //     y = limes.left_y;
            // }
            // //pnt.setCoordinates(Const.COORDS_BY_USER, [x, y], false);

            // Add points at a jump. pnt contains [NaN, NaN]
            //console.log("Add", t, pnt.usrCoords, limes, depth)
            p0 = new Coords(Const.COORDS_BY_USER, [limes.left_x, limes.left_y], curve.board);
            p0._t = t;
            curve.points.push(p0);

            if (!isNaN(limes.left_x) && !isNaN(limes.left_y) && !isNaN(limes.right_x) && !isNaN(limes.right_y) &&
                (Math.abs(limes.left_x - limes.right_x) > Mat.eps || Math.abs(limes.left_y - limes.right_y) > Mat.eps)) {
                p1 = new Coords(Const.COORDS_BY_SCREEN, pnt, curve.board);
                p1._t = t;
                curve.points.push(p1);
            }

            p2 = new Coords(Const.COORDS_BY_USER, [limes.right_x, limes.right_y], curve.board);
            p2._t = t;
            curve.points.push(p2);
            this._lastScrCrds = p2.copy('scrCoords');
            this._lastUsrCrds = p2.copy('usrCoords');

        },

        /**
         * Add a point to the curve plot. If the new point is too close to the previously inserted point,
         * it is skipped.
         * Used in {@link JXG.Curve._plotRecursive}.
         *
         * @private
         * @param {JXG.Curve} curve JSXGraph curve element
         * @param {JXG.Coords} pnt Coords to add to the list of points
         */
        _insertPoint: function (curve, pnt, t, depth, limes) {
            var last_is_real = !isNaN(this._lastScrCrds[1] + this._lastScrCrds[2]),     // The last point was real
                point_is_real  = !isNaN(pnt[1] + pnt[2]),                               // New point is real point
                cw = curve.board.canvasWidth,
                ch = curve.board.canvasHeight,
                p,
                near = 0.8,
                off = 500;

            if (Type.exists(limes)) {
                this._insertLimesPoint(curve, pnt, t, depth, limes);
                return;
            }

            // Check if point has real coordinates and
            // coordinates are not too far away from canvas.
            point_is_real = point_is_real &&
                        (pnt[1] > -off     && pnt[2] > -off &&
                         pnt[1] < cw + off && pnt[2] < ch + off);

            // Prevent two consecutive NaNs
            if (!last_is_real && !point_is_real) {
                return;
            }

            // Prevent two consecutive points which are too close
            if (point_is_real && last_is_real &&
                Math.abs(pnt[1] - this._lastScrCrds[1]) < near &&
                Math.abs(pnt[2] - this._lastScrCrds[2]) < near) {
                return;
            }

            // Prevent two consecutive points at infinity (either direction)
            if ((Math.abs(pnt[1]) === Infinity &&
                 Math.abs(this._lastUsrCrds[1]) === Infinity) ||
                (Math.abs(pnt[2]) === Infinity &&
                 Math.abs(this._lastUsrCrds[2]) === Infinity)) {
                return;
            }

            //console.log("add", t, pnt.usrCoords, depth)
            // Add regular point
            p = new Coords(Const.COORDS_BY_SCREEN, pnt, curve.board);
            p._t = t;
            curve.points.push(p);
            this._lastScrCrds = p.copy('scrCoords');
            this._lastUsrCrds = p.copy('usrCoords');
        },

        /**
         * Compute distances in screen coordinates between the points ab,
         * ac, cb, and cd, where d = (a + b)/2.
         * cd is used for the smoothness test, ab, ac, cb are used to detect jumps, cusps and poles.
         *
         * @private
         * @param {Array} a Screen coordinates of the left interval bound
         * @param {Array} b Screen coordinates of the right interval bound
         * @param {Array} c Screen coordinates of the bisection point at (ta + tb) / 2
         * @returns {Array} array of distances in screen coordinates between: ab, ac, cb, and cd.
         */
        _triangleDists: function (a, b, c) {
            var d, d_ab, d_ac, d_cb, d_cd;

            d = [a[0] * b[0], (a[1] + b[1]) * 0.5, (a[2] + b[2]) * 0.5];

            d_ab = Geometry.distance(a, b, 3);
            d_ac = Geometry.distance(a, c, 3);
            d_cb = Geometry.distance(c, b, 3);
            d_cd = Geometry.distance(c, d, 3);

            return [d_ab, d_ac, d_cb, d_cd];
        },

        /**
         * Test if the function is undefined on an interval:
         * If the interval borders a and b are undefined, 20 random values
         * are tested if they are undefined, too.
         * Only if all values are undefined, we declare the function to be undefined in this interval.
         *
         * @private
         * @param {JXG.Curve} curve JSXGraph curve element
         * @param {Array} a Screen coordinates of the left interval bound
         * @param {Number} ta Parameter which evaluates to a, i.e. [1, X(ta), Y(ta)] = a in screen coordinates
         * @param {Array} b Screen coordinates of the right interval bound
         * @param {Number} tb Parameter which evaluates to b, i.e. [1, X(tb), Y(tb)] = b in screen coordinates
         */
        _isUndefined: function (curve, a, ta, b, tb) {
            var t, i, pnt;

            if (!isNaN(a[1] + a[2]) || !isNaN(b[1] + b[2])) {
                return false;
            }

            pnt = new Coords(Const.COORDS_BY_USER, [0, 0], curve.board, false);

            for (i = 0; i < 20; ++i) {
                t = ta + Math.random() * (tb - ta);
                pnt.setCoordinates(Const.COORDS_BY_USER, [curve.X(t, true), curve.Y(t, true)], false);
                if (!isNaN(pnt.scrCoords[0] + pnt.scrCoords[1] + pnt.scrCoords[2])) {
                    return false;
                }
            }

            return true;
        },

        /**
         * Decide if a path segment is too far from the canvas that we do not need to draw it.
         * @private
         * @param  {Array}  a  Screen coordinates of the start point of the segment
         * @param  {Array}  ta Curve parameter of a  (unused).
         * @param  {Array}  b  Screen coordinates of the end point of the segment
         * @param  {Array}  tb Curve parameter of b (unused).
         * @param  {JXG.Board} board
         * @returns {Boolean}   True if the segment is too far away from the canvas, false otherwise.
         */
        _isOutside: function (a, ta, b, tb, board) {
            var off = 500,
                cw = board.canvasWidth,
                ch = board.canvasHeight;

            return !!((a[1] < -off && b[1] < -off) ||
                (a[2] < -off && b[2] < -off) ||
                (a[1] > cw + off && b[1] > cw + off) ||
                (a[2] > ch + off && b[2] > ch + off));
        },

        /**
         * Decide if a point of a curve is too far from the canvas that we do not need to draw it.
         * @private
         * @param {Array}  a  Screen coordinates of the point
         * @param {JXG.Board} board
         * @returns {Boolean}  True if the point is too far away from the canvas, false otherwise.
         */
        _isOutsidePoint: function (a, board) {
            var off = 500,
                cw = board.canvasWidth,
                ch = board.canvasHeight;

            return !!(a[1] < -off ||
                      a[2] < -off ||
                      a[1] > cw + off ||
                      a[2] > ch + off);
        },

        /**
         * For a curve c(t) defined on the interval [ta, tb] find the first point
         * which is in the visible area of the board (plus some outside margin).
         * <p>
         * This method is necessary to restrict the recursive plotting algorithm
         * {@link JXG.Curve._plotRecursive} to the visible area and not waste
         * recursion to areas far outside of the visible area.
         * <p>
         * This method can also be used to find the last visible point
         * by reversing the input parameters.
         *
         * @param {JXG.Curve} curve JSXGraph curve element
         * @param  {Array}  ta Curve parameter of a.
         * @param  {Array}  b  Screen coordinates of the end point of the segment (unused)
         * @param  {Array}  tb Curve parameter of b
         * @return {Array}  Array of length two containing the screen ccordinates of
         * the starting point and the curve parameter at this point.
         * @private
         */
        _findStartPoint: function (curve, a, ta, b, tb) {
            var i, delta, tc,
                td, z, isFound,
                w2, h2,
                pnt =  new Coords(Const.COORDS_BY_USER, [0, 0], curve.board, false),
                steps = 40,
                eps = 0.01,
                fnX1, fnX2, fnY1, fnY2,
                bbox = curve.board.getBoundingBox();

            // The code below is too unstable.
            // E.g. [function(t) { return Math.pow(t, 2) * (t + 5) * Math.pow(t - 5, 2); }, -8, 8]
            // Therefore, we return here.
            if (true || !this._isOutsidePoint(a, curve.board)) {
                return [a, ta];
            }

            w2 = (bbox[2] - bbox[0]) * 0.3;
            h2 = (bbox[1] - bbox[3]) * 0.3;
            bbox[0] -= w2;
            bbox[1] += h2;
            bbox[2] += w2;
            bbox[3] -= h2;

            delta = (tb - ta) / steps;
            tc = ta + delta;
            isFound = false;

            fnX1 = function(t) { return curve.X(t, true) - bbox[0]; };
            fnY1 = function(t) { return curve.Y(t, true) - bbox[1]; };
            fnX2 = function(t) { return curve.X(t, true) - bbox[2]; };
            fnY2 = function(t) { return curve.Y(t, true) - bbox[3]; };
            for (i = 0; i < steps; ++i) {
                // Left border
                z = bbox[0];
                td = Numerics.root(fnX1, [tc - delta, tc], curve);
                // td = Numerics.fzero(fnX1, [tc - delta, tc], this);
                // console.log("A", tc - delta, tc, td, Math.abs(this.X(td, true) - z));
                if (Math.abs(curve.X(td, true) - z) < eps) { //} * Math.abs(z)) {
                    isFound = true;
                    break;
                }
                // Top border
                z = bbox[1];
                td = Numerics.root(fnY1, [tc - delta, tc], curve);
                // td = Numerics.fzero(fnY1, [tc - delta, tc], this);
                // console.log("B", tc - delta, tc, td, Math.abs(this.Y(td, true) - z));
                if (Math.abs(curve.Y(td, true) - z) < eps) { // * Math.abs(z)) {
                    isFound = true;
                    break;
                }
                // Right border
                z = bbox[2];
                td = Numerics.root(fnX2, [tc - delta, tc], curve);
                // td = Numerics.fzero(fnX2, [tc - delta, tc], this);
                // console.log("C", tc - delta, tc, td, Math.abs(this.X(td, true) - z));
                if (Math.abs(curve.X(td, true) - z) < eps) { // * Math.abs(z)) {
                    isFound = true;
                    break;
                }
                // Bottom border
                z = bbox[3];
                td = Numerics.root(fnY2, [tc - delta, tc], curve);
                // td = Numerics.fzero(fnY2, [tc - delta, tc], this);
                // console.log("D", tc - delta, tc, td, Math.abs(this.Y(td, true) - z));
                if (Math.abs(curve.Y(td, true) - z) < eps) { // * Math.abs(z)) {
                    isFound = true;
                    break;
                }
                tc += delta;
            }
            if (isFound) {
                pnt.setCoordinates(Const.COORDS_BY_USER, [curve.X(td, true), curve.Y(td, true)], false);
                return [pnt.scrCoords, td];
            }
            console.log("TODO _findStartPoint", curve.Y.toString(), tc);
            pnt.setCoordinates(Const.COORDS_BY_USER, [curve.X(ta, true), curve.Y(ta, true)], false);
            return [pnt.scrCoords, ta];
        },

        /**
         * Investigate a function term at the bounds of intervals where
         * the function is not defined, e.g. log(x) at x = 0.
         *
         * c is inbetween a and b
         *
         * @param {JXG.Curve} curve JSXGraph curve element
         * @param {Array} a Screen coordinates of the left interval bound
         * @param {Array} b Screen coordinates of the right interval bound
         * @param {Array} c Screen coordinates of the bisection point at (ta + tb) / 2
         * @param {Number} ta Parameter which evaluates to a, i.e. [1, X(ta), Y(ta)] = a in screen coordinates
         * @param {Number} tb Parameter which evaluates to b, i.e. [1, X(tb), Y(tb)] = b in screen coordinates
         * @param {Number} tc (ta + tb) / 2 = tc. Parameter which evaluates to b, i.e. [1, X(tc), Y(tc)] = c in screen coordinates
         * @param {Number} depth Actual recursion depth. The recursion stops if depth is equal to 0.
         * @returns {JXG.Boolean} true if the point is inserted and the recursion should stop, false otherwise.
         *
         * @private
         */
        _getBorderPos: function(curve, ta, a, tc, c, tb, b) {
            var t, pnt, p,
                j,
                max_it = 30,
                is_undef = false,
                t_real2,
                t_good, t_bad;

            pnt = new Coords(Const.COORDS_BY_USER, [0, 0], curve.board, false);
            j = 0;
            // Bisect a, b and c until the point t_real is inside of the definition interval
            // and as close as possible at the boundary.
            // t_real2 is the second closest point.
            // There are four cases:
            //  a  |  c  |  b
            // ---------------
            // inf | R   | R
            // R   | R   | inf
            // inf | inf | R
            // R   | inf | inf
            //
            if (isNaN(a[1] + a[2]) && !isNaN(c[1] + c[2])) {
                t_bad = ta;
                t_good = tc;
                t_real2 = tb;
            } else if (isNaN(b[1] + b[2]) && !isNaN(c[1] + c[2])) {
                t_bad = tb;
                t_good = tc;
                t_real2 = ta;
            } else if (isNaN(c[1] + c[2]) && !isNaN(b[1] + b[2])) {
                t_bad = tc;
                t_good = tb;
                t_real2 = tb + (tb - tc);
            } else if (isNaN(c[1] + c[2]) && !isNaN(a[1] + a[2])) {
                t_bad = tc;
                t_good = ta;
                t_real2 = ta - (tc - ta);
            } else {
                return false;
            }
            do {
                t = 0.5 * (t_good + t_bad);
                pnt.setCoordinates(Const.COORDS_BY_USER, [curve.X(t, true), curve.Y(t, true)], false);
                p = pnt.usrCoords;
                is_undef = isNaN(p[1] + p[2]);
                if (is_undef) {
                    t_bad = t;
                } else {
                    t_real2 = t_good;
                    t_good = t;
                }
                ++j;
            } while (j < max_it && Math.abs(t_good - t_bad) > Mat.eps);
            return t;
        },

        /**
         *
         * @param {JXG.Curve} curve JSXGraph curve element
         * @param {Number} ta
         * @param {Number} tb
         */
        _getCuspPos: function(curve, ta, tb) {
            var a = [curve.X(ta, true), curve.Y(ta, true)],
                b = [curve.X(tb, true), curve.Y(tb, true)],
                max_func = function(t) {
                    var c = [curve.X(t, true), curve.Y(t, true)];
                    return -(Math.sqrt((a[0] - c[0]) * (a[0] - c[0]) + (a[1] - c[1]) * (a[1] - c[1])) +
                            Math.sqrt((b[0] - c[0]) * (b[0] - c[0]) + (b[1] - c[1]) * (b[1] - c[1])));
                };

            return Numerics.fminbr(max_func, [ta, tb], curve);
        },

        /**
         *
         * @param {JXG.Curve} curve JSXGraph curve element
         * @param {Number} ta
         * @param {Number} tb
         */
        _getJumpPos: function(curve, ta, tb) {
            var max_func = function(t) {
                    var e = Mat.eps * Mat.eps,
                        c1 = [curve.X(t, true), curve.Y(t, true)],
                        c2 = [curve.X(t + e, true), curve.Y(t + e, true)];
                    return -Math.abs( (c2[1] - c1[1]) / (c2[0] - c1[0]) );
                };

            return Numerics.fminbr(max_func, [ta, tb], curve);
        },

        /**
         *
         * @param {JXG.Curve} curve JSXGraph curve element
         * @param {Number} t
         * @private
         */
        _getLimits: function(curve, t) {
            var res,
                step = 2 / (curve.maxX() - curve.minX()),
                x_l, x_r, y_l, y_r;

            // From left
            res = Extrapolate.limit(t, -step, curve.X);
            x_l = res[0];
            if (res[1] === 'infinite') {
                x_l = Math.sign(x_l) * Infinity;
            }

            res = Extrapolate.limit(t, -step, curve.Y);
            y_l = res[0];
            if (res[1] === 'infinite') {
                y_l = Math.sign(y_l) * Infinity;
            }

            // From right
            res = Extrapolate.limit(t, step, curve.X);
            x_r = res[0];
            if (res[1] === 'infinite') {
                x_r = Math.sign(x_r) * Infinity;
            }

            res = Extrapolate.limit(t, step, curve.Y);
            y_r = res[0];
            if (res[1] === 'infinite') {
                y_r = Math.sign(y_r) * Infinity;
            }

            return {
                    left_x: x_l,
                    left_y: y_l,
                    right_x: x_r,
                    right_y: y_r,
                    t: t
                };
        },

        /**
         *
         * @param {JXG.Curve} curve JSXGraph curve element
         * @param {Array} a
         * @param {Number} tc
         * @param {Array} c
         * @param {Number} tb
         * @param {Array} b
         * @param {String} may_be_special
         * @param {Number} depth
         * @private
         */
        _getLimes: function(curve, ta, a, tc, c, tb, b, may_be_special, depth) {
            var t;

            if (may_be_special === 'border') {
                t = this._getBorderPos(curve, ta, a, tc, c, tb, b);
            } else if (may_be_special === 'cusp') {
                t = this._getCuspPos(curve, ta, tb);
            } else if (may_be_special === 'jump') {
                t = this._getJumpPos(curve, ta, tb);
            }
            return this._getLimits(curve, t);
        },

        /**
         * Recursive interval bisection algorithm for curve plotting.
         * Used in {@link JXG.Curve.updateParametricCurve}.
         * @private
         * @param {JXG.Curve} curve JSXGraph curve element
         * @param {Array} a Screen coordinates of the left interval bound
         * @param {Number} ta Parameter which evaluates to a, i.e. [1, X(ta), Y(ta)] = a in screen coordinates
         * @param {Array} b Screen coordinates of the right interval bound
         * @param {Number} tb Parameter which evaluates to b, i.e. [1, X(tb), Y(tb)] = b in screen coordinates
         * @param {Number} depth Actual recursion depth. The recursion stops if depth is equal to 0.
         * @param {Number} delta If the distance of the bisection point at (ta + tb) / 2 from the point (a + b) / 2 is less then delta,
         *                 the segment [a,b] is regarded as straight line.
         * @returns {JXG.Curve} Reference to the curve object.
         */
        _plotNonRecursive: function (curve, a, ta, b, tb, d) {
            var tc, c, ds,
                mindepth = 0,
                limes = null,
                a_nan, b_nan,
                isSmooth = false,
                may_be_special = '',
                x, y, oc, depth, ds0,
                stack = [],
                stack_length = 0,
                item;

            oc = curve.board.origin.scrCoords;
            stack[stack_length++] = [a, ta, b, tb, d, Infinity];
            while (stack_length > 0) {
                // item = stack.pop();
                item = stack[--stack_length];
                a = item[0];
                ta = item[1];
                b = item[2];
                tb = item[3];
                depth = item[4];
                ds0 = item[5];

                isSmooth = false;
                may_be_special = '';
                limes = null;
                //console.log(stack.length, item)

                if (curve.points.length > 65536) {
                    return;
                }

                if (depth < this.nanLevel) {
                    // Test if the function is undefined in the whole interval [ta, tb]
                    if (this._isUndefined(curve, a, ta, b, tb)) {
                        continue;
                    }
                    // Test if the graph is far outside the visible are for the interval [ta, tb]
                    if (this._isOutside(a, ta, b, tb, curve.board)) {
                        continue;
                    }
                }

                tc = (ta  + tb) * 0.5;

                // Screen coordinates of point at tc
                x = curve.X(tc, true);
                y = curve.Y(tc, true);
                c = [1, oc[1] + x * curve.board.unitX, oc[2] - y * curve.board.unitY];
                ds = this._triangleDists(a, b, c);           // returns [d_ab, d_ac, d_cb, d_cd]

                a_nan = isNaN(a[1] + a[2]);
                b_nan = isNaN(b[1] + b[2]);
                if ((a_nan && !b_nan) || (!a_nan && b_nan)) {
                    may_be_special = 'border';
                } else if (ds[0] > 0.66 * ds0 ||
                            ds[0] < this.cusp_threshold * (ds[1] + ds[2]) ||
                            ds[1] > 5 * ds[2] ||
                            ds[2] > 5 * ds[1]) {
                    may_be_special = 'cusp';
                } else if ((ds[2] > this.jump_threshold * ds[0]) ||
                           (ds[1] > this.jump_threshold * ds[0]) ||
                            ds[0] === Infinity || ds[1] === Infinity || ds[2] === Infinity) {
                    may_be_special = 'jump';
                }
                isSmooth = (may_be_special === '' && depth < this.smoothLevel && ds[3] < this.smooth_threshold);

                if (depth < this.testLevel && !isSmooth) {
                    if (may_be_special === '') {
                        isSmooth = true;
                    } else {
                        limes = this._getLimes(curve, ta, a, tc, c, tb, b, may_be_special, depth);
                    }
                }

                if (limes !== null) {
                    c = [1, NaN, NaN];
                    this._insertPoint(curve, c, tc, depth, limes);
                } else if (depth <= mindepth || isSmooth) {
                    this._insertPoint(curve, c, tc, depth, null);
                } else {
                    stack[stack_length++] = [c, tc, b, tb, depth - 1, ds[0]];
                    stack[stack_length++] = [a, ta, c, tc, depth - 1, ds[0]];
                }
            }

            return this;
        },

        /**
         * Updates the data points of a parametric curve. This version is used if {@link JXG.Curve#plotVersion} is <tt>3</tt>.
         * This is an experimental plot version, <b>not recommended</b> to be used.
         * @param {JXG.Curve} curve JSXGraph curve element
         * @param {Number} mi Left bound of curve
         * @param {Number} ma Right bound of curve
         * @returns {JXG.Curve} Reference to the curve object.
         */
        updateParametricCurve_v3: function (curve, mi, ma) {
            var ta, tb, a, b,
                suspendUpdate = false,
                pa = new Coords(Const.COORDS_BY_USER, [0, 0], curve.board, false),
                pb = new Coords(Const.COORDS_BY_USER, [0, 0], curve.board, false),
                depth,
                w2, // h2,
                bbox,
                ret_arr;

            // console.log("-----------------------------------------------------------");
            // console.time("plot");
            if (curve.board.updateQuality === curve.board.BOARD_QUALITY_LOW) {
                depth = Type.evaluate(curve.visProp.recursiondepthlow) || 14;
            } else {
                depth = Type.evaluate(curve.visProp.recursiondepthhigh) || 17;
            }

            // smoothLevel has to be small for graphs in a huge interval.
            this.smoothLevel = 7; //depth - 10;
            this.nanLevel = depth - 4;
            this.testLevel = 4;
            this.cusp_threshold = 0.5;
            this.jump_threshold = 0.99;
            this.smooth_threshold = 2;

            curve.points = [];

            if (curve.xterm === 'x') {
                // For function graphs we can restrict the plot interval
                // to the visible area +plus margin
                bbox = curve.board.getBoundingBox();
                w2 = (bbox[2] - bbox[0]) * 0.3;
                //h2 = (bbox[1] - bbox[3]) * 0.3;
                ta = Math.max(mi, bbox[0] - w2);
                tb = Math.min(ma, bbox[2] + w2);
            } else {
                ta = mi;
                tb = ma;
            }
            pa.setCoordinates(Const.COORDS_BY_USER, [curve.X(ta, suspendUpdate), curve.Y(ta, suspendUpdate)], false);

            // The first function calls of X() and Y() are done. We can now
            // switch `suspendUpdate` on. If supported by the functions, this
            // avoids for the rest of the plotting algorithm, evaluation of any
            // parent elements.
            suspendUpdate = true;

            pb.setCoordinates(Const.COORDS_BY_USER, [curve.X(tb, suspendUpdate), curve.Y(tb, suspendUpdate)], false);

            // Find start and end points of the visible area (plus a certain margin)
            ret_arr = this._findStartPoint(curve, pa.scrCoords, ta, pb.scrCoords, tb);
            pa.setCoordinates(Const.COORDS_BY_SCREEN, ret_arr[0], false);
            ta = ret_arr[1];
            ret_arr = this._findStartPoint(curve, pb.scrCoords, tb, pa.scrCoords, ta);
            pb.setCoordinates(Const.COORDS_BY_SCREEN, ret_arr[0], false);
            tb = ret_arr[1];

            // Save the visible area.
            // This can be used in Curve.hasPoint().
            this._visibleArea = [ta, tb];

            // Start recursive plotting algorithm
            a = pa.copy('scrCoords');
            b = pb.copy('scrCoords');
            pa._t = ta;
            curve.points.push(pa);
            this._lastScrCrds = pa.copy('scrCoords');   // Used in _insertPoint
            this._lastUsrCrds = pa.copy('usrCoords');   // Used in _insertPoint

            this._plotNonRecursive(curve, a, ta, b, tb, depth);

            pb._t = tb;
            curve.points.push(pb);

            curve.numberPoints = curve.points.length;
            // console.timeEnd("plot");
            // console.log("number of points:", this.numberPoints);

            return curve;
        },

        //----------------------------------------------------------------------
        // Plot algorithm v4
        //----------------------------------------------------------------------

        _criticalInterval: function(vec, le, level) {
            var i, j, le1, med,
                sgn, sgnChange,
                isGroup   = false,
                abs_vec,
                last = -Infinity,
                very_small = false,
                smooth    = false,
                group     = 0,
                groups    = [],
                types     = [],
                positions = [];

            abs_vec = Statistics.abs(vec);
            med = Statistics.median(abs_vec);

            if (med < 1.0e-7) {
                med = 1.0e-7;
                very_small = true;
            } else {
                med *= this.criticalThreshold;
            }

            //console.log("Median", med);
            for (i = 0; i < le; i++) {
                // Start a group if not yet done and
                // add position to group
                if (abs_vec[i] > med /*&& abs_vec[i] > 0.01*/)  {
                    positions.push({i: i, v: vec[i], group: group});
                    last = i;
                    if (!isGroup) {
                        isGroup = true;
                    }
                } else {
                    if (isGroup && i > last + 4) {
                        // End the group
                        if (positions.length > 0) {
                            groups.push(positions.slice(0));
                        }
                        positions = [];
                        isGroup = false;
                        group++;
                    }
                }
            }
            if (isGroup) {
                if (positions.length > 1) {
                    groups.push(positions.slice(0));
                }
            }

            if (very_small && groups.length === 0) {
                smooth = true;
            }

            // Decide if there is a singular critical point
            // or if a whole interval is problematic.
            // The latter is the case if the differences have many sign changes.
            for (j = 0; j < groups.length; j++) {
                types[j] = 'point';
                le1 = groups[j].length;
                if (le1 < 64) {
                    continue;
                }
                sgnChange = 0;
                sgn = Math.sign(groups[j][0].v);
                for (i = 1; i < le1; i++) {
                    if (Math.sign(groups[j][i].v) !== sgn) {
                        sgnChange++;
                        sgn = Math.sign(groups[j][i].v);
                    }
                }
                if (sgnChange * 6 > le1) {
                    types[j] = 'interval';
                }
            }

            return {smooth: smooth, groups: groups, types: types};
        },

        Component: function() {
            this.left_isNaN =  false;
            this.right_isNaN = false;
            this.left_t = null;
            this.right_t = null;
            this.t_values = [];
            this.x_values = [];
            this.y_values = [];
            this.len = 0;
        },

        findComponents: function(curve, mi, ma, steps) {
            var i, t, le, h, x, y,
                components = [],
                comp,
                comp_nr = 0,
                cnt = 0,
                cntNaNs = 0,
                comp_started = false,
                suspended = false;

            h = (ma - mi) / steps;
            components[comp_nr] = new this.Component();
            comp = components[comp_nr];

            for (i = 0, t = mi; i <= steps; i++, t += h) {
                x = curve.X(t, suspended);
                y = curve.Y(t, suspended);

                if (isNaN(x) || isNaN(y)) {
                    cntNaNs++;
                    // Wait for - at least - two consecutive NaNs
                    // This avoids starting a new component if
                    // the function value has infinity as intermediate value.
                    if (cntNaNs > 1 && comp_started) {
                        // Finalize a component
                        comp.right_isNaN = true;
                        comp.right_t = t - h;
                        comp.len = cnt;

                        // Prepare a new component
                        comp_started = false;
                        comp_nr++;
                        components[comp_nr] =  new this.Component();
                        comp = components[comp_nr];
                        cntNaNs = 0;
                    }
                } else {
                    // Now there is a non-NaN entry.
                    if (!comp_started) {
                        // Start the component
                        comp_started = true;
                        cnt = 0;
                        if (cntNaNs > 0) {
                            comp.left_t = t - h;
                            comp.left_isNaN = true;
                        }
                    }
                    cntNaNs = 0;
                    // Add the value to the component
                    comp.t_values[cnt] = t;
                    comp.x_values[cnt] = x;
                    comp.y_values[cnt] = y;
                    cnt++;
                }
                if (i === 0) {
                    suspended = true;
                }
            }
            if (comp_started) {
                comp.len = cnt;
            } else {
                components.pop();
            }

            return components;
        },

        getPointType: function(curve, pos, t_approx, t_values, x_table, y_table, len) {
            var x_values = x_table[0],
                y_values = y_table[0],
                full_len = t_values.length,
                result = {
                    idx: pos,
                    t: t_approx, //t_values[pos],
                    x: x_values[pos],
                    y: y_values[pos],
                    type: 'other'
                };

            if (pos < 5) {
                result.type = 'borderleft';
                result.idx = 0;
                result.t = t_values[0];
                result.x = x_values[0];
                result.y = y_values[0];

                // console.log('Border left', result.t);
                return result;
            }
            if (pos > len - 6) {
                result.type = 'borderright';
                result.idx = full_len - 1;
                result.t = t_values[full_len - 1];
                result.x = x_values[full_len - 1];
                result.y = y_values[full_len - 1];

                // console.log('Border right', result.t, full_len - 1);
                return result;
            }

            return result;
        },

        newtonApprox: function(idx, t, h, level, table) {
            var i, s = 0.0;
            for (i = level; i > 0; i--) {
                s = (s + table[i][idx]) * (t - (i - 1) * h) / i;
            }
            return s + table[0][idx];
        },

        thiele: function(t, recip, t_values, idx, degree) {
            var i, v = 0.0;
            for (i = degree; i > 1; i--) {
                v = (t - t_values[idx + i]) / (recip[i][idx + 1] - recip[i - 2][idx + 1] + v);
            }
            return recip[0][idx + 1] + (t - t_values[idx + 1]) / (recip[1][idx + 1] + v);
        },

        differenceMethodExperiments: function(component, curve) {
            var i, level, le, up,
                t_values = component.t_values,
                x_values = component.x_values,
                y_values = component.y_values,
                x_diffs = [],
                y_diffs = [],
                x_slopes = [],
                y_slopes = [],
                x_table = [],
                y_table = [],
                x_recip = [],
                y_recip = [],
                h, numerator,
                // x_med, y_med,
                foundCriticalPoint = 0,
                pos, ma, j, v,
                groups,
                criticalPoints = [];

            h = t_values[1] - t_values[0];
            x_table.push([]);
            y_table.push([]);
            x_recip.push([]);
            y_recip.push([]);
            le = y_values.length;
            for (i = 0; i < le; i++) {
                x_table[0][i] = x_values[i];
                y_table[0][i] = y_values[i];
                x_recip[0][i] = x_values[i];
                y_recip[0][i] = y_values[i];
            }

            x_table.push([]);
            y_table.push([]);
            x_recip.push([]);
            y_recip.push([]);
            numerator = h;
            le = y_values.length - 1;
            for (i = 0; i < le; i++) {
                x_diffs[i] = x_values[i + 1] - x_values[i];
                y_diffs[i] = y_values[i + 1] - y_values[i];
                x_slopes[i] = x_diffs[i];
                y_slopes[i] = y_diffs[i];
                x_table[1][i] = x_diffs[i];
                y_table[1][i] = y_diffs[i];
                x_recip[1][i] = numerator / x_diffs[i];
                y_recip[1][i] = numerator / y_diffs[i];
            }
            le--;

            up = Math.min(8, y_values.length - 1);
            for (level = 1; level < up; level++) {
                x_table.push([]);
                y_table.push([]);
                x_recip.push([]);
                y_recip.push([]);
                numerator *= h;
                for (i = 0; i < le; i++) {
                    x_diffs[i] = x_diffs[i + 1] - x_diffs[i];
                    y_diffs[i] = y_diffs[i + 1] - y_diffs[i];
                    x_table[level + 1][i] = x_diffs[i];
                    y_table[level + 1][i] = y_diffs[i];
                    x_recip[level + 1][i] = numerator / (x_recip[level][i + 1] - x_recip[level][i]) + x_recip[level - 1][i + 1];
                    y_recip[level + 1][i] = numerator / (y_recip[level][i + 1] - y_recip[level][i]) + y_recip[level - 1][i + 1];
                }

                // if (level == 1) {
                //     console.log("bends level=", level, y_diffs.toString());
                // }

                // Store point location which may be centered around
                // critical points.
                // If the lebvel is suitable, step out of the loop.
                groups = this._criticalPoints(y_diffs, le, level);
                if (groups === false) {
                    // Its seems, the degree of the polynomial is equal to level
console.log("Polynomial of degree", level);
                    groups = [];
                    break;
                }
                if (groups.length > 0) {
                    foundCriticalPoint++;
                    if (foundCriticalPoint > 1 && level % 2 === 0) {
                        break;
                    }
                }
                le--;
            }

            // console.log("Last diffs", y_diffs, "level", level);

            // Analyze the groups which have been found.
            for (i = 0; i < groups.length; i++) {
                // console.log("Group", i, groups[i])
                // Identify the maximum difference, i.e. the center of the "problem"
                ma = -Infinity;
                for (j = 0; j < groups[i].length; j++) {
                    v = Math.abs(groups[i][j].v);
                    if (v > ma) {
                        ma = v;
                        pos = j;
                    }
                }
                pos = Math.floor(groups[i][pos].i + level / 2);
                // Analyze the critical point
                criticalPoints.push(this.getPointType(curve, pos, t_values, x_values, y_values, x_slopes, y_slopes, le + 1));
            }

            return [criticalPoints, x_table, y_table, x_recip, y_recip];

        },

        getCenterOfCriticalInterval: function(group, degree, t_values) {
            var ma, j, pos, v,
                num = 0.0,
                den = 0.0,
                h = t_values[1] - t_values[0],
                pos_mean,
                range = [];

            // Identify the maximum difference, i.e. the center of the "problem"
            // If there are several equal maxima, store the positions
            // in the array range and determine the center of the array.

            ma = -Infinity;
            range = [];
            for (j = 0; j < group.length; j++) {
                v = Math.abs(group[j].v);
                if (v > ma) {
                    range = [j];
                    ma = v;
                    pos = j;
                } else if (ma === v) {
                    range.push(j);
                }
            }
            if (range.length > 0) {
                pos_mean = range.reduce(function(total, val) { return total + val; }, 0) / range.length;
                pos = Math.floor(pos_mean);
                pos_mean += group[0].i;
            }

            if (ma < Infinity) {
                for (j = 0; j < group.length; j++) {
                    num += Math.abs(group[j].v) * group[j].i;
                    den += Math.abs(group[j].v);
                }
                pos_mean = num / den;
            }
            pos_mean += degree / 2;
            return [group[pos].i + degree / 2, pos_mean, t_values[Math.floor(pos_mean)] + h * (pos_mean - Math.floor(pos_mean))];
        },

        differenceMethod: function(component, curve) {
            var i, level, le, up,
                t_values = component.t_values,
                x_values = component.x_values,
                y_values = component.y_values,
                x_table = [],
                y_table = [],
                foundCriticalPoint = 0,
                degree_x = -1,
                degree_y = -1,
                pos, res, res_x, res_y, t_approx,
                groups = [],
                types,
                criticalPoints = [];

            le = y_values.length;
            // x_table.push([]);
            // y_table.push([]);
            // for (i = 0; i < le; i++) {
            //     x_table[0][i] = x_values[i];
            //     y_table[0][i] = y_values[i];
            // }
            x_table.push(new Float64Array(x_values));
            y_table.push(new Float64Array(y_values));

            le--;
            up = Math.min(12, le);
            for (level = 0; level < up; level++) {
                // Old style method:
                // x_table.push([]);
                // y_table.push([]);
                // for (i = 0; i < le; i++) {
                //     x_table[level + 1][i] = x_table[level][i + 1] - x_table[level][i];
                //     y_table[level + 1][i] = y_table[level][i + 1] - y_table[level][i];
                // }
                // New method:
                x_table.push(new Float64Array(le));
                y_table.push(new Float64Array(le));
                x_table[level + 1] = x_table[level].map(function(v, idx, arr) { return arr[idx + 1] - v;});
                y_table[level + 1] = y_table[level].map(function(v, idx, arr) { return arr[idx + 1] - v;});

                // Store point location which may be centered around critical points.
                // If the level is suitable, step out of the loop.
                res_y = this._criticalInterval(y_table[level + 1], le, level);
                if (res_y.smooth === true) {
                    // Its seems, the degree of the polynomial is equal to level
                    // If the values in level + 1 are zero, it might be a polynomial of degree level.
                    // Seems to work numerically stable until degree 6.
                    degree_y = level;
                    groups = [];
                }
                res_x = this._criticalInterval(x_table[level + 1], le, level);
                if (degree_x === -1 && res_x.smooth === true) {
                    // Its seems, the degree of the polynomial is equal to level
                    // If the values in level + 1 are zero, it might be a polynomial of degree level.
                    // Seems to work numerically stable until degree 6.
                    degree_x = level;
                }
                if (degree_y >= 0) {
                    break;
                }

                if (res_y.groups.length > 0) {
                    foundCriticalPoint++;
                    if (foundCriticalPoint > 2 && (level + 1) % 2 === 0) {
                        groups = res_y.groups;
                        types = res_y.types;
                        break;
                    }
                }
                le--;
            }

            // console.log("Last diffs", y_table[Math.min(level + 1, up)], "level", level + 1);
            // Analyze the groups which have been found.
            for (i = 0; i < groups.length; i++) {
                if (types[i] === 'interval') {
                    continue;
                }
                // console.log("Group", i, groups[i], types[i], level + 1)
                res = this.getCenterOfCriticalInterval(groups[i], level + 1, t_values);
                pos = res_y[0];
                pos = Math.floor(res[1]);
                t_approx = res[2];
                // console.log("Critical points:", groups, res, pos)

                // Analyze the type of the critical point
                // Result is of type 'borderleft', borderright', 'other'
                criticalPoints.push(this.getPointType(curve, pos, t_approx, t_values, x_table, y_table, le + 1));
            }

            // if (level === up) {
            //     console.log("No convergence!");
            // } else {
            //     console.log("Convergence level", level);
            // }
            return [criticalPoints, x_table, y_table, degree_x, degree_y];

        },

        _insertPoint_v4: function (curve, crds, t, doLog) {
            var p,
                prev = null,
                x, y,
                near = 0.8;

            if (curve.points.length > 0) {
                prev = curve.points[curve.points.length - 1].scrCoords;
            }

            // Add regular point
            p = new Coords(Const.COORDS_BY_USER, crds, curve.board);

            if (prev !== null) {
                x = p.scrCoords[1] - prev[1];
                y = p.scrCoords[2] - prev[2];
                if (x * x + y * y < near * near) {
                // Math.abs(p.scrCoords[1] - prev[1]) < near &&
                // Math.abs(p.scrCoords[2] - prev[2]) < near) {
                    return;
                }
            }

            p._t = t;
            curve.points.push(p);
        },

        getInterval: function(curve, ta, tb) {
            var t_int, x_int, y_int;

            //console.log('critical point', ta, tb);
            IntervalArithmetic.disable();

            t_int = IntervalArithmetic.Interval(ta, tb);
            curve.board.mathLib = IntervalArithmetic;
            curve.board.mathLibJXG = IntervalArithmetic;
            x_int = curve.X(t_int, true);
            y_int = curve.Y(t_int, true);
            curve.board.mathLib = Math;
            curve.board.mathLibJXG = JXG.Math;

            //console.log(x_int, y_int);
            return y_int;
        },

        sign: function (v) {
            if (v < 0) { return -1; }
            if (v > 0) { return 1; }
            return 0;
        },

        handleBorder: function(curve, comp, group, x_table, y_table) {
            var idx = group.idx,
                t, t1, t2,
                size = 32,
                y_int,
                x, y,
                lo, hi, i,
                components2, le, h;

            // console.log("HandleBorder at t =", t_approx);
            // console.log("component:", comp)
            // console.log("Group:", group);

            h = comp.t_values[1] - comp.t_values[0];
            if (group.type === 'borderleft') {
                t = comp.left_isNaN ? comp.left_t : group.t - h;
                t1 = t;
                t2 = t1 + h;
            } else if (group.type === 'borderright') {
                t = comp.right_isNaN ? comp.right_t : group.t + h;
                t2 = t;
                t1 = t2 - h;
            } else {
                console.log("No bordercase!!!");
            }

            components2 = this.findComponents(curve, t1, t2, size);
            if (components2.length === 0) {
                return;
            }
            if (group.type === 'borderleft') {
                t1 = components2[0].left_t;
                t2 = components2[0].t_values[0];
                h = components2[0].t_values[1] - components2[0].t_values[0];
                t1 = (t1 === null) ? t2- h : t1;
                t = t1;
                y_int = this.getInterval(curve, t1, t2);
                if (Type.isObject(y_int)) {
                    lo = y_int.lo;
                    hi = y_int.hi;

                    x = curve.X(t, true);
                    y = (y_table[1][idx] < 0) ? hi : lo;
                    this._insertPoint_v4(curve, [1, x, y], t);
                }
            }

            le = components2[0].t_values.length;
            for (i = 0; i < le; i++) {
                t = components2[0].t_values[i];
                x = components2[0].x_values[i];
                y = components2[0].y_values[i];
                this._insertPoint_v4(curve, [1, x, y], t);
            }

            if (group.type === 'borderright') {
                t1 = components2[0].t_values[le - 1];
                t2 = components2[0].right_t;
                h = components2[0].t_values[1] - components2[0].t_values[0];
                t2 = (t2 === null) ? t1 + h : t2;

                t = t2;
                y_int = this.getInterval(curve, t1, t2);
                if (Type.isObject(y_int)) {
                    lo = y_int.lo;
                    hi = y_int.hi;
                    x = curve.X(t, true);
                    y = (y_table[1][idx] > 0) ? hi : lo;
                    this._insertPoint_v4(curve, [1, x, y], t);
                }
            }

        },

        _seconditeration_v4: function(curve, comp, group, x_table, y_table) {
            var i, t1, t2, ret,
                components2, comp2, idx, groups2, g,
                x_table2, y_table2, start, le;

            // Look at two points, hopefully left and right from the critical point
            t1 = comp.t_values[group.idx - 2];
            t2 = comp.t_values[group.idx + 2];
            components2 = this.findComponents(curve, t1, t2, 64);
            for (idx = 0; idx < components2.length; idx++) {
                comp2 = components2[idx];
                ret = this.differenceMethod(comp2, curve);
                groups2 = ret[0];
                x_table2 = ret[1];
                y_table2 = ret[2];
                start = 0;
                for (g = 0; g <= groups2.length; g++) {
                    if (g === groups2.length) {
                        le = comp2.len;
                    } else {
                        le = groups2[g].idx;
                    }

                    // Insert all uncritical points until next critical point
                    for (i = start; i < le; i++) {
                        if (!isNaN(comp2.x_values[i]) && !isNaN(comp2.y_values[i])) {
                            this._insertPoint_v4(curve, [1, comp2.x_values[i], comp2.y_values[i]], comp2.t_values[i]);
                        }
                    }
                    // Handle next critical point
                    if (g < groups2.length) {
                        this.handleSingularity(curve, comp2, groups2[g], x_table2, y_table2);
                        start = groups2[g].idx + 1;
                    }
                }
                le = comp2.len;
                if (idx < components2.length - 1) {
                    this._insertPoint_v4(curve, [1, NaN, NaN], comp2.right_t);
                }
            }
            return this;
        },

        _recurse_v4: function(curve, t1, t2, x1, y1, x2, y2, level) {
            var tol = 2,
                t = (t1 + t2) * 0.5,
                x = curve.X(t, true),
                y = curve.Y(t, true),
                dx, dy;

            //console.log("Level", level)
            if (level === 0) {
                this._insertPoint_v4(curve, [1, NaN, NaN], t);
                return;
            }
            // console.log("R", t1, t2)
            dx = (x - x1) * curve.board.unitX;
            dy = (y - y1) * curve.board.unitY;
            // console.log("D1", Math.sqrt(dx * dx + dy * dy))
            if (Math.sqrt(dx * dx + dy * dy) > tol) {
                this._recurse_v4(curve, t1, t, x1, y1, x, y, level - 1);
            } else {
                this._insertPoint_v4(curve, [1, x, y], t);
            }
            dx = (x - x2) * curve.board.unitX;
            dy = (y - y2) * curve.board.unitY;
            // console.log("D2", Math.sqrt(dx * dx + dy * dy), x-x2, y-y2)
            if (Math.sqrt(dx * dx + dy * dy) > tol) {
                this._recurse_v4(curve, t, t2, x, y, x2, y2, level - 1);
            } else {
                this._insertPoint_v4(curve, [1, x, y], t);
            }
        },

        handleSingularity: function(curve, comp, group, x_table, y_table) {
            var idx = group.idx,
                t, t1, t2, y_int,
                i1, i2,
                x, y, lo, hi,
                d_lft, d_rgt,
                d_thresh = 100,
                di1 = 5,
                di2 = 3,
                d1, d2;

            t = group.t;
            console.log("HandleSingularity at t =", t);
            // console.log(comp.t_values[idx - 1], comp.y_values[idx - 1], comp.t_values[idx + 1], comp.y_values[idx + 1]);
            // console.log(group);

            // Look at two points, hopefully left and right from the critical point
            t1 = comp.t_values[idx - di1];
            t2 = comp.t_values[idx + di1];

            y_int = this.getInterval(curve, t1, t2);
            if (Type.isObject(y_int)) {
                lo = y_int.lo;
                hi = y_int.hi;
            } else {
                if (y_table[0][idx - 1] < y_table[0][idx + 1]) {
                    lo = y_table[0][idx - 1];
                    hi = y_table[0][idx + 1];
                } else {
                    lo = y_table[0][idx + 1];
                    hi = y_table[0][idx - 1];
                }
            }

            x = curve.X(t, true);

            d_lft = (y_table[0][idx - di2] - y_table[0][idx - di1]) / (comp.t_values[idx - di2] - comp.t_values[idx - di1]);
            d_rgt = (y_table[0][idx + di2] - y_table[0][idx + di1]) / (comp.t_values[idx + di2] - comp.t_values[idx + di1]);

            console.log(":::", d_lft, d_rgt);

            //this._insertPoint_v4(curve, [1, NaN, NaN], 0);

            if (d_lft < -d_thresh) {
                // Left branch very steep downwards -> add the minimum
                this._insertPoint_v4(curve, [1, x, lo], t, true);
                if (d_rgt <= d_thresh) {
                    // Right branch not very steep upwards -> interrupt the curve
                    // I.e. it looks like -infty / (finite or infty) and not like -infty / -infty
                    this._insertPoint_v4(curve, [1, NaN, NaN], t);
                }
            } else if (d_lft > d_thresh) {
                // Left branch very steep upwards -> add the maximum
                this._insertPoint_v4(curve, [1, x, hi], t);
                if (d_rgt >= -d_thresh) {
                    // Right branch not very steep downwards -> interrupt the curve
                    // I.e. it looks like infty / (finite or -infty) and not like infty / infty
                    this._insertPoint_v4(curve, [1, NaN, NaN], t);
                }
            } else {
                if (lo === -Infinity) {
                    this._insertPoint_v4(curve, [1, x, lo], t, true);
                    this._insertPoint_v4(curve, [1, NaN, NaN], t);
                }
                if (hi === Infinity) {
                    this._insertPoint_v4(curve, [1, NaN, NaN], t);
                    this._insertPoint_v4(curve, [1, x, hi], t, true);
                }

                if (group.t < comp.t_values[idx]) {
                    i1 = idx - 1;
                    i2 = idx;
                } else {
                    i1 = idx;
                    i2 = idx + 1;
                }
                t1 = comp.t_values[i1];
                t2 = comp.t_values[i2];
                this._recurse_v4(curve, t1, t2,
                        x_table[0][i1],
                        y_table[0][i1],
                        x_table[0][i2],
                        y_table[0][i2],
                        10
                    );

                // x = (x_table[0][idx] - x_table[0][idx - 1]) * curve.board.unitX;
                // y = (y_table[0][idx] - y_table[0][idx - 1]) * curve.board.unitY;
                // d1 = Math.sqrt(x * x + y * y);
                // x = (x_table[0][idx + 1] - x_table[0][idx]) * curve.board.unitX;
                // y = (y_table[0][idx + 1] - y_table[0][idx]) * curve.board.unitY;
                // d2 = Math.sqrt(x * x + y * y);

                // console.log("end", t1, t2, t);
                // if (true || (d1 > 2 || d2 > 2)) {

// console.log(d1, d2, y_table[0][idx])
//                     // Finite jump
//                     this._insertPoint_v4(curve, [1, NaN, NaN], t);
//                 } else {
//                     if (lo !== -Infinity && hi !== Infinity) {
//                         // Critical point which can be ignored
//                         this._insertPoint_v4(curve, [1, x_table[0][idx], y_table[0][idx]], comp.t_values[idx]);
//                     } else {
//                         if (lo === -Infinity) {
//                             this._insertPoint_v4(curve, [1, x, lo], t, true);
//                             this._insertPoint_v4(curve, [1, NaN, NaN], t);
//                         }
//                         if (hi === Infinity) {
//                             this._insertPoint_v4(curve, [1, NaN, NaN], t);
//                             this._insertPoint_v4(curve, [1, x, hi], t, true);
//                         }
//                     }
                // }
            }
            if (d_rgt < -d_thresh) {
                // Right branch very steep downwards -> add the maximum
                this._insertPoint_v4(curve, [1, x, hi], t);
            } else if (d_rgt > d_thresh) {
                // Right branch very steep upwards -> add the minimum
                this._insertPoint_v4(curve, [1, x, lo], t);
            }

        },

        /**
         * Number of equidistant points where the function is evaluated
         */
        steps: 1021, //2053, // 1021,

        /**
         * If the absolute maximum of the set of differences is larger than
         * criticalThreshold * median of these values, it is regarded as critical point.
         * @see JXG.Math.Plot#_criticalInterval
         */
        criticalThreshold: 1000,

        plot_v4: function(curve, ta, tb, steps) {
            var i, j, le, components, idx, comp,
                groups, g, start,
                ret, x_table, y_table,
                t, t1, t2,
                good, bad,
                x_int, y_int,
                degree_x, degree_y,
                h  = (tb - ta) / steps,
                Ypl = function(x) { return curve.Y(x, true); },
                Ymi = function(x) { return -curve.Y(x, true); },
                h2 = h * 0.5;

            components = this.findComponents(curve, ta, tb, steps);
            for (idx = 0; idx < components.length; idx++) {
                comp = components[idx];
                ret = this.differenceMethod(comp, curve);
                groups = ret[0];
                x_table = ret[1];
                y_table = ret[2];
                degree_x = ret[3];
                degree_y = ret[4];

                // if (degree_x >= 0) {
                //     console.log("x polynomial of degree", degree_x);
                // }
                // if (degree_y >= 0) {
                //     console.log("y polynomial of degree", degree_y);
                // }
                if (groups.length === 0 || groups[0].type !== 'borderleft') {
                    groups.unshift({
                        idx: 0,
                        t: comp.t_values[0],
                        x: comp.x_values[0],
                        y: comp.y_values[0],
                        type: 'borderleft'
                    });
                }
                if (groups[groups.length - 1].type !== 'borderright') {
                    le = comp.t_values.length;
                    groups.push({
                        idx: le - 1,
                        t: comp.t_values[le - 1],
                        x: comp.x_values[le - 1],
                        y: comp.y_values[le - 1],
                        type: 'borderright'
                    });
                }


                start = 0;
                for (g = 0; g <= groups.length; g++) {
                    if (g === groups.length) {
                        le = comp.len;
                    } else {
                        le = groups[g].idx - 1;
                    }

                    good = 0;
                    bad = 0;
                    // Insert all uncritical points until next critical point
                    for (i = start; i < le - 2; i++) {
                        this._insertPoint_v4(curve, [1, comp.x_values[i], comp.y_values[i]], comp.t_values[i]);
                        j = Math.max(0, i - 2);
                        // Add more points in critical intervals
                        if (true &&
                            //degree_y === -1 && // No polynomial
                            i >= start + 3 &&
                            i < le - 3 &&               // Do not do this if too close to a critical point
                            y_table.length > 3 &&
                            Math.abs(y_table[2][i]) > 0.2 * Math.abs(y_table[0][i])) {
                            t = comp.t_values[i];
                            h2 = h * 0.25;
                            y_int = this.getInterval(curve, t, t + h);
                            if (Type.isObject(y_int)) {
                                if (y_table[2][i] > 0) {
                                    this._insertPoint_v4(curve, [1, t + h2, y_int.lo], t + h2);
                                } else {
                                    this._insertPoint_v4(curve, [1, t + h - h2, y_int.hi], t + h - h2);
                                }
                            } else {
                                t1 = Numerics.fminbr(Ypl, [t, t + h]);
                                t2 = Numerics.fminbr(Ymi, [t, t + h]);
                                if (t1 < t2) {
                                    this._insertPoint_v4(curve, [1, curve.X(t1, true), curve.Y(t1, true)], t1);
                                    this._insertPoint_v4(curve, [1, curve.X(t2, true), curve.Y(t2, true)], t2);
                                } else {
                                    this._insertPoint_v4(curve, [1, curve.X(t2, true), curve.Y(t2, true)], t2);
                                    this._insertPoint_v4(curve, [1, curve.X(t1, true), curve.Y(t1, true)], t1);
                                }
                            }
                            bad++;
                        } else {
                            good++;
                        }
                    }
                    // console.log("GOOD", good, "BAD", bad);

                    // Handle next critical point
                    if (g < groups.length) {
                        //console.log("critical point / interval", groups[g]);

                        i = groups[g].idx;
                        if (groups[g].type === 'borderleft' || groups[g].type === 'borderright') {
                            this.handleBorder(curve, comp, groups[g], x_table, y_table);
                        } else {
                            this._seconditeration_v4(curve, comp, groups[g], x_table, y_table);
                        }

                        start = groups[g].idx + 1 + 1;
                    }
                }

                le = comp.len;
                if (idx < components.length - 1) {
                    this._insertPoint_v4(curve, [1, NaN, NaN], comp.right_t);
                }
            }


        },

        /**
         * Updates the data points of a parametric curve, plotVersion 4. This version is used if {@link JXG.Curve#plotVersion} is <tt>4</tt>.
         * @param {JXG.Curve} curve JSXGraph curve element
         * @param {Number} mi Left bound of curve
         * @param {Number} ma Right bound of curve
         * @returns {JXG.Curve} Reference to the curve object.
         */
        updateParametricCurve_v4: function (curve, mi, ma) {
            var ta, tb, w2, bbox;

            if (curve.xterm === 'x') {
                // For function graphs we can restrict the plot interval
                // to the visible area +plus margin
                bbox = curve.board.getBoundingBox();
                w2 = (bbox[2] - bbox[0]) * 0.3;
                // h2 = (bbox[1] - bbox[3]) * 0.3;
                ta = Math.max(mi, bbox[0] - w2);
                tb = Math.min(ma, bbox[2] + w2);
            } else {
                ta = mi;
                tb = ma;
            }

            curve.points = [];

            //console.log("--------------------");
            this.plot_v4(curve, ta, tb, this.steps);

            curve.numberPoints = curve.points.length;
            //console.log(curve.numberPoints);
        },

        //----------------------------------------------------------------------
        // Plot algorithm alias
        //----------------------------------------------------------------------

        /**
         * Updates the data points of a parametric curve, alias for {@link JXG.Curve#updateParametricCurve_v2}.
         * This is needed for backwards compatibility, if this method has been
         * used directly in an application.
         * @param {JXG.Curve} curve JSXGraph curve element
         * @param {Number} mi Left bound of curve
         * @param {Number} ma Right bound of curve
         * @returns {JXG.Curve} Reference to the curve object.
         *
         * @see JXG.Curve#updateParametricCurve_v2
         */
        updateParametricCurve: function (curve, mi, ma) {
            return this.updateParametricCurve_v2(curve, mi, ma);
        }
    };


    return Mat.Plot;
});

/*
    Copyright 2008-2022
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <http://www.gnu.org/licenses/>
    and <http://opensource.org/licenses/MIT/>.


    Metapost/Hobby curves, see e.g. https://bosker.wordpress.com/2013/11/13/beyond-bezier-curves/

    * Ported to Python for the project PyX. Copyright (C) 2011 Michael Schindler <m-schindler@users.sourceforge.net>
    * Ported to javascript from the PyX implementation (http://pyx.sourceforge.net/) by Vlad-X.
    * Adapted to JSXGraph and some code changes by Alfred Wassermann 2020.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    Internal functions of MetaPost
    This file re-implements some of the functionality of MetaPost
    (http://tug.org/metapost). MetaPost was developed by John D. Hobby and
    others. The code of Metapost is in the public domain, which we understand as
    an implicit permission to reuse the code here (see the comment at
    http://www.gnu.org/licenses/license-list.html)

    This file is based on the MetaPost version distributed by TeXLive:
    svn://tug.org/texlive/trunk/Build/source/texk/web2c/mplibdir revision 22737 #
    (2011-05-31)
*/

/*global JXG: true, define: true*/
/*jslint nomen: true, plusplus: true*/

/* depends:
 utils/type
 math/math
 */

/**
 * @fileoverview In this file the namespace Math.Metapost is defined which holds algorithms translated from Metapost
 * by D.E. Knuth and J.D. Hobby.
 */

define('math/metapost',['utils/type', 'math/math'], function (Type, Mat) {

    "use strict";

    /**
     * The JXG.Math.Metapost namespace holds algorithms translated from Metapost
     * by D.E. Knuth and J.D. Hobby.
     *
     * @name JXG.Math.Metapost
     * @exports Mat.Metapost as JXG.Math.Metapost
     * @namespace
     */
    Mat.Metapost = {
        MP_ENDPOINT: 0,
        MP_EXPLICIT: 1,
        MP_GIVEN: 2,
        MP_CURL: 3,
        MP_OPEN: 4,
        MP_END_CYCLE: 5,

        UNITY: 1.0,
        // two: 2,
        // fraction_half: 0.5,
        FRACTION_ONE: 1.0,
        FRACTION_THREE: 3.0,
        ONE_EIGHTY_DEG: Math.PI,
        THREE_SIXTY_DEG: 2 * Math.PI,
        // EPSILON: 1e-5,
        EPS_SQ: 1e-5 * 1e-5,

        /**
         * @private
         */
        make_choices: function (knots) {
            var dely, h, k, delx, n,
                q, p, s, cosine, t, sine,
                delta_x, delta_y, delta, psi;

            p = knots[0];
            do {
                if (!p) {
                    break;
                }
                q = p.next;

                // Join two identical knots by setting the control points to the same
                // coordinates.
                // MP 291
                if (p.rtype > this.MP_EXPLICIT &&
                    ((p.x - q.x) * (p.x - q.x)  + (p.y - q.y) * (p.y - q.y) < this.EPS_SQ)) {

                    p.rtype = this.MP_EXPLICIT;
                    if (p.ltype === this.MP_OPEN) {
                        p.ltype = this.MP_CURL;
                        p.set_left_curl(this.UNITY);
                    }

                    q.ltype = this.MP_EXPLICIT;
                    if (q.rtype === this.MP_OPEN) {
                        q.rtype = this.MP_CURL;
                        q.set_right_curl(this.UNITY);
                    }

                    p.rx = p.x;
                    q.lx = p.x;
                    p.ry = p.y;
                    q.ly = p.y;
                }
                p = q;
            } while (p !== knots[0]);

            // Find the first breakpoint, h, on the path
            // MP 292
            h = knots[0];
            while (true) {
                if (h.ltype !== this.MP_OPEN || h.rtype !== this.MP_OPEN) {
                    break;
                }
                h = h.next;
                if (h === knots[0]) {
                    h.ltype = this.MP_END_CYCLE;
                    break;
                }
            }

            p = h;
            while (true) {
                if (!p) {
                  break;
                }

                // Fill in the control points between p and the next breakpoint,
                // then advance p to that breakpoint
                // MP 299
                q = p.next;
                if (p.rtype >= this.MP_GIVEN) {
                    while (q.ltype === this.MP_OPEN && q.rtype === this.MP_OPEN) {
                        q = q.next;
                    }

                    // Calculate the turning angles psi_ k and the distances d_{k,k+1};
                    // set n to the length of the path
                    // MP 302
                    k = 0;
                    s = p;
                    n = knots.length;

                    delta_x = [];
                    delta_y = [];
                    delta = [];
                    psi = [null];

                    // tuple([]) = tuple([[], [], [], [null]]);
                    while (true) {
                        t = s.next;
                        // None;
                        delta_x.push(t.x - s.x);
                        delta_y.push(t.y - s.y);
                        delta.push( this.mp_pyth_add(delta_x[k], delta_y[k]) );
                        if (k > 0) {
                            sine =   delta_y[k - 1] / delta[k - 1];
                            cosine = delta_x[k - 1] / delta[k - 1];
                            psi.push(
                                Math.atan2(
                                    delta_y[k] * cosine - delta_x[k] * sine,
                                    delta_x[k] * cosine + delta_y[k] * sine
                                    )
                                );
                        }
                        k++;
                        s = t;
                        if (s === q) {
                            n = k;
                        }
                        if (k >= n && s.ltype !== this.MP_END_CYCLE) {
                            break;
                        }
                    }
                    if (k === n) {
                        psi.push(0);
                    } else {
                        psi.push(psi[1]);
                    }

                    // Remove open types at the breakpoints
                    // MP 303
                    if (q.ltype === this.MP_OPEN) {
                        delx = (q.rx - q.x);
                        dely = (q.ry - q.y);
                        if (delx * delx + dely * dely < this.EPS_SQ) {
                            q.ltype = this.MP_CURL;
                            q.set_left_curl(this.UNITY);
                        } else {
                            q.ltype = this.MP_GIVEN;
                            q.set_left_given(Math.atan2(dely, delx));
                        }
                    }
                    if (p.rtype === this.MP_OPEN && p.ltype === this.MP_EXPLICIT) {
                        delx = (p.x - p.lx);
                        dely = (p.y - p.ly);
                        if ( delx * delx + dely * dely  < this.EPS_SQ) {
                            p.rtype = this.MP_CURL;
                            p.set_right_curl(this.UNITY);
                        } else {
                            p.rtype = this.MP_GIVEN;
                            p.set_right_given(Math.atan2(dely, delx));
                        }
                    }
                    this.mp_solve_choices(p, q, n, delta_x, delta_y, delta, psi);
                } else if (p.rtype === this.MP_ENDPOINT) {
                    // MP 294
                    p.rx = p.x;
                    p.ry = p.y;
                    q.lx = q.x;
                    q.ly = q.y;
                }
                p = q;

                if (p === h) {
                    break;
                }
            }
        },

        /**
         * Implements solve_choices form metapost
         * MP 305
         * @private
         */
        mp_solve_choices: function (p, q, n, delta_x, delta_y, delta, psi) {
            var aa, acc, vv, bb, ldelta, ee, k, s,
                ww, uu, lt, r, t, ff, theta, rt, dd, cc,
                ct_st, ct, st, cf_sf, cf, sf, i,
                k_idx;

            ldelta = delta.length + 1;
            uu = new Array(ldelta);
            ww = new Array(ldelta);
            vv = new Array(ldelta);
            theta = new Array(ldelta);
            for (i = 0; i < ldelta; i++) {
                theta[i] = vv[i] = ww[i] = uu[i] = 0;
            }
            k = 0;
            s = p;
            r = 0;
            while (true) {
                t = s.next;
                if (k === 0) {
                    // MP 306
                    if (s.rtype === this.MP_GIVEN) {
                        // MP 314
                        if (t.ltype === this.MP_GIVEN) {
                            aa = Math.atan2(delta_y[0], delta_x[0]);
                            ct_st = this.mp_n_sin_cos(p.right_given() - aa);
                            ct = ct_st[0];
                            st = ct_st[1];
                            cf_sf = this.mp_n_sin_cos(q.left_given() - aa);
                            cf = cf_sf[0];
                            sf = cf_sf[1];
                            this.mp_set_controls(p, q, delta_x[0], delta_y[0], st, ct, -sf, cf);
                            return;
                        }
                        vv[0] = s.right_given() - Math.atan2(delta_y[0], delta_x[0]);
                        vv[0] = this.reduce_angle(vv[0]);
                        uu[0] = 0;
                        ww[0] = 0;

                    } else if (s.rtype === this.MP_CURL) {
                        // MP 315
                        if (t.ltype === this.MP_CURL) {
                            p.rtype = this.MP_EXPLICIT;
                            q.ltype = this.MP_EXPLICIT;
                            lt = Math.abs(q.left_tension());
                            rt = Math.abs(p.right_tension());
                            ff = this.UNITY / (3.0 * rt);
                            p.rx = p.x + delta_x[0] * ff;
                            p.ry = p.y + delta_y[0] * ff;
                            ff = this.UNITY / (3.0 * lt);
                            q.lx = q.x - delta_x[0] * ff;
                            q.ly = q.y - delta_y[0] * ff;
                            return;
                        }
                        cc = s.right_curl();
                        lt = Math.abs(t.left_tension());
                        rt = Math.abs(s.right_tension());
                        uu[0] = this.mp_curl_ratio(cc, rt, lt);
                        vv[0] = -psi[1] * uu[0];
                        ww[0] = 0;
                    } else {
                        if (s.rtype === this.MP_OPEN) {
                            uu[0] = 0;
                            vv[0] = 0;
                            ww[0] = this.FRACTION_ONE;
                        }
                    }
                } else {
                    if (s.ltype === this.MP_END_CYCLE || s.ltype === this.MP_OPEN) {
                        // MP 308
                        aa = this.UNITY / (3.0 * Math.abs(r.right_tension()) - this.UNITY);
                        dd = delta[k] * (this.FRACTION_THREE - this.UNITY / Math.abs(r.right_tension()));
                        bb = this.UNITY / (3 * Math.abs(t.left_tension()) - this.UNITY);
                        ee = delta[k - 1] * (this.FRACTION_THREE - this.UNITY / Math.abs(t.left_tension()));
                        cc = this.FRACTION_ONE - uu[k - 1] * aa;
                        dd = dd * cc;
                        lt = Math.abs(s.left_tension());
                        rt = Math.abs(s.right_tension());
                        if (lt < rt) {
                            dd *= Math.pow(lt / rt, 2);
                        } else {
                            if (lt > rt) {
                                ee *= Math.pow(rt / lt, 2);
                            }
                        }
                        ff = ee / (ee + dd);
                        uu[k] = ff * bb;
                        acc = -psi[k + 1] * uu[k];
                        if (r.rtype === this.MP_CURL) {
                            ww[k] = 0;
                            vv[k] = acc - psi[1] * (this.FRACTION_ONE - ff);
                        } else {
                            ff = (this.FRACTION_ONE - ff) / cc;
                            acc = acc - psi[k] * ff;
                            ff = ff * aa;
                            vv[k] = acc - vv[k - 1] * ff;
                            ww[k] = -ww[k - 1] * ff;
                        }
                        if (s.ltype === this.MP_END_CYCLE) {
                            aa = 0;
                            bb = this.FRACTION_ONE;
                            while (true) {
                                k -= 1;
                                if (k === 0) {
                                    k = n;
                                }
                                aa = vv[k] - aa * uu[k];
                                bb = ww[k] - bb * uu[k];
                                if (k === n) {
                                    break;
                                }
                            }
                            aa = aa / (this.FRACTION_ONE - bb);
                            theta[n] = aa;
                            vv[0] = aa;
                            // k_val = range(1, n);
                            // for (k_idx in k_val) {
                              // k = k_val[k_idx];
                            for (k_idx = 1; k_idx < n; k_idx++) {
                                vv[k_idx] = vv[k_idx] + aa * ww[k_idx];
                            }
                            break;
                        }
                    } else {
                        if (s.ltype === this.MP_CURL) {
                            cc = s.left_curl();
                            lt = Math.abs(s.left_tension());
                            rt = Math.abs(r.right_tension());
                            ff = this.mp_curl_ratio(cc, lt, rt);
                            theta[n] = -(vv[n - 1] * ff) / (this.FRACTION_ONE - ff * uu[n - 1]);
                            break;
                        }
                        if (s.ltype === this.MP_GIVEN) {
                            theta[n] = s.left_given() - Math.atan2(delta_y[n - 1], delta_x[n - 1]);
                            theta[n] = this.reduce_angle(theta[n]);
                            break;
                        }
                    }
                }
                r = s;
                s = t;
                k += 1;
            }

            // MP 318
            for (k = n-1; k > -1; k--) {
                theta[k] = vv[k] - theta[k + 1] * uu[k];
            }

            s = p;
            k = 0;
            while (true) {
                t = s.next;
                ct_st = this.mp_n_sin_cos(theta[k]);
                ct = ct_st[0];
                st = ct_st[1];
                cf_sf = this.mp_n_sin_cos((-(psi[k + 1]) - theta[k + 1]));
                cf = cf_sf[0];
                sf = cf_sf[1];
                this.mp_set_controls(s, t, delta_x[k], delta_y[k], st, ct, sf, cf);
                k++;
                s = t;
                if (k === n) {
                  break;
                }
            }
        },

        /**
         * @private
         */
        mp_n_sin_cos: function (z) {
            return [Math.cos(z), Math.sin(z)];
        },

        /**
         * @private
         */
        mp_set_controls: function (p, q, delta_x, delta_y, st, ct, sf, cf) {
            var rt, ss, lt, sine, rr;
            lt = Math.abs(q.left_tension());
            rt = Math.abs(p.right_tension());
            rr = this.mp_velocity(st, ct, sf, cf, rt);
            ss = this.mp_velocity(sf, cf, st, ct, lt);

            // console.log('lt rt rr ss', lt, rt, rr, ss);
            if (p.right_tension() < 0 || q.left_tension() < 0) {
                if ((st >= 0 && sf >= 0) || (st <= 0 && sf <= 0)) {
                    sine = Math.abs(st) * cf + Math.abs(sf) * ct;
                    if (sine > 0) {
                        sine *= 1.00024414062;
                        if (p.right_tension() < 0) {
                            if (this.mp_ab_vs_cd(Math.abs(sf), this.FRACTION_ONE, rr, sine) < 0) {
                                rr = Math.abs(sf) / sine;
                            }
                        }
                        if (q.left_tension() < 0) {
                            if (this.mp_ab_vs_cd(Math.abs(st), this.FRACTION_ONE, ss, sine) < 0) {
                                ss = Math.abs(st) / sine;
                            }
                        }
                    }
                }
            }
            p.rx = p.x + (delta_x * ct - delta_y * st) * rr;
            p.ry = p.y + (delta_y * ct + delta_x * st) * rr;
            q.lx = q.x - (delta_x * cf + delta_y * sf) * ss;
            q.ly = q.y - (delta_y * cf - delta_x * sf) * ss;
            p.rtype = this.MP_EXPLICIT;
            q.ltype = this.MP_EXPLICIT;
        },

        /**
         * @private
         */
        mp_pyth_add: function (a, b) {
            return Math.sqrt((a * a + b * b));
        },

        /**
         *
         * @private
         */
        mp_curl_ratio: function (gamma, a_tension, b_tension) {
            var alpha = 1.0 / a_tension,
                beta =  1.0 / b_tension;

            return Math.min (4.0,
                ((3.0 - alpha) * alpha * alpha * gamma + beta * beta * beta) /
                 (alpha * alpha * alpha * gamma + (3.0 - beta) * beta * beta)
                );
        },

        /**
         * @private
         */
        mp_ab_vs_cd: function (a, b, c, d) {
            if (a * b === c * d) {
                return 0;
            }
            if (a * b > c * d) {
                return 1;
            }
            return -1;
        },

        /**
         * @private
         */
        mp_velocity: function (st, ct, sf, cf, t) {
          return Math.min (4.0,
                (2.0 + Math.sqrt(2) * (st - sf / 16.0) * (sf - st / 16.0) * (ct - cf)) /
                (1.5 * t * ((2 + (Math.sqrt(5) - 1) * ct) + (3 - Math.sqrt(5)) * cf))
            );
        },

        /**
         * @private
         * @param {Number} A
         */
        reduce_angle: function (A) {
            if (Math.abs(A) > this.ONE_EIGHTY_DEG) {
                if (A > 0) {
                    A -= this.THREE_SIXTY_DEG;
                } else {
                    A += this.THREE_SIXTY_DEG;
                }
            }
            return A;
        },

        /**
         *
         * @private
         * @param {Array} p
         * @param {Number} tension
         * @param {Boolean} cycle
         */
        makeknots: function (p, tension, cycle) {
            var i, len,
                knots = [];

            tension = tension || 1;

            len = p.length;
            for (i = 0; i < len; i++) {
                knots.push({
                    x: p[i][0],
                    y: p[i][1],
                    ltype: this.MP_OPEN,
                    rtype: this.MP_OPEN,
                    ly: tension,
                    ry: tension,
                    lx: tension,
                    rx: tension,
                    left_curl: function() { return this.lx || 0; },
                    right_curl: function() { return this.rx || 0; },
                    left_tension: function() {
                            if (!this.ly) { this.ly = 1; }
                            return this.ly;
                        },
                    right_tension: function() {
                            if (!this.ry) { this.ry = 1; }
                            return this.ry;
                        },
                    set_right_curl: function(x) { this.rx = x || 0; },
                    set_left_curl: function(x) { this.lx = x || 0; }
                });
            }
            len = knots.length;
            for (i = 0; i < len; i++) {
                knots[i].next = knots[i+1] || knots[i];
                knots[i].set_right_given = knots[i].set_right_curl;
                knots[i].set_left_given = knots[i].set_left_curl;
                knots[i].right_given = knots[i].right_curl;
                knots[i].left_given = knots[i].left_curl;
            }
            knots[len - 1].next = knots[0];

            if (!cycle) {
                knots[len - 1].rtype = this.MP_ENDPOINT;

                knots[len - 1].ltype = this.MP_CURL;
                knots[0].rtype = this.MP_CURL;
            }

            return knots;
        },

        /**
         *
         * @param {Array} point_list
         * @param {Object} controls
         *
         * @returns {Array}
         */
        curve: function(point_list, controls) {
            var knots, len, i, val,
                x = [],
                y = [];

            controls = controls || {
                    tension: 1,
                    direction: {},
                    curl: {},
                    isClosed: false
                };

            knots = this.makeknots(point_list, Type.evaluate(controls.tension), controls.isClosed);

            len = knots.length;
            for (i in controls.direction) {
                if (controls.direction.hasOwnProperty(i)) {
                    val = Type.evaluate(controls.direction[i]);
                    if (Type.isArray(val)) {
                        if (val[0] !== false) {
                            knots[i].lx = val[0] * Math.PI / 180;
                            knots[i].ltype = this.MP_GIVEN;
                        }
                        if (val[1] !== false) {
                            knots[i].rx = val[1] * Math.PI / 180;
                            knots[i].rtype = this.MP_GIVEN;
                        }
                    } else {
                        knots[i].lx = val * Math.PI / 180;
                        knots[i].rx = val * Math.PI / 180;
                        knots[i].ltype = knots[i].rtype = this.MP_GIVEN;
                    }
                }
            }
            for (i in controls.curl) {
                if (controls.curl.hasOwnProperty(i)) {
                    val = Type.evaluate(controls.curl[i]);
                    if (parseInt(i, 10) === 0) {
                        knots[i].rtype = this.MP_CURL;
                        knots[i].set_right_curl(val);
                    } else if (parseInt(i, 10) === len - 1) {
                        knots[i].ltype = this.MP_CURL;
                        knots[i].set_left_curl(val);
                    }
                }
            }

            this.make_choices(knots);

            for (i = 0; i < len - 1; i++) {
                x.push(knots[i].x);
                x.push(knots[i].rx);
                x.push(knots[i + 1].lx);
                y.push(knots[i].y);
                y.push(knots[i].ry);
                y.push(knots[i + 1].ly);
            }
            x.push(knots[len - 1].x);
            y.push(knots[len - 1].y);

            if (controls.isClosed) {
                x.push(knots[len - 1].rx);
                y.push(knots[len - 1].ry);
                x.push(knots[0].lx);
                y.push(knots[0].ly);
                x.push(knots[0].x);
                y.push(knots[0].y);
            }

            return [x, y];
        }

    };

    return Mat.Metapost;
});

/*
    Copyright 2008-2022
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph and JSXCompressor.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.
    JSXCompressor is free software dual licensed under the GNU LGPL or Apache License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT
      OR
      * Apache License Version 2.0

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License, Apache
    License, and the MIT License along with JSXGraph. If not, see
    <http://www.gnu.org/licenses/>, <https://www.apache.org/licenses/LICENSE-2.0.html>,
    and <http://opensource.org/licenses/MIT/>.
 */


/*global JXG: true, define: true*/
/*jslint nomen: true, plusplus: true, bitwise: true*/

/* depends:
 jxg
 */

/**
 * @fileoverview Utilities for uncompressing and base64 decoding
 */

define('utils/zip',['jxg'], function (JXG) {

    "use strict";

    // Zip routine constants

    var bitReverse = [
            0x00, 0x80, 0x40, 0xc0, 0x20, 0xa0, 0x60, 0xe0,
            0x10, 0x90, 0x50, 0xd0, 0x30, 0xb0, 0x70, 0xf0,
            0x08, 0x88, 0x48, 0xc8, 0x28, 0xa8, 0x68, 0xe8,
            0x18, 0x98, 0x58, 0xd8, 0x38, 0xb8, 0x78, 0xf8,
            0x04, 0x84, 0x44, 0xc4, 0x24, 0xa4, 0x64, 0xe4,
            0x14, 0x94, 0x54, 0xd4, 0x34, 0xb4, 0x74, 0xf4,
            0x0c, 0x8c, 0x4c, 0xcc, 0x2c, 0xac, 0x6c, 0xec,
            0x1c, 0x9c, 0x5c, 0xdc, 0x3c, 0xbc, 0x7c, 0xfc,
            0x02, 0x82, 0x42, 0xc2, 0x22, 0xa2, 0x62, 0xe2,
            0x12, 0x92, 0x52, 0xd2, 0x32, 0xb2, 0x72, 0xf2,
            0x0a, 0x8a, 0x4a, 0xca, 0x2a, 0xaa, 0x6a, 0xea,
            0x1a, 0x9a, 0x5a, 0xda, 0x3a, 0xba, 0x7a, 0xfa,
            0x06, 0x86, 0x46, 0xc6, 0x26, 0xa6, 0x66, 0xe6,
            0x16, 0x96, 0x56, 0xd6, 0x36, 0xb6, 0x76, 0xf6,
            0x0e, 0x8e, 0x4e, 0xce, 0x2e, 0xae, 0x6e, 0xee,
            0x1e, 0x9e, 0x5e, 0xde, 0x3e, 0xbe, 0x7e, 0xfe,
            0x01, 0x81, 0x41, 0xc1, 0x21, 0xa1, 0x61, 0xe1,
            0x11, 0x91, 0x51, 0xd1, 0x31, 0xb1, 0x71, 0xf1,
            0x09, 0x89, 0x49, 0xc9, 0x29, 0xa9, 0x69, 0xe9,
            0x19, 0x99, 0x59, 0xd9, 0x39, 0xb9, 0x79, 0xf9,
            0x05, 0x85, 0x45, 0xc5, 0x25, 0xa5, 0x65, 0xe5,
            0x15, 0x95, 0x55, 0xd5, 0x35, 0xb5, 0x75, 0xf5,
            0x0d, 0x8d, 0x4d, 0xcd, 0x2d, 0xad, 0x6d, 0xed,
            0x1d, 0x9d, 0x5d, 0xdd, 0x3d, 0xbd, 0x7d, 0xfd,
            0x03, 0x83, 0x43, 0xc3, 0x23, 0xa3, 0x63, 0xe3,
            0x13, 0x93, 0x53, 0xd3, 0x33, 0xb3, 0x73, 0xf3,
            0x0b, 0x8b, 0x4b, 0xcb, 0x2b, 0xab, 0x6b, 0xeb,
            0x1b, 0x9b, 0x5b, 0xdb, 0x3b, 0xbb, 0x7b, 0xfb,
            0x07, 0x87, 0x47, 0xc7, 0x27, 0xa7, 0x67, 0xe7,
            0x17, 0x97, 0x57, 0xd7, 0x37, 0xb7, 0x77, 0xf7,
            0x0f, 0x8f, 0x4f, 0xcf, 0x2f, 0xaf, 0x6f, 0xef,
            0x1f, 0x9f, 0x5f, 0xdf, 0x3f, 0xbf, 0x7f, 0xff
        ],
        cplens = [
            3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31,
            35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 0, 0
        ],

        cplext = [
            0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2,
            3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0, 99, 99
        ], /* 99==invalid */

        cpdist = [
            0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0007, 0x0009, 0x000d,
            0x0011, 0x0019, 0x0021, 0x0031, 0x0041, 0x0061, 0x0081, 0x00c1,
            0x0101, 0x0181, 0x0201, 0x0301, 0x0401, 0x0601, 0x0801, 0x0c01,
            0x1001, 0x1801, 0x2001, 0x3001, 0x4001, 0x6001
        ],

        cpdext = [
            0,  0,  0,  0,  1,  1,  2,  2,
            3,  3,  4,  4,  5,  5,  6,  6,
            7,  7,  8,  8,  9,  9, 10, 10,
            11, 11, 12, 12, 13, 13
        ],

        border = [16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15],

        NAMEMAX = 256;


    // Util namespace
    JXG.Util = JXG.Util || {};

    /**
     * @class Unzip class
     * Class for gunzipping, unzipping and base64 decoding of files.
     * It is used for reading GEONExT, Geogebra and Intergeo files.
     *
     * Only Huffman codes are decoded in gunzip.
     * The code is based on the source code for gunzip.c by Pasi Ojala
     * @see http://www.cs.tut.fi/~albert/Dev/gunzip/gunzip.c
     * @see http://www.cs.tut.fi/~albert
     */
    JXG.Util.Unzip = function (barray) {
        var gpflags, crc, SIZE, fileout, flens, fmax,
            outputArr = [],
            output = '',
            debug = false,
            files = 0,
            unzipped = [],
            buf32k = new Array(32768),
            bIdx = 0,
            modeZIP = false,
            barraylen = barray.length,
            bytepos = 0,
            bitpos = 0,
            bb = 1,
            bits = 0,
            literalTree = new Array(288),
            distanceTree = new Array(32),
            treepos = 0,
            Places = null,
            Places2 = null,
            impDistanceTree = new Array(64),
            impLengthTree = new Array(64),
            len = 0,
            fpos = new Array(17),
            nameBuf = [];

        fpos[0] = 0;

        function readByte() {
            bits += 8;

            if (bytepos < barraylen) {
                return barray[bytepos++];
            }

            return -1;
        }

        function byteAlign() {
            bb = 1;
        }

        function readBit() {
            var carry;

            try {   // Prevent problems on iOS7 with >>
                bits++;
                carry = (bb & 1);
                bb >>= 1;

                if (bb === 0) {
                    bb = readByte();
                    carry = (bb & 1);
                    bb = (bb >> 1) | 0x80;
                }

                return carry;
            } catch (e) {
                throw e;
            }
        }

        function readBits(a) {
            var res = 0,
                i = a;

            // Prevent problems on iOS7 with >>
            try {
                while (i--) {
                    res = (res << 1) | readBit();
                }

                if (a) {
                    res = bitReverse[res] >> (8 - a);
                }
            } catch (e) {
                throw e;
            }

            return res;
        }

        function flushBuffer() {
            bIdx = 0;
        }

        function addBuffer(a) {
            SIZE++;
            buf32k[bIdx++] = a;
            outputArr.push(String.fromCharCode(a));

            if (bIdx === 0x8000) {
                bIdx = 0;
            }
        }

        function HufNode() {
            this.b0 = 0;
            this.b1 = 0;
            this.jump = null;
            this.jumppos = -1;
        }

        function isPat() {
            while (true) {
                if (fpos[len] >= fmax) {
                    return -1;
                }

                if (flens[fpos[len]] === len) {
                    return fpos[len]++;
                }

                fpos[len]++;
            }
        }

        function rec() {
            var curplace = Places[treepos],
                tmp;

            if (len === 17) {
                return -1;
            }
            treepos++;
            len++;

            tmp = isPat();

            if (tmp >= 0) {
                /* leaf cell for 0-bit */
                curplace.b0 = tmp;
            } else {
                /* Not a Leaf cell */
                curplace.b0 = 0x8000;

                if (rec()) {
                    return -1;
                }
            }

            tmp = isPat();

            if (tmp >= 0) {
                /* leaf cell for 1-bit */
                curplace.b1 = tmp;
                /* Just for the display routine */
                curplace.jump = null;
            } else {
                /* Not a Leaf cell */
                curplace.b1 = 0x8000;
                curplace.jump = Places[treepos];
                curplace.jumppos = treepos;
                if (rec()) {
                    return -1;
                }
            }
            len--;

            return 0;
        }

        function createTree(currentTree, numval, lengths, show) {
            var i;

            Places = currentTree;
            treepos = 0;
            flens = lengths;
            fmax  = numval;

            for (i = 0; i < 17; i++) {
                fpos[i] = 0;
            }
            len = 0;

            if (rec()) {
                return -1;
            }

            return 0;
        }

        function decodeValue(currentTree) {
            var len, i, b,
                xtreepos = 0,
                X = currentTree[xtreepos];

            /* decode one symbol of the data */
            while (true) {
                b = readBit();

                if (b) {
                    if (!(X.b1 & 0x8000)) {
                        /* If leaf node, return data */
                        return X.b1;
                    }

                    X = X.jump;
                    len = currentTree.length;

                    for (i = 0; i < len; i++) {
                        if (currentTree[i] === X) {
                            xtreepos = i;
                            break;
                        }
                    }
                } else {
                    if (!(X.b0 & 0x8000)) {
                        /* If leaf node, return data */
                        return X.b0;
                    }
                    xtreepos++;
                    X = currentTree[xtreepos];
                }
            }
        }

        function deflateLoop() {
            var last, c, type, i, j, l, ll, ll2, len, blockLen, dist, cSum,
                n, literalCodes, distCodes, lenCodes, z;

            do {
                last = readBit();
                type = readBits(2);

                if (type === 0) {
                    // Stored
                    byteAlign();
                    blockLen = readByte();
                    blockLen |= (readByte() << 8);

                    cSum = readByte();
                    cSum |= (readByte() << 8);

                    if (((blockLen ^ ~cSum) & 0xffff)) {
                        JXG.debug('BlockLen checksum mismatch\n');
                    }

                    while (blockLen--) {
                        c = readByte();
                        addBuffer(c);
                    }
                } else if (type === 1) {
                    /* Fixed Huffman tables -- fixed decode routine */
                    while (true) {
                        /*
                         256    0000000        0
                         :   :     :
                         279    0010111        23
                         0   00110000    48
                         :    :      :
                         143    10111111    191
                         280 11000000    192
                         :    :      :
                         287 11000111    199
                         144    110010000    400
                         :    :       :
                         255    111111111    511

                         Note the bit order!
                         */

                        j = (bitReverse[readBits(7)] >> 1);

                        if (j > 23) {
                            j = (j << 1) | readBit();    /* 48..255 */

                            if (j > 199) {    /* 200..255 */
                                j -= 128;    /*  72..127 */
                                j = (j << 1) | readBit();        /* 144..255 << */
                            } else {        /*  48..199 */
                                j -= 48;    /*   0..151 */
                                if (j > 143) {
                                    j = j + 136;    /* 280..287 << */
                                    /*   0..143 << */
                                }
                            }
                        } else {    /*   0..23 */
                            j += 256;    /* 256..279 << */
                        }

                        if (j < 256) {
                            addBuffer(j);
                        } else if (j === 256) {
                            /* EOF */
                            break;
                        } else {
                            j -= 256 + 1;    /* bytes + EOF */
                            len = readBits(cplext[j]) + cplens[j];
                            j = bitReverse[readBits(5)] >> 3;

                            if (cpdext[j] > 8) {
                                dist = readBits(8);
                                dist |= (readBits(cpdext[j] - 8) << 8);
                            } else {
                                dist = readBits(cpdext[j]);
                            }

                            dist += cpdist[j];

                            for (j = 0; j < len; j++) {
                                c = buf32k[(bIdx - dist) & 0x7fff];
                                addBuffer(c);
                            }
                        }
                    } // while
                } else if (type === 2) {
                    // "static" just to preserve stack
                    ll = new Array(288 + 32);

                    // Dynamic Huffman tables
                    literalCodes = 257 + readBits(5);
                    distCodes = 1 + readBits(5);
                    lenCodes = 4 + readBits(4);

                    for (j = 0; j < 19; j++) {
                        ll[j] = 0;
                    }

                    // Get the decode tree code lengths

                    for (j = 0; j < lenCodes; j++) {
                        ll[border[j]] = readBits(3);
                    }
                    len = distanceTree.length;

                    for (i = 0; i < len; i++) {
                        distanceTree[i] = new HufNode();
                    }

                    if (createTree(distanceTree, 19, ll, 0)) {
                        flushBuffer();
                        return 1;
                    }

                    //read in literal and distance code lengths
                    n = literalCodes + distCodes;
                    i = 0;
                    z = -1;

                    while (i < n) {
                        z++;
                        j = decodeValue(distanceTree);

                        // length of code in bits (0..15)
                        if (j < 16) {
                            ll[i++] = j;
                        // repeat last length 3 to 6 times
                        } else if (j === 16) {
                            j = 3 + readBits(2);

                            if (i + j > n) {
                                flushBuffer();
                                return 1;
                            }
                            l = i ? ll[i - 1] : 0;

                            while (j--) {
                                ll[i++] = l;
                            }
                        } else {
                            // 3 to 10 zero length codes
                            if (j === 17) {
                                j = 3 + readBits(3);
                            // j == 18: 11 to 138 zero length codes
                            } else {
                                j = 11 + readBits(7);
                            }

                            if (i + j > n) {
                                flushBuffer();
                                return 1;
                            }

                            while (j--) {
                                ll[i++] = 0;
                            }
                        }
                    }

                    // Can overwrite tree decode tree as it is not used anymore
                    len = literalTree.length;
                    for (i = 0; i < len; i++) {
                        literalTree[i] = new HufNode();
                    }

                    if (createTree(literalTree, literalCodes, ll, 0)) {
                        flushBuffer();
                        return 1;
                    }

                    len = literalTree.length;

                    for (i = 0; i < len; i++) {
                        distanceTree[i] = new HufNode();
                    }

                    ll2 = [];

                    for (i = literalCodes; i < ll.length; i++) {
                        ll2[i - literalCodes] = ll[i];
                    }

                    if (createTree(distanceTree, distCodes, ll2, 0)) {
                        flushBuffer();
                        return 1;
                    }

                    while (true) {
                        j = decodeValue(literalTree);

                        // In C64: if carry set
                        if (j >= 256) {
                            j -= 256;
                            if (j === 0) {
                                // EOF
                                break;
                            }

                            j -= 1;
                            len = readBits(cplext[j]) + cplens[j];
                            j = decodeValue(distanceTree);

                            if (cpdext[j] > 8) {
                                dist = readBits(8);
                                dist |= (readBits(cpdext[j] - 8) << 8);
                            } else {
                                dist = readBits(cpdext[j]);
                            }

                            dist += cpdist[j];

                            while (len--) {
                                c = buf32k[(bIdx - dist) & 0x7fff];
                                addBuffer(c);
                            }
                        } else {
                            addBuffer(j);
                        }
                    }
                }
            } while (!last);

            flushBuffer();
            byteAlign();

            return 0;
        }


        /**
         * nextFile:
         * Extract the next file from the compressed archive.
         * Calls skipdir() to proceed recursively.
         *
         * @return {Boolean}  false if the end of files' data section has baseElement
         * reached. Then, then all recursive functions are stopped immediately.
         *
         */
        function nextFile() {
            var i, c, extralen, filelen, size, compSize, crc, method,
                tmp = [];

            // Prevent problems on iOS7 with >>
            try {
                outputArr = [];
                modeZIP = false;
                tmp[0] = readByte();
                tmp[1] = readByte();

                //GZIP
                if (tmp[0] === 0x78 && tmp[1] === 0xda) {
                    deflateLoop();
                    unzipped[files] = [outputArr.join(''), 'geonext.gxt'];
                    files++;
                }

                //GZIP
                if (tmp[0] === 0x1f && tmp[1] === 0x8b) {
                    skipdir();
                    unzipped[files] = [outputArr.join(''), 'file'];
                    files++;
                }

                //ZIP
                if (tmp[0] === 0x50 && tmp[1] === 0x4b) {
                    modeZIP = true;
                    tmp[2] = readByte();
                    tmp[3] = readByte();

                    if (tmp[2] === 0x03 && tmp[3] === 0x04) {
                        //MODE_ZIP
                        tmp[0] = readByte();
                        tmp[1] = readByte();

                        gpflags = readByte();
                        gpflags |= (readByte() << 8);

                        method = readByte();
                        method |= (readByte() << 8);

                        readByte();
                        readByte();
                        readByte();
                        readByte();

                        crc = readByte();
                        crc |= (readByte() << 8);
                        crc |= (readByte() << 16);
                        crc |= (readByte() << 24);

                        compSize = readByte();
                        compSize |= (readByte() << 8);
                        compSize |= (readByte() << 16);
                        compSize |= (readByte() << 24);

                        size = readByte();
                        size |= (readByte() << 8);
                        size |= (readByte() << 16);
                        size |= (readByte() << 24);

                        filelen = readByte();
                        filelen |= (readByte() << 8);

                        extralen = readByte();
                        extralen |= (readByte() << 8);

                        i = 0;
                        nameBuf = [];

                        while (filelen--) {
                            c = readByte();
                            if (c === '/' | c === ':') {
                                i = 0;
                            } else if (i < NAMEMAX - 1) {
                                nameBuf[i++] = String.fromCharCode(c);
                            }
                        }

                        if (!fileout) {
                            fileout = nameBuf;
                        }

                        i = 0;
                        while (i < extralen) {
                            c = readByte();
                            i++;
                        }

                        SIZE = 0;
                        if (method === 8) {
                            deflateLoop();
                            unzipped[files] = new Array(2);
                            unzipped[files][0] = outputArr.join('');
                            unzipped[files][1] = nameBuf.join('');
                            files++;
                        }

                        if (skipdir()) {
                            // We are beyond the files' data in the zip archive.
                            // Let's get out immediately...
                            return false;
                        }
                    }
                    return true;
                }
            } catch (e) {
                throw e;
            }
            return false;
        }


        /**
         * Test if the end of the files' data part of the archive has baseElement
         * reached. If not, uncompressing is resumed.
         *
         * @return {Boolean}  true if the end of the files' data sections have
         * been reached.
         *
         * @private
         */
        function skipdir() {
            var crc, compSize, size, os, i, c,
                tmp = [];

            if ((gpflags & 8)) {
                tmp[0] = readByte();
                tmp[1] = readByte();
                tmp[2] = readByte();
                tmp[3] = readByte();

                // signature for data descriptor record: 0x08074b50
                // 12 bytes:
                //  crc 4 bytes
                //  compressed size 4 bytes
                // uncompressed size 4 bytes
                if (tmp[0] === 0x50 &&
                        tmp[1] === 0x4b &&
                        tmp[2] === 0x07 &&
                        tmp[3] === 0x08) {
                    crc = readByte();
                    crc |= (readByte() << 8);
                    crc |= (readByte() << 16);
                    crc |= (readByte() << 24);
                } else {
                    crc = tmp[0] | (tmp[1] << 8) | (tmp[2] << 16) | (tmp[3] << 24);
                }

                compSize = readByte();
                compSize |= (readByte() << 8);
                compSize |= (readByte() << 16);
                compSize |= (readByte() << 24);

                size = readByte();
                size |= (readByte() << 8);
                size |= (readByte() << 16);
                size |= (readByte() << 24);
            }

            if (modeZIP) {
                if (nextFile()) {
                    // A file has been decompressed, we have to proceed
                    return false;
                }
            }

            tmp[0] = readByte();
            if (tmp[0] !== 8) {
                // It seems, we are beyond the files' data in the zip archive.
                // We'll skip the rest..
                return true;
            }

            // There is another file in the zip file. We proceed...
            gpflags = readByte();

            readByte();
            readByte();
            readByte();
            readByte();

            readByte();
            os = readByte();

            if ((gpflags & 4)) {
                tmp[0] = readByte();
                tmp[2] = readByte();
                len = tmp[0] + 256 * tmp[1];
                for (i = 0; i < len; i++) {
                    readByte();
                }
            }

            if ((gpflags & 8)) {
                i = 0;
                nameBuf = [];

                c = readByte();
                while (c) {
                    if (c === '7' || c === ':') {
                        i = 0;
                    }

                    if (i < NAMEMAX - 1) {
                        nameBuf[i++] = c;
                    }

                    c = readByte();
                }
            }

            if ((gpflags & 16)) {
                c = readByte();
                while (c) {
                    c = readByte();
                }
            }

            if ((gpflags & 2)) {
                readByte();
                readByte();
            }

            deflateLoop();

            crc = readByte();
            crc |= (readByte() << 8);
            crc |= (readByte() << 16);
            crc |= (readByte() << 24);

            size = readByte();
            size |= (readByte() << 8);
            size |= (readByte() << 16);
            size |= (readByte() << 24);

            if (modeZIP) {
                if (nextFile()) {
                    // A file has been decompressed, we have to proceed
                    return false;
                }
            }

            // We are here in non-ZIP-files only,
            // In that case the eturn value doesn't matter
            return false;
        }

        JXG.Util.Unzip.prototype.unzipFile = function (name) {
            var i;

            this.unzip();

            for (i = 0; i < unzipped.length; i++) {
                if (unzipped[i][1] === name) {
                    return unzipped[i][0];
                }
            }

            return '';
        };

        JXG.Util.Unzip.prototype.unzip = function () {
            nextFile();
            return unzipped;
        };
    };

    return JXG.Util;
});

/*global JXG: true, define: true, escape: true, unescape: true*/
/*jslint nomen: true, plusplus: true, bitwise: true*/

/* depends:
 jxg
 */

define('utils/encoding',['jxg'], function (JXG) {

    "use strict";

    // constants
    var UTF8_ACCEPT = 0,
        UTF8_REJECT = 12,
        UTF8D = [
            // The first part of the table maps bytes to character classes that
            // to reduce the size of the transition table and create bitmasks.
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,   9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
            7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,   7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
            8, 8, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,   2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
            10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3,  11, 6, 6, 6, 5, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,

            // The second part is a transition table that maps a combination
            // of a state of the automaton and a character class to a state.
            0, 12, 24, 36, 60, 96, 84, 12, 12, 12, 48, 72,  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
            12,  0, 12, 12, 12, 12, 12,  0, 12,  0, 12, 12,  12, 24, 12, 12, 12, 12, 12, 24, 12, 24, 12, 12,
            12, 12, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12,  12, 24, 12, 12, 12, 12, 12, 12, 12, 24, 12, 12,
            12, 12, 12, 12, 12, 12, 12, 36, 12, 36, 12, 12,  12, 36, 12, 12, 12, 12, 12, 36, 12, 36, 12, 12,
            12, 36, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12
        ];

    // Util namespace
    JXG.Util = JXG.Util || {};

    /**
     * UTF8 encoding routines
     * @namespace
     */
    JXG.Util.UTF8 = {
        /**
         * Encode a string to utf-8.
         * @param {String} string
         * @returns {String} utf8 encoded string
         */
        encode : function (string) {
            var n, c,
                utftext = '',
                len = string.length;

            string = string.replace(/\r\n/g, '\n');

            // See
            // http://ecmanaut.blogspot.ca/2006/07/encoding-decoding-utf8-in-javascript.html
            // http://monsur.hossa.in/2012/07/20/utf-8-in-javascript.html
            if (typeof unescape === 'function' && typeof encodeURIComponent === 'function') {
                return unescape(encodeURIComponent(string));
            }

            for (n = 0; n < len; n++) {
                c = string.charCodeAt(n);

                if (c < 128) {
                    utftext += String.fromCharCode(c);
                } else if ((c > 127) && (c < 2048)) {
                    utftext += String.fromCharCode((c >> 6) | 192);
                    utftext += String.fromCharCode((c & 63) | 128);
                } else {
                    utftext += String.fromCharCode((c >> 12) | 224);
                    utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                    utftext += String.fromCharCode((c & 63) | 128);
                }

            }

            return utftext;
        },

        /**
         * Decode a string from utf-8.
         * @param {String} utftext to decode
         * @returns {String} utf8 decoded string
         */
        decode : function (utftext) {
            /*
                 The following code is a translation from C99 to JavaScript.

                 The original C99 code can be found at
                 http://bjoern.hoehrmann.de/utf-8/decoder/dfa/

                 Original copyright note:

                 Copyright (c) 2008-2009 Bjoern Hoehrmann <bjoern@hoehrmann.de>

                 License: MIT License (see LICENSE.MIT)
            */

            var i, charCode, type,
                j = 0,
                codepoint = 0,
                state = UTF8_ACCEPT,
                chars = [],
                len = utftext.length,
                results = [];

            for (i = 0; i < len; i++) {
                charCode = utftext.charCodeAt(i);
                type = UTF8D[charCode];

                if (state !== UTF8_ACCEPT) {
                    codepoint = (charCode & 0x3f) | (codepoint << 6);
                } else {
                    codepoint = (0xff >> type) & charCode;
                }

                state = UTF8D[256 + state + type];

                if (state === UTF8_ACCEPT) {
                    if (codepoint > 0xffff) {
                        chars.push(0xD7C0 + (codepoint >> 10), 0xDC00 + (codepoint & 0x3FF));
                    } else {
                        chars.push(codepoint);
                    }

                    j++;

                    if (j % 10000 === 0) {
                        results.push(String.fromCharCode.apply(null, chars));
                        chars = [];
                    }
                }
            }
            results.push(String.fromCharCode.apply(null, chars));
            return results.join("");
        },

        /**
         * Extends the standard charCodeAt() method of the String class to find the ASCII char code of
         * a character at a given position in a UTF8 encoded string.
         * @param {String} str
         * @param {Number} i position of the character
         * @returns {Number}
         */
        asciiCharCodeAt: function (str, i) {
            var c = str.charCodeAt(i);

            if (c > 255) {
                switch (c) {
                case 8364:
                    c = 128;
                    break;
                case 8218:
                    c = 130;
                    break;
                case 402:
                    c = 131;
                    break;
                case 8222:
                    c = 132;
                    break;
                case 8230:
                    c = 133;
                    break;
                case 8224:
                    c = 134;
                    break;
                case 8225:
                    c = 135;
                    break;
                case 710:
                    c = 136;
                    break;
                case 8240:
                    c = 137;
                    break;
                case 352:
                    c = 138;
                    break;
                case 8249:
                    c = 139;
                    break;
                case 338:
                    c = 140;
                    break;
                case 381:
                    c = 142;
                    break;
                case 8216:
                    c = 145;
                    break;
                case 8217:
                    c = 146;
                    break;
                case 8220:
                    c = 147;
                    break;
                case 8221:
                    c = 148;
                    break;
                case 8226:
                    c = 149;
                    break;
                case 8211:
                    c = 150;
                    break;
                case 8212:
                    c = 151;
                    break;
                case 732:
                    c = 152;
                    break;
                case 8482:
                    c = 153;
                    break;
                case 353:
                    c = 154;
                    break;
                case 8250:
                    c = 155;
                    break;
                case 339:
                    c = 156;
                    break;
                case 382:
                    c = 158;
                    break;
                case 376:
                    c = 159;
                    break;
                default:
                    break;
                }
            }
            return c;
        }
    };

    return JXG.Util.UTF8;
});

/*
    Copyright 2008-2022
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <http://www.gnu.org/licenses/>
    and <http://opensource.org/licenses/MIT/>.
 */


/*global JXG: true, define: true*/
/*jslint nomen: true, plusplus: true, bitwise: true*/

/* depends:
 jxg
 utils/encoding
 */

define('utils/base64',['jxg', 'utils/encoding'], function (JXG, Encoding) {

    "use strict";

    var alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/',
        pad = '=';

    // Util namespace
    JXG.Util = JXG.Util || {};

    // Local helper functions
    /**
     * Extracts one byte from a string and ensures the result is less than or equal to 255.
     * @param {String} s
     * @param {Number} i
     * @returns {Number} <= 255
     * @private
     */
    function _getByte(s, i) {
        return s.charCodeAt(i) & 0xff;
    }

    /**
     * Determines the index of a base64 character in the base64 alphabet.
     * @param {String} s
     * @param {Number} i
     * @returns {Number}
     * @throws {Error} If the character can not be found in the alphabet.
     * @private
     */
    function _getIndex(s, i) {
        return alphabet.indexOf(s.charAt(i));
    }

    /**
     * Base64 routines
     * @namespace
     */
    JXG.Util.Base64 = {
        /**
         * Encode the given string.
         * @param {String} input
         * @returns {string} base64 encoded version of the input string.
         */
        encode : function (input) {
            var i, bin, len, padLen, encInput,
                buffer = [];

            encInput =  Encoding.encode(input);
            len = encInput.length;
            padLen = len % 3;

            for (i = 0; i < len - padLen; i += 3) {
                bin = (_getByte(encInput, i) << 16) | (_getByte(encInput, i + 1) << 8) | (_getByte(encInput, i + 2));
                buffer.push(
                    alphabet.charAt(bin >> 18),
                    alphabet.charAt((bin >> 12) & 63),
                    alphabet.charAt((bin >> 6) & 63),
                    alphabet.charAt(bin & 63)
                );
            }

            switch (padLen) {
            case 1:
                bin = _getByte(encInput, len - 1);
                buffer.push(alphabet.charAt(bin >> 2), alphabet.charAt((bin << 4) & 63), pad, pad);
                break;
            case 2:
                bin = (_getByte(encInput, len - 2) << 8) | _getByte(encInput, len - 1);
                buffer.push(
                    alphabet.charAt(bin >> 10),
                    alphabet.charAt((bin >> 4) & 63),
                    alphabet.charAt((bin << 2) & 63),
                    pad
                );
                break;
            }

            return buffer.join('');
        },

        /**
         * Decode from Base64
         * @param {String} input Base64 encoded data
         * @param {Boolean} utf8 In case this parameter is true {@link JXG.Util.UTF8.decode} will be applied to
         * the result of the base64 decoder.
         * @throws {Error} If the string has the wrong length.
         * @returns {String}
         */
        decode : function (input, utf8) {
            var encInput, i, len, padLen, bin, output,
                result = [],
                buffer = [];

            // deactivate regexp linting. Our regex is secure, because we replace everything with ''
            /*jslint regexp:true*/
            encInput = input.replace(/[^A-Za-z0-9+/=]/g, '');
            /*jslint regexp:false*/

            len = encInput.length;

            if (len % 4 !== 0) {
                throw new Error('JSXGraph/utils/base64: Can\'t decode string (invalid input length).');
            }

            if (encInput.charAt(len - 1) === pad) {
                padLen = 1;

                if (encInput.charAt(len - 2) === pad) {
                    padLen = 2;
                }

                // omit the last four bytes (taken care of after the for loop)
                len -= 4;
            }

            for (i = 0; i < len; i += 4) {
                bin = (_getIndex(encInput, i) << 18) | (_getIndex(encInput, i + 1) << 12) | (_getIndex(encInput, i + 2) << 6) | _getIndex(encInput, i + 3);
                buffer.push(bin >> 16, (bin >> 8) & 255, bin & 255);

                // flush the buffer, if it gets too big fromCharCode will crash
                if (i % 10000 === 0) {
                    result.push(String.fromCharCode.apply(null, buffer));
                    buffer = [];
                }
            }

            switch (padLen) {
            case 1:
                bin = (_getIndex(encInput, len) << 12) | (_getIndex(encInput, len + 1) << 6) | (_getIndex(encInput, len + 2));
                buffer.push(bin >> 10, (bin >> 2) & 255);
                break;

            case 2:
                bin = (_getIndex(encInput, i) << 6) | (_getIndex(encInput, i + 1));
                buffer.push(bin >> 4);
                break;
            }

            result.push(String.fromCharCode.apply(null, buffer));
            output = result.join('');

            if (utf8) {
                output = Encoding.decode(output);
            }

            return output;
        },

        /**
         * Decode the base64 input data as an array
         * @param {string} input
         * @returns {Array}
         */
        decodeAsArray: function (input) {
            var i,
                dec = this.decode(input),
                ar = [],
                len = dec.length;

            for (i = 0; i < len; i++) {
                ar[i] = dec.charCodeAt(i);
            }

            return ar;
        }
    };

    return JXG.Util.Base64;
});

/*
    Copyright 2008-2022
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.
    
    You can redistribute it and/or modify it under the terms of the
    
      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT
    
    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.
    
    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <http://www.gnu.org/licenses/>
    and <http://opensource.org/licenses/MIT/>.
 */


/*global JXG: true, define: true, escape:true, window:true, ActiveXObject:true, XMLHttpRequest:true*/
/*jslint nomen: true, plusplus: true*/

/* depends:
 jxg
 utils/zip
 utils/base64
 utils/type
 */

/**
 * @fileoverview The JXG.Server is a wrapper for a smoother integration of server side calculations. on the
 * server side a python plugin system is used.
 */

define('server/server',[
    'jxg', 'utils/zip', 'utils/base64', 'utils/type'
], function (JXG, Zip, Base64, Type) {

    "use strict";

    /**
     * @namespace
     * JXG.Server namespace holding functions to load JXG server modules.
     */
    JXG.Server = {
        /**
         * This is where all of a module's handlers are accessed from. If you're loading a module named JXGModule which
         * provides a handler called ImaHandler, then this handler can be called by invoking JXG.Server.modules.JXGModule.ImaHandler().
         * @namespace
         */
        modules: {},

        /**
         * Stores all asynchronous calls to server which aren't finished yet.
         * @private
         */
        runningCalls: {},

        /**
         * Handles errors, just a default implementation, can be overwritten by you, if you want to handle errors by yourself.
         * @param {object} data An object holding a field of type string named message handling the error described in the message string.
         */
        handleError: function (data) {
            JXG.debug('error occured, server says: ' + data.message);
        },

        /**
         * The main method of JXG.Server. Actually makes the calls to the server and parses the feedback.
         * @param {String} action Can be 'load' or 'exec'.
         * @param {function} callback Function pointer or anonymous function which takes as it's only argument an
         * object containing the data from the server. The fields of this object depend on the reply of the server
         * module. See the correspondings server module readme.
         * @param {Object} data What is to be sent to the server.
         * @param {Boolean} sync If the call should be synchronous or not.
         */
        callServer: function (action, callback, data, sync) {
            var fileurl, passdata, AJAX,
                params, id, dataJSONStr,
                k;

            sync = sync || false;

            params = '';
            for (k in data) {
                if (data.hasOwnProperty(k)) {
                    params += '&' + escape(k) + '=' + escape(data[k]);
                }
            }

            dataJSONStr = Type.toJSON(data);

            // generate id
            do {
                id = action + Math.floor(Math.random() * 4096);
            } while (Type.exists(this.runningCalls[id]));

            // store information about the calls
            this.runningCalls[id] = {action: action};
            if (Type.exists(data.module)) {
                this.runningCalls[id].module = data.module;
            }

            fileurl = JXG.serverBase + 'JXGServer.py';
            passdata = 'action=' + escape(action) + '&id=' + id + '&dataJSON=' + escape(Base64.encode(dataJSONStr));

            this.cbp = function (d) {
                /*jslint evil:true*/
                var str, data,
                    tmp, inject, paramlist, id,
                    i, j;

                str = (new Zip.Unzip(Base64.decodeAsArray(d))).unzip();
                if (Type.isArray(str) && str.length > 0) {
                    str = str[0][0];
                }

                if (!Type.exists(str)) {
                    return;
                }

                data = window.JSON && window.JSON.parse ? window.JSON.parse(str) : (new Function('return ' + str))();

                if (data.type === 'error') {
                    this.handleError(data);
                } else if (data.type === 'response') {
                    id = data.id;

                    // inject fields
                    for (i = 0; i < data.fields.length; i++) {
                        tmp = data.fields[i];
                        inject = tmp.namespace + (typeof ((new Function('return ' + tmp.namespace))()) === 'object' ? '.' : '.prototype.') + tmp.name + ' = ' + tmp.value;
                        (new Function(inject))();
                    }

                    // inject handlers
                    for (i = 0; i < data.handler.length; i++) {
                        tmp = data.handler[i];
                        paramlist = [];

                        for (j = 0; j < tmp.parameters.length; j++) {
                            paramlist[j] = '"' + tmp.parameters[j] + '": ' + tmp.parameters[j];
                        }
                        // insert subnamespace named after module.
                        inject = 'if(typeof JXG.Server.modules.' + this.runningCalls[id].module + ' == "undefined")' + 'JXG.Server.modules.' + this.runningCalls[id].module + ' = {};';

                        // insert callback method which fetches and uses the server's data for calculation in JavaScript
                        inject += 'JXG.Server.modules.' + this.runningCalls[id].module + '.' + tmp.name + '_cb = ' + tmp.callback + ';';

                        // insert handler as JXG.Server.modules.<module name>.<handler name>
                        inject += 'JXG.Server.modules.' + this.runningCalls[id].module + '.' + tmp.name + ' = function (' + tmp.parameters.join(',') + ', __JXGSERVER_CB__, __JXGSERVER_SYNC) {' +
                            'if(typeof __JXGSERVER_CB__ == "undefined") __JXGSERVER_CB__ = JXG.Server.modules.' + this.runningCalls[id].module + '.' + tmp.name + '_cb;' +
                            'var __JXGSERVER_PAR__ = {' + paramlist.join(',') + ', "module": "' + this.runningCalls[id].module + '", "handler": "' + tmp.name + '" };' +
                            'JXG.Server.callServer("exec", __JXGSERVER_CB__, __JXGSERVER_PAR__, __JXGSERVER_SYNC);' +
                            '};';
                        (new Function(inject))();
                    }

                    delete this.runningCalls[id];

                    // handle data
                    callback(data.data);
                }
            };

            // bind cbp callback method to JXG.Server to get access to JXG.Server fields from within cpb
            this.cb = JXG.bind(this.cbp, this);

            // We are using our own XMLHttpRequest object in here because of a/sync and POST
            if (window.XMLHttpRequest) {
                AJAX = new XMLHttpRequest();
                AJAX.overrideMimeType('text/plain; charset=iso-8859-1');
            } else {
                AJAX = new ActiveXObject("Microsoft.XMLHTTP");
            }
            if (AJAX) {
                // POST is required if data sent to server is too long for a url.
                // some browsers/http servers don't accept long urls.
                AJAX.open("POST", fileurl, !sync);
                AJAX.setRequestHeader("Content-type", "application/x-www-form-urlencoded");

                if (!sync) {
                    // Define function to fetch data received from server
                    // that function returning a function is required to make this.cb known to the function.
                    AJAX.onreadystatechange = (function (cb) {
                        return function () {
                            if (AJAX.readyState === 4 && AJAX.status === 200) {
                                cb(AJAX.responseText);
                                return true;
                            }
                            return false;
                        };
                    }(this.cb));
                }

                // send the data
                AJAX.send(passdata);
                if (sync) {
                    this.cb(AJAX.responseText);
                    return true;
                }
            }

            return false;
        },

        /**
         * Callback for the default action 'load'.
         */
        loadModule_cb: function (data) {
            var i;
            for (i = 0; i < data.length; i++) {
                JXG.debug(data[i].name + ': ' + data[i].value);
            }
        },

        /**
         * Loads a module from the server.
         * @param {string} module A string containing the module. Has to match the filename of the Python module on the server exactly including
         * lower and upper case letters without the file ending .py.
         */
        loadModule: function (module) {
            return JXG.Server.callServer('load', JXG.Server.loadModule_cb, {'module': module}, true);
        }
    };

    JXG.Server.load = JXG.Server.loadModule;

    return JXG.Server;
});
/*
    Copyright 2008-2022
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <http://www.gnu.org/licenses/>
    and <http://opensource.org/licenses/MIT/>.
 */


/*global JXG: true, define: true*/
/*jslint nomen: true, plusplus: true*/

/* depends:
 jxg
 base/constants
 base/coords
 math/math
 math/geometry
 server/server
 utils/type
 */

/**
 * @fileoverview In this file the namespace Math.Symbolic is defined, which holds methods
 * and algorithms for symbolic computations.
 * @author graphjs
 */

define('math/symbolic',[
    'base/constants', 'base/coords', 'math/math', 'math/geometry', 'server/server', 'utils/type'
], function (Const, Coords, Mat, Geometry, Server, Type) {

    "use strict";

    var undef;

    /**
     * The JXG.Math.Symbolic namespace holds algorithms for symbolic computations.
     * @name JXG.Math.Symbolic
     * @exports Mat.Symbolic as JXG.Math.Symbolic
     * @namespace
     */
    Mat.Symbolic = {
        /**
         * Generates symbolic coordinates for the part of a construction including all the elements from that
         * a specific element depends of. These coordinates will be stored in GeometryElement.symbolic.
         * @param {JXG.Board} board The board that's element get some symbolic coordinates.
         * @param {JXG.GeometryElement} element All ancestor of this element get symbolic coordinates.
         * @param {String} variable Name for the coordinates, e.g. x or u.
         * @param {String} append Method for how to append the number of the coordinates. Possible values are
         *                        'underscore' (e.g. x_2), 'none' (e.g. x2), 'brace' (e.g. x[2]).
         * @returns {Number} Number of coordinates given.
         * @memberof JXG.Math.Symbolic
         */
        generateSymbolicCoordinatesPartial: function (board, element, variable, append) {
            var t_num, t, k,
                list = element.ancestors,
                count = 0,
                makeCoords = function (num) {
                    var r;

                    if (append === 'underscore') {
                        r = variable + '_{' + num + '}';
                    } else if (append === 'brace') {
                        r = variable + '[' + num + ']';
                    } else {
                        r = variable + num;
                    }

                    return r;
                };

            board.listOfFreePoints = [];
            board.listOfDependantPoints = [];

            for (t in list) {
                if (list.hasOwnProperty(t)) {
                    t_num = 0;

                    if (Type.isPoint(list[t])) {
                        for (k in list[t].ancestors) {
                            if (list[t].ancestors.hasOwnProperty(k)) {
                                t_num++;
                            }
                        }

                        if (t_num === 0) {
                            list[t].symbolic.x = list[t].coords.usrCoords[1];
                            list[t].symbolic.y = list[t].coords.usrCoords[2];
                            board.listOfFreePoints.push(list[t]);
                        } else {
                            count += 1;
                            list[t].symbolic.x = makeCoords(count);
                            count += 1;
                            list[t].symbolic.y = makeCoords(count);
                            board.listOfDependantPoints.push(list[t]);
                        }

                    }
                }
            }

            if (Type.isPoint(element)) {
                element.symbolic.x = 'x';
                element.symbolic.y = 'y';
            }

            return count;
        },

        /**
         * Clears all .symbolic.x and .symbolic.y members on every point of a given board.
         * @param {JXG.Board} board The board that's points get cleared their symbolic coordinates.
         * @memberof JXG.Math.Symbolic
         */
        clearSymbolicCoordinates: function (board) {
            var clear = function (list) {
                    var t, l = (list && list.length) || 0;

                    for (t = 0; t < l; t++) {
                        if (Type.isPoint(list[t])) {
                            list[t].symbolic.x = '';
                            list[t].symbolic.y = '';
                        }
                    }
                };

            clear(board.listOfFreePoints);
            clear(board.listOfDependantPoints);

            delete (board.listOfFreePoints);
            delete (board.listOfDependantPoints);
        },

        /**
         * Generates polynomials for a part of the construction including all the points from that
         * a specific element depends of.
         * @param {JXG.Board} board The board that's points polynomials will be generated.
         * @param {JXG.GeometryElement} element All points in the set of ancestors of this element are used to generate the set of polynomials.
         * @param {Boolean} generateCoords
         * @returns {Array} An array of polynomials as strings.
         * @memberof JXG.Math.Symbolic
         */
        generatePolynomials: function (board, element, generateCoords) {
            var t, k, i,
                list = element.ancestors,
                number_of_ancestors,
                pgs = [],
                result = [];

            if (generateCoords) {
                this.generateSymbolicCoordinatesPartial(board, element, 'u', 'brace');
            }

            list[element.id] = element;

            for (t in list) {
                if (list.hasOwnProperty(t)) {
                    number_of_ancestors = 0;
                    pgs = [];

                    if (Type.isPoint(list[t])) {
                        for (k in list[t].ancestors) {
                            if (list[t].ancestors.hasOwnProperty(k)) {
                                number_of_ancestors++;
                            }
                        }
                        if (number_of_ancestors > 0) {
                            pgs = list[t].generatePolynomial();

                            for (i = 0; i < pgs.length; i++) {
                                result.push(pgs[i]);
                            }
                        }
                    }
                }
            }

            if (generateCoords) {
                this.clearSymbolicCoordinates(board);
            }

            return result;
        },

        /**
         * Calculate geometric locus of a point given on a board. Invokes python script on server.
         * @param {JXG.Board} board The board on which the point lies.
         * @param {JXG.Point} point The point that will be traced.
         * @returns {Array} An array of points.
         * @memberof JXG.Math.Symbolic
         */
        geometricLocusByGroebnerBase: function (board, point) {
            var poly, polyStr, result,
                P1, P2, i,
                xs, xe, ys, ye,
                c, s, tx,
                bol = board.options.locus,
                oldRadius = {},
                numDependent = this.generateSymbolicCoordinatesPartial(board, point, 'u', 'brace'),
                xsye = new Coords(Const.COORDS_BY_USR, [0, 0], board),
                xeys = new Coords(Const.COORDS_BY_USR, [board.canvasWidth, board.canvasHeight], board),
                sf = 1, transx = 0, transy = 0, rot = 0;

            if (Server.modules.geoloci === undef) {
                Server.loadModule('geoloci');
            }

            if (Server.modules.geoloci === undef) {
                throw new Error("JSXGraph: Unable to load JXG.Server module 'geoloci.py'.");
            }

            xs = xsye.usrCoords[1];
            xe = xeys.usrCoords[1];
            ys = xeys.usrCoords[2];
            ye = xsye.usrCoords[2];

            // Optimizations - but only if the user wants to
            //   Step 1: Translate all related points, such that one point P1 (board.options.locus.toOrigin if set
            //     or a random point otherwise) is moved to (0, 0)
            //   Step 2: Rotate the construction around the new P1, such that another point P2 (board.options.locus.to10 if set
            //     or a random point \neq P1 otherwise) is moved onto the positive x-axis
            //  Step 3: Dilate the construction, such that P2 is moved to (1, 0)
            //  Step 4: Give the scale factor (sf), the rotation (rot) and the translation vector (transx, transy) to
            //    the server, which retransforms the plot (if any).

            // Step 1
            if (bol.translateToOrigin && (board.listOfFreePoints.length > 0)) {
                if ((bol.toOrigin !== undef) && (bol.toOrigin !== null) && Type.isInArray(board.listOfFreePoints, bol.toOrigin.id)) {
                    P1 = bol.toOrigin;
                } else {
                    P1 = board.listOfFreePoints[0];
                }

                transx = P1.symbolic.x;
                transy = P1.symbolic.y;
                // translate the whole construction
                for (i = 0; i < board.listOfFreePoints.length; i++) {
                    board.listOfFreePoints[i].symbolic.x -= transx;
                    board.listOfFreePoints[i].symbolic.y -= transy;
                }

                xs -= transx;
                xe -= transx;
                ys -= transy;
                ye -= transy;

                // Step 2
                if (bol.translateTo10 && (board.listOfFreePoints.length > 1)) {
                    if ((bol.to10 !== undef) && (bol.to10 !== null) && (bol.to10.id !== bol.toOrigin.id) && Type.isInArray(board.listOfFreePoints, bol.to10.id)) {
                        P2 = bol.to10;
                    } else {
                        if (board.listOfFreePoints[0].id === P1.id) {
                            P2 = board.listOfFreePoints[1];
                        } else {
                            P2 = board.listOfFreePoints[0];
                        }
                    }

                    rot = Geometry.rad([1, 0], [0, 0], [P2.symbolic.x, P2.symbolic.y]);
                    c = Math.cos(-rot);
                    s = Math.sin(-rot);


                    for (i = 0; i < board.listOfFreePoints.length; i++) {
                        tx = board.listOfFreePoints[i].symbolic.x;
                        board.listOfFreePoints[i].symbolic.x = c * board.listOfFreePoints[i].symbolic.x - s * board.listOfFreePoints[i].symbolic.y;
                        board.listOfFreePoints[i].symbolic.y = s * tx + c * board.listOfFreePoints[i].symbolic.y;
                    }

                    // thanks to the rotation this is zero
                    P2.symbolic.y = 0;

                    tx = xs;
                    xs = c * xs - s * ys;
                    ys = s * tx + c * ys;
                    tx = xe;
                    xe = c * xe - s * ye;
                    ye = s * tx + c * ye;

                    // Step 3
                    if (bol.stretch && (Math.abs(P2.symbolic.x) > Mat.eps)) {
                        sf = P2.symbolic.x;

                        for (i = 0; i < board.listOfFreePoints.length; i++) {
                            board.listOfFreePoints[i].symbolic.x /= sf;
                            board.listOfFreePoints[i].symbolic.y /= sf;
                        }

                        for (i = 0; i < board.objectsList.length; i++) {
                            if ((board.objectsList[i].elementClass === Const.OBJECT_CLASS_CIRCLE) && (board.objectsList[i].method === 'pointRadius')) {
                                oldRadius[i] = board.objectsList[i].radius;
                                board.objectsList[i].radius /= sf;
                            }
                        }

                        xs /= sf;
                        xe /= sf;
                        ys /= sf;
                        ye /= sf;

                        // this is now 1
                        P2.symbolic.x = 1;
                    }
                }

                // make the coordinates "as rational as possible"
                for (i = 0; i < board.listOfFreePoints.length; i++) {
                    tx = board.listOfFreePoints[i].symbolic.x;

                    if (Math.abs(tx) < Mat.eps) {
                        board.listOfFreePoints[i].symbolic.x = 0;
                    }

                    if (Math.abs(tx - Math.round(tx)) < Mat.eps) {
                        board.listOfFreePoints[i].symbolic.x = Math.round(tx);
                    }

                    tx = board.listOfFreePoints[i].symbolic.y;

                    if (Math.abs(tx) < Mat.eps) {
                        board.listOfFreePoints[i].symbolic.y = 0;
                    }

                    if (Math.abs(tx - Math.round(tx)) < Mat.eps) {
                        board.listOfFreePoints[i].symbolic.y = Math.round(tx);
                    }
                }
            }

            // end of optimizations

            poly = this.generatePolynomials(board, point);
            polyStr = poly.join(',');

            this.cbp = function (data) {
                result = data;
            };

            this.cb = Type.bind(this.cbp, this);

            Server.modules.geoloci.lociCoCoA(xs, xe, ys, ye, numDependent, polyStr, sf, rot, transx, transy, this.cb, true);

            this.clearSymbolicCoordinates(board);

            for (i in oldRadius) {
                if (oldRadius.hasOwnProperty(i)) {
                    board.objects[i].radius = oldRadius[i];
                }
            }


            return result;
        }
    };

    return Mat.Symbolic;
});

/*
    Copyright 2008-2022
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Alfred Wassermann
console.log("P:", P.coords.usrCoords, P.data.type)

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <http://www.gnu.org/licenses/>
    and <http://opensource.org/licenses/MIT/>.
 */


/*global JXG: true, define: true*/
/*jslint nomen: true, plusplus: true*/

/* depends:
 jxg
 base/constants
 base/coords
 math/math
 math/numerics
 math/geometry
 utils/type
 */

/**
 * @fileoverview This file contains the Math.Clip namespace for clipping and computing boolean operations
 * on polygons and curves
 *
 * // TODO:
 * * Check if input polygons are closed. If not, handle this case.
 */

define('math/clip',[
    'jxg', 'base/constants', 'base/coords', 'math/math', 'math/geometry', 'utils/type'
], function (JXG, Const, Coords, Mat, Geometry, Type) {

    "use strict";

    /**
     * Math.Clip namespace definition. This namespace contains algorithms for Boolean operations on paths, i.e.
     * intersection, union and difference of paths. Base is the Greiner-Hormann algorithm.
     * @name JXG.Math.Clip
     * @exports Mat.Clip as JXG.Math.Clip
     * @namespace
     */
    // Mat.Clip = function () {
    // };

    // JXG.extend(Mat.Clip.prototype, /** @lends JXG.Curve.prototype */ {

    Mat.Clip = {

        _isSeparator: function(node) {
            return isNaN(node.coords.usrCoords[1]) && isNaN(node.coords.usrCoords[2]);
        },

        /**
         * Add pointers to an array S such that it is a circular doubly-linked list.
         *
         * @private
         * @param  {Array} S Array
         * @return {Array} return containing the starter indices of each component.
         */
        makeDoublyLinkedList: function(S) {
            var i,
                first = null,
                components = [],
                le = S.length;

            if (le > 0) {
                for (i = 0; i < le; i++) {
                    // S[i]._next = S[(i + 1) % le];
                    // S[i]._prev = S[(le + i - 1) % le];

                    // If S[i] is component separator we proceed with the next node.
                    if (this._isSeparator(S[i])) {
                        S[i]._next = S[(i + 1) % le];
                        S[i]._prev = S[(le + i - 1) % le];
                        continue;
                    }

                    // Now we know that S[i] is a path component
                    if (first === null) {
                        // Start the component if it is not yet started.
                        first = i;
                        components.push(first);
                    }
                    if (this._isSeparator(S[(i + 1) % le]) || i === le - 1) {
                        // If the next node is a component separator or if the node is the last node,
                        // then we close the loop

                        S[i]._next = S[first];
                        S[first]._prev = S[i];
                        S[i]._end = true;
                        first = null;
                    } else {
                        // Here, we are not at the end of component
                        S[i]._next = S[(i + 1) % le];
                        S[first]._prev = S[i];
                    }
                    if (!this._isSeparator(S[(le + i - 1) % le])) {
                        S[i]._prev = S[(le + i - 1) % le];
                    }
                }
            }
            return components;
        },

        /**
         * Determinant of three points in the Euclidean plane.
         * Zero, if the points are collinear. Used to determine of a point q is left or
         * right to a segment defined by points p1 and p2.
         * @private
         * @param  {Array} p1 Coordinates of the first point of the segment. Array of length 3. First coordinate is equal to 1.
         * @param  {Array} p2 Coordinates of the second point of the segment. Array of length 3. First coordinate is equal to 1.
         * @param  {Array} q Coordinates of the point. Array of length 3. First coordinate is equal to 1.
         * @return {Number} Signed area of the triangle formed by these three points.
         */
        det: function(p1, p2, q) {
            return (p1[1] - q[1]) * (p2[2] - q[2]) - (p2[1] - q[1]) * (p1[2] - q[2]);
        },

        /**
         * Winding number of a point in respect to a polygon path.
         *
         * The point is regarded outside if the winding number is zero,
         * inside otherwise. The algorithm tries to find degenerate cases, i.e.
         * if the point is on the path. This is regarded as "outside".
         * If the point is a vertex of the path, it is regarded as "inside".
         *
         * Implementation of algorithm 7 from "The point in polygon problem for
         * arbitrary polygons" by Kai Hormann and Alexander Agathos, Computational Geometry,
         * Volume 20, Issue 3, November 2001, Pages 131-144.
         *
         * @param  {Array} usrCoords Homogenous coordinates of the point
         * @param  {Array} path      Array of points determining a path, i.e. the vertices of the polygon. The array elements
         * do not have to be full points, but have to have a subobject "coords".
         * @return {Number}          Winding number of the point. The point is
         *                           regarded outside if the winding number is zero,
         *                           inside otherwise.
         */
        windingNumber: function(usrCoords, path) {
            var wn = 0,
                le = path.length,
                x = usrCoords[1],
                y = usrCoords[2],
                p1, p2, d, sign, i;

            if (le === 0) {
                return 0;
            }

            // Infinite points are declared outside
            if (isNaN(x) || isNaN(y)) {
                return 1;
            }

            // Handle the case if the point is a vertex of the path
            if (path[0].coords.usrCoords[1] === x &&
                path[0].coords.usrCoords[2] === y) {

                // console.log('<<<<<<< Vertex 1');
                return 1;
            }

            for (i = 0; i < le; i++) {
                // Consider the edge from p1 = path[i] to p2 = path[i+1]
                p1 = path[i].coords.usrCoords;
                p2 = path[(i + 1) % le].coords.usrCoords;
                if (p1[0] === 0 || p2[0] === 0 ||
                    isNaN(p1[1]) || isNaN(p2[1]) ||
                    isNaN(p1[2]) || isNaN(p2[2])) {

                    continue;
                }

                if (p2[2] === y) {
                    if (p2[1] === x) {
                        // console.log('<<<<<<< Vertex 2');
                        return 1;
                    }
                    if (p1[2] === y && ((p2[1] > x) === (p1[1] < x))) {
                        // console.log('<<<<<<< Edge 1', p1, p2, [x, y]);
                        return 0;
                    }
                }

                if ((p1[2] < y) !== (p2[2] < y)) {
                    sign = 2 * ((p2[2] > p1[2]) ? 1 : 0) - 1;
                    if (p1[1] >= x) {
                        if (p2[1] > x) {
                            wn += sign;
                        } else {
                            d = this.det(p1, p2, usrCoords);
                            if (d === 0) {
                                // console.log('<<<<<<< Edge 2');
                                return 0;
                            }
                            if ((d > 0) === (p2[2] > p1[2])) {
                                wn += sign;
                            }
                        }
                    } else {
                        if (p2[1] > x) {
                            d = this.det(p1, p2, usrCoords);
                            if ((d > 0 + Mat.eps) === (p2[2] > p1[2])) {
                                wn += sign;
                            }
                        }
                    }
                }
            }

            return wn;
        },

        /**
         * JavaScript object containing the intersection of two paths. Every intersection point is on one path, but
         * comes with a neighbour point having the same coordinates and being on the other path.
         *
         * The intersection point is inserted into the doubly linked list of the path.
         *
         * @private
         * @param  {JXG.Coords} coords JSXGraph Coords object conatining the coordinates of the intersection
         * @param  {Number} i        Number of the segment of the subject path (first path) containing the intersection.
         * @param  {Number} alpha    The intersection is a p_1 + alpha*(p_2 - p_1), where p_1 and p_2 are the end points
         *      of the i-th segment.
         * @param  {Array} path      Pointer to the path containing the intersection point
         * @param  {String} pathname Name of the path: 'S' or 'C'.
         */
        Vertex: function(coords, i, alpha, path, pathname, type) {
            this.pos = i;
            this.intersection = true;
            this.coords = coords;
            this.elementClass = Const.OBJECT_CLASS_POINT;

            this.data = {
                alpha: alpha,
                path: path,
                pathname: pathname,
                done: false,
                type: type,
                idx: 0
            };

            // Set after initialisation
            this.neighbour = null;
            this.entry_exit = false;
        },

        _addToList: function(list, coords, pos) {
            var len = list.length,
                eps = Mat.eps * Mat.eps;

            if (len > 0 &&
                Math.abs(list[len - 1].coords.usrCoords[0] - coords.usrCoords[0]) < eps &&
                Math.abs(list[len - 1].coords.usrCoords[1] - coords.usrCoords[1]) < eps &&
                Math.abs(list[len - 1].coords.usrCoords[2] - coords.usrCoords[2]) < eps) {
                // Skip point
                return;
            }
            list.push({
                pos: pos,
                intersection: false,
                coords: coords,
                elementClass: Const.OBJECT_CLASS_POINT
            });
        },

        /**
         * Sort the intersection points into their path.
         * @private
         * @param  {Array} P_crossings Array of arrays. Each array contains the intersections of the path
         *      with one segment of the other path.
         * @return {Array}  Array of intersection points ordered by first occurrence in the path.
         */
        sortIntersections: function(P_crossings) {
            var i, j, P, Q,
                last,
                next_node,
                P_intersect = [],
                P_le = P_crossings.length;

            for (i = 0; i < P_le; i++) {
                P_crossings[i].sort(function(a, b) { return (a.data.alpha > b.data.alpha) ? 1 : -1; });

                if (P_crossings[i].length > 0) {
                    // console.log("Crossings", P_crossings[i])
                    last = P_crossings[i].length - 1;
                    P = P_crossings[i][0];

                    //console.log("SORT", P.coords.usrCoords)
                    Q =  P.data.path[P.pos];
                    next_node = Q._next;  // Store the next "normal" node

                    if (i === P_le - 1) {
                        Q._end = false;
                    }

                    if (P.data.alpha === 0.0 && P.data.type === 'T') {
                        // console.log("SKIP", P.coords.usrCoords, P.data.type, P.neighbour.data.type);
                        Q.intersection = true;
                        Q.data = P.data;
                        Q.neighbour = P.neighbour;
                        Q.neighbour.neighbour = Q;
                        Q.entry_exit = false;
                        P_crossings[i][0] = Q;
                    } else {
                        // Insert the first intersection point
                        P._prev = Q;
                        P._prev._next = P;
                    }

                    // Insert the other intersection points, but the last
                    for (j = 1; j <= last; j++) {
                        P = P_crossings[i][j];
                        P._prev = P_crossings[i][j - 1];
                        P._prev._next = P;
                    }

                    // Link last intersection point to the next node
                    P = P_crossings[i][last];
                    P._next = next_node;
                    P._next._prev = P;

                    if (i === P_le - 1) {
                        P._end = true;
                        //console.log("END", P._end, P.coords.usrCoords, P._prev.coords.usrCoords, P._next.coords.usrCoords);
                    }

                    P_intersect = P_intersect.concat(P_crossings[i]);
                }
            }
            return P_intersect;
        },

        _inbetween: function(q, p1, p2) {
            var alpha,
                eps = Mat.eps * Mat.eps,
                px = p2[1] - p1[1],
                py = p2[2] - p1[2],
                qx = q[1]  - p1[1],
                qy = q[2]  - p1[2];

            if (px === 0 && py === 0 && qx === 0 && qy === 0) {
                // All three points are equal
                return true;
            }
            if (Math.abs(qx) < eps && Math.abs(px) < eps) {
                alpha = qy / py;
            } else {
                alpha = qx / px;
            }
            if (Math.abs(alpha) < eps) {
                alpha = 0.0;
            }
            return alpha;
        },

        _print_array: function(arr) {
            var i, end;
            for (i = 0; i < arr.length; i++) {
                //console.log(i, arr[i].coords.usrCoords,  arr[i].data.type);
                try {
                    end = "";
                    if (arr[i]._end) {
                        end = " end";
                    }
                    console.log(i, arr[i].coords.usrCoords, arr[i].data.type, "\t",
                                "prev", arr[i]._prev.coords.usrCoords,
                                "next", arr[i]._next.coords.usrCoords + end);
                } catch (e) {
                    console.log(i, arr[i].coords.usrCoords);
                }
            }
        },

        _print_list: function(P) {
            var cnt = 0, alpha;
            while (cnt < 100) {
                if (P.data) {
                    alpha = P.data.alpha;
                } else {
                    alpha = '-';
                }
                console.log("\t", P.coords.usrCoords, "\n\t\tis:", P.intersection, "end:", P._end,
                            alpha,
                            "\n\t\t-:", P._prev.coords.usrCoords,
                            "\n\t\t+:", P._next.coords.usrCoords,
                            "\n\t\tn:", (P.intersection) ? P.neighbour.coords.usrCoords : '-'
                            );
                if (P._end) {
                    break;
                }
                P = P._next;
                cnt++;
            }
        },

        _noOverlap: function(p1, p2, q1, q2) {
            var k,
                eps = Math.sqrt(Mat.eps),
                minp, maxp, minq, maxq,
                no_overlap = false;

            for (k = 0; k < 3; k++) {
                minp = Math.min(p1[k], p2[k]);
                maxp = Math.max(p1[k], p2[k]);
                minq = Math.min(q1[k], q2[k]);
                maxq = Math.max(q1[k], q2[k]);
                if (maxp < minq - eps || minp > maxq + eps) {
                    no_overlap = true;
                    break;
                }
            }
            return no_overlap;
        },

        /**
         * Find all intersections between two paths.
         * @private
         * @param  {Array} S     Subject path
         * @param  {Array} C     Clip path
         * @param  {JXG.Board} board JSXGraph board object. It is needed to convert between
         * user coordinates and screen coordinates.
         * @return {Array}  Array containing two arrays. The first array contains the intersection vertices
         * of the subject path and the second array contains the intersection vertices of the clip path.
         * @see JXG.Clip#Vertex
         */
        findIntersections: function(S, C, board) {
            var res = [],
                eps = Mat.eps,
                i, j,
                crds,
                S_le = S.length,
                C_le = C.length,
                Si, Si1, Cj, Cj1,
                d1, d2,
                alpha,
                type,
                IS, IC,
                S_intersect = [],
                C_intersect = [],
                S_crossings = [],
                C_crossings = [],
                hasMultCompsS = false,
                hasMultCompsC = false,
                DEBUG = false;

            for (j = 0; j < C_le; j++) {
                C_crossings.push([]);
            }

            // Run through the subject path.
            for (i = 0; i < S_le; i++) {
                S_crossings.push([]);

                // Test if S[i] or its successor is a path separator.
                // If yes, we know that the path consists of multiple components.
                // We immediately jump to the next segment.
                if (this._isSeparator(S[i]) || this._isSeparator(S[(i + 1) % S_le])) {
                    hasMultCompsS = true;
                    continue;
                }

                // If the path consists of multiple components then there is
                // no path-closing segment between the last node and the first
                // node. In this case we can leave the loop now.
                if (hasMultCompsS && i === S_le - 1) {
                    break;
                }

                Si = S[i].coords.usrCoords;
                Si1 = S[(i + 1) % S_le].coords.usrCoords;
                // Run through the clip path.
                for (j = 0; j < C_le; j++) {
                    // Test if C[j] or its successor is a path separator.
                    // If yes, we know that the path consists of multiple components.
                    // We immediately jump to the next segment.
                    if (this._isSeparator(C[j]) || this._isSeparator(C[(j + 1) % C_le])) {
                        hasMultCompsC = true;
                        continue;
                    }

                    // If the path consists of multiple components then there is
                    // no path-closing segment between the last node and the first
                    // node. In this case we can leave the loop now.
                    if (hasMultCompsC && j === C_le - 1) {
                        break;
                    }

                    // Test if bounding boxes of the two curve segments overlap
                    // If not, the expensive intersection test can be skipped.
                    Cj  = C[j].coords.usrCoords;
                    Cj1 = C[(j + 1) % C_le].coords.usrCoords;

                    if (this._noOverlap(Si, Si1, Cj, Cj1)) {
                        continue;
                    }

                    // Intersection test
                    res = Geometry.meetSegmentSegment(Si, Si1, Cj, Cj1);

                    d1 = Geometry.distance(Si, Si1, 3);
                    d2 = Geometry.distance(Cj, Cj1, 3);

                    // Found an intersection point
                    if ( // "Regular" intersection
                        (res[1] * d1 > -eps && res[1] < 1 - eps / d1 && res[2] * d2 > -eps && res[2] < 1 - eps / d2) ||
                        // Collinear segments
                        (res[1] === Infinity && res[2] === Infinity && Mat.norm(res[0], 3) < eps)
                        ) {

                        crds = new Coords(Const.COORDS_BY_USER, res[0], board);
                        type = 'X';

                        // Handle degenerated cases
                        if (Math.abs(res[1]) * d1 < eps || Math.abs(res[2]) * d2 < eps) {
                            // Crossing / bouncing at vertex or
                            // end of delayed crossing / bouncing
                            type  = 'T';
                            if (Math.abs(res[1]) * d1 < eps) {
                                res[1] = 0;
                            }
                            if (Math.abs(res[2]) * d2 < eps) {
                                res[2] = 0;
                            }
                            if (res[1] === 0) {
                                crds = new Coords(Const.COORDS_BY_USER, Si, board);
                            } else {
                                crds = new Coords(Const.COORDS_BY_USER, Cj, board);
                            }

                            if (DEBUG) {
                                console.log("Degenerate case I", res[1], res[2], crds.usrCoords, "type", type);
                            }
                        } else if (res[1] === Infinity &&
                                   res[2] === Infinity &&
                                   Mat.norm(res[0], 3) < eps) {                // console.log(C_intersect);


                            // Collinear segments
                            // Here, there might be two intersection points to be added

                            alpha = this._inbetween(Si, Cj, Cj1);
                            if (DEBUG) {
                                // console.log("alpha Si", alpha, Si);
                                // console.log(j, Cj)
                                // console.log((j + 1) % C_le, Cj1)
                            }
                            if (alpha >= 0 && alpha < 1) {
                                type = 'T';
                                crds = new Coords(Const.COORDS_BY_USER, Si, board);
                                res[1] = 0;
                                res[2] = alpha;
                                IS = new this.Vertex(crds, i, res[1], S, 'S', type);
                                IC = new this.Vertex(crds, j, res[2], C, 'C', type);
                                IS.neighbour = IC;
                                IC.neighbour = IS;
                                S_crossings[i].push(IS);
                                C_crossings[j].push(IC);
                                if (DEBUG) {
                                    console.log("Degenerate case II", res[1], res[2], crds.usrCoords, "type T");
                                }
                            }
                            alpha = this._inbetween(Cj, Si, Si1);
                            if (DEBUG) {
                                // console.log("alpha Cj", alpha, Si, Geometry.distance(Si, Cj, 3));
                            }
                            if (Geometry.distance(Si, Cj, 3) > eps &&
                                alpha >= 0 && alpha < 1) {

                                type = 'T';
                                crds = new Coords(Const.COORDS_BY_USER, Cj, board);
                                res[1] = alpha;
                                res[2] = 0;
                                IS = new this.Vertex(crds, i, res[1], S, 'S', type);
                                IC = new this.Vertex(crds, j, res[2], C, 'C', type);
                                IS.neighbour = IC;
                                IC.neighbour = IS;
                                S_crossings[i].push(IS);
                                C_crossings[j].push(IC);
                                if (DEBUG) {
                                    console.log("Degenerate case III", res[1], res[2], crds.usrCoords, "type T");
                                }
                            }
                            continue;
                        }
                        if (DEBUG) {
                            console.log("IS", i, j, crds.usrCoords, type);
                        }

                        IS = new this.Vertex(crds, i, res[1], S, 'S', type);
                        IC = new this.Vertex(crds, j, res[2], C, 'C', type);
                        IS.neighbour = IC;
                        IC.neighbour = IS;

                        S_crossings[i].push(IS);
                        C_crossings[j].push(IC);
                    }
                }
            }

            // For both paths, sort their intersection points
            S_intersect = this.sortIntersections(S_crossings);

            if (DEBUG) {
                console.log('>>>>>> Intersections ');
                console.log("S_intersect");
                this._print_array(S_intersect);
                console.log('----------');
            }
            for (i = 0; i < S_intersect.length; i++) {
                S_intersect[i].data.idx = i;
                S_intersect[i].neighbour.data.idx = i;
            }
            C_intersect = this.sortIntersections(C_crossings);

            if (DEBUG) {
                console.log("C_intersect");
                this._print_array(C_intersect);
                console.log('<<<<<< Phase 1 done');
            }
            return [S_intersect, C_intersect];
        },

        /**
         * It is testedd if the point q lies to the left or right
         * of the poylgonal chain [p1, p2, p3].
         * @param {Array} q User coords array
         * @param {Array} p1 User coords array
         * @param {Array} p2 User coords array
         * @param {Array} p3 User coords array
         * @returns string 'left' or 'right'
         * @private
         */
        _getPosition: function(q, p1, p2, p3) {
            var s1 = this.det(q, p1, p2),
                s2 = this.det(q, p2, p3),
                s3 = this.det(p1, p2, p3);

            // Left turn
            if (s3 >= 0) {
                if (s1 >= 0 && s2 >= 0) {
                    return 'left';
                }
                return 'right';
            }
            // Right turn
            if (s1 >= 0 || s2 >= 0) {
                return 'left';
            }
            return 'right';
        },

        /**
         * Determine the delayed status of degenerated intersection points.
         * It is of the form
         *   ['on|left|right', 'on|left|right']
         * <p>
         * If all four determinants are zero, we add random noise to the point.
         *
         * @param {JXG.Math.Clip.Vertex} P Start of path
         * @private
         * @see JXG.Math.Clip#markEntryExit
         * @see JXG.Math.Clip#_handleIntersectionChains
         */
        _classifyDegenerateIntersections: function(P) {
            var Pp, Pm, Qp, Qm, Q, side,
                cnt, tmp,
                oppositeDir,
                s1, s2, s3, s4,
                DEBUG = false;

            if (DEBUG) {
                console.log("\n-------------- _classifyDegenerateIntersections()", (Type.exists(P.data))?P.data.pathname:' ');
            }
            cnt = 0;
            P._tours = 0;
            while (true) {
                if (DEBUG) {
                    console.log("Inspect P:", P.coords.usrCoords, (P.data) ? P.data.type : " ");
                }
                if (P.intersection && (P.data.type === 'T')) {

                    // Handle the degenerate cases
                    // Decide if they are (delayed) bouncing or crossing intersections
                    Pp = P._next.coords.usrCoords;  // P+
                    Pm = P._prev.coords.usrCoords;  // P-

                    // If the intersection point is degenerated and
                    // equal to the start and end of one component,
                    // then there will be two adjacent points with
                    // the same coordinate.
                    // In that case, we proceed to the next node.
                    if (Geometry.distance(P.coords.usrCoords, Pp, 3) < Mat.eps) {
                        Pp = P._next._next.coords.usrCoords;
                    }
                    if (Geometry.distance(P.coords.usrCoords, Pm, 3) < Mat.eps) {
                        Pm = P._prev._prev.coords.usrCoords;
                    }

                    Q = P.neighbour;
                    Qm = Q._prev.coords.usrCoords;  // Q-
                    Qp = Q._next.coords.usrCoords;  // Q+
                    if (Geometry.distance(Q.coords.usrCoords, Qp, 3) < Mat.eps) {
                        Qp = Q._next._next.coords.usrCoords;
                    }
                    if (Geometry.distance(Q.coords.usrCoords, Qm, 3) < Mat.eps) {
                        Qm = Q._prev._prev.coords.usrCoords;
                    }

                    if (DEBUG) {
                        console.log("P chain:", Pm, P.coords.usrCoords, Pp);
                        console.log("Q chain:", Qm, P.neighbour.coords.usrCoords, Qp);
                        console.log("Pm", this._getPosition(Pm,  Qm, Q.coords.usrCoords, Qp));
                        console.log("Pp", this._getPosition(Pp,  Qm, Q.coords.usrCoords, Qp));
                    }

                    s1 = this.det(P.coords.usrCoords, Pm, Qm);
                    s2 = this.det(P.coords.usrCoords, Pp, Qp);
                    s3 = this.det(P.coords.usrCoords, Pm, Qp);
                    s4 = this.det(P.coords.usrCoords, Pp, Qm);

                    if (s1 === 0 && s2 === 0 && s3 === 0 && s4 === 0) {
                        P.coords.usrCoords[1] *= 1 + Math.random() * Mat.eps;
                        P.coords.usrCoords[2] *= 1 + Math.random() * Mat.eps;
                        Q.coords.usrCoords[1] = P.coords.usrCoords[1];
                        Q.coords.usrCoords[2] = P.coords.usrCoords[2];
                        s1 = this.det(P.coords.usrCoords, Pm, Qm);
                        s2 = this.det(P.coords.usrCoords, Pp, Qp);
                        s3 = this.det(P.coords.usrCoords, Pm, Qp);
                        s4 = this.det(P.coords.usrCoords, Pp, Qm);
                        if (DEBUG) {
                            console.log("Random shift", P.coords.usrCoords);
                            console.log(s1, s2, s3, s4, s2 === 0);
                            console.log(this._getPosition(Pm,  Qm, Q.coords.usrCoords, Qp),
                                this._getPosition(Pp,  Qm, Q.coords.usrCoords, Qp));
                        }
                    }
                    oppositeDir = false;
                    if (s1 === 0) {
                        // Q-, Q=P, P- on straight line
                        if (Geometry.affineRatio(P.coords.usrCoords, Pm, Qm) < 0) {
                            oppositeDir = true;
                        }
                    } else if (s2 === 0) {
                        if (Geometry.affineRatio(P.coords.usrCoords, Pp, Qp) < 0) {
                            oppositeDir = true;
                        }
                    } else if (s3 === 0) {
                        if (Geometry.affineRatio(P.coords.usrCoords, Pm, Qp) > 0) {
                            oppositeDir = true;
                        }
                    } else if (s4 === 0) {
                        if (Geometry.affineRatio(P.coords.usrCoords, Pp, Qm) > 0) {
                            oppositeDir = true;
                        }
                    }
                    if (oppositeDir) {
                        // Swap Qm and Qp
                        // Then Qm Q Qp has the same direction as Pm P Pp
                        tmp = Qm; Qm = Qp; Qp = tmp;
                        tmp = s1; s1 = s3; s3 = tmp;
                        tmp = s2; s2 = s4; s4 = tmp;
                    }

                    if (DEBUG) {
                        console.log(s1, s2, s3, s4, oppositeDir);
                    }

                    if (!Type.exists(P.delayedStatus)) {
                        P.delayedStatus = [];
                    }

                    if (s1 === 0 && s2 === 0) {
                        // Line [P-,P] equals [Q-,Q] and line [P,P+] equals [Q,Q+]
                        // Interior of delayed crossing / bouncing
                        P.delayedStatus = ['on', 'on'];

                    } else if (s1 === 0) {
                        // P- on line [Q-,Q], P+ not on line [Q,Q+]
                        // Begin / end of delayed crossing / bouncing
                        side = this._getPosition(Pp,  Qm, Q.coords.usrCoords, Qp);
                        P.delayedStatus = ['on', side];

                    } else if (s2 === 0) {
                        // P+ on line [Q,Q+], P- not on line [Q-,Q]
                        // Begin / end of delayed crossing / bouncing
                        side = this._getPosition(Pm,  Qm, Q.coords.usrCoords, Qp);
                        P.delayedStatus = [side, 'on'];

                    } else {
                        // Neither P+ on line [Q,Q+], nor P- on line [Q-,Q]
                        // No delayed crossing / bouncing
                        if (P.delayedStatus.length === 0) {
                            if (this._getPosition(Pm,  Qm, Q.coords.usrCoords, Qp) !== this._getPosition(Pp,  Qm, Q.coords.usrCoords, Qp)) {
                                P.data.type = 'X';
                            } else {
                                P.data.type = 'B';
                            }
                        }
                    }

                    if (DEBUG) {
                        console.log(">>>> P:", P.coords.usrCoords, "delayedStatus:", P.delayedStatus.toString(), (P.data) ? P.data.type : " ", "\n---");
                    }

                }

                if (Type.exists(P._tours)) {
                    P._tours++;
                }

                if (P._tours > 3 || P._end || cnt > 1000) {
                    // Jump out if either
                    // - we reached the end
                    // - there are more than 1000 intersection points
                    // - P._tours > 3: We went already 4 times through this path.
                    if (cnt > 1000) {
                        console.log("Clipping: _classifyDegenerateIntersections exit");
                    }
                    if (Type.exists(P._tours)) {
                        delete P._tours;
                    }
                    break;
                }
                if (P.intersection) {
                    cnt++;
                }
                P = P._next;
            }
            if (DEBUG) {
                console.log("------------------------");
            }
        },

        /**
         * At this point the degenerated intersections have been classified.
         * Now we decide if the intersection chains of the given path
         * ultimatively cross the other path or bounce.
         *
         * @param {JXG.Math.Clip.Vertex} P Start of path
         *
         * @see JXG.Math.Clip#markEntryExit
         * @see JXG.Math.Clip#_classifyDegenerateIntersections
         * @private
         */
        _handleIntersectionChains: function(P) {
            var cnt = 0,
                start_status = 'Null',
                P_start,
                intersection_chain = false,
                wait_for_exit = false,
                DEBUG = false;

            if (DEBUG) {
                console.log("\n-------------- _handleIntersectionChains()",
                    (Type.exists(P.data))?P.data.pathname:' ');
            }
            while (true) {
                if (P.intersection === true) {
                    if (DEBUG) {
                        if (P.data.type === 'T') {
                            console.log("Degenerate point", P.coords.usrCoords, P.data.type, (P.data.type === 'T')?P.delayedStatus:' ');
                        } else {
                            console.log("Intersection point", P.coords.usrCoords, P.data.type);
                        }
                    }
                    if (P.data.type === 'T') {
                        if (P.delayedStatus[0] !== 'on' && P.delayedStatus[1] === 'on') {
                            // First point of intersection chain
                            intersection_chain = true;
                            P_start = P;
                            start_status = P.delayedStatus[0];

                        } else if (intersection_chain &&
                                    P.delayedStatus[0] === 'on' && P.delayedStatus[1] === 'on') {
                            // Interior of intersection chain
                            P.data.type    = 'B';
                            if (DEBUG) {
                                console.log("Interior", P.coords.usrCoords);
                            }
                        } else if (intersection_chain &&
                                    P.delayedStatus[0] === 'on' && P.delayedStatus[1] !== 'on') {
                            // Last point of intersection chain
                            intersection_chain = false;
                            if (start_status === P.delayedStatus[1]) {
                                // Intersection chain is delayed bouncing
                                P_start.data.type    = 'DB';
                                P.data.type          = 'DB';
                                if (DEBUG) {
                                    console.log("Chain: delayed bouncing", P_start.coords.usrCoords, '...', P.coords.usrCoords);
                                }
                            } else {
                                // Intersection chain is delayed crossing
                                P_start.data.type    = 'DX';
                                P.data.type          = 'DX';
                                if (DEBUG) {
                                    console.log("Chain: delayed crossing", P_start.coords.usrCoords, '...', P.coords.usrCoords);
                                }
                            }
                        }
                    }
                    cnt++;
                }
                if (P._end) {
                    wait_for_exit = true;
                }
                if (wait_for_exit && !intersection_chain) {
                    break;
                }
                if (cnt > 1000) {
                    console.log("Warning: _handleIntersectionChains: intersection chain reached maximum numbers of iterations");
                    break;
                }
                P = P._next;
            }
        },

        /**
         * Handle the case that all vertices of one path are contained
         * in the other path. In this case we search for a midpoint of an edge
         * which is not contained in the other path and add it to the path.
         * It will be used as starting point for the entry/exit algorithm.
         *
         * @private
         * @param {Array} S Subject path
         * @param {Array} C Clip path
         * @param {JXG.board} board JSXGraph board object. It is needed to convert between
         * user coordinates and screen coordinates.
         */
        _handleFullyDegenerateCase: function(S, C, board) {
            var P, Q, l, M, crds, q1, q2, node,
                i, j, le, le2, is_on_Q,
                is_fully_degenerated,
                arr = [S, C];

            for (l = 0; l < 2; l++) {
                P = arr[l];
                le = P.length;
                for (i = 0, is_fully_degenerated = true; i < le; i++) {
                    if (!P[i].intersection) {
                        is_fully_degenerated = false;
                        break;
                    }
                }

                if (is_fully_degenerated) {
                    // All nodes of P are also on the other path.
                    Q = arr[(l + 1) % 2];
                    le2 = Q.length;

                    // We search for a midpoint of one edge of P which is not the other path and
                    // we add that midpoint to P.
                    for (i = 0; i < le; i++) {
                        q1 = P[i].coords.usrCoords;
                        q2 = P[(i + 1) % le].coords.usrCoords;
                        // M id the midpoint
                        M = [(q1[0] +  q2[0]) * 0.5,
                             (q1[1] +  q2[1]) * 0.5,
                             (q1[2] +  q2[2]) * 0.5];

                        // Test if M is on path Q. If this is not the case,
                        // we take M as additional point of P.
                        for (j = 0, is_on_Q = false; j < le2; j++) {
                            if (Math.abs(this.det(Q[j].coords.usrCoords, Q[(j + 1) % le2].coords.usrCoords, M)) < Mat.eps) {
                                is_on_Q = true;
                                break;
                            }
                        }
                        if (!is_on_Q) {
                            // The midpoint is added to the doubly-linked list.
                            crds = new Coords(Const.COORDS_BY_USER, M, board);
                            node = {
                                    pos: i,
                                    intersection: false,
                                    coords: crds,
                                    elementClass: Const.OBJECT_CLASS_POINT
                                };
                            P[i]._next = node;
                            node._prev = P[i];
                            P[(i + 1) % le]._prev = node;
                            node._next = P[(i + 1) % le];
                            if (P[i]._end) {
                                P[i]._end = false;
                                node._end = true;
                            }

                            break;
                        }
                    }
                }
            }
        },

        _getStatus: function(P, path) {
            var status;
            while (P.intersection) {
                if (P._end) {
                    break;
                }
                P = P._next;
            }
            if (this.windingNumber(P.coords.usrCoords, path) % 2 === 0) {
                // Outside
                status = 'entry';
            } else {
                // Inside
                status = 'exit';
            }

            return [P, status];
        },

        /**
         * Mark the intersection vertices of path1 as entry points or as exit points
         * in respect to path2.
         * <p>
         * This is the simple algorithm as in
         * Greiner, Günther; Kai Hormann (1998). "Efficient clipping of arbitrary polygons".
         * ACM Transactions on Graphics. 17 (2): 71–83
         * <p>
         * The algorithm handles also "delayed crossings" from
         * Erich, L. Foster, and Kai Hormann, Kai, and Romeo Traaian Popa (2019),
         * "Clipping simple polygons with degenerate intersections", Computers & Graphics:X, 2.
         * and - as an additional improvement -
         * handles self intersections of delayed crossings (A.W. 2021).
         *
         * @private
         * @param  {Array} path1 First path
         * @param  {Array} path2 Second path
         */
        markEntryExit: function(path1, path2, starters) {
            var status, P, cnt, res,
                i, len, start,
                chain_start = null,
                intersection_chain = 0,
                DEBUG = false;

            len = starters.length;
            for (i = 0; i < len; i++) {
                start = starters[i];
                if (DEBUG) {
                    console.log("\n;;;;;;;;;; Labelling phase",
                        (Type.exists(path1[start].data))?path1[start].data.pathname:' ',
                        path1[start].coords.usrCoords);
                }
                this._classifyDegenerateIntersections(path1[start]);
                this._handleIntersectionChains(path1[start]);
                if (DEBUG) {
                    console.log("\n---- back to markEntryExit");
                }

                // Decide if the first point of the component is inside or outside
                // of the other path.
                res = this._getStatus(path1[start], path2);
                P = res[0];
                status = res[1];
                if (DEBUG) {
                    console.log("Start node:", P.coords.usrCoords, status);
                }

                P._starter = true;

                // Greiner-Hormann entry/exit algorithm
                // with additional handling of delayed crossing / bouncing
                cnt = 0;
                chain_start = null;
                intersection_chain = 0;

                while (true) {
                    if (P.intersection === true) {
                        if (P.data.type === 'X' && intersection_chain === 1) {
                            // While we are in an intersection chain, i.e. a delayed crossing,
                            // we stumble on a crossing intersection.
                            // Probably, the other path is self intersecting.
                            // We end the intersection chain here and
                            // mark this event by setting intersection_chain = 2.
                            chain_start.entry_exit = status;
                            if (status === 'exit') {
                                chain_start.data.type = 'X';
                            }
                            intersection_chain = 2;
                        }

                        if (P.data.type === 'X' || P.data.type === 'DB') {
                            P.entry_exit = status;
                            status = (status === 'entry') ? 'exit' : 'entry';
                            if (DEBUG) {
                                console.log("mark:", P.coords.usrCoords, P.data.type, P.entry_exit);
                            }
                        }

                        if (P.data.type === 'DX') {
                            if (intersection_chain === 0) {
                                // Start of intersection chain.
                                // No active intersection chain yet,
                                // i.e. we did not pass a the first node of a delayed crossing.
                                chain_start = P;
                                intersection_chain = 1;
                                if (DEBUG) {
                                    console.log("Start intersection chain:", P.coords.usrCoords, P.data.type, status);
                                }

                            } else if (intersection_chain === 1) {
                                // Active intersection chain (intersection_chain===1)!
                                // End of delayed crossing chain reached
                                P.entry_exit = status;
                                chain_start.entry_exit = status;
                                if (status === 'exit') {
                                    chain_start.data.type = 'X';
                                } else {
                                    P.data.type = 'X';
                                }
                                status = (status === 'entry') ? 'exit' : 'entry';

                                if (DEBUG) {
                                    console.log("mark':", chain_start.coords.usrCoords, chain_start.data.type, chain_start.entry_exit);
                                    console.log("mark:", P.coords.usrCoords, P.data.type, P.entry_exit);
                                }
                                chain_start = null;
                                intersection_chain = 0;

                            } else if (intersection_chain === 2) {
                                // The delayed crossing had been interrupted by a crossing intersection.
                                // Now we treat the end of the delayed crossing as regular crossing.
                                P.entry_exit = status;
                                P.data.type = 'X';
                                status = (status === 'entry') ? 'exit' : 'entry';
                                chain_start = null;
                                intersection_chain = 0;
                            }
                        }
                    }

                    P = P._next;
                    if (Type.exists(P._starter) || cnt > 10000) {
                            break;
                    }

                    cnt++;
                }
            }
        },

        /**
         *
         * @private
         * @param {Array} P
         * @param {Boolean} isBackward
         * @returns {Boolean} True, if the node is an intersection and is of type 'X'
         */
        _stayOnPath: function(P, status) {
            var stay = true;

            if (P.intersection && P.data.type !== 'B') {
                stay = (status === P.entry_exit);
            }
            return stay;
        },

        /**
         * Add a point to the clipping path and returns if the algorithms
         * arrived at an intersection point which has already been visited.
         * In this case, true is returned.
         *
         * @param {Array} path Resulting path
         * @param {JXG.Math.Clip.Vertex} vertex Point to be added
         * @param {Boolean} DEBUG debug output to console.log
         * @returns {Boolean} true: point has been visited before, false otherwise
         * @private
         */
        _addVertex: function(path, vertex, DEBUG) {
            if (!isNaN(vertex.coords.usrCoords[1]) && !isNaN(vertex.coords.usrCoords[2])) {
                path.push(vertex);
            }
            if (vertex.intersection && vertex.data.done) {
                if (DEBUG) {
                    console.log("Add last intersection point", vertex.coords.usrCoords,
                        "on", vertex.data.pathname, vertex.entry_exit,
                        vertex.data.type);
                }
                return true;
            }
            if (vertex.intersection) {
                vertex.data.done = true;

                if (DEBUG) {
                    console.log("Add intersection point", vertex.coords.usrCoords,
                        "on", vertex.data.pathname, vertex.entry_exit,
                        vertex.data.type);
                }
            }
            return false;
        },

        /**
         * Tracing phase of the Greiner-Hormann algorithm, see
         * Greiner, Günther; Kai Hormann (1998).
         * "Efficient clipping of arbitrary polygons". ACM Transactions on Graphics. 17 (2): 71–83
         *
         * Boolean operations on polygons are distinguished: 'intersection', 'union', 'difference'.
         *
         * @private
         * @param  {Array} S           Subject path
         * @param  {Array} S_intersect Array containing the intersection vertices of the subject path
         * @param  {String} clip_type  contains the Boolean operation: 'intersection', 'union', or 'difference'
         * @return {Array}             Array consisting of two arrays containing the x-coordinates and the y-coordintaes of
         *      the resulting path.
         */
        tracing: function(S, S_intersect, clip_type) {
            var P, current, start,
                cnt = 0,
                status,
                maxCnt = 10000,
                S_idx = 0,
                path = [],
                done = false,
                DEBUG = false;

            if (DEBUG) {
                console.log("\n------ Start Phase 3");
            }

            // reverse = (clip_type === 'difference' || clip_type === 'union') ? true : false;
            while (S_idx < S_intersect.length && cnt < maxCnt) {
                // Take the first intersection node of the subject path
                // which is not yet included as start point.
                current = S_intersect[S_idx];
                if (current.data.done || current.data.type !== 'X' /*|| !this._isCrossing(current, reverse)*/) {
                    S_idx++;
                    continue;
                }

                if (DEBUG) {
                    console.log("\nStart", current.data.pathname, current.coords.usrCoords, current.data.type, current.entry_exit, S_idx);
                }
                if (path.length > 0) {    // Add a new path
                    path.push([NaN, NaN]);
                }

                // Start now the tracing with that node of the subject path
                start = current.data.idx;
                P = S;

                done = this._addVertex(path, current, DEBUG);
                status = current.entry_exit;
                do {
                    if (done) {
                        break;
                    }
                    //
                    // Decide if we follow the current path forward or backward.
                    // for example, in case the clipping is of type "intersection"
                    // and the current intersection node is of type entry, we go forward.
                    //
                    if ((clip_type === 'intersection' && current.entry_exit === 'entry') ||
                        (clip_type === 'union' && current.entry_exit === 'exit') ||
                        (clip_type === 'difference' && (P === S) === (current.entry_exit === 'exit')) ) {

                        if (DEBUG) {
                            console.log("Go forward on", current.data.pathname, current.entry_exit);
                        }

                        //
                        // Take the next nodes and add them to the path
                        // as long as they are not intersection nodes of type 'X'.
                        //
                        do {
                            current = current._next;
                            done = this._addVertex(path, current, DEBUG);
                            if (done) {
                                break;
                            }
                        } while (this._stayOnPath(current, status));
                        cnt++;
                    } else {
                        if (DEBUG) {
                            console.log("Go backward on", current.data.pathname);
                        }
                        //
                        // Here, we go backward:
                        // Take the previous nodes and add them to the path
                        // as long as they are not intersection nodes of type 'X'.
                        //
                        do {
                            current = current._prev;
                            done = this._addVertex(path, current, DEBUG);
                            if (done) {
                                break;
                            }
                        } while (this._stayOnPath(current, status));
                        cnt++;
                    }

                    if (done) {
                        break;
                    }

                    if (!current.neighbour) {
                        console.log("Tracing: emergency break - no neighbour!!!!!!!!!!!!!!!!!", cnt);
                        return [[0], [0]];
                    }
                    //
                    // We stopped the forward or backward loop, because we've
                    // arrived at a crossing intersection node, i.e. we have to
                    // switch to the other path now.
                    if (DEBUG) {
                        console.log("Switch from", current.coords.usrCoords, current.data.pathname, "to",
                        current.neighbour.coords.usrCoords, "on", current.neighbour.data.pathname);
                    }
                    current = current.neighbour;
                    if (current.data.done) {
                        break;
                    }
                    current.data.done = true;
                    status = current.entry_exit;

                    // if (current.data.done) {
                    //     // We arrived at an intersection node which is already
                    //     // added to the clipping path.
                    //     // We add it again to close the clipping path and jump out of the
                    //     // loop.
                    //     path.push(current);
                    //     if (DEBUG) {
                    //         console.log("Push last", current.coords.usrCoords);
                    //     }
                    //     break;
                    // }
                    P = current.data.path;

                    // Polygon closed:
                    // if (DEBUG) {
                    //     console.log("End of loop:", "start=", start, "idx=", current.data.idx);
                    // }
                // } while (!(current.data.pathname === 'S' && current.data.idx === start) && cnt < maxCnt);
                } while (current.data.idx !== start && cnt < maxCnt);

                if (cnt >= maxCnt) {
                    console.log("Tracing: stopping an infinite loop!", cnt);
                }

                S_idx++;
            }
            return this._getCoordsArrays(path, false);
        },

        /**
         * Handle path clipping if one of the two paths is empty.
         * @private
         * @param  {Array} S        First path, array of JXG.Coords
         * @param  {Array} C        Second path, array of JXG.Coords
         * @param  {String} clip_type Type of Boolean operation: 'intersection', 'union', 'differrence'.
         * @return {Boolean}        true, if one of the input paths is empty, false otherwise.
         */
        isEmptyCase: function(S, C, clip_type) {
            if (clip_type === 'intersection' && (S.length === 0 || C.length === 0)) {
                return true;
            }
            if (clip_type === 'union' && (S.length === 0 && C.length === 0)) {
                return true;
            }
            if (clip_type === 'difference' && S.length === 0) {
                return true;
            }

            return false;
        },

        _getCoordsArrays: function(path, doClose) {
            var pathX = [],
                pathY = [],
                i, le = path.length;

            for (i = 0; i < le; i++) {
                if (path[i].coords) {
                    pathX.push(path[i].coords.usrCoords[1]);
                    pathY.push(path[i].coords.usrCoords[2]);
                } else {
                    pathX.push(path[i][0]);
                    pathY.push(path[i][1]);
                }
            }
            if (doClose && le > 0) {
                if (path[0].coords) {
                    pathX.push(path[0].coords.usrCoords[1]);
                    pathY.push(path[0].coords.usrCoords[2]);
                } else {
                    pathX.push(path[0][0]);
                    pathY.push(path[0][1]);
                }
            }

            return [pathX, pathY];
        },

        /**
         * Handle cases when there are no intersection points of the two paths. This is the case if the
         * paths are disjoint or one is contained in the other.
         * @private
         * @param  {Array} S        First path, array of JXG.Coords
         * @param  {Array} C        Second path, array of JXG.Coords
         * @param  {String} clip_type Type of Boolean operation: 'intersection', 'union', 'differrence'.
         * @return {Array}          Array consisting of two arrays containing the x-coordinates and the y-coordinates of
         *      the resulting path.
         */
        handleEmptyIntersection: function(S, C, clip_type) {
            var P, Q,
                doClose = false,
                path = [];

            // Handle trivial cases
            if (S.length === 0) {
                if (clip_type === 'union') {
                    // S cup C = C
                    path = C;
                } else {
                    // S cap C = S \ C = {}
                    path = [];
                }
                return this._getCoordsArrays(path, true);
            }
            if (C.length === 0) {
                if (clip_type === 'intersection') {
                    // S cap C = {}
                    path = [];
                } else {
                    // S cup C = S \ C = S
                    path = S;
                }
                return this._getCoordsArrays(path, true);
            }

            // From now on, both paths have non-zero length.
            // The two paths have no crossing intersections,
            // but there might be bouncing intersections.

            // First, we find -- if possible -- on each path a point which is not an intersection point.
            if (S.length > 0) {
                P = S[0];
                while (P.intersection) {
                    P = P._next;
                    if (P._end) {
                        break;
                    }
                }
            }
            if (C.length > 0) {
                Q = C[0];
                while (Q.intersection) {
                    Q = Q._next;
                    if (Q._end) {
                        break;
                    }
                }
            }

            // Test if one curve is contained by the other
            if (this.windingNumber(P.coords.usrCoords, C) === 0) {
                // P is outside of C:
                // Either S is disjoint from C or C is inside of S
                if (this.windingNumber(Q.coords.usrCoords, S) !== 0) {
                    // C is inside of S, i.e. C subset of S

                    if (clip_type === 'union') {
                        path = path.concat(S);
                        path.push(S[0]);
                    } else if (clip_type === 'difference') {
                        path = path.concat(S);
                        path.push(S[0]);
                        if (Geometry.signedPolygon(S) * Geometry.signedPolygon(C) > 0) {
                            // Pathes have same orientation, we have to revert one.
                            path.reverse();
                        }
                        path.push([NaN, NaN]);
                    }
                    if (clip_type === 'difference' || clip_type === 'intersection') {
                        path = path.concat(C);
                        path.push(C[0]);
                        doClose = false;
                    }
                } else {                                           // The curves are disjoint
                    if (clip_type === 'difference') {
                        path = path.concat(S);
                        doClose = true;
                    } else if (clip_type === 'union') {
                        path = path.concat(S);
                        path.push(S[0]);
                        path.push([NaN, NaN]);
                        path = path.concat(C);
                        path.push(C[0]);
                    }
                }
            } else {
                                                                    // S inside of C, i.e. S subset of C
                if (clip_type === 'intersection') {
                    path = path.concat(S);
                    doClose = true;
                } else if (clip_type === 'union') {
                    path = path.concat(C);
                    path.push(C[0]);
                }

                // 'difference': path is empty
            }

            return this._getCoordsArrays(path, doClose);
        },

        /**
         * Count intersection points of type 'X'.
         * @param {JXG.Mat.Clip.Vertex} intersections
         * @returns Number
         * @private
         */
        _countCrossingIntersections: function(intersections) {
            var i,
                le = intersections.length,
                sum = 0;

            for (i = 0; i  < le; i++) {
                if (intersections[i].data.type === 'X') {
                    sum++;
                }
            }
            return sum;
        },

        /**
         * Create path from all sorts of input elements and convert it
         * to a suitable input path for greinerHormann().
         *
         * @private
         * @param {Object} obj Maybe curve, arc, sector, circle, polygon, array of points, array of JXG.Coords,
         * array of coordinate pairs.
         * @param  {JXG.Board} board   JSXGraph board object. It is needed to convert between
         * user coordinates and screen coordinates.
         * @returns {Array} Array of JXG.Coords elements containing a path.
         * @see JXG.Math.Clip#greinerHormann
         */
        _getPath: function(obj, board) {
            var i, len, r, rad, angle, alpha,
                steps,
                S = [];

            // Collect all points into path array S
            if (obj.elementClass === Const.OBJECT_CLASS_CURVE &&
                (obj.type === Const.OBJECT_TYPE_ARC || obj.type === Const.OBJECT_TYPE_SECTOR)) {
                angle = Geometry.rad(obj.radiuspoint, obj.center, obj.anglepoint);
                steps = Math.floor(angle * 180 / Math.PI);
                r = obj.Radius();
                rad = angle / steps;
                alpha = Math.atan2(obj.radiuspoint.coords.usrCoords[2] - obj.center.coords.usrCoords[2],
                    obj.radiuspoint.coords.usrCoords[1] - obj.center.coords.usrCoords[1]);

                if (obj.type === Const.OBJECT_TYPE_SECTOR) {
                    this._addToList(S, obj.center.coords, 0);
                }
                for (i = 0; i <= steps; i++) {
                    this._addToList(S, new Coords(Const.COORDS_BY_USER, [
                        obj.center.coords.usrCoords[0],
                        obj.center.coords.usrCoords[1] + Math.cos(i * rad + alpha) * r,
                        obj.center.coords.usrCoords[2] + Math.sin(i * rad + alpha) * r
                    ], board), i + 1);
                }
                if (obj.type === Const.OBJECT_TYPE_SECTOR) {
                    this._addToList(S, obj.center.coords, steps + 2);
                }

            } else if (obj.elementClass === Const.OBJECT_CLASS_CURVE && Type.exists(obj.points)) {
                len = obj.numberPoints;
                for (i = 0; i < len; i++) {
                    this._addToList(S, obj.points[i], i);
                }
            } else if (obj.type === Const.OBJECT_TYPE_POLYGON) {
                for (i = 0; i < obj.vertices.length; i++) {
                    this._addToList(S, obj.vertices[i].coords, i);
                }
            } else if (obj.elementClass === Const.OBJECT_CLASS_CIRCLE) {
                steps = 359;
                r = obj.Radius();
                rad = 2 * Math.PI / steps;
                for (i = 0; i <= steps; i++) {
                    this._addToList(S, new Coords(Const.COORDS_BY_USER, [
                        obj.center.coords.usrCoords[0],
                        obj.center.coords.usrCoords[1] + Math.cos(i * rad) * r,
                        obj.center.coords.usrCoords[2] + Math.sin(i * rad) * r
                    ], board), i);
                }
            } else if (Type.isArray(obj)) {
                len = obj.length;
                for (i = 0; i < len; i++) {
                    if (Type.exists(obj[i].coords)) {
                        // Point type
                        this._addToList(S, obj[i].coords, i);
                    } else if (Type.isArray(obj[i])) {
                        // Coordinate pair
                        this._addToList(S, new Coords(Const.COORDS_BY_USER, obj[i], board), i);
                    } else if (Type.exists(obj[i].usrCoords)) {
                        // JXG.Coordinates
                        this._addToList(S, obj[i], i);
                    }
                }
            }

            return S;
        },

        /**
         * Determine the intersection, union or difference of two closed paths.
         * <p>
         * This is an implementation of the Greiner-Hormann algorithm, see
         * Günther Greiner and Kai Hormann (1998).
         * "Efficient clipping of arbitrary polygons". ACM Transactions on Graphics. 17 (2): 71–83.
         * and
         * Erich, L. Foster, and Kai Hormann, Kai, and Romeo Traaian Popa (2019),
         * "Clipping simple polygons with degenerate intersections", Computers & Graphics:X, 2.
         * <p>
         * It is assumed that the pathes are closed, whereby it does not matter if the last point indeed
         * equals the first point. In contrast to the original Greiner-Hormann algorithm,
         * this algorithm can cope with many degenerate cases. A degenerate case is a vertext of one path
         * which is contained in the other path.
         * <p>
         *
         * <p>Problematic are:
         * <ul>
         *   <li>degenerate cases where one path additionally has self-intersections
         *   <li>differences with one path having self-intersections.
         * </ul>
         *
         * @param  {JXG.Circle|JXG.Curve|JXG.Polygon} subject   First closed path, usually called 'subject'.
         * Maybe curve, arc, sector, circle, polygon, array of points, array of JXG.Coords,
         * array of coordinate pairs.
         * @param  {JXG.Circle|JXG.Curve|JXG.Polygon} clip      Second closed path, usually called 'clip'.
         * Maybe curve, arc, sector, circle, polygon, array of points, array of JXG.Coords,
         * array of coordinate pairs.
         * @param  {String} clip_type Determines the type of boolean operation on the two paths.
         *  Possible values are 'intersection', 'union', or 'difference'.
         * @param  {JXG.Board} board   JSXGraph board object. It is needed to convert between
         * user coordinates and screen coordinates.
         * @return {Array}          Array consisting of two arrays containing the x-coordinates and the y-coordinates of
         *      the resulting path.
         *
         * @see JXG.Math.Clip#intersection
         * @see JXG.Math.Clip#union
         * @see JXG.Math.Clip#difference
         *
         * @example
         *     var curve1 = board.create('curve', [
         *             [-3, 3, 0, -3],
         *             [3, 3, 0, 3]
         *         ],
         *         {strokeColor: 'black'});
         *
         *     var curve2 = board.create('curve', [
         *             [-4, 4, 0, -4],
         *             [2, 2, 4, 2]
         *         ],
         *         {strokeColor: 'blue'});
         *
         *     var clip_path = board.create('curve', [[], []], {strokeWidth: 3, fillColor: 'yellow', fillOpacity: 0.6});
         *     clip_path.updateDataArray = function() {
         *         var a = JXG.Math.Clip.greinerHormann(curve2, curve1, 'intersection', this.board);
         *
         *         this.dataX = a[0];
         *         this.dataY = a[1];
         *     };
         *
         *     board.update();
         *
         * </pre><div id="JXG9d2a6acf-a43b-4035-8f8a-9b1bee580210" class="jxgbox" style="width: 300px; height: 300px;"></div>
         * <script type="text/javascript">
         *     (function() {
         *         var board = JXG.JSXGraph.initBoard('JXG9d2a6acf-a43b-4035-8f8a-9b1bee580210',
         *             {boundingbox: [-8, 8, 8,-8], axis: true, showcopyright: false, shownavigation: false});
         *
         *         var curve1 = board.create('curve', [
         *                 [-3, 3, 0, -3],
         *                 [3, 3, 0, 3]
         *             ],
         *             {strokeColor: 'black'});
         *
         *         var curve2 = board.create('curve', [
         *                 [-4, 4, 0, -4],
         *                 [2, 2, 4, 2]
         *             ],
         *             {strokeColor: 'blue'});
         *
         *         var clip_path = board.create('curve', [[], []], {strokeWidth: 3, fillColor: 'yellow', fillOpacity: 0.6});
         *         clip_path.updateDataArray = function() {
         *             var a = JXG.Math.Clip.greinerHormann(curve2, curve1, 'intersection', this.board);
         *
         *             this.dataX = a[0];
         *             this.dataY = a[1];
         *         };
         *
         *         board.update();
         *
         *     })();
         *
         * </script><pre>
         *
         * @example
         *     var curve1 = board.create('curve', [
         *             [-3, 3, 0, -3],
         *             [3, 3, 0, 3]
         *         ],
         *         {strokeColor: 'black', fillColor: 'none', fillOpacity: 0.8});
         *
         *     var curve2 = board.create('polygon', [[3, 4], [-4, 0], [-4, 4]],
         *             {strokeColor: 'blue', fillColor: 'none'});
         *
         *     var clip_path = board.create('curve', [[], []], {strokeWidth: 3, fillColor: 'yellow', fillOpacity: 0.6});
         *     clip_path.updateDataArray = function() {
         *         var a = JXG.Math.Clip.greinerHormann(curve1, curve2, 'union', this.board);
         *         this.dataX = a[0];
         *         this.dataY = a[1];
         *     };
         *
         *     board.update();
         *
         * </pre><div id="JXG6075c918-4d57-4b72-b600-6597a6a4f44e" class="jxgbox" style="width: 300px; height: 300px;"></div>
         * <script type="text/javascript">
         *     (function() {
         *         var board = JXG.JSXGraph.initBoard('JXG6075c918-4d57-4b72-b600-6597a6a4f44e',
         *             {boundingbox: [-8, 8, 8,-8], axis: true, showcopyright: false, shownavigation: false});
         *         var curve1 = board.create('curve', [
         *                 [-3, 3, 0, -3],
         *                 [3, 3, 0, 3]
         *             ],
         *             {strokeColor: 'black', fillColor: 'none', fillOpacity: 0.8});
         *
         *         var curve2 = board.create('polygon', [[3, 4], [-4, 0], [-4, 4]],
         *                 {strokeColor: 'blue', fillColor: 'none'});
         *
         *
         *         var clip_path = board.create('curve', [[], []], {strokeWidth: 3, fillColor: 'yellow', fillOpacity: 0.6});
         *         clip_path.updateDataArray = function() {
         *             var a = JXG.Math.Clip.greinerHormann(curve1, curve2, 'union', this.board);
         *             this.dataX = a[0];
         *             this.dataY = a[1];
         *         };
         *
         *         board.update();
         *
         *     })();
         *
         * </script><pre>
         *
         * @example
         *     var curve1 = board.create('curve', [
         *             [-4, 4, 0, -4],
         *             [4, 4, -2, 4]
         *         ],
         *         {strokeColor: 'black', fillColor: 'none', fillOpacity: 0.8});
         *
         *     var curve2 = board.create('circle', [[0, 0], [0, -2]],
         *             {strokeColor: 'blue', strokeWidth: 1, fillColor: 'red', fixed: true, fillOpacity: 0.3,
         *             center: {visible: true, size: 5}, point2: {size: 5}});
         *
         *     var clip_path = board.create('curve', [[], []], {strokeWidth: 3, fillColor: 'yellow', fillOpacity: 0.6});
         *     clip_path.updateDataArray = function() {
         *         var a = JXG.Math.Clip.greinerHormann(curve1, curve2, 'difference', this.board);
         *
         *         this.dataX = a[0];
         *         this.dataY = a[1];
         *     };
         *
         *     board.update();
         *
         * </pre><div id="JXG46b3316b-5ab9-4928-9473-ccb476ca4185" class="jxgbox" style="width: 300px; height: 300px;"></div>
         * <script type="text/javascript">
         *     (function() {
         *         var board = JXG.JSXGraph.initBoard('JXG46b3316b-5ab9-4928-9473-ccb476ca4185',
         *             {boundingbox: [-8, 8, 8,-8], axis: true, showcopyright: false, shownavigation: false});
         *         var curve1 = board.create('curve', [
         *                 [-4, 4, 0, -4],
         *                 [4, 4, -2, 4]
         *             ],
         *             {strokeColor: 'black', fillColor: 'none', fillOpacity: 0.8});
         *
         *         var curve2 = board.create('circle', [[0, 0], [0, -2]],
         *                 {strokeColor: 'blue', strokeWidth: 1, fillColor: 'red', fixed: true, fillOpacity: 0.3,
         *                 center: {visible: true, size: 5}, point2: {size: 5}});
         *
         *
         *         var clip_path = board.create('curve', [[], []], {strokeWidth: 3, fillColor: 'yellow', fillOpacity: 0.6});
         *         clip_path.updateDataArray = function() {
         *             var a = JXG.Math.Clip.greinerHormann(curve1, curve2, 'difference', this.board);
         *
         *             this.dataX = a[0];
         *             this.dataY = a[1];
         *         };
         *
         *         board.update();
         *
         *     })();
         *
         * </script><pre>
         *
         * @example
         * var clip_path = board.create('curve', [[], []], {strokeWidth: 1, fillColor: 'yellow', fillOpacity: 0.6});
         * clip_path.updateDataArray = function() {
         *     var bbox = this.board.getBoundingBox(),
         *         canvas, triangle;
         *
         *     canvas = [[bbox[0], bbox[1]], // ul
         *          [bbox[0], bbox[3]], // ll
         *          [bbox[2], bbox[3]], // lr
         *          [bbox[2], bbox[1]], // ur
         *          [bbox[0], bbox[1]]] // ul
         *     triangle = [[-1,1], [1,1], [0,-1], [-1,1]];
         *
         *     var a = JXG.Math.Clip.greinerHormann(canvas, triangle, 'difference', this.board);
         *     this.dataX = a[0];
         *     this.dataY = a[1];
         * };
         *
         * </pre><div id="JXGe94da07a-2a01-4498-ad62-f71a327f8e25" class="jxgbox" style="width: 300px; height: 300px;"></div>
         * <script type="text/javascript">
         *     (function() {
         *         var board = JXG.JSXGraph.initBoard('JXGe94da07a-2a01-4498-ad62-f71a327f8e25',
         *             {boundingbox: [-8, 8, 8,-8], axis: true, showcopyright: false, shownavigation: false});
         *     var clip_path = board.create('curve', [[], []], {strokeWidth: 1, fillColor: 'yellow', fillOpacity: 0.6});
         *     clip_path.updateDataArray = function() {
         *         var bbox = this.board.getBoundingBox(),
         *             canvas, triangle;
         *
         *         canvas = [[bbox[0], bbox[1]], // ul
         *              [bbox[0], bbox[3]], // ll
         *              [bbox[2], bbox[3]], // lr
         *              [bbox[2], bbox[1]], // ur
         *              [bbox[0], bbox[1]]] // ul
         *         triangle = [[-1,1], [1,1], [0,-1], [-1,1]];
         *
         *         var a = JXG.Math.Clip.greinerHormann(canvas, triangle, 'difference', this.board);
         *         this.dataX = a[0];
         *         this.dataY = a[1];
         *     };
         *
         *     })();
         *
         * </script><pre>
         *
         */
        greinerHormann: function(subject, clip, clip_type, board) { //},
                // subject_first_point_type, clip_first_point_type) {

            var len, S = [],
                C = [],
                S_intersect = [],
                // C_intersect = [],
                S_starters,
                C_starters,
                res = [],
                DEBUG = false;

            if (DEBUG) {
                console.log("\n------------ GREINER-HORMANN --------------");
            }
            // Collect all subject points into subject array S
            S = this._getPath(subject, board);
            len = S.length;
            if (len > 0 && Geometry.distance(S[0].coords.usrCoords, S[len - 1].coords.usrCoords, 3) < Mat.eps) {
                S.pop();
            }

            // Collect all points into clip array C
            C = this._getPath(clip, board);

            len = C.length;
            if (len > 0 && Geometry.distance(C[0].coords.usrCoords, C[len - 1].coords.usrCoords, 3) < Mat.eps * Mat.eps) {
                C.pop();
            }

            // Handle cases where at least one of the paths is empty
            if (this.isEmptyCase(S, C, clip_type)) {
                return [[], []];
            }

            // Add pointers for doubly linked lists
            S_starters = this.makeDoublyLinkedList(S);
            C_starters = this.makeDoublyLinkedList(C);

            if (DEBUG) {
                this._print_array(S);
                console.log("Components:", S_starters);
                this._print_array(C);
                console.log("Components:", C_starters);
            }

            res = this.findIntersections(S, C, board);
            S_intersect = res[0];

            this._handleFullyDegenerateCase(S, C, board);

            // Phase 2: mark intersection points as entry or exit points
            this.markEntryExit(S, C, S_starters);

            // if (S[0].coords.distance(Const.COORDS_BY_USER, C[0].coords) === 0) {
            //     // Randomly disturb the first point of the second path
            //     // if both paths start at the same point.
            //     C[0].usrCoords[1] *= 1 + Math.random() * 0.0001 - 0.00005;
            //     C[0].usrCoords[2] *= 1 + Math.random() * 0.0001 - 0.00005;
            // }
            this.markEntryExit(C, S, C_starters);

            // Handle cases without intersections
            if (this._countCrossingIntersections(S_intersect) === 0) {
                return this.handleEmptyIntersection(S, C, clip_type);
            }

            // Phase 3: tracing
            return this.tracing(S, S_intersect, clip_type);
        },

        /**
         * Union of two closed paths. The paths could be JSXGraph elements circle, curve, or polygon.
         * Computed by the Greiner-Hormann algorithm.
         *
         * @param  {JXG.Circle|JXG.Curve|JXG.Polygon} subject   First closed path.
         * @param  {JXG.Circle|JXG.Curve|JXG.Polygon} clip      Second closed path.
         * @param  {JXG.Board} board   JSXGraph board object. It is needed to convert between
         * user coordinates and screen coordinates.
         * @return {Array}          Array consisting of two arrays containing the x-coordinates and the y-coordinates of
         *      the resulting path.
         *
         * @see JXG.Math.Clip#greinerHormann
         * @see JXG.Math.Clip#intersection
         * @see JXG.Math.Clip#difference
         *
         * @example
         *     var curve1 = board.create('curve', [
         *             [-3, 3, 0, -3],
         *             [3, 3, 0, 3]
         *         ],
         *         {strokeColor: 'black'});
         *
         *     var curve2 = board.create('polygon', [[3, 4], [-4, 0], [-4, 4]],
         *             {strokeColor: 'blue', fillColor: 'none'});
         *
         *     var clip_path = board.create('curve', [[], []], {strokeWidth: 3, fillColor: 'yellow', fillOpacity: 0.3});
         *     clip_path.updateDataArray = function() {
         *         var a = JXG.Math.Clip.union(curve1, curve2, this.board);
         *         this.dataX = a[0];
         *         this.dataY = a[1];
         *     };
         *
         *     board.update();
         *
         * </pre><div id="JXG7c5204aa-3824-4464-819c-80df7bf1d917" class="jxgbox" style="width: 300px; height: 300px;"></div>
         * <script type="text/javascript">
         *     (function() {
         *         var board = JXG.JSXGraph.initBoard('JXG7c5204aa-3824-4464-819c-80df7bf1d917',
         *             {boundingbox: [-8, 8, 8,-8], axis: true, showcopyright: false, shownavigation: false});
         *         var curve1 = board.create('curve', [
         *                 [-3, 3, 0, -3],
         *                 [3, 3, 0, 3]
         *             ],
         *             {strokeColor: 'black'});
         *
         *         var curve2 = board.create('polygon', [[3, 4], [-4, 0], [-4, 4]],
         *                 {strokeColor: 'blue', fillColor: 'none'});
         *
         *
         *         var clip_path = board.create('curve', [[], []], {strokeWidth: 3, fillColor: 'yellow', fillOpacity: 0.3});
         *         clip_path.updateDataArray = function() {
         *             var a = JXG.Math.Clip.union(curve1, curve2, this.board);
         *             this.dataX = a[0];
         *             this.dataY = a[1];
         *         };
         *
         *         board.update();
         *
         *     })();
         *
         * </script><pre>
         *
         */
        union: function(path1, path2, board) {
            return this.greinerHormann(path1, path2, 'union', board);
        },

        /**
         * Intersection of two closed paths. The paths could be JSXGraph elements circle, curve, or polygon.
         * Computed by the Greiner-Hormann algorithm.
         *
         * @param  {JXG.Circle|JXG.Curve|JXG.Polygon} subject   First closed path.
         * @param  {JXG.Circle|JXG.Curve|JXG.Polygon} clip      Second closed path.
         * @param  {JXG.Board} board   JSXGraph board object. It is needed to convert between
         * user coordinates and screen coordinates.
         * @return {Array}          Array consisting of two arrays containing the x-coordinates and the y-coordinates of
         *      the resulting path.
         *
         * @see JXG.Math.Clip#greinerHormann
         * @see JXG.Math.Clip#union
         * @see JXG.Math.Clip#difference
         *
         * @example
         * var p = [];
         * p.push(board.create('point', [0, -5]));
         * p.push(board.create('point', [-5, 0]));
         * p.push(board.create('point', [-3, 3]));
         *
         * var curve1 = board.create('ellipse', p,
         *                 {strokeColor: 'black'});
         *
         * var curve2 = board.create('curve', [function(phi){return 4 * Math.cos(2*phi); },
         *                                     [0, 0],
         *                                     0, 2 * Math.PI],
         *                       {curveType:'polar', strokeColor: 'blue', strokewidth:1});
         *
         * var clip_path = board.create('curve', [[], []], {strokeWidth: 3, fillColor: 'yellow', fillOpacity: 0.3});
         * clip_path.updateDataArray = function() {
         *     var a = JXG.Math.Clip.intersection(curve2, curve1, this.board);
         *
         *     this.dataX = a[0];
         *     this.dataY = a[1];
         * };
         *
         * board.update();
         *
         * </pre><div id="JXG7ad547eb-7b6c-4a1a-a4d4-4ed298fc7998" class="jxgbox" style="width: 300px; height: 300px;"></div>
         * <script type="text/javascript">
         *     (function() {
         *         var board = JXG.JSXGraph.initBoard('JXG7ad547eb-7b6c-4a1a-a4d4-4ed298fc7998',
         *             {boundingbox: [-8, 8, 8,-8], axis: true, showcopyright: false, shownavigation: false});
         *     var p = [];
         *     p.push(board.create('point', [0, -5]));
         *     p.push(board.create('point', [-5, 0]));
         *     p.push(board.create('point', [-3, 3]));
         *
         *     var curve1 = board.create('ellipse', p,
         *                     {strokeColor: 'black'});
         *
         *     var curve2 = board.create('curve', [function(phi){return 4 * Math.cos(2*phi); },
         *                                         [0, 0],
         *                                         0, 2 * Math.PI],
         *                           {curveType:'polar', strokeColor: 'blue', strokewidth:1});
         *
         *
         *     var clip_path = board.create('curve', [[], []], {strokeWidth: 3, fillColor: 'yellow', fillOpacity: 0.3});
         *     clip_path.updateDataArray = function() {
         *         var a = JXG.Math.Clip.intersection(curve2, curve1, this.board);
         *
         *         this.dataX = a[0];
         *         this.dataY = a[1];
         *     };
         *
         *     board.update();
         *
         *     })();
         *
         * </script><pre>
         *
         *
         */
        intersection: function(path1, path2, board) {
            return this.greinerHormann(path1, path2, 'intersection', board);
        },

        /**
         * Difference of two closed paths, i.e. path1 minus path2.
         * The paths could be JSXGraph elements circle, curve, or polygon.
         * Computed by the Greiner-Hormann algorithm.
         *
         * @param  {JXG.Circle|JXG.Curve|JXG.Polygon} subject   First closed path.
         * @param  {JXG.Circle|JXG.Curve|JXG.Polygon} clip      Second closed path.
         * @param  {JXG.Board} board   JSXGraph board object. It is needed to convert between
         * user coordinates and screen coordinates.
         * @return {Array}          Array consisting of two arrays containing the x-coordinates and the y-coordinates of
         *      the resulting path.
         *
         * @see JXG.Math.Clip#greinerHormann
         * @see JXG.Math.Clip#intersection
         * @see JXG.Math.Clip#union
         *
         * @example
         *     var curve1 = board.create('polygon', [[-4, 4], [4, 4], [0, -1]],
         *             {strokeColor: 'blue', fillColor: 'none'});
         *
         *     var curve2 = board.create('curve', [
         *             [-1, 1, 0, -1],
         *             [1, 1, 3, 1]
         *         ],
         *         {strokeColor: 'black', fillColor: 'none', fillOpacity: 0.8});
         *
         *     var clip_path = board.create('curve', [[], []], {strokeWidth: 3, fillColor: 'yellow', fillOpacity: 0.3});
         *     clip_path.updateDataArray = function() {
         *         var a = JXG.Math.Clip.difference(curve1, curve2, this.board);
         *         this.dataX = a[0];
         *         this.dataY = a[1];
         *     };
         *
         *     board.update();
         *
         * </pre><div id="JXGc5ce6bb3-146c-457f-a48b-6b9081fb68a3" class="jxgbox" style="width: 300px; height: 300px;"></div>
         * <script type="text/javascript">
         *     (function() {
         *         var board = JXG.JSXGraph.initBoard('JXGc5ce6bb3-146c-457f-a48b-6b9081fb68a3',
         *             {boundingbox: [-8, 8, 8,-8], axis: true, showcopyright: false, shownavigation: false});
         *         var curve1 = board.create('polygon', [[-4, 4], [4, 4], [0, -1]],
         *                 {strokeColor: 'blue', fillColor: 'none'});
         *
         *         var curve2 = board.create('curve', [
         *                 [-1, 1, 0, -1],
         *                 [1, 1, 3, 1]
         *             ],
         *             {strokeColor: 'black', fillColor: 'none', fillOpacity: 0.8});
         *
         *
         *         var clip_path = board.create('curve', [[], []], {strokeWidth: 3, fillColor: 'yellow', fillOpacity: 0.3});
         *         clip_path.updateDataArray = function() {
         *             var a = JXG.Math.Clip.difference(curve1, curve2, this.board);
         *             this.dataX = a[0];
         *             this.dataY = a[1];
         *         };
         *
         *         board.update();
         *
         *     })();
         *
         * </script><pre>
         *
         */
        difference: function(path1, path2, board) {
            return this.greinerHormann(path1, path2, 'difference', board);
        }
    }; //);

    JXG.extend(Mat.Clip, /** @lends JXG.Math.Clip */ {
    });

    return Mat.Clip;
});

/*
    Copyright 2008-2022
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <http://www.gnu.org/licenses/>
    and <http://opensource.org/licenses/MIT/>.
 */


/*global JXG: true, define: true*/
/*jslint nomen: true, plusplus: true*/

/* depends:
 jxg
 math/math
 utils/type
 */

/**
 * @fileoverview In this file the namespace Math.Poly is defined, which holds algorithms to create and
 * manipulate polynomials.
 */

define('math/poly',['jxg', 'math/math', 'utils/type'], function (JXG, Mat, Type) {

    "use strict";

    /**
     * The JXG.Math.Poly namespace holds algorithms to create and manipulate polynomials.
     * @name JXG.Math.Poly
     * @exports Mat.Poly as JXG.Math.Poly
     * @namespace
     */
    Mat.Poly = {};

    /**
     * Define a polynomial ring over R.
     * @class
     * @name JXG.Math.Poly.Ring
     * @param {Array} variables List of indeterminates.
     */
    Mat.Poly.Ring = function (variables) {
        /**
         * A list of variables in this polynomial ring.
         * @type Array
         */
        this.vars = variables;
    };

    JXG.extend(Mat.Poly.Ring.prototype, /** @lends JXG.Math.Poly.Ring.prototype */ {
        // nothing yet.
    });


    /**
     * Define a monomial over the polynomial ring <tt>ring</tt>.
     * @class
     * @name JXG.Math.Poly.Monomial
     * @param {JXG.Math.Poly.Ring} ring
     * @param {Number} coefficient
     * @param {Array} exponents An array of exponents, corresponding to ring
     */
    Mat.Poly.Monomial = function (ring, coefficient, exponents) {
        var i;

        if (!Type.exists(ring)) {
            throw new Error('JSXGraph error: In JXG.Math.Poly.monomial missing parameter \'ring\'.');
        }

        if (!Type.isArray(exponents)) {
            exponents = [];
        }

        exponents = exponents.slice(0, ring.vars.length);

        for (i = exponents.length; i < ring.vars.length; i++) {
            exponents.push(0);
        }

        /**
         * A polynomial ring.
         * @type JXG.Math.Poly.Ring
         */
        this.ring = ring;

        /**
         * The monomial's coefficient
         * @type Number
         */
        this.coefficient = coefficient || 0;

        /**
         * Exponent vector, the order depends on the order of the variables
         * in the ring definition.
         * @type Array
         */
        this.exponents = Type.deepCopy(exponents);
    };

    JXG.extend(Mat.Poly.Monomial.prototype, /** @lends JXG.Math.Poly.Monomial.prototype */ {

        /**
         * Creates a deep copy of the monomial.
         *
         * @returns {JXG.Math.Poly.Monomial}
         *
         * @memberof JXG.Math.Poly.Monomial
         */
        copy: function () {
            return new Mat.Poly.Monomial(this.ring, this.coefficient, this.exponents);
        },

        /**
         * Print the monomial.
         * @returns {String} String representation of the monomial

         * @memberof JXG.Math.Poly.Monomial
         */
        print: function () {
            var s = [],
                i;

            for (i = 0; i < this.ring.vars.length; i++) {
                s.push(this.ring.vars[i] + '^' + this.exponents[i]);
            }

            return this.coefficient + '*' + s.join('*');
        }
    });


    /**
     * A polynomial is a sum of monomials.
     * @class
     * @name JXG.Math.Poly.Polynomial
     * @param {JXG.Math.Poly.Ring} ring A polynomial ring.
     * @param {String} str TODO String representation of the polynomial, will be parsed.
     */
    Mat.Poly.Polynomial = function (ring, str) {
        var parse = function () {

            },
            mons;

        if (!Type.exists(ring)) {
            throw new Error('JSXGraph error: In JXG.Math.Poly.polynomial missing parameter \'ring\'.');
        }

        if (Type.exists(str) && Type.isString(str)) {
            mons = parse(str);
        } else {
            mons = [];
        }

        /**
         * A polynomial ring.
         * @type JXG.Math.Poly.Ring
         */
        this.ring = ring;

        /**
         * List of monomials.
         * @type Array
         */
        this.monomials = mons;
    };

    JXG.extend(Mat.Poly.Polynomial.prototype, /** @lends JXG.Math.Poly.Polynomial.prototype */ {
        /**
         * Find a monomial with the given signature, i.e. exponent vector.
         * @param {Array} sig An array of numbers
         * @returns {Number} The index of the first monomial with the given signature, or -1
         * if no monomial could be found.
         * @memberof JXG.Math.Poly.Polynomial
         */
        findSignature: function (sig) {
            var i;

            for (i = 0; i < this.monomials.length; i++) {
                if (Type.cmpArrays(this.monomials[i].exponents, sig)) {
                    return i;
                }
            }

            return -1;
        },

        /**
         * Adds a monomial to the polynomial. Checks the existing monomials for the added
         * monomial's signature and just adds the coefficient if one is found.
         * @param {JXG.Math.Poly.Monomial} m
         * @param {Number} factor Either <tt>1</tt> or <tt>-1</tt>.
         * @memberof JXG.Math.Poly.Polynomial
         */
        addSubMonomial: function (m, factor) {
            var i;

            i = this.findSignature(m.exponents);
            if (i > -1) {
                this.monomials[i].coefficient += factor * m.coefficient;
            } else {
                m.coefficient *= factor;
                this.monomials.push(m);
            }
        },

        /**
         * Adds another polynomial or monomial to this one and merges them by checking for the
         * signature of each new monomial in the existing monomials.
         * @param {JXG.Math.Poly.Polynomial|JXG.Math.Poly.Monomial} mp
         * @memberof JXG.Math.Poly.Polynomial
         */
        add: function (mp) {
            var i;

            if (Type.exists(mp) && mp.ring === this.ring) {
                if (Type.isArray(mp.exponents)) {
                    // mp is a monomial
                    this.addSubMonomial(mp, 1);
                } else {
                    // mp is a polynomial
                    for (i = 0; i < mp.monomials.length; i++) {
                        this.addSubMonomial(mp.monomials[i], 1);
                    }
                }
            } else {
                throw new Error('JSXGraph error: In JXG.Math.Poly.polynomial.add either summand is undefined or rings don\'t match.');
            }
        },

        /**
         * Subtracts another polynomial or monomial from this one and merges them by checking for the
         * signature of each new monomial in the existing monomials.
         * @param {JXG.Math.Poly.Polynomial|JXG.Math.Poly.Monomial} mp
         * @memberof JXG.Math.Poly.Polynomial
         */
        sub: function (mp) {
            var i;

            if (Type.exists(mp) && mp.ring === this.ring) {
                if (Type.isArray(mp.exponents)) {
                    // mp is a monomial
                    this.addSubMonomial(mp, -1);
                } else {
                    // mp is a polynomial
                    for (i = 0; i < mp.monomials.length; i++) {
                        this.addSubMonomial(mp.monomials[i], -1);
                    }
                }
            } else {
                throw new Error('JSXGraph error: In JXG.Math.Poly.polynomial.sub either summand is undefined or rings don\'t match.');
            }
        },

        /**
         * Creates a deep copy of the polynomial.
         * @returns {JXG.Math.Poly.Polynomial}
         * @memberof JXG.Math.Poly.Polynomial
         */
        copy: function () {
            var i, p;

            p = new Mat.Poly.Polynomial(this.ring);

            for (i = 0; i < this.monomials.length; i++) {
                p.monomials.push(this.monomials[i].copy());
            }
            return p;
        },

        /**
         * Prints the polynomial.
         * @returns {String} A string representation of the polynomial.
         * @memberof JXG.Math.Poly.Polynomial
         */
        print: function () {
            var s = [],
                i;

            for (i = 0; i < this.monomials.length; i++) {
                s.push('(' + this.monomials[i].print() + ')');
            }

            return s.join('+');
        }
    });

    return Mat.Poly;
});

/*
    Copyright 2008-2022
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <http://www.gnu.org/licenses/>
    and <http://opensource.org/licenses/MIT/>.
 */


/*global JXG: true, define: true*/
/*jslint nomen: true, plusplus: true*/

/* depends:
 jxg
 */

/**
 * @fileoverview A class for complex arithmetics JXG.Complex is defined in this
 * file. Also a namespace JXG.C is included to provide instance-independent
 * arithmetic functions.
 */

define('math/complex',['jxg', 'utils/type'], function (JXG, Type) {

    "use strict";

    /**
     * Creates a new complex number.
     * @class This class is for calculating with complex numbers.
     * @constructor
     * @param {Number} [x=0] Real part.
     * @param {Number} [y=0] Imaginary part.
     */
    JXG.Complex = function (x, y) {
        /**
         * This property is only to signalize that this object is of type JXG.Complex. Only
         * used internally to distinguish between normal JavaScript numbers and JXG.Complex numbers.
         * @type Boolean
         * @default true
         * @private
         */
        this.isComplex = true;

        /* is the first argument a complex number? if it is,
         * extract real and imaginary part. */
        if (x && x.isComplex) {
            y = x.imaginary;
            x = x.real;
        }

        /**
         * Real part of the complex number.
         * @type Number
         * @default 0
         */
        this.real = x || 0;

        /**
         * Imaginary part of the complex number.
         * @type Number
         * @default 0
         */
        this.imaginary = y || 0;

        /**
         * Absolute value in the polar form of the complex number. Currently unused.
         * @type Number
         */
        this.absval = 0;

        /**
         * Angle value in the polar form of the complex number. Currently unused.
         * @type Number
         */
        this.angle = 0;
    };

    JXG.extend(JXG.Complex.prototype, /** @lends JXG.Complex.prototype */ {
        /**
         * Converts a complex number into a string.
         * @returns {String} Formatted string containing the complex number in human readable form (algebraic form).
         */
        toString: function () {
            return this.real + ' + ' + this.imaginary + 'i';
        },

        /**
         * Add another complex number to this complex number.
         * @param {JXG.Complex,Number} c A JavaScript number or a JXG.Complex object to be added to the current object.
         * @returns {JXG.Complex} Reference to this complex number
         */
        add: function (c) {
            if (Type.isNumber(c)) {
                this.real += c;
            } else {
                this.real += c.real;
                this.imaginary += c.imaginary;
            }

            return this;
        },

        /**
         * Subtract another complex number from this complex number.
         * @param {JXG.Complex,Number} c A JavaScript number or a JXG.Complex object to subtract from the current object.
         * @returns {JXG.Complex} Reference to this complex number
         */
        sub: function (c) {
            if (Type.isNumber(c)) {
                this.real -= c;
            } else {
                this.real -= c.real;
                this.imaginary -= c.imaginary;
            }

            return this;
        },

        /**
         * Multiply another complex number to this complex number.
         * @param {JXG.Complex,Number} c A JavaScript number or a JXG.Complex object to
         * multiply with the current object.
         * @returns {JXG.Complex} Reference to this complex number
         */
        mult: function (c) {
            var re, im;

            if (Type.isNumber(c)) {
                this.real *= c;
                this.imaginary *= c;
            } else {
                re = this.real;
                im = this.imaginary;

                //  (a+ib)(x+iy) = ax-by + i(xb+ay)
                this.real = re * c.real - im * c.imaginary;
                this.imaginary = re * c.imaginary + im * c.real;
            }

            return this;
        },

        /**
         * Divide this complex number by the given complex number.
         * @param {JXG.Complex,Number} c A JavaScript number or a JXG.Complex object to
         * divide the current object by.
         * @returns {JXG.Complex} Reference to this complex number
         */
        div: function (c) {
            var denom, im, re;

            if (Type.isNumber(c)) {
                if (Math.abs(c) < Math.eps) {
                    this.real = Infinity;
                    this.imaginary = Infinity;

                    return this;
                }

                this.real /= c;
                this.imaginary /= c;
            } else {
                //  (a+ib)(x+iy) = ax-by + i(xb+ay)
                if ((Math.abs(c.real) < Math.eps) && (Math.abs(c.imaginary) < Math.eps)) {
                    this.real = Infinity;
                    this.imaginary = Infinity;

                    return this;
                }

                denom = c.real * c.real + c.imaginary * c.imaginary;

                re = this.real;
                im = this.imaginary;
                this.real = (re * c.real + im * c.imaginary) / denom;
                this.imaginary = (im * c.real - re * c.imaginary) / denom;
            }

            return this;
        },

        /**
         * Conjugate a complex number in place.
         * @returns {JXG.Complex} Reference to this complex number
         */
        conj: function () {
            this.imaginary *= -1;

            return this;
        }
    });

    /**
     * @description
     * JXG.C is the complex number (name)space. It provides functions to calculate with
     * complex numbers (defined in {@link JXG.Complex}). With this namespace you don't have to modify
     * your existing complex numbers, e.g. to add two complex numbers:
     * <pre class="code">   var z1 = new JXG.Complex(1, 0);
     *    var z2 = new JXG.Complex(0, 1);
     *    z = JXG.C.add(z1, z1);</pre>
     * z1 and z2 here remain unmodified. With the object oriented approach above this
     * section the code would look like:
     * <pre class="code">   var z1 = new JXG.Complex(1, 0);
     *    var z2 = new JXG.Complex(0, 1);
     *    var z = new JXG.Complex(z1);
     *    z.add(z2);</pre>
     * @namespace Namespace for the complex number arithmetic functions.
     */
    JXG.C = {};

    /**
     * Add two (complex) numbers z1 and z2 and return the result as a (complex) number.
     * @param {JXG.Complex,Number} z1 Summand
     * @param {JXG.Complex,Number} z2 Summand
     * @returns {JXG.Complex} A complex number equal to the sum of the given parameters.
     */
    JXG.C.add = function (z1, z2) {
        var z = new JXG.Complex(z1);
        z.add(z2);
        return z;
    };

    /**
     * Subtract two (complex) numbers z1 and z2 and return the result as a (complex) number.
     * @param {JXG.Complex,Number} z1 Minuend
     * @param {JXG.Complex,Number} z2 Subtrahend
     * @returns {JXG.Complex} A complex number equal to the difference of the given parameters.
     */
    JXG.C.sub = function (z1, z2) {
        var z = new JXG.Complex(z1);
        z.sub(z2);
        return z;
    };

    /**
     * Multiply two (complex) numbers z1 and z2 and return the result as a (complex) number.
     * @param {JXG.Complex,Number} z1 Factor
     * @param {JXG.Complex,Number} z2 Factor
     * @returns {JXG.Complex} A complex number equal to the product of the given parameters.
     */
    JXG.C.mult = function (z1, z2) {
        var z = new JXG.Complex(z1);
        z.mult(z2);
        return z;
    };

    /**
     * Divide two (complex) numbers z1 and z2 and return the result as a (complex) number.
     * @param {JXG.Complex,Number} z1 Dividend
     * @param {JXG.Complex,Number} z2 Divisor
     * @returns {JXG.Complex} A complex number equal to the quotient of the given parameters.
     */
    JXG.C.div = function (z1, z2) {
        var z = new JXG.Complex(z1);
        z.div(z2);
        return z;
    };

    /**
     * Conjugate a complex number and return the result.
     * @param {JXG.Complex,Number} z1 Complex number
     * @returns {JXG.Complex} A complex number equal to the conjugate of the given parameter.
     */
    JXG.C.conj = function (z1) {
        var z = new JXG.Complex(z1);
        z.conj();
        return z;
    };

    /**
     * Absolute value of a complex number.
     * @param {JXG.Complex,Number} z1 Complex number
     * @returns {Number} real number equal to the absolute value of the given parameter.
     */
    JXG.C.abs = function (z1) {
        var z = new JXG.Complex(z1);

        z.conj();
        z.mult(z1);

        return Math.sqrt(z.real);
    };

    JXG.Complex.C = JXG.C;

    return JXG.Complex;
});

/*
    Copyright 2008-2022
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Andreas Walter,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <http://www.gnu.org/licenses/>
    and <http://opensource.org/licenses/MIT/>.
 */

/*global JXG: true, define: true*/

/*jslint nomen: true, plusplus: true*/

/* depends:
 jxg
 utils/type
 math/math
 */

/**
 * Functions for color conversions. This was originally based on a class to parse color values by
 * Stoyan Stefanov <sstoo@gmail.com> (see http://www.phpied.com/rgb-color-parser-in-javascript/)
 */

define('utils/color',['jxg', 'utils/type', 'math/math'],
    function (JXG, Type, Mat) {

    "use strict";

    // private constants and helper functions

    // simple colors contains string color constants that can be used in various browser
    // in javascript
    var simpleColors = {
            aliceblue: 'f0f8ff',
            antiquewhite: 'faebd7',
            aqua: '00ffff',
            aquamarine: '7fffd4',
            azure: 'f0ffff',
            beige: 'f5f5dc',
            bisque: 'ffe4c4',
            black: '000000',
            blanchedalmond: 'ffebcd',
            blue: '0000ff',
            blueviolet: '8a2be2',
            brown: 'a52a2a',
            burlywood: 'deb887',
            cadetblue: '5f9ea0',
            chartreuse: '7fff00',
            chocolate: 'd2691e',
            coral: 'ff7f50',
            cornflowerblue: '6495ed',
            cornsilk: 'fff8dc',
            crimson: 'dc143c',
            cyan: '00ffff',
            darkblue: '00008b',
            darkcyan: '008b8b',
            darkgoldenrod: 'b8860b',
            darkgray: 'a9a9a9',
            darkgreen: '006400',
            darkkhaki: 'bdb76b',
            darkmagenta: '8b008b',
            darkolivegreen: '556b2f',
            darkorange: 'ff8c00',
            darkorchid: '9932cc',
            darkred: '8b0000',
            darksalmon: 'e9967a',
            darkseagreen: '8fbc8f',
            darkslateblue: '483d8b',
            darkslategray: '2f4f4f',
            darkturquoise: '00ced1',
            darkviolet: '9400d3',
            deeppink: 'ff1493',
            deepskyblue: '00bfff',
            dimgray: '696969',
            dodgerblue: '1e90ff',
            feldspar: 'd19275',
            firebrick: 'b22222',
            floralwhite: 'fffaf0',
            forestgreen: '228b22',
            fuchsia: 'ff00ff',
            gainsboro: 'dcdcdc',
            ghostwhite: 'f8f8ff',
            gold: 'ffd700',
            goldenrod: 'daa520',
            gray: '808080',
            green: '008000',
            greenyellow: 'adff2f',
            honeydew: 'f0fff0',
            hotpink: 'ff69b4',
            indianred: 'cd5c5c',
            indigo: '4b0082',
            ivory: 'fffff0',
            khaki: 'f0e68c',
            lavender: 'e6e6fa',
            lavenderblush: 'fff0f5',
            lawngreen: '7cfc00',
            lemonchiffon: 'fffacd',
            lightblue: 'add8e6',
            lightcoral: 'f08080',
            lightcyan: 'e0ffff',
            lightgoldenrodyellow: 'fafad2',
            lightgrey: 'd3d3d3',
            lightgreen: '90ee90',
            lightpink: 'ffb6c1',
            lightsalmon: 'ffa07a',
            lightseagreen: '20b2aa',
            lightskyblue: '87cefa',
            lightslateblue: '8470ff',
            lightslategray: '778899',
            lightsteelblue: 'b0c4de',
            lightyellow: 'ffffe0',
            lime: '00ff00',
            limegreen: '32cd32',
            linen: 'faf0e6',
            magenta: 'ff00ff',
            maroon: '800000',
            mediumaquamarine: '66cdaa',
            mediumblue: '0000cd',
            mediumorchid: 'ba55d3',
            mediumpurple: '9370d8',
            mediumseagreen: '3cb371',
            mediumslateblue: '7b68ee',
            mediumspringgreen: '00fa9a',
            mediumturquoise: '48d1cc',
            mediumvioletred: 'c71585',
            midnightblue: '191970',
            mintcream: 'f5fffa',
            mistyrose: 'ffe4e1',
            moccasin: 'ffe4b5',
            navajowhite: 'ffdead',
            navy: '000080',
            oldlace: 'fdf5e6',
            olive: '808000',
            olivedrab: '6b8e23',
            orange: 'ffa500',
            orangered: 'ff4500',
            orchid: 'da70d6',
            palegoldenrod: 'eee8aa',
            palegreen: '98fb98',
            paleturquoise: 'afeeee',
            palevioletred: 'd87093',
            papayawhip: 'ffefd5',
            peachpuff: 'ffdab9',
            peru: 'cd853f',
            pink: 'ffc0cb',
            plum: 'dda0dd',
            powderblue: 'b0e0e6',
            purple: '800080',
            red: 'ff0000',
            rosybrown: 'bc8f8f',
            royalblue: '4169e1',
            saddlebrown: '8b4513',
            salmon: 'fa8072',
            sandybrown: 'f4a460',
            seagreen: '2e8b57',
            seashell: 'fff5ee',
            sienna: 'a0522d',
            silver: 'c0c0c0',
            skyblue: '87ceeb',
            slateblue: '6a5acd',
            slategray: '708090',
            snow: 'fffafa',
            springgreen: '00ff7f',
            steelblue: '4682b4',
            tan: 'd2b48c',
            teal: '008080',
            thistle: 'd8bfd8',
            tomato: 'ff6347',
            turquoise: '40e0d0',
            violet: 'ee82ee',
            violetred: 'd02090',
            wheat: 'f5deb3',
            white: 'ffffff',
            whitesmoke: 'f5f5f5',
            yellow: 'ffff00',
            yellowgreen: '9acd32'
        },

        // array of color definition objects
        colorDefs = [{
            re: /^\s*rgba\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*([\d.]{1,3})\s*\)\s*$/,
            example: ['rgba(123, 234, 45, 0.5)', 'rgba(255,234,245,1.0)'],
            process: function (bits) {
                return [
                    parseInt(bits[1], 10),
                    parseInt(bits[2], 10),
                    parseInt(bits[3], 10)
                ];
            }
        }, {
            re: /^\s*rgb\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*\)\s*$/,
            example: ['rgb(123, 234, 45)', 'rgb(255,234,245)'],
            process: function (bits) {
                return [
                    parseInt(bits[1], 10),
                    parseInt(bits[2], 10),
                    parseInt(bits[3], 10)
                ];
            }
        }, {
            re: /^(\w{2})(\w{2})(\w{2})$/,
            example: ['#00ff00', '336699'],
            process: function (bits) {
                return [
                    parseInt(bits[1], 16),
                    parseInt(bits[2], 16),
                    parseInt(bits[3], 16)
                ];
            }
        }, {
            re: /^(\w{1})(\w{1})(\w{1})$/,
            example: ['#fb0', 'f0f'],
            process: function (bits) {
                return [
                    parseInt(bits[1] + bits[1], 16),
                    parseInt(bits[2] + bits[2], 16),
                    parseInt(bits[3] + bits[3], 16)
                ];
            }
        }];

    /**
     * Converts a valid HTML/CSS color string into a rgb value array. This is the base
     * function for the following wrapper functions which only adjust the output to
     * different flavors like an object, string or hex values.
     * @param {String,Array,Number} color A valid HTML or CSS styled color value, e.g. '#12ab21', '#abc', 'black',
     * or 'rgb(12, 132, 233)'. This can also be an array containing three color values either from 0.0 to 1.0 or
     * from 0 to 255. They will be interpreted as red, green, and blue values. In case this is a number this method
     * expects the parameters ag and ab.
     * @param {Number} ag
     * @param {Number} ab
     * @returns {Array} RGB color values as an array [r, g, b] with values ranging from 0 to 255.
     */
    JXG.rgbParser = function (color, ag, ab) {
        var color_string, channels, re, processor, bits, i,
            r, g, b,
            values = color,
            testFloat;

        if (!Type.exists(color)) {
            return [];
        }

        if (Type.exists(ag) && Type.exists(ab)) {
            values = [color, ag, ab];
        }

        color_string = values;

        testFloat = false;
        if (Type.isArray(color_string)) {
            for (i = 0; i < 3; i++) {
                testFloat = testFloat || /\./.test(values[i].toString());
            }

            for (i = 0; i < 3; i++) {
                testFloat = testFloat && (values[i] >= 0.0) && (values[i] <= 1.0);
            }

            if (testFloat) {
                return [Math.ceil(values[0] * 255), Math.ceil(values[1] * 255), Math.ceil(values[2] * 255)];
            }

            return values;
        }

        if (typeof values === 'string') {
            color_string = values;
        }

        // strip any leading #
        if (color_string.charAt(0) === '#') { // remove # if any
            color_string = color_string.substr(1, 6);
        }

        color_string = color_string.replace(/ /g, '').toLowerCase();

        // before getting into regexps, try simple matches
        // and overwrite the input
        color_string = simpleColors[color_string] || color_string;

        // search through the colorDefs definitions to find a match
        for (i = 0; i < colorDefs.length; i++) {
            re = colorDefs[i].re;
            processor = colorDefs[i].process;
            bits = re.exec(color_string);

            if (bits) {
                channels = processor(bits);
                r = channels[0];
                g = channels[1];
                b = channels[2];
            }

        }

        if (isNaN(r) || isNaN(g) || isNaN(b)) {
            return [];
        }

        // validate/cleanup values
        r = (r < 0 || isNaN(r)) ? 0 : ((r > 255) ? 255 : r);
        g = (g < 0 || isNaN(g)) ? 0 : ((g > 255) ? 255 : g);
        b = (b < 0 || isNaN(b)) ? 0 : ((b > 255) ? 255 : b);

        return [r, g, b];
    };

    /**
     * Converts a valid HTML/CSS color string into a string of the 'rgb(r, g, b)' format.
     * @param {String,Array,Number} color A valid HTML or CSS styled color value, e.g. '#12ab21', '#abc', 'black',
     * or 'rgb(12, 132, 233)'. This can also be an array containing three color values either from 0.0 to 1.0 or
     * from 0 to 255. They will be interpreted as red, green, and blue values. In case this is a number this method
     * expects the parameters ag and ab.
     * @param {Number} ag
     * @param {Number} ab
     * @returns {String} A 'rgb(r, g, b)' formatted string
     */
    JXG.rgb2css = function (color, ag, ab) {
        var r;

        r = JXG.rgbParser(color, ag, ab);

        return 'rgb(' + r[0] + ', ' + r[1] + ', ' + r[2] + ')';
    };

    /**
     * Converts a valid HTML/CSS color string into a HTML rgb string.
     * @param {String,Array,Number} color A valid HTML or CSS styled color value, e.g. '#12ab21', '#abc', 'black',
     * or 'rgb(12, 132, 233)'. This can also be an array containing three color values either from 0.0 to 1.0 or
     * from 0 to 255. They will be interpreted as red, green, and blue values. In case this is a number this method
     * expects the parameters ag and ab.
     * @param {Number} ag
     * @param {Number} ab
     * @returns {String} A '#rrggbb' formatted string
     */
    JXG.rgb2hex = function (color, ag, ab) {
        var r, g, b;

        r = JXG.rgbParser(color, ag, ab);
        g = r[1];
        b = r[2];
        r = r[0];
        r = r.toString(16);
        g = g.toString(16);
        b = b.toString(16);

        if (r.length === 1) {
            r = '0' + r;
        }

        if (g.length === 1) {
            g = '0' + g;
        }

        if (b.length === 1) {
            b = '0' + b;
        }

        return '#' + r + g + b;
    };

    /**
     * Converts a valid HTML/CSS color string from the '#rrggbb' format into the 'rgb(r, g, b)' format.
     * @param {String} hex A valid HTML or CSS styled color value, e.g. '#12ab21', '#abc', or 'black'
     * @deprecated Use {@link JXG#rgb2css} instead.
     * @returns {String} A 'rgb(r, g, b)' formatted string
     */
    JXG.hex2rgb = function (hex) {
        JXG.deprecated('JXG.hex2rgb()', 'JXG.rgb2css()');
        return JXG.rgb2css(hex);
    };

    /**
     * Converts HSV color to RGB color.
     * Based on C Code in "Computer Graphics -- Principles and Practice,"
     * Foley et al, 1996, p. 593.
     * See also http://www.efg2.com/Lab/Graphics/Colors/HSV.htm
     * @param {Number} H value between 0 and 360
     * @param {Number} S value between 0.0 (shade of gray) to 1.0 (pure color)
     * @param {Number} V value between 0.0 (black) to 1.0 (white)
     * @returns {String} RGB color string
     */
    JXG.hsv2rgb = function (H, S, V) {
        var R, G, B, f, i, hTemp, p, q, t;

        H = ((H % 360.0) + 360.0) % 360;

        if (S === 0) {
            if (isNaN(H) || H < Mat.eps) {
                R = V;
                G = V;
                B = V;
            } else {
                return '#ffffff';
            }
        } else {
            if (H >= 360) {
                hTemp = 0.0;
            } else {
                hTemp = H;
            }

            // h is now IN [0,6)
            hTemp = hTemp / 60;
            // largest integer <= h
            i = Math.floor(hTemp);
            // fractional part of h
            f = hTemp - i;
            p = V * (1.0 - S);
            q = V * (1.0 - (S * f));
            t = V * (1.0 - (S * (1.0 - f)));

            switch (i) {
                case 0:
                    R = V;
                    G = t;
                    B = p;
                    break;
                case 1:
                    R = q;
                    G = V;
                    B = p;
                    break;
                case 2:
                    R = p;
                    G = V;
                    B = t;
                    break;
                case 3:
                    R = p;
                    G = q;
                    B = V;
                    break;
                case 4:
                    R = t;
                    G = p;
                    B = V;
                    break;
                case 5:
                    R = V;
                    G = p;
                    B = q;
                    break;
            }
        }

        R = Math.round(R * 255).toString(16);
        R = (R.length === 2) ? R : ((R.length === 1) ? '0' + R : '00');
        G = Math.round(G * 255).toString(16);
        G = (G.length === 2) ? G : ((G.length === 1) ? '0' + G : '00');
        B = Math.round(B * 255).toString(16);
        B = (B.length === 2) ? B : ((B.length === 1) ? '0' + B : '00');

        return ['#', R, G, B].join('');
    };

    /**
     * Converts a color from the RGB color space into the HSV space. Input can be any valid HTML/CSS color definition.
     * @param {String,Array,Number} color A valid HTML or CSS styled color value, e.g. '#12ab21', '#abc', 'black',
     * or 'rgb(12, 132, 233)'. This can also be an array containing three color values either from 0.0 to 1.0 or
     * from 0 to 255. They will be interpreted as red, green, and blue values. In case this is a number this method
     * expects the parameters ag and ab.
     * @param {Number} ag
     * @param {Number} ab
     * @returns {Array} Contains the h, s, and v value in this order.
     * @see http://zach.in.tu-clausthal.de/teaching/cg1_0708/folien/13_color_3_4up.pdf
     */
    JXG.rgb2hsv = function (color, ag, ab) {
        var r, g, b, fr, fg, fb, fmax, fmin, h, s, v, max, min;

        r = JXG.rgbParser(color, ag, ab);

        g = r[1];
        b = r[2];
        r = r[0];
        fr = r / 255.0;
        fg = g / 255.0;
        fb = b / 255.0;
        max = Math.max(r, g, b);
        min = Math.min(r, g, b);
        fmax = max / 255.0;
        fmin = min / 255.0;

        v = fmax;
        s = 0.0;

        if (v > 0) {
            s = (v - fmin) / v;
        }

        h = 1.0 / (fmax - fmin);

        if (s > 0) {
            if (max === r) {
                h = (fg - fb) * h;
            } else if (max === g) {
                h = 2 + (fb - fr) * h;
            } else {
                h = 4 + (fr - fg) * h;
            }
        }

        h *= 60;

        if (h < 0) {
            h += 360;
        }

        if (max === min) {
            h = 0.0;
        }

        return [h, s, v];
    };

    /**
     * Converts a color from the RGB color space into the LMS space. Input can be any valid HTML/CSS color definition.
     * @param {String,Array,Number} color A valid HTML or CSS styled color value, e.g. '#12ab21', '#abc', 'black',
     * or 'rgb(12, 132, 233)'. This can also be an array containing three color values either from 0.0 to 1.0 or
     * from 0 to 255. They will be interpreted as red, green, and blue values. In case this is a number this method
     * expects the parameters ag and ab.
     * @param {Number} ag
     * @param {Number} ab
     * @returns {Array} Contains the l, m, and s value in this order.
     */
    JXG.rgb2LMS = function (color, ag, ab) {
        var r, g, b, l, m, s, ret,
            // constants
            matrix = [[0.05059983, 0.08585369, 0.00952420],
                [0.01893033, 0.08925308, 0.01370054],
                [0.00292202, 0.00975732, 0.07145979]];

        r = JXG.rgbParser(color, ag, ab);
        g = r[1];
        b = r[2];
        r = r[0];

        // de-gamma
        // Maybe this can be made faster by using a cache
        r = Math.pow(r, 0.476190476);
        g = Math.pow(g, 0.476190476);
        b = Math.pow(b, 0.476190476);

        l = r * matrix[0][0] + g * matrix[0][1] + b * matrix[0][2];
        m = r * matrix[1][0] + g * matrix[1][1] + b * matrix[1][2];
        s = r * matrix[2][0] + g * matrix[2][1] + b * matrix[2][2];

        ret = [l, m, s];
        ret.l = l;
        ret.m = m;
        ret.s = s;

        return ret;
    };

    /**
     * Convert color information from LMS to RGB color space.
     * @param {Number} l
     * @param {Number} m
     * @param {Number} s
     * @returns {Array} Contains the r, g, and b value in this order.
     */
    JXG.LMS2rgb = function (l, m, s) {
        var r, g, b, ret,
            // constants
            matrix = [[30.830854, -29.832659, 1.610474],
                [-6.481468, 17.715578, -2.532642],
                [-0.375690, -1.199062, 14.273846]],

            // re-gamma, inspired by GIMP modules/display-filter-color-blind.c:
            // Copyright (C) 2002-2003 Michael Natterer <mitch@gimp.org>,
            //                         Sven Neumann <sven@gimp.org>,
            //                         Robert Dougherty <bob@vischeck.com> and
            //                         Alex Wade <alex@vischeck.com>
            // This code is an implementation of an algorithm described by Hans Brettel,
            // Francoise Vienot and John Mollon in the Journal of the Optical Society of
            // America V14(10), pg 2647. (See http://vischeck.com/ for more info.)
            lut_lookup = function (value) {
                var offset = 127, step = 64;

                while (step > 0) {
                    if (Math.pow(offset, 0.476190476) > value) {
                        offset -= step;
                    } else {
                        if (Math.pow(offset + 1, 0.476190476) > value) {
                            return offset;
                        }

                        offset += step;
                    }

                    step /= 2;
                }

                /*  the algorithm above can't reach 255  */
                if (offset === 254 && 13.994955247 < value) {
                    return 255;
                }

                return offset;
            };

        // transform back to rgb
        r = l * matrix[0][0] + m * matrix[0][1] + s * matrix[0][2];
        g = l * matrix[1][0] + m * matrix[1][1] + s * matrix[1][2];
        b = l * matrix[2][0] + m * matrix[2][1] + s * matrix[2][2];

        r = lut_lookup(r);
        g = lut_lookup(g);
        b = lut_lookup(b);

        ret = [r, g, b];
        ret.r = r;
        ret.g = g;
        ret.b = b;

        return ret;
    };

    /**
     * Splits a RGBA color value like #112233AA into it's RGB and opacity parts.
     * @param {String} rgba A RGBA color value
     * @returns {Array} An array containing the rgb color value in the first and the opacity in the second field.
     */
    JXG.rgba2rgbo = function (rgba) {
        var opacity;

        if (rgba.length === 9 && rgba.charAt(0) === '#') {
            opacity = parseInt(rgba.substr(7, 2).toUpperCase(), 16) / 255;
            rgba = rgba.substr(0, 7);
        } else {
            opacity = 1;
        }

        return [rgba, opacity];
    };

    /**
     * Generates a RGBA color value like #112233AA from it's RGB and opacity parts.
     * @param {String} rgb A RGB color value.
     * @param {Number} o The desired opacity >=0, <=1.
     * @returns {String} The RGBA color value.
     */
    JXG.rgbo2rgba = function (rgb, o) {
        var rgba;

        if (rgb === 'none') {
            return rgb;
        }

        rgba = Math.round(o * 255).toString(16);
        if (rgba.length === 1) {
            rgba = "0" + rgba;
        }

        return rgb + rgba;
    };

    /**
     * Decolorizes the given color.
     * @param {String} color HTML string containing the HTML color code.
     * @returns {String} Returns a HTML color string
     */
    JXG.rgb2bw = function (color) {
        var x, tmp, arr,
            HexChars = "0123456789ABCDEF";

        if (color === 'none') {
            return color;
        }

        arr = JXG.rgbParser(color);
        x = Math.floor(0.3 * arr[0] + 0.59 * arr[1] + 0.11 * arr[2]);

        // rgbParser and Math.floor ensure that x is 0 <= x <= 255.
        // Bitwise operators can be used.
        /*jslint bitwise: true*/
        tmp = HexChars.charAt((x >> 4) & 0xf) + HexChars.charAt(x & 0xf);

        color = "#" + tmp + tmp + tmp;

        return color;
    };

    /**
     * Converts a color into how a colorblind human approximately would see it.
     * @param {String} color HTML string containing the HTML color code.
     * @param {String} deficiency The type of color blindness. Possible
     * options are <i>protanopia</i>, <i>deuteranopia</i>, and <i>tritanopia</i>.
     * @returns {String} Returns a HTML color string
     */
    JXG.rgb2cb = function (color, deficiency) {
        var rgb, l, m, s, lms, tmp,
            a1, b1, c1, a2, b2, c2,
            inflection,
            HexChars = "0123456789ABCDEF";

        if (color === 'none') {
            return color;
        }

        lms = JXG.rgb2LMS(color);
        l = lms[0];
        m = lms[1];
        s = lms[2];

        deficiency = deficiency.toLowerCase();

        switch (deficiency) {
            case "protanopia":
                a1 = -0.06150039994295001;
                b1 = 0.08277001656812001;
                c1 = -0.013200141220000003;
                a2 = 0.05858939668799999;
                b2 = -0.07934519995360001;
                c2 = 0.013289415272000003;
                inflection = 0.6903216543277437;

                tmp = s / m;

                if (tmp < inflection) {
                    l = -(b1 * m + c1 * s) / a1;
                } else {
                    l = -(b2 * m + c2 * s) / a2;
                }
                break;
            case "tritanopia":
                a1 = -0.00058973116217;
                b1 = 0.007690316482;
                c1 = -0.01011703519052;
                a2 = 0.025495080838999994;
                b2 = -0.0422740347;
                c2 = 0.017005316784;
                inflection = 0.8349489908460004;

                tmp = m / l;

                if (tmp < inflection) {
                    s = -(a1 * l + b1 * m) / c1;
                } else {
                    s = -(a2 * l + b2 * m) / c2;
                }
                break;
            default:
                a1 = -0.06150039994295001;
                b1 = 0.08277001656812001;
                c1 = -0.013200141220000003;
                a2 = 0.05858939668799999;
                b2 = -0.07934519995360001;
                c2 = 0.013289415272000003;
                inflection = 0.5763833686400911;

                tmp = s / l;

                if (tmp < inflection) {
                    m = -(a1 * l + c1 * s) / b1;
                } else {
                    m = -(a2 * l + c2 * s) / b2;
                }
                break;
        }

        rgb = JXG.LMS2rgb(l, m, s);

        // LMS2rgb returns an array of values ranging from 0 to 255 (both included)
        // bitwise operators are safe to use.
        /*jslint bitwise: true*/
        tmp = HexChars.charAt((rgb[0] >> 4) & 0xf) + HexChars.charAt(rgb[0] & 0xf);
        color = "#" + tmp;
        tmp = HexChars.charAt((rgb[1] >> 4) & 0xf) + HexChars.charAt(rgb[1] & 0xf);
        color += tmp;
        tmp = HexChars.charAt((rgb[2] >> 4) & 0xf) + HexChars.charAt(rgb[2] & 0xf);
        color += tmp;

        return color;
    };

    /**
     * Determines highlight color to a given color. Done by reducing (or increasing) the opacity.
     * @param {String} color HTML RGBA string containing the HTML color code.
     * @returns {String} Returns a HTML RGBA color string
     */
    JXG.autoHighlight = function (colstr) {
        var col = JXG.rgba2rgbo(colstr),
            c = col[0],
            opa = col[1];

        if (colstr.charAt(0) === '#') {
            if (opa < 0.3) {
                opa *= 1.8;
            } else {
                opa *= 0.4;
            }

            return JXG.rgbo2rgba(c, opa);
        }

        return colstr;
    };

    /**
     * Calculate whether a light or a dark color is needed as a contrast.
     * Especially useful to determine whether white or black font goes
     * better with a given background color.
     * @param {String} hexColor HEX value of color.
     * @param {String} [darkColor="#000000"] HEX string for a dark color.
     * @param {String} [lightColor="#ffffff"] HEX string for a light color.
     * @param {Number} [threshold=8]
     * @returns {String} Returns darkColor or lightColor.
     */
    JXG.contrast = function (hexColor, darkColor, lightColor, threshold) {
        var rgb,
            black = '#000000',
            rgbBlack,
            l1, l2,
            contrastRatio;

        darkColor = darkColor || '#000000';
        lightColor = lightColor || '#ffffff';
        threshold = threshold || 7;

        // hexColor RGB
        rgb = JXG.rgbParser(hexColor);

        // Black RGB
        rgbBlack = JXG.rgbParser(black);

        // Calc contrast ratio
        l1 = 0.2126 * Math.pow(rgb[0] / 255, 2.2) +
            0.7152 * Math.pow(rgb[1] / 255, 2.2) +
            0.0722 * Math.pow(rgb[2] / 255, 2.2);

        l2 = 0.2126 * Math.pow(rgbBlack[0] / 255, 2.2) +
            0.7152 * Math.pow(rgbBlack[1] / 255, 2.2) +
            0.0722 * Math.pow(rgbBlack[2] / 255, 2.2);

        if (l1 > l2) {
            contrastRatio = Math.floor((l1 + 0.05) / (l2 + 0.05));
        } else {
            contrastRatio = Math.floor((l2 + 0.05) / (l1 + 0.05));
        }
        contrastRatio = contrastRatio - 1;

        // If contrast is more than threshold, return darkColor
        if (contrastRatio > threshold) {
            return darkColor;
        }
        // if not, return lightColor.
        return lightColor;
    };

    /**
     * Use the color scheme of JSXGraph up to version 1.3.2.
     * This method has to be called before JXG.JSXGraph.initBoard();
     *
     * @see JXG.palette
     * @see JXG.paletteWong
     *
     * @example
     *
     * JXG.setClassicColors();
     * var board = JXG.JSXGraph.initBoard('jxgbox', {boundingbox: [-5, 5, 5,-5]});
     *
     */
    JXG.setClassicColors = function() {
        JXG.Options.elements.strokeColor = 'blue';
        JXG.Options.elements.fillColor = 'red';
        JXG.Options.hatch.strokeColor = 'blue';
        JXG.Options.angle.fillColor = '#ff7f00';
        JXG.Options.angle.highlightFillColor = '#ff7f00';
        JXG.Options.angle.strokeColor = '#ff7f00';
        JXG.Options.angle.label.strokeColor = 'blue';
        JXG.Options.arc.strokeColor = 'blue';
        JXG.Options.circle.center.fillColor = 'red';
        JXG.Options.circle.center.strokeColor = 'blue';
        JXG.Options.circumcircle.strokeColor = 'blue';
        JXG.Options.circumcircle.center.fillColor = 'red';
        JXG.Options.circumcircle.center.strokeColor = 'blue';
        JXG.Options.circumcirclearc.strokeColor = 'blue';
        JXG.Options.circumcirclesector.strokeColor = 'blue';
        JXG.Options.circumcirclesector.fillColor = 'green';
        JXG.Options.circumcirclesector.highlightFillColor = 'green';
        JXG.Options.conic.strokeColor = 'blue';
        JXG.Options.curve.strokeColor = 'blue';
        JXG.Options.incircle.strokeColor = 'blue';
        JXG.Options.incircle.center.fillColor = 'red';
        JXG.Options.incircle.center.strokeColor = 'blue';
        JXG.Options.inequality.fillColor = 'red';
        JXG.Options.integral.fillColor = 'red';
        JXG.Options.integral.curveLeft.color = 'red';
        JXG.Options.integral.curveRight.color = 'red';
        JXG.Options.line.strokeColor = 'blue';
        JXG.Options.point.fillColor = 'red';
        JXG.Options.point.strokeColor = 'red';
        JXG.Options.polygon.fillColor = 'green';
        JXG.Options.polygon.highlightFillColor = 'green';
        JXG.Options.polygon.vertices.strokeColor = 'red';
        JXG.Options.polygon.vertices.fillColor = 'red';
        JXG.Options.regularpolygon.fillColor = 'green';
        JXG.Options.regularpolygon.highlightFillColor = 'green';
        JXG.Options.regularpolygon.vertices.strokeColor = 'red';
        JXG.Options.regularpolygon.vertices.fillColor = 'red';
        JXG.Options.riemannsum.fillColor = 'yellow';
        JXG.Options.sector.fillColor = 'green';
        JXG.Options.sector.highlightFillColor = 'green';
        JXG.Options.semicircle.center.fillColor = 'red';
        JXG.Options.semicircle.center.strokeColor = 'blue';
        JXG.Options.slopetriangle.fillColor = 'red';
        JXG.Options.slopetriangle.highlightFillColor = 'red';
        JXG.Options.turtle.arrow.strokeColor = 'blue';
    };

    JXG.extend(JXG, /** @lends JXG */ {
        /**
         * Bang Wong color palette,
         * optimized for various type
         * of color blindness.
         * It contains values for
         * <ul>
         * <li> 'black'
         * <li> 'orange'
         * <li> 'skyblue'
         * <li> 'bluishgreen'
         * <li> 'yellow'
         * <li> 'darkblue'
         * <li> 'vermillion'
         * <li> 'reddishpurple'
         * </ul>
         *
         * As substitutes for standard colors, it contains the following aliases:
         *
         * <ul>
         * <li> black (= #000000)
         * <li> blue (= darkblue)
         * <li> green (= bluishgreen)
         * <li> purple (= reddishpurple)
         * <li> red (= vermillion)
         * <li> white (= #ffffff)
         * </ul>
         *
         * See <a href="https://www.nature.com/articles/nmeth.1618">Bang Wong: "Points of view: Color blindness"</a>
         * and
         * <a href="https://davidmathlogic.com/colorblind/">https://davidmathlogic.com/colorblind/</a>.
         *
         * @name JXG.paletteWong
         * @type Object
         * @see JXG.palette
         * @example
         * var p = board.create('line', [[-1, 1], [2, -3]], {strokeColor: JXG.paletteWong.yellow});
         */
        paletteWong: {
            black: '#000000',
            orange: '#E69F00',
            skyblue: '#56B4E9',
            bluishgreen: '#009E73',
            yellow: '#F0E442',
            darkblue: '#0072B2',
            vermillion: '#D55E00',
            reddishpurple: '#CC79A7',

            blue: '#0072B2',
            red: '#D55E00',   // vermillion
            green: '#009E73', // bluishgreen
            purple: '#CC79A7', // reddishpurple
            white: '#ffffff'
        }
    });

    /**
     * Default color palette.
     * Contains at least color values for
     * <ul>
     * <li> black
     * <li> blue
     * <li> green
     * <li> purple
     * <li> red
     * <li> white
     * <li> yellow
     * </ul>
     *
     * @name JXG.palette
     * @type Object
     * @default JXG.paletteWong
     * @see JXG.paletteWong
     *
     * @example
     *
     * var p = board.create('line', [[-1, 1], [2, -3]], {strokeColor: JXG.palette.yellow});
     *
     */
    JXG.palette = JXG.paletteWong;

    return JXG;
});

/*
    Copyright 2008-2022
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <http://www.gnu.org/licenses/>
    and <http://opensource.org/licenses/MIT/>.
 */


/*global JXG:true, define: true*/
/*jslint nomen: true, plusplus: true*/

/* depends:
 jxg
 base/constants
 math/math
 utils/color
 utils/type
 */

define('options',[
    'jxg', 'base/constants', 'math/math', 'utils/color', 'utils/type'
], function (JXG, Const, Mat, Color, Type) {

    "use strict";

    /**
     * Options Namespace
     * @description These are the default options of the board and of all geometry elements.
     * @namespace
     * @name JXG.Options
     */
    JXG.Options = {
        jc: {
            enabled: true,
            compile: true
        },

        /*
         * Options that are used directly within the board class
         */
        board: {
            /**#@+
             * @visprop
             */

            //updateType: 'hierarchical', // 'all'

            /**
             * Bounding box of the visible area in user coordinates.
             * It is an array consisting of four values:
             * [x<sub>1</sub>, y<sub>1</sub>, x<sub>2</sub>, y<sub>2</sub>]
             *
             * The canvas will be spanned from the upper left corner (<sub>1</sub>, y<sub>1</sub>)
             * to the lower right corner (x<sub>2</sub>, y<sub>2</sub>).
             *
             * @name JXG.Board#boundingbox
             * @type Array
             * @default [-5, 5, 5, -5]
             * @example
             * var board = JXG.JSXGraph.initBoard('jxgbox', {
             *         boundingbox: [-5, 5, 5, -5],
             *         axis: true
             *     });
             */
            boundingBox: [-5, 5, 5, -5],

            /**
             * Maximal bounding box of the visible area in user coordinates.
             * It is an array consisting of four values:
             * [x<sub>1</sub>, y<sub>1</sub>, x<sub>2</sub>, y<sub>2</sub>]
             *
             * The bounding box of the canvas must be inside of this maximal
             * boundings box.
             * @name JXG.Board#maxboundingbox
             * @type Array
             * @see JXG.Board#boundingbox
             * @default [-Infinity, Infinity, Infinity, -Infinity]
             *
             * @example
             * var board = JXG.JSXGraph.initBoard('jxgbox', {
             *         boundingbox: [-5, 5, 5, -5],
             *         maxboundingbox: [-8, 8, 8, -8],
             *         pan: {enabled: true},
             *         axis: true
             *     });
             *
             * </pre><div id="JXG065e2750-217c-48ed-a52b-7d7df6de7055" class="jxgbox" style="width: 300px; height: 300px;"></div>
             * <script type="text/javascript">
             *     (function() {
             *         var board = JXG.JSXGraph.initBoard('JXG065e2750-217c-48ed-a52b-7d7df6de7055', {
             *             showcopyright: false, shownavigation: false,
             *             boundingbox: [-5,5,5,-5],
             *             maxboundingbox: [-8,8,8,-8],
             *             pan: {enabled: true},
             *             axis:true
             *         });
             *
             *     })();
             *
             * </script><pre>
             *
             */
            maxBoundingBox: [-Infinity, Infinity, Infinity, -Infinity],

            /**
             * Additional zoom factor multiplied to {@link JXG.Board#zoomX} and {@link JXG.Board#zoomY}.
             *
             * @name JXG.Board#zoomFactor
             * @type Number
             * @default 1.0
             */
            zoomFactor: 1,

            /**
             * Zoom factor in horizontal direction.
             *
             * @name JXG.Board#zoomX
             * @see JXG.Board#zoomY
             * @type Number
             * @default 1.0
             */
            zoomX: 1,

            /**
             * Zoom factor in vertical direction.
             *
             * @name JXG.Board#zoomY
             * @see JXG.Board#zoomX
             * @type Number
             * @default 1.0
             */
            zoomY: 1,

            /**
             * Title string for the board.
             * Primarily used in an invisible text element which is adressed by
             * the attribute 'aria-labelledby' from the JSXGraph container.
             * JSXGraph creates a new div-element with id "{containerid}_ARIAlabel"
             * containing this string.
             *
             * @name JXG.Board#title
             * @see JXG.Board#description
             * @type String
             * @default ''
             *
             */
            title: '',

            /**
             * Description string for the board.
             * Primarily used in an invisible text element which is adressed by
             * the attribute 'aria-describedby' from the JSXGraph container.
             * JSXGraph creates a new div-element with id "{containerid}_ARIAdescription"
             * containing this string.
             *
             * @name JXG.Board#description
             * @see JXG.Board#title
             * @type String
             * @default ''
             *
             */
            description: '',

            /**
             * Show copyright string in canvas.
             *
             * @name JXG.Board#showCopyright
             * @type Boolean
             * @default true
             */
            showCopyright: true,

            /**
             * Show default axis.
             * If shown, the horizontal axis can be accessed via JXG.Board.defaultAxes.x, the
             * vertical axis can be accessed via JXG.Board.defaultAxes.y.
             * Both axes have a sub-element "defaultTicks".
             *
             * Value can be Boolean or an object containing axis attributes.
             *
             * @name JXG.Board#axis
             * @type Boolean
             * @default false
             */
            axis: false,

            /**
             * Attributes for the default axes in case of the attribute
             * axis:true in {@link JXG.JSXGraph#initBoard}.
             *
             * @name JXG.Board#defaultAxes
             * @type Object
             * @default {x: {name:'x'}, y: {name: 'y'}}
             *
             */
            defaultAxes: {
                x: {
                    name: 'x',
                    ticks: {
                        label: {
                            visible: 'inherit',
                            anchorX: 'middle',
                            anchorY: 'top',
                            fontSize: 12,
                            offset: [0, -3]
                        },
                        drawZero: false,
                        visible: 'inherit'
                    }
                },
                y: {
                    name: 'y',
                    ticks: {
                        label: {
                            visible: 'inherit',
                            anchorX: 'right',
                            anchorY: 'middle',
                            fontSize: 12,
                            offset: [-6, 0]
                        },
                        tickEndings: [1, 0],
                        drawZero: false,
                        visible: 'inherit'
                    }
                }
            },

            /**
             * Display of navigation arrows and zoom buttons in the navigation bar.
             *
             * @name JXG.Board#showNavigation
             * @type Boolean
             * @default true
             */
            showNavigation: true,

            /**
             * Display of zoom buttons in the navigation bar. To show zoom buttons, additionally
             * showNavigation has to be set to true.
             *
             * @name JXG.Board#showZoom
             * @type Boolean
             * @default true
             */
            showZoom: true,

            /**
             * Show a button in the navigation bar to force reload of a construction.
             * Works only with the JessieCode tag.
             *
             * @name JXG.Board#showReload
             * @type Boolean
             * @default false
             */
            showReload: false,

            /**
             * Show a button in the navigation bar to enable screenshots.
             *
             * @name JXG.Board#showScreenshot
             * @type Boolean
             * @default false
             */
            showScreenshot: false,

            /**
             * Attributes to control the screenshot function.
             * The following attributes can be set:
             * <ul>
             *  <li>scale: scaling factor (default=1.0)
             *  <li>type: format of the screenshot image. Default: png
             *  <li>symbol: Unicode symbol which is shown in the navigation bar. Default: '\u2318'
             *  <li>css: CSS rules to format the div element containing the screen shot image
             *  <li>cssButton: CSS rules to format the close button of the div element containing the screen shot image
             * </ul>
             *
             * @name JXG.Board#screenshot
             * @type Object
             */
            screenshot: {
                scale: 1.0,
                type: 'png',
                symbol: '\u2318', //'\u22b9', //'\u26f6',
                css: 'background-color:#eeeeee; opacity:1.0; border:2px solid black; border-radius:10px; text-align:center',
                cssButton:  'padding: 4px 10px; border: solid #356AA0 1px; border-radius: 5px; position: absolute; right: 2ex; top: 2ex; background-color: rgba(255, 255, 255, 0.3);'
            },

            /**
             * Show a button in the navigation bar to start fullscreen mode.
             *
             * @name JXG.Board#showFullscreen
             * @type Boolean
             * @see JXG.Board#fullscreen
             * @default false
             */
            showFullscreen: false,

            /**
             * Attribute(s) to control the fullscreen icon. The attribute "showFullscreen"
             * controls if the icon is shown.
             * The following attribute(s) can be set:
             * <ul>
             *  <li>symbol (String): Unicode symbol which is shown in the navigation bar. Default: '\u25a1'
             *  <li>id (String): Id of the HTML element which is brought to full screen or null if the JSXgraph div is taken.
             * It may be an outer div element, e.g. if the old aspect ratio trick is used. Default: null, i.e. use the JSXGraph div.
             * </ul>
             *
             * @example
             * var board = JXG.JSXGraph.initBoard('35bec5a2-fd4d-11e8-ab14-901b0e1b8723',
             *             {boundingbox: [-8, 8, 8,-8], axis: true,
             *             showcopyright: false,
             *             showFullscreen: true,
             *             fullscreen: {
             *                  symbol: '\u22c7'
             *              }
             *             });
             * var pol = board.create('polygon', [[0, 1], [3,4], [1,-4]], {fillColor: 'yellow'});
             *
             * </pre><div id="JXGa35bec5a2-fd4d-11e8-ab14-901b0e1b8723" class="jxgbox" style="width: 300px; height: 300px;"></div>
             * <script type="text/javascript">
             *     (function() {
             *         var board = JXG.JSXGraph.initBoard('JXGa35bec5a2-fd4d-11e8-ab14-901b0e1b8723',
             *             {boundingbox: [-8, 8, 8,-8], axis: true, showcopyright: false,
             *              showFullscreen: true,
             *              fullscreen: {
             *                  symbol: '\u22c7'
             *                  }
             *             });
             *     var pol = board.create('polygon', [[0, 1], [3,4], [1,-4]], {fillColor: 'yellow'});
             *     })();
             *
             * </script><pre>
             *
             * @name JXG.Board#fullscreen
             * @see JXG.Board#showFullscreen
             * @type Object
             */
            fullscreen: {
                symbol: '\u25a1', // '\u26f6' (not supported by MacOS), // '\u25a1'
                id: null
            },

            /**
             * Show a button which allows to clear all traces of a board.
             *
             * @name JXG.Board#showClearTraces
             * @type Boolean
             * @default false
             */
            showClearTraces: false,

            /**
             * If set to true the bounding box might be changed such that
             * the ratio of width and height of the hosting HTML div is equal
             * to the ratio of width and height of the bounding box.
             *
             * This is necessary if circles should look like circles and not
             * like ellipses. It is recommended to set keepAspectRatio = true
             * for geometric applets. For function plotting keepAspectRatio = false
             * might be the better choice.
             *
             * @name JXG.Board#keepAspectRatio
             * @see JXG.Board#boundingbox
             * @see JXG.Board#setBoundingBox
             * @type Boolean
             * @default false
             */
            keepAspectRatio: false,

            /**
             * If set true and
             * hasPoint() is true for both an element and it's label,
             * the element (and not the label) is taken as drag element.
             *
             * If set false and hasPoint() is true for both an element and it's label,
             * the label is taken (if it is on a higher layer than the element)
             *
             * @name JXG.Board#ignoreLabels
             * @type Booelan
             * @default true
             */
            ignoreLabels: true,

            /**
             * Maximum number of digits in automatic label generation.
             * For example, if set to 1 automatic point labels end at "Z".
             * If set to 2, point labels end at "ZZ".
             *
             * @name JXG.Board#maxNameLength
             * @see JXG.Board#generateName
             * @type Number
             * @default 1
             */
            maxNameLength: 1,

            /**
             * Supply the document object. Defaults to window.document
             *
             * @name JXG.Board#document
             * @type DOM object
             * @default false (meaning window.document)
             */
            document: false,

            /**
             * If true the first element of the set JXG.board.objects having hasPoint==true is taken as drag element.
             *
             * @name JXG.Board#takeFirst
             * @type Boolean
             * @default false
             */
            takeFirst: false,

            /**
            * If true, when read from a file or string - the size of the div can be changed by the construction text.
            *
            * @name JXG.Board#takeSizeFromFile
            * @type Boolean
            * @default false
            */
            takeSizeFromFile: false,

            /**
             * Default rendering engine. Possible values are 'svg', 'canvas', 'vml', 'no', or 'auto'.
             * If the rendering engine is not available JSXGraph tries to detect a different engine.
             *
             * <p>
             * In case of 'canvas' it is advisable to call 'board.update()' after all elements have been
             * constructed. This ensures that all elements are drawn with their intended visual appearance.
             *
             * @name JXG.Board#renderer
             * @type String
             * @default 'auto'
             */
            renderer: 'auto',

            /**
             * Time (in msec) between two animation steps. Used in
             * {@link JXG.CoordsElement#moveAlong}, {@link JXG.CoordsElement#moveTo} and
             * {@link JXG.CoordsElement#visit}.
             *
             * @name JXG.Board#animationDelay
             * @type Number
             * @default 35
             * @see JXG.CoordsElement#moveAlong
             * @see JXG.CoordsElement#moveTo
             * @see JXG.CoordsElement#visit
             */
            animationDelay: 35,

            /**
             * Maximum frame rate of the board, i.e. maximum number of updates per second
             * triggered by move events.
             *
             * @name JXG.Board#maxFrameRate
             * @type Number
             * @default 40
             */
            maxFrameRate: 40,

            /**
             * Allow user interaction by registering mouse, pointer and touch events.
             *
             * @name JXG.Board#registerEvents
             * @type Boolean
             * @default true
             */
            registerEvents: true,

            /**
             * Change redraw strategy in SVG rendering engine.
             * <p>
             * This optimization seems to be <b>obsolete</b> in newer browsers (from 2021 on, at least)
             * and even slow down the constructions. Therefore, the default is set to 'none' since v1.2.4.
             * <p>
             * If set to 'svg', before every redrawing of the JSXGraph construction
             * the SVG sub-tree of the DOM tree is taken out of the DOM.
             *
             * If set to 'all', before every redrawing of the JSXGraph construction the
             * complete DOM tree is taken out of the DOM.
             * If set to 'none' the redrawing is done in-place.
             *
             * Using 'svg' or 'all' speeds up the update process considerably. The risk
             * is that if there is an exception, only a white div or window is left.
             *
             *
             * @name JXG.Board#minimizeReflow
             * @type String
             * @default 'none'
             */
            minimizeReflow: 'none',

            /**
             * A number that will be added to the absolute position of the board used in mouse coordinate
             * calculations in {@link JXG.Board#getCoordsTopLeftCorner}.
             *
             * @name JXG.Board#offsetX
             * @see JXG.Board#offsetY
             * @type Number
             * @default 0
             */
            offsetX: 0,

            /**
             * A number that will be added to the absolute position of the board used in mouse coordinate
             * calculations in {@link JXG.Board#getCoordsTopLeftCorner}.
             *
             * @name JXG.Board#offsetY
             * @see JXG.Board#offsetX
             * @type Number
             * @default 0
             */
            offsetY: 0,

            /**
             * Control the possibilities for zoom interaction.
             *
             * Possible sub-attributes with default values are:
             * <pre>
             * zoom: {
             *   factorX: 1.25,  // horizontal zoom factor (multiplied to {@link JXG.Board#zoomX})
             *   factorY: 1.25,  // vertical zoom factor (multiplied to {@link JXG.Board#zoomY})
             *   wheel: true,     // allow zooming by mouse wheel or
             *   				   // by pinch-to-toom gesture on touch devices
             *   needShift: true,   // mouse wheel zooming needs pressing of the shift key
             *   min: 0.001,        // minimal values of {@link JXG.Board#zoomX} and {@link JXG.Board#zoomY}, limits zoomOut
             *   max: 1000.0,       // maximal values of {@link JXG.Board#zoomX} and {@link JXG.Board#zoomY}, limits zoomIn
             *
             *   pinchHorizontal: true, // Allow pinch-to-zoom to zoom only horizontal axis
             *   pinchVertical: true,   // Allow pinch-to-zoom to zoom only vertical axis
             *   pinchSensitivity: 7    // Sensitivity (in degrees) for recognizing horizontal or vertical pinch-to-zoom gestures.
             * }
             * </pre>
             *
             * Deprecated: zoom.eps which is superseded by zoom.min
             *
             * @name JXG.Board#zoom
             * @type Object
             * @default
             */
            zoom: {
                enabled: true,
                factorX: 1.25,
                factorY: 1.25,
                wheel: true,
                needShift: true,
                min: 0.0001,
                max: 10000.0,
                pinchHorizontal: true,
                pinchVertical: true,
                pinchSensitivity: 7
            },

            /**
             * Control the possibilities for panning interaction (i.e. moving the origin).
             *
             * Possible sub-attributes with default values are:
             * <pre>
             * pan: {
             *   enabled: true   // Allow panning
             *   needTwoFingers: false, // panning is done with two fingers on touch devices
             *   needShift: true, // mouse panning needs pressing of the shift key
             * }
             * </pre>
             *
             * @name JXG.Board#pan
             * @type Object
             */
            pan: {
                needShift: true,
                needTwoFingers: false,
                enabled: true
            },

            /**
             * Control the possibilities for dragging objects.
             *
             * Possible sub-attributes with default values are:
             * <pre>
             * drag: {
             *   enabled: true   // Allow dragging
             * }
             * </pre>
             *
             * @name JXG.Board#drag
             * @type Object
             * @default {enabled: true}
             */
            drag: {
                enabled: true
            },

            /**
             * Control using the keyboard to change the construction.
             * <ul>
             * <li> enabled: true / false
             * <li> dx: horizontal shift amount per key press
             * <li> dy: vertical shift amount per key press
             * <li> panShift: zoom if shift key is pressed
             * <li> panCtrl: zoom if ctrl key is pressed
             * </ul>
             *
             * @example
             * var board = JXG.JSXGraph.initBoard("jxgbox", {boundingbox: [-5,5,5,-5],
             *     axis: true,
             *     showCopyright:true,
             *     showNavigation:true,
             *     keyboard: {
             *         enabled: true,
             *         dy: 30,
             *         panShift: true,
             *         panCtrl: false
             *     }
             * });
             *
             * </pre><div id="JXGb1d3aab6-ced2-4fe9-8fa5-b0accc8c7266" class="jxgbox" style="width: 300px; height: 300px;"></div>
             * <script type="text/javascript">
             *     (function() {
             *         var board = JXG.JSXGraph.initBoard('JXGb1d3aab6-ced2-4fe9-8fa5-b0accc8c7266',
             *             {boundingbox: [-5,5,5,-5],
             *         axis: true,
             *         showCopyright:true,
             *         showNavigation:true,
             *         keyboard: {
             *             enabled: true,
             *             dy: 30,
             *             panShift: true,
             *             panCtrl: false
             *         }
             *     });
             *
             *     })();
             *
             * </script><pre>
             *
             *
             * @see JXG.Board#keyDownListener
             * @see JXG.Board#keyFocusInListener
             * @see JXG.Board#keyFocusOutListener
             *
             * @name JXG.Board#keyboard
             * @type Object
             * @default {enabled: true, dx: 10, dy:10, panShift: true, panCtrl: false}
             */
            keyboard: {
                enabled: true,
                dx: 10,
                dy: 10,
                panShift: true,
                panCtrl: false
            },

            /**
             * Control if JSXGraph reacts to resizing of the JSXGraph container element
             * by the user / browser.
             * The attribute "throttle" determines the minimal time in msec between to
             * resize calls.
             *
             * @see JXG.Board#startResizeObserver
             * @see JXG.Board#resizeListener
             *
             * @name JXG.Board#resize
             * @type Object
             * @default {enabled: true, throttle: 10}
             *
             * @example
             *     var board = JXG.JSXGraph.initBoard('jxgbox', {
             *         boundingbox: [-5,5,5,-5],
             *         keepAspectRatio: true,
             *         axis: true,
             *         resize: {enabled: true, throttle: 200}
             *     });
             *
             * </pre><div id="JXGb55d4608-5d71-4bc3-b332-18c15fbda8c3" class="jxgbox" style="width: 300px; height: 300px;"></div>
             * <script type="text/javascript">
             *     (function() {
             *         var board = JXG.JSXGraph.initBoard('JXGb55d4608-5d71-4bc3-b332-18c15fbda8c3', {
             *             boundingbox: [-5,5,5,-5],
             *             keepAspectRatio: true,
             *             axis: true,
             *             resize: {enabled: true, throttle: 200}
             *         });
             *
             *     })();
             *
             * </script><pre>
             *
             *
             */
            resize: {
                enabled: true,
                throttle: 10
            },

            /**
             * Element which listens to move events of the pointing device.
             * This allows to drag elements of a JSXGraph construction outside of the board.
             * Especially, on mobile devices this enhances the user experience.
             * However, it is recommended to allow dragging outside of the JSXGraph board only
             * in certain constructions where users may not "loose" points outside of the board.
             * Then points may become unreachable.
             * <p>
             * A situation where dragging outside of the board is uncritical is for example if
             * only sliders are used to interact with the construction.
             * <p>
             * Possible values for this attributes are:
             * <ul>
             * <li> an element specified by document.getElementById('some id');
             * <li> null: to use the JSXgraph container div element
             * <li> document
             * </ul>
             *
             * @name JXG.Board#moveTarget
             * @type HTML node or document
             * @default null
             *
             * @example
             *     var board = JXG.JSXGraph.initBoard('jxgbox', {
             *         boundingbox: [-5,5,5,-5],
             *         axis: true,
             *         moveTarget: document
             *     });
             *
             * </pre><div id="JXG973457e5-c63f-4516-8570-743f2cc560e1" class="jxgbox" style="width: 300px; height: 300px;"></div>
             * <script type="text/javascript">
             *     (function() {
             *         var board = JXG.JSXGraph.initBoard('JXG973457e5-c63f-4516-8570-743f2cc560e1',
             *             {boundingbox: [-5,5,5,-5],
             *             axis: true,
             *             moveTarget: document
             *         });
             *
             *     })();
             *
             * </script><pre>
             *
             *
             */
            moveTarget: null,

            /**
             * Control the possibilities for a selection rectangle.
             * Starting a selection event triggers the "startselecting" event.
             * When the mouse pointer is released, the "stopselecting" event is fired.
             * The "stopselecting" event must be supplied by the user.
             * <p>
             * Possible sub-attributes with default values are:
             * <pre>
             * selection: {
             *   enabled: false,
             *   name: 'selectionPolygon',
             *   needShift: false,  // mouse selection needs pressing of the shift key
             *   needCtrl: true,    // mouse selection needs pressing of the shift key
             *   withLines: false,  // Selection polygon has border lines
             *   vertices: {
             *       visible: false
             *   },
             *   fillColor: '#ffff00',
             *   visible: false      // Initial visibility. Should be set to false always
             * }
             * </pre>
             *
             * @example
             * board.on('stopselecting', function(){
             *     var box = board.stopSelectionMode(),
             *     // bbox has the coordinates of the selectionr rectangle.
             *     // Attention: box[i].usrCoords have the form [1, x, y], i.e.
             *     // are homogeneous coordinates.
             *     bbox = box[0].usrCoords.slice(1).concat(box[1].usrCoords.slice(1));
             *     // Set a new bounding box
             *     board.setBoundingBox(bbox, false);
             * });
             *
             * @name JXG.Board#selection
             * @see JXG.Board#startselecting
             * @see JXG.Board#stopselecting
             * @see JXG.Board#mousestartselecting
             * @see JXG.Board#pointerstartselecting
             * @see JXG.Board#touchstartselecting
             * @see JXG.Board#mousestopselecting
             * @see JXG.Board#pointerstopselecting
             * @see JXG.Board#touchstopselecting
             * @type Object
             * @default
             */
            selection: {
                enabled: false,
                name: 'selectionPolygon',
                needShift: false,
                needCtrl: true,
                withLines: false,
                vertices: {
                    visible: false
                },
                fillColor: '#ffff00',
                visible: false
            },

            /**
             * If true, the infobox is shown on mouse/pen over for all points
             * which have set their attribute showInfobox to 'inherit'.
             * If a point has set its attribute showInfobox to false or true,
             * that value will have priority over this value.
             *
             * @name JXG.Board#showInfobox
             * @see Point#showInfobox
             * @type Boolean
             * @default true
             */
            showInfobox: true

            /**#@-*/
        },

        /**
         * Options that are used by the navigation bar.
         *
         * Default values are
         * <pre>
         * JXG.Option.navbar: {
         *   strokeColor: '#333333',
         *   fillColor: 'transparent',
         *   highlightFillColor: '#aaaaaa',
         *   padding: '2px',
         *   position: 'absolute',
         *   fontSize: '14px',
         *   cursor: 'pointer',
         *   zIndex: '100',
         *   right: '5px',
         *   bottom: '5px'
         * },
         * </pre>
         * These settings are overruled by the CSS class 'JXG_navigation'.
         * @deprecated
         * @type Object
         * @name JXG.Options#navbar
         *
         */
        navbar: {
            strokeColor: '#333333', //'#aaaaaa',
            fillColor: 'transparent', //#f5f5f5',
            highlightFillColor: '#aaaaaa',
            padding: '2px',
            position: 'absolute',
            fontSize: '14px',
            cursor: 'pointer',
            zIndex: '100',
            right: '5px',
            bottom: '5px'
            //border: 'none 1px black',
            //borderRadius: '4px'
        },

         /*
          *  Generic options used by {@link JXG.GeometryElement}
          */
        elements: {
            // the following tag is a meta tag: http://code.google.com/p/jsdoc-toolkit/wiki/MetaTags

            /**#@+
             * @visprop
             */

            /**
             * The stroke color of the given geometry element.
             * @type String
             * @name JXG.GeometryElement#strokeColor
             * @see JXG.GeometryElement#highlightStrokeColor
             * @see JXG.GeometryElement#strokeWidth
             * @see JXG.GeometryElement#strokeOpacity
             * @see JXG.GeometryElement#highlightStrokeOpacity
             * @default {@link JXG.Options.elements.color#strokeColor}
             */
            strokeColor: Color.palette.blue,

            /**
             * The stroke color of the given geometry element when the user moves the mouse over it.
             * @type String
             * @name JXG.GeometryElement#highlightStrokeColor
             * @see JXG.GeometryElement#strokeColor
             * @see JXG.GeometryElement#strokeWidth
             * @see JXG.GeometryElement#strokeOpacity
             * @see JXG.GeometryElement#highlightStrokeOpacity
             * @default {@link JXG.Options.elements.color#highlightStrokeColor}
             */
            highlightStrokeColor: '#c3d9ff',

            /**
             * The fill color of this geometry element.
             * @type String
             * @name JXG.GeometryElement#fillColor
             * @see JXG.GeometryElement#highlightFillColor
             * @see JXG.GeometryElement#fillOpacity
             * @see JXG.GeometryElement#highlightFillOpacity
             * @default {@link JXG.Options.elements.color#fillColor}
             */
            fillColor: Color.palette.red,

            /**
             * The fill color of the given geometry element when the mouse is pointed over it.
             * @type String
             * @name JXG.GeometryElement#highlightFillColor
             * @see JXG.GeometryElement#fillColor
             * @see JXG.GeometryElement#fillOpacity
             * @see JXG.GeometryElement#highlightFillOpacity
             * @default {@link JXG.Options.elements.color#highlightFillColor}
             */
            highlightFillColor: 'none',

            /**
             * Opacity for element's stroke color.
             * @type Number
             * @name JXG.GeometryElement#strokeOpacity
             * @see JXG.GeometryElement#strokeColor
             * @see JXG.GeometryElement#highlightStrokeColor
             * @see JXG.GeometryElement#strokeWidth
             * @see JXG.GeometryElement#highlightStrokeOpacity
             * @default {@link JXG.Options.elements#strokeOpacity}
             */
            strokeOpacity: 1,

            /**
             * Opacity for stroke color when the object is highlighted.
             * @type Number
             * @name JXG.GeometryElement#highlightStrokeOpacity
             * @see JXG.GeometryElement#strokeColor
             * @see JXG.GeometryElement#highlightStrokeColor
             * @see JXG.GeometryElement#strokeWidth
             * @see JXG.GeometryElement#strokeOpacity
             * @default {@link JXG.Options.elements#highlightStrokeOpacity}
             */
            highlightStrokeOpacity: 1,

            /**
             * Opacity for fill color.
             * @type Number
             * @name JXG.GeometryElement#fillOpacity
             * @see JXG.GeometryElement#fillColor
             * @see JXG.GeometryElement#highlightFillColor
             * @see JXG.GeometryElement#highlightFillOpacity
             * @default {@link JXG.Options.elements.color#fillOpacity}
             */
            fillOpacity: 1,

            /**
             * Opacity for fill color when the object is highlighted.
             * @type Number
             * @name JXG.GeometryElement#highlightFillOpacity
             * @see JXG.GeometryElement#fillColor
             * @see JXG.GeometryElement#highlightFillColor
             * @see JXG.GeometryElement#fillOpacity
             * @default {@link JXG.Options.elements.color#highlightFillOpacity}
             */
            highlightFillOpacity: 1,

            /**
             * Gradient type. Possible values are 'linear'. 'radial' or null.
             *
             * @example
             *     var a = board.create('slider', [[0, -0.2], [3.5, -0.2], [0, 0, 2 * Math.PI]], {name: 'angle'});
             *     var b = board.create('slider', [[0, -0.4], [3.5, -0.4], [0, 0, 1]], {name: 'offset1'});
             *     var c = board.create('slider', [[0, -0.6], [3.5, -0.6], [0, 1, 1]], {name: 'offset2'});
             *
             *     var pol = board.create('polygon', [[0, 0], [4, 0], [4,4], [0,4]], {
             *                 fillOpacity: 1,
             *                 fillColor: 'yellow',
             *                 gradient: 'linear',
             *                 gradientSecondColor: 'blue',
             *                 gradientAngle: function() { return a.Value(); },
             *                 gradientStartOffset: function() { return b.Value(); },
             *                 gradientEndOffset: function() { return c.Value(); },
             *                 hasInnerPoints: true
             *         });
             *
             * </pre><div id="JXG3d04b5fd-0cd4-4f49-8c05-4e9686cd7ff0" class="jxgbox" style="width: 300px; height: 300px;"></div>
             * <script type="text/javascript">
             *     (function() {
             *         var board = JXG.JSXGraph.initBoard('JXG3d04b5fd-0cd4-4f49-8c05-4e9686cd7ff0',
             *             {boundingbox: [-1.5, 4.5, 5, -1.5], axis: true, showcopyright: false, shownavigation: false});
             *         var a = board.create('slider', [[0, -0.2], [3.5, -0.2], [0, 0, 2 * Math.PI]], {name: 'angle'});
             *         var b = board.create('slider', [[0, -0.4], [3.5, -0.4], [0, 0, 1]], {name: 'offset1'});
             *         var c = board.create('slider', [[0, -0.6], [3.5, -0.6], [0, 1, 1]], {name: 'offset2'});
             *
             *         var pol = board.create('polygon', [[0, 0], [4, 0], [4,4], [0,4]], {
             *                     fillOpacity: 1,
             *                     fillColor: 'yellow',
             *                     gradient: 'linear',
             *                     gradientSecondColor: 'blue',
             *                     gradientAngle: function() { return a.Value(); },
             *                     gradientStartOffset: function() { return b.Value(); },
             *                     gradientEndOffset: function() { return c.Value(); },
             *                     hasInnerPoints: true
             *             });
             *
             *     })();
             *
             * </script><pre>
             *
             * @example
             *     var cx = board.create('slider', [[0, -.2], [3.5, -.2], [0, 0.5, 1]], {name: 'cx, cy'});
             *     var fx = board.create('slider', [[0, -.4], [3.5, -.4], [0, 0.5, 1]], {name: 'fx, fy'});
             *     var o1 = board.create('slider', [[0, -.6], [3.5, -.6], [0, 0.0, 1]], {name: 'offset1'});
             *     var o2 = board.create('slider', [[0, -.8], [3.5, -.8], [0, 1, 1]], {name: 'offset2'});
             *     var r = board.create('slider', [[0, -1], [3.5, -1], [0, 0.5, 1]], {name: 'r'});
             *     var fr = board.create('slider', [[0, -1.2], [3.5, -1.2], [0, 0, 1]], {name: 'fr'});
             *
             *     var pol = board.create('polygon', [[0, 0], [4, 0], [4,4], [0,4]], {
             *                 fillOpacity: 1,
             *                 fillColor: 'yellow',
             *                 gradient: 'radial',
             *                 gradientSecondColor: 'blue',
             *                 gradientCX: function() { return cx.Value(); },
             *                 gradientCY: function() { return cx.Value(); },
             *                 gradientR: function() { return r.Value(); },
             *                 gradientFX: function() { return fx.Value(); },
             *                 gradientFY: function() { return fx.Value(); },
             *                 gradientFR: function() { return fr.Value(); },
             *                 gradientStartOffset: function() { return o1.Value(); },
             *                 gradientEndOffset: function() { return o2.Value(); },
             *                 hasInnerPoints: true
             *     });
             *
             * </pre><div id="JXG6081ca7f-0d09-4525-87ac-325a02fe2225" class="jxgbox" style="width: 300px; height: 300px;"></div>
             * <script type="text/javascript">
             *     (function() {
             *         var board = JXG.JSXGraph.initBoard('JXG6081ca7f-0d09-4525-87ac-325a02fe2225',
             *             {boundingbox: [-1.5, 4.5, 5, -1.5], axis: true, showcopyright: false, shownavigation: false});
             *         var cx = board.create('slider', [[0, -.2], [3.5, -.2], [0, 0.5, 1]], {name: 'cx, cy'});
             *         var fx = board.create('slider', [[0, -.4], [3.5, -.4], [0, 0.5, 1]], {name: 'fx, fy'});
             *         var o1 = board.create('slider', [[0, -.6], [3.5, -.6], [0, 0.0, 1]], {name: 'offset1'});
             *         var o2 = board.create('slider', [[0, -.8], [3.5, -.8], [0, 1, 1]], {name: 'offset2'});
             *         var r = board.create('slider', [[0, -1], [3.5, -1], [0, 0.5, 1]], {name: 'r'});
             *         var fr = board.create('slider', [[0, -1.2], [3.5, -1.2], [0, 0, 1]], {name: 'fr'});
             *
             *         var pol = board.create('polygon', [[0, 0], [4, 0], [4,4], [0,4]], {
             *                     fillOpacity: 1,
             *                     fillColor: 'yellow',
             *                     gradient: 'radial',
             *                     gradientSecondColor: 'blue',
             *                     gradientCX: function() { return cx.Value(); },
             *                     gradientCY: function() { return cx.Value(); },
             *                     gradientR: function() { return r.Value(); },
             *                     gradientFX: function() { return fx.Value(); },
             *                     gradientFY: function() { return fx.Value(); },
             *                     gradientFR: function() { return fr.Value(); },
             *                     gradientStartOffset: function() { return o1.Value(); },
             *                     gradientEndOffset: function() { return o2.Value(); },
             *                     hasInnerPoints: true
             *         });
             *
             *     })();
             *
             * </script><pre>
             *
             *
             * @type String
             * @name JXG.GeometryElement#gradient
             * @see JXG.GeometryElement#gradientSecondColor
             * @see JXG.GeometryElement#gradientSecondOpacity
             * @default null
             */
            gradient: null,

            /**
             * Second color for gradient.
             * @type String
             * @name JXG.GeometryElement#gradientSecondColor
             * @see JXG.GeometryElement#gradient
             * @see JXG.GeometryElement#gradientSecondOpacity
             * @default '#ffffff'
             */
            gradientSecondColor: '#ffffff',

            /**
             * Opacity of second gradient color. Takes a value between 0 and 1.
             * @type Number
             * @name JXG.GeometryElement#gradientSecondOpacity
             * @see JXG.GeometryElement#gradient
             * @see JXG.GeometryElement#gradientSecondColor
             * @default 1
             */
            gradientSecondOpacity: 1,

            /**
             * The gradientStartOffset attribute is a number (ranging from 0 to 1) which indicates where the first gradient stop is placed,
             * see the SVG specification for more information.
             * For linear gradients, this attribute represents a location along the gradient vector.
             * For radial gradients, it represents a percentage distance from (fx,fy) to the edge of the outermost/largest circle.
             * @type Number
             * @name JXG.GeometryElement#gradientStartOffset
             * @see JXG.GeometryElement#gradient
             * @see JXG.GeometryElement#gradientEndOffset
             * @default 0.0
             */
            gradientStartOffset: 0.0,

            /**
             * The gradientEndOffset attribute is a number (ranging from 0 to 1) which indicates where the second gradient stop is placed,
             * see the SVG specification for more information.
             * For linear gradients, this attribute represents a location along the gradient vector.
             * For radial gradients, it represents a percentage distance from (fx,fy) to the edge of the outermost/largest circle.
             * @type Number
             * @name JXG.GeometryElement#gradientEndOffset
             * @see JXG.GeometryElement#gradient
             * @see JXG.GeometryElement#gradientStartOffset
             * @default 1.0
             */
            gradientEndOffset: 1.0,


            /**
             * Angle (in radians) of the gradiant in case the gradient is of type 'linear'.
             * If the angle is 0, the first color is on the left and the second color is on the right.
             * If the angle is pi/4 the first color is on top and the second color at the
             * bottom.
             * @type Number
             * @name JXG.GeometryElement#gradientAngle
             * @see JXG.GeometryElement#gradient
             * @default 0
             */
            gradientAngle: 0,

            /**
             * From the SVG specification: ‘cx’, ‘cy’ and ‘r’ define the largest (i.e., outermost) circle for the radial gradient.
             * The gradient will be drawn such that the 100% gradient stop is mapped to the perimeter of this largest (i.e., outermost) circle.
             * For radial gradients in canvas this is the value 'x1'.
             * Takes a value between 0 and 1.
             * @type Number
             * @name JXG.GeometryElement#gradientCX
             * @see JXG.GeometryElement#gradient
             * @see JXG.GeometryElement#gradientCY
             * @see JXG.GeometryElement#gradientR
             * @default 0.5
             */
            gradientCX: 0.5,

            /**
             * From the SVG specification: ‘cx’, ‘cy’ and ‘r’ define the largest (i.e., outermost) circle for the radial gradient.
             * The gradient will be drawn such that the 100% gradient stop is mapped to the perimeter of this largest (i.e., outermost) circle.
             * For radial gradients in canvas this is the value 'y1'.
             * Takes a value between 0 and 1.
             * @type Number
             * @name JXG.GeometryElement#gradientCY
             * @see JXG.GeometryElement#gradient
             * @see JXG.GeometryElement#gradientCX
             * @see JXG.GeometryElement#gradientR
             * @default 0.5
             */
            gradientCY: 0.5,

            /**
             * From the SVG specification: ‘cx’, ‘cy’ and ‘r’ define the largest (i.e., outermost) circle for the radial gradient.
             * The gradient will be drawn such that the 100% gradient stop is mapped to the perimeter of this largest (i.e., outermost) circle.
             * For radial gradients in canvas this is the value 'r1'.
             * Takes a value between 0 and 1.
             * @type Number
             * @name JXG.GeometryElement#gradientR
             * @see JXG.GeometryElement#gradient
             * @see JXG.GeometryElement#gradientCX
             * @see JXG.GeometryElement#gradientCY
             * @default 0.5
             */
            gradientR: 0.5,

            /**
             * ‘fx’ and ‘fy’ define the focal point for the radial gradient.
             * The gradient will be drawn such that the 0% gradient stop is mapped to (fx, fy).
             * For radial gradients in canvas this is the value 'x0'.
             * Takes a value between 0 and 1.
             * @type Number
             * @name JXG.GeometryElement#gradientFX
             * @see JXG.GeometryElement#gradient
             * @see JXG.GeometryElement#gradientFY
             * @see JXG.GeometryElement#gradientFR
             * @default 0.5
             */
            gradientFX: 0.5,

            /**
             * y-coordinate of the circle center for the second color in case of gradient 'radial'. (The attribute fy in SVG)
             * For radial gradients in canvas this is the value 'y0'.
             * Takes a value between 0 and 1.
             * @type Number
             * @name JXG.GeometryElement#gradientFY
             * @see JXG.GeometryElement#gradient
             * @see JXG.GeometryElement#gradientFX
             * @see JXG.GeometryElement#gradientFR
             * @default 0.5
             */
            gradientFY: 0.5,

            /**
             * This attribute defines the radius of the start circle of the radial gradient.
             * The gradient will be drawn such that the 0% &lt;stop&gt; is mapped to the perimeter of the start circle.
             * For radial gradients in canvas this is the value 'r0'.
             * Takes a value between 0 and 1.
             * @type Number
             * @name JXG.GeometryElement#gradientFR
             * @see JXG.GeometryElement#gradient
             * @see JXG.GeometryElement#gradientFX
             * @see JXG.GeometryElement#gradientFY
             * @default 0.0
             */
            gradientFR: 0.0,

            /**
             * Transition duration (in milliseconds) for color and opacity
             * changes. Works in SVG renderer, only.
             * @type Number
             * @name JXG.GeometryElement#transitionDuration
             * @see JXG.GeometryElement#strokeColor
             * @see JXG.GeometryElement#highlightStrokeColor
             * @see JXG.GeometryElement#strokeOpacity
             * @see JXG.GeometryElement#highlightStrokeOpacity
             * @see JXG.GeometryElement#fillColor
             * @see JXG.GeometryElement#highlightFillColor
             * @see JXG.GeometryElement#fillOpacity
             * @see JXG.GeometryElement#highlightFillOpacity
             * @default {@link JXG.Options.elements#transitionDuration}
             */
            transitionDuration: 100,

            /**
             * Width of the element's stroke.
             * @type Number
             * @name JXG.GeometryElement#strokeWidth
             * @see JXG.GeometryElement#strokeColor
             * @see JXG.GeometryElement#highlightStrokeColor
             * @see JXG.GeometryElement#strokeOpacity
             * @see JXG.GeometryElement#highlightStrokeOpacity
             * @default {@link JXG.Options.elements#strokeWidth}
             */
            strokeWidth: 2,

            /**
             * Width of the element's stroke when the mouse is pointed over it.
             * @type Number
             * @name JXG.GeometryElement#highlightStrokeWidth
             * @see JXG.GeometryElement#strokeColor
             * @see JXG.GeometryElement#highlightStrokeColor
             * @see JXG.GeometryElement#strokeOpacity
             * @see JXG.GeometryElement#highlightStrokeOpacity
             * @see JXG.GeometryElement#highlightFillColor
             * @default {@link JXG.Options.elements#strokeWidth}
             */
            highlightStrokeWidth: 2,

            /**
             * If true the element is fixed and can not be dragged around. The element
             * will be repositioned on zoom and moveOrigin events.
             * @type Boolean
             * @default false
             * @name JXG.GeometryElement#fixed
             */
            fixed: false,

            /**
             * If true the element is fixed and can not be dragged around. The element
             * will even stay at its position on zoom and moveOrigin events.
             * Only free elements like points, texts, curves can be frozen.
             * @type Boolean
             * @default false
             * @name JXG.GeometryElement#frozen
             */
            frozen: false,

            /**
             * If true a label will display the element's name.
             * @type Boolean
             * @default false
             * @name JXG.GeometryElement#withLabel
             */
            withLabel: false,

            /**
             * If false the element won't be visible on the board, otherwise it is shown.
             * @type Boolean
             * @name JXG.GeometryElement#visible
             * @see JXG.GeometryElement#hideElement
             * @see JXG.GeometryElement#showElement
             * @default true
             */
            visible: true,

            /**
             * A private element will be inaccessible in certain environments, e.g. a graphical user interface.
             * @default false
             */
            priv: false,

            /**
             * Display layer which will contain the element.
             * @see JXG.Options#layer
             * @default See {@link JXG.Options#layer}
             */
            layer: 0,

            /**
             * Determines the elements border-style.
             * Possible values are:
             * <ul><li>0 for a solid line</li>
             * <li>1 for a dotted line</li>
             * <li>2 for a line with small dashes</li>


             * <li>3 for a line with medium dashes</li>
             * <li>4 for a line with big dashes</li>
             * <li>5 for a line with alternating medium and big dashes and large gaps</li>
             * <li>6 for a line with alternating medium and big dashes and small gaps</li></ul>
             * @type Number
             * @name JXG.GeometryElement#dash
             * @default 0
             */
            dash: 0,

            /**
             * If true the element will get a shadow.
             * @type Boolean
             * @name JXG.GeometryElement#shadow
             * @default false
             */
            shadow: false,

            /**
             * If true the element will be traced, i.e. on every movement the element will be copied
             * to the background. Use {@link JXG.GeometryElement#clearTrace} to delete the trace elements.
             *
             * The calling of element.setAttribute({trace:false}) additionally
             * deletes all traces of this element. By calling
             * element.setAttribute({trace:'pause'})
             * the removal of already existing traces can be prevented.
             * @see JXG.GeometryElement#clearTrace
             * @see JXG.GeometryElement#traces
             * @see JXG.GeometryElement#numTraces
             * @type Boolean|String
             * @default false
             * @name JXG.GeometryElement#trace
             */
            trace: false,

            /**
             * Extra visual properties for traces of an element
             * @type Object
             * @see JXG.GeometryElement#trace
             * @name JXG.GeometryElement#traceAttributes
             */
            traceAttributes: {},

            /**
             *
             * @type Boolean
             * @default true
             * @name JXG.GeometryElement#highlight
             */
            highlight: true,

            /**
             * If this is set to true, the element is updated in every update
             * call of the board. If set to false, the element is updated only after
             * zoom events or more generally, when the bounding box has been changed.
             * Examples for the latter behaviour should be axes.
             * @type Boolean
             * @default true
             * @see JXG.GeometryElement#needsRegularUpdate
             * @name JXG.GeometryElement#needsRegularUpdate
             */
            needsRegularUpdate: true,

            /**
             * Snaps the element or its parents to the grid. Currently only relevant for points, circles,
             * and lines. Points are snapped to grid directly, on circles and lines it's only the parent
             * points that are snapped
             * @type Boolean
             * @default false
             * @name JXG.GeometryElement#snapToGrid
             */
            snapToGrid: false,

            /**
             * Determines whether two-finger manipulation of this object may change its size.
             * If set to false, the object is only rotated and translated.
             * <p>
             * In case the element is a horizontal or vertical line having ticks, "scalable:true"
             * enables zooming of the board by dragging ticks lines. This feature is enabled,
             * for the ticks element of the line element the attribute "fixed" has to be false
             * and the line element's scalable attribute has to be true.
             * <p>
             * In case the element is a polygon or line and it has the attribute "scalable:false",
             * moving the element with two fingers results in a rotation or translation.
             *
             * @type Boolean
             * @default true
             * @name JXG.GeometryElement#scalable
             * @see JXG.Ticks#fixed
             */
            scalable: true,

            /**
             * If the element is dragged it will be moved on mousedown or touchstart to the
             * top of its layer. Works only for SVG renderer and for simple elements
             * consisting of one SVG node.
             * @example
             * var li1 = board.create('line', [1, 1, 1], {strokeWidth: 20, dragToTopOfLayer: true});
             * var li2 = board.create('line', [1, -1, 1], {strokeWidth: 20, strokeColor: 'red'});
             *
             * </pre><div id="JXG38449fee-1ab4-44de-b7d1-43caa1f50f86" class="jxgbox" style="width: 300px; height: 300px;"></div>
             * <script type="text/javascript">
             *     (function() {
             *         var board = JXG.JSXGraph.initBoard('JXG38449fee-1ab4-44de-b7d1-43caa1f50f86',
             *             {boundingbox: [-8, 8, 8,-8], axis: true, showcopyright: false, shownavigation: false});
             *     var li1 = board.create('line', [1, 1, 1], {strokeWidth: 20, dragToTopOfLayer: true});
             *     var li2 = board.create('line', [1, -1, 1], {strokeWidth: 20, strokeColor: 'red'});
             *
             *     })();
             *
             * </script><pre>
             *
             * @type Boolean
             * @default false
             * @name JXG.GeometryElement#dragToTopOfLayer
             */
            dragToTopOfLayer: false,

            /**
             * Precision options for JSXGraph elements.
             * This attributes takes either the value 'inherit' or an object of the form:
             * <pre>
             * precision: {
             *      touch: 30,
             *      mouse: 4,
             *      pen: 4
             * }
             * </pre>
             *
             * In the first case, the global, JSXGraph-wide values of JXGraph.Options.precision
             * are taken.
             *
             * @type {String|Object}
             * @name JXG.GeometryElement#precision
             * @see JXG.Options#precision
             * @default 'inherit'
             */
            precision: 'inherit',

            /*draft options */
            draft: {
                /**
                 * If true the element will be drawn in grey scale colors to visualize that it's only a draft.
                 * @type Boolean
                 * @name JXG.GeometryElement#draft
                 * @default {@link JXG.Options.elements.draft#draft}
                 */
                draft: false,
                strokeColor: '#565656',
                fillColor: '#565656',
                strokeOpacity: 0.8,
                fillOpacity: 0.8,
                strokeWidth: 1
            },

            /**
             * @private
             * By default, an element is not a label. Do not change this.
             */
            isLabel: false,

            /**
             * Controls if an element can get the focus with the tab key.
             * See <a href="https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/tabindex">descriptiona at MDN</a>.
             * The additional value null completely disables focus of an element.
             * The value will be ignored if keyboard control of the board is not enabled or
             * the element is fixed or not visible.
             *
             * @name JXG.GeometryElement#tabindex
             * @type Number
             * @default 0
             * @see JXG.Board#keyboard
             * @see JXG.GeometryElement#fixed
             * @see JXG.GeometryElement#visible
             */
            tabindex: 0

            // close the meta tag
            /**#@-*/
        },

         /*
          *  Generic options used by {@link JXG.Ticks}
          */
        ticks: {
            /**#@+
             * @visprop
             */

            /**
             * A function that expects two {@link JXG.Coords}, the first one representing the coordinates of the
             * tick that is to be labeled, the second one the coordinates of the center (the tick with position 0).
             *
             * @type function
             * @name Ticks#generateLabelText
             */
            generateLabelText: null,

            /**
             * A function that expects two {@link JXG.Coords}, the first one representing the coordinates of the
             * tick that is to be labeled, the second one the coordinates of the center (the tick with position 0).
             *
             * @deprecated Use {@link JGX.Options@generateLabelValue}
             * @type function
             * @name Ticks#generateLabelValue
             */
            generateLabelValue: null,

            /**
             * Draw labels yes/no
             *
             * @type Boolean
             * @name Ticks#drawLabels
             * @default false
             */
            drawLabels: false,

            /**
             * Attributes for the ticks labels
             *
             * @name Ticks#label
             * @type Object
             * @default {}
             *
             */
            label: {
            },

            /**
            * Format tick labels that were going to have scientific notation
            * like 5.00e+6 to look like 5•10⁶.
            *
            * @example
            * var board = JXG.JSXGraph.initBoard("jxgbox", {
            *     boundingbox: [-500000, 500000, 500000, -500000],
            *     axis: true,
            *     defaultAxes: {
            *         x: {
            *             scalable: true,
            *             ticks: {
            *                 beautifulScientificTickLabels: true
            *           },
            *         },
            *         y: {
            *             scalable: true,
            *             ticks: {
            *                 beautifulScientificTickLabels: true
            *           },
            *         }
            *     },
            * });
            *
            * </pre><div id="JXGc1e46cd1-e025-4002-80aa-b450869fdaa2" class="jxgbox" style="width: 300px; height: 300px;"></div>
     