#!/usr/bin/sh
# Generate the header file for including git repository HEAD information.

GIT="${GIT:-$(command -v git 2>/dev/null)}"

GIT_HASH=""
GIT_DATE=""
GIT_DIRTY=0

if test -x "$GIT" ; then
  # Change current directory to execute git commands in source directory.
  if test -d "$1"; then
    cd "$1"
  fi
  GIT_HASH="$($GIT log --pretty=format:%h --abbrev=10 -n 1 2>/dev/null)"
  GIT_DATE="$($GIT log  --pretty=format:%ad --date=format:%Y%m%d -n 1 2>/dev/null)"
  GIT_STATUS="$($GIT status -uno -s 2>/dev/null | head -n 1)"
  if test -n "$GIT_STATUS" ; then
    GIT_DIRTY=1
  fi
fi

echo "/*"
echo " * Autogenerated by the Meson build system."
echo " * Do not edit, your changes will be lost."
echo " */"
echo ""
echo "#pragma once"
echo ""
echo "#define GIT_HASH \"${GIT_HASH}\""
echo "#define GIT_DATE \"${GIT_DATE}\""
echo "#define GIT_DIRTY ${GIT_DIRTY}"
