/*****************************************************************************
 Copyright (c) 2023, Intel Corporation

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

     * Redistributions of source code must retain the above copyright notice,
       this list of conditions and the following disclaimer.
     * Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.
     * Neither the name of Intel Corporation nor the names of its contributors
       may be used to endorse or promote products derived from this software
       without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*****************************************************************************/

/* SHA1, SHA2 */
#include "mac_test.h"

const struct mac_test sha_test_json[] = {
        /*
         * Vectors from https://csrc.nist.gov/csrc/media/projects/
         * cryptographic-standards-and-guidelines/documents/examples/sha_all.pdf
         */
        { 0, 160, 1, NULL, "\x61\x62\x63",
          "\xa9\x99\x3e\x36\x47\x06\x81\x6a\xba\x3e\x25\x71\x78\x50\xc2\x6c\x9c\xd0"
          "\xd8\x9d",
          1, 24, NULL, 0 },
        { 0, 224, 2, NULL, "\x61\x62\x63",
          "\x23\x09\x7d\x22\x34\x05\xd8\x22\x86\x42\xa4\x77\xbd\xa2\x55\xb3\x2a\xad"
          "\xbc\xe4\xbd\xa0\xb3\xf7\xe3\x6c\x9d\xa7",
          1, 24, NULL, 0 },
        { 0, 256, 3, NULL, "\x61\x62\x63",
          "\xba\x78\x16\xbf\x8f\x01\xcf\xea\x41\x41\x40\xde\x5d\xae\x22\x23\xb0\x03"
          "\x61\xa3\x96\x17\x7a\x9c\xb4\x10\xff\x61\xf2\x00\x15\xad",
          1, 24, NULL, 0 },
        { 0, 384, 4, NULL, "\x61\x62\x63",
          "\xcb\x00\x75\x3f\x45\xa3\x5e\x8b\xb5\xa0\x3d\x69\x9a\xc6\x50\x07\x27\x2c"
          "\x32\xab\x0e\xde\xd1\x63\x1a\x8b\x60\x5a\x43\xff\x5b\xed\x80\x86\x07\x2b"
          "\xa1\xe7\xcc\x23\x58\xba\xec\xa1\x34\xc8\x25\xa7",
          1, 24, NULL, 0 },
        { 0, 512, 5, NULL, "\x61\x62\x63",
          "\xdd\xaf\x35\xa1\x93\x61\x7a\xba\xcc\x41\x73\x49\xae\x20\x41\x31\x12\xe6"
          "\xfa\x4e\x89\xa9\x7e\xa2\x0a\x9e\xee\xe6\x4b\x55\xd3\x9a\x21\x92\x99\x2a"
          "\x27\x4f\xc1\xa8\x36\xba\x3c\x23\xa3\xfe\xeb\xbd\x45\x4d\x44\x23\x64\x3c"
          "\xe8\x0e\x2a\x9a\xc9\x4f\xa5\x4c\xa4\x9f",
          1, 24, NULL, 0 },
        { 0, 160, 6, NULL, "",
          "\xda\x39\xa3\xee\x5e\x6b\x4b\x0d\x32\x55\xbf\xef\x95\x60\x18\x90\xaf\xd8"
          "\x07\x09",
          1, 0, NULL, 0 },
        { 0, 224, 7, NULL, "",
          "\xd1\x4a\x02\x8c\x2a\x3a\x2b\xc9\x47\x61\x02\xbb\x28\x82\x34\xc4\x15\xa2"
          "\xb0\x1f\x82\x8e\xa6\x2a\xc5\xb3\xe4\x2f",
          1, 0, NULL, 0 },
        { 0, 256, 8, NULL, "",
          "\xe3\xb0\xc4\x42\x98\xfc\x1c\x14\x9a\xfb\xf4\xc8\x99\x6f\xb9\x24\x27\xae"
          "\x41\xe4\x64\x9b\x93\x4c\xa4\x95\x99\x1b\x78\x52\xb8\x55",
          1, 0, NULL, 0 },
        { 0, 384, 9, NULL, "",
          "\x38\xb0\x60\xa7\x51\xac\x96\x38\x4c\xd9\x32\x7e\xb1\xb1\xe3\x6a\x21\xfd"
          "\xb7\x11\x14\xbe\x07\x43\x4c\x0c\xc7\xbf\x63\xf6\xe1\xda\x27\x4e\xde\xbf"
          "\xe7\x6f\x65\xfb\xd5\x1a\xd2\xf1\x48\x98\xb9\x5b",
          1, 0, NULL, 0 },
        { 0, 512, 10, NULL, "",
          "\xcf\x83\xe1\x35\x7e\xef\xb8\xbd\xf1\x54\x28\x50\xd6\x6d\x80\x07\xd6\x20"
          "\xe4\x05\x0b\x57\x15\xdc\x83\xf4\xa9\x21\xd3\x6c\xe9\xce\x47\xd0\xd1\x3c"
          "\x5d\x85\xf2\xb0\xff\x83\x18\xd2\x87\x7e\xec\x2f\x63\xb9\x31\xbd\x47\x41"
          "\x7a\x81\xa5\x38\x32\x7a\xf9\x27\xda\x3e",
          1, 0, NULL, 0 },
        { 0, 160, 11, NULL,
          "\x61\x62\x63\x64\x62\x63\x64\x65\x63\x64\x65\x66\x64\x65\x66\x67\x65\x66"
          "\x67\x68\x66\x67\x68\x69\x67\x68\x69\x6a\x68\x69\x6a\x6b\x69\x6a\x6b\x6c"
          "\x6a\x6b\x6c\x6d\x6b\x6c\x6d\x6e\x6c\x6d\x6e\x6f\x6d\x6e\x6f\x70\x6e\x6f"
          "\x70\x71",
          "\x84\x98\x3e\x44\x1c\x3b\xd2\x6e\xba\xae\x4a\xa1\xf9\x51\x29\xe5\xe5\x46"
          "\x70\xf1",
          1, 448, NULL, 0 },
        { 0, 224, 12, NULL,
          "\x61\x62\x63\x64\x62\x63\x64\x65\x63\x64\x65\x66\x64\x65\x66\x67\x65\x66"
          "\x67\x68\x66\x67\x68\x69\x67\x68\x69\x6a\x68\x69\x6a\x6b\x69\x6a\x6b\x6c"
          "\x6a\x6b\x6c\x6d\x6b\x6c\x6d\x6e\x6c\x6d\x6e\x6f\x6d\x6e\x6f\x70\x6e\x6f"
          "\x70\x71",
          "\x75\x38\x8b\x16\x51\x27\x76\xcc\x5d\xba\x5d\xa1\xfd\x89\x01\x50\xb0\xc6"
          "\x45\x5c\xb4\xf5\x8b\x19\x52\x52\x25\x25",
          1, 448, NULL, 0 },
        { 0, 256, 13, NULL,
          "\x61\x62\x63\x64\x62\x63\x64\x65\x63\x64\x65\x66\x64\x65\x66\x67\x65\x66"
          "\x67\x68\x66\x67\x68\x69\x67\x68\x69\x6a\x68\x69\x6a\x6b\x69\x6a\x6b\x6c"
          "\x6a\x6b\x6c\x6d\x6b\x6c\x6d\x6e\x6c\x6d\x6e\x6f\x6d\x6e\x6f\x70\x6e\x6f"
          "\x70\x71",
          "\x24\x8d\x6a\x61\xd2\x06\x38\xb8\xe5\xc0\x26\x93\x0c\x3e\x60\x39\xa3\x3c"
          "\xe4\x59\x64\xff\x21\x67\xf6\xec\xed\xd4\x19\xdb\x06\xc1",
          1, 448, NULL, 0 },
        { 0, 384, 14, NULL,
          "\x61\x62\x63\x64\x62\x63\x64\x65\x63\x64\x65\x66\x64\x65\x66\x67\x65\x66"
          "\x67\x68\x66\x67\x68\x69\x67\x68\x69\x6a\x68\x69\x6a\x6b\x69\x6a\x6b\x6c"
          "\x6a\x6b\x6c\x6d\x6b\x6c\x6d\x6e\x6c\x6d\x6e\x6f\x6d\x6e\x6f\x70\x6e\x6f"
          "\x70\x71",
          "\x33\x91\xfd\xdd\xfc\x8d\xc7\x39\x37\x07\xa6\x5b\x1b\x47\x09\x39\x7c\xf8"
          "\xb1\xd1\x62\xaf\x05\xab\xfe\x8f\x45\x0d\xe5\xf3\x6b\xc6\xb0\x45\x5a\x85"
          "\x20\xbc\x4e\x6f\x5f\xe9\x5b\x1f\xe3\xc8\x45\x2b",
          1, 448, NULL, 0 },
        { 0, 512, 15, NULL,
          "\x61\x62\x63\x64\x62\x63\x64\x65\x63\x64\x65\x66\x64\x65\x66\x67\x65\x66"
          "\x67\x68\x66\x67\x68\x69\x67\x68\x69\x6a\x68\x69\x6a\x6b\x69\x6a\x6b\x6c"
          "\x6a\x6b\x6c\x6d\x6b\x6c\x6d\x6e\x6c\x6d\x6e\x6f\x6d\x6e\x6f\x70\x6e\x6f"
          "\x70\x71",
          "\x20\x4a\x8f\xc6\xdd\xa8\x2f\x0a\x0c\xed\x7b\xeb\x8e\x08\xa4\x16\x57\xc1"
          "\x6e\xf4\x68\xb2\x28\xa8\x27\x9b\xe3\x31\xa7\x03\xc3\x35\x96\xfd\x15\xc1"
          "\x3b\x1b\x07\xf9\xaa\x1d\x3b\xea\x57\x78\x9c\xa0\x31\xad\x85\xc7\xa7\x1d"
          "\xd7\x03\x54\xec\x63\x12\x38\xca\x34\x45",
          1, 448, NULL, 0 },
        { 0, 160, 16, NULL,
          "\x61\x62\x63\x64\x65\x66\x67\x68\x62\x63\x64\x65\x66\x67\x68\x69\x63\x64"
          "\x65\x66\x67\x68\x69\x6a\x64\x65\x66\x67\x68\x69\x6a\x6b\x65\x66\x67\x68"
          "\x69\x6a\x6b\x6c\x66\x67\x68\x69\x6a\x6b\x6c\x6d\x67\x68\x69\x6a\x6b\x6c"
          "\x6d\x6e\x68\x69\x6a\x6b\x6c\x6d\x6e\x6f\x69\x6a\x6b\x6c\x6d\x6e\x6f\x70"
          "\x6a\x6b\x6c\x6d\x6e\x6f\x70\x71\x6b\x6c\x6d\x6e\x6f\x70\x71\x72\x6c\x6d"
          "\x6e\x6f\x70\x71\x72\x73\x6d\x6e\x6f\x70\x71\x72\x73\x74\x6e\x6f\x70\x71"
          "\x72\x73\x74\x75",
          "\xa4\x9b\x24\x46\xa0\x2c\x64\x5b\xf4\x19\xf9\x95\xb6\x70\x91\x25\x3a\x04"
          "\xa2\x59",
          1, 896, NULL, 0 },
        { 0, 224, 17, NULL,
          "\x61\x62\x63\x64\x65\x66\x67\x68\x62\x63\x64\x65\x66\x67\x68\x69\x63\x64"
          "\x65\x66\x67\x68\x69\x6a\x64\x65\x66\x67\x68\x69\x6a\x6b\x65\x66\x67\x68"
          "\x69\x6a\x6b\x6c\x66\x67\x68\x69\x6a\x6b\x6c\x6d\x67\x68\x69\x6a\x6b\x6c"
          "\x6d\x6e\x68\x69\x6a\x6b\x6c\x6d\x6e\x6f\x69\x6a\x6b\x6c\x6d\x6e\x6f\x70"
          "\x6a\x6b\x6c\x6d\x6e\x6f\x70\x71\x6b\x6c\x6d\x6e\x6f\x70\x71\x72\x6c\x6d"
          "\x6e\x6f\x70\x71\x72\x73\x6d\x6e\x6f\x70\x71\x72\x73\x74\x6e\x6f\x70\x71"
          "\x72\x73\x74\x75",
          "\xc9\x7c\xa9\xa5\x59\x85\x0c\xe9\x7a\x04\xa9\x6d\xef\x6d\x99\xa9\xe0\xe0"
          "\xe2\xab\x14\xe6\xb8\xdf\x26\x5f\xc0\xb3",
          1, 896, NULL, 0 },
        { 0, 256, 18, NULL,
          "\x61\x62\x63\x64\x65\x66\x67\x68\x62\x63\x64\x65\x66\x67\x68\x69\x63\x64"
          "\x65\x66\x67\x68\x69\x6a\x64\x65\x66\x67\x68\x69\x6a\x6b\x65\x66\x67\x68"
          "\x69\x6a\x6b\x6c\x66\x67\x68\x69\x6a\x6b\x6c\x6d\x67\x68\x69\x6a\x6b\x6c"
          "\x6d\x6e\x68\x69\x6a\x6b\x6c\x6d\x6e\x6f\x69\x6a\x6b\x6c\x6d\x6e\x6f\x70"
          "\x6a\x6b\x6c\x6d\x6e\x6f\x70\x71\x6b\x6c\x6d\x6e\x6f\x70\x71\x72\x6c\x6d"
          "\x6e\x6f\x70\x71\x72\x73\x6d\x6e\x6f\x70\x71\x72\x73\x74\x6e\x6f\x70\x71"
          "\x72\x73\x74\x75",
          "\xcf\x5b\x16\xa7\x78\xaf\x83\x80\x03\x6c\xe5\x9e\x7b\x04\x92\x37\x0b\x24"
          "\x9b\x11\xe8\xf0\x7a\x51\xaf\xac\x45\x03\x7a\xfe\xe9\xd1",
          1, 896, NULL, 0 },
        { 0, 384, 19, NULL,
          "\x61\x62\x63\x64\x65\x66\x67\x68\x62\x63\x64\x65\x66\x67\x68\x69\x63\x64"
          "\x65\x66\x67\x68\x69\x6a\x64\x65\x66\x67\x68\x69\x6a\x6b\x65\x66\x67\x68"
          "\x69\x6a\x6b\x6c\x66\x67\x68\x69\x6a\x6b\x6c\x6d\x67\x68\x69\x6a\x6b\x6c"
          "\x6d\x6e\x68\x69\x6a\x6b\x6c\x6d\x6e\x6f\x69\x6a\x6b\x6c\x6d\x6e\x6f\x70"
          "\x6a\x6b\x6c\x6d\x6e\x6f\x70\x71\x6b\x6c\x6d\x6e\x6f\x70\x71\x72\x6c\x6d"
          "\x6e\x6f\x70\x71\x72\x73\x6d\x6e\x6f\x70\x71\x72\x73\x74\x6e\x6f\x70\x71"
          "\x72\x73\x74\x75",
          "\x09\x33\x0c\x33\xf7\x11\x47\xe8\x3d\x19\x2f\xc7\x82\xcd\x1b\x47\x53\x11"
          "\x1b\x17\x3b\x3b\x05\xd2\x2f\xa0\x80\x86\xe3\xb0\xf7\x12\xfc\xc7\xc7\x1a"
          "\x55\x7e\x2d\xb9\x66\xc3\xe9\xfa\x91\x74\x60\x39",
          1, 896, NULL, 0 },
        { 0, 512, 20, NULL,
          "\x61\x62\x63\x64\x65\x66\x67\x68\x62\x63\x64\x65\x66\x67\x68\x69\x63\x64"
          "\x65\x66\x67\x68\x69\x6a\x64\x65\x66\x67\x68\x69\x6a\x6b\x65\x66\x67\x68"
          "\x69\x6a\x6b\x6c\x66\x67\x68\x69\x6a\x6b\x6c\x6d\x67\x68\x69\x6a\x6b\x6c"
          "\x6d\x6e\x68\x69\x6a\x6b\x6c\x6d\x6e\x6f\x69\x6a\x6b\x6c\x6d\x6e\x6f\x70"
          "\x6a\x6b\x6c\x6d\x6e\x6f\x70\x71\x6b\x6c\x6d\x6e\x6f\x70\x71\x72\x6c\x6d"
          "\x6e\x6f\x70\x71\x72\x73\x6d\x6e\x6f\x70\x71\x72\x73\x74\x6e\x6f\x70\x71"
          "\x72\x73\x74\x75",
          "\x8e\x95\x9b\x75\xda\xe3\x13\xda\x8c\xf4\xf7\x28\x14\xfc\x14\x3f\x8f\x77"
          "\x79\xc6\xeb\x9f\x7f\xa1\x72\x99\xae\xad\xb6\x88\x90\x18\x50\x1d\x28\x9e"
          "\x49\x00\xf7\xe4\x33\x1b\x99\xde\xc4\xb5\x43\x3a\xc7\xd3\x29\xee\xb6\xdd"
          "\x26\x54\x5e\x96\xe5\x5b\x87\x4b\xe9\x09",
          1, 896, NULL, 0 },
        { 0, 0, 0, NULL, NULL, NULL, 0, 0, NULL, 0 }
};
