<!--
SPDX-License-Identifier: Apache-2.0
SPDX-FileCopyrightText: Zygmunt Krynicki
-->
# Image Garden

Image garden is a project that aims to provide the following properties together:

## Obtain test images for operating systems

We want to make getting commonly used images easy and accessible. If you can
name it it should be simple to get and run locally on your system. At present
we focus mostly on Linux distributions and their cloud images, but we want to
expose access to installable images, server and desktop alike.

The images we prepare are intended for use in full-system tests. They are not
general-purpose images destined for production workflows. They compromise on
security for ease of use and convenience in testing.

## Use commonly available tools

We want to provide access to all the systems from all the systems, without
requiring distribution-specific tooling to be pre-installed. In practice we
don't want to build images, we want to fetch and run them. Each OS has complex
tooling for building their images that makes this problem more confusing.

## Use simple, insecure access methods

Our images are pre-configured with network, ssh access with simple password
(the distribution name), interactive login on the serial port and anything else
that may be handy for testing.

## Simplicity

You can run `image-garden make -n all` to see the exact commands that are
needed to create and prepare all the images. Each machine image comes with a
script that runs the exact `qemu` incantation required to boot it correctly.
You can use this to learn and copy relevant parts to your own project.

# Usage and examples

All the images can be built with `make`. You will need the following additional
programs: `wget`, `qemu-system-x86_64`, `qemu-system-aarch64`, `qemu-img`,
`genisoimage`, and `mkpasswd` (usually in the `whois` package). You should be
able to install them on your system of choice, even if that's MacOS.

Note that all the targets need to be run as `image-garden make TARGET`.

## fetch

Downloads all the images to the cache structure under
`$XDG_CACHE_HOME/image-garden/dl`.

## all

Builds all the virtual machine images for the same CPU architecture as the
host. Building for cross-CPU architecture may work but is slow and not
recommended.

## clean

Removes all of the images, intermediate images, log files and other support
files without removing the original source images downloaded from the Internet.

## distclean

Like clean, but also removes images downloaded from the Internet. Unless you
need space you should not need to run this target.

# Local cloud-init templates

If the directory where `image-garden` is invoked contains the file
`.image-garden.mk` then that file is loaded by `make` and used as additional
set of build rules.

While somewhat technical this is sufficient to define arbitrary new build
goals, operating systems or initialization logic. At present it is strongly
recommended to constrain oneself to `cloud-init` user-data templates though.

Using this technique well can drastically speed up test iteration, as the
cached image can contain arbitrary customizations that are local to the
project.

There are two forms available, one that is specific to a given operating system
and release, and one that is shared across a family of systems. Both are shown
below:

```make
# This defines the cloud-init profile for Debian 13 (Trixie).
# The definition extends the standard profile provided by image-garden.
define DEBIAN_13_CLOUD_INIT_USER_DATA_TEMPLATE
$(CLOUD_INIT_USER_DATA_TEMPLATE)
packages:
- build-essential
- docker
- virtualbox
- snapd
endef

# This defines the cloud-init profile for all versions of Ubuntu.
# The definition extends the standard profile provided by image-garden.
define UBUNTU_CLOUD_INIT_USER_DATA_TEMPLATE
$(CLOUD_INIT_USER_DATA_TEMPLATE)
packages:
- build-essential
- docker
- virtualbox
- snapd
endef
```
