module Test.Data.Function where

import qualified Data.Function.HT.Private as FuncHT

import Test.QuickCheck (Property, quickCheck, (==>), )


powerAssociative :: Eq a =>
   (a -> a -> a) -> a -> a -> Integer -> Property
powerAssociative op a0 a n =
   n>0 ==>
      FuncHT.powerAssociative op a0 a n == FuncHT.powerAssociative1 op a0 a n


tests :: [(String, IO ())]
tests =
   ("powerAssociative", quickCheck (powerAssociative (+) :: Integer -> Integer -> Integer -> Property)) :
   []
