;;; GnuTLS --- Guile bindings for GnuTLS.
;;; Copyright (C) 2023 Free Software Foundation, Inc.
;;;
;;; This file is part of Guile-GnuTLS.
;;;
;;; This library is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU Lesser General Public
;;; License as published by the Free Software Foundation; either
;;; version 2.1 of the License, or (at your option) any later version.
;;;
;;; This library is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; Lesser General Public License for more details.
;;;
;;; You should have received a copy of the GNU Lesser General Public
;;; License along with this library; if not, see <https://www.gnu.org/licenses/>.

(use-modules (ice-9 receive)
             (rnrs bytevectors)
             (gnutls))

(receive (curve x y k)
    (let ((key (generate-private-key
                pk-algorithm/ecc ecc-curve/secp521r1)))
      (private-key-export-raw-ecc key))
  (write
   `((curve . ,(ecc-curve->string curve))
     (x . ,(base64-encode x))
     (y . ,(base64-encode y))
     (k . ,(base64-encode k))))
  (newline))
