// This file was generated by the Gtk# code generator.
// Any changes made will be lost if regenerated.

namespace Gdk {

	using System;
	using System.Collections;
	using System.Collections.Generic;
	using System.Runtime.InteropServices;

#region Autogenerated code
	public partial class DragContext : GLib.Object {

		public DragContext (IntPtr raw) : base(raw) {}

		protected DragContext() : base(IntPtr.Zero)
		{
			CreateNativeObject (new string [0], new GLib.Value [0]);
		}

		[GLib.Signal("drop-performed")]
		public event Gdk.DropPerformedHandler DropPerformed {
			add {
				this.AddSignalHandler ("drop-performed", value, typeof (Gdk.DropPerformedArgs));
			}
			remove {
				this.RemoveSignalHandler ("drop-performed", value);
			}
		}

		[GLib.Signal("cancel")]
		public event Gdk.CancelHandler Cancel {
			add {
				this.AddSignalHandler ("cancel", value, typeof (Gdk.CancelArgs));
			}
			remove {
				this.RemoveSignalHandler ("cancel", value);
			}
		}

		[GLib.Signal("dnd-finished")]
		public event System.EventHandler DndFinished {
			add {
				this.AddSignalHandler ("dnd-finished", value);
			}
			remove {
				this.RemoveSignalHandler ("dnd-finished", value);
			}
		}

		[GLib.Signal("action-changed")]
		public event Gdk.ActionChangedHandler ActionChanged {
			add {
				this.AddSignalHandler ("action-changed", value, typeof (Gdk.ActionChangedArgs));
			}
			remove {
				this.RemoveSignalHandler ("action-changed", value);
			}
		}

		static FindWindowNativeDelegate FindWindow_cb_delegate;
		static FindWindowNativeDelegate FindWindowVMCallback {
			get {
				if (FindWindow_cb_delegate == null)
					FindWindow_cb_delegate = new FindWindowNativeDelegate (FindWindow_cb);
				return FindWindow_cb_delegate;
			}
		}

		static void OverrideFindWindow (GLib.GType gtype)
		{
			OverrideFindWindow (gtype, FindWindowVMCallback);
		}

		static void OverrideFindWindow (GLib.GType gtype, FindWindowNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("find_window"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate IntPtr FindWindowNativeDelegate (IntPtr inst, IntPtr drag_window, IntPtr screen, int x_root, int y_root, out int protocol);

		static IntPtr FindWindow_cb (IntPtr inst, IntPtr drag_window, IntPtr screen, int x_root, int y_root, out int protocol)
		{
			try {
				DragContext __obj = GLib.Object.GetObject (inst, false) as DragContext;
				Gdk.Window __result;
				Gdk.DragProtocol myprotocol;
				__result = __obj.OnFindWindow (GLib.Object.GetObject(drag_window) as Gdk.Window, GLib.Object.GetObject(screen) as Gdk.Screen, x_root, y_root, out myprotocol);
				protocol = (int) myprotocol;
				return __result == null ? IntPtr.Zero : __result.Handle;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gdk.DragContext), ConnectionMethod="OverrideFindWindow")]
		protected virtual Gdk.Window OnFindWindow (Gdk.Window drag_window, Gdk.Screen screen, int x_root, int y_root, out Gdk.DragProtocol protocol)
		{
			return InternalFindWindow (drag_window, screen, x_root, y_root, out protocol);
		}

		private Gdk.Window InternalFindWindow (Gdk.Window drag_window, Gdk.Screen screen, int x_root, int y_root, out Gdk.DragProtocol protocol)
		{
			FindWindowNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("find_window"));
				unmanaged = (FindWindowNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(FindWindowNativeDelegate));
			}
			if (unmanaged == null) throw new InvalidOperationException ("No base method to invoke");

			int native_protocol;
			IntPtr __result = unmanaged (this.Handle, drag_window == null ? IntPtr.Zero : drag_window.Handle, screen == null ? IntPtr.Zero : screen.Handle, x_root, y_root, out native_protocol);
			protocol = (Gdk.DragProtocol) native_protocol;
			return GLib.Object.GetObject(__result) as Gdk.Window;
		}

		static GetSelectionNativeDelegate GetSelection_cb_delegate;
		static GetSelectionNativeDelegate GetSelectionVMCallback {
			get {
				if (GetSelection_cb_delegate == null)
					GetSelection_cb_delegate = new GetSelectionNativeDelegate (GetSelection_cb);
				return GetSelection_cb_delegate;
			}
		}

		static void OverrideGetSelection (GLib.GType gtype)
		{
			OverrideGetSelection (gtype, GetSelectionVMCallback);
		}

		static void OverrideGetSelection (GLib.GType gtype, GetSelectionNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("get_selection"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate IntPtr GetSelectionNativeDelegate (IntPtr inst);

		static IntPtr GetSelection_cb (IntPtr inst)
		{
			try {
				DragContext __obj = GLib.Object.GetObject (inst, false) as DragContext;
				Gdk.Atom __result;
				__result = __obj.OnGetSelection ();
				return __result == null ? IntPtr.Zero : __result.Handle;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gdk.DragContext), ConnectionMethod="OverrideGetSelection")]
		protected virtual Gdk.Atom OnGetSelection ()
		{
			return InternalGetSelection ();
		}

		private Gdk.Atom InternalGetSelection ()
		{
			GetSelectionNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("get_selection"));
				unmanaged = (GetSelectionNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(GetSelectionNativeDelegate));
			}
			if (unmanaged == null) return null;

			IntPtr __result = unmanaged (this.Handle);
			return __result == IntPtr.Zero ? null : (Gdk.Atom) GLib.Opaque.GetOpaque (__result, typeof (Gdk.Atom), false);
		}

		static DragMotionNativeDelegate DragMotion_cb_delegate;
		static DragMotionNativeDelegate DragMotionVMCallback {
			get {
				if (DragMotion_cb_delegate == null)
					DragMotion_cb_delegate = new DragMotionNativeDelegate (DragMotion_cb);
				return DragMotion_cb_delegate;
			}
		}

		static void OverrideDragMotion (GLib.GType gtype)
		{
			OverrideDragMotion (gtype, DragMotionVMCallback);
		}

		static void OverrideDragMotion (GLib.GType gtype, DragMotionNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("drag_motion"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate bool DragMotionNativeDelegate (IntPtr inst, IntPtr dest_window, int protocol, int root_x, int root_y, int suggested_action, int possible_actions, uint time_);

		static bool DragMotion_cb (IntPtr inst, IntPtr dest_window, int protocol, int root_x, int root_y, int suggested_action, int possible_actions, uint time_)
		{
			try {
				DragContext __obj = GLib.Object.GetObject (inst, false) as DragContext;
				bool __result;
				__result = __obj.OnDragMotion (GLib.Object.GetObject(dest_window) as Gdk.Window, (Gdk.DragProtocol) protocol, root_x, root_y, (Gdk.DragAction) suggested_action, (Gdk.DragAction) possible_actions, time_);
				return __result;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gdk.DragContext), ConnectionMethod="OverrideDragMotion")]
		protected virtual bool OnDragMotion (Gdk.Window dest_window, Gdk.DragProtocol protocol, int root_x, int root_y, Gdk.DragAction suggested_action, Gdk.DragAction possible_actions, uint time_)
		{
			return InternalDragMotion (dest_window, protocol, root_x, root_y, suggested_action, possible_actions, time_);
		}

		private bool InternalDragMotion (Gdk.Window dest_window, Gdk.DragProtocol protocol, int root_x, int root_y, Gdk.DragAction suggested_action, Gdk.DragAction possible_actions, uint time_)
		{
			DragMotionNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("drag_motion"));
				unmanaged = (DragMotionNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(DragMotionNativeDelegate));
			}
			if (unmanaged == null) return false;

			bool __result = unmanaged (this.Handle, dest_window == null ? IntPtr.Zero : dest_window.Handle, (int) protocol, root_x, root_y, (int) suggested_action, (int) possible_actions, time_);
			return __result;
		}

		static DragStatusNativeDelegate DragStatus_cb_delegate;
		static DragStatusNativeDelegate DragStatusVMCallback {
			get {
				if (DragStatus_cb_delegate == null)
					DragStatus_cb_delegate = new DragStatusNativeDelegate (DragStatus_cb);
				return DragStatus_cb_delegate;
			}
		}

		static void OverrideDragStatus (GLib.GType gtype)
		{
			OverrideDragStatus (gtype, DragStatusVMCallback);
		}

		static void OverrideDragStatus (GLib.GType gtype, DragStatusNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("drag_status"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void DragStatusNativeDelegate (IntPtr inst, int action, uint time_);

		static void DragStatus_cb (IntPtr inst, int action, uint time_)
		{
			try {
				DragContext __obj = GLib.Object.GetObject (inst, false) as DragContext;
				__obj.OnDragStatus ((Gdk.DragAction) action, time_);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gdk.DragContext), ConnectionMethod="OverrideDragStatus")]
		protected virtual void OnDragStatus (Gdk.DragAction action, uint time_)
		{
			InternalDragStatus (action, time_);
		}

		private void InternalDragStatus (Gdk.DragAction action, uint time_)
		{
			DragStatusNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("drag_status"));
				unmanaged = (DragStatusNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(DragStatusNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle, (int) action, time_);
		}

		static DragAbortNativeDelegate DragAbort_cb_delegate;
		static DragAbortNativeDelegate DragAbortVMCallback {
			get {
				if (DragAbort_cb_delegate == null)
					DragAbort_cb_delegate = new DragAbortNativeDelegate (DragAbort_cb);
				return DragAbort_cb_delegate;
			}
		}

		static void OverrideDragAbort (GLib.GType gtype)
		{
			OverrideDragAbort (gtype, DragAbortVMCallback);
		}

		static void OverrideDragAbort (GLib.GType gtype, DragAbortNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("drag_abort"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void DragAbortNativeDelegate (IntPtr inst, uint time_);

		static void DragAbort_cb (IntPtr inst, uint time_)
		{
			try {
				DragContext __obj = GLib.Object.GetObject (inst, false) as DragContext;
				__obj.OnDragAbort (time_);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gdk.DragContext), ConnectionMethod="OverrideDragAbort")]
		protected virtual void OnDragAbort (uint time_)
		{
			InternalDragAbort (time_);
		}

		private void InternalDragAbort (uint time_)
		{
			DragAbortNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("drag_abort"));
				unmanaged = (DragAbortNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(DragAbortNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle, time_);
		}

		static DragDropNativeDelegate DragDrop_cb_delegate;
		static DragDropNativeDelegate DragDropVMCallback {
			get {
				if (DragDrop_cb_delegate == null)
					DragDrop_cb_delegate = new DragDropNativeDelegate (DragDrop_cb);
				return DragDrop_cb_delegate;
			}
		}

		static void OverrideDragDrop (GLib.GType gtype)
		{
			OverrideDragDrop (gtype, DragDropVMCallback);
		}

		static void OverrideDragDrop (GLib.GType gtype, DragDropNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("drag_drop"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void DragDropNativeDelegate (IntPtr inst, uint time_);

		static void DragDrop_cb (IntPtr inst, uint time_)
		{
			try {
				DragContext __obj = GLib.Object.GetObject (inst, false) as DragContext;
				__obj.OnDragDrop (time_);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gdk.DragContext), ConnectionMethod="OverrideDragDrop")]
		protected virtual void OnDragDrop (uint time_)
		{
			InternalDragDrop (time_);
		}

		private void InternalDragDrop (uint time_)
		{
			DragDropNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("drag_drop"));
				unmanaged = (DragDropNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(DragDropNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle, time_);
		}

		static DropReplyNativeDelegate DropReply_cb_delegate;
		static DropReplyNativeDelegate DropReplyVMCallback {
			get {
				if (DropReply_cb_delegate == null)
					DropReply_cb_delegate = new DropReplyNativeDelegate (DropReply_cb);
				return DropReply_cb_delegate;
			}
		}

		static void OverrideDropReply (GLib.GType gtype)
		{
			OverrideDropReply (gtype, DropReplyVMCallback);
		}

		static void OverrideDropReply (GLib.GType gtype, DropReplyNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("drop_reply"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void DropReplyNativeDelegate (IntPtr inst, bool accept, uint time_);

		static void DropReply_cb (IntPtr inst, bool accept, uint time_)
		{
			try {
				DragContext __obj = GLib.Object.GetObject (inst, false) as DragContext;
				__obj.OnDropReply (accept, time_);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gdk.DragContext), ConnectionMethod="OverrideDropReply")]
		protected virtual void OnDropReply (bool accept, uint time_)
		{
			InternalDropReply (accept, time_);
		}

		private void InternalDropReply (bool accept, uint time_)
		{
			DropReplyNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("drop_reply"));
				unmanaged = (DropReplyNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(DropReplyNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle, accept, time_);
		}

		static DropFinishNativeDelegate DropFinish_cb_delegate;
		static DropFinishNativeDelegate DropFinishVMCallback {
			get {
				if (DropFinish_cb_delegate == null)
					DropFinish_cb_delegate = new DropFinishNativeDelegate (DropFinish_cb);
				return DropFinish_cb_delegate;
			}
		}

		static void OverrideDropFinish (GLib.GType gtype)
		{
			OverrideDropFinish (gtype, DropFinishVMCallback);
		}

		static void OverrideDropFinish (GLib.GType gtype, DropFinishNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("drop_finish"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void DropFinishNativeDelegate (IntPtr inst, bool success, uint time_);

		static void DropFinish_cb (IntPtr inst, bool success, uint time_)
		{
			try {
				DragContext __obj = GLib.Object.GetObject (inst, false) as DragContext;
				__obj.OnDropFinish (success, time_);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gdk.DragContext), ConnectionMethod="OverrideDropFinish")]
		protected virtual void OnDropFinish (bool success, uint time_)
		{
			InternalDropFinish (success, time_);
		}

		private void InternalDropFinish (bool success, uint time_)
		{
			DropFinishNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("drop_finish"));
				unmanaged = (DropFinishNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(DropFinishNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle, success, time_);
		}

		static DropStatusNativeDelegate DropStatus_cb_delegate;
		static DropStatusNativeDelegate DropStatusVMCallback {
			get {
				if (DropStatus_cb_delegate == null)
					DropStatus_cb_delegate = new DropStatusNativeDelegate (DropStatus_cb);
				return DropStatus_cb_delegate;
			}
		}

		static void OverrideDropStatus (GLib.GType gtype)
		{
			OverrideDropStatus (gtype, DropStatusVMCallback);
		}

		static void OverrideDropStatus (GLib.GType gtype, DropStatusNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("drop_status"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate bool DropStatusNativeDelegate (IntPtr inst);

		static bool DropStatus_cb (IntPtr inst)
		{
			try {
				DragContext __obj = GLib.Object.GetObject (inst, false) as DragContext;
				bool __result;
				__result = __obj.OnDropStatus ();
				return __result;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gdk.DragContext), ConnectionMethod="OverrideDropStatus")]
		protected virtual bool OnDropStatus ()
		{
			return InternalDropStatus ();
		}

		private bool InternalDropStatus ()
		{
			DropStatusNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("drop_status"));
				unmanaged = (DropStatusNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(DropStatusNativeDelegate));
			}
			if (unmanaged == null) return false;

			bool __result = unmanaged (this.Handle);
			return __result;
		}

		static GetDragWindowNativeDelegate GetDragWindow_cb_delegate;
		static GetDragWindowNativeDelegate GetDragWindowVMCallback {
			get {
				if (GetDragWindow_cb_delegate == null)
					GetDragWindow_cb_delegate = new GetDragWindowNativeDelegate (GetDragWindow_cb);
				return GetDragWindow_cb_delegate;
			}
		}

		static void OverrideGetDragWindow (GLib.GType gtype)
		{
			OverrideGetDragWindow (gtype, GetDragWindowVMCallback);
		}

		static void OverrideGetDragWindow (GLib.GType gtype, GetDragWindowNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("get_drag_window"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate IntPtr GetDragWindowNativeDelegate (IntPtr inst);

		static IntPtr GetDragWindow_cb (IntPtr inst)
		{
			try {
				DragContext __obj = GLib.Object.GetObject (inst, false) as DragContext;
				Gdk.Window __result;
				__result = __obj.OnGetDragWindow ();
				return __result == null ? IntPtr.Zero : __result.Handle;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gdk.DragContext), ConnectionMethod="OverrideGetDragWindow")]
		protected virtual Gdk.Window OnGetDragWindow ()
		{
			return InternalGetDragWindow ();
		}

		private Gdk.Window InternalGetDragWindow ()
		{
			GetDragWindowNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("get_drag_window"));
				unmanaged = (GetDragWindowNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(GetDragWindowNativeDelegate));
			}
			if (unmanaged == null) return null;

			IntPtr __result = unmanaged (this.Handle);
			return GLib.Object.GetObject(__result) as Gdk.Window;
		}

		static SetHotspotNativeDelegate SetHotspot_cb_delegate;
		static SetHotspotNativeDelegate SetHotspotVMCallback {
			get {
				if (SetHotspot_cb_delegate == null)
					SetHotspot_cb_delegate = new SetHotspotNativeDelegate (SetHotspot_cb);
				return SetHotspot_cb_delegate;
			}
		}

		static void OverrideSetHotspot (GLib.GType gtype)
		{
			OverrideSetHotspot (gtype, SetHotspotVMCallback);
		}

		static void OverrideSetHotspot (GLib.GType gtype, SetHotspotNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("set_hotspot"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void SetHotspotNativeDelegate (IntPtr inst, int hot_x, int hot_y);

		static void SetHotspot_cb (IntPtr inst, int hot_x, int hot_y)
		{
			try {
				DragContext __obj = GLib.Object.GetObject (inst, false) as DragContext;
				__obj.OnSetHotspot (hot_x, hot_y);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gdk.DragContext), ConnectionMethod="OverrideSetHotspot")]
		protected virtual void OnSetHotspot (int hot_x, int hot_y)
		{
			InternalSetHotspot (hot_x, hot_y);
		}

		private void InternalSetHotspot (int hot_x, int hot_y)
		{
			SetHotspotNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("set_hotspot"));
				unmanaged = (SetHotspotNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(SetHotspotNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle, hot_x, hot_y);
		}

		static DropDoneNativeDelegate DropDone_cb_delegate;
		static DropDoneNativeDelegate DropDoneVMCallback {
			get {
				if (DropDone_cb_delegate == null)
					DropDone_cb_delegate = new DropDoneNativeDelegate (DropDone_cb);
				return DropDone_cb_delegate;
			}
		}

		static void OverrideDropDone (GLib.GType gtype)
		{
			OverrideDropDone (gtype, DropDoneVMCallback);
		}

		static void OverrideDropDone (GLib.GType gtype, DropDoneNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("drop_done"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void DropDoneNativeDelegate (IntPtr inst, bool success);

		static void DropDone_cb (IntPtr inst, bool success)
		{
			try {
				DragContext __obj = GLib.Object.GetObject (inst, false) as DragContext;
				__obj.OnDropDone (success);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gdk.DragContext), ConnectionMethod="OverrideDropDone")]
		protected virtual void OnDropDone (bool success)
		{
			InternalDropDone (success);
		}

		private void InternalDropDone (bool success)
		{
			DropDoneNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("drop_done"));
				unmanaged = (DropDoneNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(DropDoneNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle, success);
		}

		static ManageDndNativeDelegate ManageDnd_cb_delegate;
		static ManageDndNativeDelegate ManageDndVMCallback {
			get {
				if (ManageDnd_cb_delegate == null)
					ManageDnd_cb_delegate = new ManageDndNativeDelegate (ManageDnd_cb);
				return ManageDnd_cb_delegate;
			}
		}

		static void OverrideManageDnd (GLib.GType gtype)
		{
			OverrideManageDnd (gtype, ManageDndVMCallback);
		}

		static void OverrideManageDnd (GLib.GType gtype, ManageDndNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("manage_dnd"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate bool ManageDndNativeDelegate (IntPtr inst, IntPtr ipc_window, int actions);

		static bool ManageDnd_cb (IntPtr inst, IntPtr ipc_window, int actions)
		{
			try {
				DragContext __obj = GLib.Object.GetObject (inst, false) as DragContext;
				bool __result;
				__result = __obj.OnManageDnd (GLib.Object.GetObject(ipc_window) as Gdk.Window, (Gdk.DragAction) actions);
				return __result;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gdk.DragContext), ConnectionMethod="OverrideManageDnd")]
		protected virtual bool OnManageDnd (Gdk.Window ipc_window, Gdk.DragAction actions)
		{
			return InternalManageDnd (ipc_window, actions);
		}

		private bool InternalManageDnd (Gdk.Window ipc_window, Gdk.DragAction actions)
		{
			ManageDndNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("manage_dnd"));
				unmanaged = (ManageDndNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(ManageDndNativeDelegate));
			}
			if (unmanaged == null) return false;

			bool __result = unmanaged (this.Handle, ipc_window == null ? IntPtr.Zero : ipc_window.Handle, (int) actions);
			return __result;
		}

		static SetCursorNativeDelegate SetCursor_cb_delegate;
		static SetCursorNativeDelegate SetCursorVMCallback {
			get {
				if (SetCursor_cb_delegate == null)
					SetCursor_cb_delegate = new SetCursorNativeDelegate (SetCursor_cb);
				return SetCursor_cb_delegate;
			}
		}

		static void OverrideSetCursor (GLib.GType gtype)
		{
			OverrideSetCursor (gtype, SetCursorVMCallback);
		}

		static void OverrideSetCursor (GLib.GType gtype, SetCursorNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("set_cursor"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void SetCursorNativeDelegate (IntPtr inst, IntPtr cursor);

		static void SetCursor_cb (IntPtr inst, IntPtr cursor)
		{
			try {
				DragContext __obj = GLib.Object.GetObject (inst, false) as DragContext;
				__obj.OnSetCursor (GLib.Object.GetObject(cursor) as Gdk.Cursor);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gdk.DragContext), ConnectionMethod="OverrideSetCursor")]
		protected virtual void OnSetCursor (Gdk.Cursor cursor)
		{
			InternalSetCursor (cursor);
		}

		private void InternalSetCursor (Gdk.Cursor cursor)
		{
			SetCursorNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("set_cursor"));
				unmanaged = (SetCursorNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(SetCursorNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle, cursor == null ? IntPtr.Zero : cursor.Handle);
		}

		static CancelNativeDelegate Cancel_cb_delegate;
		static CancelNativeDelegate CancelVMCallback {
			get {
				if (Cancel_cb_delegate == null)
					Cancel_cb_delegate = new CancelNativeDelegate (Cancel_cb);
				return Cancel_cb_delegate;
			}
		}

		static void OverrideCancel (GLib.GType gtype)
		{
			OverrideCancel (gtype, CancelVMCallback);
		}

		static void OverrideCancel (GLib.GType gtype, CancelNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("cancel"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void CancelNativeDelegate (IntPtr inst, int reason);

		static void Cancel_cb (IntPtr inst, int reason)
		{
			try {
				DragContext __obj = GLib.Object.GetObject (inst, false) as DragContext;
				__obj.OnCancel ((Gdk.DragCancelReason) reason);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gdk.DragContext), ConnectionMethod="OverrideCancel")]
		protected virtual void OnCancel (Gdk.DragCancelReason reason)
		{
			InternalCancel (reason);
		}

		private void InternalCancel (Gdk.DragCancelReason reason)
		{
			CancelNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("cancel"));
				unmanaged = (CancelNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(CancelNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle, (int) reason);
		}

		static DropPerformedNativeDelegate DropPerformed_cb_delegate;
		static DropPerformedNativeDelegate DropPerformedVMCallback {
			get {
				if (DropPerformed_cb_delegate == null)
					DropPerformed_cb_delegate = new DropPerformedNativeDelegate (DropPerformed_cb);
				return DropPerformed_cb_delegate;
			}
		}

		static void OverrideDropPerformed (GLib.GType gtype)
		{
			OverrideDropPerformed (gtype, DropPerformedVMCallback);
		}

		static void OverrideDropPerformed (GLib.GType gtype, DropPerformedNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("drop_performed"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void DropPerformedNativeDelegate (IntPtr inst, uint time);

		static void DropPerformed_cb (IntPtr inst, uint time)
		{
			try {
				DragContext __obj = GLib.Object.GetObject (inst, false) as DragContext;
				__obj.OnDropPerformed (time);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gdk.DragContext), ConnectionMethod="OverrideDropPerformed")]
		protected virtual void OnDropPerformed (uint time)
		{
			InternalDropPerformed (time);
		}

		private void InternalDropPerformed (uint time)
		{
			DropPerformedNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("drop_performed"));
				unmanaged = (DropPerformedNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(DropPerformedNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle, time);
		}

		static DndFinishedNativeDelegate DndFinished_cb_delegate;
		static DndFinishedNativeDelegate DndFinishedVMCallback {
			get {
				if (DndFinished_cb_delegate == null)
					DndFinished_cb_delegate = new DndFinishedNativeDelegate (DndFinished_cb);
				return DndFinished_cb_delegate;
			}
		}

		static void OverrideDndFinished (GLib.GType gtype)
		{
			OverrideDndFinished (gtype, DndFinishedVMCallback);
		}

		static void OverrideDndFinished (GLib.GType gtype, DndFinishedNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("dnd_finished"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void DndFinishedNativeDelegate (IntPtr inst);

		static void DndFinished_cb (IntPtr inst)
		{
			try {
				DragContext __obj = GLib.Object.GetObject (inst, false) as DragContext;
				__obj.OnDndFinished ();
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gdk.DragContext), ConnectionMethod="OverrideDndFinished")]
		protected virtual void OnDndFinished ()
		{
			InternalDndFinished ();
		}

		private void InternalDndFinished ()
		{
			DndFinishedNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("dnd_finished"));
				unmanaged = (DndFinishedNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(DndFinishedNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle);
		}

		static HandleEventNativeDelegate HandleEvent_cb_delegate;
		static HandleEventNativeDelegate HandleEventVMCallback {
			get {
				if (HandleEvent_cb_delegate == null)
					HandleEvent_cb_delegate = new HandleEventNativeDelegate (HandleEvent_cb);
				return HandleEvent_cb_delegate;
			}
		}

		static void OverrideHandleEvent (GLib.GType gtype)
		{
			OverrideHandleEvent (gtype, HandleEventVMCallback);
		}

		static void OverrideHandleEvent (GLib.GType gtype, HandleEventNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("handle_event"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate bool HandleEventNativeDelegate (IntPtr inst, IntPtr evnt);

		static bool HandleEvent_cb (IntPtr inst, IntPtr evnt)
		{
			try {
				DragContext __obj = GLib.Object.GetObject (inst, false) as DragContext;
				bool __result;
				__result = __obj.OnHandleEvent (Gdk.Event.GetEvent (evnt));
				return __result;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gdk.DragContext), ConnectionMethod="OverrideHandleEvent")]
		protected virtual bool OnHandleEvent (Gdk.Event evnt)
		{
			return InternalHandleEvent (evnt);
		}

		private bool InternalHandleEvent (Gdk.Event evnt)
		{
			HandleEventNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("handle_event"));
				unmanaged = (HandleEventNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(HandleEventNativeDelegate));
			}
			if (unmanaged == null) return false;

			bool __result = unmanaged (this.Handle, evnt == null ? IntPtr.Zero : evnt.Handle);
			return __result;
		}

		static ActionChangedNativeDelegate ActionChanged_cb_delegate;
		static ActionChangedNativeDelegate ActionChangedVMCallback {
			get {
				if (ActionChanged_cb_delegate == null)
					ActionChanged_cb_delegate = new ActionChangedNativeDelegate (ActionChanged_cb);
				return ActionChanged_cb_delegate;
			}
		}

		static void OverrideActionChanged (GLib.GType gtype)
		{
			OverrideActionChanged (gtype, ActionChangedVMCallback);
		}

		static void OverrideActionChanged (GLib.GType gtype, ActionChangedNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("action_changed"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void ActionChangedNativeDelegate (IntPtr inst, int action);

		static void ActionChanged_cb (IntPtr inst, int action)
		{
			try {
				DragContext __obj = GLib.Object.GetObject (inst, false) as DragContext;
				__obj.OnActionChanged ((Gdk.DragAction) action);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gdk.DragContext), ConnectionMethod="OverrideActionChanged")]
		protected virtual void OnActionChanged (Gdk.DragAction action)
		{
			InternalActionChanged (action);
		}

		private void InternalActionChanged (Gdk.DragAction action)
		{
			ActionChangedNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("action_changed"));
				unmanaged = (ActionChangedNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(ActionChangedNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle, (int) action);
		}

		static CommitDragStatusNativeDelegate CommitDragStatus_cb_delegate;
		static CommitDragStatusNativeDelegate CommitDragStatusVMCallback {
			get {
				if (CommitDragStatus_cb_delegate == null)
					CommitDragStatus_cb_delegate = new CommitDragStatusNativeDelegate (CommitDragStatus_cb);
				return CommitDragStatus_cb_delegate;
			}
		}

		static void OverrideCommitDragStatus (GLib.GType gtype)
		{
			OverrideCommitDragStatus (gtype, CommitDragStatusVMCallback);
		}

		static void OverrideCommitDragStatus (GLib.GType gtype, CommitDragStatusNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("commit_drag_status"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void CommitDragStatusNativeDelegate (IntPtr inst);

		static void CommitDragStatus_cb (IntPtr inst)
		{
			try {
				DragContext __obj = GLib.Object.GetObject (inst, false) as DragContext;
				__obj.OnCommitDragStatus ();
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gdk.DragContext), ConnectionMethod="OverrideCommitDragStatus")]
		protected virtual void OnCommitDragStatus ()
		{
			InternalCommitDragStatus ();
		}

		private void InternalCommitDragStatus ()
		{
			CommitDragStatusNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("commit_drag_status"));
				unmanaged = (CommitDragStatusNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(CommitDragStatusNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle);
		}


		// Internal representation of the wrapped structure ABI.
		static GLib.AbiStruct _class_abi = null;
		static public new GLib.AbiStruct class_abi {
			get {
				if (_class_abi == null)
					_class_abi = new GLib.AbiStruct (new List<GLib.AbiField>{ 
						new GLib.AbiField("find_window"
							, GLib.Object.class_abi.Fields
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // find_window
							, null
							, "get_selection"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("get_selection"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // get_selection
							, "find_window"
							, "drag_motion"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("drag_motion"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // drag_motion
							, "get_selection"
							, "drag_status"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("drag_status"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // drag_status
							, "drag_motion"
							, "drag_abort"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("drag_abort"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // drag_abort
							, "drag_status"
							, "drag_drop"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("drag_drop"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // drag_drop
							, "drag_abort"
							, "drop_reply"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("drop_reply"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // drop_reply
							, "drag_drop"
							, "drop_finish"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("drop_finish"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // drop_finish
							, "drop_reply"
							, "drop_status"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("drop_status"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // drop_status
							, "drop_finish"
							, "get_drag_window"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("get_drag_window"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // get_drag_window
							, "drop_status"
							, "set_hotspot"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("set_hotspot"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // set_hotspot
							, "get_drag_window"
							, "drop_done"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("drop_done"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // drop_done
							, "set_hotspot"
							, "manage_dnd"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("manage_dnd"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // manage_dnd
							, "drop_done"
							, "set_cursor"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("set_cursor"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // set_cursor
							, "manage_dnd"
							, "cancel"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("cancel"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // cancel
							, "set_cursor"
							, "drop_performed"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("drop_performed"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // drop_performed
							, "cancel"
							, "dnd_finished"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("dnd_finished"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // dnd_finished
							, "drop_performed"
							, "handle_event"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("handle_event"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // handle_event
							, "dnd_finished"
							, "action_changed"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("action_changed"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // action_changed
							, "handle_event"
							, "commit_drag_status"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("commit_drag_status"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // commit_drag_status
							, "action_changed"
							, null
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
					});

				return _class_abi;
			}
		}


		// End of the ABI representation.

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gdk_drag_context_get_actions(IntPtr raw);

		public Gdk.DragAction Actions { 
			get {
				int raw_ret = gdk_drag_context_get_actions(Handle);
				Gdk.DragAction ret = (Gdk.DragAction) raw_ret;
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_drag_context_get_dest_window(IntPtr raw);

		public Gdk.Window DestWindow { 
			get {
				IntPtr raw_ret = gdk_drag_context_get_dest_window(Handle);
				Gdk.Window ret = GLib.Object.GetObject(raw_ret) as Gdk.Window;
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_drag_context_get_device(IntPtr raw);

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_drag_context_set_device(IntPtr raw, IntPtr device);

		public Gdk.Device Device { 
			get {
				IntPtr raw_ret = gdk_drag_context_get_device(Handle);
				Gdk.Device ret = GLib.Object.GetObject(raw_ret) as Gdk.Device;
				return ret;
			}
			set {
				gdk_drag_context_set_device(Handle, value == null ? IntPtr.Zero : value.Handle);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_drag_context_get_drag_window(IntPtr raw);

		public Gdk.Window DragWindow { 
			get {
				IntPtr raw_ret = gdk_drag_context_get_drag_window(Handle);
				Gdk.Window ret = GLib.Object.GetObject(raw_ret) as Gdk.Window;
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gdk_drag_context_get_protocol(IntPtr raw);

		public Gdk.DragProtocol Protocol { 
			get {
				int raw_ret = gdk_drag_context_get_protocol(Handle);
				Gdk.DragProtocol ret = (Gdk.DragProtocol) raw_ret;
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gdk_drag_context_get_selected_action(IntPtr raw);

		public Gdk.DragAction SelectedAction { 
			get {
				int raw_ret = gdk_drag_context_get_selected_action(Handle);
				Gdk.DragAction ret = (Gdk.DragAction) raw_ret;
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_drag_context_get_source_window(IntPtr raw);

		public Gdk.Window SourceWindow { 
			get {
				IntPtr raw_ret = gdk_drag_context_get_source_window(Handle);
				Gdk.Window ret = GLib.Object.GetObject(raw_ret) as Gdk.Window;
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gdk_drag_context_get_suggested_action(IntPtr raw);

		public Gdk.DragAction SuggestedAction { 
			get {
				int raw_ret = gdk_drag_context_get_suggested_action(Handle);
				Gdk.DragAction ret = (Gdk.DragAction) raw_ret;
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_drag_context_get_type();

		public static new GLib.GType GType { 
			get {
				IntPtr raw_ret = gdk_drag_context_get_type();
				GLib.GType ret = new GLib.GType(raw_ret);
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_drag_context_list_targets(IntPtr raw);

		public Gdk.Atom[] ListTargets() {
			IntPtr raw_ret = gdk_drag_context_list_targets(Handle);
			Gdk.Atom[] ret = (Gdk.Atom[]) GLib.Marshaller.ListPtrToArray (raw_ret, typeof(GLib.List), false, false, typeof(Gdk.Atom));
			return ret;
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gdk_drag_context_manage_dnd(IntPtr raw, IntPtr ipc_window, int actions);

		public bool ManageDnd(Gdk.Window ipc_window, Gdk.DragAction actions) {
			bool raw_ret = gdk_drag_context_manage_dnd(Handle, ipc_window == null ? IntPtr.Zero : ipc_window.Handle, (int) actions);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_drag_context_set_hotspot(IntPtr raw, int hot_x, int hot_y);

		public void SetHotspot(int hot_x, int hot_y) {
			gdk_drag_context_set_hotspot(Handle, hot_x, hot_y);
		}


		// Internal representation of the wrapped structure ABI.
		static GLib.AbiStruct _abi_info = null;
		static public new GLib.AbiStruct abi_info {
			get {
				if (_abi_info == null)
					_abi_info = new GLib.AbiStruct (GLib.Object.abi_info.Fields);

				return _abi_info;
			}
		}


		// End of the ABI representation.

#endregion
	}
}
