#ifndef __GM_APP_VIEW_H__
#define __GM_APP_VIEW_H__

#include <gtk/gtk.h>
#include <glib.h>
#include <glade/glade.h>
#include "gm-world.h"
#include "gm-world-view.h"
#include "gm-editor-view.h"
#include "gm-app.h"

G_BEGIN_DECLS

/*
 * Type checking and casting macros
 */
#define GM_TYPE_APP_VIEW				(gm_app_view_get_type())
#define GM_APP_VIEW(obj)				(G_TYPE_CHECK_INSTANCE_CAST((obj), GM_TYPE_APP_VIEW, GmAppView))
#define GM_APP_VIEW_CONST(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), GM_TYPE_APP_VIEW, GmAppView const))
#define GM_APP_VIEW_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), GM_TYPE_APP_VIEW, GmAppViewClass))
#define GM_IS_APP_VIEW(obj)				(G_TYPE_CHECK_INSTANCE_TYPE((obj), GM_TYPE_APP_VIEW))
#define GM_IS_APP_VIEW_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE ((klass), GM_TYPE_APP_VIEW))
#define GM_APP_VIEW_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), GM_TYPE_APP_VIEW, GmAppViewClass))

/* Private structure type */
typedef struct _GmAppViewPrivate GmAppViewPrivate;

/*
 * Main object structure
 */
typedef struct _GmAppView GmAppView;
 
struct _GmAppView {
	GtkWindow window;
	
	/*< private > */
	GmAppViewPrivate *priv;
};

/*
 * Class definition
 */
typedef struct _GmAppViewClass 	GmAppViewClass;

struct _GmAppViewClass {
	GtkWindowClass parent_class;

	/* Signals */
	void (* active_world_changed) (GmAppView *view, GmWorldView *world_view);
};

GType gm_app_view_get_type(void) G_GNUC_CONST;
GmAppView *gm_app_view_new(GmApp *application);
GmApp const *gm_app_view_application(GmAppView *view);
GtkNotebook *gm_app_view_notebook(GmAppView *view);
GtkMenuItem *gm_app_view_menu_item(GmAppView *view, gchar const *path);
GtkAction *gm_app_view_action(GmAppView *view, gchar const *path);

GmWorld *gm_app_view_active_world(GmAppView *view);
GmWorldView *gm_app_view_active_world_view(GmAppView *view);
GmEditorView *gm_app_view_active_editor_view(GmAppView *view);

/* Callbacks */
void on_gm_app_view_edit_find(GtkMenuItem * menuitem, GmAppView *view);
void on_gm_app_view_edit_find_next(GtkMenuItem * menuitem, GmAppView *view);
void on_gm_app_view_edit_replace(GtkMenuItem * menuitem, GmAppView *view);

G_END_DECLS

#endif /* __GM_APP_VIEW__ */
