from GlassWindow import GlassWindow
from Observable import Observable
import configvalues as conf
import desktop
import errormessage

import commands
import os
import sys
import gtk



#
# Class for the calendar window.
#
class CalWindow(GlassWindow, Observable):

    # messages to the observers
    OBS_WHEEL = 0
    OBS_CLOSE = 1
    OBS_MOVE = 2
    OBS_MENU = 3
    OBS_CLICK = 4
    

    #
    # Constructor.
    #
    def __init__(self, config):

        # flag indicating whether this window is currently being dragged
        self.__is_dragging = 0
        self.__drag_offset = (0, 0)

        # remember the current window position to detect movements
        self.__position = (0, 0)


    	GlassWindow.__init__(self, gtk.WINDOW_TOPLEVEL)
        import icon; self.set_icon(icon.ICON)
        self.set_title("gDeskCal")
        self.set_decorated(gtk.FALSE)
        self.stick()
        
        self.connect("delete-event", self.__on_close)
        self.connect("scroll-event", self.__on_mouse_wheel)
        self.connect("key-press-event", self.__on_key)
        self.connect("configure-event", self.__on_configure)

        # window moving
        self.connect("button-press-event", self.__on_button_press)
        self.connect("button-release-event", self.__on_button_release)

        self.add_events(gtk.gdk.SCROLL_MASK | gtk.gdk.POINTER_MOTION_MASK |
                        #gtk.gdk.POINTER_MOTION_HINT_MASK |
                        gtk.gdk.BUTTON_PRESS_MASK |
                        gtk.gdk.BUTTON_RELEASE_MASK)

        # layout
        self.__layout = gtk.Fixed()
        self.__layout.show()
        self.add(self.__layout)

        # use gDesklets' EWMH module if available
        try:
            if (not config.get([conf.TEMPORARY, conf.USE_EWMH])):
                raise StandardError
            gdesklets_exe = commands.getoutput("which gdesklets")
            cwd = os.getcwd()
            os.chdir(os.path.dirname(gdesklets_exe))
            link_dest = os.path.dirname(os.readlink(gdesklets_exe))
            gdesklets_home = os.path.abspath(link_dest)
            os.chdir(cwd)
            sys.path.append(os.path.join(gdesklets_home, "utils"))
            import _ewmh
            self.realize()
            gtk.idle_add(_ewmh.set_below, self.window)
            
        except:
            gtk.idle_add(self.set_property, "skip-taskbar-hint", 1)
            gtk.idle_add(self.set_property, "skip-pager-hint", 1)

            # keep window below others
            self.connect("focus-in-event", self.__lower_window)
            self.connect_after("button-press-event", self.__lower_window)



    #
    # Reacts on mouse wheel.
    #
    def __on_mouse_wheel(self, src, event):

        if (event.direction == gtk.gdk.SCROLL_UP): step = -1
        elif (event.direction == gtk.gdk.SCROLL_DOWN): step = 1
        else: step = 0
        self.update_observer(self.OBS_WHEEL, step)



    #
    # Reacts on key presses.
    #
    def __on_key(self, src, event):

        key = gtk.gdk.keyval_name(event.keyval)

        # SPACE updates the background
        if (key == "space"):
            self.update_bg()

        # F10 opens the menu
        elif (key == "F10"):
            self.update_observer(self.OBS_MENU, 0, event.time)



    #
    # Keeps the window below others.
    #
    def __lower_window(self, src, event):

        if (self.window): self.window.lower()
        
        return gtk.TRUE
    

    #
    # Reacts on moving the window.
    #
    def __on_configure(self, src, event):

        pos = self.window.get_origin()
        if (pos != self.__position):
            self.update_observer(self.OBS_MOVE, pos)
            self.__position = pos




    #
    # Reacts on closing the window.
    #
    def __on_close(self, src, event):

        self.update_observer(self.OBS_CLOSE)



    #
    # Reacts on pressing a mouse button.
    #
    def __on_button_press(self, src, event):

        button = event.button
        modifiers = event.state
        if (button == 1):
            x, y = self.get_pointer()
            self.update_observer(self.OBS_CLICK, x, y)

        if (button == 2):
            x, y = self.get_pointer()
            self.__is_dragging = 1
            self.__drag_offset = (x, y)
            self.window.set_cursor(gtk.gdk.Cursor(gtk.gdk.FLEUR))
            gtk.timeout_add(20, self.__on_move)
        



    #
    # Reacts on releasing a mouse button.
    #
    def __on_button_release(self, src, event):

        if (self.__is_dragging):
            self.__is_dragging = 0
            self.window.set_cursor(None)
            self.update_bg()

        elif (event.button == 3):
            self.update_observer(self.OBS_MENU, event.button, event.time)



    #
    # Reacts on moving the mouse pointer.
    #
    def __on_move(self):

        if (self.__is_dragging):
            offx, offy = self.__drag_offset
            winx, winy = self.get_position()
            x, y = self.get_pointer()
            x += winx; y += winy
            self.move(x - offx, y - offy)

            return gtk.TRUE

        else:
            return gtk.FALSE



    #
    # Updates the background.
    #
    def update_bg(self, noscreenshot = 0):

        GlassWindow.update_bg(self, noscreenshot)
        self.stick()
        


    #
    # Puts or moves a child widget at the given position.
    #
    def put(self, widget, x, y):

        if (not widget in self.__layout.get_children()):
            self.__layout.put(widget, x, y)
        else:
            self.__layout.move(widget, x, y)



    #
    # Switches to window move mode.
    #
    def move_window(self):

        x, y = self.get_pointer()
        width, height = self.window.get_size()
        x = max(4, min(x, width - 4))
        y = max(4, min(y, height - 4))
        self.__is_dragging = 1
        self.__drag_offset = (x, y)
        gtk.timeout_add(20, self.__on_move)

        



    #
    # Configures the window.
    #
    def set_config(self, config):

        x = config.get([conf.GEOMETRY, conf.WINDOW, conf.X])
        y = config.get([conf.GEOMETRY, conf.WINDOW, conf.Y])

        width = config.get([conf.SKIN, conf.GEOMETRY, conf.WINDOW, conf.WIDTH])
        height = config.get([conf.SKIN, conf.GEOMETRY, conf.WINDOW,
                             conf.HEIGHT])

        transparency = config.get([conf.TEMPORARY, conf.TRANSPARENCY])

        self.set_transparency_mode(transparency)
        self.show()


        self.move(x, y)
        self.resize(width, height)
        self.set_size_request(width, height)
        
        if (transparency != self.TRANSPARENCY_NONE):
            self.update_bg()
