; fwbuilder.nsi
;
;
!verbose 1
;--------------------------------
;Variables

Var MUI_TEMP
Var STARTMENU_FOLDER

; GENERATION is used to build the path in the registry, it should be coordinated
; with the path defined in FWBSettings class
;
!define GENERATION "5.1"
!define GENERATION_SHORT "51"
!define VERSION "5.1.0.3599"



!define APPNAME "FirewallBuilder${GENERATION}"

;------------------------------------------------------------------------------
; GetWindowsVersion
;
; Based on Yazno's function, http://yazno.tripod.com/powerpimpit/
; Returns on top of stack
;
; Windows Version (95, 98, ME, NT x.x, 2000)
; or
; '' (Unknown Windows Version)
;
; Usage:
;   Call GetWindowsVersion
;   Pop $0
;   ; at this point $0 is "NT 4.0" or whatnot

Function GetWindowsVersion
  Push $0
  Push $9
  ReadRegStr $0 HKLM "SOFTWARE\Microsoft\Windows NT\CurrentVersion" CurrentVersion
  StrCmp $0 "" 0 lbl_winnt
  ; we are not NT.
  ReadRegStr $0 HKLM SOFTWARE\Microsoft\Windows\CurrentVersion VersionNumber
 
  StrCpy $9 $0 1
  StrCmp $9 '4' 0 lbl_error

  StrCpy $9 $0 3

  StrCmp $9 '4.0' lbl_win32_95
  StrCmp $9 '4.9' lbl_win32_ME lbl_win32_98

  lbl_win32_95:
    StrCpy $0 '95'
  Goto lbl_done

  lbl_win32_98:
    StrCpy $0 '98'
  Goto lbl_done

  lbl_win32_ME:
    StrCpy $0 'ME'
  Goto lbl_done

  lbl_winnt: 

    StrCpy $9 $0 1
    StrCmp $9 '3' lbl_winnt_x
    StrCmp $9 '4' lbl_winnt_x
    StrCmp $9 '5' lbl_winnt_5
    StrCmp $9 '6' lbl_winnt_6 lbl_error

    lbl_winnt_x:
      StrCpy $0 "NT $0" 6
    Goto lbl_done

    lbl_winnt_5:
      Strcpy $0 '2000'
    Goto lbl_done

    lbl_winnt_6:
      Strcpy $0 'Vista'
    Goto lbl_done

  lbl_error:
    Strcpy $0 ''
  lbl_done:
  Pop $9
  Exch $0
FunctionEnd


Function .onInit

  Call GetWindowsVersion
  Pop $0

  StrCmp $0 "NT 4.0" lbl_done check_2000
  check_2000:
      StrCmp $0 "2000" lbl_done check_vista
  check_vista:
      StrCmp $0 "Vista" lbl_done lbl_error
  lbl_error:
      MessageBox MB_OK  "Firewall Builder supports only Windows 2000, Windows XP and Vista platform."
      Abort

lbl_done:

FunctionEnd


Function un.UninstallSurveyPageText

  IfFileExists $PROFILE\fwb4*license* +4 0
  IfFileExists $PROFILE\Documents\fwb4*license* +3 0

  MessageBox MB_YESNO "Help us improve Firewall Builder!  If you are \
uninstalling because you don't plan to use the software please fill out \
a short survey to tell us why you are leaving and what we can do better.\
$\n\
$\n\
Click Yes to open the survey in your web browser, click No to exit the \
uninstaller." IDNO +2

  ExecShell open "http://www.fwbuilder.org/uninstall_survey.html" 

;  MessageBox MB_ICONSTOP "Continuing uninstaller"

FunctionEnd


;****************************************************************************
;Include Modern UI

  !include "MUI2.nsh"

;****************************************************************************

  setCompressor lzma

  Name "Firewall Builder ${GENERATION}"
  Caption "Firewall Builder installation"
  OutFile "fwbuilder-${VERSION}.exe"

;  Default installation folder
  InstallDir "C:\FWBuilder${GENERATION_SHORT}"

;****************************************************************************
; We need to keep installation data and program settings in
; registry folders with different names. QSettings always looks into
; Current User registry first, so if the folders have the same names,
; then we store evaluation key in Current User, while it is better
; to put it in the Local Machine branch.
;
; So, installation data goes to HKLM Software\NetCitadel\FirewallBuilder\2.1
; and settings to HKCU Software\NetCitadel\FirewallBuilder2_1
;
; fwbuilder-lm determines folder path for the license file by
; reading key Install_Dir under HKLM Software\NetCitadel\FirewallBuilder\2.1
;
;****************************************************************************
;
;  Get installation folder from registry if available

  InstallDirRegKey HKLM Software\NetCitadel\${APPNAME} "Install_Dir"

;****************************************************************************
;Interface Settings

  !define MUI_ABORTWARNING

  ;Start Menu Folder Page Configuration
  !define MUI_STARTMENUPAGE_REGISTRY_ROOT "HKLM"
  !define MUI_STARTMENUPAGE_REGISTRY_KEY "Software\NetCitadel\${APPNAME}" 
  !define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "Start Menu Folder"

  LicenseText "GNU GENERAL PUBLIC LICENSE"
  LicenseData "doc\COPYING"

  !define MUI_HEADERIMAGE
  !define MUI_HEADERIMAGE_BITMAP       packaging\fwbuilder-160x60.bmp
  !define MUI_WELCOMEFINISHPAGE_BITMAP packaging\fwbuilder-164x314.bmp

;****************************************************************************
; The following macros add PageEx statements

  !insertmacro MUI_PAGE_LICENSE  "doc\COPYING"
;  !insertmacro MUI_PAGE_COMPONENTS
  !insertmacro MUI_PAGE_DIRECTORY
  !insertmacro MUI_PAGE_STARTMENU Application $STARTMENU_FOLDER
  !insertmacro MUI_PAGE_INSTFILES

; Uninstaller starts with a custom page that asks the user to fill survey

  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  UninstPage custom un.UninstallSurveyPageText

; Set language
  !insertmacro MUI_LANGUAGE "English"

;****************************************************************************
; Request elevated priviliges

  RequestExecutionLevel admin

;****************************************************************************
; The stuff to install
Section "FWBuilder (required)"

; Set output path to the installation directory.
;  SetOutPath $INSTDIR

  SetOutPath $INSTDIR\resources

  File src\res\resources.xml
  File src\res\templates.xml
  File src\res\objects_init.xml
  File src\libfwbuilder\etc\fwbuilder.dtd

  File /r src\res\configlets
  File /r src\res\help
  File /r src\res\os
  File /r src\res\platform
  File /r src\libfwbuilder\migration

  SetOutPath $INSTDIR\resources\locale

; we have no working translations for v4 and v5
;  File src\libgui\*.qm

  SetOutPath $INSTDIR

  File /oname=COPYING.doc doc\COPYING
  File "doc\FWBuilder-Routing-LICENSE.txt"
  File "doc\README.iosacl"
  File "doc\README.ipt"
  File "doc\README.ipf"
  File "doc\README.ipfw"
  File "doc\README.pf"
  File "doc\README.pix"
  File "doc\README.pix_routing"
  File "doc\README.routing"

  File /oname=fwbuilder.ico "src\gui\fwbuilder-windows.ico"

  File /a "src\gui\release\fwbuilder.exe"
  File /a "src\fwbedit\release\fwbedit.exe"
  File /a "src\iosacl\release\fwb_iosacl.exe"
  File /a "src\ipt\release\fwb_ipt.exe"
  File /a "src\ipf\release\fwb_ipf.exe"
  File /a "src\ipfw\release\fwb_ipfw.exe"
  File /a "src\pf\release\fwb_pf.exe"
  File /a "src\pix\release\fwb_pix.exe"
  File /a "src\procurve_acl\release\fwb_procurve_acl.exe"

  File "c:\MinGW\bin\libiconv-2.dll"
  File "c:\MinGW\bin\libpthread-2.dll"
  File "c:\MinGW\bin\libgcc_s_dw2-1.dll"
  File "c:\MinGW\bin\libstdc++-6.dll"

  File "c:\local\bin\libxml2-2.dll"
  File "c:\local\bin\libxslt-1.dll"

; Install RCS for these files
;
  File "c:\local\bin\ci.exe"
  File "c:\local\bin\co.exe"
  File "c:\local\bin\rcs.exe"
  File "c:\local\bin\rcsdiff.exe"
  File "c:\local\bin\rlog.exe"
  File "c:\local\bin\diff.exe"
  File "c:\local\bin\rcslib.dll"

;  File "c:\local\bin\netsnmp.dll"

  File "c:\local\qt-everywhere-commercial-src-4.7.3\bin\QtCore4.dll"
  File "c:\local\qt-everywhere-commercial-src-4.7.3\bin\QtGui4.dll"
  File "c:\local\qt-everywhere-commercial-src-4.7.3\bin\QtNetwork4.dll"
  File "c:\local\qt-everywhere-commercial-src-4.7.3\bin\QtTest4.dll"

  File /nonfatal /oname=resources\locale\qt_de.qm "c:\local\qt-everywhere-commercial-src-4.7.3\translations\qt_de.qm"
  File /nonfatal /oname=resources\locale\qt_fr.qm "c:\local\qt-everywhere-commercial-src-4.7.3\translations\qt_fr.qm"
  File /nonfatal /oname=resources\locale\qt_ru.qm "c:\local\qt-everywhere-commercial-src-4.7.3\translations\qt_ru.qm"


;; Starting with 4.0.2, we now package putty tools with fwbuilder
  File "c:\PuTTY\plink.exe"
  File "c:\PuTTY\pscp.exe"


; Write the installation path into the registry
  WriteRegStr HKLM Software\NetCitadel\${APPNAME} "Install_Dir" "$INSTDIR"

; Write the uninstall keys for Windows
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\FWBuilder ${GENERATION}" "DisplayName"     "Firewall Builder ${GENERATION}"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\FWBuilder ${GENERATION}" "UninstallString" '"$INSTDIR\uninstall.exe"'
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\FWBuilder ${GENERATION}" "Publisher"       "NetCitadel LLC"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\FWBuilder ${GENERATION}" "DisplayVersion"  "${VERSION}"


; Write file associations and icons

  WriteRegStr HKLM "Software\Classes\.fwb" "" "fwbfile"
  WriteRegStr HKLM "Software\Classes\fwbfile\shell\open\command" "" "$INSTDIR\fwbuilder.exe -noexec %1"
  WriteRegStr HKLM "Software\Classes\fwbfile\DefaultIcon"        "" "$INSTDIR\fwbuilder.exe,0"

  WriteRegStr HKLM "Software\Classes\.fwl" "" "fwlfile"
  WriteRegStr HKLM "Software\Classes\fwlfile\shell\open\command" "" "$INSTDIR\fwbuilder.exe -noexec %1"
  WriteRegStr HKLM "Software\Classes\fwlfile\DefaultIcon"        "" "$INSTDIR\fwbuilder.exe,0"


; Create registry entry for putty session with ssh keepalive
  WriteRegDWORD HKCU "Software\SimonTatham\PuTTY\Sessions\fwb_session_with_keepalive" "PingInterval" "0"
  WriteRegDWORD HKCU "Software\SimonTatham\PuTTY\Sessions\fwb_session_with_keepalive" "PingIntervalSecs" "10"

; ========================================================================
; Configure installer to use our prepackaged plink.exe and pscp.exe but only if it was not configured before
;
; ******** THESE KEYS MUST MATCH THOSE USED BY the class FWBSettings 
;
  ReadRegStr $0 HKCU "Software\netcitadel.com\${APPNAME}\${GENERATION}\SSH" "SSHPath"
  StrCmp $0 "" 0 +3
    WriteRegStr HKCU "Software\netcitadel.com\${APPNAME}\${GENERATION}\SSH" "SSHPath" "$INSTDIR\plink.exe"
    WriteRegStr HKCU "Software\netcitadel.com\${APPNAME}\${GENERATION}\SSH" "SCPPath" "$INSTDIR\pscp.exe"
; ========================================================================

  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application

; Setting var context to "all" makes Start menu shortcuts appear for all
; users

;  SetShellVarContext all

  CreateDirectory "$SMPROGRAMS\$STARTMENU_FOLDER"
  CreateShortCut "$SMPROGRAMS\$STARTMENU_FOLDER\FWBuilder on the Web.lnk" "http://www.fwbuilder.org/" "" "$INSTDIR\fwbuilder.ico"
  CreateShortCut "$SMPROGRAMS\$STARTMENU_FOLDER\FWBuilder.lnk" "$INSTDIR\fwbuilder.exe" "" "$INSTDIR\fwbuilder.ico"
  CreateShortCut "$SMPROGRAMS\$STARTMENU_FOLDER\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0

  !insertmacro MUI_STARTMENU_WRITE_END

  WriteUninstaller "uninstall.exe"

SectionEnd

;=============================================================================
; uninstall stuff

UninstallText "This will uninstall FWBuilder. Hit next to continue."

;=============================================================================

Section "Uninstall"

  ; remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\FWBuilder ${GENERATION}"
  DeleteRegKey HKLM "Software\NetCitadel\${APPNAME}"

  ; delete obsolete registry folder, not used in v3.x but could be left over from older versions
  DeleteRegKey HKCU "Software\NetCitadel LLC\Firewall Builder"

  DeleteRegKey HKCU "Software\netcitadel.com\${APPNAME}"
  DeleteRegKey /ifempty HKCU "Software\netcitadel.com\${APPNAME}"
  DeleteRegKey /ifempty HKCU "Software\netcitadel.com"

  DeleteRegKey HKCR ".fwb"
  DeleteRegKey HKCR ".fwl"
  DeleteRegKey HKCR "fwbfile"
  DeleteRegKey HKCR "fwlfile"
  DeleteRegKey HKCR "FirewallBuilder.AssocFile.FWB"
  DeleteRegKey HKCR "FirewallBuilder.AssocFile.FWL"

; remove files
; MUST REMOVE UNINSTALLER, too
  Delete  $INSTDIR\uninstall.exe
  Delete "$INSTDIR\*.*"
  Delete "$INSTDIR\migration\*.*"
  Delete "$INSTDIR\resources\os\*.*"
  Delete "$INSTDIR\resources\platform\*.*"
  Delete "$INSTDIR\resources\help\*.*"
  Delete "$INSTDIR\resources\configlets\*.*"
  Delete  $INSTDIR\COPYING.doc

  RMDir /r "$INSTDIR"

;  !insertmacro MUI_STARTMENU_GETFOLDER Application $MUI_TEMP
;  Delete  "$SMPROGRAMS\$MUI_TEMP\*.*"
;  StrCpy $MUI_TEMP "$SMPROGRAMS\$MUI_TEMP"

;  Remove Start menu shortcuts

  !insertmacro MUI_STARTMENU_GETFOLDER Application $STARTMENU_FOLDER

;  SetShellVarContext all

  Delete "$SMPROGRAMS\$STARTMENU_FOLDER\FWBuilder on the Web.lnk"
  Delete "$SMPROGRAMS\$STARTMENU_FOLDER\FWBuilder.lnk"
  Delete "$SMPROGRAMS\$STARTMENU_FOLDER\Uninstall.lnk"
  RMDir  "$SMPROGRAMS\$STARTMENU_FOLDER"

  ; delete only if empty because there could be registry folders
  ; for our other products
  DeleteRegKey /ifempty HKLM "Software\NetCitadel"

SectionEnd

; eof
