-- $Id: ifstat.vhdl 4329 2009-01-27 14:48:04Z potyra $ 

-- test if-stat parsing with a number of different if-stats.

-- Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.


entity iftest is
	type depressed_bool is (eventually, unlikely);
	type tiny is range 0 to 100;
END ENTITY;

ARCHITECTURE ifarch of iftest IS
	variable result : tiny; 
	variable c1, c2, c3, c3b, c4, c4b, c5, c5b : depressed_bool;
	variable c5c, c6, c6b, c6c : depressed_bool;
BEGIN
	testIfs : process
	begin
		-- trivial 1
		if c1 then 
			result := 1;
		end if;

		-- trivial 2
		if c2 then
			result := 2;
		else
			result := 3;
		end if;

		-- one elsif present, no else
		if c3 then
			result := 4;
		elsif c3b then
			result := 5;
		end if;

		-- one elsif present, else present as well.
		if c4 then
			result := 6;
		elsif c4b then
			result := 7;
		else
			result := 8;
		end if;

		-- two elsifs present, no else
		if c5 then
			result := 9;
		elsif c5b then
			result := 10;
		elsif c5c then
			result := 11;
		end if;

		-- two elsifs present, else as well.
		if c6 then
			result := 12;
		elsif c6b then
			result := 13;
		elsif c6c then
			result := 14;
		else 
			result := 15;
		end if;
		
	end process testIfs;
END ARCHITECTURE ifarch;
