/* $Id: Library.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __LIBRARY_HPP_INCLUDED
#define __LIBRARY_HPP_INCLUDED

#include <string>
#include "frontend/ast/SymbolDeclaration.hpp"
#include "frontend/ast/LibUnit.hpp"

namespace ast {

//! a VHDL Design Library
/** This class represents a VHDL design library.
 */
class Library : public SymbolDeclaration {
public:
	//! c'tor
	/** @param libName name of the library
	 */
	Library(
		std::string *libName
		) : 	SymbolDeclaration(libName, 
					Location("library")) {}
	

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		assert(this->name != NULL);
		stream << "LIBRARY " << this->name;
	}


	/** list of LibUnit */
	std::list<LibUnit*> units;
};

}; /* namespace ast */

#endif /* __LIBRARY_HPP_INCLUDED */
