/* -*- Mode: c++ -*- */
/***************************************************************************
 *            powerbutton.cc
 *
 *  Thu Mar 23 12:30:50 CET 2017
 *  Copyright 2017 André Nusser
 *  andre.nusser@googlemail.com
 ****************************************************************************/

/*
 *  This file is part of DrumGizmo.
 *
 *  DrumGizmo is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  DrumGizmo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with DrumGizmo; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 */
#include "powerbutton.h"

#include "painter.h"

namespace GUI
{

PowerButton::PowerButton(Widget* parent) : Toggle(parent)
{
}

void PowerButton::setEnabled(bool enabled)
{
	this->enabled = enabled;

	redraw();
}

void PowerButton::repaintEvent(RepaintEvent* repaintEvent)
{
	Painter p(*this);

	// disabled
	if(!enabled)
	{
		if(clicked)
		{
			p.drawImage(0, 0, disabled_clicked);
		}
		else
		{
			p.drawImage(0, 0, disabled);
		}
		return;
	}

	// enabled and on
	if(state)
	{
		if(clicked)
		{
			p.drawImage(0, 0, on_clicked);
		}
		else
		{
			p.drawImage(0, 0, on);
		}
		return;
	}

	// enabled and off
	if(clicked)
	{
		p.drawImage(0, 0, off_clicked);
	}
	else
	{
		p.drawImage(0, 0, off);
	}
}

} // GUI::
