#! /bin/sh

dbfile=$1
if [ -z "$dbfile" ]; then
    echo "Usage:"
    echo "    initsqlite DBFILENAME"
    exit 1
fi

case $dbfile in
    /*)
        ;;
    *)
        echo "the DBFILENAME must be absolute"
	exit 1
	;;
esac

rm -f $dbfile
sqlite3 $dbfile <<EOF
CREATE TABLE dict (
        key,
        value,
        username DEFAULT "",
        PRIMARY KEY (key, username) ON CONFLICT REPLACE
);
EOF

cat <<EOF
connect = $dbfile

map {
  table = dict
  pattern = shared/\$key
  value_field = value
  username_field = username
  fields {
    key = \$key
  }
}

map {
  table = dict
  pattern = priv/\$key
  value_field = value
  username_field = username
  fields {
    key = \$key
  }
}

EOF
