CREATE TABLE dc_pref (
    pref_id VARCHAR(255) NOT NULL,
    user_id VARCHAR(32),
    pref_ws VARCHAR(32) DEFAULT 'system' NOT NULL,
    pref_value text,
    pref_type VARCHAR(8) DEFAULT 'string' NOT NULL,
    pref_label TEXT,
    ADD CONSTRAINT dc_fk_pref_user FOREIGN KEY (user_id) REFERENCES dc_user(user_id) ON UPDATE CASCADE ON DELETE CASCADE,
    UNIQUE (pref_ws, pref_id, user_id)
);
CREATE TABLE dc_spamrule (
    rule_id bigint NOT NULL,
    blog_id VARCHAR(32),
    rule_type VARCHAR(16) DEFAULT 'word' NOT NULL,
    rule_content VARCHAR(128) NOT NULL,
    CONSTRAINT dc_fk_spamrule_blog FOREIGN KEY (blog_id) REFERENCES dc_blog(blog_id) ON UPDATE CASCADE ON DELETE CASCADE
    PRIMARY KEY (rule_id)
);
UPDATE dc_version SET module = 'core', version = '2.5.0' WHERE module='core';
