<?php

declare(strict_types=1);

namespace Doctrine\Tests\ORM\Functional;

use Doctrine\Tests\Models\EagerFetchedCompositeOneToMany\RootEntity;
use Doctrine\Tests\Models\EagerFetchedCompositeOneToMany\SecondLevel;
use Doctrine\Tests\Models\EagerFetchedCompositeOneToMany\SecondLevelWithoutCompositePrimaryKey;
use Doctrine\Tests\OrmFunctionalTestCase;
use PHPUnit\Framework\Attributes\Group;

final class EagerFetchOneToManyWithCompositeKeyTest extends OrmFunctionalTestCase
{
    #[Group('GH11154')]
    public function testItDoesNotThrowAnExceptionWhenTriggeringALoad(): void
    {
        $this->setUpEntitySchema([RootEntity::class, SecondLevel::class, SecondLevelWithoutCompositePrimaryKey::class]);

        $a1 = new RootEntity(1, 'A');

        $this->_em->persist($a1);
        $this->_em->flush();

        $this->_em->clear();

        self::assertCount(1, $this->_em->getRepository(RootEntity::class)->findAll());
    }
}
