package DhMakeELPA;

use warnings;
use strict;

use base 'Class::Accessor';

__PACKAGE__->mk_accessors( qw( cfg ) );

use DhMakeELPA::Config;

=item run( I<%init> )

Runs DhMakeELPA.

Unless the %init contains an I<cfg> member, constructs and instance of
L<DhMakeELPA::Config> and assigns it to I<$init{cfg}>.

Then determines the dh-make-elpa command requested (via cfg->command),
loads the appropriate I<DhMakeELPA::Command::$command> class,
constructs an instance of it and calls its I<execute> method.

=cut

sub run {
    my ( $class, %c ) = @_;

    unless ( $c{cfg} ) {
        my $cfg = DhMakeELPA::Config->new;
        $cfg->parse_command_line_options;
        $c{cfg} = $cfg;
    }

    my $cmd_mod = $c{cfg}->command;
    $cmd_mod =~ s/-/_/g;
    require "DhMakeELPA/Command/$cmd_mod.pm";

    $cmd_mod =~ s{/}{::}g;
    $cmd_mod = "DhMakeELPA::Command::$cmd_mod";

    my $self = $cmd_mod->new( \%c );

    return $self->execute;
}

1;
