{-# OPTIONS_GHC -fno-warn-orphans #-}
module Darcs.Patch.V1.Show ( showPatch_ ) where

import Prelude ()
import Darcs.Prelude

import Darcs.Patch.Format ( FileNameFormat(..) )
import Darcs.Patch.Prim ( showPrim, PrimPatch )

import Darcs.Patch.V1.Core ( RepoPatchV1(..) )

import Darcs.Util.Printer ( Doc,
                 text, blueText,
                 ($$), (<+>) )

showPatch_ :: PrimPatch prim => RepoPatchV1 prim wA wB -> Doc
showPatch_ (PP p) = showPrim OldFormat p
showPatch_ (Merger _ _ p1 p2) = showMerger "merger" p1 p2
showPatch_ (Regrem _ _ p1 p2) = showMerger "regrem" p1 p2

showMerger :: PrimPatch prim => String -> RepoPatchV1 prim wA wB -> RepoPatchV1 prim wD wE -> Doc
showMerger merger_name p1 p2 =
    blueText merger_name <+> text "0.0" <+> blueText "("
                           $$ showPatch_ p1
                           $$ showPatch_ p2
                           $$ blueText ")"
