#
# Copyright (C) 2005  Robert Collins  <robertc@squid-cache.org>
# 
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os

import config_manager.implementations

fake_builds = []


class FakeVCS(object):
    """A fake vcs implementation used for loopback testing."""

    def __init__(self):
        self.schemes = ["fake"]

    def checkout(self, url, to):
        if url == "fake://not-a-branch.com":
            return False
        if url == "fake://bad_url.com":
            raise config_manager.implementations.UnusableURL(
                "URL %r is unavailable." % url)
        os.mkdir(to)
        fake_builds.append((url, to))
        return True

    def get_test_repo(self):
        return FakeVCSRepo()


class FakeVCSRepo(object):
    """A stub repo for the fake: scheme, tested implicitly by use."""

    def setUp(self):
        """Prepare the repo for use."""

    def tearDown(self):
        """Delete any disk resources used by the repo."""

    def get_branch_url(self):
        return "fake://anarchive@example.com"

    def get_not_branch_url(self):
        return "fake://not-a-branch.com"

    def get_bad_url(self):
        return "fake://bad_url.com"
        

config_manager.implementations.register(FakeVCS())
