package org.apache.commons.javaflow.bytecode.transformation;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.ClassReader;

public abstract class AbstractClassTransformerClassLoader extends ClassLoader {

    private final ResourceTransformer transformer;
    private final String prefix;
    private final ClassLoader classloader;


    public AbstractClassTransformerClassLoader(final String pPrefix, final ResourceTransformer pTransformer) {
        prefix = pPrefix;
        transformer = pTransformer;
        classloader = getClass().getClassLoader();
    }

    protected byte[] transform( final InputStream pClassStream ) throws IOException {
        return transformer.transform(IOUtils.toByteArray(pClassStream));
    }

    public Class loadClass( final String name ) throws ClassNotFoundException {
        if (name.startsWith("org.apache.commons.javaflow.bytecode.transformation.")) {
            //System.err.println("Loading: " + name);
            try {
                final InputStream is = getClass().getResourceAsStream(
                        "/" + name.replace('.', '/') + ".class");
                byte[] bytecode;
                if (name.startsWith("org.apache.commons.javaflow.bytecode.transformation.data.")) {
                    //System.err.println("Instrumenting: " + name);
                    // bytecode = DefaultConstructorDump.dump();
                    bytecode = transform(is);
                    /*
                     * FileOutputStream os = new FileOutputStream(name+".class");
                     * os.write(bytecode); os.flush(); os.close();
                     */
                    // CheckClassAdapter.verify(new ClassReader(bytecode), true);
                } else {
                    ClassReader cr = new ClassReader(is);
                    bytecode = cr.b;
                }
                return super.defineClass(name, bytecode, 0, bytecode.length);
                // } catch( Error ex) {
                // new ClassReader(bytecode).accept(new TraceClassVisitor(new
                // PrintWriter(System.err)), false);
                // throw ex;
            } catch (Throwable ex) {
                System.err.println("Load error: " + ex.toString());
                ex.printStackTrace();
                throw new ClassNotFoundException(name + " " + ex.getMessage(), ex);
            }
        }
        return classloader.loadClass(name);
    }
}
