<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.7                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2017                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2017
 *
 * Generated from xml/schema/CRM/Core/Extension.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:6fdc48310a3cb4c35b5a3fa3a8aca079)
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
/**
 * CRM_Core_DAO_Extension constructor.
 */
class CRM_Core_DAO_Extension extends CRM_Core_DAO {
  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  static $_tableName = 'civicrm_extension';
  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var boolean
   */
  static $_log = false;
  /**
   * Local Extension ID
   *
   * @var int unsigned
   */
  public $id;
  /**
   *
   * @var string
   */
  public $type;
  /**
   * Fully qualified extension name
   *
   * @var string
   */
  public $full_name;
  /**
   * Short name
   *
   * @var string
   */
  public $name;
  /**
   * Short, printable name
   *
   * @var string
   */
  public $label;
  /**
   * Primary PHP file
   *
   * @var string
   */
  public $file;
  /**
   * Revision code of the database schema; the format is module-defined
   *
   * @var string
   */
  public $schema_version;
  /**
   * Is this extension active?
   *
   * @var boolean
   */
  public $is_active;
  /**
   * Class constructor.
   */
  function __construct() {
    $this->__table = 'civicrm_extension';
    parent::__construct();
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = array(
        'id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Extension ID') ,
          'description' => 'Local Extension ID',
          'required' => true,
          'table_name' => 'civicrm_extension',
          'entity' => 'Extension',
          'bao' => 'CRM_Core_BAO_Extension',
          'localizable' => 0,
        ) ,
        'type' => array(
          'name' => 'type',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Type') ,
          'required' => true,
          'maxlength' => 8,
          'size' => CRM_Utils_Type::EIGHT,
          'table_name' => 'civicrm_extension',
          'entity' => 'Extension',
          'bao' => 'CRM_Core_BAO_Extension',
          'localizable' => 0,
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'callback' => 'CRM_Core_SelectValues::getExtensionTypes',
          )
        ) ,
        'full_name' => array(
          'name' => 'full_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Key') ,
          'description' => 'Fully qualified extension name',
          'required' => true,
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_extension',
          'entity' => 'Extension',
          'bao' => 'CRM_Core_BAO_Extension',
          'localizable' => 0,
        ) ,
        'name' => array(
          'name' => 'name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Name') ,
          'description' => 'Short name',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'import' => true,
          'where' => 'civicrm_extension.name',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => true,
          'table_name' => 'civicrm_extension',
          'entity' => 'Extension',
          'bao' => 'CRM_Core_BAO_Extension',
          'localizable' => 0,
        ) ,
        'label' => array(
          'name' => 'label',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Label') ,
          'description' => 'Short, printable name',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'import' => true,
          'where' => 'civicrm_extension.label',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => true,
          'table_name' => 'civicrm_extension',
          'entity' => 'Extension',
          'bao' => 'CRM_Core_BAO_Extension',
          'localizable' => 0,
        ) ,
        'file' => array(
          'name' => 'file',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('File') ,
          'description' => 'Primary PHP file',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'import' => true,
          'where' => 'civicrm_extension.file',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => true,
          'table_name' => 'civicrm_extension',
          'entity' => 'Extension',
          'bao' => 'CRM_Core_BAO_Extension',
          'localizable' => 0,
        ) ,
        'schema_version' => array(
          'name' => 'schema_version',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Schema Version') ,
          'description' => 'Revision code of the database schema; the format is module-defined',
          'maxlength' => 63,
          'size' => CRM_Utils_Type::BIG,
          'import' => true,
          'where' => 'civicrm_extension.schema_version',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => true,
          'table_name' => 'civicrm_extension',
          'entity' => 'Extension',
          'bao' => 'CRM_Core_BAO_Extension',
          'localizable' => 0,
        ) ,
        'is_active' => array(
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Extension is Active?') ,
          'description' => 'Is this extension active?',
          'default' => '1',
          'table_name' => 'civicrm_extension',
          'entity' => 'Extension',
          'bao' => 'CRM_Core_BAO_Extension',
          'localizable' => 0,
        ) ,
      );
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }
  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName() {
    return self::$_tableName;
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog() {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'extension', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'extension', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of indices
   */
  public static function indices($localize = TRUE) {
    $indices = array(
      'UI_extension_full_name' => array(
        'name' => 'UI_extension_full_name',
        'field' => array(
          0 => 'full_name',
        ) ,
        'localizable' => false,
        'unique' => true,
        'sig' => 'civicrm_extension::1::full_name',
      ) ,
      'UI_extension_name' => array(
        'name' => 'UI_extension_name',
        'field' => array(
          0 => 'name',
        ) ,
        'localizable' => false,
        'sig' => 'civicrm_extension::0::name',
      ) ,
    );
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }
}
