# Generated by binpac_quickstart

# Analyzer for Secure Shell
#  - ssh-protocol.pac: describes the SSH protocol messages
#  - ssh-analyzer.pac: describes the SSH analyzer code

%include binpac.pac
%include bro.pac

%extern{
	#include "types.bif.h"
	#include "events.bif.h"
%}

analyzer SSH withcontext {
	connection: SSH_Conn;
	flow:       SSH_Flow;
};

# Our connection consists of two flows, one in each direction.
connection SSH_Conn(bro_analyzer: BroAnalyzer) {
	upflow   = SSH_Flow(true);
	downflow = SSH_Flow(false);
};

%include ssh-protocol.pac

# Now we define the flow:
flow SSH_Flow(is_orig: bool) {
	flowunit = SSH_PDU(is_orig) withcontext(connection, this);
};

%include ssh-analyzer.pac