/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.jsnappy;

import de.jarnbjo.jsnappy.Buffer;
import java.util.Arrays;

class TableBasedCompressor {
    public static final int DEFAULT_MAX_OFFSET = 65536;

    TableBasedCompressor() {
    }

    static Buffer compress(byte[] in, int offset, int length, Buffer out) {
        int i;
        if (out == null) {
            out = new Buffer(length * 6 / 5);
        } else {
            out.ensureCapacity(length * 6 / 5);
        }
        byte[] target = out.getData();
        int targetIndex = 0;
        int lasthit = offset;
        for (int l = length; l > 0; l >>= 7) {
            target[targetIndex++] = l >= 128 ? (byte)(0x80 | l & 0x7F) : (byte)l;
        }
        int[] ilhm = new int[length / 5];
        Arrays.fill(ilhm, -1);
        for (i = offset; i + 4 < length && i < offset + 4; ++i) {
            ilhm[TableBasedCompressor.toInt((byte[])in, (int)i) % ilhm.length] = i;
        }
        for (i = offset + 4; i < offset + length; ++i) {
            Hit h = TableBasedCompressor.search(in, i, length, ilhm);
            if (i + 4 < offset + length) {
                ilhm[TableBasedCompressor.toInt((byte[])in, (int)i) % ilhm.length] = i;
            }
            if (h != null) {
                if (lasthit < i) {
                    int len = i - lasthit - 1;
                    if (len < 60) {
                        target[targetIndex++] = (byte)(len << 2);
                    } else if (len < 256) {
                        target[targetIndex++] = -16;
                        target[targetIndex++] = (byte)len;
                    } else if (len < 65536) {
                        target[targetIndex++] = -12;
                        target[targetIndex++] = (byte)len;
                        target[targetIndex++] = (byte)(len >> 8);
                    } else if (len < 0x1000000) {
                        target[targetIndex++] = -8;
                        target[targetIndex++] = (byte)len;
                        target[targetIndex++] = (byte)(len >> 8);
                        target[targetIndex++] = (byte)(len >> 16);
                    } else {
                        target[targetIndex++] = -4;
                        target[targetIndex++] = (byte)len;
                        target[targetIndex++] = (byte)(len >> 8);
                        target[targetIndex++] = (byte)(len >> 16);
                        target[targetIndex++] = (byte)(len >> 24);
                    }
                    System.arraycopy(in, lasthit, target, targetIndex, i - lasthit);
                    targetIndex += i - lasthit;
                    lasthit = i;
                }
                if (h.length <= 11 && h.offset < 2048) {
                    target[targetIndex] = 1;
                    int n = targetIndex;
                    target[n] = (byte)(target[n] | h.length - 4 << 2);
                    int n2 = targetIndex++;
                    target[n2] = (byte)(target[n2] | h.offset >> 3 & 0xE0);
                    target[targetIndex++] = (byte)(h.offset & 0xFF);
                } else if (h.offset < 65536) {
                    target[targetIndex] = 2;
                    int n = targetIndex++;
                    target[n] = (byte)(target[n] | h.length - 1 << 2);
                    target[targetIndex++] = (byte)h.offset;
                    target[targetIndex++] = (byte)(h.offset >> 8);
                } else {
                    target[targetIndex] = 3;
                    int n = targetIndex++;
                    target[n] = (byte)(target[n] | h.length - 1 << 2);
                    target[targetIndex++] = (byte)h.offset;
                    target[targetIndex++] = (byte)(h.offset >> 8);
                    target[targetIndex++] = (byte)(h.offset >> 16);
                    target[targetIndex++] = (byte)(h.offset >> 24);
                }
                while (i < lasthit) {
                    if (i + 4 < in.length) {
                        ilhm[TableBasedCompressor.toInt((byte[])in, (int)i) % ilhm.length] = i;
                    }
                    ++i;
                }
                lasthit = i + h.length;
                while (i < lasthit - 1) {
                    if (i + 4 < in.length) {
                        ilhm[TableBasedCompressor.toInt((byte[])in, (int)i) % ilhm.length] = i;
                    }
                    ++i;
                }
                continue;
            }
            if (i + 4 >= length) continue;
            ilhm[TableBasedCompressor.toInt((byte[])in, (int)i) % ilhm.length] = i;
        }
        if (lasthit < offset + length) {
            int len = offset + length - lasthit - 1;
            if (len < 60) {
                target[targetIndex++] = (byte)(len << 2);
            } else if (len < 256) {
                target[targetIndex++] = -16;
                target[targetIndex++] = (byte)len;
            } else if (len < 65536) {
                target[targetIndex++] = -12;
                target[targetIndex++] = (byte)len;
                target[targetIndex++] = (byte)(len >> 8);
            } else if (len < 0x1000000) {
                target[targetIndex++] = -8;
                target[targetIndex++] = (byte)len;
                target[targetIndex++] = (byte)(len >> 8);
                target[targetIndex++] = (byte)(len >> 16);
            } else {
                target[targetIndex++] = -4;
                target[targetIndex++] = (byte)len;
                target[targetIndex++] = (byte)(len >> 8);
                target[targetIndex++] = (byte)(len >> 16);
                target[targetIndex++] = (byte)(len >> 24);
            }
            System.arraycopy(in, lasthit, target, targetIndex, length - lasthit);
            targetIndex += length - lasthit;
        }
        out.setLength(targetIndex);
        return out;
    }

    private static Hit search(byte[] source, int index, int length, int[] ilhm) {
        if (index + 4 >= length) {
            return null;
        }
        if (index > 0 && source[index] == source[index - 1] && source[index] == source[index + 1] && source[index] == source[index + 2] && source[index] == source[index + 3]) {
            int len = 0;
            for (int i = index; len < 64 && i < length && source[index] == source[i]; ++i, ++len) {
            }
            return new Hit(1, len);
        }
        int fp = ilhm[TableBasedCompressor.toInt(source, index) % ilhm.length];
        if (fp < 0) {
            return null;
        }
        int offset = index - fp;
        if (offset < 4) {
            return null;
        }
        int l = 0;
        int o = fp;
        for (int io = index; io < length && source[o] == source[io] && o < index && l < 64; ++l, ++o, ++io) {
        }
        return l >= 4 ? new Hit(offset, l) : null;
    }

    private static int toInt(byte[] data, int offset) {
        return ((data[offset] & 0xFF) << 24 | (data[offset + 1] & 0xFF) << 16 | (data[offset + 2] & 0xFF) << 8 | data[offset + 3] & 0xFF) & Integer.MAX_VALUE;
    }

    private static class Hit {
        int offset;
        int length;

        Hit(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }
    }
}

