#ifndef XCTYPE_H_DEFINED_
#define XCTYPE_H_DEFINED_

#ifdef HAVE_CTYPE_H
#include <ctype.h>
#else
#endif

/* We need the isxxx() functions/macros from <ctype.h> to work
correctly for 8-bit characters, but regrettably, those in many C
implementations fail to do so if char is a signed data type, and the
character is out of the range 0..127.  If your compiler lacks an
unsigned char data type, then you will have to change (unsigned
char)(c) to (int)(0xff & (unsigned int)(c)).  With this change, it is
important that none of these be invoked with c == EOF. */

#define Isalnum(c)	isalnum((unsigned char)(c))
#define Isalpha(c)	isalpha((unsigned char)(c))
#define Isdigit(c)	isdigit((unsigned char)(c))
#define Isgraph(c)	isgraph((unsigned char)(c))
#define Islower(c)	islower((unsigned char)(c))
#define Isprint(c)	isprint((unsigned char)(c))
#define Isspace(c)	isspace((unsigned char)(c))
#define Isupper(c)	isupper((unsigned char)(c))

#endif /* XCTYPE_H_DEFINED_ */
