open Printf
open Tyxml.Html

let page ~title ~subtitle ~headers ~body ~footer =
  let headers =
    (meta
      ~a:[a_charset "utf-8"]
      ())
    ::
    (link ~rel:[`Stylesheet] ~href:"media/revamp.css" ())
    ::
    (link ~rel:[`Stylesheet] ~href:"media/styles.css" ())
    ::
    headers in
  html ~a:[a_xmlns `W3_org_1999_xhtml]
    (head
       (Tyxml.Html.title (txt title))
       headers
    )
    (Tyxml.Html.body ~a:[a_class ["debian"]] [
      h1 ~a:[a_id "title"] [txt "Ubuntu Release Management"];
      h2 ~a:[a_id "subtitle"] subtitle;
      div ~a:[a_id "body"] body;
      div ~a:[a_id "footer"] footer
    ])

open Ben.Template

let () =
  Ben_frontends.Templates.register_template {
    name = "Ubuntu";
    page;
    intro = [];
    pts = (fun ~src -> sprintf "https://launchpad.net/ubuntu/+source/%s" src);
    changelog = (fun ~letter ~src ~ver -> sprintf "https://changelogs.ubuntu.com/changelogs/%s/%s_%s/changelog" letter src ver);
    buildd = (fun ~src ~ver -> sprintf "https://launchpad.net/ubuntu/+source/%s/%s" src ver);
    buildds = (fun ~srcs -> None);
    bugs = (fun ~src -> sprintf "https://bugs.launchpad.net/ubuntu/+source/%s" src);
    critical_bugs = (fun ~srcs -> None);
    msg_id = (fun ~mid -> sprintf "http://mid.gmane.org/%s" mid);
  }
