#!/usr/bin/python

#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
# 
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

#  Copyright (c) 2007,2008 Ezequiel Vera

#------------------------------------------------------------------------------
#  Nombre: auth2db.py
#  Autor: Ezequiel Vera (ezequielvera@yahoo.com.ar)
#  Ult. Modificacion: 17/04/2008
#  Description: Parsea los archivos auth en busca de logins (smb,ssh,su,login,gdm)
#               y lo pasa a una base de datos mysql que permite listar y ordenar 
#               los resultados.
#------------------------------------------------------------------------------

# Author: Ezequiel Vera
# 
# $Revision$

__author__ = "Ezequiel Vera"
__version__ = "$Revision$"
__date__ = "$Date$"
__copyright__ = "Copyright (c) 2007,2008 Ezequiel Vera"
__license__ = "GPL"

from distutils.core import setup
#from common.version import version
from os.path import isfile, join, isdir
from sys import argv
from glob import glob
import os

longdesc = '''
Auth2db parses auth files and inserts details about logins into a MySQL database.
It allows you to display in the shell or in a Web front-end the date and time, IP, 
username and service (ssh, smb, login, su, gdm, etc.) for each login.'''

setup(
	name = "auth2db", 
	version = "0.2.3", 
	description = "Auth2db parses auth files and inserts details about logins into a MySQL database", 
	long_description = longdesc, 
	author = "Ezequiel Vera", 
	author_email = "ezequielvera@yahoo.com.ar", 
	url = "http://www.auth2db.com.ar", 
	license = "GPL", 
	platforms = "Posix", 
	scripts =	[
					'auth2db', 
					'auth2db-view', 
					'auth2db-config',
					'auth2db-alert'
				], 
	packages =	[
					'modules'
				], 
	data_files =	[
						('/etc/auth2db', 
							glob("config/*.conf")
						), 
						('/var/lib/auth2db/tmp', 
							glob("config/tmp/auth2db_sshd.log")
						),
						('/var/lib/auth2db/flag.d', 
							glob("config/flag.d/flag.dat")
						),
                    				('/etc/auth2db/error.d', 
							glob("config/error.d/error.log")
						), 
						('/usr/share/doc/auth2db/www', 
							glob("www/*")
						),
						('/usr/share/doc/auth2db/sql', 
							glob("setup/*.sql")
						),
                    				('/usr/share/doc/auth2db', 
                        				["CHANGELOG","README","TODO","LICENSE"]
						),
						('/etc/init.d', 
                        				["daemon/auth2db-daemon"]
						)
					]
)

# tmp folder
#os.system("mkdir /var/lib/auth2db/tmp")
# daemon permission
#os.system("/etc/init.d/auth2db-daemon stop")
os.system("chmod 755 /etc/init.d/auth2db-daemon")
# Remove
#os.system("update-rc.d -f auth2db-daemon remove")
#os.system("update-rc.d auth2db-daemon defaults")

# Update config file
if argv[1] == "install":
	print
	print "Please do not forget to update your configuration files."
	print "They are in /etc/auth2db/."
	print "Execute 'auth2db-config' to config server and clients machines."
	print "Start auth2db daemon with '/etc/init.d/auth2db-daemon start'"
	print

